
package WSNotification::Elements::Subscribe;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://docs.oasis-open.org/wsn/b-2' }

__PACKAGE__->__set_name('Subscribe');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ConsumerReference_of :ATTR(:get<ConsumerReference>);
my %Filter_of :ATTR(:get<Filter>);
my %InitialTerminationTime_of :ATTR(:get<InitialTerminationTime>);
my %SubscriptionPolicy_of :ATTR(:get<SubscriptionPolicy>);

__PACKAGE__->_factory(
    [ qw(        ConsumerReference
        Filter
        InitialTerminationTime
        SubscriptionPolicy

    ) ],
    {
        'ConsumerReference' => \%ConsumerReference_of,
        'Filter' => \%Filter_of,
        'InitialTerminationTime' => \%InitialTerminationTime_of,
        'SubscriptionPolicy' => \%SubscriptionPolicy_of,
    },
    {
        'ConsumerReference' => 'WSNotification::Types::EndpointReferenceType',
        'Filter' => 'WSNotification::Types::FilterType',
        'InitialTerminationTime' => 'WSNotification::Types::AbsoluteOrRelativeTimeType',

        'SubscriptionPolicy' => 'WSNotification::Elements::Subscribe::_SubscriptionPolicy',
    },
    {

        'ConsumerReference' => 'ConsumerReference',
        'Filter' => 'Filter',
        'InitialTerminationTime' => 'InitialTerminationTime',
        'SubscriptionPolicy' => 'SubscriptionPolicy',
    }
);

} # end BLOCK




package WSNotification::Elements::Subscribe::_SubscriptionPolicy;
use strict;
use warnings;
{
our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables


__PACKAGE__->_factory(
    [ qw(
    ) ],
    {
    },
    {
    },
    {

    }
);

} # end BLOCK







}






} # end of BLOCK



1;


=pod

=head1 NAME

WSNotification::Elements::Subscribe

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
Subscribe from the namespace http://docs.oasis-open.org/wsn/b-2.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ConsumerReference

 $element->set_ConsumerReference($data);
 $element->get_ConsumerReference();




=item * Filter

 $element->set_Filter($data);
 $element->get_Filter();




=item * InitialTerminationTime

 $element->set_InitialTerminationTime($data);
 $element->get_InitialTerminationTime();




=item * SubscriptionPolicy

 $element->set_SubscriptionPolicy($data);
 $element->get_SubscriptionPolicy();





=back


=head1 METHODS

=head2 new

 my $element = WSNotification::Elements::Subscribe->new($data);

Constructor. The following data structure may be passed to new():

 {
   ConsumerReference =>  { # WSNotification::Types::EndpointReferenceType
     Address =>  { value => $some_value },
     ReferenceParameters =>  { # WSNotification::Types::ReferenceParametersType
     },
     Metadata =>  { # WSNotification::Types::MetadataType
     },
   },
   Filter =>  { # WSNotification::Types::FilterType
     TopicExpression =>  { # WSNotification::Types::TopicExpressionType
     },
     MessageContent =>  { # WSNotification::Types::QueryExpressionType
     },
   },
   InitialTerminationTime => $some_value, # AbsoluteOrRelativeTimeType
   SubscriptionPolicy =>  {
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

