/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef SYSDBUSREGISTER_H
#define SYSDBUSREGISTER_H

#include <QObject>
#include <QCoreApplication>
#include <QProcess>
#include <QFile>
#include <QDir>
#include <QSettings>
#include <QDBusMessage>
#include <QtDBus/QDBusInterface>
#include <QDBusConnection>
#include <QDBusReply>
#include <QDBusUnixFileDescriptor>

#include "dev-power-control/devpowercontrol.h"
#include "brightness-control/brightnessnode.h"
#include "powerconfig.h"



#define DEFAULE_BRIGHTNESS_PERCNET      66

class SysdbusRegister : public QObject
{
    Q_OBJECT

    Q_CLASSINFO("D-Bus Interface", "org.ukui.powermanagement.interface")

public:
    explicit SysdbusRegister();

    ~SysdbusRegister();

private:
    int m_cpuCoreNum;
    PowerConfig *m_powerConfig;
    QStringList m_cpuFreqMode = {"performance", "powersave", "powersave"};
    BrightnessNode *m_brightnessNode;
    DevPowerControl *m_devPowerControl;
    QSettings *m_susThenHibSet;

    QMap<QString, bool> m_userMap;
    QDBusUnixFileDescriptor m_login1Lock;
    bool m_blockLidAction = false;

    void getCpuInfo();
    void controlLogin1Connection(QString);
    void blockLidAction();
    void releaseLidAction();
    QString canControl(const QString);
    QString executeLinuxCmd(QString);

    enum policy
    {
        Performance = 0,
        Balance,
        EnergySaving,
    };

public slots:

    Q_SCRIPTABLE void UserLogin(const QString);
    Q_SCRIPTABLE void UserLogout(const QString);
    Q_SCRIPTABLE void UserActive(const QString);
    Q_SCRIPTABLE bool CanSetBrightness();
    Q_SCRIPTABLE void SetBrightnessPercent(const int);
    Q_SCRIPTABLE int GetBrightnessPercent();
    Q_SCRIPTABLE int GetMaxBrightness();
    Q_SCRIPTABLE void SetReduceBacklightSwitch(const bool);

    Q_SCRIPTABLE void SetPcPolicy(const int);
    Q_SCRIPTABLE void SetCpuPolicy(const int);
    Q_SCRIPTABLE void SetGpuPolicy(const int);
    Q_SCRIPTABLE void SetAudioPolicy(const int);
    Q_SCRIPTABLE void SetAspmPolicy(const int);

    Q_SCRIPTABLE void LockScreen();
    Q_SCRIPTABLE void PowerOff();
    Q_SCRIPTABLE void Suspend();
    Q_SCRIPTABLE void Hibernate();
    Q_SCRIPTABLE void SuspendThenHibernate();

    Q_SCRIPTABLE void SetSystemConfig(const QString, const QString, const QString);

    Q_SCRIPTABLE QString GetSystemConfig(const QString);

signals:
    Q_SCRIPTABLE void SystemConfigChanged(const QString, const QString, const QString);
    Q_SCRIPTABLE void ActiveUserChanged(const QString);
};

#endif // SYSDBUSREGISTER_H
