# 2023-08-29 Triage Log

A fairly quiet week, with improvements exceeding a small scattering of
regressions. Memory usage and artifact size held fairly steady across the week,
with no regressions or improvements.

Triage done by **@simulacrum**.
Revision range: [d4a881e1433cd10e424843353e1f939f5a798f4e..cedbe5c715c1fa9359683c5f108bed2054ac258b](https://perf.rust-lang.org/?start=d4a881e1433cd10e424843353e1f939f5a798f4e&end=cedbe5c715c1fa9359683c5f108bed2054ac258b&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.6%  | [0.3%, 2.2%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.8%, 1.9%]   | 19    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-8.0%, -0.3%] | 70    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-4.2%, -0.2%] | 56    |
| All ❌✅ (primary)                 | -0.8% | [-8.0%, 2.2%]  | 76    |


2 Regressions, 3 Improvements, 2 Mixed; 0 of them in rollups
108 artifact comparisons made in total

#### Regressions

rustdoc: Add lint `redundant_explicit_links` [#113167](https://github.com/rust-lang/rust/pull/113167) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f32ced648191cc67efdf6001585687ad22ed00d2&end=9c699a40cc2680b876c32ee69b402ee34bf7989a&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.4%, 0.9%] | 7     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.4%, 0.9%] | 7     |

Small regression in libc compilation, primarily incremental non-doc scenarios.
Unclear cause but sufficiently limited in scope that further investigation is
not warranted.

Fix races conditions with `SyntaxContext` decoding [#115082](https://github.com/rust-lang/rust/pull/115082) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=aa5dbee3ebff8703456e8be3b5fb368fc68fe0d1&end=b60e31b673b0d36c50f8e0a3b6f8f077221d983d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.3%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.3%, 0.4%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.3%] | 4     |

Some small regressions, but this is a correctness fix for parallel compilation
so warranted. (Parallel compilation is not on here but the fix affects both
non-parallel and parallel scenarios).

#### Improvements

Speed up compilation of `type-system-chess` [#114611](https://github.com/rust-lang/rust/pull/114611) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fe3eae3f310b2f709aa5b39d76a94fc1ea843854&end=a1e1dba9cc40a90409bccb8b19e359c4bdf573e5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-1.7%, -1.7%] | 1     |
| Improvements ✅ <br /> (secondary) | -2.2% | [-4.2%, -0.7%] | 28    |
| All ❌✅ (primary)                 | -1.7% | [-1.7%, -1.7%] | 1     |

> Perf results look good, various small improvements in secondary benchmarks.
> The real driver was the type-system-chess program I mentioned above, where
> the walltime and max-rss changes were both about -85% when I measured them
> locally.

(https://github.com/rust-lang/rust/pull/114611#issuecomment-1670713067)

Add MIR validation for unwind out from nounwind functions + fixes to make validation pass [#113124](https://github.com/rust-lang/rust/pull/113124) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b6ab01a7131481b52131a9bd814dc8084052f643&end=ff55fa30267d7963146c52026b4f4f5396484675&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.1%, -0.5%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.2%] | 3     |
| All ❌✅ (primary)                 | -0.7% | [-1.1%, -0.5%] | 6     |


Update x64 Linux host compiler to LLVM 17 [#114297](https://github.com/rust-lang/rust/pull/114297) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9bd60a60cefdddca1f507083dda37e1664b295c5&end=0b31792ef1c15538b07c7b83585dc2fb371c239f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.0%, -0.2%] | 41    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.5%, -0.2%] | 22    |
| All ❌✅ (primary)                 | -0.6% | [-1.0%, -0.2%] | 41    |


#### Mixed

Remove references in VarDebugInfo [#114904](https://github.com/rust-lang/rust/pull/114904) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=07688726805d5db0a4bca445a6651d09708041ea&end=ccc3ac0cae0d901a360c4f93f6d41d87ed459d20&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.3%, 1.3%]   | 10    |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [1.3%, 1.4%]   | 4     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-7.3%, -0.3%] | 32    |
| Improvements ✅ <br /> (secondary) | -2.1% | [-2.4%, -1.6%] | 4     |
| All ❌✅ (primary)                 | -0.6% | [-7.3%, 1.3%]  | 42    |

Fixed a bug in codegen. The regressions appear to be within noise range for the
relevant benchmarks.

Add a new helper to avoid calling io::Error::kind [#115228](https://github.com/rust-lang/rust/pull/115228) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c5035271acc7e140893c1dcdb5a83bf4ddf04593&end=9334ec93541fd6963a3bfa2d2d09e3e33ac93131&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.8%, -0.5%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-0.8%, 0.3%]  | 4     |

Regression is within noise range of the relevant benchmark.
