/*!
Functions that create IRIs for the Dublin Core [DCMI Terms](http://purl.org/dc/terms/) namespace.

Retrieved from `https://www.dublincore.org/specifications/dublin-core/dcmi-terms/dublin_core_terms.nt`.
*/

namespace! {
    "dcterms",
    "http://purl.org/dc/terms/",
    {
        agent, "Agent",
        agent_class, "AgentClass",
        bibliographic_resource, "BibliographicResource",
        a_box, "Box",
        dcmi_type, "DCMIType",
        ddc_classify, "DDC",
        file_format, "FileFormat",
        frequency, "Frequency",
        imt_classify, "IMT",
        iso_3166, "ISO3166",
        iso_639_2, "ISO639-2",
        iso_639_3, "ISO639-3",
        jurisdiction, "Jurisdiction",
        lcc_classify, "LCC",
        lcsh_classify, "LCSH",
        license_document, "LicenseDocument",
        linguistic_system, "LinguisticSystem",
        location, "Location",
        location_period_or_jurisdiction, "LocationPeriodOrJurisdiction",
        mesh_classify, "MESH",
        media_type, "MediaType",
        media_type_or_extent, "MediaTypeOrExtent",
        method_of_accrual, "MethodOfAccrual",
        method_of_instruction, "MethodOfInstruction",
        nlm_classify, "NLM",
        period, "Period",
        period_of_time, "PeriodOfTime",
        physical_medium, "PhysicalMedium",
        physical_resource, "PhysicalResource",
        point, "Point",
        policy, "Policy",
        rfc_1766, "RFC1766",
        rfc_3066, "RFC3066",
        rfc_4646, "RFC4646",
        rfc_5646, "RFC5646",
        rights_statement, "RightsStatement",
        size_or_duration, "SizeOrDuration",
        standard, "Standard",
        tgn_classify, "TGN",
        udc_classify, "UDC",
        uri, "URI",
        w3c_dtf, "W3CDTF",

        an_abstract, "abstract",
        access_rights, "accessRights",
        accrual_method, "accrualMethod",
        accrual_periodicity, "accrualPeriodicity",
        accrual_policy, "accrualPolicy",
        alternative, "alternative",
        audience, "audience",
        available, "available",
        bibliographic_citation, "bibliographicCitation",
        conforms_to, "conformsTo",
        contributor, "contributor",
        coverage, "coverage",
        created, "created",
        creator, "creator",
        date, "date",
        date_accepted, "dateAccepted",
        date_copyrighted, "dateCopyrighted",
        date_submitted, "dateSubmitted",
        description, "description",
        education_level, "educationLevel",
        extent, "extent",
        format, "format",
        has_format, "hasFormat",
        has_part, "hasPart",
        has_version, "hasVersion",
        identifier, "identifier",
        instructional_method, "instructionalMethod",
        is_format_of, "isFormatOf",
        is_part_of, "isPartOf",
        is_referenced_by, "isReferencedBy",
        is_replaced_by, "isReplacedBy",
        is_required_by, "isRequiredBy",
        is_version_of, "isVersionOf",
        issued, "issued",
        language, "language",
        license, "license",
        mediator, "mediator",
        medium, "medium",
        modified, "modified",
        provenance, "provenance",
        publisher, "publisher",
        references, "references",
        relation, "relation",
        replaces, "replaces",
        requires, "requires",
        rights, "rights",
        rights_holder, "rightsHolder",
        source, "source",
        spatial, "spatial",
        subject, "subject",
        temporal, "temporal",
        title, "title",
        a_type, "type",
        valid, "valid"
    }
}
