// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Cascade.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class Cascade : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Cascade:1.0.0", null);

    public Cascade(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Cascade(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Cascade StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Cascade(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class Info : ICloneable {
      public object Clone() {
        Info copy = new Info();
        copy.pduIds = this.pduIds;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["pduIds"] = new JsonArray(this.pduIds.Select(
          _value => (JsonValue)(_value)));
        return json;
      }

      public static Info Decode(LightJson.JsonObject json, Agent agent) {
        Info inst = new Info();
        inst.pduIds = new System.Collections.Generic.List<int>(json["pduIds"].AsJsonArray.Select(
          _value => (int)_value));
        return inst;
      }

      public System.Collections.Generic.IEnumerable<int> pduIds = new System.Collections.Generic.List<int>();
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.pdumodel.Cascade.Info _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Cascade.Info.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Cascade.Info.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
