This release introduces new features, changes to RabbitMQ distribution (e.g. what plugins ship
with it), and bug fixes. It also includes all the changes from the [3.6.x release series](https://www.rabbitmq.com/changelog.html) unless stated otherwise.

Documentation for this release is available at [the RabbitMQ website](https://www.rabbitmq.com).


## Breaking Changes

 * Minimum required Erlang/OTP version is now 19.3. Recent Erlang versions can be obtained from [Erlang Solutions](https://www.erlang-solutions.com/resources/download.html), [RabbitMQ zero dependency Erlang RPM](https://github.com/rabbitmq/erlang-rpm), as well as main and backports repositories of recent Ubuntu and Debian releases.

   GitHub issues: [rabbitmq-server#1305](https://github.com/rabbitmq/rabbitmq-server/issues/1305), [rabbitmq-server#1307](https://github.com/rabbitmq/rabbitmq-server/issues/1307), [rabbitmq-common#234](https://github.com/rabbitmq/rabbitmq-common/pull/234).

 * HTTP API has minor breaking changes in several endpoints (see below).

 * .NET client is now [.NET Core-compatible](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/148).
   Starting with `3.7.0`, [.NET client releases](https://github.com/rabbitmq/rabbitmq-dotnet-client/releases) are decoupled from RabbitMQ server releases and exclusively distributed via the [RabbitMQ.Client NuGet package](https://www.nuget.org/packages/RabbitMQ.Client/).

 * Starting with `3.7.0`, [Java client releases](https://github.com/rabbitmq/rabbitmq-java-client/releases) are decoupled from RabbitMQ server releases and exclusively distributed via Maven: [RabbitMQ Milestones Maven repository](https://bintray.com/rabbitmq/maven-milestones), [RabbitMQ Maven repository](https://bintray.com/rabbitmq/maven), as well as Maven Central.

 * Users tagged with `administrator` now implicitly have access to most operations in all vhosts,
   including those they don't have explicit permissions for.

   GitHub issue: [rabbitmq-management#461](https://github.com/rabbitmq/rabbitmq-management/issues/461)

 * Plugins now must depend on the `rabbit` application [in order to be recognised as such by `rabbitmq-plugins list`](https://github.com/rabbitmq/rabbitmq-server/issues/1124).
   Plugins that do not have the dependency will still function, can be enabled or disabled but won't appear
   in `rabbitmq-plugins list` output.

 * `rabbitmq_management_visualiser` plugin [no longer ships with RabbitMQ](https://groups.google.com/forum/#!searchin/rabbitmq-users/ANN$20rabbitmq_management_visualiser%7Csort:relevance/rabbitmq-users/WiHmPcmzNtI/YJ356EW4BAAJ) and is considered to be deprecated. Installations that have this plugin enabled **must disable it before upgrading**. This can
    be done using `rabbitmq-plugins disable` (which supports offline modifications)
    or by updating the list of plugins in `RABBITMQ_ENABLED_PLUGINS_FILE`.


### Erlang/OTP 20 Support

Erlang/OTP 20 has [breaking changes](https://groups.google.com/d/msg/rabbitmq-users/_imbAavBYjY/xHzMiGgMAgAJ) that affected RabbitMQ.

3.7.0 supports OTP 20, including upgrades of existing installations to OTP 20. This required changes to the core and multiple plugins that ship with RabbitMQ.

GitHub issues: [rabbitmq-server#1243](https://github.com/rabbitmq/rabbitmq-server/issues/1243), [rabbitmq-server#1250](https://github.com/rabbitmq/rabbitmq-server/pull/1250), [rabbitmq-server#1268](https://github.com/rabbitmq/rabbitmq-server/pull/1268),
	       [rabbitmq-server#1272](https://github.com/rabbitmq/rabbitmq-server/issues/1272), [rabbitmq-federation#58](https://github.com/rabbitmq/rabbitmq-federation/pull/58), [rabbitmq-management-agent#47](https://github.com/rabbitmq/rabbitmq-management-agent/pull/47),
	       [rabbitmq-management#415](https://github.com/rabbitmq/rabbitmq-management/pull/415), [rabbitmq-stomp#115](https://github.com/rabbitmq/rabbitmq-stomp/issues/115)


### Core Server

#### Enhancements

 * New configuration file format

   RabbitMQ now supports a [new configuration file format](http://next.rabbitmq.com/configure.html#config-file).
   The format is [based on sysctl](https://github.com/basho/cuttlefish/wiki/Cuttlefish-for-Application-Users)
   and is similar to `.ini` files. Erlang term configuration files are still supported, it is also
   possible to combine the two formats (use both `rabbitmq.conf` and `advanced.config`).

   Most documentation examples were updated to use both new and classic config formats. See the docs
   at [next.rabbitmq.com](http://next.rabbitmq.com), in particular [the configuration guide](http://next.rabbitmq.com/configure.html),
   for more information.

   GitHub issues: [rabbitmq-server#550](https://github.com/rabbitmq/rabbitmq-server/issues/550),
   		  [rabbitmq-server#1103](https://github.com/rabbitmq/rabbitmq-server/pull/1103),
                  [rabbitmq-auth-backend-ldap#59](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/59)

 * Pluggable cluster peer discovery

   Automatic clustering for blank (without an existing database) nodes now can discover
   peers using pluggable backends. This is a set of features adopted from the [rabbitmq-autocluster](https://github.com/rabbitmq/rabbitmq-autocluster/) plugin by Gavin Roy.
   Two implementations are available out of the box: one uses a config file- and another DNS A records.
   Several more are available via plugins:

    * [AWS](https://github.com/rabbitmq/rabbitmq-peer-discovery-aws)
    * [Consul](https://github.com/rabbitmq/rabbitmq-peer-discovery-consul)
    * [etcd](https://github.com/rabbitmq/rabbitmq-peer-discovery-etcd)
    * [Kubernetes](https://github.com/rabbitmq/rabbitmq-peer-discovery-k8s)

   GitHub issues: [rabbitmq-server#486](https://github.com/rabbitmq/rabbitmq-server/issues/486), [rabbitmq-server#988](https://github.com/rabbitmq/rabbitmq-server/issues/988), [rabbitmq-server#1143](https://github.com/rabbitmq/rabbitmq-server/issues/1143)
		  [rabbitmq-server#1202](https://github.com/rabbitmq/rabbitmq-server/issues/1202), [rabbitmq-server#1171](https://github.com/rabbitmq/rabbitmq-server/issues/1171), [rabbitmq-server#1257](https://github.com/rabbitmq/rabbitmq-server/issues/1257), [rabbitmq-server#1247](https://github.com/rabbitmq/rabbitmq-server/issues/1247)

 * Nodes in a cluster now can be restared in arbitrary order. They will attempt to contact
   one of the previously seen peers periodically (10 times with 30 second intervals by default).

   GitHub issue: [rabbitmq-server#1022](https://github.com/rabbitmq/rabbitmq-server/issues/1022),
                 [rabbitmq-server#487](https://github.com/rabbitmq/rabbitmq-server/issues/487)

 * Every virtual host now has separate message stores.
   This improves resiliency and reduces contention in multitenant environments,
   plus makes development of tools that perform backups and recovery of resting data easier
   in the future.

   During the upgrade nodes will migrate data to this new layout. This can take some time.
   To reduce the amount of time, drain as many queues as possible before upgrading, e.g.
   by stopping publishers without stopping consumers for a period of time.

   GitHub issues: [rabbitmq-server#567](https://github.com/rabbitmq/rabbitmq-server/issues/567), [rabbitmq-server#1146](https://github.com/rabbitmq/rabbitmq-server/issues/1146), [rabbitmq-server#1280](https://github.com/rabbitmq/rabbitmq-server/issues/1280),
		  [rabbitmq-management#446](https://github.com/rabbitmq/rabbitmq-management/issues/446), [rabbitmq-server#1303](https://github.com/rabbitmq/rabbitmq-server/issues/1303), [rabbitmq-management#460](https://github.com/rabbitmq/rabbitmq-management/issues/460), [rabbitmq-server#1321](https://github.com/rabbitmq/rabbitmq-server/issues/1321)

 * New [LevelDB-based message store index plugin](https://github.com/rabbitmq/rabbitmq-msg-store-index-eleveldb).

   GitHub issue: [rabbitmq-server#838](https://github.com/rabbitmq/rabbitmq-server/issues/838)

 * Support config file path values with and without file extensions

   RabbitMQ no longer *requires* `RABBITMQ_CONFIG_FILE` values to not have a `.config` or `.conf` suffix. It will try appending both suffixes as needed when searching for suitable config file(s) to load.

   GitHub Issue: [rabbitmq-server#691](https://github.com/rabbitmq/rabbitmq-server/issues/691)

 * Operators now can configure how many concurrent connections are allowed in a vhost.

   GitHub issue: [rabbitmq-server#500](https://github.com/rabbitmq/rabbitmq-server/issues/500)

 * Operators now can configure how many queues can exist in a vhost.

   GitHub issue: [rabbitmq-server#501](https://github.com/rabbitmq/rabbitmq-server/issues/501)

 * Operator policies: their definitions are merged with the standard (user) policies and allow operators put global
   limits in place, e.g. max queue length or message TTL.

   GitHub issue: [rabbitmq-server#930](https://github.com/rabbitmq/rabbitmq-server/issues/930)

 * It is now possible to configure a limited [prefetch value](https://www.rabbitmq.com/confirms.html) for all newly opened channels by default.
   This helps prevent consumers that never acknowledge deliveries from exhausting server resources.
   It is important to make sure that consumers that use [manual acknowledgements](https://www.rabbitmq.com/confirms.html) can cope with this
   change before enabling it.

   GitHub issue: [rabbitmq-server#1367](https://github.com/rabbitmq/rabbitmq-server/issues/1367)

 * Plugin version constraints

   RabbitMQ now has a mechanism for plugin authors to indicate what versions a plugin is compatible with.
   Incompatible plugins are logged and ignored.

   GitHub issues: [rabbitmq-server#591](https://github.com/rabbitmq/rabbitmq-server/issues/591), [rabbitmq-server#735](https://github.com/rabbitmq/rabbitmq-server/issues/735), [rabbitmq-server#1090](https://github.com/rabbitmq/rabbitmq-server/issues/1090)

 * Lager-based logging: less [not prone to overload](https://s3.us-east-2.amazonaws.com/ferd.erlang-in-anger/text.v1.1.0.pdf), pluggable backends, debug log level, more flexibility in configuration.

   RabbitMQ now uses [Lager](https://github.com/basho/lager) for its logging subsystem.
   This brings a group of benefits: (quite verbose) debug log level, pluggable logging
   backends (will require Lager plugins), and much
   more flexibility in logging configuration.

   See [RabbitMQ 3.7.0 logging guide](http://next.rabbitmq.com/logging.html), [rabbitmq.conf.example](https://github.com/rabbitmq/rabbitmq-server/blob/master/docs/rabbitmq.conf.example) (new style config)
   and [rabbitmq.config.example](https://github.com/rabbitmq/rabbitmq-server/blob/v3.7.x/docs/rabbitmq.config.example) (classic/advanced config format) to learn more.

   GitHub issues: [rabbitmq-server#94](https://github.com/rabbitmq/rabbitmq-server/issues/94), [rabbitmq-website#418](https://github.com/rabbitmq/rabbitmq-website/issues/418)

 * Topic authorisation built around topic exchanges. This includes support for certain variables,
   such as virtual host and username.

   GitHub issues: [rabbitmq-server#505](https://github.com/rabbitmq/rabbitmq-server/issues/505), [rabbitmq-server#1085](https://github.com/rabbitmq/rabbitmq-server/issues/1085), [rabbitmq-server#1099](https://github.com/rabbitmq/rabbitmq-server/issues/1099), [rabbitmq-server#1229](https://github.com/rabbitmq/rabbitmq-server/issues/1229)

 * When queue length limit is exceeded, publishers of messages that did not fit
   now can opt-in to receive a nack by opting in (configuring an overflow behavior).
   When the behavior is configured to reject, messages are also discarded more efficiently.

   GitHub issue: [rabbitmq-server#995](https://github.com/rabbitmq/rabbitmq-server/issues/995)

 * [Proxy Protocol](http://www.haproxy.org/download/1.8/doc/proxy-protocol.txt) support.

   GitHub issue: [rabbitmq-server#589](https://github.com/rabbitmq/rabbitmq-server/issues/589)

 * Deleting a vhost now will force close all connections in it.

   GitHub issue: [rabbitmq-server#627](https://github.com/rabbitmq/rabbitmq-server/issues/627)

 * Deleting a user account now will force close all of its connections.

   GitHub issue: [rabbitmq-server#628](https://github.com/rabbitmq/rabbitmq-server/issues/628)

 * OpenSUSE RPM package now supports systemd and requires Leap 42.2.

   GitHub issue: [rabbitmq-server-release#31](https://github.com/rabbitmq/rabbitmq-server-release/pull/31)

 * Standalone MacOS release now bundles Erlang 19.x.

   GitHub issue: [rabbitmq-server-release#10](https://github.com/rabbitmq/rabbitmq-server-release/issues/10)

 * First dead-lettering event now injects a separate set of top-level headers — `x-first-death-queue`, `x-first-death-reason`,
   and `x-first-death-exchange` — in addition to the `x-deaths` entries.

   GitHub issue: [rabbitmq-server#1332](https://github.com/rabbitmq/rabbitmq-server/issues/1332)

 * LF and CR are now stripped off of names of queues and exchanges

   Although line feeds in names are permitted under the AMQP 0-9-1 spec,
   in practice they can make it very difficult to work with queues and exchanges.
   Stripping them out makes life much easier for developers.

   GitHub issue: [rabbitmq-server#710](https://github.com/rabbitmq/rabbitmq-server/issues/710)

 * Deletion of auto-delete and exclusive queues now leaves (debug) log entries

   GitHub issue: [rabbitmq-server#590](https://github.com/rabbitmq/rabbitmq-server/issues/590)

 * `rabbitmqctl set_vm_high_watermark` now produces more useful error messages when
    relative values provided are outside of the `0..1.0` range.

    GitHub issue: [rabbitmq-cli#157](https://github.com/rabbitmq/rabbitmq-cli/issues/157)

#### Bug Fixes

 * Mirrored queue could terminate if a policy is re-applied concurrently after promotion

   GitHub issue: [rabbitmq-server#803](https://github.com/rabbitmq/rabbitmq-server/issues/803)

 * Old incarnations of queue mirrors are stopped before new ones start

   GitHub issue: [rabbitmq-server#863](https://github.com/rabbitmq/rabbitmq-server/issues/863)

 * Channel interceptors are enabled/disabled together with plugins

   GitHub issue: [rabbitmq-server#559](https://github.com/rabbitmq/rabbitmq-server/issues/559)


### CLI Tools

CLI tools were [significatnly redesigned](https://groups.google.com/forum/#!searchin/rabbitmq-users/ANN$20New$20CLI$20tools%7Csort:relevance/rabbitmq-users/x0XugmBt-IE/t2wdjIdSBgAJ),
now can be extended from plugins and support command
aliases (à la Git). There's also a new tool, `rabbitmq-diagnostics`, and several new commands available.

GitHub issues: [rabbitmq-server#577](https://github.com/rabbitmq/rabbitmq-server/issues/577), [rabbitmq-cli#38](https://github.com/rabbitmq/rabbitmq-cli/issues/38), [rabbitmq-server#1085](https://github.com/rabbitmq/rabbitmq-server/issues/1085),
		  [rabbitmq-cli#10](https://github.com/rabbitmq/rabbitmq-cli/issues/10), [rabbitmq-cli#178](https://github.com/rabbitmq/rabbitmq-cli/issues/178), [rabbitmq-cli#180](https://github.com/rabbitmq/rabbitmq-cli/issues/180).

#### Enhancements

 * New CLI command for closing connections in bulk (e.g. a specific vhost).

   GitHub issue: [rabbitmq-server#849](https://github.com/rabbitmq/rabbitmq-server/issues/849)

 * New CLI command for detecting potentially stuck
   processes (previously invoked as `rabbit_diagnostics:maybe_stuck/0` via `rabbitmqctl eval`).

   GitHub issue: [rabbitmq-cli#144](https://github.com/rabbitmq/rabbitmq-cli/issues/144)

 * New CLI command that lists non-AMQP connections (e.g. MQTT).

   GitHub issue: [rabbitmq-cli#121](https://github.com/rabbitmq/rabbitmq-cli/issues/121)

 * New CLI command that outputs effective Erlang cookie hash.

   GitHub issue: [rabbitmq-cli#151](https://github.com/rabbitmq/rabbitmq-cli/issues/151)

 * `rabbitmq-plugins list` will now only recognise Erlang applications that depend on
   `rabbit` as plugins. Plugins that lacks the dependency will still function and
   can be enabled or disabled but won't be listed.

   GitHub issue: [rabbitmq-server#1124](https://github.com/rabbitmq/rabbitmq-server/issues/1124)



### Management plugin

#### Enhancements

 * Statistics database is now distributed across the cluster: each nodes stores its own stats.

   GitHub issue: [rabbitmq-management#236](https://github.com/rabbitmq/rabbitmq-management/issues/236)

* Migration to Cowboy REST

   RabbitMQ management plugin as well as its extensions (e.g. those of
   Federation and Shovel, `rabbitmq-top`) now uses [Cowboy REST](http://ninenines.eu/docs/en/cowboy/HEAD/guide/rest_handlers/)
   instead of Webmachine. Cowboy is a state-of-the-art open source Erlang HTTP 1.1 server and REST micro framework
   that is also used in the plugins that provide WebSocket support.

   The change is largely invisible to management UI and HTTP API
   clients but there are minor changes that can affect test suites: for example,
   `POST` and `PUT` responses now use `201 Created` instead of `204 No Content`.

   Plugins that extend management UI need to be ported to Cowboy REST and Cowboy 2.

   GitHub issue: [rabbitmq-management#63](https://github.com/rabbitmq/rabbitmq-management/issues/63)

 * Users tagged with `administrator` now implicitly have access to most operations in all vhosts,
   including those they don't have explicit permissions for.

   GitHub issue: [rabbitmq-management#461](https://github.com/rabbitmq/rabbitmq-management/issues/461)

 * User that creates a vhost is automatically granted full permissions in it. This is a usability
   improvement to the management UI. Note that this assumes that a user that has the permissions to create
   vhosts also has the permission to grant themselves permissions to any vhost, so this changes nothing in
   terms of security.

   GitHub issue: [rabbitmq-management#445](https://github.com/rabbitmq/rabbitmq-management/issues/445)

 * New HTTP API endpoint allows for bulk deletion of users.

   GitHub issue: [rabbitmq-management#448](https://github.com/rabbitmq/rabbitmq-management/issues/448)

 * Node endpoint now returns more information about [memory use breakdown](http://next.rabbitmq.com/memory-use.html).
   This is **breaking change**.

   GitHub issue: [rabbitmq-management#499](https://github.com/rabbitmq/rabbitmq-management/issues/499)

 * Report more TLS-related values via HTTP API

	The HTTP API now reports all SSL/TLS options available for the RabbitMQ server as well as for the management plugin.

	GitHub issue: [rabbitmq-management#163](https://github.com/rabbitmq/rabbitmq-management/issues/163)

 * Topic authorisation permission management.

   GitHub issue: [rabbitmq-management#405](https://github.com/rabbitmq/rabbitmq-management/issues/405)

 * Dual IP Stack Support

   Management plugin now can be configured to use IPv6 or both IPv6 and IPv4.

   GitHub issue: [rabbitmq-management#64](https://github.com/rabbitmq/rabbitmq-management/issues/64)

 * "Get messages" in the UI now offers more requeueing options. This is a **breaking change** for HTTP API
    clients as the list of accepted `ackmode` field values has [changed](https://rawcdn.githack.com/rabbitmq/rabbitmq-management/v3.7.0/priv/www/api/index.html).

   GitHub issue: [rabbitmq-management#68](https://github.com/rabbitmq/rabbitmq-management/issues/68)


### Java client

These release notes are for the 4.0 release. Please see [Java client release notes](https://github.com/rabbitmq/rabbitmq-java-client/releases)
for information about later releases.

#### Enhancements

 * Bump default TLS version to v1.2 with a fallback for older JDKs

   The Java client now attempts to use TLS v1.2 by default (which many RabbitMQ servers prefer due to vulnerabilities in TLS v1)
   but falls back to TLS v1 for older JDKs such as JDK 6.

   GitHub issue: [rabbitmq-java-client#139](https://github.com/rabbitmq/rabbitmq-java-client/issues/139)

 * Begin recovery after all shutdown listeners have been given a chance to run

   GitHub issue: [rabbitmq-java-client#135](https://github.com/rabbitmq/rabbitmq-java-client/issues/135)

 * `com.rabbitmq.client.Connection` and `com.rabbitmq.client.Channel` now implement `java.io.Closeable`

   GitHub issue: [rabbitmq-java-client#131](https://github.com/rabbitmq/rabbitmq-java-client/issues/131)


### .NET Client

These release notes are for the 4.0 release. Please see [.NET client release notes](https://github.com/rabbitmq/rabbitmq-dotnet-client/releases)
for information about later releases.

#### Enhancements

 * .NET Core support (as of .NET client `4.0.0`).

   GitHub issues: [rabbitmq-dotnet-client#148](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/148), [rabbitmq-dotnet-client#213](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/213), [rabbitmq-dotnet-client#206](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/206)

 * AppVeyor CI and NuGet feed of Nightly Builds

   GitHub issue: [rabbitmq-dotnet-client#206](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/206)


### MQTT plugin

#### Enhancements

 * Topic authorisation.

   GitHub issues: [rabbitmq-mqtt#95](https://github.com/rabbitmq/rabbitmq-mqtt/issues/95), [rabbitmq-server#505](https://github.com/rabbitmq/rabbitmq-server/issues/505), [rabbitmq-mqtt#114](https://github.com/rabbitmq/rabbitmq-mqtt/issues/114).

 * Client ID is propagated to [authentication backends](http://rabbitmq.com/access-control.html).

   GitHub issue: [rabbitmq-mqtt#139](https://github.com/rabbitmq/rabbitmq-mqtt/issues/139)

 * QoS 2 subscriptions are downgraded to QoS 1

   GitHub issue: [rabbitmq-mqtt#21](https://github.com/rabbitmq/rabbitmq-mqtt/issues/21)


### Shovel Plugin

#### Enhancements

 * Support for AMQP 1.0 and a foundation for more protocols supported in the future.
   This means cross-protocol shoveling (AMQP 0-9-1 to AMQP 1.0 or the other way around) is now
   supported. [Erlang client for AMQP 1.0](https://github.com/rabbitmq/rabbitmq-amqp1.0-client) is now also available
   as a standalone project.

   GitHub issue: [rabbitmq-shovel#26](https://github.com/rabbitmq/rabbitmq-shovel/issues/26)

 * Message timestamping.

   Shovel now adds an extra header that contains the timestamp
   indicating when message was shovelled.

   GitHub issue: [rabbitmq-shovel#2](https://github.com/rabbitmq/rabbitmq-shovel/issues/2)


### Federation Plugin

#### Enhancements

 * New CLI command that restarts a link.

   GitHub issue: [rabbitmq-federation#45](https://github.com/rabbitmq/rabbitmq-federation/issues/45)

#### Bug Fixes

 * Internal exchanges and queues are now cleaned up if the policy goes out of effect or the plugin is disabled.

   GitHub issue: [rabbitmq-federation#63](https://github.com/rabbitmq/rabbitmq-federation/issues/63)

### Event Exchange Plugin

#### Enhancements

 * Acting user information is now included into the emitted events where possible.

   GitHub issue: [rabbitmq-event-exchange#10](https://github.com/rabbitmq/rabbitmq-event-exchange/issues/10)


### AMQP 1.0 Plugin

This release introduces a new sub-project, an [Erlang client for AMQP 1.0](https://github.com/rabbitmq/rabbitmq-amqp1.0-client), and AMQP 1.0 support
in the Shovel plugin.

#### Bug Fixes

 * Transfer frames are no longer sent before credit has been granted.

    GitHub issue: [rabbitmq-amqp1.0#43](https://github.com/rabbitmq/rabbitmq-amqp1.0/issues/43)

 * Ensure messages with `uint` TTL can round trip.

   GitHub issue: [rabbitmq-amqp1.0#13](https://github.com/rabbitmq/rabbitmq-amqp1.0/issues/13)


### LDAP Authn/Authz Backend

#### Enhancements

 * Topic authorisation support with variable expansion.

   GitHub issue: [rabbitmq-auth-backend-ldap#71](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/71)


### Delayed Message Exchange Plugin

#### Enhancements

 * It is now possible to see how many messages are delayed in management UI

   GitHub issue: [rabbitmq-delayed-message-exchange#3](https://github.com/rabbitmq/rabbitmq-delayed-message-exchange/issues/3)


### Erlang Client

#### Bug Fixes

 * Connection operations now use a reasonable timeout.

   GitHub issue: [rabbitmq-erlang-client#85](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/85)


### AMQP 0-9-1 Authn/Authz Backend

 * Topic authorisation support with variable expansion.

   GitHub issue: [rabbitmq-auth-backend-amqp#16](https://github.com/rabbitmq/rabbitmq-auth-backend-amqp/issues/16)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained.
When upgrading using definitions export/import from versions earlier than 3.6.0, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins, CLI tools or other sub-projects. Please download the archive named `rabbitmq-server-<version>.tar.xz` from this release
page.
