## RabbitMQ 3.6.6

`3.6.6` is a maintenance release that includes a fix for an **important security vulnerability** ([CVE-2016-9877](https://pivotal.io/security/cve-2016-9877)) in the MQTT plugin.

### Upgrades and Compatibility

> :warning:
> **Upgrading from versions between 3.6.0 and 3.6.5 to this release requires a cluster shutdown.**
This is also true for versions prior to 3.6.0.
See the ["Upgrading clusters" section of the documentation](https://www.rabbitmq.com/clustering.html#upgrading).

### Server

#### Bug Fixes

 * Changing queue mode to `lazy` could block queue process in certain circumstances.

   GitHub issue: [rabbitmq-server#850](https://github.com/rabbitmq/rabbitmq-server/issues/850)

 * Mirroring implementation didn't handle certain internal protocol messages arriving
   out of order.

   GitHub issue: [rabbitmq-server#922](https://github.com/rabbitmq/rabbitmq-server/issues/922)

 * Mirror set changes weren't handled gracefully in certain circumstances (e.g. in the middle of a mirror promotion).

   GitHub issue: [rabbitmq-server#914](https://github.com/rabbitmq/rabbitmq-server/issues/914)

 * Mirrored queue could terminate after promotion if HA policy was reapplied during sync.

   GitHub issue: [rabbitmq-server#803](https://github.com/rabbitmq/rabbitmq-server/issues/803)

 * Autoheal partition handling mode could run into a multi-node deadlock.

   GitHub issue: [rabbitmq-server#928](https://github.com/rabbitmq/rabbitmq-server/issues/928)

 * Queue mirror group membership now correctly handles certain partial partition cases.

   GitHub issues: [rabbitmq-server#950](https://github.com/rabbitmq/rabbitmq-server/issues/950),
                  [rabbitmq-server#953](https://github.com/rabbitmq/rabbitmq-server/issues/953)

 * Eager queue sync will now stop as soon as a mirror shutdown/unavailability is detected.

   GitHub issue: [rabbitmq-server#975](https://github.com/rabbitmq/rabbitmq-server/issues/975)

 * Lazy queues now trigger runtime GC significantly less frequently, making moving data
   to the message store more efficient.

   GitHub issue: [rabbitmq-server#973](https://github.com/rabbitmq/rabbitmq-server/issues/973)

 * Mirroring policies now respect the `nodes` parameter when re-electing a master.

   GitHub issue: [](https://github.com/rabbitmq/rabbitmq-server/issues/990)

 * After a partial network partitions, nodes with newly elected masters will now be more defensive
   about the (no longer relevant) policy change notifications.

   GitHub issue: [rabbitmq-server#1007](https://github.com/rabbitmq/rabbitmq-server/issues/1007)

 * Late responses from peers in certain partial network partition scenarios are now
   ignored by channels.

   GitHub issue: [rabbitmq-server#1005](https://github.com/rabbitmq/rabbitmq-server/issues/1005)

 * After a partial network partitions, nodes with newly elected masters will now be more defensive
   about the (no longer relevant) synchronization start requests.

   GitHub issue: [rabbitmq-server#1006](https://github.com/rabbitmq/rabbitmq-server/issues/1006)

 * Network partition triggered late and duplicate acknowledgements are now ignored/filterd out
   by queue leader processes.

   GitHub issue: [rabbitmq-server#960](https://github.com/rabbitmq/rabbitmq-server/issues/960)

 * Queue mirrors now try detect leader replica changes during partial partitions and do a clean stop
   instead of failing because their state is in sync with the old leader and not the newly promoted one.

   GitHub issue: [rabbitmq-server#944](https://github.com/rabbitmq/rabbitmq-server/issues/944)

 * `rabbitmqctl` and server startup could be affected by some DNS configurations.

   GitHub issue: [rabbitmq-server#890](https://github.com/rabbitmq/rabbitmq-server/issues/890)

 * RPM package was split into two: for CentOS 6 and 7. The latter includes systemd support.

   GitHub issue: [rabbitmq-server#932](https://github.com/rabbitmq/rabbitmq-server/issues/932)

 * Workaround for Erlang/OTP bug OTP-13425 where crash dump generation failed on UNIX
   platforms.

   GitHub issue: [rabbitmq-server#956](https://github.com/rabbitmq/rabbitmq-server/issues/956)

#### Enhancements

 * Inter-node traffic buffer increased to 32 MB by default, configurable with `RABBITMQ_DISTRIBUTION_BUFFER_SIZE` (in kilobytes).

   This improves network bandwidth utilization for inter-node traffic and reduces the probability
   of spurious network partitions due to latency spikes caused by the buffer being full.

   GitHub issue: [rabbitmq-server#908](https://github.com/rabbitmq/rabbitmq-server/issues/908)

 * Default flow control settings were increased to `{200, 100}`. This helps with consumer throughput
   in some cases. The value still can be configured using the `rabbit.credit_flow_default_credit` setting.

   GitHub issue: [rabbitmq-server#949](https://github.com/rabbitmq/rabbitmq-server/issues/949)

 * `rabbitmqctl list_queues` now has more filtering options.

   GitHub issue: [rabbitmq-server#851](https://github.com/rabbitmq/rabbitmq-server/issues/851)

 * `RABBITMQ_IGNORE_SIGINT` is a new environment variable that lets the user disable the
    `+B` VM flag that is known to have issues in Erlang 18.x series (prevents crash dumps from being produced).

    GitHub issue: [rabbitmq-server#956](https://github.com/rabbitmq/rabbitmq-server/issues/956)

 * The `pg2_fixed` module is now replaced by the standard `pg2` from a newer Erlang/OTP release.

   GitHub issue: [rabbitmq-server#980](https://github.com/rabbitmq/rabbitmq-server/issues/980)

### MQTT Plugin

#### Bug Fixes

 * Authentication with correct username but omitted password succeeded when TLS/x509
   certificate wasn't provided by the client. CVE allocation for this vulnerability is pending.

   GitHub issue: [rabbitmq-mqtt#96](https://github.com/rabbitmq/rabbitmq-mqtt/issues/96)


### JMS Topic Exchange Plugin

#### Bug Fixes

 * The plugin no longer tries to check if JMS client's version is identical/compatible.
   This caused certain legitimate use cases, such as exchange declaration over HTTP API, to fail.

   GitHub issue: [rabbitmq-jms-topic-exchange#9](https://github.com/rabbitmq/rabbitmq-jms-topic-exchange/issues/9)


### Java Client

#### Bug Fixes

 * Fixed a NPE that can occur when a thread attempts to create a new channel after a connection
   has been recovered but before channel recovery has completed.

   GitHub issue: [rabbitmq-java-client#197](https://github.com/rabbitmq/rabbitmq-java-client/pull/197)

   Contributed by Michael Dent.

 * Binding cache entries of auto-delete queues should be cleaned up when the last consumer is cancelled.

   GitHub issue: [rabbitmq-java-client#199](https://github.com/rabbitmq/rabbitmq-java-client/pull/199)

   Contributed by Michael Dent.

 * When a channel is closed, consumers will be correctly cleaned up from AutorecoveringConnection cache.

   GitHub issue: [rabbitmq-java-client#208](https://github.com/rabbitmq/rabbitmq-java-client/issues/208)

 * `junit` is no longer listed as a dependency in the OSGi manifest

   GitHub issue: [rabbitmq-java-client#211](https://github.com/rabbitmq/rabbitmq-java-client/issues/211)

#### Enhancements

 * `com.rabbitmq.client.AddressResolver` is a new interface that can be used to "expand"
   endpoints into groups of IP addresses, e.g. to a list of IP addresses resolved from a DNS
   record.

   GitHub issue: [rabbitmq-java-client#153](https://github.com/rabbitmq/rabbitmq-java-client/issues/153)

 * Building on the new `AddressResolver` interface, the client now includes a resolver
   that uses DNS SVR records to discover endpoints.

   GitHub issue: [rabbitmq-java-client#104](https://github.com/rabbitmq/rabbitmq-java-client/issues/104)

 * `com.rabbitmq.client.BuiltinExchangeType` is an enum that contains built-in exchange types.

   GitHub issue: [rabbitmq-java-client#150](https://github.com/rabbitmq/rabbitmq-java-client/issues/150)


### .NET Client

#### Bug Fixes

 * Fixed a possible `NullReferenceException` in `HeartbeatReadTimerCallback` during
   connection closure.

   GitHub issue: [rabbitmq-dotnet-client#257](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/257)

 * Fixed a potential race condition in `EventingBasicConsumer`

   GitHub issue: [rabbitmq-dotnet-client#242](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/242)

### Federation Plugin

#### Enhancements

 * Federation links now specify a name which makes them easier to tell from other connections
   in the management UI (requires RabbitMQ 3.6.3+).

   GitHub issue: [rabbitmq-federation#39](https://github.com/rabbitmq/rabbitmq-federation/issues/39)


### Shovel Plugin

#### Enhancements

 * Shovel connections now specify a name which makes them easier to tell from other connections
   in the management UI (requires RabbitMQ 3.6.3+).

   GitHub issue: [rabbitmq-shovel#19](https://github.com/rabbitmq/rabbitmq-shovel/issues/19)

## Release Artifacts

Available from:

 * GitHub (see below)
 * [Bintray](https://bintray.com/rabbitmq/)
 * [Package Cloud](https://packagecloud.io/rabbitmq/)
 * [rabbitmq.com](https://www.rabbitmq.com/download.html)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained. When upgrading using definitions export/import from versions earlier than 3.6.0, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.6.6.tar.gz`.
