% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtable.R
\name{dtable}
\alias{dtable}
\alias{dtab}
\title{tables for data frames}
\usage{
dtable(
  data,
  y = NULL,
  x = NULL,
  ...,
  level = -1,
  response = NULL,
  flat = TRUE,
  total = FALSE,
  prop = FALSE,
  summary = NULL
)
}
\arguments{
\item{data}{if x is formula or names for data frame then data frame is needed.}

\item{y}{name of variable, or fomula, or names of variables on data frame.}

\item{x}{name of variable, or fomula, or names of variables on data frame.}

\item{...}{Optional additional arguments}

\item{level}{1 for all marginal tables, 2 for all 2 by 2 tables, and null for the full table, possible versus group variable}

\item{response}{For level=2, only produce tables with columns given by 'response' (index)}

\item{flat}{produce flat tables}

\item{total}{add total counts/proportions}

\item{prop}{Proportions instead of counts (vector of margins)}

\item{summary}{summary function}
}
\description{
tables for data frames
}
\examples{
data("sTRACE",package="timereg")

dtable(sTRACE,~status)
dtable(sTRACE,~status+vf)
dtable(sTRACE,~status+vf,level=1)
dtable(sTRACE,~status+vf,~chf+diabetes)

dtable(sTRACE,c("*f*","status"),~diabetes)
dtable(sTRACE,c("*f*","status"),~diabetes, level=2)
dtable(sTRACE,c("*f*","status"),level=1)

dtable(sTRACE,~"*f*"+status,level=1)
dtable(sTRACE,~"*f*"+status+I(wmi>1.4)|age>60,level=2)
dtable(sTRACE,"*f*"+status~I(wmi>0.5)|age>60,level=1)
dtable(sTRACE,status~dcut(age))

dtable(sTRACE,~status+vf+sex|age>60)
dtable(sTRACE,status+vf+sex~+1|age>60, level=2)
dtable(sTRACE,.~status+vf+sex|age>60,level=1)
dtable(sTRACE,status+vf+sex~diabetes|age>60)
dtable(sTRACE,status+vf+sex~diabetes|age>60, flat=FALSE)

dtable(sTRACE,status+vf+sex~diabetes|age>60, level=1)
dtable(sTRACE,status+vf+sex~diabetes|age>60, level=2)

dtable(sTRACE,status+vf+sex~diabetes|age>60, level=2, prop=1, total=TRUE)
dtable(sTRACE,status+vf+sex~diabetes|age>60, level=2, prop=2, total=TRUE)
dtable(sTRACE,status+vf+sex~diabetes|age>60, level=2, prop=1:2, summary=summary)

}
\author{
Klaus K. Holst and Thomas Scheike
}
