% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-sf.R
\name{layer_sf}
\alias{layer_sf}
\title{Create a new sf layer that auto-maps geometry data}
\usage{
layer_sf(
  geom = NULL,
  stat = NULL,
  data = NULL,
  mapping = NULL,
  position = NULL,
  params = list(),
  inherit.aes = TRUE,
  check.aes = TRUE,
  check.param = TRUE,
  show.legend = NA
)
}
\arguments{
\item{geom}{The geometric object to use display the data}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{params}{Additional parameters to the \code{geom} and \code{stat}.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{check.aes}{If \code{TRUE}, the default, will check that
supplied parameters and aesthetics are understood by the \code{geom} or
\code{stat}. Use \code{FALSE} to suppress the checks.}

\item{check.param}{If \code{TRUE}, the default, will check that
supplied parameters and aesthetics are understood by the \code{geom} or
\code{stat}. Use \code{FALSE} to suppress the checks.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}
}
\description{
The \code{layer_sf()} function is a variant of \code{\link[=layer]{layer()}} meant to be used by
extension developers who are writing new sf-based geoms or stats.
The sf layer checks whether the data contains a geometry column, and
if one is found it is automatically mapped to the \code{geometry} aesthetic.
}
\keyword{internal}
