% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-simplegeom-obj.R
\name{simplegeom}
\alias{simplegeom}
\alias{simplegeom,missing-method}
\alias{simplegeom,ANY-method}
\title{Create simplegeom object}
\usage{
simplegeom(.Object, ...)

\S4method{simplegeom}{missing}(.Object, ...)

\S4method{simplegeom}{ANY}(.Object, ...)
}
\arguments{
\item{.Object}{any object that can be coerced into \linkS4class{simplegeom}}

\item{...}{additional arguments passed to \code{\link[sf]{st_sf}}}
}
\value{
the simplegeom object
}
\description{
A simple geom is a simple set of geometries specified locally. See 
\code{\link{webgeom}} for web features.
}
\examples{

simplegeom(c(-88.6, 45.2))

p1 <- sf::st_polygon(list(cbind(c(-89.0001,-89,-88.9999,-89,-89.0001),
                                c(46,46.0001,46,45.9999,46))))

p2 <- sf::st_polygon(list(cbind(c(-88.6,-88.5999,-88.5999,-88.6,-88.6),
                                c(45.2,45.2,45.1999,45.1999,45.2))))

P <- simplegeom(
  sf::st_sf(geo = sf::st_sfc(list(p1, p2), crs = 4326))
)

\dontrun{
result(geoknife(P, "prism", wait = TRUE))
}

simplegeom(data.frame('point1'=c(-89, 46), 'point2'=c(-88.6, 45.2)))

}
\author{
Jordan S Read
}
