% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-escape.R
\name{db-quote}
\alias{sql_escape_logical}
\alias{sql_escape_date}
\alias{sql_escape_datetime}
\alias{sql_escape_raw}
\title{SQL escaping/quoting generics}
\usage{
sql_escape_logical(con, x)

sql_escape_date(con, x)

sql_escape_datetime(con, x)

sql_escape_raw(con, x)
}
\description{
These generics translate individual values into SQL. The core
generics are \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}} and \link[DBI:dbQuoteString]{DBI::dbQuoteString}
for quoting identifiers and strings, but dbplyr needs additional
tools for inserting logical, date, date-time, and raw values into
queries.
}
\examples{
con <- simulate_dbi()
sql_escape_logical(con, c(TRUE, FALSE, NA))
sql_escape_date(con, Sys.Date())
sql_escape_date(con, Sys.time())
sql_escape_raw(con, charToRaw("hi"))
}
\seealso{
Other generic: 
\code{\link{db-sql}},
\code{\link{db_connection_describe}()},
\code{\link{db_copy_to}()}
}
\concept{generic}
\keyword{internal}
