% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.R
\name{GDCprepare}
\alias{GDCprepare}
\title{Prepare GDC data}
\usage{
GDCprepare(
  query,
  save = FALSE,
  save.filename,
  directory = "GDCdata",
  summarizedExperiment = TRUE,
  remove.files.prepared = FALSE,
  add.gistic2.mut = NULL,
  mutant_variant_classification = c("Frame_Shift_Del", "Frame_Shift_Ins",
    "Missense_Mutation", "Nonsense_Mutation", "Splice_Site", "In_Frame_Del",
    "In_Frame_Ins", "Translation_Start_Site", "Nonstop_Mutation")
)
}
\arguments{
\item{query}{A query for GDCquery function}

\item{save}{Save result as RData object?}

\item{save.filename}{Name of the file to be save if empty an automatic will be created}

\item{directory}{Directory/Folder where the data was downloaded. Default: GDCdata}

\item{summarizedExperiment}{Create a summarizedExperiment? Default TRUE (if possible)}

\item{remove.files.prepared}{Remove the files read? Default: FALSE
This argument will be considered only if save argument is set to true}

\item{add.gistic2.mut}{If a list of genes (gene symbol) is given, columns with gistic2 results from GDAC firehose (hg19)
and a column indicating if there is or not mutation in that gene (hg38)
(TRUE or FALSE - use the MAF file for more information)
will be added to the sample matrix in the summarized Experiment object.}

\item{mutant_variant_classification}{List of mutant_variant_classification that will be
consider a sample mutant or not. Default: "Frame_Shift_Del", "Frame_Shift_Ins",
"Missense_Mutation", "Nonsense_Mutation", "Splice_Site", "In_Frame_Del",
"In_Frame_Ins", "Translation_Start_Site", "Nonstop_Mutation"}
}
\value{
A summarizedExperiment or a data.frame
}
\description{
Reads the data downloaded and prepare it into an R object
}
\examples{
\dontrun{
query <- GDCquery(
  project = "TCGA-KIRP",
  data.category = "Simple Nucleotide Variation",
  data.type = "Masked Somatic Mutation"
)
GDCdownload(query, method = "api", directory = "maf")
maf <- GDCprepare(query, directory = "maf")

}
}
\author{
Tiago Chedraoui Silva
}
