# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.loganalytics.aio import LogAnalyticsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestLogAnalyticsManagementQueriesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(LogAnalyticsManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_queries_list(self, resource_group):
        response = self.client.queries.list(
            resource_group_name=resource_group.name,
            query_pack_name="str",
            api_version="2025-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_queries_search(self, resource_group):
        response = self.client.queries.search(
            resource_group_name=resource_group.name,
            query_pack_name="str",
            query_search_properties={
                "related": {"categories": ["str"], "resourceTypes": ["str"], "solutions": ["str"]},
                "tags": {"str": ["str"]},
            },
            api_version="2025-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_queries_get(self, resource_group):
        response = await self.client.queries.get(
            resource_group_name=resource_group.name,
            query_pack_name="str",
            id="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_queries_put(self, resource_group):
        response = await self.client.queries.put(
            resource_group_name=resource_group.name,
            query_pack_name="str",
            id="str",
            query_payload={
                "author": "str",
                "body": "str",
                "description": "str",
                "displayName": "str",
                "id": "str",
                "name": "str",
                "properties": {},
                "related": {"categories": ["str"], "resourceTypes": ["str"], "solutions": ["str"]},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": ["str"]},
                "timeCreated": "2020-02-20 00:00:00",
                "timeModified": "2020-02-20 00:00:00",
                "type": "str",
            },
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_queries_update(self, resource_group):
        response = await self.client.queries.update(
            resource_group_name=resource_group.name,
            query_pack_name="str",
            id="str",
            query_payload={
                "author": "str",
                "body": "str",
                "description": "str",
                "displayName": "str",
                "id": "str",
                "name": "str",
                "properties": {},
                "related": {"categories": ["str"], "resourceTypes": ["str"], "solutions": ["str"]},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": ["str"]},
                "timeCreated": "2020-02-20 00:00:00",
                "timeModified": "2020-02-20 00:00:00",
                "type": "str",
            },
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_queries_delete(self, resource_group):
        response = await self.client.queries.delete(
            resource_group_name=resource_group.name,
            query_pack_name="str",
            id="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...
