/* SPDX-FileCopyrightText: 2009, 2015, 2018, 2020  Peter Pentchev
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _UTIL_H_
#define _UTIL_H_

int		 util_strsort(char **);
int		 util_trunc(char *);
int		 write_buf(int, const char *, size_t);

static inline void *
malloc_fatal(const size_t size)
{
  void * const p = malloc(size);
  if (p == NULL)
    abort();
  return p;
}

#if defined(__GNUC__) && __GNUC__ >= 7
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Walloc-size-larger-than="
#endif

static inline void *
realloc_fatal(void * const p, const size_t size)
{
  void * const newp = realloc(p, size);
  if (newp == NULL)
    abort();
  return newp;
}

#if defined(__GNUC__) && __GNUC__ >= 7
#pragma GCC diagnostic pop
#endif

static inline char *
strdup_fatal(const char * const s)
{
  char * const news = strdup(s);
  if (news == NULL)
    abort();
  return news;
}

#endif /* _UTIL_H_ */
