/*
 * @(#)Oct2dP.h
 *
 * Copyright 2023 - 2024  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Oct2d */

#ifndef _Oct2dP_h
#define _Oct2dP_h

#include "Oct2d.h"

#ifndef WINVER
/* This gets around C's inability to do inheritance */
typedef struct _Oct2DClassPart {
	int ignore;
} Oct2DClassPart;

typedef struct _Oct2DClassRec {
	CoreClassPart coreClass;
	OctClassPart octClass;
	Oct2DClassPart oct2dClass;
} Oct2DClassRec;

extern Oct2DClassRec oct2dClassRec;
#endif

typedef struct _Oct2DPart {
	Position    faceLength;
	Position    viewLength;
} Oct2DPart;

typedef struct _Oct2DRec {
	CorePart    core;
	OctPart     oct;
	Oct2DPart   oct2d;
} Oct2DRec;

extern Boolean selectPieces2D(Oct2DWidget w, int positionX, int positionY,
	int *face, int *position);
extern Boolean narrowSelection2D(Oct2DWidget w, int style,
	int *face, int *position, int *direction);
extern void eraseFrame2D(const Oct2DWidget w);
extern void drawFrame2D(Oct2DWidget w, Boolean focus);
extern void drawTriangle2D(Oct2DWidget w, int face, int position, int offset);
#ifdef WINVER
extern void initializePuzzle2D(Oct2DWidget w);
extern void resizePuzzle2D(Oct2DWidget w);
extern void exposePuzzle2D(Oct2DWidget w);
#endif

#endif /* _Oct2dP_h */
