.\" @(#)xbarrel.man
.\"
.\" Copyright 2004 - 2024  David A. Bagley
.\"
.\" All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "useful",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH BARREL 6 "15 Aug 2024" "V8.8.4"
.SH NAME
xbarrel \- Barrel X widget
.SH SYNOPSIS
.B /usr/games/xbarrel
[\-geometry [{width}][x{height}][{+\-}{xoff}[{+\-}{yoff}]]]
[\-display [{host}]:[{vs}]] [\-[no]mono] [\-[no]{reverse|rv}]
[\-{foreground|fg} {color}] [\-{background|bg} {color}]
[\-{border|bd} {color}] [\-face{0|1|2|3|4|5} {color}]
[\-tile {color}] [\-frame {color}] [\-no]stippleFrame]
[\-[no]install] [\-picture {filename}] [\-delay msecs]
[\-[no]sound] [\-bumpSound {filename}]
[\-moveSound {filename}] [\-{font|fn} {fontname}]
[\-[no]orient] [\-[no]pairs] [\-[no]practice] [\-base {int}]
[\-userName {string}] [\-scoreFile {filename}] [\-scores]
[\-version]
.SH DESCRIPTION
.LP
The Barrel, the Billion Barrel, or Wonderful Barrel also seen as the
Cylinder Puzzle is of Japanese origin.  The puzzle contains 23 beads of 6
different colors.  4 each of 5 different colors arranged in 5 rows and 3
black beads making 3 rows one unit longer.  A system of plungers slide
all three of the long rows left and right.  Two of the plungers sit
together and the other (the middle plunger) is separate from the
other two.  There are 2 separate wheels or disks that rotate about
the center axis.
.SH FEATURES
Press "\fBmouse\-left\fP" button to move a tile.  Release
"\fBmouse\-left\fP" button in the same row would move the tile towards the
space (unless there is no space in that row).  Release on a different row
will move the tiles up or down.
.LP
Click "\fBmouse\-center\fP", or press "\fBP\fP" or "\fBp\fP" keys to toggle
the practice mode (in practice mode the record should say "practice").
This is good for learning moves and experimenting.
.LP
Click "\fBmouse\-right\fP", or press "\fBZ\fP" or "\fBz\fP" keys, to
randomize the puzzle (this must be done first to set a new record).
.LP
Press "\fBG\fP" or "\fBg\fP" keys to read (get) a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to save (write) a puzzle.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBR\fP" or "\fBr\fP" keys to redo a move.
.LP
Press "\fBC\fP" or "\fBc\fP" keys to clear the puzzle.
.LP
Press "\fBS\fP" or "\fBs\fP" keys to start the auto\-solver.  Only works
where oriented is off.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  Slightly
more challenging on (default is off).
.LP
Press "\fBI\fP" or "\fBi\fP" keys to toggle the pairs mode.  All the
tiles rotate in pairs.  This is considerably more challenging on
(default is on).
.LP
Press "\fB>\fP" or "\fB.\fP" keys to speed up the movement of tiles.
.LP
Press "\fB<\fP" or "\fB,\fP" keys to slow down the movement of tiles.
.LP
Press "\fB@\fP" key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL\-C\fP" keys to kill program.
.LP
Use the key pad or arrow keys to move without the mouse.
.br
Key pad is defined for Barrel as:
.br
  8     Up
.br
  ^
.br
4< >6   Left, Right
.br
  v
.br
  2     Down
.LP
Use the shift key and the up or down arrow keys to rotate all the tiles.
.LP
Use the control key and the keypad or arrow keys to reduce or enlarge the
complexity of the puzzle.
.LP
The title is in the following format (non\-motif version):
.RS
xbarrel: {norm|ind<control of movement of pairs tiles>} @
(<Number of moves>/{<Record number of moves>
<user name>|"NEVER noaccess"|"practice"}) \- <Comment>
.RE
Movement of tile pairs are either move together or independent.
.br
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the barrel window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to display the barrel window on a color screen
as if it were monochrome (resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the barrel window in reverse video
(resource name "\fIreverseVideo\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the barrel window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the barrel window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the tiles in the barrel window
(resource name "\fborderColor\fP").
.TP 8
.B \-face{0|1|2|3|4|5} <\fIcolor\fP>
This option allows you to change the color of a face (resource name
"\fIfaceColorN\fP"). In mono\-mode, color is represented as the first letter
of the color name.  The 0th face is the last face face on barrel
because I wanted that one to remain white by default when there are more or
.TP 8
.B \-tile \fIcolor\fP
This option specifies the tile color of the tiles in the barrel window
(resource name "\fItileColor\fP").
less faces.
.TP 8
.B \-frame \fIcolor\fP
This option specifies the color of the frame (resource name
"\fIframeColor\fP").
.TP 8
.B \-[no]stippleFrame
This option allows you to toggle the frame stippling (resource name
"\fIstippleFrame\fP").
.TP 8
.B \-[no]install
This option specifies if the colormap should be installed or not
(resource name "\fIinstall\fP").
.TP 8
.B \-picture \fIfilename\fP
This option specifies the file for the picture (resource name
"\fIpicture\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move a tile or
a group of tiles one space (1\-50) (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if a sliding tile should make a sound or not
(resource name "\fIsound\fP").
.TP 8
.B \-bumpSound \fIfilename\fP
This option specifies the file for the bump sound for the sliding of
the tiles (resource name "\fIbumpSound\fP").
.TP 8
.B \-moveSound \fIfilename\fP
This option specifies the file for the move sound for the twisting of
the puzzle (resource name "\fImoveSound\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-[no]orient
This option allows you to access the oriented mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]pairs
This option allows you to access the pairs rigid mode (resource name
"\fIpairs\fP").
.TP 8
.B \-[no]practice
This option allows you to access the practice mode (resource name
"\fIpractice\fP").
.TP 8
.B \-base \fIint\fP
This option specifies the base used (default is base 10) (resource name
"\fIbase\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xbarrel you have.
.SH RECORDS
You must randomize the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get.
.SH SAVE FORMAT
Here is the format for the xbarrel configuration, starting position, and
the movement of its pieces.
.sp
.RS
pairs: 0\-1 <0 false, 1 true; if 1 then pairs of rings move together>
.br
orient: 0\-1 <0 false, 1 true; if 1 then chain linked in order>
.br
moves: 0\-MAXINT <total number of moves>
.sp
startingPosition: <array of tile positions where 0 is the empty space>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <direction> <tile> <shift>
.RE
Direction is represented as 0 up, 1 right, 2 down, and 3 left.
.br
Tile is the column of tile.
.br
Shift is represented as 0 or 1, 1 if the whole puzzle is moved at
once (here Tile does not matter), 0 if not.  The xbarrel record keeper
does not count a control move as a move, but here we do.
.SH REFERENCES
L. E. Horden, Sliding Piece Puzzles (Recreations in Mathematics Series),
Oxford University Press 1986, Plate X.
.sp
James G Nourse, The Simple Solutions to Cubic, Puzzles, Bantam Books,
New York, November 1981, pp 25\-42.
.sp
John Ewing & Czes Kosniowski, Puzzle it Out: Cubes Groups and Puzzles,
Cambridge University Press, New York, 1982, pp 50\-54?
.SH SEE ALSO
.LP
X(1), xcubes(6), xtriangles(6), xhexagons(6), xmlink(6), xpanex(6),
xmball(6), xpyraminx(6), xoct(6), xrubik(6), xskewb(6), xdino(6),
xbevel(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1994\-2024, David A. Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David A. Bagley, <\fIbagleyd AT verizon.net\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIhttps://www.sillycycle.com/puzzles.html\fP
.br
\fIhttp://www.ibiblio.org/pub/Linux/games/strategy/\fP
