# This Makefile snippet defines DEB_*_RUST_TYPE triples based on DEB_*_GNU_TYPE

include /usr/share/dpkg/architecture.mk

rust_cpu = $(subst i586,i686,\
$(if $(findstring -riscv64-,-$(2)-),$(subst riscv64,riscv64gc,$(1)),\
$(if $(findstring -armel-,-$(2)-),$(subst arm,armv5te,$(1)),\
$(1))))

rust_os = $(if $(findstring -hurd-,-$(2)-),$(subst gnu,hurd-gnu,$(1)),$1)

rust_type_setvar = $(1)_RUST_TYPE ?= $(call rust_cpu,$($(1)_GNU_CPU),$($(1)_ARCH))-unknown-$(call rust_os,$($(1)_GNU_SYSTEM),$($(1)_ARCH_OS))

$(foreach machine,BUILD HOST TARGET,\
  $(eval $(call rust_type_setvar,DEB_$(machine))))

# fallback for older dpkg versions
ifeq ($(DEB_TARGET_RUST_TYPE),-unknown-)
  DEB_TARGET_RUST_TYPE = $(DEB_HOST_RUST_TYPE)
endif

DEB_BUILD_RUST_TYPE = $(shell RUSTC_BOOTSTRAP=1 rustc -Z unstable-options --print target-spec-json | python3 -c 'import json,sys;obj=json.load(sys.stdin);print(obj["llvm-target"])')
