/*
 * Copyright (c) 2014, 2015
 * NDE Netzdesign und -entwicklung AG, Hamburg, Germany
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program (see the file LICENSE.txt for more
 * details); if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 */

package org.acplt.oncrpc.maven.plugin;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

/**
 * This class defines the goal <em>clientandserver</em> within the
 * lifecycle phase <em>generate-sources</em>.
 * 
 * <p>Both the client and server stub(s) to the RPC program(s) specified in the x-file
 * to be processed are generated alongside the XDR datatype classes.
 *
 * <p>Possible parameters are described in the base class {@link JrpcgenGeneratorBase}.
 * 
 * <p>Sample configuration:
 * <pre>
	{@literal <}plugin{@literal >}
		{@literal <}groupId{@literal >}org.acplt.remotetea{@literal <}/groupId{@literal >}
		{@literal <}artifactId{@literal >}remotetea-maven-plugin{@literal <}/artifactId{@literal >}
		{@literal <}version{@literal >}1.1.6{@literal <}/version{@literal >}
		{@literal <}executions{@literal >}
			{@literal <}execution{@literal >}
				{@literal <}id{@literal >}jrpcgen{@literal <}/id{@literal >}
				{@literal <}goals{@literal >}
					{@literal <}goal{@literal >}clientandserver{@literal <}/goal{@literal >}
				{@literal <}/goals{@literal >}
				{@literal <}configuration{@literal >}
					{@literal <}xFile{@literal >}src/main/resources/bellamso_tracelog.x{@literal <}/xFile{@literal >}
					{@literal <}destDir{@literal >}${project.build.directory}/generated-sources{@literal <}/destDir{@literal >}
					{@literal <}packageName{@literal >}com.bellamso.tracelog.rpc{@literal <}/packageName{@literal >}
					{@literal <}!-- Force the creation of the destination directory
					     if it does not already exist at generation time. --{@literal >} 
					{@literal <}createDir{@literal >}true{@literal <}/createDir{@literal >}
					{@literal <}!-- Uncomment the following line to create
					     an RPC server listening only on TCP. --{@literal >}
					{@literal <}!-- {@literal <}serverTcpOnly{@literal >}true{@literal <}/serverTcpOnly{@literal >} --{@literal >}
					{@literal <}!-- Uncomment the following line to create
					     an RPC server listening only on UDP. --{@literal >}
					{@literal <}!-- {@literal <}serverUdpOnly{@literal >}true{@literal <}/serverUdpOnly{@literal >} --{@literal >}
				{@literal <}/configuration{@literal >}
			{@literal <}/execution{@literal >}
		{@literal <}/executions{@literal >}
	{@literal <}/plugin{@literal >}
 * </pre>
 * 
 * @author Harald Wirths {@literal hwirths@nde.ag>}
 *
 */
@Mojo( name="clientandserver", defaultPhase=LifecyclePhase.GENERATE_SOURCES )
public class JRpcGenerator
    extends JRpcGeneratorBase
{

    public void execute()
        throws MojoExecutionException
    {
        this.generateSources();
    }
    
}
