% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{u_scale}
\alias{u_scale}
\title{Rank uniformization}
\usage{
u_scale(x, c = 3/8)
}
\arguments{
\item{x}{(numeric) A scalar, vector, matrix, or array of values.}

\item{c}{(numeric) Fractional offset used in the back-transformation of ranks.
Defaults to \code{3/8}.}
}
\value{
A numeric array of uniformized values with the same size
and dimension as the input.
}
\description{
Compute rank uniformization for a numeric array. First replace each value by
its rank. Average rank for ties are used to conserve the number of unique
values of discrete quantities. Second, uniformize ranks using formula
\code{(r - c) / (S - 2 * c + 1)}, where \code{r} is a rank, \code{S} is the number of
values, and \code{c} is a fractional offset which defaults to c = 3/8 as
recommend by Blom (1958).
}
\keyword{internal}
