% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialExperiment-rotate-mirror.R
\name{SpatialExperiment-rotate-mirror}
\alias{SpatialExperiment-rotate-mirror}
\alias{rotateCoords}
\alias{mirrorCoords}
\alias{rotateObject}
\alias{mirrorObject}
\alias{rotateCoords,SpatialExperiment-method}
\alias{mirrorCoords,SpatialExperiment-method}
\alias{rotateObject,SpatialExperiment-method}
\alias{mirrorObject,SpatialExperiment-method}
\title{Methods for spatial attributes}
\usage{
\S4method{rotateCoords}{SpatialExperiment}(x, sample_id = NULL, degrees = 90, warn = TRUE)

\S4method{mirrorCoords}{SpatialExperiment}(x, sample_id = NULL, axis = c("h", "v"), warn = TRUE)

\S4method{rotateObject}{SpatialExperiment}(x, sample_id = NULL, image_id = NULL, degrees = 90)

\S4method{mirrorObject}{SpatialExperiment}(x, sample_id = NULL, image_id = NULL, axis = c("h", "v"))
}
\arguments{
\item{x}{A \code{\link{SpatialExperiment}} object.}

\item{sample_id}{Logical value or character vector specifying sample
identifier(s) for \code{scaleFactors}. Default = \code{TRUE} (all samples).}

\item{degrees}{single numeric 
in +/-[0,90,...,360] specifying how many degrees to rotate.
A negative/positive value corresponds to counter-/clockwise rotation.
Applicable for \code{rotateCoords} and \code{rotateObject} methods.}

\item{warn}{Logical value indicating whether to print a warning about
mismatches between coordinates and images, possible with the spatialCoords
transformation methods \code{rotateCoords} and \code{mirrorCoords}.}

\item{axis}{character string specifying whether to mirror 
horizontally (\code{"h"}) or vertically (\code{"v"}). Applicable for
\code{mirrorCoords} and \code{mirrorObject} methods.}

\item{image_id}{Logical value or character vector specifying image
identifier(s) for \code{scaleFactors}. Default = \code{TRUE} (all images).}
}
\value{
Return value varies depending on method, as described below.
}
\description{
The \code{\link{SpatialExperiment}} class provides methods to rotate and
mirror \code{\link{SpatialExperiment}} objects and their
\code{spatialCoords}.
}
\details{
Additional details for each type of data attribute are provided below.
}
\section{spatialCoords transformation methods}{

\describe{
\item{\code{rotateCoords(x, sample_id, degrees, warn)}: }{
  Apply a rotation to the \code{spatialCoords} of \code{x}, potentially
  subsetted to sample \code{sample_id} (or without subsetting if
  \code{sample_id} is \code{NULL}), by the specified number of \code{degrees}
  clockwise. Warn about mismatches with images if \code{warn}.}
\item{\code{mirrorCoords(x, sample_id, axis, warn)}: }{
  Reflect the \code{spatialCoords} of \code{x} across either the horizontal
  or vertical axis, specified by supplying "h" or "v" to the \code{axis}
  argument, respectively. Subset \code{x} to just the sample
  \code{sample_id}, if not \code{NULL}. Warn about mismatches with images if
  \code{warn}.}
}
}

\section{SpatialExperiment transformation wrapper methods}{

\describe{
\item{\code{rotateObject(x, sample_id, image_id, degrees)}: }{
  Apply a rotation to the \code{\link{spatialCoords}} and
  \code{\link{imgData}} of
  \code{x}, potentially subsetted to sample \code{sample_id} (or without
  subsetting if \code{sample_id} is \code{NULL}), by the specified number of
  \code{degrees} clockwise. Wrapper around \code{rotateCoords} and
  \code{rotateImg}.}
\item{\code{mirrorObject(x, sample_id, image_id, axis)}: }{
  Reflect the \code{\link{spatialCoords}} and \code{\link{imgData}} of \code{x} across
  either the horizontal or vertical axis, specified by supplying "h" or "v"
  to the \code{axis} argument, respectively. Subset \code{x} to just the
  sample \code{sample_id}, if not \code{NULL}. Wrapper around
  \code{mirrorCoords} and \code{mirrorImg}.}
}
}

\examples{
example(read10xVisium)

# rotateCoords(), mirrorCoords(), rotateObject(), and mirrorObject() return a
# SpatialExperiment, potentially subsetted by sample.

# Subset to just "section1"; rotate coordinates 90 degrees clockwise followed
# by a reflection across the vertical axis
spe_coords <- rotateCoords(spe, sample_id = "section1", degrees = 90)
spe_coords <- mirrorCoords(spe_coords, axis = "v")

# Subset to just "section2"; transform both the imgData() and spatialCoords()
# by a 180-degree rotation then reflection across the vertical axis
spe_wrapper <- rotateObject(spe, sample_id = "section2", degrees = 180)
spe_wrapper <- mirrorObject(spe_wrapper, axis = "v")
}
\author{
Nicholas J. Eagles
}
