% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_central.R
\name{scater-plot-args}
\alias{scater-plot-args}
\title{General visualization parameters}
\description{
\pkg{scater} functions that plot points share a number of visualization parameters, which are described on this page.
}
\section{Aesthetic parameters}{

\describe{
\item{\code{add_legend}:}{Logical scalar, specifying whether a legend should be shown.
Defaults to TRUE.}
\item{\code{theme_size}:}{Integer scalar, specifying the font size.
Defaults to 10.}
\item{\code{point_alpha}:}{Numeric scalar in [0, 1], specifying the transparency.
Defaults to 0.6.}
\item{\code{point_size}:}{Numeric scalar, specifying the size of the points.
Defaults to \code{NULL}.}
\item{\code{point_shape}:}{An integer, or a string specifying the shape
of the points. Details see \code{vignette("ggplot2-specs")}. Defaults to
\code{19}.}
\item{\code{jitter_type}:}{String to define how points are to be jittered in a violin plot.
This is either with random jitter on the x-axis (\code{"jitter"}) or in a \dQuote{beeswarm} style (if \code{"swarm"}, default).
The latter usually looks more attractive, but for datasets with a large number of cells, or for dense plots, the jitter option may work better.}
}
}

\section{Distributional calculations}{

\describe{
\item{\code{show_median}:}{Logical, should the median of the distribution be shown for violin plots?
Defaults to \code{FALSE}.}
\item{\code{show_violin}:}{Logical, should the outline of a violin plot be shown?
Defaults to \code{TRUE}.}
\item{\code{show_smooth}:}{Logical, should a smoother be fitted to a scatter plot?
Defaults to \code{FALSE}.}
\item{\code{show_se}:}{Logical, should standard errors for the fitted line be shown on a scatter plot when \code{show_smooth=TRUE}?
Defaults to \code{TRUE}.}
\item{\code{show_boxplot}:}{Logical, should a box plot be shown? Defaults to \code{FALSE}.}
}
}

\section{Miscellaneous fields}{
 Addititional fields can be added to the
  data.frame passed to \link{ggplot} by setting the \code{other_fields}
  argument. This allows users to easily incorporate additional metadata for
  use in further \pkg{ggplot} operations.

  The \code{other_fields} argument should be character vector where each
  string is passed to \code{\link{retrieveCellInfo}} (for cell-based plots)
  or \code{\link{retrieveFeatureInfo}} (for feature-based plots).
  Alternatively, \code{other_fields} can be a named list where each element
  is of any type accepted by \code{\link{retrieveCellInfo}} or
  \code{\link{retrieveFeatureInfo}}. This includes \link{AsIs}-wrapped
  vectors, data.frames or \linkS4class{DataFrame}s.

  Each additional column of the output data.frame will be named according to
  the \code{name} returned by \code{\link{retrieveCellInfo}} or
  \code{\link{retrieveFeatureInfo}}. If these clash with inbuilt names (e.g.,
  \code{X}, \code{Y}, \code{colour_by}), a warning will be raised and the
  additional column will not be added to avoid overwriting an existing
  column.
}

\seealso{
\code{\link{plotColData}}, \code{\link{plotRowData}},
\code{\link{plotReducedDim}}, \code{\link{plotExpression}},
\code{\link{plotPlatePosition}}, and most other plotting functions.
}
