% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentationCBS.R
\name{segmentationCBS}
\alias{segmentationCBS}
\title{CBS segmentation}
\usage{
segmentationCBS(
  normal,
  tumor,
  log.ratio,
  seg,
  plot.cnv,
  sampleid,
  weight.flag.pvalue = 0.01,
  alpha = 0.005,
  undo.SD = NULL,
  vcf = NULL,
  tumor.id.in.vcf = 1,
  normal.id.in.vcf = NULL,
  max.segments = NULL,
  prune.hclust.h = NULL,
  prune.hclust.method = "ward.D",
  chr.hash = NULL,
  centromeres = NULL
)
}
\arguments{
\item{normal}{Coverage data for normal sample.}

\item{tumor}{Coverage data for tumor sample.}

\item{log.ratio}{Copy number log-ratios, one for each target in the coverage
files.}

\item{seg}{If segmentation was provided by the user, this data structure
will contain this segmentation. Useful for minimal segmentation functions.
Otherwise PureCN will re-segment the data. This segmentation function
ignores this user provided segmentation.}

\item{plot.cnv}{Segmentation plots.}

\item{sampleid}{Sample id, used in output files.}

\item{weight.flag.pvalue}{Flag values with one-sided p-value smaller than
this cutoff.}

\item{alpha}{Alpha value for CBS, see documentation for the \code{segment}
function.}

\item{undo.SD}{\code{undo.SD} for CBS, see documentation of the
\code{segment} function. If NULL, try to find a sensible default.}

\item{vcf}{Optional \code{CollapsedVCF} object with germline allelic ratios.}

\item{tumor.id.in.vcf}{Id of tumor in case multiple samples are stored in
VCF.}

\item{normal.id.in.vcf}{Id of normal in in VCF. Currently not used.}

\item{max.segments}{If not \code{NULL}, try a higher \code{undo.SD}
parameter if number of segments exceeds the threshold.}

\item{prune.hclust.h}{Height in the \code{hclust} pruning step. Increasing
this value will merge segments more aggressively. If NULL, try to find a
sensible default.}

\item{prune.hclust.method}{Cluster method used in the \code{hclust} pruning
step. See documentation for the \code{hclust} function.}

\item{chr.hash}{Mapping of non-numerical chromsome names to numerical names
(e.g. chr1 to 1, chr2 to 2, etc.). If \code{NULL}, assume chromsomes are
properly ordered.}

\item{centromeres}{A \code{GRanges} object with centromere positions.
Currently not supported in this function.}
}
\value{
\code{data.frame} containing the segmentation.
}
\description{
The default segmentation function. This function is called via the
\code{fun.segmentation} argument of \code{\link{runAbsoluteCN}}.  The
arguments are passed via \code{args.segmentation}.
}
\examples{

normal.coverage.file <- system.file("extdata", "example_normal_tiny.txt", 
    package="PureCN")
tumor.coverage.file <- system.file("extdata", "example_tumor_tiny.txt", 
    package="PureCN")
vcf.file <- system.file("extdata", "example.vcf.gz", 
    package="PureCN")
interval.file <- system.file("extdata", "example_intervals_tiny.txt", 
    package="PureCN")

# The max.candidate.solutions, max.ploidy and test.purity parameters are set to
# non-default values to speed-up this example.  This is not a good idea for real
# samples.
ret <-runAbsoluteCN(normal.coverage.file=normal.coverage.file, 
    tumor.coverage.file=tumor.coverage.file, vcf.file=vcf.file, genome="hg19", 
    sampleid="Sample1", interval.file=interval.file, 
    max.candidate.solutions=1, max.ploidy=4, test.purity=seq(0.3,0.7,by=0.05), 
    fun.segmentation=segmentationCBS, args.segmentation=list(alpha=0.001))

}
\references{
Olshen, A. B., Venkatraman, E. S., Lucito, R., Wigler, M. 
(2004). Circular binary segmentation for the analysis of array-based DNA 
copy number data. Biostatistics 5: 557-572.

Venkatraman, E. S., Olshen, A. B. (2007). A faster circular binary 
segmentation algorithm for the analysis of array CGH data. Bioinformatics 
23: 657-63.
}
\seealso{
\code{\link{runAbsoluteCN}}
}
\author{
Markus Riester
}
