% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWeights.R
\name{plotWeights}
\alias{plotWeights}
\title{Plot Weights}
\usage{
plotWeights(object, view, factor, nfeatures = 10, abs = FALSE,
  manual = NULL, color_manual = NULL, scale = TRUE)
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{view}{character vector with the view name, or numeric vector with the index of the view to use.}

\item{factor}{character vector with the factor name, or numeric vector with the index of the factor to use.}

\item{nfeatures}{number of top features to label.}

\item{abs}{logical indicating whether to use the absolute value of the weights.}

\item{manual}{A list of character vectors with features to be manually labelled 
(i.e. list(c("feature1","feature2"), c("feature3","feature4")). 
Each character vector specifies a set of features that will be highlighted with the same color, as specified in \code{color_manual}.}

\item{color_manual}{a character vector with colors, one for each character vector of \code{manual}}

\item{scale}{logical indicating whether to scale all loadings from 0 to 1.}
}
\value{
a plot of all feature loadings for the given factor
}
\description{
An important step to annotate factors is to visualise the feature loadings. \cr
This function plots all loadings for a given latent factor and view, optionally labeling the top ones. \cr
A similar function is \code{\link{plotTopWeights}}, which displays only the top features with highest loading.
}
\details{
The weights, or the loadings, provide the mapping between the high-dimensional space (the genes) and the low-dimensional space (the factors). \cr
They define a score for each gene on each factor, such that genes with no association with the factor are expected to 
have values close to zero, whereas genes with strong association with the factor are expected to have large absolute values. \cr
The sign of the loading indicates the direction of the effect: A positive loading indicates that the feature is more active 
in the cells with positive factor values, while a negative loading indicates that the feature is more active in the cells with negative factor values.
}
\examples{
# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
plotWeights(MOFA_CLL, view="Mutations", factor=1)

# Highlight specific features
plotWeights(MOFA_CLL, view="Mutations", factor=1,
  manual=list(c("IGHV"), c("TP53", "del17p13")), 
  color_manual=c("blue","red")
 )

# Example on the scMT data
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFA_scMT <- loadModel(filepath)
plotWeights(MOFA_scMT, view="RNA expression", factor=1, nfeatures=15)
}
