% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{makeSimSwishData}
\alias{makeSimSwishData}
\title{Make simulated data for swish for examples/testing}
\usage{
makeSimSwishData(
  m = 1000,
  n = 10,
  numReps = 20,
  null = FALSE,
  meanVariance = FALSE,
  allelic = FALSE,
  diffAI = FALSE,
  dynamicAI = FALSE
)
}
\arguments{
\item{m}{number of genes}

\item{n}{number of samples}

\item{numReps}{how many inferential replicates to generate}

\item{null}{logical, whether to make an all null dataset}

\item{meanVariance}{logical, whether to output only mean and
variance of inferential replicates}

\item{allelic}{logical, whether to make an allelic sim dataset}

\item{diffAI}{logical, whether to make a differential allelic sim dataset}

\item{dynamicAI}{logical, whether to make a dynamic allelic sim dataset}
}
\value{
a SummarizedExperiment
}
\description{
Makes a small swish dataset for examples and testing.
The first six genes have some differential expression
evidence in the counts, with varying degree of inferential
variance across inferential replicates (1-2: minor,
3-4: some, 5-6: substantial). The 7th and 8th
genes have all zeros to demonstrate \code{labelKeep}.
}
\examples{

library(SummarizedExperiment)
y <- makeSimSwishData()
assayNames(y)

}
