; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='require<profile-summary>,function(codegenprepare)' -S -mtriple=x86_64-linux < %s | FileCheck %s

define i32 @test1(ptr %d) nounwind {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L:%.*]] = load i8, ptr [[D:%.*]], align 1
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i8 [[L]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[TMP0]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
entry:
  %l = load i8, ptr %d
  %cmp = icmp eq i8 %l, 0
  br i1 %cmp, label %exit, label %if.end

if.end:
  %gep = getelementptr i8, ptr %d, i32 42
  %call = call i64 @foo(ptr %gep) nounwind readonly willreturn
  %cmp2 = icmp ne i64 %call, 0
  call void @llvm.assume(i1 %cmp2)
  br label %exit

exit:
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @test2(i32 %N) nounwind {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_INC:%.*]], [[HEADER]] ]
; CHECK-NEXT:    [[IV_INC]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[IV]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[EXIT:%.*]], label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[IV]]
;
entry:
  br label %header

header:
  %iv = phi i32 [0, %entry], [%iv.inc, %header]
  %iv2 = phi i32 [0, %entry], [%iv2.inc, %header]
  %iv.inc = add i32 %iv, 1
  %iv2.inc = add i32 %iv2, 1
  %cmp = icmp eq i32 %iv, %N
  %cmp2 = icmp sle i32 %iv2, %N
  call void @llvm.assume(i1 %cmp2)
  br i1 %cmp, label %exit, label %header

exit:
  ret i32 %iv
}

define i32 @test3(i32 %N) nounwind {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_INC:%.*]], [[HEADER]] ]
; CHECK-NEXT:    [[IV_INC]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[IV]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[EXIT:%.*]], label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[IV]]
;
entry:
  br label %header

header:
  %iv = phi i32 [0, %entry], [%iv.inc, %header]
  %iv2 = phi i32 [0, %entry], [%iv2.inc, %header]
  %iv.inc = add i32 %iv, 1
  %iv2.inc = add i32 %iv2, 1
  %cmp = icmp eq i32 %iv, %N
  %cmp2 = icmp sle i32 %iv2.inc, %N
  call void @llvm.assume(i1 %cmp2)
  br i1 %cmp, label %exit, label %header

exit:
  ret i32 %iv
}

; Two assumes case.
define i32 @test4(i32 %N) nounwind {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_INC:%.*]], [[HEADER]] ]
; CHECK-NEXT:    [[IV_INC]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[IV]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[EXIT:%.*]], label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[IV]]
;
entry:
  br label %header

header:
  %iv = phi i32 [0, %entry], [%iv.inc, %header]
  %iv2 = phi i32 [0, %entry], [%iv2.inc, %header]
  %iv.inc = add i32 %iv, 1
  %iv2.inc = add i32 %iv2, 1
  %cmp = icmp eq i32 %iv, %N
  %cmp2 = icmp sle i32 %iv2.inc, %N
  call void @llvm.assume(i1 %cmp2)
  %cmp3 = icmp sge i32 %iv2.inc, 0
  call void @llvm.assume(i1 %cmp3)
  br i1 %cmp, label %exit, label %header

exit:
  ret i32 %iv
}

; phi is used in assume and in compare.
define i32 @test5(i32 %N, i32 %M) nounwind {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_INC:%.*]], [[HEADER]] ]
; CHECK-NEXT:    [[IV2:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[IV2_INC:%.*]], [[HEADER]] ]
; CHECK-NEXT:    [[IV_INC]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[IV2_INC]] = add i32 [[IV2]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[IV]], [[N:%.*]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sge i32 [[IV2_INC]], [[M:%.*]]
; CHECK-NEXT:    [[CMP4:%.*]] = and i1 [[CMP]], [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP4]], label [[EXIT:%.*]], label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[IV]]
;
entry:
  br label %header

header:
  %iv = phi i32 [0, %entry], [%iv.inc, %header]
  %iv2 = phi i32 [0, %entry], [%iv2.inc, %header]
  %iv.inc = add i32 %iv, 1
  %iv2.inc = add i32 %iv2, 1
  %cmp = icmp eq i32 %iv, %N
  %cmp2 = icmp sle i32 %iv2.inc, %N
  call void @llvm.assume(i1 %cmp2)
  %cmp3 = icmp sge i32 %iv2.inc, %M
  %cmp4 = and i1 %cmp, %cmp3
  br i1 %cmp4, label %exit, label %header

exit:
  ret i32 %iv
}

declare i64 @foo(ptr) nounwind readonly willreturn
declare void @llvm.assume(i1 noundef) nounwind willreturn
