// RUN: %run_test hipify "%s" "%t" %hipify_args 2 --skip-excluded-preprocessor-conditional-blocks --experimental %clang_args -D__CUDA_API_VERSION_INTERNAL

// CHECK: #include <hip/hip_runtime.h>
#include <cuda.h>
#include <stdio.h>
#if defined(_WIN32)
  #include "windows.h"
  #include <GL/glew.h>
#endif
#include "cudaGL.h"

int main() {
  printf("02. CUDA Driver API Enums synthetic test\n");

  // CHECK: HIPaddress_mode address_mode;
  // CHECK-NEXT: HIPaddress_mode_enum address_mode_enum;
  // CHECK-NEXT: HIPaddress_mode TR_ADDRESS_MODE_WRAP = HIP_TR_ADDRESS_MODE_WRAP;
  // CHECK-NEXT: HIPaddress_mode TR_ADDRESS_MODE_CLAMP = HIP_TR_ADDRESS_MODE_CLAMP;
  // CHECK-NEXT: HIPaddress_mode TR_ADDRESS_MODE_MIRROR = HIP_TR_ADDRESS_MODE_MIRROR;
  // CHECK-NEXT: HIPaddress_mode TR_ADDRESS_MODE_BORDER = HIP_TR_ADDRESS_MODE_BORDER;
  CUaddress_mode address_mode;
  CUaddress_mode_enum address_mode_enum;
  CUaddress_mode TR_ADDRESS_MODE_WRAP = CU_TR_ADDRESS_MODE_WRAP;
  CUaddress_mode TR_ADDRESS_MODE_CLAMP = CU_TR_ADDRESS_MODE_CLAMP;
  CUaddress_mode TR_ADDRESS_MODE_MIRROR = CU_TR_ADDRESS_MODE_MIRROR;
  CUaddress_mode TR_ADDRESS_MODE_BORDER = CU_TR_ADDRESS_MODE_BORDER;

  // CHECK: hipArray_Format array_format;
  // CHECK-NEXT: hipArray_Format array_format_enum;
  // CHECK-NEXT: hipArray_Format AD_FORMAT_UNSIGNED_INT8 = HIP_AD_FORMAT_UNSIGNED_INT8;
  // CHECK-NEXT: hipArray_Format AD_FORMAT_UNSIGNED_INT16 = HIP_AD_FORMAT_UNSIGNED_INT16;
  // CHECK-NEXT: hipArray_Format AD_FORMAT_UNSIGNED_INT32 = HIP_AD_FORMAT_UNSIGNED_INT32;
  // CHECK-NEXT: hipArray_Format AD_FORMAT_SIGNED_INT8 = HIP_AD_FORMAT_SIGNED_INT8;
  // CHECK-NEXT: hipArray_Format AD_FORMAT_SIGNED_INT16 = HIP_AD_FORMAT_SIGNED_INT16;
  // CHECK-NEXT: hipArray_Format AD_FORMAT_SIGNED_INT32 = HIP_AD_FORMAT_SIGNED_INT32;
  // CHECK-NEXT: hipArray_Format AD_FORMAT_HALF = HIP_AD_FORMAT_HALF;
  // CHECK-NEXT: hipArray_Format AD_FORMAT_FLOAT = HIP_AD_FORMAT_FLOAT;
  CUarray_format array_format;
  CUarray_format_enum array_format_enum;
  CUarray_format AD_FORMAT_UNSIGNED_INT8 = CU_AD_FORMAT_UNSIGNED_INT8;
  CUarray_format AD_FORMAT_UNSIGNED_INT16 = CU_AD_FORMAT_UNSIGNED_INT16;
  CUarray_format AD_FORMAT_UNSIGNED_INT32 = CU_AD_FORMAT_UNSIGNED_INT32;
  CUarray_format AD_FORMAT_SIGNED_INT8 = CU_AD_FORMAT_SIGNED_INT8;
  CUarray_format AD_FORMAT_SIGNED_INT16 = CU_AD_FORMAT_SIGNED_INT16;
  CUarray_format AD_FORMAT_SIGNED_INT32 = CU_AD_FORMAT_SIGNED_INT32;
  CUarray_format AD_FORMAT_HALF = CU_AD_FORMAT_HALF;
  CUarray_format AD_FORMAT_FLOAT = CU_AD_FORMAT_FLOAT;

  // CHECK: hipComputeMode computemode;
  // CHECK-NEXT: hipComputeMode computemode_enum;
  // CHECK-NEXT: hipComputeMode COMPUTEMODE_DEFAULT = hipComputeModeDefault;
  // hipComputeMode COMPUTEMODE_EXCLUSIVE = hipComputeModeExclusive; // CUDA_REMOVED since CUDA_80
  CUcomputemode computemode;
  CUcomputemode_enum computemode_enum;
  CUcomputemode COMPUTEMODE_DEFAULT = CU_COMPUTEMODE_DEFAULT;
  // CUcomputemode COMPUTEMODE_EXCLUSIVE = CU_COMPUTEMODE_EXCLUSIVE; // CUDA_REMOVED since CUDA_80
  // CHECK: hipComputeMode COMPUTEMODE_PROHIBITED = hipComputeModeProhibited;
  // CHECK-NEXT: hipComputeMode COMPUTEMODE_EXCLUSIVE_PROCESS = hipComputeModeExclusiveProcess;
  CUcomputemode COMPUTEMODE_PROHIBITED = CU_COMPUTEMODE_PROHIBITED;
  CUcomputemode COMPUTEMODE_EXCLUSIVE_PROCESS = CU_COMPUTEMODE_EXCLUSIVE_PROCESS;

  // CHECK: int CTX_SCHED_AUTO = hipDeviceScheduleAuto;
  // CHECK-NEXT: int CTX_SCHED_SPIN = hipDeviceScheduleSpin;
  // CHECK-NEXT: int CTX_SCHED_YIELD = hipDeviceScheduleYield;
  // CHECK-NEXT: int CTX_SCHED_BLOCKING_SYNC = hipDeviceScheduleBlockingSync;
  // CHECK-NEXT: int CTX_BLOCKING_SYNC = hipDeviceScheduleBlockingSync;
  // CHECK-NEXT: int CTX_SCHED_MASK = hipDeviceScheduleMask;
  // CHECK-NEXT: int CTX_MAP_HOST = hipDeviceMapHost;
  // CHECK-NEXT: int CTX_LMEM_RESIZE_TO_MAX = hipDeviceLmemResizeToMax;
  int CTX_SCHED_AUTO = CU_CTX_SCHED_AUTO;
  int CTX_SCHED_SPIN = CU_CTX_SCHED_SPIN;
  int CTX_SCHED_YIELD = CU_CTX_SCHED_YIELD;
  int CTX_SCHED_BLOCKING_SYNC = CU_CTX_SCHED_BLOCKING_SYNC;
  int CTX_BLOCKING_SYNC = CU_CTX_BLOCKING_SYNC;
  int CTX_SCHED_MASK = CU_CTX_SCHED_MASK;
  int CTX_MAP_HOST = CU_CTX_MAP_HOST;
  int CTX_LMEM_RESIZE_TO_MAX = CU_CTX_LMEM_RESIZE_TO_MAX;

  // CHECK: hipDeviceAttribute_t dev_attr;
  // CHECK-NEXT: hipDeviceAttribute_t dev_attr_enum;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_THREADS_PER_BLOCK = hipDeviceAttributeMaxThreadsPerBlock;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_X = hipDeviceAttributeMaxBlockDimX;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Y = hipDeviceAttributeMaxBlockDimY;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Z = hipDeviceAttributeMaxBlockDimZ;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_GRID_DIM_X = hipDeviceAttributeMaxGridDimX;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_GRID_DIM_Y = hipDeviceAttributeMaxGridDimY;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_GRID_DIM_Z = hipDeviceAttributeMaxGridDimZ;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK = hipDeviceAttributeMaxSharedMemoryPerBlock;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_SHARED_MEMORY_PER_BLOCK = hipDeviceAttributeMaxSharedMemoryPerBlock;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_TOTAL_CONSTANT_MEMORY = hipDeviceAttributeTotalConstantMemory;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_WARP_SIZE = hipDeviceAttributeWarpSize;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_PITCH = hipDeviceAttributeMaxPitch;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_BLOCK = hipDeviceAttributeMaxRegistersPerBlock;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_REGISTERS_PER_BLOCK = hipDeviceAttributeMaxRegistersPerBlock;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_CLOCK_RATE = hipDeviceAttributeClockRate;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_TEXTURE_ALIGNMENT = hipDeviceAttributeTextureAlignment;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_GPU_OVERLAP = hipDeviceAttributeAsyncEngineCount;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT = hipDeviceAttributeMultiprocessorCount;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_KERNEL_EXEC_TIMEOUT = hipDeviceAttributeKernelExecTimeout;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_INTEGRATED = hipDeviceAttributeIntegrated;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_CAN_MAP_HOST_MEMORY = hipDeviceAttributeCanMapHostMemory;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_COMPUTE_MODE = hipDeviceAttributeComputeMode;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH = hipDeviceAttributeMaxTexture1DWidth;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_WIDTH = hipDeviceAttributeMaxTexture2DWidth;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_HEIGHT = hipDeviceAttributeMaxTexture2DHeight;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH = hipDeviceAttributeMaxTexture3DWidth;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT = hipDeviceAttributeMaxTexture3DHeight;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH = hipDeviceAttributeMaxTexture3DDepth;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_SURFACE_ALIGNMENT = hipDeviceAttributeSurfaceAlignment;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_CONCURRENT_KERNELS = hipDeviceAttributeConcurrentKernels;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_ECC_ENABLED = hipDeviceAttributeEccEnabled;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_PCI_BUS_ID = hipDeviceAttributePciBusId;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_PCI_DEVICE_ID = hipDeviceAttributePciDeviceId;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_TCC_DRIVER = hipDeviceAttributeTccDriver;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MEMORY_CLOCK_RATE = hipDeviceAttributeMemoryClockRate;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_GLOBAL_MEMORY_BUS_WIDTH = hipDeviceAttributeMemoryBusWidth;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_L2_CACHE_SIZE = hipDeviceAttributeL2CacheSize;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR = hipDeviceAttributeMaxThreadsPerMultiProcessor;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_ASYNC_ENGINE_COUNT = hipDeviceAttributeAsyncEngineCount;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING = hipDeviceAttributeUnifiedAddressing;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_WIDTH = hipDeviceAttributeMaxTexture1DLayered;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_PCI_DOMAIN_ID = hipDeviceAttributePciDomainID;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_TEXTURE_PITCH_ALIGNMENT = hipDeviceAttributeTexturePitchAlignment;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_WIDTH = hipDeviceAttributeMaxTextureCubemap;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_WIDTH = hipDeviceAttributeMaxSurface1D;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_WIDTH = hipDeviceAttributeMaxSurface2D;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_HEIGHT = hipDeviceAttributeMaxSurface2D;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH = hipDeviceAttributeMaxTexture2DLayered;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT = hipDeviceAttributeMaxTexture2DLayered;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_WIDTH = hipDeviceAttributeMaxTexture2DGather;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_HEIGHT = hipDeviceAttributeMaxTexture2DGather;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH_ALTERNATE = hipDeviceAttributeMaxTexture3DAlt;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT_ALTERNATE = hipDeviceAttributeMaxTexture3DAlt;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH_ALTERNATE = hipDeviceAttributeMaxTexture3DAlt;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_WIDTH = hipDeviceAttributeMaxSurface3D;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_HEIGHT = hipDeviceAttributeMaxSurface3D;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_DEPTH = hipDeviceAttributeMaxSurface3D;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_WIDTH = hipDeviceAttributeMaxSurface1DLayered;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_WIDTH = hipDeviceAttributeMaxSurface2DLayered;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_HEIGHT = hipDeviceAttributeMaxSurface2DLayered;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_WIDTH = hipDeviceAttributeMaxSurfaceCubemap;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_WIDTH = hipDeviceAttributeMaxSurfaceCubemapLayered;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LINEAR_WIDTH = hipDeviceAttributeMaxTexture1DLinear;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_WIDTH = hipDeviceAttributeMaxTexture2DLinear;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_HEIGHT = hipDeviceAttributeMaxTexture2DLinear;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_PITCH = hipDeviceAttributeMaxTexture2DLinear;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_WIDTH = hipDeviceAttributeMaxTexture2DMipmap;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_HEIGHT = hipDeviceAttributeMaxTexture2DMipmap;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MAJOR = hipDeviceAttributeComputeCapabilityMajor;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MINOR = hipDeviceAttributeComputeCapabilityMinor;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH = hipDeviceAttributeMaxTexture1DMipmap;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_STREAM_PRIORITIES_SUPPORTED = hipDeviceAttributeStreamPrioritiesSupported;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_GLOBAL_L1_CACHE_SUPPORTED = hipDeviceAttributeGlobalL1CacheSupported;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_LOCAL_L1_CACHE_SUPPORTED = hipDeviceAttributeLocalL1CacheSupported;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR = hipDeviceAttributeMaxSharedMemoryPerMultiprocessor;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_MULTIPROCESSOR = hipDeviceAttributeMaxRegistersPerMultiprocessor;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MANAGED_MEMORY = hipDeviceAttributeManagedMemory;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MULTI_GPU_BOARD = hipDeviceAttributeIsMultiGpuBoard;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MULTI_GPU_BOARD_GROUP_ID = hipDeviceAttributeMultiGpuBoardGroupId;
  CUdevice_attribute dev_attr;
  CUdevice_attribute_enum dev_attr_enum;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_THREADS_PER_BLOCK = CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_BLOCK;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_X = CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_X;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Y = CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Y;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Z = CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Z;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_GRID_DIM_X = CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_X;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_GRID_DIM_Y = CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Y;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_GRID_DIM_Z = CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Z;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK = CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK;
  CUdevice_attribute DEVICE_ATTRIBUTE_SHARED_MEMORY_PER_BLOCK = CU_DEVICE_ATTRIBUTE_SHARED_MEMORY_PER_BLOCK;
  CUdevice_attribute DEVICE_ATTRIBUTE_TOTAL_CONSTANT_MEMORY = CU_DEVICE_ATTRIBUTE_TOTAL_CONSTANT_MEMORY;
  CUdevice_attribute DEVICE_ATTRIBUTE_WARP_SIZE = CU_DEVICE_ATTRIBUTE_WARP_SIZE;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_PITCH = CU_DEVICE_ATTRIBUTE_MAX_PITCH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_BLOCK = CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_BLOCK;
  CUdevice_attribute DEVICE_ATTRIBUTE_REGISTERS_PER_BLOCK = CU_DEVICE_ATTRIBUTE_REGISTERS_PER_BLOCK;
  CUdevice_attribute DEVICE_ATTRIBUTE_CLOCK_RATE = CU_DEVICE_ATTRIBUTE_CLOCK_RATE;
  CUdevice_attribute DEVICE_ATTRIBUTE_TEXTURE_ALIGNMENT = CU_DEVICE_ATTRIBUTE_TEXTURE_ALIGNMENT;
  CUdevice_attribute DEVICE_ATTRIBUTE_GPU_OVERLAP = CU_DEVICE_ATTRIBUTE_GPU_OVERLAP;
  CUdevice_attribute DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT = CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT;
  CUdevice_attribute DEVICE_ATTRIBUTE_KERNEL_EXEC_TIMEOUT = CU_DEVICE_ATTRIBUTE_KERNEL_EXEC_TIMEOUT;
  CUdevice_attribute DEVICE_ATTRIBUTE_INTEGRATED = CU_DEVICE_ATTRIBUTE_INTEGRATED;
  CUdevice_attribute DEVICE_ATTRIBUTE_CAN_MAP_HOST_MEMORY = CU_DEVICE_ATTRIBUTE_CAN_MAP_HOST_MEMORY;
  CUdevice_attribute DEVICE_ATTRIBUTE_COMPUTE_MODE = CU_DEVICE_ATTRIBUTE_COMPUTE_MODE;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_HEIGHT = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_HEIGHT;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_SURFACE_ALIGNMENT = CU_DEVICE_ATTRIBUTE_SURFACE_ALIGNMENT;
  CUdevice_attribute DEVICE_ATTRIBUTE_CONCURRENT_KERNELS = CU_DEVICE_ATTRIBUTE_CONCURRENT_KERNELS;
  CUdevice_attribute DEVICE_ATTRIBUTE_ECC_ENABLED = CU_DEVICE_ATTRIBUTE_ECC_ENABLED;
  CUdevice_attribute DEVICE_ATTRIBUTE_PCI_BUS_ID = CU_DEVICE_ATTRIBUTE_PCI_BUS_ID;
  CUdevice_attribute DEVICE_ATTRIBUTE_PCI_DEVICE_ID = CU_DEVICE_ATTRIBUTE_PCI_DEVICE_ID;
  CUdevice_attribute DEVICE_ATTRIBUTE_TCC_DRIVER = CU_DEVICE_ATTRIBUTE_TCC_DRIVER;
  CUdevice_attribute DEVICE_ATTRIBUTE_MEMORY_CLOCK_RATE = CU_DEVICE_ATTRIBUTE_MEMORY_CLOCK_RATE;
  CUdevice_attribute DEVICE_ATTRIBUTE_GLOBAL_MEMORY_BUS_WIDTH = CU_DEVICE_ATTRIBUTE_GLOBAL_MEMORY_BUS_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_L2_CACHE_SIZE = CU_DEVICE_ATTRIBUTE_L2_CACHE_SIZE;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR = CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR;
  CUdevice_attribute DEVICE_ATTRIBUTE_ASYNC_ENGINE_COUNT = CU_DEVICE_ATTRIBUTE_ASYNC_ENGINE_COUNT;
  CUdevice_attribute DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING = CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_PCI_DOMAIN_ID = CU_DEVICE_ATTRIBUTE_PCI_DOMAIN_ID;
  CUdevice_attribute DEVICE_ATTRIBUTE_TEXTURE_PITCH_ALIGNMENT = CU_DEVICE_ATTRIBUTE_TEXTURE_PITCH_ALIGNMENT;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_HEIGHT = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_HEIGHT;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_HEIGHT = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_HEIGHT;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH_ALTERNATE = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH_ALTERNATE;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT_ALTERNATE = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT_ALTERNATE;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH_ALTERNATE = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH_ALTERNATE;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_HEIGHT = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_HEIGHT;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_DEPTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_DEPTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_HEIGHT = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_HEIGHT;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LINEAR_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LINEAR_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_HEIGHT = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_HEIGHT;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_PITCH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_PITCH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_HEIGHT = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_HEIGHT;
  CUdevice_attribute DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MAJOR = CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MAJOR;
  CUdevice_attribute DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MINOR = CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MINOR;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH = CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH;
  CUdevice_attribute DEVICE_ATTRIBUTE_STREAM_PRIORITIES_SUPPORTED = CU_DEVICE_ATTRIBUTE_STREAM_PRIORITIES_SUPPORTED;
  CUdevice_attribute DEVICE_ATTRIBUTE_GLOBAL_L1_CACHE_SUPPORTED = CU_DEVICE_ATTRIBUTE_GLOBAL_L1_CACHE_SUPPORTED;
  CUdevice_attribute DEVICE_ATTRIBUTE_LOCAL_L1_CACHE_SUPPORTED = CU_DEVICE_ATTRIBUTE_LOCAL_L1_CACHE_SUPPORTED;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR = CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_MULTIPROCESSOR = CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_MULTIPROCESSOR;
  CUdevice_attribute DEVICE_ATTRIBUTE_MANAGED_MEMORY = CU_DEVICE_ATTRIBUTE_MANAGED_MEMORY;
  CUdevice_attribute DEVICE_ATTRIBUTE_MULTI_GPU_BOARD = CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD;
  CUdevice_attribute DEVICE_ATTRIBUTE_MULTI_GPU_BOARD_GROUP_ID = CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD_GROUP_ID;

  // CHECK: int EVENT_DEFAULT = hipEventDefault;
  // CHECK-NEXT: int EVENT_BLOCKING_SYNC = hipEventBlockingSync;
  // CHECK-NEXT: int EVENT_DISABLE_TIMING = hipEventDisableTiming;
  // CHECK-NEXT: int EVENT_INTERPROCESS = hipEventInterprocess;
  int EVENT_DEFAULT = CU_EVENT_DEFAULT;
  int EVENT_BLOCKING_SYNC = CU_EVENT_BLOCKING_SYNC;
  int EVENT_DISABLE_TIMING = CU_EVENT_DISABLE_TIMING;
  int EVENT_INTERPROCESS = CU_EVENT_INTERPROCESS;

  // CHECK: HIPfilter_mode filter_mode;
  // CHECK-NEXT: HIPfilter_mode_enum filter_mode_enum;
  // CHECK-NEXT: HIPfilter_mode TR_FILTER_MODE_POINT = HIP_TR_FILTER_MODE_POINT;
  // CHECK-NEXT: HIPfilter_mode TR_FILTER_MODE_LINEAR = HIP_TR_FILTER_MODE_LINEAR;
  CUfilter_mode filter_mode;
  CUfilter_mode_enum filter_mode_enum;
  CUfilter_mode TR_FILTER_MODE_POINT = CU_TR_FILTER_MODE_POINT;
  CUfilter_mode TR_FILTER_MODE_LINEAR = CU_TR_FILTER_MODE_LINEAR;

  // CHECK: hipFuncCache_t func_cache;
  // CHECK-NEXT: hipFuncCache_t func_cache_enum;
  // CHECK-NEXT: hipFuncCache_t FUNC_CACHE_PREFER_NONE = hipFuncCachePreferNone;
  // CHECK-NEXT: hipFuncCache_t FUNC_CACHE_PREFER_SHARED = hipFuncCachePreferShared;
  // CHECK-NEXT: hipFuncCache_t FUNC_CACHE_PREFER_L1 = hipFuncCachePreferL1;
  // CHECK-NEXT: hipFuncCache_t FUNC_CACHE_PREFER_EQUAL = hipFuncCachePreferEqual;
  CUfunc_cache func_cache;
  CUfunc_cache_enum func_cache_enum;
  CUfunc_cache FUNC_CACHE_PREFER_NONE = CU_FUNC_CACHE_PREFER_NONE;
  CUfunc_cache FUNC_CACHE_PREFER_SHARED = CU_FUNC_CACHE_PREFER_SHARED;
  CUfunc_cache FUNC_CACHE_PREFER_L1 = CU_FUNC_CACHE_PREFER_L1;
  CUfunc_cache FUNC_CACHE_PREFER_EQUAL = CU_FUNC_CACHE_PREFER_EQUAL;

  // CHECK: hipFunction_attribute function_attribute;
  // CHECK-NEXT: hipFunction_attribute function_attribute_enum;
  // CHECK-NEXT: hipFunction_attribute FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK = HIP_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK;
  // CHECK-NEXT: hipFunction_attribute FUNC_ATTRIBUTE_SHARED_SIZE_BYTES = HIP_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES;
  // CHECK-NEXT: hipFunction_attribute FUNC_ATTRIBUTE_CONST_SIZE_BYTES = HIP_FUNC_ATTRIBUTE_CONST_SIZE_BYTES;
  // CHECK-NEXT: hipFunction_attribute FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES = HIP_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES;
  // CHECK-NEXT: hipFunction_attribute FUNC_ATTRIBUTE_NUM_REGS = HIP_FUNC_ATTRIBUTE_NUM_REGS;
  // CHECK-NEXT: hipFunction_attribute FUNC_ATTRIBUTE_PTX_VERSION = HIP_FUNC_ATTRIBUTE_PTX_VERSION;
  // CHECK-NEXT: hipFunction_attribute FUNC_ATTRIBUTE_BINARY_VERSION = HIP_FUNC_ATTRIBUTE_BINARY_VERSION;
  // CHECK-NEXT: hipFunction_attribute FUNC_ATTRIBUTE_CACHE_MODE_CA = HIP_FUNC_ATTRIBUTE_CACHE_MODE_CA;
  // CHECK-NEXT: hipFunction_attribute FUNC_ATTRIBUTE_MAX = HIP_FUNC_ATTRIBUTE_MAX;
  CUfunction_attribute function_attribute;
  CUfunction_attribute_enum function_attribute_enum;
  CUfunction_attribute FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK = CU_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK;
  CUfunction_attribute FUNC_ATTRIBUTE_SHARED_SIZE_BYTES = CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES;
  CUfunction_attribute FUNC_ATTRIBUTE_CONST_SIZE_BYTES = CU_FUNC_ATTRIBUTE_CONST_SIZE_BYTES;
  CUfunction_attribute FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES = CU_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES;
  CUfunction_attribute FUNC_ATTRIBUTE_NUM_REGS = CU_FUNC_ATTRIBUTE_NUM_REGS;
  CUfunction_attribute FUNC_ATTRIBUTE_PTX_VERSION = CU_FUNC_ATTRIBUTE_PTX_VERSION;
  CUfunction_attribute FUNC_ATTRIBUTE_BINARY_VERSION = CU_FUNC_ATTRIBUTE_BINARY_VERSION;
  CUfunction_attribute FUNC_ATTRIBUTE_CACHE_MODE_CA = CU_FUNC_ATTRIBUTE_CACHE_MODE_CA;
  CUfunction_attribute FUNC_ATTRIBUTE_MAX = CU_FUNC_ATTRIBUTE_MAX;

  // CHECK: hipGraphicsRegisterFlags graphicsRegisterFlags;
  // CHECK-NEXT: hipGraphicsRegisterFlags graphicsRegisterFlags_enum;
  // CHECK-NEXT: hipGraphicsRegisterFlags GRAPHICS_REGISTER_FLAGS_NONE = hipGraphicsRegisterFlagsNone;
  // CHECK-NEXT: hipGraphicsRegisterFlags GRAPHICS_REGISTER_FLAGS_READ_ONLY = hipGraphicsRegisterFlagsReadOnly;
  // CHECK-NEXT: hipGraphicsRegisterFlags GRAPHICS_REGISTER_FLAGS_WRITE_DISCARD = hipGraphicsRegisterFlagsWriteDiscard;
  // CHECK-NEXT: hipGraphicsRegisterFlags GRAPHICS_REGISTER_FLAGS_SURFACE_LDST = hipGraphicsRegisterFlagsSurfaceLoadStore;
  // CHECK-NEXT: hipGraphicsRegisterFlags GRAPHICS_REGISTER_FLAGS_TEXTURE_GATHER = hipGraphicsRegisterFlagsTextureGather;
  CUgraphicsRegisterFlags graphicsRegisterFlags;
  CUgraphicsRegisterFlags_enum graphicsRegisterFlags_enum;
  CUgraphicsRegisterFlags GRAPHICS_REGISTER_FLAGS_NONE = CU_GRAPHICS_REGISTER_FLAGS_NONE;
  CUgraphicsRegisterFlags GRAPHICS_REGISTER_FLAGS_READ_ONLY = CU_GRAPHICS_REGISTER_FLAGS_READ_ONLY;
  CUgraphicsRegisterFlags GRAPHICS_REGISTER_FLAGS_WRITE_DISCARD = CU_GRAPHICS_REGISTER_FLAGS_WRITE_DISCARD;
  CUgraphicsRegisterFlags GRAPHICS_REGISTER_FLAGS_SURFACE_LDST = CU_GRAPHICS_REGISTER_FLAGS_SURFACE_LDST;
  CUgraphicsRegisterFlags GRAPHICS_REGISTER_FLAGS_TEXTURE_GATHER = CU_GRAPHICS_REGISTER_FLAGS_TEXTURE_GATHER;

  // CHECK: int IPC_MEM_LAZY_ENABLE_PEER_ACCESS = hipIpcMemLazyEnablePeerAccess;
  int IPC_MEM_LAZY_ENABLE_PEER_ACCESS = CU_IPC_MEM_LAZY_ENABLE_PEER_ACCESS;

  // CHECK: hipJitOption jit_option;
  // CHECK-NEXT: hipJitOption jit_option_enum;
  // CHECK-NEXT: hipJitOption JIT_MAX_REGISTERS = HIPRTC_JIT_MAX_REGISTERS;
  // CHECK-NEXT: hipJitOption JIT_THREADS_PER_BLOCK = HIPRTC_JIT_THREADS_PER_BLOCK;
  // CHECK-NEXT: hipJitOption JIT_WALL_TIME = HIPRTC_JIT_WALL_TIME;
  // CHECK-NEXT: hipJitOption JIT_INFO_LOG_BUFFER = HIPRTC_JIT_INFO_LOG_BUFFER;
  // CHECK-NEXT: hipJitOption JIT_INFO_LOG_BUFFER_SIZE_BYTES = HIPRTC_JIT_INFO_LOG_BUFFER_SIZE_BYTES;
  // CHECK-NEXT: hipJitOption JIT_ERROR_LOG_BUFFER = HIPRTC_JIT_ERROR_LOG_BUFFER;
  // CHECK-NEXT: hipJitOption JIT_ERROR_LOG_BUFFER_SIZE_BYTES = HIPRTC_JIT_ERROR_LOG_BUFFER_SIZE_BYTES;
  // CHECK-NEXT: hipJitOption JIT_OPTIMIZATION_LEVEL = HIPRTC_JIT_OPTIMIZATION_LEVEL;
  // CHECK-NEXT: hipJitOption JIT_TARGET_FROM_CUCONTEXT = HIPRTC_JIT_TARGET_FROM_HIPCONTEXT;
  // CHECK-NEXT: hipJitOption JIT_TARGET = HIPRTC_JIT_TARGET;
  // CHECK-NEXT: hipJitOption JIT_FALLBACK_STRATEGY = HIPRTC_JIT_FALLBACK_STRATEGY;
  // CHECK-NEXT: hipJitOption JIT_GENERATE_DEBUG_INFO = HIPRTC_JIT_GENERATE_DEBUG_INFO;
  // CHECK-NEXT: hipJitOption JIT_LOG_VERBOSE = HIPRTC_JIT_LOG_VERBOSE;
  // CHECK-NEXT: hipJitOption JIT_GENERATE_LINE_INFO = HIPRTC_JIT_GENERATE_LINE_INFO;
  // CHECK-NEXT: hipJitOption JIT_CACHE_MODE = HIPRTC_JIT_CACHE_MODE;
  CUjit_option jit_option;
  CUjit_option_enum jit_option_enum;
  CUjit_option JIT_MAX_REGISTERS = CU_JIT_MAX_REGISTERS;
  CUjit_option JIT_THREADS_PER_BLOCK = CU_JIT_THREADS_PER_BLOCK;
  CUjit_option JIT_WALL_TIME = CU_JIT_WALL_TIME;
  CUjit_option JIT_INFO_LOG_BUFFER = CU_JIT_INFO_LOG_BUFFER;
  CUjit_option JIT_INFO_LOG_BUFFER_SIZE_BYTES = CU_JIT_INFO_LOG_BUFFER_SIZE_BYTES;
  CUjit_option JIT_ERROR_LOG_BUFFER = CU_JIT_ERROR_LOG_BUFFER;
  CUjit_option JIT_ERROR_LOG_BUFFER_SIZE_BYTES = CU_JIT_ERROR_LOG_BUFFER_SIZE_BYTES;
  CUjit_option JIT_OPTIMIZATION_LEVEL = CU_JIT_OPTIMIZATION_LEVEL;
  CUjit_option JIT_TARGET_FROM_CUCONTEXT = CU_JIT_TARGET_FROM_CUCONTEXT;
  CUjit_option JIT_TARGET = CU_JIT_TARGET;
  CUjit_option JIT_FALLBACK_STRATEGY = CU_JIT_FALLBACK_STRATEGY;
  CUjit_option JIT_GENERATE_DEBUG_INFO = CU_JIT_GENERATE_DEBUG_INFO;
  CUjit_option JIT_LOG_VERBOSE = CU_JIT_LOG_VERBOSE;
  CUjit_option JIT_GENERATE_LINE_INFO = CU_JIT_GENERATE_LINE_INFO;
  CUjit_option JIT_CACHE_MODE = CU_JIT_CACHE_MODE;

  // CHECK: hipJitOption JIT_NUM_OPTIONS = HIPRTC_JIT_NUM_OPTIONS;
  CUjit_option JIT_NUM_OPTIONS = CU_JIT_NUM_OPTIONS;

  // CHECK: hipLimit_t limit;
  // CHECK-NEXT: hipLimit_t limit_enum;
  // CHECK-NEXT: hipLimit_t LIMIT_STACK_SIZE = hipLimitStackSize;
  // CHECK-NEXT: hipLimit_t LIMIT_PRINTF_FIFO_SIZE = hipLimitPrintfFifoSize;
  // CHECK-NEXT: hipLimit_t LIMIT_MALLOC_HEAP_SIZE = hipLimitMallocHeapSize;
  CUlimit limit;
  CUlimit_enum limit_enum;
  CUlimit LIMIT_STACK_SIZE = CU_LIMIT_STACK_SIZE;
  CUlimit LIMIT_PRINTF_FIFO_SIZE = CU_LIMIT_PRINTF_FIFO_SIZE;
  CUlimit LIMIT_MALLOC_HEAP_SIZE = CU_LIMIT_MALLOC_HEAP_SIZE;

  // CHECK: int MEM_ATTACH_GLOBAL = hipMemAttachGlobal;
  // CHECK-NEXT: int MEM_ATTACH_HOST = hipMemAttachHost;
  // CHECK-NEXT: int MEM_ATTACH_SINGLE = hipMemAttachSingle;
  int MEM_ATTACH_GLOBAL = CU_MEM_ATTACH_GLOBAL;
  int MEM_ATTACH_HOST = CU_MEM_ATTACH_HOST;
  int MEM_ATTACH_SINGLE = CU_MEM_ATTACH_SINGLE;

  // CHECK: hipPointer_attribute pointer_attribute;
  // CHECK: hipPointer_attribute pointer_attribute_enum;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_CONTEXT = HIP_POINTER_ATTRIBUTE_CONTEXT;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_MEMORY_TYPE = HIP_POINTER_ATTRIBUTE_MEMORY_TYPE;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_DEVICE_POINTER = HIP_POINTER_ATTRIBUTE_DEVICE_POINTER;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_HOST_POINTER = HIP_POINTER_ATTRIBUTE_HOST_POINTER;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_P2P_TOKENS = HIP_POINTER_ATTRIBUTE_P2P_TOKENS;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_SYNC_MEMOPS = HIP_POINTER_ATTRIBUTE_SYNC_MEMOPS;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_BUFFER_ID = HIP_POINTER_ATTRIBUTE_BUFFER_ID;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_IS_MANAGED = HIP_POINTER_ATTRIBUTE_IS_MANAGED;
  CUpointer_attribute pointer_attribute;
  CUpointer_attribute_enum pointer_attribute_enum;
  CUpointer_attribute POINTER_ATTRIBUTE_CONTEXT = CU_POINTER_ATTRIBUTE_CONTEXT;
  CUpointer_attribute POINTER_ATTRIBUTE_MEMORY_TYPE = CU_POINTER_ATTRIBUTE_MEMORY_TYPE;
  CUpointer_attribute POINTER_ATTRIBUTE_DEVICE_POINTER = CU_POINTER_ATTRIBUTE_DEVICE_POINTER;
  CUpointer_attribute POINTER_ATTRIBUTE_HOST_POINTER = CU_POINTER_ATTRIBUTE_HOST_POINTER;
  CUpointer_attribute POINTER_ATTRIBUTE_P2P_TOKENS = CU_POINTER_ATTRIBUTE_P2P_TOKENS;
  CUpointer_attribute POINTER_ATTRIBUTE_SYNC_MEMOPS = CU_POINTER_ATTRIBUTE_SYNC_MEMOPS;
  CUpointer_attribute POINTER_ATTRIBUTE_BUFFER_ID = CU_POINTER_ATTRIBUTE_BUFFER_ID;
  CUpointer_attribute POINTER_ATTRIBUTE_IS_MANAGED = CU_POINTER_ATTRIBUTE_IS_MANAGED;

  // CHECK: int OCCUPANCY_DEFAULT = hipOccupancyDefault;
  // CHECK-NEXT: int OCCUPANCY_DISABLE_CACHING_OVERRIDE = hipOccupancyDisableCachingOverride;
  int OCCUPANCY_DEFAULT = CU_OCCUPANCY_DEFAULT;
  int OCCUPANCY_DISABLE_CACHING_OVERRIDE = CU_OCCUPANCY_DISABLE_CACHING_OVERRIDE;

  // CHECK: HIPresourcetype resourcetype;
  // CHECK-NEXT: HIPresourcetype_enum resourcetype_enum;
  // CHECK-NEXT: HIPresourcetype RESOURCE_TYPE_ARRAY = HIP_RESOURCE_TYPE_ARRAY;
  // CHECK-NEXT: HIPresourcetype RESOURCE_TYPE_MIPMAPPED_ARRAY = HIP_RESOURCE_TYPE_MIPMAPPED_ARRAY;
  // CHECK-NEXT: HIPresourcetype RESOURCE_TYPE_LINEAR = HIP_RESOURCE_TYPE_LINEAR;
  // CHECK-NEXT: HIPresourcetype RESOURCE_TYPE_PITCH2D = HIP_RESOURCE_TYPE_PITCH2D;
  CUresourcetype resourcetype;
  CUresourcetype_enum resourcetype_enum;
  CUresourcetype RESOURCE_TYPE_ARRAY = CU_RESOURCE_TYPE_ARRAY;
  CUresourcetype RESOURCE_TYPE_MIPMAPPED_ARRAY = CU_RESOURCE_TYPE_MIPMAPPED_ARRAY;
  CUresourcetype RESOURCE_TYPE_LINEAR = CU_RESOURCE_TYPE_LINEAR;
  CUresourcetype RESOURCE_TYPE_PITCH2D = CU_RESOURCE_TYPE_PITCH2D;

  // CHECK: HIPresourceViewFormat resourceViewFormat;
  // CHECK-NEXT: HIPresourceViewFormat_enum resourceViewFormat_enum;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_NONE = HIP_RES_VIEW_FORMAT_NONE;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UINT_1X8 = HIP_RES_VIEW_FORMAT_UINT_1X8;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UINT_2X8 = HIP_RES_VIEW_FORMAT_UINT_2X8;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UINT_4X8 = HIP_RES_VIEW_FORMAT_UINT_4X8;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SINT_1X8 = HIP_RES_VIEW_FORMAT_SINT_1X8;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SINT_2X8 = HIP_RES_VIEW_FORMAT_SINT_2X8;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SINT_4X8 = HIP_RES_VIEW_FORMAT_SINT_4X8;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UINT_1X16 = HIP_RES_VIEW_FORMAT_UINT_1X16;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UINT_2X16 = HIP_RES_VIEW_FORMAT_UINT_2X16;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UINT_4X16 = HIP_RES_VIEW_FORMAT_UINT_4X16;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SINT_1X16 = HIP_RES_VIEW_FORMAT_SINT_1X16;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SINT_2X16 = HIP_RES_VIEW_FORMAT_SINT_2X16;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SINT_4X16 = HIP_RES_VIEW_FORMAT_SINT_4X16;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UINT_1X32 = HIP_RES_VIEW_FORMAT_UINT_1X32;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UINT_2X32 = HIP_RES_VIEW_FORMAT_UINT_2X32;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UINT_4X32 = HIP_RES_VIEW_FORMAT_UINT_4X32;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SINT_1X32 = HIP_RES_VIEW_FORMAT_SINT_1X32;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SINT_2X32 = HIP_RES_VIEW_FORMAT_SINT_2X32;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SINT_4X32 = HIP_RES_VIEW_FORMAT_SINT_4X32;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_FLOAT_1X16 = HIP_RES_VIEW_FORMAT_FLOAT_1X16;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_FLOAT_2X16 = HIP_RES_VIEW_FORMAT_FLOAT_2X16;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_FLOAT_4X16 = HIP_RES_VIEW_FORMAT_FLOAT_4X16;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_FLOAT_1X32 = HIP_RES_VIEW_FORMAT_FLOAT_1X32;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_FLOAT_2X32 = HIP_RES_VIEW_FORMAT_FLOAT_2X32;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_FLOAT_4X32 = HIP_RES_VIEW_FORMAT_FLOAT_4X32;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC1 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC1;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC2 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC2;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC3 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC3;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC4 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC4;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SIGNED_BC4 = HIP_RES_VIEW_FORMAT_SIGNED_BC4;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC5 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC5;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SIGNED_BC5 = HIP_RES_VIEW_FORMAT_SIGNED_BC5;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC6H = HIP_RES_VIEW_FORMAT_UNSIGNED_BC6H;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_SIGNED_BC6H = HIP_RES_VIEW_FORMAT_SIGNED_BC6H;
  // CHECK-NEXT: HIPresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC7 = HIP_RES_VIEW_FORMAT_UNSIGNED_BC7;
  CUresourceViewFormat resourceViewFormat;
  CUresourceViewFormat_enum resourceViewFormat_enum;
  CUresourceViewFormat RES_VIEW_FORMAT_NONE = CU_RES_VIEW_FORMAT_NONE;
  CUresourceViewFormat RES_VIEW_FORMAT_UINT_1X8 = CU_RES_VIEW_FORMAT_UINT_1X8;
  CUresourceViewFormat RES_VIEW_FORMAT_UINT_2X8 = CU_RES_VIEW_FORMAT_UINT_2X8;
  CUresourceViewFormat RES_VIEW_FORMAT_UINT_4X8 = CU_RES_VIEW_FORMAT_UINT_4X8;
  CUresourceViewFormat RES_VIEW_FORMAT_SINT_1X8 = CU_RES_VIEW_FORMAT_SINT_1X8;
  CUresourceViewFormat RES_VIEW_FORMAT_SINT_2X8 = CU_RES_VIEW_FORMAT_SINT_2X8;
  CUresourceViewFormat RES_VIEW_FORMAT_SINT_4X8 = CU_RES_VIEW_FORMAT_SINT_4X8;
  CUresourceViewFormat RES_VIEW_FORMAT_UINT_1X16 = CU_RES_VIEW_FORMAT_UINT_1X16;
  CUresourceViewFormat RES_VIEW_FORMAT_UINT_2X16 = CU_RES_VIEW_FORMAT_UINT_2X16;
  CUresourceViewFormat RES_VIEW_FORMAT_UINT_4X16 = CU_RES_VIEW_FORMAT_UINT_4X16;
  CUresourceViewFormat RES_VIEW_FORMAT_SINT_1X16 = CU_RES_VIEW_FORMAT_SINT_1X16;
  CUresourceViewFormat RES_VIEW_FORMAT_SINT_2X16 = CU_RES_VIEW_FORMAT_SINT_2X16;
  CUresourceViewFormat RES_VIEW_FORMAT_SINT_4X16 = CU_RES_VIEW_FORMAT_SINT_4X16;
  CUresourceViewFormat RES_VIEW_FORMAT_UINT_1X32 = CU_RES_VIEW_FORMAT_UINT_1X32;
  CUresourceViewFormat RES_VIEW_FORMAT_UINT_2X32 = CU_RES_VIEW_FORMAT_UINT_2X32;
  CUresourceViewFormat RES_VIEW_FORMAT_UINT_4X32 = CU_RES_VIEW_FORMAT_UINT_4X32;
  CUresourceViewFormat RES_VIEW_FORMAT_SINT_1X32 = CU_RES_VIEW_FORMAT_SINT_1X32;
  CUresourceViewFormat RES_VIEW_FORMAT_SINT_2X32 = CU_RES_VIEW_FORMAT_SINT_2X32;
  CUresourceViewFormat RES_VIEW_FORMAT_SINT_4X32 = CU_RES_VIEW_FORMAT_SINT_4X32;
  CUresourceViewFormat RES_VIEW_FORMAT_FLOAT_1X16 = CU_RES_VIEW_FORMAT_FLOAT_1X16;
  CUresourceViewFormat RES_VIEW_FORMAT_FLOAT_2X16 = CU_RES_VIEW_FORMAT_FLOAT_2X16;
  CUresourceViewFormat RES_VIEW_FORMAT_FLOAT_4X16 = CU_RES_VIEW_FORMAT_FLOAT_4X16;
  CUresourceViewFormat RES_VIEW_FORMAT_FLOAT_1X32 = CU_RES_VIEW_FORMAT_FLOAT_1X32;
  CUresourceViewFormat RES_VIEW_FORMAT_FLOAT_2X32 = CU_RES_VIEW_FORMAT_FLOAT_2X32;
  CUresourceViewFormat RES_VIEW_FORMAT_FLOAT_4X32 = CU_RES_VIEW_FORMAT_FLOAT_4X32;
  CUresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC1 = CU_RES_VIEW_FORMAT_UNSIGNED_BC1;
  CUresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC2 = CU_RES_VIEW_FORMAT_UNSIGNED_BC2;
  CUresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC3 = CU_RES_VIEW_FORMAT_UNSIGNED_BC3;
  CUresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC4 = CU_RES_VIEW_FORMAT_UNSIGNED_BC4;
  CUresourceViewFormat RES_VIEW_FORMAT_SIGNED_BC4 = CU_RES_VIEW_FORMAT_SIGNED_BC4;
  CUresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC5 = CU_RES_VIEW_FORMAT_UNSIGNED_BC5;
  CUresourceViewFormat RES_VIEW_FORMAT_SIGNED_BC5 = CU_RES_VIEW_FORMAT_SIGNED_BC5;
  CUresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC6H = CU_RES_VIEW_FORMAT_UNSIGNED_BC6H;
  CUresourceViewFormat RES_VIEW_FORMAT_SIGNED_BC6H = CU_RES_VIEW_FORMAT_SIGNED_BC6H;
  CUresourceViewFormat RES_VIEW_FORMAT_UNSIGNED_BC7 = CU_RES_VIEW_FORMAT_UNSIGNED_BC7;

  // CHECK: hipError_t result;
  // CHECK-NEXT: hipError_t Error_enum;
  // CHECK-NEXT: hipError_t SUCCESS = hipSuccess;
  // CHECK-NEXT: hipError_t ERROR_INVALID_VALUE = hipErrorInvalidValue;
  // CHECK-NEXT: hipError_t ERROR_OUT_OF_MEMORY = hipErrorOutOfMemory;
  // CHECK-NEXT: hipError_t ERROR_NOT_INITIALIZED = hipErrorNotInitialized;
  // CHECK-NEXT: hipError_t ERROR_DEINITIALIZED = hipErrorDeinitialized;
  // CHECK-NEXT: hipError_t ERROR_PROFILER_DISABLED = hipErrorProfilerDisabled;
  // CHECK-NEXT: hipError_t ERROR_PROFILER_NOT_INITIALIZED = hipErrorProfilerNotInitialized;
  // CHECK-NEXT: hipError_t ERROR_PROFILER_ALREADY_STARTED = hipErrorProfilerAlreadyStarted;
  // CHECK-NEXT: hipError_t ERROR_PROFILER_ALREADY_STOPPED = hipErrorProfilerAlreadyStopped;
  // CHECK-NEXT: hipError_t ERROR_NO_DEVICE = hipErrorNoDevice;
  // CHECK-NEXT: hipError_t ERROR_INVALID_DEVICE = hipErrorInvalidDevice;
  // CHECK-NEXT: hipError_t ERROR_INVALID_IMAGE = hipErrorInvalidImage;
  // CHECK-NEXT: hipError_t ERROR_INVALID_CONTEXT = hipErrorInvalidContext;
  // CHECK-NEXT: hipError_t ERROR_CONTEXT_ALREADY_CURRENT = hipErrorContextAlreadyCurrent;
  // CHECK-NEXT: hipError_t ERROR_MAP_FAILED = hipErrorMapFailed;
  // CHECK-NEXT: hipError_t ERROR_UNMAP_FAILED = hipErrorUnmapFailed;
  // CHECK-NEXT: hipError_t ERROR_ARRAY_IS_MAPPED = hipErrorArrayIsMapped;
  // CHECK-NEXT: hipError_t ERROR_ALREADY_MAPPED = hipErrorAlreadyMapped;
  // CHECK-NEXT: hipError_t ERROR_NO_BINARY_FOR_GPU = hipErrorNoBinaryForGpu;
  // CHECK-NEXT: hipError_t ERROR_ALREADY_ACQUIRED = hipErrorAlreadyAcquired;
  // CHECK-NEXT: hipError_t ERROR_NOT_MAPPED = hipErrorNotMapped;
  // CHECK-NEXT: hipError_t ERROR_NOT_MAPPED_AS_ARRAY = hipErrorNotMappedAsArray;
  // CHECK-NEXT: hipError_t ERROR_NOT_MAPPED_AS_POINTER = hipErrorNotMappedAsPointer;
  // CHECK-NEXT: hipError_t ERROR_ECC_UNCORRECTABLE = hipErrorECCNotCorrectable;
  // CHECK-NEXT: hipError_t ERROR_UNSUPPORTED_LIMIT = hipErrorUnsupportedLimit;
  // CHECK-NEXT: hipError_t ERROR_CONTEXT_ALREADY_IN_USE = hipErrorContextAlreadyInUse;
  // CHECK-NEXT: hipError_t ERROR_PEER_ACCESS_UNSUPPORTED = hipErrorPeerAccessUnsupported;
  // CHECK-NEXT: hipError_t ERROR_INVALID_PTX = hipErrorInvalidKernelFile;
  // CHECK-NEXT: hipError_t ERROR_INVALID_GRAPHICS_CONTEXT = hipErrorInvalidGraphicsContext;
  // CHECK-NEXT: hipError_t ERROR_INVALID_SOURCE = hipErrorInvalidSource;
  // CHECK-NEXT: hipError_t ERROR_FILE_NOT_FOUND_ = hipErrorFileNotFound;
  // CHECK-NEXT: hipError_t ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND = hipErrorSharedObjectSymbolNotFound;
  // CHECK-NEXT: hipError_t ERROR_SHARED_OBJECT_INIT_FAILED = hipErrorSharedObjectInitFailed;
  // CHECK-NEXT: hipError_t ERROR_OPERATING_SYSTEM = hipErrorOperatingSystem;
  // CHECK-NEXT: hipError_t ERROR_INVALID_HANDLE_ = hipErrorInvalidHandle;
  // CHECK-NEXT: hipError_t ERROR_NOT_FOUND_ = hipErrorNotFound;
  // CHECK-NEXT: hipError_t ERROR_NOT_READY_ = hipErrorNotReady;
  // CHECK-NEXT: hipError_t ERROR_ILLEGAL_ADDRESS = hipErrorIllegalAddress;
  // CHECK-NEXT: hipError_t ERROR_LAUNCH_OUT_OF_RESOURCES = hipErrorLaunchOutOfResources;
  // CHECK-NEXT: hipError_t ERROR_LAUNCH_TIMEOUT = hipErrorLaunchTimeOut;
  // CHECK-NEXT: hipError_t ERROR_PEER_ACCESS_ALREADY_ENABLED = hipErrorPeerAccessAlreadyEnabled;
  // CHECK-NEXT: hipError_t ERROR_PEER_ACCESS_NOT_ENABLED = hipErrorPeerAccessNotEnabled;
  // CHECK-NEXT: hipError_t ERROR_PRIMARY_CONTEXT_ACTIVE = hipErrorSetOnActiveProcess;
  // CHECK-NEXT: hipError_t ERROR_CONTEXT_IS_DESTROYED = hipErrorContextIsDestroyed;
  // CHECK-NEXT: hipError_t ERROR_ASSERT = hipErrorAssert;
  // CHECK-NEXT: hipError_t ERROR_HOST_MEMORY_ALREADY_REGISTERED = hipErrorHostMemoryAlreadyRegistered;
  // CHECK-NEXT: hipError_t ERROR_HOST_MEMORY_NOT_REGISTERED = hipErrorHostMemoryNotRegistered;
  // CHECK-NEXT: hipError_t ERROR_LAUNCH_FAILED = hipErrorLaunchFailure;
  // CHECK-NEXT: hipError_t ERROR_NOT_SUPPORTED_ = hipErrorNotSupported;
  CUresult result;
  cudaError_enum Error_enum;
  CUresult SUCCESS = CUDA_SUCCESS;
  CUresult ERROR_INVALID_VALUE = CUDA_ERROR_INVALID_VALUE;
  CUresult ERROR_OUT_OF_MEMORY = CUDA_ERROR_OUT_OF_MEMORY;
  CUresult ERROR_NOT_INITIALIZED = CUDA_ERROR_NOT_INITIALIZED;
  CUresult ERROR_DEINITIALIZED = CUDA_ERROR_DEINITIALIZED;
  CUresult ERROR_PROFILER_DISABLED = CUDA_ERROR_PROFILER_DISABLED;
  CUresult ERROR_PROFILER_NOT_INITIALIZED = CUDA_ERROR_PROFILER_NOT_INITIALIZED;
  CUresult ERROR_PROFILER_ALREADY_STARTED = CUDA_ERROR_PROFILER_ALREADY_STARTED;
  CUresult ERROR_PROFILER_ALREADY_STOPPED = CUDA_ERROR_PROFILER_ALREADY_STOPPED;
  CUresult ERROR_NO_DEVICE = CUDA_ERROR_NO_DEVICE;
  CUresult ERROR_INVALID_DEVICE = CUDA_ERROR_INVALID_DEVICE;
  CUresult ERROR_INVALID_IMAGE = CUDA_ERROR_INVALID_IMAGE;
  CUresult ERROR_INVALID_CONTEXT = CUDA_ERROR_INVALID_CONTEXT;
  CUresult ERROR_CONTEXT_ALREADY_CURRENT = CUDA_ERROR_CONTEXT_ALREADY_CURRENT;
  CUresult ERROR_MAP_FAILED = CUDA_ERROR_MAP_FAILED;
  CUresult ERROR_UNMAP_FAILED = CUDA_ERROR_UNMAP_FAILED;
  CUresult ERROR_ARRAY_IS_MAPPED = CUDA_ERROR_ARRAY_IS_MAPPED;
  CUresult ERROR_ALREADY_MAPPED = CUDA_ERROR_ALREADY_MAPPED;
  CUresult ERROR_NO_BINARY_FOR_GPU = CUDA_ERROR_NO_BINARY_FOR_GPU;
  CUresult ERROR_ALREADY_ACQUIRED = CUDA_ERROR_ALREADY_ACQUIRED;
  CUresult ERROR_NOT_MAPPED = CUDA_ERROR_NOT_MAPPED;
  CUresult ERROR_NOT_MAPPED_AS_ARRAY = CUDA_ERROR_NOT_MAPPED_AS_ARRAY;
  CUresult ERROR_NOT_MAPPED_AS_POINTER = CUDA_ERROR_NOT_MAPPED_AS_POINTER;
  CUresult ERROR_ECC_UNCORRECTABLE = CUDA_ERROR_ECC_UNCORRECTABLE;
  CUresult ERROR_UNSUPPORTED_LIMIT = CUDA_ERROR_UNSUPPORTED_LIMIT;
  CUresult ERROR_CONTEXT_ALREADY_IN_USE = CUDA_ERROR_CONTEXT_ALREADY_IN_USE;
  CUresult ERROR_PEER_ACCESS_UNSUPPORTED = CUDA_ERROR_PEER_ACCESS_UNSUPPORTED;
  CUresult ERROR_INVALID_PTX = CUDA_ERROR_INVALID_PTX;
  CUresult ERROR_INVALID_GRAPHICS_CONTEXT = CUDA_ERROR_INVALID_GRAPHICS_CONTEXT;
  CUresult ERROR_INVALID_SOURCE = CUDA_ERROR_INVALID_SOURCE;
  CUresult ERROR_FILE_NOT_FOUND_ = CUDA_ERROR_FILE_NOT_FOUND;
  CUresult ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND = CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND;
  CUresult ERROR_SHARED_OBJECT_INIT_FAILED = CUDA_ERROR_SHARED_OBJECT_INIT_FAILED;
  CUresult ERROR_OPERATING_SYSTEM = CUDA_ERROR_OPERATING_SYSTEM;
  CUresult ERROR_INVALID_HANDLE_ = CUDA_ERROR_INVALID_HANDLE;
  CUresult ERROR_NOT_FOUND_ = CUDA_ERROR_NOT_FOUND;
  CUresult ERROR_NOT_READY_ = CUDA_ERROR_NOT_READY;
  CUresult ERROR_ILLEGAL_ADDRESS = CUDA_ERROR_ILLEGAL_ADDRESS;
  CUresult ERROR_LAUNCH_OUT_OF_RESOURCES = CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES;
  CUresult ERROR_LAUNCH_TIMEOUT = CUDA_ERROR_LAUNCH_TIMEOUT;
  CUresult ERROR_PEER_ACCESS_ALREADY_ENABLED = CUDA_ERROR_PEER_ACCESS_ALREADY_ENABLED;
  CUresult ERROR_PEER_ACCESS_NOT_ENABLED = CUDA_ERROR_PEER_ACCESS_NOT_ENABLED;
  CUresult ERROR_PRIMARY_CONTEXT_ACTIVE = CUDA_ERROR_PRIMARY_CONTEXT_ACTIVE;
  CUresult ERROR_CONTEXT_IS_DESTROYED = CUDA_ERROR_CONTEXT_IS_DESTROYED;
  CUresult ERROR_ASSERT = CUDA_ERROR_ASSERT;
  CUresult ERROR_HOST_MEMORY_ALREADY_REGISTERED = CUDA_ERROR_HOST_MEMORY_ALREADY_REGISTERED;
  CUresult ERROR_HOST_MEMORY_NOT_REGISTERED = CUDA_ERROR_HOST_MEMORY_NOT_REGISTERED;
  CUresult ERROR_LAUNCH_FAILED = CUDA_ERROR_LAUNCH_FAILED;
  CUresult ERROR_NOT_SUPPORTED_ = CUDA_ERROR_NOT_SUPPORTED;

  // CHECK: hipError_t ERROR_UNKNOWN = hipErrorUnknown;
  CUresult ERROR_UNKNOWN = CUDA_ERROR_UNKNOWN;

  // CHECK: hipSharedMemConfig sharedconfig;
  // CHECK-NEXT: hipSharedMemConfig sharedconfig_enum;
  // CHECK-NEXT: hipSharedMemConfig SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE = hipSharedMemBankSizeDefault;
  // CHECK-NEXT: hipSharedMemConfig SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE = hipSharedMemBankSizeFourByte;
  // CHECK-NEXT: hipSharedMemConfig SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE = hipSharedMemBankSizeEightByte;
  CUsharedconfig sharedconfig;
  CUsharedconfig_enum sharedconfig_enum;
  CUsharedconfig SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE = CU_SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE;
  CUsharedconfig SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE = CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE;
  CUsharedconfig SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE = CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE;

  // CHECK: int STREAM_DEFAULT = hipStreamDefault;
  // CHECK-NEXT: int STREAM_NON_BLOCKING = hipStreamNonBlocking;
  int STREAM_DEFAULT = CU_STREAM_DEFAULT;
  int STREAM_NON_BLOCKING = CU_STREAM_NON_BLOCKING;

  // CHECK: hipGLDeviceList GLDeviceList;
  // CHECK-NEXT: hipGLDeviceList GLDeviceList_enum;
  // CHECK-NEXT: hipGLDeviceList GL_DEVICE_LIST_ALL = hipGLDeviceListAll;
  // CHECK-NEXT: hipGLDeviceList GL_DEVICE_LIST_CURRENT_FRAME = hipGLDeviceListCurrentFrame;
  // CHECK-NEXT: hipGLDeviceList GL_DEVICE_LIST_NEXT_FRAME = hipGLDeviceListNextFrame;
  CUGLDeviceList GLDeviceList;
  CUGLDeviceList_enum GLDeviceList_enum;
  CUGLDeviceList GL_DEVICE_LIST_ALL = CU_GL_DEVICE_LIST_ALL;
  CUGLDeviceList GL_DEVICE_LIST_CURRENT_FRAME = CU_GL_DEVICE_LIST_CURRENT_FRAME;
  CUGLDeviceList GL_DEVICE_LIST_NEXT_FRAME = CU_GL_DEVICE_LIST_NEXT_FRAME;

  // CHECK: typedef struct hipGraphicsResource* graphicsResource_st;
  // CHECK-NEXT: hipGraphicsResource_t graphicsResource;
  typedef struct CUgraphicsResource_st* graphicsResource_st;
  CUgraphicsResource graphicsResource;

#if CUDA_VERSION >= 8000
  // CHECK: hipDeviceAttribute_t DEVICE_ATTRIBUTE_HOST_NATIVE_ATOMIC_SUPPORTED = hipDeviceAttributeHostNativeAtomicSupported;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_SINGLE_TO_DOUBLE_PRECISION_PERF_RATIO = hipDeviceAttributeSingleToDoublePrecisionPerfRatio;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS = hipDeviceAttributePageableMemoryAccess;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS = hipDeviceAttributeConcurrentManagedAccess;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_COMPUTE_PREEMPTION_SUPPORTED = hipDeviceAttributeComputePreemptionSupported;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM = hipDeviceAttributeCanUseHostPointerForRegisteredMem;
  CUdevice_attribute DEVICE_ATTRIBUTE_HOST_NATIVE_ATOMIC_SUPPORTED = CU_DEVICE_ATTRIBUTE_HOST_NATIVE_ATOMIC_SUPPORTED;
  CUdevice_attribute DEVICE_ATTRIBUTE_SINGLE_TO_DOUBLE_PRECISION_PERF_RATIO = CU_DEVICE_ATTRIBUTE_SINGLE_TO_DOUBLE_PRECISION_PERF_RATIO;
  CUdevice_attribute DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS = CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS;
  CUdevice_attribute DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS = CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS;
  CUdevice_attribute DEVICE_ATTRIBUTE_COMPUTE_PREEMPTION_SUPPORTED = CU_DEVICE_ATTRIBUTE_COMPUTE_PREEMPTION_SUPPORTED;
  CUdevice_attribute DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM = CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM;

  // CHECK: hipDeviceP2PAttr deviceP2PAttribute;
  // CHECK-NEXT: hipDeviceP2PAttr deviceP2PAttribute_enum;
  // CHECK-NEXT: hipDeviceP2PAttr DEVICE_P2P_ATTRIBUTE_PERFORMANCE_RANK = hipDevP2PAttrPerformanceRank;
  // CHECK-NEXT: hipDeviceP2PAttr DEVICE_P2P_ATTRIBUTE_ACCESS_SUPPORTED = hipDevP2PAttrAccessSupported;
  // CHECK-NEXT: hipDeviceP2PAttr DEVICE_P2P_ATTRIBUTE_NATIVE_ATOMIC_SUPPORTED = hipDevP2PAttrNativeAtomicSupported;
  CUdevice_P2PAttribute deviceP2PAttribute;
  CUdevice_P2PAttribute_enum deviceP2PAttribute_enum;
  CUdevice_P2PAttribute DEVICE_P2P_ATTRIBUTE_PERFORMANCE_RANK = CU_DEVICE_P2P_ATTRIBUTE_PERFORMANCE_RANK;
  CUdevice_P2PAttribute DEVICE_P2P_ATTRIBUTE_ACCESS_SUPPORTED = CU_DEVICE_P2P_ATTRIBUTE_ACCESS_SUPPORTED;
  CUdevice_P2PAttribute DEVICE_P2P_ATTRIBUTE_NATIVE_ATOMIC_SUPPORTED = CU_DEVICE_P2P_ATTRIBUTE_NATIVE_ATOMIC_SUPPORTED;

  // CHECK: hipJitOption JIT_NEW_SM3X_OPT = HIPRTC_JIT_NEW_SM3X_OPT;
  // CHECK-NEXT: hipJitOption JIT_FAST_COMPILE = HIPRTC_JIT_FAST_COMPILE;
  CUjit_option JIT_NEW_SM3X_OPT = CU_JIT_NEW_SM3X_OPT;
  CUjit_option JIT_FAST_COMPILE = CU_JIT_FAST_COMPILE;

  // CHECK: hipMemoryAdvise mem_advise;
  // CHECK-NEXT: hipMemoryAdvise mem_advise_enum;
  // CHECK-NEXT: hipMemoryAdvise MEM_ADVISE_SET_READ_MOSTLY = hipMemAdviseSetReadMostly;
  // CHECK-NEXT: hipMemoryAdvise MEM_ADVISE_UNSET_READ_MOSTLY = hipMemAdviseUnsetReadMostly;
  // CHECK-NEXT: hipMemoryAdvise MEM_ADVISE_SET_PREFERRED_LOCATION = hipMemAdviseSetPreferredLocation;
  // CHECK-NEXT: hipMemoryAdvise MEM_ADVISE_UNSET_PREFERRED_LOCATION = hipMemAdviseUnsetPreferredLocation;
  // CHECK-NEXT: hipMemoryAdvise MEM_ADVISE_SET_ACCESSED_BY = hipMemAdviseSetAccessedBy;
  // CHECK-NEXT: hipMemoryAdvise MEM_ADVISE_UNSET_ACCESSED_BY = hipMemAdviseUnsetAccessedBy;
  CUmem_advise mem_advise;
  CUmem_advise_enum mem_advise_enum;
  CUmem_advise MEM_ADVISE_SET_READ_MOSTLY = CU_MEM_ADVISE_SET_READ_MOSTLY;
  CUmem_advise MEM_ADVISE_UNSET_READ_MOSTLY = CU_MEM_ADVISE_UNSET_READ_MOSTLY;
  CUmem_advise MEM_ADVISE_SET_PREFERRED_LOCATION = CU_MEM_ADVISE_SET_PREFERRED_LOCATION;
  CUmem_advise MEM_ADVISE_UNSET_PREFERRED_LOCATION = CU_MEM_ADVISE_UNSET_PREFERRED_LOCATION;
  CUmem_advise MEM_ADVISE_SET_ACCESSED_BY = CU_MEM_ADVISE_SET_ACCESSED_BY;
  CUmem_advise MEM_ADVISE_UNSET_ACCESSED_BY = CU_MEM_ADVISE_UNSET_ACCESSED_BY;

  // CHECK: hipMemRangeAttribute mem_range_attribute;
  // CHECK-NEXT: hipMemRangeAttribute mem_range_attribute_enum;
  // CHECK-NEXT: hipMemRangeAttribute MEM_RANGE_ATTRIBUTE_READ_MOSTLY = hipMemRangeAttributeReadMostly;
  // CHECK-NEXT: hipMemRangeAttribute MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION = hipMemRangeAttributePreferredLocation;
  // CHECK-NEXT: hipMemRangeAttribute MEM_RANGE_ATTRIBUTE_ACCESSED_BY = hipMemRangeAttributeAccessedBy;
  // CHECK-NEXT: hipMemRangeAttribute MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION = hipMemRangeAttributeLastPrefetchLocation;
  CUmem_range_attribute mem_range_attribute;
  CUmem_range_attribute_enum mem_range_attribute_enum;
  CUmem_range_attribute MEM_RANGE_ATTRIBUTE_READ_MOSTLY = CU_MEM_RANGE_ATTRIBUTE_READ_MOSTLY;
  CUmem_range_attribute MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION = CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION;
  CUmem_range_attribute MEM_RANGE_ATTRIBUTE_ACCESSED_BY = CU_MEM_RANGE_ATTRIBUTE_ACCESSED_BY;
  CUmem_range_attribute MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION = CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION;

  // CHECK: int STREAM_WAIT_VALUE_GEQ = hipStreamWaitValueGte;
  // CHECK-NEXT: int STREAM_WAIT_VALUE_EQ = hipStreamWaitValueEq;
  // CHECK-NEXT: int STREAM_WAIT_VALUE_AND = hipStreamWaitValueAnd;
  int STREAM_WAIT_VALUE_GEQ = CU_STREAM_WAIT_VALUE_GEQ;
  int STREAM_WAIT_VALUE_EQ = CU_STREAM_WAIT_VALUE_EQ;
  int STREAM_WAIT_VALUE_AND = CU_STREAM_WAIT_VALUE_AND;
#endif

#if CUDA_VERSION >= 9000
  // CHECK: hipDeviceAttribute_t DEVICE_ATTRIBUTE_COOPERATIVE_LAUNCH = hipDeviceAttributeCooperativeLaunch;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_COOPERATIVE_MULTI_DEVICE_LAUNCH = hipDeviceAttributeCooperativeMultiDeviceLaunch;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN = hipDeviceAttributeSharedMemPerBlockOptin;
  CUdevice_attribute DEVICE_ATTRIBUTE_COOPERATIVE_LAUNCH = CU_DEVICE_ATTRIBUTE_COOPERATIVE_LAUNCH;
  CUdevice_attribute DEVICE_ATTRIBUTE_COOPERATIVE_MULTI_DEVICE_LAUNCH = CU_DEVICE_ATTRIBUTE_COOPERATIVE_MULTI_DEVICE_LAUNCH;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN = CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN;

  // CHECK: hipFunction_attribute FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES = HIP_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES;
  // CHECK-NEXT: hipFunction_attribute FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT = HIP_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT;
  CUfunction_attribute FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES = CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES;
  CUfunction_attribute FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT = CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT;

  // CHECK: hipError_t ERROR_COOPERATIVE_LAUNCH_TOO_LARGE = hipErrorCooperativeLaunchTooLarge;
  CUresult ERROR_COOPERATIVE_LAUNCH_TOO_LARGE = CUDA_ERROR_COOPERATIVE_LAUNCH_TOO_LARGE;

  // CHECK: int STREAM_WAIT_VALUE_NOR = hipStreamWaitValueNor;
  int STREAM_WAIT_VALUE_NOR = CU_STREAM_WAIT_VALUE_NOR;
#endif

#if CUDA_VERSION >= 9000 && CUDA_VERSION < 12000
  // CHECK: hipDeviceAttribute_t DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR = hipDeviceAttributeCanUseStreamWaitValue;
  CUdevice_attribute DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR = CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR;
#endif

#if CUDA_VERSION >= 9020
  // CHECK: hipDeviceAttribute_t DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES = hipDeviceAttributePageableMemoryAccessUsesHostPageTables;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_DIRECT_MANAGED_MEM_ACCESS_FROM_HOST = hipDeviceAttributeDirectManagedMemAccessFromHost;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_HOST_REGISTER_SUPPORTED = hipDeviceAttributeHostRegisterSupported;
  CUdevice_attribute DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES = CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES;
  CUdevice_attribute DEVICE_ATTRIBUTE_DIRECT_MANAGED_MEM_ACCESS_FROM_HOST = CU_DEVICE_ATTRIBUTE_DIRECT_MANAGED_MEM_ACCESS_FROM_HOST;
  CUdevice_attribute DEVICE_ATTRIBUTE_HOST_REGISTER_SUPPORTED = CU_DEVICE_ATTRIBUTE_HOST_REGISTER_SUPPORTED;
#endif

#if CUDA_VERSION >= 10000
  // CHECK: hipDeviceP2PAttr DEVICE_P2P_ATTRIBUTE_CUDA_ARRAY_ACCESS_SUPPORTED = hipDevP2PAttrHipArrayAccessSupported;
  CUdevice_P2PAttribute DEVICE_P2P_ATTRIBUTE_CUDA_ARRAY_ACCESS_SUPPORTED = CU_DEVICE_P2P_ATTRIBUTE_CUDA_ARRAY_ACCESS_SUPPORTED;

  // CHECK: hipExternalMemoryHandleType externalMemoryHandleType;
  // CHECK-NEXT: hipExternalMemoryHandleType_enum externalMemoryHandleType_enum;
  // CHECK-NEXT: hipExternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD = hipExternalMemoryHandleTypeOpaqueFd;
  // CHECK-NEXT: hipExternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32 = hipExternalMemoryHandleTypeOpaqueWin32;
  // CHECK-NEXT: hipExternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT = hipExternalMemoryHandleTypeOpaqueWin32Kmt;
  // CHECK-NEXT: hipExternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP = hipExternalMemoryHandleTypeD3D12Heap;
  // CHECK-NEXT: hipExternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE = hipExternalMemoryHandleTypeD3D12Resource;
  CUexternalMemoryHandleType externalMemoryHandleType;
  CUexternalMemoryHandleType_enum externalMemoryHandleType_enum;
  CUexternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD = CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD;
  CUexternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32 = CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32;
  CUexternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT = CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT;
  CUexternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP = CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP;
  CUexternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE = CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE;

  // CHECK: hipExternalSemaphoreHandleType externalSemaphoreHandleType;
  // CHECK-NEXT: hipExternalSemaphoreHandleType_enum externalSemaphoreHandleType_enum;
  // CHECK-NEXT: hipExternalSemaphoreHandleType EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD = hipExternalSemaphoreHandleTypeOpaqueFd;
  // CHECK-NEXT: hipExternalSemaphoreHandleType EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32 = hipExternalSemaphoreHandleTypeOpaqueWin32;
  // CHECK-NEXT: hipExternalSemaphoreHandleType EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT = hipExternalSemaphoreHandleTypeOpaqueWin32Kmt;
  // CHECK-NEXT: hipExternalSemaphoreHandleType EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE = hipExternalSemaphoreHandleTypeD3D12Fence;
  CUexternalSemaphoreHandleType externalSemaphoreHandleType;
  CUexternalSemaphoreHandleType_enum externalSemaphoreHandleType_enum;
  CUexternalSemaphoreHandleType EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD = CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD;
  CUexternalSemaphoreHandleType EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32 = CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32;
  CUexternalSemaphoreHandleType EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT = CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT;
  CUexternalSemaphoreHandleType EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE = CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE;

  // CHECK: hipGraphNodeType graphNodeType;
  // CHECK-NEXT: hipGraphNodeType graphNodeType_enum;
  // CHECK-NEXT: hipGraphNodeType GRAPH_NODE_TYPE_KERNEL = hipGraphNodeTypeKernel;
  // CHECK-NEXT: hipGraphNodeType GRAPH_NODE_TYPE_MEMCPY = hipGraphNodeTypeMemcpy;
  // CHECK-NEXT: hipGraphNodeType GRAPH_NODE_TYPE_MEMSET = hipGraphNodeTypeMemset;
  // CHECK-NEXT: hipGraphNodeType GRAPH_NODE_TYPE_HOST = hipGraphNodeTypeHost;
  // CHECK-NEXT: hipGraphNodeType GRAPH_NODE_TYPE_GRAPH = hipGraphNodeTypeGraph;
  // CHECK-NEXT: hipGraphNodeType GRAPH_NODE_TYPE_EMPTY = hipGraphNodeTypeEmpty;
  CUgraphNodeType graphNodeType;
  CUgraphNodeType_enum graphNodeType_enum;
  CUgraphNodeType GRAPH_NODE_TYPE_KERNEL = CU_GRAPH_NODE_TYPE_KERNEL;
  CUgraphNodeType GRAPH_NODE_TYPE_MEMCPY = CU_GRAPH_NODE_TYPE_MEMCPY;
  CUgraphNodeType GRAPH_NODE_TYPE_MEMSET = CU_GRAPH_NODE_TYPE_MEMSET;
  CUgraphNodeType GRAPH_NODE_TYPE_HOST = CU_GRAPH_NODE_TYPE_HOST;
  CUgraphNodeType GRAPH_NODE_TYPE_GRAPH = CU_GRAPH_NODE_TYPE_GRAPH;
  CUgraphNodeType GRAPH_NODE_TYPE_EMPTY = CU_GRAPH_NODE_TYPE_EMPTY;

  // CHECK: hipError_t ERROR_STREAM_CAPTURE_UNSUPPORTED = hipErrorStreamCaptureUnsupported;
  // CHECK-NEXT: hipError_t ERROR_STREAM_CAPTURE_INVALIDATED = hipErrorStreamCaptureInvalidated;
  // CHECK-NEXT: hipError_t ERROR_STREAM_CAPTURE_MERGE = hipErrorStreamCaptureMerge;
  // CHECK-NEXT: hipError_t ERROR_STREAM_CAPTURE_UNMATCHED = hipErrorStreamCaptureUnmatched;
  // CHECK-NEXT: hipError_t ERROR_STREAM_CAPTURE_UNJOINED = hipErrorStreamCaptureUnjoined;
  // CHECK-NEXT: hipError_t ERROR_STREAM_CAPTURE_ISOLATION = hipErrorStreamCaptureIsolation;
  // CHECK-NEXT: hipError_t ERROR_STREAM_CAPTURE_IMPLICIT = hipErrorStreamCaptureImplicit;
  // CHECK-NEXT: hipError_t ERROR_CAPTURED_EVENT = hipErrorCapturedEvent;
  // CHECK-NEXT: hipError_t ERROR_ILLEGAL_STATE = hipErrorIllegalState;
  CUresult ERROR_STREAM_CAPTURE_UNSUPPORTED = CUDA_ERROR_STREAM_CAPTURE_UNSUPPORTED;
  CUresult ERROR_STREAM_CAPTURE_INVALIDATED = CUDA_ERROR_STREAM_CAPTURE_INVALIDATED;
  CUresult ERROR_STREAM_CAPTURE_MERGE = CUDA_ERROR_STREAM_CAPTURE_MERGE;
  CUresult ERROR_STREAM_CAPTURE_UNMATCHED = CUDA_ERROR_STREAM_CAPTURE_UNMATCHED;
  CUresult ERROR_STREAM_CAPTURE_UNJOINED = CUDA_ERROR_STREAM_CAPTURE_UNJOINED;
  CUresult ERROR_STREAM_CAPTURE_ISOLATION = CUDA_ERROR_STREAM_CAPTURE_ISOLATION;
  CUresult ERROR_STREAM_CAPTURE_IMPLICIT = CUDA_ERROR_STREAM_CAPTURE_IMPLICIT;
  CUresult ERROR_CAPTURED_EVENT = CUDA_ERROR_CAPTURED_EVENT;
  CUresult ERROR_ILLEGAL_STATE = CUDA_ERROR_ILLEGAL_STATE;

  // CHECK: hipStreamCaptureStatus streamCaptureStatus;
  // CHECK-NEXT: hipStreamCaptureStatus streamCaptureStatus_enum;
  // CHECK-NEXT: hipStreamCaptureStatus STREAM_CAPTURE_STATUS_NONE = hipStreamCaptureStatusNone;
  // CHECK-NEXT: hipStreamCaptureStatus STREAM_CAPTURE_STATUS_ACTIVE = hipStreamCaptureStatusActive;
  // CHECK-NEXT: hipStreamCaptureStatus STREAM_CAPTURE_STATUS_INVALIDATED = hipStreamCaptureStatusInvalidated;
  CUstreamCaptureStatus streamCaptureStatus;
  CUstreamCaptureStatus_enum streamCaptureStatus_enum;
  CUstreamCaptureStatus STREAM_CAPTURE_STATUS_NONE = CU_STREAM_CAPTURE_STATUS_NONE;
  CUstreamCaptureStatus STREAM_CAPTURE_STATUS_ACTIVE = CU_STREAM_CAPTURE_STATUS_ACTIVE;
  CUstreamCaptureStatus STREAM_CAPTURE_STATUS_INVALIDATED = CU_STREAM_CAPTURE_STATUS_INVALIDATED;
#endif

#if CUDA_VERSION == 10010
  // CHECK: hipDeviceP2PAttr DEVICE_P2P_ATTRIBUTE_ACCESS_ACCESS_SUPPORTED = hipDevP2PAttrHipArrayAccessSupported;
  CUdevice_P2PAttribute DEVICE_P2P_ATTRIBUTE_ACCESS_ACCESS_SUPPORTED = CU_DEVICE_P2P_ATTRIBUTE_ACCESS_ACCESS_SUPPORTED;
#endif

#if CUDA_VERSION >= 10010
  // CHECK: hipError_t ERROR_STREAM_CAPTURE_WRONG_THREAD = hipErrorStreamCaptureWrongThread;
  CUresult ERROR_STREAM_CAPTURE_WRONG_THREAD = CUDA_ERROR_STREAM_CAPTURE_WRONG_THREAD;

  // CHECK: hipStreamCaptureMode streamCaptureMode;
  // CHECK-NEXT: hipStreamCaptureMode streamCaptureMode_enum;
  // CHECK-NEXT: hipStreamCaptureMode STREAM_CAPTURE_MODE_GLOBAL = hipStreamCaptureModeGlobal;
  // CHECK-NEXT: hipStreamCaptureMode STREAM_CAPTURE_MODE_THREAD_LOCAL = hipStreamCaptureModeThreadLocal;
  // CHECK-NEXT: hipStreamCaptureMode STREAM_CAPTURE_MODE_RELAXED = hipStreamCaptureModeRelaxed;
  CUstreamCaptureMode streamCaptureMode;
  CUstreamCaptureMode_enum streamCaptureMode_enum;
  CUstreamCaptureMode STREAM_CAPTURE_MODE_GLOBAL = CU_STREAM_CAPTURE_MODE_GLOBAL;
  CUstreamCaptureMode STREAM_CAPTURE_MODE_THREAD_LOCAL = CU_STREAM_CAPTURE_MODE_THREAD_LOCAL;
  CUstreamCaptureMode STREAM_CAPTURE_MODE_RELAXED = CU_STREAM_CAPTURE_MODE_RELAXED;
#endif

#if CUDA_VERSION >= 10020
  // CHECK: hipExternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE = hipExternalMemoryHandleTypeD3D11Resource;
  // CHECK: hipExternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE_KMT = hipExternalMemoryHandleTypeD3D11ResourceKmt;
  CUexternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE = CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE;
  CUexternalMemoryHandleType EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE_KMT = CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE_KMT;

  // CHECK: hipGraphExecUpdateResult graphExecUpdateResult;
  // CHECK-NEXT: hipGraphExecUpdateResult graphExecUpdateResult_enum;
  // CHECK-NEXT: hipGraphExecUpdateResult GRAPH_EXEC_UPDATE_SUCCESS = hipGraphExecUpdateSuccess;
  // CHECK-NEXT: hipGraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR = hipGraphExecUpdateError;
  // CHECK-NEXT: hipGraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_TOPOLOGY_CHANGED = hipGraphExecUpdateErrorTopologyChanged;
  // CHECK-NEXT: hipGraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_NODE_TYPE_CHANGED = hipGraphExecUpdateErrorNodeTypeChanged;
  // CHECK-NEXT: hipGraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_FUNCTION_CHANGED = hipGraphExecUpdateErrorFunctionChanged;
  // CHECK-NEXT: hipGraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_PARAMETERS_CHANGED = hipGraphExecUpdateErrorParametersChanged;
  // CHECK-NEXT: hipGraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_NOT_SUPPORTED = hipGraphExecUpdateErrorNotSupported;
  CUgraphExecUpdateResult graphExecUpdateResult;
  CUgraphExecUpdateResult_enum graphExecUpdateResult_enum;
  CUgraphExecUpdateResult GRAPH_EXEC_UPDATE_SUCCESS = CU_GRAPH_EXEC_UPDATE_SUCCESS;
  CUgraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR = CU_GRAPH_EXEC_UPDATE_ERROR;
  CUgraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_TOPOLOGY_CHANGED = CU_GRAPH_EXEC_UPDATE_ERROR_TOPOLOGY_CHANGED;
  CUgraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_NODE_TYPE_CHANGED = CU_GRAPH_EXEC_UPDATE_ERROR_NODE_TYPE_CHANGED;
  CUgraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_FUNCTION_CHANGED = CU_GRAPH_EXEC_UPDATE_ERROR_FUNCTION_CHANGED;
  CUgraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_PARAMETERS_CHANGED = CU_GRAPH_EXEC_UPDATE_ERROR_PARAMETERS_CHANGED;
  CUgraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_NOT_SUPPORTED = CU_GRAPH_EXEC_UPDATE_ERROR_NOT_SUPPORTED;

  // CHECK: hipError_t ERROR_GRAPH_EXEC_UPDATE_FAILURE = hipErrorGraphExecUpdateFailure;
  CUresult ERROR_GRAPH_EXEC_UPDATE_FAILURE = CUDA_ERROR_GRAPH_EXEC_UPDATE_FAILURE;

  // CHECK: hipMemLocationType memLocationType;
  // CHECK-NEXT: hipMemLocationType memLocationType_enum;
  // CHECK-NEXT: hipMemLocationType MEM_LOCATION_TYPE_INVALID = hipMemLocationTypeInvalid;
  // CHECK-NEXT: hipMemLocationType MEM_LOCATION_TYPE_DEVICE = hipMemLocationTypeDevice;
  CUmemLocationType memLocationType;
  CUmemLocationType_enum memLocationType_enum;
  CUmemLocationType MEM_LOCATION_TYPE_INVALID = CU_MEM_LOCATION_TYPE_INVALID;
  CUmemLocationType MEM_LOCATION_TYPE_DEVICE = CU_MEM_LOCATION_TYPE_DEVICE;

  // CHECK: hipPointer_attribute POINTER_ATTRIBUTE_IS_LEGACY_CUDA_IPC_CAPABLE = HIP_POINTER_ATTRIBUTE_IS_LEGACY_HIP_IPC_CAPABLE;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_RANGE_START_ADDR = HIP_POINTER_ATTRIBUTE_RANGE_START_ADDR;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_RANGE_SIZE = HIP_POINTER_ATTRIBUTE_RANGE_SIZE;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_MAPPED = HIP_POINTER_ATTRIBUTE_MAPPED;
  // CHECK-NEXT: hipPointer_attribute POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES = HIP_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES;
  CUpointer_attribute POINTER_ATTRIBUTE_IS_LEGACY_CUDA_IPC_CAPABLE = CU_POINTER_ATTRIBUTE_IS_LEGACY_CUDA_IPC_CAPABLE;
  CUpointer_attribute POINTER_ATTRIBUTE_RANGE_START_ADDR = CU_POINTER_ATTRIBUTE_RANGE_START_ADDR;
  CUpointer_attribute POINTER_ATTRIBUTE_RANGE_SIZE = CU_POINTER_ATTRIBUTE_RANGE_SIZE;
  CUpointer_attribute POINTER_ATTRIBUTE_MAPPED = CU_POINTER_ATTRIBUTE_MAPPED;
  CUpointer_attribute POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES = CU_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES;

  // CHECK: hipMemAccessFlags memAccess_flags;
  // CHECK-NEXT: hipMemAccessFlags memAccess_flags_enum;
  // CHECK-NEXT: hipMemAccessFlags MEM_ACCESS_FLAGS_PROT_NONE = hipMemAccessFlagsProtNone;
  // CHECK-NEXT: hipMemAccessFlags MEM_ACCESS_FLAGS_PROT_READ = hipMemAccessFlagsProtRead;
  // CHECK-NEXT: hipMemAccessFlags MEM_ACCESS_FLAGS_PROT_READWRITE = hipMemAccessFlagsProtReadWrite;
  CUmemAccess_flags memAccess_flags;
  CUmemAccess_flags_enum memAccess_flags_enum;
  CUmemAccess_flags MEM_ACCESS_FLAGS_PROT_NONE = CU_MEM_ACCESS_FLAGS_PROT_NONE;
  CUmemAccess_flags MEM_ACCESS_FLAGS_PROT_READ = CU_MEM_ACCESS_FLAGS_PROT_READ;
  CUmemAccess_flags MEM_ACCESS_FLAGS_PROT_READWRITE = CU_MEM_ACCESS_FLAGS_PROT_READWRITE;

  // CHECK: hipMemAllocationType memAllocationType;
  // CHECK-NEXT: hipMemAllocationType memAllocationType_enum;
  // CHECK-NEXT: hipMemAllocationType MEM_ALLOCATION_TYPE_INVALID = hipMemAllocationTypeInvalid;
  // CHECK-NEXT: hipMemAllocationType MEM_ALLOCATION_TYPE_PINNED = hipMemAllocationTypePinned;
  // CHECK-NEXT: hipMemAllocationType MEM_ALLOCATION_TYPE_MAX = hipMemAllocationTypeMax;
  CUmemAllocationType memAllocationType;
  CUmemAllocationType_enum memAllocationType_enum;
  CUmemAllocationType MEM_ALLOCATION_TYPE_INVALID = CU_MEM_ALLOCATION_TYPE_INVALID;
  CUmemAllocationType MEM_ALLOCATION_TYPE_PINNED = CU_MEM_ALLOCATION_TYPE_PINNED;
  CUmemAllocationType MEM_ALLOCATION_TYPE_MAX = CU_MEM_ALLOCATION_TYPE_MAX;

  // CHECK: hipMemAllocationHandleType memAllocationHandleType;
  // CHECK-NEXT: hipMemAllocationHandleType memAllocationHandleType_enum;
  // CHECK-NEXT: hipMemAllocationHandleType MEM_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR = hipMemHandleTypePosixFileDescriptor;
  // CHECK-NEXT: hipMemAllocationHandleType MEM_HANDLE_TYPE_WIN32 = hipMemHandleTypeWin32;
  // CHECK-NEXT: hipMemAllocationHandleType MEM_HANDLE_TYPE_WIN32_KMT = hipMemHandleTypeWin32Kmt;
  CUmemAllocationHandleType memAllocationHandleType;
  CUmemAllocationHandleType_enum memAllocationHandleType_enum;
  CUmemAllocationHandleType MEM_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR = CU_MEM_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR;
  CUmemAllocationHandleType MEM_HANDLE_TYPE_WIN32 = CU_MEM_HANDLE_TYPE_WIN32;
  CUmemAllocationHandleType MEM_HANDLE_TYPE_WIN32_KMT = CU_MEM_HANDLE_TYPE_WIN32_KMT;

  // CHECK: hipMemAllocationGranularity_flags memAllocationGranularity_flags;
  // CHECK-NEXT: hipMemAllocationGranularity_flags memAllocationGranularity_flags_enum;
  // CHECK-NEXT: hipMemAllocationGranularity_flags MEM_ALLOC_GRANULARITY_MINIMUM = hipMemAllocationGranularityMinimum;
  // CHECK-NEXT: hipMemAllocationGranularity_flags MEM_ALLOC_GRANULARITY_RECOMMENDED = hipMemAllocationGranularityRecommended;
  CUmemAllocationGranularity_flags memAllocationGranularity_flags;
  CUmemAllocationGranularity_flags_enum memAllocationGranularity_flags_enum;
  CUmemAllocationGranularity_flags MEM_ALLOC_GRANULARITY_MINIMUM = CU_MEM_ALLOC_GRANULARITY_MINIMUM;
  CUmemAllocationGranularity_flags MEM_ALLOC_GRANULARITY_RECOMMENDED = CU_MEM_ALLOC_GRANULARITY_RECOMMENDED;
#endif

#if CUDA_VERSION >= 11000
  // CHECK: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MAX_BLOCKS_PER_MULTIPROCESSOR = hipDeviceAttributeMaxBlocksPerMultiprocessor;
  CUdevice_attribute DEVICE_ATTRIBUTE_MAX_BLOCKS_PER_MULTIPROCESSOR = CU_DEVICE_ATTRIBUTE_MAX_BLOCKS_PER_MULTIPROCESSOR;

  // CHECK: hipAccessProperty accessProperty;
  // CHECK-NEXT: hipAccessProperty accessProperty_enum;
  // CHECK-NEXT: hipAccessProperty ACCESS_PROPERTY_NORMAL = hipAccessPropertyNormal;
  // CHECK-NEXT: hipAccessProperty ACCESS_PROPERTY_STREAMING = hipAccessPropertyStreaming;
  // CHECK-NEXT: hipAccessProperty ACCESS_PROPERTY_PERSISTING = hipAccessPropertyPersisting;
  CUaccessProperty accessProperty;
  CUaccessProperty_enum accessProperty_enum;
  CUaccessProperty ACCESS_PROPERTY_NORMAL = CU_ACCESS_PROPERTY_NORMAL;
  CUaccessProperty ACCESS_PROPERTY_STREAMING = CU_ACCESS_PROPERTY_STREAMING;
  CUaccessProperty ACCESS_PROPERTY_PERSISTING = CU_ACCESS_PROPERTY_PERSISTING;

  // CHECK: hipPointer_attribute POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE = HIP_POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE;
  CUpointer_attribute POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE = CU_POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE;

  // CHECK: hipKernelNodeAttrID kernelNodeAttrID;
  // CHECK-NEXT: hipKernelNodeAttrID KERNEL_NODE_ATTRIBUTE_ACCESS_POLICY_WINDOW = hipKernelNodeAttributeAccessPolicyWindow;
  // CHECK-NEXT: hipKernelNodeAttrID KERNEL_NODE_ATTRIBUTE_COOPERATIVE = hipKernelNodeAttributeCooperative;
  CUkernelNodeAttrID kernelNodeAttrID;
  CUkernelNodeAttrID KERNEL_NODE_ATTRIBUTE_ACCESS_POLICY_WINDOW = CU_KERNEL_NODE_ATTRIBUTE_ACCESS_POLICY_WINDOW;
  CUkernelNodeAttrID KERNEL_NODE_ATTRIBUTE_COOPERATIVE = CU_KERNEL_NODE_ATTRIBUTE_COOPERATIVE;
#endif

#if CUDA_VERSION >= 11000 && CUDA_VERSION < 11080
  // CHECK: hipKernelNodeAttrID kernelNodeAttrID_enum;
  CUkernelNodeAttrID_enum kernelNodeAttrID_enum;
#endif

#if CUDA_VERSION >= 11010
  // CHECK: hipGraphNodeType GRAPH_NODE_TYPE_WAIT_EVENT = hipGraphNodeTypeWaitEvent;
  // CHECK-NEXT: hipGraphNodeType GRAPH_NODE_TYPE_EVENT_RECORD = hipGraphNodeTypeEventRecord;
  CUgraphNodeType GRAPH_NODE_TYPE_WAIT_EVENT = CU_GRAPH_NODE_TYPE_WAIT_EVENT;
  CUgraphNodeType GRAPH_NODE_TYPE_EVENT_RECORD = CU_GRAPH_NODE_TYPE_EVENT_RECORD;

  // CHECK: hipMemHandleType memHandleType;
  // CHECK-NEXT: hipMemHandleType memHandleType_enum;
  // CHECK-NEXT: hipMemHandleType MEM_HANDLE_TYPE_GENERIC = hipMemHandleTypeGeneric;
  CUmemHandleType memHandleType;
  CUmemHandleType_enum memHandleType_enum;
  CUmemHandleType MEM_HANDLE_TYPE_GENERIC = CU_MEM_HANDLE_TYPE_GENERIC;

  // CHECK: hipPointer_attribute POINTER_ATTRIBUTE_ACCESS_FLAGS = HIP_POINTER_ATTRIBUTE_ACCESS_FLAGS;
  CUpointer_attribute POINTER_ATTRIBUTE_ACCESS_FLAGS = CU_POINTER_ATTRIBUTE_ACCESS_FLAGS;

  // CHECK: hipMemOperationType memOperationType;
  // CHECK-NEXT: hipMemOperationType memOperationType_enum;
  // CHECK-NEXT: hipMemOperationType MEM_OPERATION_TYPE_MAP = hipMemOperationTypeMap;
  // CHECK-NEXT: hipMemOperationType MEM_OPERATION_TYPE_UNMAP = hipMemOperationTypeUnmap;
  CUmemOperationType memOperationType;
  CUmemOperationType_enum memOperationType_enum;
  CUmemOperationType MEM_OPERATION_TYPE_MAP = CU_MEM_OPERATION_TYPE_MAP;
  CUmemOperationType MEM_OPERATION_TYPE_UNMAP = CU_MEM_OPERATION_TYPE_UNMAP;

  // CHECK: hipArraySparseSubresourceType arraySparseSubresourceType;
  // CHECK-NEXT: hipArraySparseSubresourceType arraySparseSubresourceType_enum;
  // CHECK-NEXT: hipArraySparseSubresourceType ARRAY_SPARSE_SUBRESOURCE_TYPE_SPARSE_LEVEL = hipArraySparseSubresourceTypeSparseLevel;
  // CHECK-NEXT: hipArraySparseSubresourceType ARRAY_SPARSE_SUBRESOURCE_TYPE_MIPTAIL = hipArraySparseSubresourceTypeMiptail;
  CUarraySparseSubresourceType arraySparseSubresourceType;
  CUarraySparseSubresourceType_enum arraySparseSubresourceType_enum;
  CUarraySparseSubresourceType ARRAY_SPARSE_SUBRESOURCE_TYPE_SPARSE_LEVEL = CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_SPARSE_LEVEL;
  CUarraySparseSubresourceType ARRAY_SPARSE_SUBRESOURCE_TYPE_MIPTAIL = CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_MIPTAIL;
#endif

#if CUDA_VERSION >= 11020
  // CHECK: hipDeviceAttribute_t DEVICE_ATTRIBUTE_MEMORY_POOLS_SUPPORTED = hipDeviceAttributeMemoryPoolsSupported;
  // CHECK-NEXT: hipDeviceAttribute_t DEVICE_ATTRIBUTE_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED = hipDeviceAttributeVirtualMemoryManagementSupported;
  CUdevice_attribute DEVICE_ATTRIBUTE_MEMORY_POOLS_SUPPORTED = CU_DEVICE_ATTRIBUTE_MEMORY_POOLS_SUPPORTED;
  CUdevice_attribute DEVICE_ATTRIBUTE_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED = CU_DEVICE_ATTRIBUTE_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED;

  // CHECK: hipGraphNodeType GRAPH_NODE_TYPE_EXT_SEMAS_SIGNAL = hipGraphNodeTypeExtSemaphoreSignal;
  // CHECK-NEXT: hipGraphNodeType GRAPH_NODE_TYPE_EXT_SEMAS_WAIT = hipGraphNodeTypeExtSemaphoreWait;
  CUgraphNodeType GRAPH_NODE_TYPE_EXT_SEMAS_SIGNAL = CU_GRAPH_NODE_TYPE_EXT_SEMAS_SIGNAL;
  CUgraphNodeType GRAPH_NODE_TYPE_EXT_SEMAS_WAIT = CU_GRAPH_NODE_TYPE_EXT_SEMAS_WAIT;

  // CHECK: hipGraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_UNSUPPORTED_FUNCTION_CHANGE = hipGraphExecUpdateErrorUnsupportedFunctionChange;
  CUgraphExecUpdateResult GRAPH_EXEC_UPDATE_ERROR_UNSUPPORTED_FUNCTION_CHANGE = CU_GRAPH_EXEC_UPDATE_ERROR_UNSUPPORTED_FUNCTION_CHANGE;

  // CHECK: hipMemPoolAttr memPool_attribute;
  // CHECK-NEXT: hipMemPoolAttr memPool_attribute_enum;
  // CHECK-NEXT: hipMemPoolAttr MEMPOOL_ATTR_REUSE_FOLLOW_EVENT_DEPENDENCIES = hipMemPoolReuseFollowEventDependencies;
  // CHECK-NEXT: hipMemPoolAttr MEMPOOL_ATTR_REUSE_ALLOW_OPPORTUNISTIC = hipMemPoolReuseAllowOpportunistic;
  // CHECK-NEXT: hipMemPoolAttr MEMPOOL_ATTR_REUSE_ALLOW_INTERNAL_DEPENDENCIES = hipMemPoolReuseAllowInternalDependencies;
  // CHECK-NEXT: hipMemPoolAttr MEMPOOL_ATTR_RELEASE_THRESHOLD = hipMemPoolAttrReleaseThreshold;
  CUmemPool_attribute memPool_attribute;
  CUmemPool_attribute_enum memPool_attribute_enum;
  CUmemPool_attribute MEMPOOL_ATTR_REUSE_FOLLOW_EVENT_DEPENDENCIES = CU_MEMPOOL_ATTR_REUSE_FOLLOW_EVENT_DEPENDENCIES;
  CUmemPool_attribute MEMPOOL_ATTR_REUSE_ALLOW_OPPORTUNISTIC = CU_MEMPOOL_ATTR_REUSE_ALLOW_OPPORTUNISTIC;
  CUmemPool_attribute MEMPOOL_ATTR_REUSE_ALLOW_INTERNAL_DEPENDENCIES = CU_MEMPOOL_ATTR_REUSE_ALLOW_INTERNAL_DEPENDENCIES;
  CUmemPool_attribute MEMPOOL_ATTR_RELEASE_THRESHOLD = CU_MEMPOOL_ATTR_RELEASE_THRESHOLD;

  // CHECK: hipMemAllocationHandleType MEM_HANDLE_TYPE_NONE = hipMemHandleTypeNone;
  CUmemAllocationHandleType MEM_HANDLE_TYPE_NONE = CU_MEM_HANDLE_TYPE_NONE;
#endif

#if CUDA_VERSION >= 11030
  // CHECK: hipStreamUpdateCaptureDependenciesFlags StreamUpdateCaptureDependencies_flags;
  // CHECK-NEXT: hipStreamUpdateCaptureDependenciesFlags StreamUpdateCaptureDependencies_flags_enum;
  // CHECK-NEXT: hipStreamUpdateCaptureDependenciesFlags STREAM_ADD_CAPTURE_DEPENDENCIES = hipStreamAddCaptureDependencies;
  // CHECK-NEXT: hipStreamUpdateCaptureDependenciesFlags STREAM_SET_CAPTURE_DEPENDENCIES = hipStreamSetCaptureDependencies;
  CUstreamUpdateCaptureDependencies_flags StreamUpdateCaptureDependencies_flags;
  CUstreamUpdateCaptureDependencies_flags_enum StreamUpdateCaptureDependencies_flags_enum;
  CUstreamUpdateCaptureDependencies_flags STREAM_ADD_CAPTURE_DEPENDENCIES = CU_STREAM_ADD_CAPTURE_DEPENDENCIES;
  CUstreamUpdateCaptureDependencies_flags STREAM_SET_CAPTURE_DEPENDENCIES = CU_STREAM_SET_CAPTURE_DEPENDENCIES;

  // CHECK: hipMemPoolAttr MEMPOOL_ATTR_RESERVED_MEM_CURRENT = hipMemPoolAttrReservedMemCurrent;
  // CHECK-NEXT: hipMemPoolAttr MEMPOOL_ATTR_RESERVED_MEM_HIGH = hipMemPoolAttrReservedMemHigh;
  // CHECK-NEXT: hipMemPoolAttr MEMPOOL_ATTR_USED_MEM_CURRENT = hipMemPoolAttrUsedMemCurrent;
  // CHECK-NEXT: hipMemPoolAttr MEMPOOL_ATTR_USED_MEM_HIGH = hipMemPoolAttrUsedMemHigh;
  CUmemPool_attribute MEMPOOL_ATTR_RESERVED_MEM_CURRENT = CU_MEMPOOL_ATTR_RESERVED_MEM_CURRENT;
  CUmemPool_attribute MEMPOOL_ATTR_RESERVED_MEM_HIGH = CU_MEMPOOL_ATTR_RESERVED_MEM_HIGH;
  CUmemPool_attribute MEMPOOL_ATTR_USED_MEM_CURRENT = CU_MEMPOOL_ATTR_USED_MEM_CURRENT;
  CUmemPool_attribute MEMPOOL_ATTR_USED_MEM_HIGH = CU_MEMPOOL_ATTR_USED_MEM_HIGH;

  // CHECK: hipUserObjectFlags userObject_flags;
  // CHECK-NEXT: hipUserObjectFlags userObject_flags_enum;
  // CHECK-NEXT: hipUserObjectFlags USER_OBJECT_NO_DESTRUCTOR_SYNC = hipUserObjectNoDestructorSync;
  CUuserObject_flags userObject_flags;
  CUuserObject_flags_enum userObject_flags_enum;
  CUuserObject_flags USER_OBJECT_NO_DESTRUCTOR_SYNC = CU_USER_OBJECT_NO_DESTRUCTOR_SYNC;

  // CHECK: hipUserObjectRetainFlags userObjectRetain_flags;
  // CHECK-NEXT: hipUserObjectRetainFlags userObjectRetain_flags_enum;
  // CHECK-NEXT: hipUserObjectRetainFlags GRAPH_USER_OBJECT_MOVE = hipGraphUserObjectMove;
  CUuserObjectRetain_flags userObjectRetain_flags;
  CUuserObjectRetain_flags_enum userObjectRetain_flags_enum;
  CUuserObjectRetain_flags GRAPH_USER_OBJECT_MOVE = CU_GRAPH_USER_OBJECT_MOVE;

  // CHECK: hipPointer_attribute POINTER_ATTRIBUTE_MEMPOOL_HANDLE = HIP_POINTER_ATTRIBUTE_MEMPOOL_HANDLE;
  CUpointer_attribute POINTER_ATTRIBUTE_MEMPOOL_HANDLE = CU_POINTER_ATTRIBUTE_MEMPOOL_HANDLE;

  // CHECK: hipGraphDebugDotFlags graphDebugDot_flags;
  // CHECK-NEXT: hipGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_VERBOSE = hipGraphDebugDotFlagsVerbose;
  // CHECK-NEXT: hipGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_PARAMS = hipGraphDebugDotFlagsKernelNodeParams;
  // CHECK-NEXT: hipGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_MEMCPY_NODE_PARAMS = hipGraphDebugDotFlagsMemcpyNodeParams;
  // CHECK-NEXT: hipGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_MEMSET_NODE_PARAMS = hipGraphDebugDotFlagsMemsetNodeParams;
  // CHECK-NEXT: hipGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_HOST_NODE_PARAMS = hipGraphDebugDotFlagsHostNodeParams;
  // CHECK-NEXT: hipGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_EVENT_NODE_PARAMS = hipGraphDebugDotFlagsEventNodeParams;
  // CHECK-NEXT: hipGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_SIGNAL_NODE_PARAMS = hipGraphDebugDotFlagsExtSemasSignalNodeParams;
  // CHECK-NEXT: hipGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_WAIT_NODE_PARAMS = hipGraphDebugDotFlagsExtSemasWaitNodeParams;
  // CHECK-NEXT: hipGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_ATTRIBUTES = hipGraphDebugDotFlagsKernelNodeAttributes;
  // CHECK-NEXT: hipGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_HANDLES = hipGraphDebugDotFlagsHandles;
  cudaGraphDebugDotFlags graphDebugDot_flags;
  cudaGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_VERBOSE = cudaGraphDebugDotFlagsVerbose;
  cudaGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_PARAMS = cudaGraphDebugDotFlagsKernelNodeParams;
  cudaGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_MEMCPY_NODE_PARAMS = cudaGraphDebugDotFlagsMemcpyNodeParams;
  cudaGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_MEMSET_NODE_PARAMS = cudaGraphDebugDotFlagsMemsetNodeParams;
  cudaGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_HOST_NODE_PARAMS = cudaGraphDebugDotFlagsHostNodeParams;
  cudaGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_EVENT_NODE_PARAMS = cudaGraphDebugDotFlagsEventNodeParams;
  cudaGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_SIGNAL_NODE_PARAMS = cudaGraphDebugDotFlagsExtSemasSignalNodeParams;
  cudaGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_WAIT_NODE_PARAMS = cudaGraphDebugDotFlagsExtSemasWaitNodeParams;
  cudaGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_ATTRIBUTES = cudaGraphDebugDotFlagsKernelNodeAttributes;
  cudaGraphDebugDotFlags GRAPH_DEBUG_DOT_FLAGS_HANDLES = cudaGraphDebugDotFlagsHandles;
#endif

#if CUDA_VERSION >= 11040
  // CHECK: hipGraphInstantiateFlags graphInstantiate_flags;
  // CHECK-NEXT: hipGraphInstantiateFlags graphInstantiate_flags_enum;
  // CHECK-NEXT: hipGraphInstantiateFlags GRAPH_INSTANTIATE_FLAG_AUTO_FREE_ON_LAUNCH = hipGraphInstantiateFlagAutoFreeOnLaunch;
  CUgraphInstantiate_flags graphInstantiate_flags;
  CUgraphInstantiate_flags_enum graphInstantiate_flags_enum;
  CUgraphInstantiate_flags GRAPH_INSTANTIATE_FLAG_AUTO_FREE_ON_LAUNCH = CUDA_GRAPH_INSTANTIATE_FLAG_AUTO_FREE_ON_LAUNCH;

  // CHECK: hipGraphMemAttributeType graphMem_attribute;
  // CHECK-NEXT: hipGraphMemAttributeType graphMem_attribute_enum;
  // CHECK-NEXT: hipGraphMemAttributeType GRAPH_MEM_ATTR_USED_MEM_CURRENT = hipGraphMemAttrUsedMemCurrent;
  // CHECK-NEXT: hipGraphMemAttributeType GRAPH_MEM_ATTR_USED_MEM_HIGH = hipGraphMemAttrUsedMemHigh;
  // CHECK-NEXT: hipGraphMemAttributeType GRAPH_MEM_ATTR_RESERVED_MEM_CURRENT = hipGraphMemAttrReservedMemCurrent;
  // CHECK-NEXT: hipGraphMemAttributeType GRAPH_MEM_ATTR_RESERVED_MEM_HIGH = hipGraphMemAttrReservedMemHigh;
  CUgraphMem_attribute graphMem_attribute;
  CUgraphMem_attribute_enum graphMem_attribute_enum;
  CUgraphMem_attribute GRAPH_MEM_ATTR_USED_MEM_CURRENT = CU_GRAPH_MEM_ATTR_USED_MEM_CURRENT;
  CUgraphMem_attribute GRAPH_MEM_ATTR_USED_MEM_HIGH = CU_GRAPH_MEM_ATTR_USED_MEM_HIGH;
  CUgraphMem_attribute GRAPH_MEM_ATTR_RESERVED_MEM_CURRENT = CU_GRAPH_MEM_ATTR_RESERVED_MEM_CURRENT;
  CUgraphMem_attribute GRAPH_MEM_ATTR_RESERVED_MEM_HIGH = CU_GRAPH_MEM_ATTR_RESERVED_MEM_HIGH;

  // CHECK: hipGraphNodeType GRAPH_NODE_TYPE_MEM_ALLOC = hipGraphNodeTypeMemAlloc;
  // CHECK-NEXT: hipGraphNodeType GRAPH_NODE_TYPE_MEM_FREE = hipGraphNodeTypeMemFree;
  CUgraphNodeType GRAPH_NODE_TYPE_MEM_ALLOC = CU_GRAPH_NODE_TYPE_MEM_ALLOC;
  CUgraphNodeType GRAPH_NODE_TYPE_MEM_FREE = CU_GRAPH_NODE_TYPE_MEM_FREE;
#endif

#if CUDA_VERSION >= 11070
  // CHECK: hipGraphInstantiateFlags GRAPH_INSTANTIATE_FLAG_USE_NODE_PRIORITY = hipGraphInstantiateFlagUseNodePriority;
  CUgraphInstantiate_flags GRAPH_INSTANTIATE_FLAG_USE_NODE_PRIORITY = CUDA_GRAPH_INSTANTIATE_FLAG_USE_NODE_PRIORITY;
#endif

#if CUDA_VERSION >= 12000
  // CHECK: hipDeviceAttribute_t DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR = hipDeviceAttributeCanUseStreamWaitValue;
  CUdevice_attribute DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR = CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR_V1;

  // CHECK: hipGraphInstantiateFlags GRAPH_INSTANTIATE_FLAG_UPLOAD = hipGraphInstantiateFlagUpload;
  // CHECK-NEXT: hipGraphInstantiateFlags GRAPH_INSTANTIATE_FLAG_DEVICE_LAUNCH = hipGraphInstantiateFlagDeviceLaunch;
  CUgraphInstantiate_flags GRAPH_INSTANTIATE_FLAG_UPLOAD = CUDA_GRAPH_INSTANTIATE_FLAG_UPLOAD;
  CUgraphInstantiate_flags GRAPH_INSTANTIATE_FLAG_DEVICE_LAUNCH = CUDA_GRAPH_INSTANTIATE_FLAG_DEVICE_LAUNCH;
#endif

  return 0;
}
