/*
 * Decompiled with CFR 0.152.
 */
package adql.db.region;

import adql.db.region.Region;
import adql.parser.grammar.ParseException;

public final class DALI {
    private DALI() {
    }

    public static Region parseRegion(String daliRegion) throws ParseException {
        if (daliRegion == null || daliRegion.trim().length() == 0) {
            throw new ParseException("Missing DALI expression to parse!");
        }
        String[] values = daliRegion.trim().split("\\s+");
        Region region = null;
        try {
            switch (values.length) {
                case 0: 
                case 1: {
                    throw new ParseException("Incorrect DALI region!");
                }
                case 2: {
                    region = new Region(null, new double[]{Double.parseDouble(values[0]), Double.parseDouble(values[1])});
                    break;
                }
                case 3: {
                    region = new Region(null, new double[]{Double.parseDouble(values[0]), Double.parseDouble(values[1])}, Double.parseDouble(values[2]));
                    break;
                }
                default: {
                    if (values.length >= 6 && values.length % 2 == 0) {
                        double[][] vertices = new double[values.length / 2][2];
                        int i = 0;
                        while (i + 1 < values.length) {
                            vertices[i / 2] = new double[]{Double.parseDouble(values[i]), Double.parseDouble(values[i + 1])};
                            i += 2;
                        }
                        region = new Region(null, vertices);
                    }
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (region == null) {
            throw new ParseException("Incorrect DALI region!");
        }
        return region;
    }

    public static String toDALI(Region region) {
        if (region == null) {
            return null;
        }
        switch (region.type) {
            case POSITION: {
                return region.coordinates[0][0] + " " + region.coordinates[0][1];
            }
            case CIRCLE: {
                return region.coordinates[0][0] + " " + region.coordinates[0][1] + " " + region.radius;
            }
            case POLYGON: {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < region.coordinates.length; ++i) {
                    if (i > 0) {
                        buf.append(' ');
                    }
                    buf.append(region.coordinates[i][0]).append(' ').append(region.coordinates[i][1]);
                }
                return buf.toString();
            }
        }
        return null;
    }
}

