/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.bristol.star.cdf.AttributeEntry;
import uk.ac.bristol.star.cdf.CdfContent;
import uk.ac.bristol.star.cdf.CdfReader;
import uk.ac.bristol.star.cdf.DataType;
import uk.ac.bristol.star.cdf.GlobalAttribute;
import uk.ac.bristol.star.cdf.Variable;
import uk.ac.bristol.star.cdf.VariableAttribute;
import uk.ac.bristol.star.cdf.util.CdfDump;
import uk.ac.bristol.star.cdf.util.LogUtil;

public class CdfList {
    private final CdfContent cdf_;
    private final PrintStream out_;
    private final boolean writeData_;
    private static final String[] NOVARY_MARKS = new String[]{"{ ", " }"};
    private static final String[] VIRTUAL_MARKS = new String[]{"[ ", " ]"};
    private static final String[] REAL_MARKS = new String[]{"  ", ""};

    public CdfList(CdfContent cdfContent, PrintStream printStream, boolean bl) {
        this.cdf_ = cdfContent;
        this.out_ = printStream;
        this.writeData_ = bl;
    }

    public void run() throws IOException {
        Object object;
        int n;
        GlobalAttribute[] globalAttributeArray = this.cdf_.getGlobalAttributes();
        VariableAttribute[] variableAttributeArray = this.cdf_.getVariableAttributes();
        Variable[] variableArray = this.cdf_.getVariables();
        this.header("Global Attributes");
        for (n = 0; n < globalAttributeArray.length; ++n) {
            object = globalAttributeArray[n];
            this.out_.println("    " + ((GlobalAttribute)object).getName());
            AttributeEntry[] attributeEntryArray = ((GlobalAttribute)object).getEntries();
            for (int i = 0; i < attributeEntryArray.length; ++i) {
                this.out_.println("        " + attributeEntryArray[i]);
            }
        }
        for (n = 0; n < variableArray.length; ++n) {
            Object object2;
            this.out_.println();
            object = variableArray[n];
            this.header("Variable " + ((Variable)object).getNum() + ": " + ((Variable)object).getName() + "  ---  " + ((Variable)object).getSummary());
            for (int i = 0; i < variableAttributeArray.length; ++i) {
                object2 = variableAttributeArray[i];
                AttributeEntry attributeEntry = ((VariableAttribute)object2).getEntry((Variable)object);
                if (attributeEntry == null) continue;
                this.out_.println("    " + ((VariableAttribute)object2).getName() + ":\t" + attributeEntry);
            }
            if (!this.writeData_) continue;
            DataType dataType = ((Variable)object).getDataType();
            object2 = ((Variable)object).createRawValueArray();
            boolean bl = ((Variable)object).getRecordVariance();
            int n2 = ((Variable)object).getRecordCount();
            int n3 = Integer.toString(n2).length();
            for (int i = 0; i < n2; ++i) {
                ((Variable)object).readRawRecord(i, object2);
                String[] stringArray = !bl ? NOVARY_MARKS : (!((Variable)object).hasRecord(i) ? VIRTUAL_MARKS : REAL_MARKS);
                String string = Integer.toString(i);
                StringBuffer stringBuffer = new StringBuffer().append(stringArray[0]).append(CdfDump.spaces(n3 - string.length())).append(string).append(':').append('\t').append(this.formatValues(object2, dataType)).append(stringArray[1]);
                this.out_.println(stringBuffer.toString());
            }
        }
    }

    private String formatValues(Object object, DataType dataType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null) {
            if (object.getClass().isArray()) {
                int n = dataType.getGroupSize();
                int n2 = Array.getLength(object);
                for (int i = 0; i < n2; i += n) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(dataType.formatArrayValue(object, i));
                }
            } else {
                stringBuffer.append(dataType.formatScalarValue(object));
            }
        }
        return stringBuffer.toString();
    }

    private void header(String string) {
        this.out_.println(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append('-');
        }
        this.out_.println(stringBuffer.toString());
    }

    public static int runMain(String[] stringArray) throws IOException {
        String string = new StringBuffer().append("\n   Usage: ").append(CdfList.class.getName()).append(" [-help]").append(" [-verbose]").append(" [-data]").append(" <cdf-file>").append("\n").toString();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        File file = null;
        boolean bl = false;
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.startsWith("-h")) {
                iterator.remove();
                System.out.println(string);
                return 0;
            }
            if (string2.equals("-verbose") || string2.equals("-v")) {
                iterator.remove();
                ++n;
                continue;
            }
            if (string2.equals("+verbose") || string2.equals("+v")) {
                iterator.remove();
                --n;
                continue;
            }
            if (string2.equals("-data")) {
                iterator.remove();
                bl = true;
                continue;
            }
            if (file != null) continue;
            iterator.remove();
            file = new File(string2);
        }
        if (!arrayList.isEmpty()) {
            System.err.println("Unused args: " + arrayList);
            System.err.println(string);
            return 1;
        }
        if (file == null) {
            System.err.println(string);
            return 1;
        }
        LogUtil.setVerbosity(n);
        new CdfList(new CdfContent(new CdfReader(file)), System.out, bl).run();
        return 0;
    }

    public static void main(String[] stringArray) throws IOException {
        int n = CdfList.runMain(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }
}

