use super::{Command, Representation};
use clap::Args;
use rdftk_core::error::Error;
use std::process::ExitCode;

// ------------------------------------------------------------------------------------------------
// Public Macros
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Public Types
// ------------------------------------------------------------------------------------------------

#[derive(Args, Debug)]
pub(crate) struct ConvertCmd {
    /// File name to write to, or '-' to write to stdout
    #[arg(short, long)]
    #[clap(value_parser, default_value = "-")]
    output: clio::Output,

    #[arg(short = 'f', long)]
    #[arg(value_enum)]
    from: Representation,

    /// Input SDML file name to read from, or '-' to read from stdin
    #[arg(short, long)]
    #[clap(value_parser, default_value = "-")]
    input: clio::Input,

    #[arg(short = 't', long)]
    #[arg(value_enum)]
    #[arg(default_value_t = Representation::Turtle)]
    to: Representation,
}

// ------------------------------------------------------------------------------------------------
// Public Functions
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Private Macros
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Private Types
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Implementations
// ------------------------------------------------------------------------------------------------

impl Command for ConvertCmd {
    fn execute(mut self) -> Result<ExitCode, Error> {
        let graph = super::read_graph(&mut self.input, self.from)?;
        super::write_graph(&graph, &mut self.output, self.to)?;
        Ok(ExitCode::SUCCESS)
    }
}

// ------------------------------------------------------------------------------------------------
// Private Functions
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Modules
// ------------------------------------------------------------------------------------------------
