# -*- mode: ruby; coding: utf-8; -*-
require 'gem2deb/rake/spectask'
require 'fileutils'

task :default => :post

task :spec => :pre do
  Gem2Deb::Rake::RSpecTask.new do |t|
    t.pattern = 'spec/*_spec.rb'
  end
end

task :pre do
  if File.exists?(".gem2deb.lib")
    FileUtils.symlink(".gem2deb.lib", "lib", force: true)
  end
  if File.exists?(".gem2deb.ext")
    FileUtils.symlink(".gem2deb.ext", "ext", force: true)
  end
end

task :post => :spec do
  if File.exists?(".gem2deb.lib")
    FileUtils.remove("lib", force: true)
  end
  if File.exists?(".gem2deb.ext")
    FileUtils.remove("ext", force: true)
  end
end
