% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textUtils.R
\name{escape}
\alias{escape}
\title{Text that is to be included as content in documents is cleaned
(escaped) to prevent errors}
\usage{
escape(x, type = "tex")
}
\arguments{
\item{x}{a string, or vector of strings (each of which is
processed separately)}

\item{type}{"tex" is default, could be "filename" or "html"}
}
\value{
corrected character vector
}
\description{
This is for fixing up "untrusted text" that is to be passed into a
file as content. It protects against "bad" text strings in 3
contexts, 1) LaTeX documents, 2) HTML documents, or 3) text in a
file name. It converts content text to an improved string that
will not cause failures in the eventual document.
}
\details{
The special in-document LaTeX symbols like percent sign or dollar sign
are "\%" and "\$". *Warning*: In the R
session, these will appear as double-backslashed symbols, while in
a saved text file, there will only be the one desired slash.

If type = "html", we only clean up <, >, / and &, and quote
characters.  If document is in unicode, we don't need to do the
gigantic set anymore.

If type = "filename", then symbols that are not allowed in file
names, such as "\", "*", are replaced. Do not use this on a
full path, since it will obliterate path separators.
}
\examples{
x1 <- c("_asdf&_&$", "asd adf asd_", "^ \% & $asdf_")
escape(x1)
x2 <- c("a>b", "a<b", "a < c", 'Paul "pj" Johnson')
escape(x2, type = "tex")
escape(x2, type = "html")
escape(x2, type = "filename")
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
