% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_rows.R
\name{collapse_rows}
\alias{collapse_rows}
\title{Collapse repeated rows to multirow cell}
\usage{
collapse_rows(
  kable_input,
  columns = NULL,
  valign = c("middle", "top", "bottom"),
  latex_hline = c("full", "major", "none", "custom", "linespace"),
  row_group_label_position = c("identity", "stack", "first"),
  custom_latex_hline = NULL,
  row_group_label_fonts = NULL,
  headers_to_remove = NULL,
  target = NULL,
  col_names = TRUE,
  longtable_clean_cut = TRUE
)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{columns}{A numeric value or vector indicating in which column(s) rows
need to be collapsed.}

\item{valign}{Select from "top", "middle" (default), "bottom". The reason why
"top" is not default is that the multirow package on CRAN win-builder is
not up to date.
Only used when \code{row_group_label_position} is \code{identity}.}

\item{latex_hline}{Option controlling the behavior of adding hlines to table.
Choose from \code{full}, \code{major}, \code{none}, \code{custom} and \code{linespace}.}

\item{row_group_label_position}{Option controlling positions of row group
labels. Choose from \code{identity}, \code{stack}, or \code{first} -- the latter behaves
like \code{identity} when \code{row_group_label_position} is \code{top} but without using
the multirow package.}

\item{custom_latex_hline}{Numeric column positions whose collapsed rows will
be separated by hlines.}

\item{row_group_label_fonts}{A list of arguments that can be supplied to
group_rows function to format the row group label when
\code{row_group_label_position} is \code{stack}.}

\item{headers_to_remove}{Numeric column positions where headers should be
removed when they are stacked.}

\item{target}{If multiple columns are selected to do collapsing and a target
column is specified, this target column will be used to collapse other
columns based on the groups of this target column.}

\item{col_names}{T/F. A LaTeX specific option. If you set \code{col.names} be
\code{NULL} in your \code{kable} call, you need to set this option false to let
everything work properly.}

\item{longtable_clean_cut}{T/F with default T. Multirow cell sometimes are
displayed incorrectly around pagebreak. This option forces groups to cut
before the end of a page. If you have a group that is longer than 1 page,
you need to turn off this option.}
}
\description{
Collapse same values in columns into multirow cells. This
feature does similar things with \code{group_rows}. However, unlike \code{group_rows},
it analyzes existing columns, finds out rows that can be grouped together,
and make them multirow cells. Note that if you want to use \code{column_spec} to
specify column styles, you should use \code{column_spec} before \code{collapse_rows}.
}
\examples{
\dontrun{
dt <- data.frame(a = c(1, 1, 2, 2), b = c("a", "a", "a", "b"))
x <- knitr::kable(dt, "html")
collapse_rows(x)
}

}
