% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvisAnnotatedTimeLine.R
\name{gvisAnnotatedTimeLine}
\alias{gvisAnnotatedTimeLine}
\title{Google Annotated Time Line with R
\Sexpr{googleChartName <- "annotatedtimeline"}
\Sexpr{gvisChartName <- "gvisAnnotatedTimeLine"}}
\usage{
gvisAnnotatedTimeLine(
  data,
  datevar = "",
  numvar = "",
  idvar = "",
  titlevar = "",
  annotationvar = "",
  date.format = "\%Y/\%m/\%d",
  options = list(),
  chartid
)
}
\arguments{
\item{data}{a \code{data.frame}. The data has to have at least two columns,
one with date information (\code{datevar}) and one numerical variable.}

\item{datevar}{column name of \code{data} which shows the date dimension.
The information has to be of class \code{\link{Date}} or \code{POSIX*} time
series.}

\item{numvar}{column name of \code{data} which shows the values to be
displayed against \code{datevar}. The information has to be
\code{\link{numeric}}.}

\item{idvar}{column name of \code{data} which identifies different groups of
the data. The information has to be of class \code{\link{character}} or
\code{\link{factor}}.}

\item{titlevar}{column name of \code{data} which shows the title of the
annotations. The information has to be of class \code{\link{character}} or
\code{\link{factor}}.  Missing information can be set to \code{NA}. See
section 'Details' for more details.}

\item{annotationvar}{column name of \code{data} which shows the annotation
text. The information has to be of class \code{\link{character}} or
\code{\link{factor}}. Missing information can be set to \code{NA}. See
section 'Details' for more details.}

\item{date.format}{if \code{datevar} is of class \code{\link{Date}} then
this argument specifies how the dates are reformatted to be used by
JavaScript.}

\item{options}{list of configuration options, see:

% START DYNAMIC CONTENT

\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName,
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURLConfigOptions.txt")))}

 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOptions.txt")))}}

\item{chartid}{character. If missing (default) a random chart id will be 
generated based on chart type and \code{\link{tempfile}}}
}
\value{
\Sexpr[results=rd]{paste(gvisChartName)} returns list 
of \code{\link{class}}
 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOutputStructure.txt")))}
}
\description{
The gvisAnnotatedTimeLine function reads a data.frame and creates text
output referring to the Google Visualisation API, which can be included into
a web page, or as a stand-alone page.
}
\details{
An annotated time line is an interactive time series line chart with
optional annotations. The chart is rendered within the browser using Flash.
}
\section{Warnings}{

AnnotatedTimeline (gvisAnnotatedTimeLine) is no longer supported by Google. 
The annotated timeline now automatically uses Annotation Charts instead.

Important: To use this visualization, you must specify the height and width 
of the container element explicitly on your page. So, for example:
options=list(width="600px", height="350px")

Use \code{\link{gvisAnnotationChart}} for a non-Flash version of this plot.
}

\examples{

## Please note that by default the googleVis plot command
## will open a browser window and requires Flash and Internet
## connection to display the visualisation.


data(Stock)
Stock
A1 <- gvisAnnotatedTimeLine(Stock, datevar="Date",
                           numvar="Value", idvar="Device",
                           titlevar="Title", annotationvar="Annotation",
                           options=list(displayAnnotations=TRUE,
                            legendPosition='newRow',
                            width="600px", height="350px")
                           )
plot(A1)

## Two Y-axis
A2 <- gvisAnnotatedTimeLine(Stock, datevar="Date",
                           numvar="Value", idvar="Device",
                           titlevar="Title", annotationvar="Annotation",
                           options=list(displayAnnotations=TRUE, 
                            width="600px", height="350px", scaleColumns='[0,1]',
                            scaleType='allmaximized')
                          )
plot(A2)



## Colouring the area below the lines to create an area chart
A3 <- gvisAnnotatedTimeLine(Stock, datevar="Date",
                           numvar="Value", idvar="Device",
                           titlevar="Title", annotationvar="Annotation",
                           options=list(
                             width="600px", height="350px",
                             fill=10, displayExactValues=TRUE,
                             colors="['#0000ff','#00ff00']")
                           )
                          
plot(A3)


## Data with POSIXct datetime variable
A4 <- gvisAnnotatedTimeLine(Andrew, datevar="Date/Time UTC",
                            numvar="Pressure_mb",
                            options=list(scaleType='maximized',
                                         width="600px", height="350px")
                            )

plot(A4)



}
\references{
Google Chart Tools API: 
\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName, 
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURL.txt")))}

% END DYNAMIC CONTENT
}
\seealso{
See also \code{\link{print.gvis}}, \code{\link{plot.gvis}} for printing and
plotting methods. Further see \code{\link{reshape}} for reshaping data, e.g.
from a wide format into a long format.
}
\author{
Markus Gesmann \email{markus.gesmann@gmail.com},

Diego de Castillo \email{decastillo@gmail.com}
}
\keyword{iplot}
