% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical.R
\name{GDCprepare_clinic}
\alias{GDCprepare_clinic}
\title{Parsing clinical xml files}
\usage{
GDCprepare_clinic(query, clinical.info, directory = "GDCdata")
}
\arguments{
\item{query}{Result from GDCquery, with data.category set to Clinical}

\item{clinical.info}{Which information should be retrieved.
Options Clinical: drug, admin, follow_up,radiation, patient, stage_event or new_tumor_event
Options Biospecimen: protocol, admin, aliquot, analyte, bio_patient, sample, portion, slide}

\item{directory}{Directory/Folder where the data was downloaded. Default: GDCdata}
}
\value{
A data frame with the parsed values from the XML
}
\description{
This function receives the query argument and parses the clinical xml files
based on the desired information
}
\examples{
query <- GDCquery(project = "TCGA-COAD",
                  data.category = "Clinical",
                  file.type = "xml",
                  barcode = c("TCGA-RU-A8FL","TCGA-AA-3972"))
GDCdownload(query)
clinical <- GDCprepare_clinic(query,"patient")
clinical.drug <- GDCprepare_clinic(query,"drug")
clinical.radiation <- GDCprepare_clinic(query,"radiation")
clinical.admin <- GDCprepare_clinic(query,"admin")
query <- GDCquery(
   project = "TCGA-COAD",
   data.category = "Biospecimen",
   file.type = "xml",
   data.type = "Biospecimen Supplement",
   barcode = c("TCGA-RU-A8FL","TCGA-AA-3972")
)
GDCdownload(query)
clinical <- GDCprepare_clinic(query,"admin")
clinical.drug <- GDCprepare_clinic(query,"sample")
clinical.radiation <- GDCprepare_clinic(query,"portion")
clinical.admin <- GDCprepare_clinic(query,"slide")
}
