% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExpression.R
\name{plotExpression}
\alias{plotExpression}
\title{Plot expression values for all cells}
\usage{
plotExpression(
  object,
  features,
  x = NULL,
  exprs_values = "logcounts",
  log2_values = FALSE,
  colour_by = NULL,
  shape_by = NULL,
  size_by = NULL,
  by_exprs_values = exprs_values,
  xlab = NULL,
  feature_colours = TRUE,
  one_facet = TRUE,
  ncol = 2,
  scales = "fixed",
  other_fields = list(),
  swap_rownames = NULL,
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object containing expression values and other metadata.}

\item{features}{A character vector or a list specifying the features to plot.
If a list is supplied, each entry of the list can be a string, an AsIs-wrapped vector or a data.frame - see \code{?\link{retrieveCellInfo}}.}

\item{x}{Specification of a column metadata field or a feature to show on the x-axis, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{exprs_values}{A string or integer scalar specifying which assay in \code{assays(object)} to obtain expression values from.}

\item{log2_values}{Logical scalar, specifying whether the expression values be transformed to the log2-scale for plotting (with an offset of 1 to avoid logging zeroes).}

\item{colour_by}{Specification of a column metadata field or a feature to colour by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{shape_by}{Specification of a column metadata field or a feature to shape by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{size_by}{Specification of a column metadata field or a feature to size by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{by_exprs_values}{A string or integer scalar specifying which assay to obtain expression values from, 
for use in point aesthetics - see the \code{exprs_values} argument in \code{?\link{retrieveCellInfo}}.}

\item{xlab}{String specifying the label for x-axis.
If \code{NULL} (default), \code{x} will be used as the x-axis label.}

\item{feature_colours}{Logical scalar indicating whether violins should be coloured by feature when \code{x} and \code{colour_by} are not specified and \code{one_facet=TRUE}.}

\item{one_facet}{Logical scalar indicating whether grouped violin plots for multiple features should be put onto one facet.
Only relevant when \code{x=NULL}.}

\item{ncol}{Integer scalar, specifying the number of columns to be used for the panels of a multi-facet plot.}

\item{scales}{String indicating whether should multi-facet scales be fixed (\code{"fixed"}), free (\code{"free"}), or free in one dimension (\code{"free_x"}, \code{"free_y"}).
Passed to the \code{scales} argument in the \code{\link[ggplot2]{facet_wrap}} when multiple facets are generated.}

\item{other_fields}{Additional cell-based fields to include in the data.frame, see \code{?"\link{scater-plot-args}"} for details.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to 
identify features instead of \code{rownames(object)} when labelling plot 
elements.}

\item{...}{Additional arguments for visualization, see \code{?"\link{scater-plot-args}"} for details.}
}
\value{
A ggplot object.
}
\description{
Plot expression values for a set of features (e.g. genes or transcripts) in a SingleExperiment object, against a continuous or categorical covariate for all cells.
}
\details{
This function plots expression values for one or more features.
If \code{x} is not specified, a violin plot will be generated of expression values.
If \code{x} is categorical, a grouped violin plot will be generated, with one violin for each level of \code{x}.
If \code{x} is continuous, a scatter plot will be generated.

If multiple features are requested and \code{x} is not specified and \code{one_facet=TRUE}, a grouped violin plot will be generated with one violin per feature.
This will be coloured by feature if \code{colour_by=NULL} and \code{feature_colours=TRUE}, to yield a more aesthetically pleasing plot.
Otherwise, if \code{x} is specified or \code{one_facet=FALSE}, a multi-panel plot will be generated where each panel corresponds to a feature.
Each panel will be a scatter plot or (grouped) violin plot, depending on the nature of \code{x}.

Note that this assumes that the expression values are numeric.
If not, and \code{x} is continuous, horizontal violin plots will be generated.
If \code{x} is missing or categorical, rectangule plots will be generated where the area of a rectangle is proportional to the number of points for a combination of factors.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)

## default plot
plotExpression(example_sce, rownames(example_sce)[1:15])

## plot expression against an x-axis value
plotExpression(example_sce, c("Gene_0001", "Gene_0004"), 
    x="Mutation_Status")
plotExpression(example_sce, c("Gene_0001", "Gene_0004"), 
    x="Gene_0002")

## add visual options
plotExpression(example_sce, rownames(example_sce)[1:6], 
    colour_by = "Mutation_Status")
plotExpression(example_sce, rownames(example_sce)[1:6], 
    colour_by = "Mutation_Status", shape_by = "Treatment", 
    size_by = "Gene_0010")

## plot expression against expression values for Gene_0004
plotExpression(example_sce, rownames(example_sce)[1:4],
    "Gene_0004", show_smooth = TRUE)

}
\author{
Davis McCarthy, with modifications by Aaron Lun
}
