% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/378-extractDrugKR.R
\name{extractDrugKR}
\alias{extractDrugKR}
\title{Calculate the KR (Klekota and Roth) Molecular Fingerprints (in Compact Format)}
\usage{
extractDrugKR(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A list, each component represents one of the molecules, each element
in the component represents the index of which element in the fingerprint is 1.
Each component's name is the length of the fingerprints.
}
\description{
Calculate the KR (Klekota and Roth) Molecular Fingerprints (in Compact Format)
}
\details{
Calculate the 4860 bit fingerprint defined by Klekota and Roth.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
fp  = extractDrugKR(mol)
head(fp)}
}
\seealso{
\link{extractDrugKRComplete}
}
