% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pfam.R
\name{read_pfam}
\alias{read_pfam}
\title{Read Pfam file into R}
\usage{
read_pfam(path)
}
\arguments{
\item{path}{A string indicating the full path to the Pfam result file}
}
\value{
A data.frame with the Pfam results
}
\description{
Read Pfam result file file into R. Supports both result files from local and web-server
}
\details{
The pfam webserver can be found at \url{https://www.ebi.ac.uk/Tools/hmmer/search/hmmscan}.
}
\examples{
pfamResultFile <- system.file("extdata/pfam_results.txt", package = "pfamAnalyzeR")
pfamRes <- read_pfam(pfamResultFile)
}
