\name{plotMCS}
\alias{plotMCS}
\title{
Plot MCS
}
\description{
Convenience plotting function to visualize and compare MCSs generated by \code{fmcs} function. 
}
\usage{
plotMCS(x, mcs = 1, print = FALSE, ...)
}
\arguments{
  \item{x}{
\code{MCS} object
}
  \item{mcs}{
Selection of MCS solution by position number, default is 1.
}
  \item{print}{
\code{print=FALSE} turns of printing behavior of class. 
}
  \item{\dots}{
Arguments to be passed to/from other methods.
}
}
\details{
The two structures, target and query, used to generate \code{x} with a call to \code{fmcs} are plotted next to each other, and the corresponding MCS substructures are highlighted in color.}
\value{
Prints summary of MCS to screen and plots their structures to graphics device.
}
\references{
...
}
\author{
Yan Wang
}
\note{
...
}
\seealso{
\code{sdf.visualize}
}
\examples{
library(fmcsR)
data(sdfsample)
sdfset <- sdfsample
mcs <- fmcs(sdfset[[1]], sdfset[[2]], au=2, bu=1, matching.mode="aromatic")
plotMCS(mcs, mcs=1)
}
\keyword{ utilities }
