% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnoyIndex-class.R
\docType{class}
\name{AnnoyIndex}
\alias{AnnoyIndex}
\alias{AnnoyIndex-class}
\alias{show,AnnoyIndex-method}
\alias{bnorder,AnnoyIndex-method}
\alias{AnnoyIndex_path}
\alias{AnnoyIndex_search_mult}
\title{The AnnoyIndex class}
\usage{
AnnoyIndex(data, path, search.mult = 50, NAMES = NULL, distance = "Euclidean")
}
\arguments{
\item{data}{A numeric matrix with data points in columns and dimensions in rows.}

\item{path}{A string specifying the path to the index file.}

\item{search.mult}{Numeric scalar, multiplier for the number of points to search.}

\item{NAMES}{A character vector of sample names or \code{NULL}.}

\item{distance}{A string specifying the distance metric to use.}
}
\value{
An instance of the AnnoyIndex class.
}
\description{
A class to hold indexing structures for the Annoy algorithm for approximate nearest neighbor identification.
}
\details{
The AnnoyIndex class holds the indexing structure required to run the Annoy algorithm.
Users should never need to call the constructor explicitly, but should generate instances of AnnoyIndex classes with \code{\link{buildAnnoy}}.

Users can get values from an AnnoyIndex object with the usual \code{[[} syntax.
All parameters listed in the constructor can be extracted in this manner.
}
\examples{
example(buildAnnoy)
out[['path']]
bndistance(out)
str(bndata(out))

}
\seealso{
\code{\link{buildAnnoy}}, for the index construction.

\linkS4class{BiocNeighborIndex}, for the parent class and its available methods.
}
\author{
Aaron Lun
}
