% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveDataFrameList.R
\name{saveObject,CompressedSplitDataFrameList-method}
\alias{saveObject,CompressedSplitDataFrameList-method}
\alias{stageObject,CompressedSplitDataFrameList-method}
\title{Save compressed lists of data frames to disk}
\usage{
\S4method{saveObject}{CompressedSplitDataFrameList}(x, path, ...)
}
\arguments{
\item{x}{A \linkS4class{CompressedSplitDataFrameList} object.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments to pass to specific methods.}
}
\value{
\code{x} is saved to \code{path}, and \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{CompressedSplitDataFrameList} object to its on-disk representation.
}
\examples{
library(S4Vectors)
Y <- splitAsList(DataFrame(Xxx=LETTERS, Yyy=1:26), sample(3, 26, replace=TRUE))

tmp <- tempfile()
saveObject(Y, tmp)
list.files(tmp, recursive=TRUE)

}
\seealso{
\code{\link{readDataFrameList}}, to read a \linkS4class{CompressedSplitDataFrameList} from disk.
}
\author{
Aaron Lun
}
