# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._artifacts_client_enums import *


class Activity(msrest.serialization.Model):
    """A pipeline activity.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AppendVariableActivity, ControlActivity, ExecutePipelineActivity, ExecutionActivity, FilterActivity, ForEachActivity, IfConditionActivity, SetVariableActivity, SwitchActivity, UntilActivity, ValidationActivity, WaitActivity, WebHookActivity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
    }

    _subtype_map = {
        'type': {'AppendVariable': 'AppendVariableActivity', 'Container': 'ControlActivity', 'ExecutePipeline': 'ExecutePipelineActivity', 'Execution': 'ExecutionActivity', 'Filter': 'FilterActivity', 'ForEach': 'ForEachActivity', 'IfCondition': 'IfConditionActivity', 'SetVariable': 'SetVariableActivity', 'Switch': 'SwitchActivity', 'Until': 'UntilActivity', 'Validation': 'ValidationActivity', 'Wait': 'WaitActivity', 'WebHook': 'WebHookActivity'}
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        **kwargs
    ):
        super(Activity, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.type: str = 'Activity'
        self.description = description
        self.depends_on = depends_on
        self.user_properties = user_properties


class ActivityDependency(msrest.serialization.Model):
    """Activity dependency information.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param activity: Required. Activity name.
    :type activity: str
    :param dependency_conditions: Required. Match-Condition for the dependency.
    :type dependency_conditions: list[str or ~azure.synapse.artifacts.models.DependencyCondition]
    """

    _validation = {
        'activity': {'required': True},
        'dependency_conditions': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'activity': {'key': 'activity', 'type': 'str'},
        'dependency_conditions': {'key': 'dependencyConditions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        activity: str,
        dependency_conditions: List[Union[str, "DependencyCondition"]],
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(ActivityDependency, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.activity = activity
        self.dependency_conditions = dependency_conditions


class ActivityPolicy(msrest.serialization.Model):
    """Execution policy for an activity.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param timeout: Specifies the timeout for the activity to run. The default timeout is 7 days.
     Type: string (or Expression with resultType string), pattern:
     ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type timeout: object
    :param retry: Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with
     resultType integer), minimum: 0.
    :type retry: object
    :param retry_interval_in_seconds: Interval between each retry attempt (in seconds). The default
     is 30 sec.
    :type retry_interval_in_seconds: int
    :param secure_input: When set to true, Input from activity is considered as secure and will not
     be logged to monitoring.
    :type secure_input: bool
    :param secure_output: When set to true, Output from activity is considered as secure and will
     not be logged to monitoring.
    :type secure_output: bool
    """

    _validation = {
        'retry_interval_in_seconds': {'maximum': 86400, 'minimum': 30},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'timeout': {'key': 'timeout', 'type': 'object'},
        'retry': {'key': 'retry', 'type': 'object'},
        'retry_interval_in_seconds': {'key': 'retryIntervalInSeconds', 'type': 'int'},
        'secure_input': {'key': 'secureInput', 'type': 'bool'},
        'secure_output': {'key': 'secureOutput', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        timeout: Optional[object] = None,
        retry: Optional[object] = None,
        retry_interval_in_seconds: Optional[int] = None,
        secure_input: Optional[bool] = None,
        secure_output: Optional[bool] = None,
        **kwargs
    ):
        super(ActivityPolicy, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.timeout = timeout
        self.retry = retry
        self.retry_interval_in_seconds = retry_interval_in_seconds
        self.secure_input = secure_input
        self.secure_output = secure_output


class ActivityRun(msrest.serialization.Model):
    """Information about an activity run in a pipeline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar pipeline_name: The name of the pipeline.
    :vartype pipeline_name: str
    :ivar pipeline_run_id: The id of the pipeline run.
    :vartype pipeline_run_id: str
    :ivar activity_name: The name of the activity.
    :vartype activity_name: str
    :ivar activity_type: The type of the activity.
    :vartype activity_type: str
    :ivar activity_run_id: The id of the activity run.
    :vartype activity_run_id: str
    :ivar linked_service_name: The name of the compute linked service.
    :vartype linked_service_name: str
    :ivar status: The status of the activity run.
    :vartype status: str
    :ivar activity_run_start: The start time of the activity run in 'ISO 8601' format.
    :vartype activity_run_start: ~datetime.datetime
    :ivar activity_run_end: The end time of the activity run in 'ISO 8601' format.
    :vartype activity_run_end: ~datetime.datetime
    :ivar duration_in_ms: The duration of the activity run.
    :vartype duration_in_ms: int
    :ivar input: The input for the activity.
    :vartype input: object
    :ivar output: The output for the activity.
    :vartype output: object
    :ivar error: The error if any from the activity run.
    :vartype error: object
    """

    _validation = {
        'pipeline_name': {'readonly': True},
        'pipeline_run_id': {'readonly': True},
        'activity_name': {'readonly': True},
        'activity_type': {'readonly': True},
        'activity_run_id': {'readonly': True},
        'linked_service_name': {'readonly': True},
        'status': {'readonly': True},
        'activity_run_start': {'readonly': True},
        'activity_run_end': {'readonly': True},
        'duration_in_ms': {'readonly': True},
        'input': {'readonly': True},
        'output': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'pipeline_name': {'key': 'pipelineName', 'type': 'str'},
        'pipeline_run_id': {'key': 'pipelineRunId', 'type': 'str'},
        'activity_name': {'key': 'activityName', 'type': 'str'},
        'activity_type': {'key': 'activityType', 'type': 'str'},
        'activity_run_id': {'key': 'activityRunId', 'type': 'str'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'activity_run_start': {'key': 'activityRunStart', 'type': 'iso-8601'},
        'activity_run_end': {'key': 'activityRunEnd', 'type': 'iso-8601'},
        'duration_in_ms': {'key': 'durationInMs', 'type': 'int'},
        'input': {'key': 'input', 'type': 'object'},
        'output': {'key': 'output', 'type': 'object'},
        'error': {'key': 'error', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(ActivityRun, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.pipeline_name = None
        self.pipeline_run_id = None
        self.activity_name = None
        self.activity_type = None
        self.activity_run_id = None
        self.linked_service_name = None
        self.status = None
        self.activity_run_start = None
        self.activity_run_end = None
        self.duration_in_ms = None
        self.input = None
        self.output = None
        self.error = None


class ActivityRunsQueryResponse(msrest.serialization.Model):
    """A list activity runs.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of activity runs.
    :type value: list[~azure.synapse.artifacts.models.ActivityRun]
    :param continuation_token: The continuation token for getting the next page of results, if any
     remaining results exist, null otherwise.
    :type continuation_token: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ActivityRun]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ActivityRun"],
        continuation_token: Optional[str] = None,
        **kwargs
    ):
        super(ActivityRunsQueryResponse, self).__init__(**kwargs)
        self.value = value
        self.continuation_token = continuation_token


class AddDataFlowToDebugSessionResponse(msrest.serialization.Model):
    """Response body structure for starting data flow debug session.

    :param job_version: The ID of data flow debug job version.
    :type job_version: str
    """

    _attribute_map = {
        'job_version': {'key': 'jobVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_version: Optional[str] = None,
        **kwargs
    ):
        super(AddDataFlowToDebugSessionResponse, self).__init__(**kwargs)
        self.job_version = job_version


class LinkedService(msrest.serialization.Model):
    """The Azure Synapse nested object which contains the information and credential which can be used to connect with related store or compute resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSLinkedService, AmazonRedshiftLinkedService, AmazonS3LinkedService, AzureBatchLinkedService, AzureBlobFSLinkedService, AzureBlobStorageLinkedService, AzureDataExplorerLinkedService, AzureDataLakeAnalyticsLinkedService, AzureDataLakeStoreLinkedService, AzureDatabricksLinkedService, AzureFileStorageLinkedService, AzureFunctionLinkedService, AzureKeyVaultLinkedService, AzureMLLinkedService, AzureMLServiceLinkedService, AzureMariaDBLinkedService, AzureMySqlLinkedService, AzurePostgreSqlLinkedService, AzureSearchLinkedService, AzureSqlDWLinkedService, AzureSqlDatabaseLinkedService, AzureSqlMILinkedService, AzureStorageLinkedService, AzureTableStorageLinkedService, CassandraLinkedService, CommonDataServiceForAppsLinkedService, ConcurLinkedService, CosmosDbLinkedService, CosmosDbMongoDbApiLinkedService, CouchbaseLinkedService, CustomDataSourceLinkedService, Db2LinkedService, DrillLinkedService, DynamicsLinkedService, DynamicsAXLinkedService, DynamicsCrmLinkedService, EloquaLinkedService, FileServerLinkedService, FtpServerLinkedService, GoogleAdWordsLinkedService, GoogleBigQueryLinkedService, GoogleCloudStorageLinkedService, GreenplumLinkedService, HBaseLinkedService, HDInsightLinkedService, HDInsightOnDemandLinkedService, HdfsLinkedService, HiveLinkedService, HttpLinkedService, HubspotLinkedService, ImpalaLinkedService, InformixLinkedService, JiraLinkedService, MagentoLinkedService, MariaDBLinkedService, MarketoLinkedService, MicrosoftAccessLinkedService, MongoDbLinkedService, MongoDbV2LinkedService, MySqlLinkedService, NetezzaLinkedService, ODataLinkedService, OdbcLinkedService, Office365LinkedService, OracleLinkedService, OracleServiceCloudLinkedService, PaypalLinkedService, PhoenixLinkedService, PostgreSqlLinkedService, PrestoLinkedService, QuickBooksLinkedService, ResponsysLinkedService, RestServiceLinkedService, SalesforceLinkedService, SalesforceMarketingCloudLinkedService, SalesforceServiceCloudLinkedService, SapBWLinkedService, SapCloudForCustomerLinkedService, SapEccLinkedService, SapHanaLinkedService, SapOpenHubLinkedService, SapTableLinkedService, ServiceNowLinkedService, SftpServerLinkedService, ShopifyLinkedService, SparkLinkedService, SqlServerLinkedService, SquareLinkedService, SybaseLinkedService, TeradataLinkedService, VerticaLinkedService, WebLinkedService, XeroLinkedService, ZohoLinkedService.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
    }

    _subtype_map = {
        'type': {'AmazonMWS': 'AmazonMWSLinkedService', 'AmazonRedshift': 'AmazonRedshiftLinkedService', 'AmazonS3': 'AmazonS3LinkedService', 'AzureBatch': 'AzureBatchLinkedService', 'AzureBlobFS': 'AzureBlobFSLinkedService', 'AzureBlobStorage': 'AzureBlobStorageLinkedService', 'AzureDataExplorer': 'AzureDataExplorerLinkedService', 'AzureDataLakeAnalytics': 'AzureDataLakeAnalyticsLinkedService', 'AzureDataLakeStore': 'AzureDataLakeStoreLinkedService', 'AzureDatabricks': 'AzureDatabricksLinkedService', 'AzureFileStorage': 'AzureFileStorageLinkedService', 'AzureFunction': 'AzureFunctionLinkedService', 'AzureKeyVault': 'AzureKeyVaultLinkedService', 'AzureML': 'AzureMLLinkedService', 'AzureMLService': 'AzureMLServiceLinkedService', 'AzureMariaDB': 'AzureMariaDBLinkedService', 'AzureMySql': 'AzureMySqlLinkedService', 'AzurePostgreSql': 'AzurePostgreSqlLinkedService', 'AzureSearch': 'AzureSearchLinkedService', 'AzureSqlDW': 'AzureSqlDWLinkedService', 'AzureSqlDatabase': 'AzureSqlDatabaseLinkedService', 'AzureSqlMI': 'AzureSqlMILinkedService', 'AzureStorage': 'AzureStorageLinkedService', 'AzureTableStorage': 'AzureTableStorageLinkedService', 'Cassandra': 'CassandraLinkedService', 'CommonDataServiceForApps': 'CommonDataServiceForAppsLinkedService', 'Concur': 'ConcurLinkedService', 'CosmosDb': 'CosmosDbLinkedService', 'CosmosDbMongoDbApi': 'CosmosDbMongoDbApiLinkedService', 'Couchbase': 'CouchbaseLinkedService', 'CustomDataSource': 'CustomDataSourceLinkedService', 'Db2': 'Db2LinkedService', 'Drill': 'DrillLinkedService', 'Dynamics': 'DynamicsLinkedService', 'DynamicsAX': 'DynamicsAXLinkedService', 'DynamicsCrm': 'DynamicsCrmLinkedService', 'Eloqua': 'EloquaLinkedService', 'FileServer': 'FileServerLinkedService', 'FtpServer': 'FtpServerLinkedService', 'GoogleAdWords': 'GoogleAdWordsLinkedService', 'GoogleBigQuery': 'GoogleBigQueryLinkedService', 'GoogleCloudStorage': 'GoogleCloudStorageLinkedService', 'Greenplum': 'GreenplumLinkedService', 'HBase': 'HBaseLinkedService', 'HDInsight': 'HDInsightLinkedService', 'HDInsightOnDemand': 'HDInsightOnDemandLinkedService', 'Hdfs': 'HdfsLinkedService', 'Hive': 'HiveLinkedService', 'HttpServer': 'HttpLinkedService', 'Hubspot': 'HubspotLinkedService', 'Impala': 'ImpalaLinkedService', 'Informix': 'InformixLinkedService', 'Jira': 'JiraLinkedService', 'Magento': 'MagentoLinkedService', 'MariaDB': 'MariaDBLinkedService', 'Marketo': 'MarketoLinkedService', 'MicrosoftAccess': 'MicrosoftAccessLinkedService', 'MongoDb': 'MongoDbLinkedService', 'MongoDbV2': 'MongoDbV2LinkedService', 'MySql': 'MySqlLinkedService', 'Netezza': 'NetezzaLinkedService', 'OData': 'ODataLinkedService', 'Odbc': 'OdbcLinkedService', 'Office365': 'Office365LinkedService', 'Oracle': 'OracleLinkedService', 'OracleServiceCloud': 'OracleServiceCloudLinkedService', 'Paypal': 'PaypalLinkedService', 'Phoenix': 'PhoenixLinkedService', 'PostgreSql': 'PostgreSqlLinkedService', 'Presto': 'PrestoLinkedService', 'QuickBooks': 'QuickBooksLinkedService', 'Responsys': 'ResponsysLinkedService', 'RestService': 'RestServiceLinkedService', 'Salesforce': 'SalesforceLinkedService', 'SalesforceMarketingCloud': 'SalesforceMarketingCloudLinkedService', 'SalesforceServiceCloud': 'SalesforceServiceCloudLinkedService', 'SapBW': 'SapBWLinkedService', 'SapCloudForCustomer': 'SapCloudForCustomerLinkedService', 'SapEcc': 'SapEccLinkedService', 'SapHana': 'SapHanaLinkedService', 'SapOpenHub': 'SapOpenHubLinkedService', 'SapTable': 'SapTableLinkedService', 'ServiceNow': 'ServiceNowLinkedService', 'Sftp': 'SftpServerLinkedService', 'Shopify': 'ShopifyLinkedService', 'Spark': 'SparkLinkedService', 'SqlServer': 'SqlServerLinkedService', 'Square': 'SquareLinkedService', 'Sybase': 'SybaseLinkedService', 'Teradata': 'TeradataLinkedService', 'Vertica': 'VerticaLinkedService', 'Web': 'WebLinkedService', 'Xero': 'XeroLinkedService', 'Zoho': 'ZohoLinkedService'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(LinkedService, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type: str = 'LinkedService'
        self.connect_via = connect_via
        self.description = description
        self.parameters = parameters
        self.annotations = annotations


class AmazonMWSLinkedService(LinkedService):
    """Amazon Marketplace Web Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the Amazon MWS server, (i.e.
     mws.amazonservices.com).
    :type endpoint: object
    :param marketplace_id: Required. The Amazon Marketplace ID you want to retrieve data from. To
     retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e.
     A2EUQ1WTGCTBG2).
    :type marketplace_id: object
    :param seller_id: Required. The Amazon seller ID.
    :type seller_id: object
    :param mws_auth_token: The Amazon MWS authentication token.
    :type mws_auth_token: ~azure.synapse.artifacts.models.SecretBase
    :param access_key_id: Required. The access key id used to access data.
    :type access_key_id: object
    :param secret_key: The secret key used to access data.
    :type secret_key: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'marketplace_id': {'required': True},
        'seller_id': {'required': True},
        'access_key_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'marketplace_id': {'key': 'typeProperties.marketplaceID', 'type': 'object'},
        'seller_id': {'key': 'typeProperties.sellerID', 'type': 'object'},
        'mws_auth_token': {'key': 'typeProperties.mwsAuthToken', 'type': 'SecretBase'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_key': {'key': 'typeProperties.secretKey', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: object,
        marketplace_id: object,
        seller_id: object,
        access_key_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        mws_auth_token: Optional["SecretBase"] = None,
        secret_key: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AmazonMWSLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AmazonMWS'
        self.endpoint = endpoint
        self.marketplace_id = marketplace_id
        self.seller_id = seller_id
        self.mws_auth_token = mws_auth_token
        self.access_key_id = access_key_id
        self.secret_key = secret_key
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class Dataset(msrest.serialization.Model):
    """The Azure Data Factory nested object which identifies data within different data stores, such as tables, files, folders, and documents.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSObjectDataset, AmazonRedshiftTableDataset, AvroDataset, AzureDataExplorerTableDataset, AzureMariaDBTableDataset, AzureMySqlTableDataset, AzurePostgreSqlTableDataset, AzureSearchIndexDataset, AzureSqlDWTableDataset, AzureSqlMITableDataset, AzureSqlTableDataset, AzureTableDataset, BinaryDataset, CassandraTableDataset, CommonDataServiceForAppsEntityDataset, ConcurObjectDataset, CosmosDbMongoDbApiCollectionDataset, CosmosDbSqlApiCollectionDataset, CouchbaseTableDataset, Db2TableDataset, DelimitedTextDataset, DocumentDbCollectionDataset, DrillTableDataset, DynamicsAXResourceDataset, DynamicsCrmEntityDataset, DynamicsEntityDataset, EloquaObjectDataset, GoogleAdWordsObjectDataset, GoogleBigQueryObjectDataset, GreenplumTableDataset, HBaseObjectDataset, HiveObjectDataset, HubspotObjectDataset, ImpalaObjectDataset, InformixTableDataset, JiraObjectDataset, JsonDataset, MagentoObjectDataset, MariaDBTableDataset, MarketoObjectDataset, MicrosoftAccessTableDataset, MongoDbCollectionDataset, MongoDbV2CollectionDataset, MySqlTableDataset, NetezzaTableDataset, ODataResourceDataset, OdbcTableDataset, Office365Dataset, OracleServiceCloudObjectDataset, OracleTableDataset, OrcDataset, ParquetDataset, PaypalObjectDataset, PhoenixObjectDataset, PostgreSqlTableDataset, PrestoObjectDataset, QuickBooksObjectDataset, RelationalTableDataset, ResponsysObjectDataset, RestResourceDataset, SalesforceMarketingCloudObjectDataset, SalesforceObjectDataset, SalesforceServiceCloudObjectDataset, SapBwCubeDataset, SapCloudForCustomerResourceDataset, SapEccResourceDataset, SapHanaTableDataset, SapOpenHubTableDataset, SapTableResourceDataset, ServiceNowObjectDataset, ShopifyObjectDataset, SparkObjectDataset, SqlServerTableDataset, SquareObjectDataset, SybaseTableDataset, TeradataTableDataset, VerticaTableDataset, WebTableDataset, XeroObjectDataset, ZohoObjectDataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
    }

    _subtype_map = {
        'type': {'AmazonMWSObject': 'AmazonMWSObjectDataset', 'AmazonRedshiftTable': 'AmazonRedshiftTableDataset', 'Avro': 'AvroDataset', 'AzureDataExplorerTable': 'AzureDataExplorerTableDataset', 'AzureMariaDBTable': 'AzureMariaDBTableDataset', 'AzureMySqlTable': 'AzureMySqlTableDataset', 'AzurePostgreSqlTable': 'AzurePostgreSqlTableDataset', 'AzureSearchIndex': 'AzureSearchIndexDataset', 'AzureSqlDWTable': 'AzureSqlDWTableDataset', 'AzureSqlMITable': 'AzureSqlMITableDataset', 'AzureSqlTable': 'AzureSqlTableDataset', 'AzureTable': 'AzureTableDataset', 'Binary': 'BinaryDataset', 'CassandraTable': 'CassandraTableDataset', 'CommonDataServiceForAppsEntity': 'CommonDataServiceForAppsEntityDataset', 'ConcurObject': 'ConcurObjectDataset', 'CosmosDbMongoDbApiCollection': 'CosmosDbMongoDbApiCollectionDataset', 'CosmosDbSqlApiCollection': 'CosmosDbSqlApiCollectionDataset', 'CouchbaseTable': 'CouchbaseTableDataset', 'Db2Table': 'Db2TableDataset', 'DelimitedText': 'DelimitedTextDataset', 'DocumentDbCollection': 'DocumentDbCollectionDataset', 'DrillTable': 'DrillTableDataset', 'DynamicsAXResource': 'DynamicsAXResourceDataset', 'DynamicsCrmEntity': 'DynamicsCrmEntityDataset', 'DynamicsEntity': 'DynamicsEntityDataset', 'EloquaObject': 'EloquaObjectDataset', 'GoogleAdWordsObject': 'GoogleAdWordsObjectDataset', 'GoogleBigQueryObject': 'GoogleBigQueryObjectDataset', 'GreenplumTable': 'GreenplumTableDataset', 'HBaseObject': 'HBaseObjectDataset', 'HiveObject': 'HiveObjectDataset', 'HubspotObject': 'HubspotObjectDataset', 'ImpalaObject': 'ImpalaObjectDataset', 'InformixTable': 'InformixTableDataset', 'JiraObject': 'JiraObjectDataset', 'Json': 'JsonDataset', 'MagentoObject': 'MagentoObjectDataset', 'MariaDBTable': 'MariaDBTableDataset', 'MarketoObject': 'MarketoObjectDataset', 'MicrosoftAccessTable': 'MicrosoftAccessTableDataset', 'MongoDbCollection': 'MongoDbCollectionDataset', 'MongoDbV2Collection': 'MongoDbV2CollectionDataset', 'MySqlTable': 'MySqlTableDataset', 'NetezzaTable': 'NetezzaTableDataset', 'ODataResource': 'ODataResourceDataset', 'OdbcTable': 'OdbcTableDataset', 'Office365Table': 'Office365Dataset', 'OracleServiceCloudObject': 'OracleServiceCloudObjectDataset', 'OracleTable': 'OracleTableDataset', 'Orc': 'OrcDataset', 'Parquet': 'ParquetDataset', 'PaypalObject': 'PaypalObjectDataset', 'PhoenixObject': 'PhoenixObjectDataset', 'PostgreSqlTable': 'PostgreSqlTableDataset', 'PrestoObject': 'PrestoObjectDataset', 'QuickBooksObject': 'QuickBooksObjectDataset', 'RelationalTable': 'RelationalTableDataset', 'ResponsysObject': 'ResponsysObjectDataset', 'RestResource': 'RestResourceDataset', 'SalesforceMarketingCloudObject': 'SalesforceMarketingCloudObjectDataset', 'SalesforceObject': 'SalesforceObjectDataset', 'SalesforceServiceCloudObject': 'SalesforceServiceCloudObjectDataset', 'SapBwCube': 'SapBwCubeDataset', 'SapCloudForCustomerResource': 'SapCloudForCustomerResourceDataset', 'SapEccResource': 'SapEccResourceDataset', 'SapHanaTable': 'SapHanaTableDataset', 'SapOpenHubTable': 'SapOpenHubTableDataset', 'SapTableResource': 'SapTableResourceDataset', 'ServiceNowObject': 'ServiceNowObjectDataset', 'ShopifyObject': 'ShopifyObjectDataset', 'SparkObject': 'SparkObjectDataset', 'SqlServerTable': 'SqlServerTableDataset', 'SquareObject': 'SquareObjectDataset', 'SybaseTable': 'SybaseTableDataset', 'TeradataTable': 'TeradataTableDataset', 'VerticaTable': 'VerticaTableDataset', 'WebTable': 'WebTableDataset', 'XeroObject': 'XeroObjectDataset', 'ZohoObject': 'ZohoObjectDataset'}
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(Dataset, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type: str = 'Dataset'
        self.description = description
        self.structure = structure
        self.schema = schema
        self.linked_service_name = linked_service_name
        self.parameters = parameters
        self.annotations = annotations
        self.folder = folder


class AmazonMWSObjectDataset(Dataset):
    """Amazon Marketplace Web Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(AmazonMWSObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AmazonMWSObject'
        self.table_name = table_name


class AmazonRedshiftLinkedService(LinkedService):
    """Linked service for Amazon Redshift.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param server: Required. The name of the Amazon Redshift server. Type: string (or Expression
     with resultType string).
    :type server: object
    :param username: The username of the Amazon Redshift source. Type: string (or Expression with
     resultType string).
    :type username: object
    :param password: The password of the Amazon Redshift source.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param database: Required. The database name of the Amazon Redshift source. Type: string (or
     Expression with resultType string).
    :type database: object
    :param port: The TCP port number that the Amazon Redshift server uses to listen for client
     connections. The default value is 5439. Type: integer (or Expression with resultType integer).
    :type port: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        server: object,
        database: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        port: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AmazonRedshiftLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AmazonRedshift'
        self.server = server
        self.username = username
        self.password = password
        self.database = database
        self.port = port
        self.encrypted_credential = encrypted_credential


class AmazonRedshiftTableDataset(Dataset):
    """The Amazon Redshift table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The Amazon Redshift table name. Type: string (or Expression with resultType
     string).
    :type table: object
    :param schema_type_properties_schema: The Amazon Redshift schema name. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(AmazonRedshiftTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AmazonRedshiftTable'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class AmazonS3LinkedService(LinkedService):
    """Linked service for Amazon S3.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param access_key_id: The access key identifier of the Amazon S3 Identity and Access Management
     (IAM) user. Type: string (or Expression with resultType string).
    :type access_key_id: object
    :param secret_access_key: The secret access key of the Amazon S3 Identity and Access Management
     (IAM) user.
    :type secret_access_key: ~azure.synapse.artifacts.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the S3 Connector. This is
     an optional property; change it only if you want to try a different service endpoint or want to
     switch between https and http. Type: string (or Expression with resultType string).
    :type service_url: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        access_key_id: Optional[object] = None,
        secret_access_key: Optional["SecretBase"] = None,
        service_url: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AmazonS3LinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AmazonS3'
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.service_url = service_url
        self.encrypted_credential = encrypted_credential


class AppendVariableActivity(Activity):
    """Append value for a Variable of type Array.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param variable_name: Name of the variable whose value needs to be appended to.
    :type variable_name: str
    :param value: Value to be appended. Could be a static value or Expression.
    :type value: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'variable_name': {'key': 'typeProperties.variableName', 'type': 'str'},
        'value': {'key': 'typeProperties.value', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        variable_name: Optional[str] = None,
        value: Optional[object] = None,
        **kwargs
    ):
        super(AppendVariableActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type: str = 'AppendVariable'
        self.variable_name = variable_name
        self.value = value


class AvroDataset(Dataset):
    """Avro dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the avro storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param avro_compression_codec:  Possible values include: "none", "deflate", "snappy", "xz",
     "bzip2".
    :type avro_compression_codec: str or ~azure.synapse.artifacts.models.AvroCompressionCodec
    :param avro_compression_level:
    :type avro_compression_level: int
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'avro_compression_level': {'maximum': 9, 'minimum': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'avro_compression_codec': {'key': 'typeProperties.avroCompressionCodec', 'type': 'str'},
        'avro_compression_level': {'key': 'typeProperties.avroCompressionLevel', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        avro_compression_codec: Optional[Union[str, "AvroCompressionCodec"]] = None,
        avro_compression_level: Optional[int] = None,
        **kwargs
    ):
        super(AvroDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'Avro'
        self.location = location
        self.avro_compression_codec = avro_compression_codec
        self.avro_compression_level = avro_compression_level


class AzureBatchLinkedService(LinkedService):
    """Azure Batch linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param account_name: Required. The Azure Batch account name. Type: string (or Expression with
     resultType string).
    :type account_name: object
    :param access_key: The Azure Batch account access key.
    :type access_key: ~azure.synapse.artifacts.models.SecretBase
    :param batch_uri: Required. The Azure Batch URI. Type: string (or Expression with resultType
     string).
    :type batch_uri: object
    :param pool_name: Required. The Azure Batch pool name. Type: string (or Expression with
     resultType string).
    :type pool_name: object
    :param linked_service_name: Required. The Azure Storage linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'batch_uri': {'required': True},
        'pool_name': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'access_key': {'key': 'typeProperties.accessKey', 'type': 'SecretBase'},
        'batch_uri': {'key': 'typeProperties.batchUri', 'type': 'object'},
        'pool_name': {'key': 'typeProperties.poolName', 'type': 'object'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        account_name: object,
        batch_uri: object,
        pool_name: object,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        access_key: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureBatchLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureBatch'
        self.account_name = account_name
        self.access_key = access_key
        self.batch_uri = batch_uri
        self.pool_name = pool_name
        self.linked_service_name = linked_service_name
        self.encrypted_credential = encrypted_credential


class AzureBlobFSLinkedService(LinkedService):
    """Azure Data Lake Storage Gen2 linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or
     Expression with resultType string).
    :type url: object
    :param account_key: Account key for the Azure Data Lake Storage Gen2 service. Type: string (or
     Expression with resultType string).
    :type account_key: object
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Storage Gen2 account. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Storage Gen2 account.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        account_key: Optional[object] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureBlobFSLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureBlobFS'
        self.url = url
        self.account_key = account_key
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureBlobStorageLinkedService(LinkedService):
    """The azure blob storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. It is mutually exclusive with sasUri,
     serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Blob Storage resource. It is mutually exclusive with
     connectionString, serviceEndpoint property. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type sas_uri: object
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param service_endpoint: Blob service endpoint of the Azure Blob Storage resource. It is
     mutually exclusive with connectionString, sasUri property.
    :type service_endpoint: str
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Data Warehouse. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Data Warehouse.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'service_endpoint': {'key': 'typeProperties.serviceEndpoint', 'type': 'str'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[object] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        service_endpoint: Optional[str] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        super(AzureBlobStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureBlobStorage'
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.service_endpoint = service_endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureDatabricksLinkedService(LinkedService):
    """Azure Databricks linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param domain: Required. :code:`<REGION>`.azuredatabricks.net, domain name of your Databricks
     deployment. Type: string (or Expression with resultType string).
    :type domain: object
    :param access_token: Required. Access token for databricks REST API. Refer to
     https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression
     with resultType string).
    :type access_token: ~azure.synapse.artifacts.models.SecretBase
    :param existing_cluster_id: The id of an existing interactive cluster that will be used for all
     runs of this activity. Type: string (or Expression with resultType string).
    :type existing_cluster_id: object
    :param instance_pool_id: The id of an existing instance pool that will be used for all runs of
     this activity. Type: string (or Expression with resultType string).
    :type instance_pool_id: object
    :param new_cluster_version: If not using an existing interactive cluster, this specifies the
     Spark version of a new job cluster or instance pool nodes created for each run of this
     activity. Required if instancePoolId is specified. Type: string (or Expression with resultType
     string).
    :type new_cluster_version: object
    :param new_cluster_num_of_worker: If not using an existing interactive cluster, this specifies
     the number of worker nodes to use for the new job cluster or instance pool. For new job
     clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-
     scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and can
     only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is
     specified. Type: string (or Expression with resultType string).
    :type new_cluster_num_of_worker: object
    :param new_cluster_node_type: The node type of the new job cluster. This property is required
     if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is
     specified, this property is ignored. Type: string (or Expression with resultType string).
    :type new_cluster_node_type: object
    :param new_cluster_spark_conf: A set of optional, user-specified Spark configuration key-value
     pairs.
    :type new_cluster_spark_conf: dict[str, object]
    :param new_cluster_spark_env_vars: A set of optional, user-specified Spark environment
     variables key-value pairs.
    :type new_cluster_spark_env_vars: dict[str, object]
    :param new_cluster_custom_tags: Additional tags for cluster resources. This property is ignored
     in instance pool configurations.
    :type new_cluster_custom_tags: dict[str, object]
    :param new_cluster_driver_node_type: The driver node type for the new job cluster. This
     property is ignored in instance pool configurations. Type: string (or Expression with
     resultType string).
    :type new_cluster_driver_node_type: object
    :param new_cluster_init_scripts: User-defined initialization scripts for the new cluster. Type:
     array of strings (or Expression with resultType array of strings).
    :type new_cluster_init_scripts: object
    :param new_cluster_enable_elastic_disk: Enable the elastic disk on the new cluster. This
     property is now ignored, and takes the default elastic disk behavior in Databricks (elastic
     disks are always enabled). Type: boolean (or Expression with resultType boolean).
    :type new_cluster_enable_elastic_disk: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'domain': {'required': True},
        'access_token': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'domain': {'key': 'typeProperties.domain', 'type': 'object'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'existing_cluster_id': {'key': 'typeProperties.existingClusterId', 'type': 'object'},
        'instance_pool_id': {'key': 'typeProperties.instancePoolId', 'type': 'object'},
        'new_cluster_version': {'key': 'typeProperties.newClusterVersion', 'type': 'object'},
        'new_cluster_num_of_worker': {'key': 'typeProperties.newClusterNumOfWorker', 'type': 'object'},
        'new_cluster_node_type': {'key': 'typeProperties.newClusterNodeType', 'type': 'object'},
        'new_cluster_spark_conf': {'key': 'typeProperties.newClusterSparkConf', 'type': '{object}'},
        'new_cluster_spark_env_vars': {'key': 'typeProperties.newClusterSparkEnvVars', 'type': '{object}'},
        'new_cluster_custom_tags': {'key': 'typeProperties.newClusterCustomTags', 'type': '{object}'},
        'new_cluster_driver_node_type': {'key': 'typeProperties.newClusterDriverNodeType', 'type': 'object'},
        'new_cluster_init_scripts': {'key': 'typeProperties.newClusterInitScripts', 'type': 'object'},
        'new_cluster_enable_elastic_disk': {'key': 'typeProperties.newClusterEnableElasticDisk', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        domain: object,
        access_token: "SecretBase",
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        existing_cluster_id: Optional[object] = None,
        instance_pool_id: Optional[object] = None,
        new_cluster_version: Optional[object] = None,
        new_cluster_num_of_worker: Optional[object] = None,
        new_cluster_node_type: Optional[object] = None,
        new_cluster_spark_conf: Optional[Dict[str, object]] = None,
        new_cluster_spark_env_vars: Optional[Dict[str, object]] = None,
        new_cluster_custom_tags: Optional[Dict[str, object]] = None,
        new_cluster_driver_node_type: Optional[object] = None,
        new_cluster_init_scripts: Optional[object] = None,
        new_cluster_enable_elastic_disk: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureDatabricksLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureDatabricks'
        self.domain = domain
        self.access_token = access_token
        self.existing_cluster_id = existing_cluster_id
        self.instance_pool_id = instance_pool_id
        self.new_cluster_version = new_cluster_version
        self.new_cluster_num_of_worker = new_cluster_num_of_worker
        self.new_cluster_node_type = new_cluster_node_type
        self.new_cluster_spark_conf = new_cluster_spark_conf
        self.new_cluster_spark_env_vars = new_cluster_spark_env_vars
        self.new_cluster_custom_tags = new_cluster_custom_tags
        self.new_cluster_driver_node_type = new_cluster_driver_node_type
        self.new_cluster_init_scripts = new_cluster_init_scripts
        self.new_cluster_enable_elastic_disk = new_cluster_enable_elastic_disk
        self.encrypted_credential = encrypted_credential


class ExecutionActivity(Activity):
    """Base class for all execution activities.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureDataExplorerCommandActivity, AzureFunctionActivity, AzureMLBatchExecutionActivity, AzureMLExecutePipelineActivity, AzureMLUpdateResourceActivity, CopyActivity, CustomActivity, DataLakeAnalyticsUSQLActivity, DatabricksNotebookActivity, DatabricksSparkJarActivity, DatabricksSparkPythonActivity, DeleteActivity, ExecuteDataFlowActivity, ExecuteSSISPackageActivity, GetMetadataActivity, HDInsightHiveActivity, HDInsightMapReduceActivity, HDInsightPigActivity, HDInsightSparkActivity, HDInsightStreamingActivity, LookupActivity, SqlServerStoredProcedureActivity, WebActivity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
    }

    _subtype_map = {
        'type': {'AzureDataExplorerCommand': 'AzureDataExplorerCommandActivity', 'AzureFunctionActivity': 'AzureFunctionActivity', 'AzureMLBatchExecution': 'AzureMLBatchExecutionActivity', 'AzureMLExecutePipeline': 'AzureMLExecutePipelineActivity', 'AzureMLUpdateResource': 'AzureMLUpdateResourceActivity', 'Copy': 'CopyActivity', 'Custom': 'CustomActivity', 'DataLakeAnalyticsU-SQL': 'DataLakeAnalyticsUSQLActivity', 'DatabricksNotebook': 'DatabricksNotebookActivity', 'DatabricksSparkJar': 'DatabricksSparkJarActivity', 'DatabricksSparkPython': 'DatabricksSparkPythonActivity', 'Delete': 'DeleteActivity', 'ExecuteDataFlow': 'ExecuteDataFlowActivity', 'ExecuteSSISPackage': 'ExecuteSSISPackageActivity', 'GetMetadata': 'GetMetadataActivity', 'HDInsightHive': 'HDInsightHiveActivity', 'HDInsightMapReduce': 'HDInsightMapReduceActivity', 'HDInsightPig': 'HDInsightPigActivity', 'HDInsightSpark': 'HDInsightSparkActivity', 'HDInsightStreaming': 'HDInsightStreamingActivity', 'Lookup': 'LookupActivity', 'SqlServerStoredProcedure': 'SqlServerStoredProcedureActivity', 'WebActivity': 'WebActivity'}
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        **kwargs
    ):
        super(ExecutionActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type: str = 'Execution'
        self.linked_service_name = linked_service_name
        self.policy = policy


class AzureDataExplorerCommandActivity(ExecutionActivity):
    """Azure Data Explorer command activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param command: Required. A control command, according to the Azure Data Explorer command
     syntax. Type: string (or Expression with resultType string).
    :type command: object
    :param command_timeout: Control command timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..).
    :type command_timeout: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'command': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'command': {'key': 'typeProperties.command', 'type': 'object'},
        'command_timeout': {'key': 'typeProperties.commandTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        command: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        command_timeout: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataExplorerCommandActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'AzureDataExplorerCommand'
        self.command = command
        self.command_timeout = command_timeout


class AzureDataExplorerLinkedService(LinkedService):
    """Azure Data Explorer (Kusto) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of Azure Data Explorer (the engine's endpoint). URL
     will be in the format https://:code:`<clusterName>`.:code:`<regionName>`.kusto.windows.net.
     Type: string (or Expression with resultType string).
    :type endpoint: object
    :param service_principal_id: Required. The ID of the service principal used to authenticate
     against Azure Data Explorer. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: Required. The key of the service principal used to authenticate
     against Kusto.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param database: Required. Database name for connection. Type: string (or Expression with
     resultType string).
    :type database: object
    :param tenant: Required. The name or ID of the tenant to which the service principal belongs.
     Type: string (or Expression with resultType string).
    :type tenant: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'service_principal_id': {'required': True},
        'service_principal_key': {'required': True},
        'database': {'required': True},
        'tenant': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: object,
        service_principal_id: object,
        service_principal_key: "SecretBase",
        database: object,
        tenant: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(AzureDataExplorerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureDataExplorer'
        self.endpoint = endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.database = database
        self.tenant = tenant


class AzureDataExplorerTableDataset(Dataset):
    """The Azure Data Explorer (Kusto) dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table: The table name of the Azure Data Explorer database. Type: string (or Expression
     with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataExplorerTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AzureDataExplorerTable'
        self.table = table


class AzureDataLakeAnalyticsLinkedService(LinkedService):
    """Azure Data Lake Analytics linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param account_name: Required. The Azure Data Lake Analytics account name. Type: string (or
     Expression with resultType string).
    :type account_name: object
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Analytics account. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Analytics account.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: Required. The name or ID of the tenant to which the service principal belongs.
     Type: string (or Expression with resultType string).
    :type tenant: object
    :param subscription_id: Data Lake Analytics account subscription ID (if different from Data
     Factory account). Type: string (or Expression with resultType string).
    :type subscription_id: object
    :param resource_group_name: Data Lake Analytics account resource group name (if different from
     Data Factory account). Type: string (or Expression with resultType string).
    :type resource_group_name: object
    :param data_lake_analytics_uri: Azure Data Lake Analytics URI Type: string (or Expression with
     resultType string).
    :type data_lake_analytics_uri: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'tenant': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'data_lake_analytics_uri': {'key': 'typeProperties.dataLakeAnalyticsUri', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        account_name: object,
        tenant: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        subscription_id: Optional[object] = None,
        resource_group_name: Optional[object] = None,
        data_lake_analytics_uri: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataLakeAnalyticsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureDataLakeAnalytics'
        self.account_name = account_name
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.data_lake_analytics_uri = data_lake_analytics_uri
        self.encrypted_credential = encrypted_credential


class AzureDataLakeStoreLinkedService(LinkedService):
    """Azure Data Lake Store linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param data_lake_store_uri: Required. Data Lake Store service URI. Type: string (or Expression
     with resultType string).
    :type data_lake_store_uri: object
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Store account. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Store account.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param account_name: Data Lake Store account name. Type: string (or Expression with resultType
     string).
    :type account_name: object
    :param subscription_id: Data Lake Store account subscription ID (if different from Data Factory
     account). Type: string (or Expression with resultType string).
    :type subscription_id: object
    :param resource_group_name: Data Lake Store account resource group name (if different from Data
     Factory account). Type: string (or Expression with resultType string).
    :type resource_group_name: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'data_lake_store_uri': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'data_lake_store_uri': {'key': 'typeProperties.dataLakeStoreUri', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        data_lake_store_uri: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        account_name: Optional[object] = None,
        subscription_id: Optional[object] = None,
        resource_group_name: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureDataLakeStore'
        self.data_lake_store_uri = data_lake_store_uri
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.account_name = account_name
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.encrypted_credential = encrypted_credential


class AzureFileStorageLinkedService(LinkedService):
    """Azure File Storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name of the server. Type: string (or Expression with resultType
     string).
    :type host: object
    :param user_id: User ID to logon the server. Type: string (or Expression with resultType
     string).
    :type user_id: object
    :param password: Password to logon the server.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'user_id': {'key': 'typeProperties.userId', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        user_id: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureFileStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureFileStorage'
        self.host = host
        self.user_id = user_id
        self.password = password
        self.encrypted_credential = encrypted_credential


class AzureFunctionActivity(ExecutionActivity):
    """Azure Function activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param method: Required. Rest API method for target endpoint. Possible values include: "GET",
     "POST", "PUT", "DELETE", "OPTIONS", "HEAD", "TRACE".
    :type method: str or ~azure.synapse.artifacts.models.AzureFunctionActivityMethod
    :param function_name: Required. Name of the Function that the Azure Function Activity will
     call. Type: string (or Expression with resultType string).
    :type function_name: object
    :param headers: Represents the headers that will be sent to the request. For example, to set
     the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type":
     "application/json" }. Type: string (or Expression with resultType string).
    :type headers: object
    :param body: Represents the payload that will be sent to the endpoint. Required for POST/PUT
     method, not allowed for GET method Type: string (or Expression with resultType string).
    :type body: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'method': {'required': True},
        'function_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'method': {'key': 'typeProperties.method', 'type': 'str'},
        'function_name': {'key': 'typeProperties.functionName', 'type': 'object'},
        'headers': {'key': 'typeProperties.headers', 'type': 'object'},
        'body': {'key': 'typeProperties.body', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        method: Union[str, "AzureFunctionActivityMethod"],
        function_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        headers: Optional[object] = None,
        body: Optional[object] = None,
        **kwargs
    ):
        super(AzureFunctionActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'AzureFunctionActivity'
        self.method = method
        self.function_name = function_name
        self.headers = headers
        self.body = body


class AzureFunctionLinkedService(LinkedService):
    """Azure Function linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param function_app_url: Required. The endpoint of the Azure Function App. URL will be in the
     format https://:code:`<accountName>`.azurewebsites.net.
    :type function_app_url: object
    :param function_key: Function or Host key for Azure Function App.
    :type function_key: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'function_app_url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'function_app_url': {'key': 'typeProperties.functionAppUrl', 'type': 'object'},
        'function_key': {'key': 'typeProperties.functionKey', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        function_app_url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        function_key: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureFunctionLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureFunction'
        self.function_app_url = function_app_url
        self.function_key = function_key
        self.encrypted_credential = encrypted_credential


class AzureKeyVaultLinkedService(LinkedService):
    """Azure Key Vault linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param base_url: Required. The base URL of the Azure Key Vault. e.g.
     https://myakv.vault.azure.net Type: string (or Expression with resultType string).
    :type base_url: object
    """

    _validation = {
        'type': {'required': True},
        'base_url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'base_url': {'key': 'typeProperties.baseUrl', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        base_url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(AzureKeyVaultLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureKeyVault'
        self.base_url = base_url


class SecretBase(msrest.serialization.Model):
    """The base definition of a secret type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureKeyVaultSecretReference, SecureString.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzureKeyVaultSecret': 'AzureKeyVaultSecretReference', 'SecureString': 'SecureString'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecretBase, self).__init__(**kwargs)
        self.type: Optional[str] = None


class AzureKeyVaultSecretReference(SecretBase):
    """Azure Key Vault secret reference.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    :param store: Required. The Azure Key Vault linked service reference.
    :type store: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param secret_name: Required. The name of the secret in Azure Key Vault. Type: string (or
     Expression with resultType string).
    :type secret_name: object
    :param secret_version: The version of the secret in Azure Key Vault. The default value is the
     latest version of the secret. Type: string (or Expression with resultType string).
    :type secret_version: object
    """

    _validation = {
        'type': {'required': True},
        'store': {'required': True},
        'secret_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'store': {'key': 'store', 'type': 'LinkedServiceReference'},
        'secret_name': {'key': 'secretName', 'type': 'object'},
        'secret_version': {'key': 'secretVersion', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        store: "LinkedServiceReference",
        secret_name: object,
        secret_version: Optional[object] = None,
        **kwargs
    ):
        super(AzureKeyVaultSecretReference, self).__init__(**kwargs)
        self.type: str = 'AzureKeyVaultSecret'
        self.store = store
        self.secret_name = secret_name
        self.secret_version = secret_version


class AzureMariaDBLinkedService(LinkedService):
    """Azure Database for MariaDB linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureMariaDBLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureMariaDB'
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class AzureMariaDBTableDataset(Dataset):
    """Azure Database for MariaDB dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(AzureMariaDBTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AzureMariaDBTable'
        self.table_name = table_name


class AzureMLBatchExecutionActivity(ExecutionActivity):
    """Azure ML Batch Execution activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param global_parameters: Key,Value pairs to be passed to the Azure ML Batch Execution Service
     endpoint. Keys must match the names of web service parameters defined in the published Azure ML
     web service. Values will be passed in the GlobalParameters property of the Azure ML batch
     execution request.
    :type global_parameters: dict[str, object]
    :param web_service_outputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
     Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This
     information will be passed in the WebServiceOutputs property of the Azure ML batch execution
     request.
    :type web_service_outputs: dict[str, ~azure.synapse.artifacts.models.AzureMLWebServiceFile]
    :param web_service_inputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
     Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This
     information will be passed in the WebServiceInputs property of the Azure ML batch execution
     request.
    :type web_service_inputs: dict[str, ~azure.synapse.artifacts.models.AzureMLWebServiceFile]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'global_parameters': {'key': 'typeProperties.globalParameters', 'type': '{object}'},
        'web_service_outputs': {'key': 'typeProperties.webServiceOutputs', 'type': '{AzureMLWebServiceFile}'},
        'web_service_inputs': {'key': 'typeProperties.webServiceInputs', 'type': '{AzureMLWebServiceFile}'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        global_parameters: Optional[Dict[str, object]] = None,
        web_service_outputs: Optional[Dict[str, "AzureMLWebServiceFile"]] = None,
        web_service_inputs: Optional[Dict[str, "AzureMLWebServiceFile"]] = None,
        **kwargs
    ):
        super(AzureMLBatchExecutionActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'AzureMLBatchExecution'
        self.global_parameters = global_parameters
        self.web_service_outputs = web_service_outputs
        self.web_service_inputs = web_service_inputs


class AzureMLExecutePipelineActivity(ExecutionActivity):
    """Azure ML Execute Pipeline activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param ml_pipeline_id: Required. ID of the published Azure ML pipeline. Type: string (or
     Expression with resultType string).
    :type ml_pipeline_id: object
    :param experiment_name: Run history experiment name of the pipeline run. This information will
     be passed in the ExperimentName property of the published pipeline execution request. Type:
     string (or Expression with resultType string).
    :type experiment_name: object
    :param ml_pipeline_parameters: Key,Value pairs to be passed to the published Azure ML pipeline
     endpoint. Keys must match the names of pipeline parameters defined in the published pipeline.
     Values will be passed in the ParameterAssignments property of the published pipeline execution
     request. Type: object with key value pairs (or Expression with resultType object).
    :type ml_pipeline_parameters: object
    :param ml_parent_run_id: The parent Azure ML Service pipeline run id. This information will be
     passed in the ParentRunId property of the published pipeline execution request. Type: string
     (or Expression with resultType string).
    :type ml_parent_run_id: object
    :param continue_on_step_failure: Whether to continue execution of other steps in the
     PipelineRun if a step fails. This information will be passed in the continueOnStepFailure
     property of the published pipeline execution request. Type: boolean (or Expression with
     resultType boolean).
    :type continue_on_step_failure: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'ml_pipeline_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'ml_pipeline_id': {'key': 'typeProperties.mlPipelineId', 'type': 'object'},
        'experiment_name': {'key': 'typeProperties.experimentName', 'type': 'object'},
        'ml_pipeline_parameters': {'key': 'typeProperties.mlPipelineParameters', 'type': 'object'},
        'ml_parent_run_id': {'key': 'typeProperties.mlParentRunId', 'type': 'object'},
        'continue_on_step_failure': {'key': 'typeProperties.continueOnStepFailure', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        ml_pipeline_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        experiment_name: Optional[object] = None,
        ml_pipeline_parameters: Optional[object] = None,
        ml_parent_run_id: Optional[object] = None,
        continue_on_step_failure: Optional[object] = None,
        **kwargs
    ):
        super(AzureMLExecutePipelineActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'AzureMLExecutePipeline'
        self.ml_pipeline_id = ml_pipeline_id
        self.experiment_name = experiment_name
        self.ml_pipeline_parameters = ml_pipeline_parameters
        self.ml_parent_run_id = ml_parent_run_id
        self.continue_on_step_failure = continue_on_step_failure


class AzureMLLinkedService(LinkedService):
    """Azure ML Studio Web Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param ml_endpoint: Required. The Batch Execution REST URL for an Azure ML Studio Web Service
     endpoint. Type: string (or Expression with resultType string).
    :type ml_endpoint: object
    :param api_key: Required. The API key for accessing the Azure ML model endpoint.
    :type api_key: ~azure.synapse.artifacts.models.SecretBase
    :param update_resource_endpoint: The Update Resource REST URL for an Azure ML Studio Web
     Service endpoint. Type: string (or Expression with resultType string).
    :type update_resource_endpoint: object
    :param service_principal_id: The ID of the service principal used to authenticate against the
     ARM-based updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression
     with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against the
     ARM-based updateResourceEndpoint of an Azure ML Studio web service.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'ml_endpoint': {'required': True},
        'api_key': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'ml_endpoint': {'key': 'typeProperties.mlEndpoint', 'type': 'object'},
        'api_key': {'key': 'typeProperties.apiKey', 'type': 'SecretBase'},
        'update_resource_endpoint': {'key': 'typeProperties.updateResourceEndpoint', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        ml_endpoint: object,
        api_key: "SecretBase",
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        update_resource_endpoint: Optional[object] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureMLLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureML'
        self.ml_endpoint = ml_endpoint
        self.api_key = api_key
        self.update_resource_endpoint = update_resource_endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureMLServiceLinkedService(LinkedService):
    """Azure ML Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param subscription_id: Required. Azure ML Service workspace subscription ID. Type: string (or
     Expression with resultType string).
    :type subscription_id: object
    :param resource_group_name: Required. Azure ML Service workspace resource group name. Type:
     string (or Expression with resultType string).
    :type resource_group_name: object
    :param ml_workspace_name: Required. Azure ML Service workspace name. Type: string (or
     Expression with resultType string).
    :type ml_workspace_name: object
    :param service_principal_id: The ID of the service principal used to authenticate against the
     endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType
     string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against the
     endpoint of a published Azure ML Service pipeline.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'ml_workspace_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'ml_workspace_name': {'key': 'typeProperties.mlWorkspaceName', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        subscription_id: object,
        resource_group_name: object,
        ml_workspace_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureMLServiceLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureMLService'
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.ml_workspace_name = ml_workspace_name
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureMLUpdateResourceActivity(ExecutionActivity):
    """Azure ML Update Resource management activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param trained_model_name: Required. Name of the Trained Model module in the Web Service
     experiment to be updated. Type: string (or Expression with resultType string).
    :type trained_model_name: object
    :param trained_model_linked_service_name: Required. Name of Azure Storage linked service
     holding the .ilearner file that will be uploaded by the update operation.
    :type trained_model_linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param trained_model_file_path: Required. The relative file path in trainedModelLinkedService
     to represent the .ilearner file that will be uploaded by the update operation.  Type: string
     (or Expression with resultType string).
    :type trained_model_file_path: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'trained_model_name': {'required': True},
        'trained_model_linked_service_name': {'required': True},
        'trained_model_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'trained_model_name': {'key': 'typeProperties.trainedModelName', 'type': 'object'},
        'trained_model_linked_service_name': {'key': 'typeProperties.trainedModelLinkedServiceName', 'type': 'LinkedServiceReference'},
        'trained_model_file_path': {'key': 'typeProperties.trainedModelFilePath', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        trained_model_name: object,
        trained_model_linked_service_name: "LinkedServiceReference",
        trained_model_file_path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        **kwargs
    ):
        super(AzureMLUpdateResourceActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'AzureMLUpdateResource'
        self.trained_model_name = trained_model_name
        self.trained_model_linked_service_name = trained_model_linked_service_name
        self.trained_model_file_path = trained_model_file_path


class AzureMLWebServiceFile(msrest.serialization.Model):
    """Azure ML WebService Input/Output file.

    All required parameters must be populated in order to send to Azure.

    :param file_path: Required. The relative file path, including container name, in the Azure Blob
     Storage specified by the LinkedService. Type: string (or Expression with resultType string).
    :type file_path: object
    :param linked_service_name: Required. Reference to an Azure Storage LinkedService, where Azure
     ML WebService Input/Output file located.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    """

    _validation = {
        'file_path': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'file_path': {'key': 'filePath', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        *,
        file_path: object,
        linked_service_name: "LinkedServiceReference",
        **kwargs
    ):
        super(AzureMLWebServiceFile, self).__init__(**kwargs)
        self.file_path = file_path
        self.linked_service_name = linked_service_name


class AzureMySqlLinkedService(LinkedService):
    """Azure MySQL database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureMySqlLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureMySql'
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class AzureMySqlTableDataset(Dataset):
    """The Azure MySQL database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The Azure MySQL database table name. Type: string (or Expression with
     resultType string).
    :type table_name: object
    :param table: The name of Azure MySQL database table. Type: string (or Expression with
     resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(AzureMySqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AzureMySqlTable'
        self.table_name = table_name
        self.table = table


class AzurePostgreSqlLinkedService(LinkedService):
    """Azure PostgreSQL linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzurePostgreSqlLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzurePostgreSql'
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class AzurePostgreSqlTableDataset(Dataset):
    """Azure PostgreSQL dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name of the Azure PostgreSQL database which includes both schema
     and table. Type: string (or Expression with resultType string).
    :type table_name: object
    :param table: The table name of the Azure PostgreSQL database. Type: string (or Expression with
     resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Azure PostgreSQL database. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(AzurePostgreSqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AzurePostgreSqlTable'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class AzureSearchIndexDataset(Dataset):
    """The Azure Search Index.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param index_name: Required. The name of the Azure Search Index. Type: string (or Expression
     with resultType string).
    :type index_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'index_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'index_name': {'key': 'typeProperties.indexName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        index_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(AzureSearchIndexDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AzureSearchIndex'
        self.index_name = index_name


class AzureSearchLinkedService(LinkedService):
    """Linked service for Windows Azure Search Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. URL for Azure Search service. Type: string (or Expression with resultType
     string).
    :type url: object
    :param key: Admin Key for Azure Search service.
    :type key: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'key': {'key': 'typeProperties.key', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        key: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureSearchLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureSearch'
        self.url = url
        self.key = key
        self.encrypted_credential = encrypted_credential


class AzureSqlDatabaseLinkedService(LinkedService):
    """Microsoft Azure SQL Database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Database. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Database.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlDatabaseLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureSqlDatabase'
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureSqlDWLinkedService(LinkedService):
    """Azure SQL Data Warehouse linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Data Warehouse. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Data Warehouse.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlDWLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureSqlDW'
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureSqlDWTableDataset(Dataset):
    """The Azure SQL Data Warehouse dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the Azure SQL Data Warehouse. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the Azure SQL Data Warehouse. Type: string (or Expression with
     resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlDWTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AzureSqlDWTable'
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureSqlMILinkedService(LinkedService):
    """Azure SQL Managed Instance linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Managed Instance. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Managed Instance.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlMILinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureSqlMI'
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureSqlMITableDataset(Dataset):
    """The Azure SQL Managed Instance dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the Azure SQL Managed Instance. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the Azure SQL Managed Instance dataset. Type: string (or
     Expression with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlMITableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AzureSqlMITable'
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureSqlTableDataset(Dataset):
    """The Azure SQL Server database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the Azure SQL database. Type: string
     (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the Azure SQL database. Type: string (or Expression with
     resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(AzureSqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AzureSqlTable'
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureStorageLinkedService(LinkedService):
    """The storage account linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type sas_uri: object
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[object] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        super(AzureStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureStorage'
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.encrypted_credential = encrypted_credential


class AzureTableDataset(Dataset):
    """The Azure Table storage dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: Required. The table name of the Azure Table storage. Type: string (or
     Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'table_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        table_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(AzureTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'AzureTable'
        self.table_name = table_name


class AzureTableStorageLinkedService(LinkedService):
    """The azure table storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type sas_uri: object
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        account_key: Optional["AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[object] = None,
        sas_token: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        super(AzureTableStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'AzureTableStorage'
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.encrypted_credential = encrypted_credential


class BigDataPoolReference(msrest.serialization.Model):
    """Big data pool reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Big data pool reference type. Default value: "BigDataPoolReference".
    :vartype type: str
    :param reference_name: Required. Reference big data pool name.
    :type reference_name: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
    }

    type = "BigDataPoolReference"

    def __init__(
        self,
        *,
        reference_name: str,
        **kwargs
    ):
        super(BigDataPoolReference, self).__init__(**kwargs)
        self.reference_name = reference_name


class BinaryDataset(Dataset):
    """Binary dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the Binary storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param compression: The data compression method used for the binary dataset.
    :type compression: ~azure.synapse.artifacts.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(BinaryDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'Binary'
        self.location = location
        self.compression = compression


class CassandraLinkedService(LinkedService):
    """Linked service for Cassandra data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name for connection. Type: string (or Expression with resultType
     string).
    :type host: object
    :param authentication_type: AuthenticationType to be used for connection. Type: string (or
     Expression with resultType string).
    :type authentication_type: object
    :param port: The port for the connection. Type: integer (or Expression with resultType
     integer).
    :type port: object
    :param username: Username for authentication. Type: string (or Expression with resultType
     string).
    :type username: object
    :param password: Password for authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[object] = None,
        port: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(CassandraLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Cassandra'
        self.host = host
        self.authentication_type = authentication_type
        self.port = port
        self.username = username
        self.password = password
        self.encrypted_credential = encrypted_credential


class CassandraTableDataset(Dataset):
    """The Cassandra database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name of the Cassandra database. Type: string (or Expression with
     resultType string).
    :type table_name: object
    :param keyspace: The keyspace of the Cassandra database. Type: string (or Expression with
     resultType string).
    :type keyspace: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'keyspace': {'key': 'typeProperties.keyspace', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        keyspace: Optional[object] = None,
        **kwargs
    ):
        super(CassandraTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'CassandraTable'
        self.table_name = table_name
        self.keyspace = keyspace


class CloudError(msrest.serialization.Model):
    """The object that defines the structure of an Azure Synapse error response.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. Error message.
    :type message: str
    :param target: Property name/path in request associated with error.
    :type target: str
    :param details: Array with additional error details.
    :type details: list[~azure.synapse.artifacts.models.CloudError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
        'target': {'key': 'error.target', 'type': 'str'},
        'details': {'key': 'error.details', 'type': '[CloudError]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["CloudError"]] = None,
        **kwargs
    ):
        super(CloudError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CommonDataServiceForAppsEntityDataset(Dataset):
    """The Common Data Service for Apps entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        entity_name: Optional[object] = None,
        **kwargs
    ):
        super(CommonDataServiceForAppsEntityDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'CommonDataServiceForAppsEntity'
        self.entity_name = entity_name


class CommonDataServiceForAppsLinkedService(LinkedService):
    """Common Data Service for Apps linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param deployment_type: Required. The deployment type of the Common Data Service for Apps
     instance. 'Online' for Common Data Service for Apps Online and 'OnPremisesWithIfd' for Common
     Data Service for Apps on-premises with Ifd. Type: string (or Expression with resultType
     string). Possible values include: "Online", "OnPremisesWithIfd".
    :type deployment_type: str or ~azure.synapse.artifacts.models.DynamicsDeploymentType
    :param host_name: The host name of the on-premises Common Data Service for Apps server. The
     property is required for on-prem and not allowed for online. Type: string (or Expression with
     resultType string).
    :type host_name: object
    :param port: The port of on-premises Common Data Service for Apps server. The property is
     required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression
     with resultType integer), minimum: 0.
    :type port: object
    :param service_uri: The URL to the Microsoft Common Data Service for Apps server. The property
     is required for on-line and not allowed for on-prem. Type: string (or Expression with
     resultType string).
    :type service_uri: object
    :param organization_name: The organization name of the Common Data Service for Apps instance.
     The property is required for on-prem and required for online when there are more than one
     Common Data Service for Apps instances associated with the user. Type: string (or Expression
     with resultType string).
    :type organization_name: object
    :param authentication_type: Required. The authentication type to connect to Common Data Service
     for Apps server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario.
     'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or
     Expression with resultType string). Possible values include: "Office365", "Ifd",
     "AADServicePrincipal".
    :type authentication_type: str or ~azure.synapse.artifacts.models.DynamicsAuthenticationType
    :param username: User name to access the Common Data Service for Apps instance. Type: string
     (or Expression with resultType string).
    :type username: object
    :param password: Password to access the Common Data Service for Apps instance.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.synapse.artifacts.models.DynamicsServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'str'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'object'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        deployment_type: Union[str, "DynamicsDeploymentType"],
        authentication_type: Union[str, "DynamicsAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        host_name: Optional[object] = None,
        port: Optional[object] = None,
        service_uri: Optional[object] = None,
        organization_name: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_credential_type: Optional[Union[str, "DynamicsServicePrincipalCredentialType"]] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(CommonDataServiceForAppsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'CommonDataServiceForApps'
        self.deployment_type = deployment_type
        self.host_name = host_name
        self.port = port
        self.service_uri = service_uri
        self.organization_name = organization_name
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.encrypted_credential = encrypted_credential


class ConcurLinkedService(LinkedService):
    """Concur Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param client_id: Required. Application client_id supplied by Concur App Management.
    :type client_id: object
    :param username: Required. The user name that you use to access Concur Service.
    :type username: object
    :param password: The password corresponding to the user name that you provided in the username
     field.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'client_id': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        client_id: object,
        username: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(ConcurLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Concur'
        self.client_id = client_id
        self.username = username
        self.password = password
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class ConcurObjectDataset(Dataset):
    """Concur Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(ConcurObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'ConcurObject'
        self.table_name = table_name


class ControlActivity(Activity):
    """Base class for all control activities like IfCondition, ForEach , Until.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        **kwargs
    ):
        super(ControlActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type: str = 'Container'


class CopyActivity(ExecutionActivity):
    """Copy activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param inputs: List of inputs for the activity.
    :type inputs: list[~azure.synapse.artifacts.models.DatasetReference]
    :param outputs: List of outputs for the activity.
    :type outputs: list[~azure.synapse.artifacts.models.DatasetReference]
    :param source: Required. Copy activity source.
    :type source: ~azure.synapse.artifacts.models.CopySource
    :param sink: Required. Copy activity sink.
    :type sink: ~azure.synapse.artifacts.models.CopySink
    :param translator: Copy activity translator. If not specified, tabular translator is used.
    :type translator: object
    :param enable_staging: Specifies whether to copy data via an interim staging. Default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type enable_staging: object
    :param staging_settings: Specifies interim staging settings when EnableStaging is true.
    :type staging_settings: ~azure.synapse.artifacts.models.StagingSettings
    :param parallel_copies: Maximum number of concurrent sessions opened on the source or sink to
     avoid overloading the data store. Type: integer (or Expression with resultType integer),
     minimum: 0.
    :type parallel_copies: object
    :param data_integration_units: Maximum number of data integration units that can be used to
     perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
    :type data_integration_units: object
    :param enable_skip_incompatible_row: Whether to skip incompatible row. Default value is false.
     Type: boolean (or Expression with resultType boolean).
    :type enable_skip_incompatible_row: object
    :param redirect_incompatible_row_settings: Redirect incompatible row settings when
     EnableSkipIncompatibleRow is true.
    :type redirect_incompatible_row_settings:
     ~azure.synapse.artifacts.models.RedirectIncompatibleRowSettings
    :param preserve_rules: Preserve Rules.
    :type preserve_rules: list[object]
    :param preserve: Preserve rules.
    :type preserve: list[object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'source': {'required': True},
        'sink': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'inputs': {'key': 'inputs', 'type': '[DatasetReference]'},
        'outputs': {'key': 'outputs', 'type': '[DatasetReference]'},
        'source': {'key': 'typeProperties.source', 'type': 'CopySource'},
        'sink': {'key': 'typeProperties.sink', 'type': 'CopySink'},
        'translator': {'key': 'typeProperties.translator', 'type': 'object'},
        'enable_staging': {'key': 'typeProperties.enableStaging', 'type': 'object'},
        'staging_settings': {'key': 'typeProperties.stagingSettings', 'type': 'StagingSettings'},
        'parallel_copies': {'key': 'typeProperties.parallelCopies', 'type': 'object'},
        'data_integration_units': {'key': 'typeProperties.dataIntegrationUnits', 'type': 'object'},
        'enable_skip_incompatible_row': {'key': 'typeProperties.enableSkipIncompatibleRow', 'type': 'object'},
        'redirect_incompatible_row_settings': {'key': 'typeProperties.redirectIncompatibleRowSettings', 'type': 'RedirectIncompatibleRowSettings'},
        'preserve_rules': {'key': 'typeProperties.preserveRules', 'type': '[object]'},
        'preserve': {'key': 'typeProperties.preserve', 'type': '[object]'},
    }

    def __init__(
        self,
        *,
        name: str,
        source: "CopySource",
        sink: "CopySink",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        inputs: Optional[List["DatasetReference"]] = None,
        outputs: Optional[List["DatasetReference"]] = None,
        translator: Optional[object] = None,
        enable_staging: Optional[object] = None,
        staging_settings: Optional["StagingSettings"] = None,
        parallel_copies: Optional[object] = None,
        data_integration_units: Optional[object] = None,
        enable_skip_incompatible_row: Optional[object] = None,
        redirect_incompatible_row_settings: Optional["RedirectIncompatibleRowSettings"] = None,
        preserve_rules: Optional[List[object]] = None,
        preserve: Optional[List[object]] = None,
        **kwargs
    ):
        super(CopyActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'Copy'
        self.inputs = inputs
        self.outputs = outputs
        self.source = source
        self.sink = sink
        self.translator = translator
        self.enable_staging = enable_staging
        self.staging_settings = staging_settings
        self.parallel_copies = parallel_copies
        self.data_integration_units = data_integration_units
        self.enable_skip_incompatible_row = enable_skip_incompatible_row
        self.redirect_incompatible_row_settings = redirect_incompatible_row_settings
        self.preserve_rules = preserve_rules
        self.preserve = preserve


class CopySink(msrest.serialization.Model):
    """A copy activity sink.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: .

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
    }

    _subtype_map = {
        'type': {}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        write_batch_size: Optional[object] = None,
        write_batch_timeout: Optional[object] = None,
        sink_retry_count: Optional[object] = None,
        sink_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        **kwargs
    ):
        super(CopySink, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type: str = 'CopySink'
        self.write_batch_size = write_batch_size
        self.write_batch_timeout = write_batch_timeout
        self.sink_retry_count = sink_retry_count
        self.sink_retry_wait = sink_retry_wait
        self.max_concurrent_connections = max_concurrent_connections


class CopySource(msrest.serialization.Model):
    """A copy activity source.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: .

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
    }

    _subtype_map = {
        'type': {}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_retry_count: Optional[object] = None,
        source_retry_wait: Optional[object] = None,
        max_concurrent_connections: Optional[object] = None,
        **kwargs
    ):
        super(CopySource, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type: str = 'CopySource'
        self.source_retry_count = source_retry_count
        self.source_retry_wait = source_retry_wait
        self.max_concurrent_connections = max_concurrent_connections


class CosmosDbLinkedService(LinkedService):
    """Microsoft Azure Cosmos Database (CosmosDB) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_endpoint: The endpoint of the Azure CosmosDB account. Type: string (or
     Expression with resultType string).
    :type account_endpoint: object
    :param database: The name of the database. Type: string (or Expression with resultType string).
    :type database: object
    :param account_key: The account key of the Azure CosmosDB account. Type: SecureString or
     AzureKeyVaultSecretReference.
    :type account_key: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_endpoint': {'key': 'typeProperties.accountEndpoint', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        account_endpoint: Optional[object] = None,
        database: Optional[object] = None,
        account_key: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(CosmosDbLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'CosmosDb'
        self.connection_string = connection_string
        self.account_endpoint = account_endpoint
        self.database = database
        self.account_key = account_key
        self.encrypted_credential = encrypted_credential


class CosmosDbMongoDbApiCollectionDataset(Dataset):
    """The CosmosDB (MongoDB API) database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param collection: Required. The collection name of the CosmosDB (MongoDB API) database. Type:
     string (or Expression with resultType string).
    :type collection: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection': {'key': 'typeProperties.collection', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(CosmosDbMongoDbApiCollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'CosmosDbMongoDbApiCollection'
        self.collection = collection


class CosmosDbMongoDbApiLinkedService(LinkedService):
    """Linked service for CosmosDB (MongoDB API) data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The CosmosDB (MongoDB API) connection string. Type: string,
     SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param database: Required. The name of the CosmosDB (MongoDB API) database that you want to
     access. Type: string (or Expression with resultType string).
    :type database: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        database: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(CosmosDbMongoDbApiLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'CosmosDbMongoDbApi'
        self.connection_string = connection_string
        self.database = database


class CosmosDbSqlApiCollectionDataset(Dataset):
    """Microsoft Azure CosmosDB (SQL API) Collection dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param collection_name: Required. CosmosDB (SQL API) collection name. Type: string (or
     Expression with resultType string).
    :type collection_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection_name': {'key': 'typeProperties.collectionName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(CosmosDbSqlApiCollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'CosmosDbSqlApiCollection'
        self.collection_name = collection_name


class CouchbaseLinkedService(LinkedService):
    """Couchbase server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param cred_string: The Azure key vault secret reference of credString in connection string.
    :type cred_string: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'cred_string': {'key': 'typeProperties.credString', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        cred_string: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(CouchbaseLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Couchbase'
        self.connection_string = connection_string
        self.cred_string = cred_string
        self.encrypted_credential = encrypted_credential


class CouchbaseTableDataset(Dataset):
    """Couchbase server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(CouchbaseTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'CouchbaseTable'
        self.table_name = table_name


class CreateDataFlowDebugSessionRequest(msrest.serialization.Model):
    """Request body structure for creating data flow debug session.

    :param data_flow_name: The name of the data flow.
    :type data_flow_name: str
    :param existing_cluster_id: The ID of existing Databricks cluster.
    :type existing_cluster_id: str
    :param cluster_timeout: Timeout setting for Databricks cluster.
    :type cluster_timeout: int
    :param new_cluster_name: The name of new Databricks cluster.
    :type new_cluster_name: str
    :param new_cluster_node_type: The type of new Databricks cluster.
    :type new_cluster_node_type: str
    :param data_bricks_linked_service: Data bricks linked service.
    :type data_bricks_linked_service: ~azure.synapse.artifacts.models.LinkedServiceResource
    """

    _attribute_map = {
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'existing_cluster_id': {'key': 'existingClusterId', 'type': 'str'},
        'cluster_timeout': {'key': 'clusterTimeout', 'type': 'int'},
        'new_cluster_name': {'key': 'newClusterName', 'type': 'str'},
        'new_cluster_node_type': {'key': 'newClusterNodeType', 'type': 'str'},
        'data_bricks_linked_service': {'key': 'dataBricksLinkedService', 'type': 'LinkedServiceResource'},
    }

    def __init__(
        self,
        *,
        data_flow_name: Optional[str] = None,
        existing_cluster_id: Optional[str] = None,
        cluster_timeout: Optional[int] = None,
        new_cluster_name: Optional[str] = None,
        new_cluster_node_type: Optional[str] = None,
        data_bricks_linked_service: Optional["LinkedServiceResource"] = None,
        **kwargs
    ):
        super(CreateDataFlowDebugSessionRequest, self).__init__(**kwargs)
        self.data_flow_name = data_flow_name
        self.existing_cluster_id = existing_cluster_id
        self.cluster_timeout = cluster_timeout
        self.new_cluster_name = new_cluster_name
        self.new_cluster_node_type = new_cluster_node_type
        self.data_bricks_linked_service = data_bricks_linked_service


class CreateDataFlowDebugSessionResponse(msrest.serialization.Model):
    """Response body structure for creating data flow debug session.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        **kwargs
    ):
        super(CreateDataFlowDebugSessionResponse, self).__init__(**kwargs)
        self.session_id = session_id


class CreateRunResponse(msrest.serialization.Model):
    """Response body with a run identifier.

    All required parameters must be populated in order to send to Azure.

    :param run_id: Required. Identifier of a run.
    :type run_id: str
    """

    _validation = {
        'run_id': {'required': True},
    }

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_id: str,
        **kwargs
    ):
        super(CreateRunResponse, self).__init__(**kwargs)
        self.run_id = run_id


class CustomActivity(ExecutionActivity):
    """Custom activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param command: Required. Command for custom activity Type: string (or Expression with
     resultType string).
    :type command: object
    :param resource_linked_service: Resource linked service reference.
    :type resource_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param folder_path: Folder path for resource files Type: string (or Expression with resultType
     string).
    :type folder_path: object
    :param reference_objects: Reference objects.
    :type reference_objects: ~azure.synapse.artifacts.models.CustomActivityReferenceObject
    :param extended_properties: User defined property bag. There is no restriction on the keys or
     values that can be used. The user specified custom activity has the full responsibility to
     consume and interpret the content defined.
    :type extended_properties: dict[str, object]
    :param retention_time_in_days: The retention time for the files submitted for custom activity.
     Type: double (or Expression with resultType double).
    :type retention_time_in_days: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'command': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'command': {'key': 'typeProperties.command', 'type': 'object'},
        'resource_linked_service': {'key': 'typeProperties.resourceLinkedService', 'type': 'LinkedServiceReference'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'reference_objects': {'key': 'typeProperties.referenceObjects', 'type': 'CustomActivityReferenceObject'},
        'extended_properties': {'key': 'typeProperties.extendedProperties', 'type': '{object}'},
        'retention_time_in_days': {'key': 'typeProperties.retentionTimeInDays', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        command: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        resource_linked_service: Optional["LinkedServiceReference"] = None,
        folder_path: Optional[object] = None,
        reference_objects: Optional["CustomActivityReferenceObject"] = None,
        extended_properties: Optional[Dict[str, object]] = None,
        retention_time_in_days: Optional[object] = None,
        **kwargs
    ):
        super(CustomActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'Custom'
        self.command = command
        self.resource_linked_service = resource_linked_service
        self.folder_path = folder_path
        self.reference_objects = reference_objects
        self.extended_properties = extended_properties
        self.retention_time_in_days = retention_time_in_days


class CustomActivityReferenceObject(msrest.serialization.Model):
    """Reference objects for custom activity.

    :param linked_services: Linked service references.
    :type linked_services: list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param datasets: Dataset references.
    :type datasets: list[~azure.synapse.artifacts.models.DatasetReference]
    """

    _attribute_map = {
        'linked_services': {'key': 'linkedServices', 'type': '[LinkedServiceReference]'},
        'datasets': {'key': 'datasets', 'type': '[DatasetReference]'},
    }

    def __init__(
        self,
        *,
        linked_services: Optional[List["LinkedServiceReference"]] = None,
        datasets: Optional[List["DatasetReference"]] = None,
        **kwargs
    ):
        super(CustomActivityReferenceObject, self).__init__(**kwargs)
        self.linked_services = linked_services
        self.datasets = datasets


class CustomDataSourceLinkedService(LinkedService):
    """Custom linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param type_properties: Required. Custom linked service properties.
    :type type_properties: object
    """

    _validation = {
        'type': {'required': True},
        'type_properties': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'type_properties': {'key': 'typeProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        type_properties: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(CustomDataSourceLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'CustomDataSource'
        self.type_properties = type_properties


class DatabricksNotebookActivity(ExecutionActivity):
    """DatabricksNotebook activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param notebook_path: Required. The absolute path of the notebook to be run in the Databricks
     Workspace. This path must begin with a slash. Type: string (or Expression with resultType
     string).
    :type notebook_path: object
    :param base_parameters: Base parameters to be used for each run of this job.If the notebook
     takes a parameter that is not specified, the default value from the notebook will be used.
    :type base_parameters: dict[str, object]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, object]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'notebook_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'notebook_path': {'key': 'typeProperties.notebookPath', 'type': 'object'},
        'base_parameters': {'key': 'typeProperties.baseParameters', 'type': '{object}'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        *,
        name: str,
        notebook_path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        base_parameters: Optional[Dict[str, object]] = None,
        libraries: Optional[List[Dict[str, object]]] = None,
        **kwargs
    ):
        super(DatabricksNotebookActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'DatabricksNotebook'
        self.notebook_path = notebook_path
        self.base_parameters = base_parameters
        self.libraries = libraries


class DatabricksSparkJarActivity(ExecutionActivity):
    """DatabricksSparkJar activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param main_class_name: Required. The full name of the class containing the main method to be
     executed. This class must be contained in a JAR provided as a library. Type: string (or
     Expression with resultType string).
    :type main_class_name: object
    :param parameters: Parameters that will be passed to the main method.
    :type parameters: list[object]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, object]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'main_class_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'main_class_name': {'key': 'typeProperties.mainClassName', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '[object]'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        *,
        name: str,
        main_class_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        parameters: Optional[List[object]] = None,
        libraries: Optional[List[Dict[str, object]]] = None,
        **kwargs
    ):
        super(DatabricksSparkJarActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'DatabricksSparkJar'
        self.main_class_name = main_class_name
        self.parameters = parameters
        self.libraries = libraries


class DatabricksSparkPythonActivity(ExecutionActivity):
    """DatabricksSparkPython activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param python_file: Required. The URI of the Python file to be executed. DBFS paths are
     supported. Type: string (or Expression with resultType string).
    :type python_file: object
    :param parameters: Command line parameters that will be passed to the Python file.
    :type parameters: list[object]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, object]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'python_file': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'python_file': {'key': 'typeProperties.pythonFile', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '[object]'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        *,
        name: str,
        python_file: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        parameters: Optional[List[object]] = None,
        libraries: Optional[List[Dict[str, object]]] = None,
        **kwargs
    ):
        super(DatabricksSparkPythonActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'DatabricksSparkPython'
        self.python_file = python_file
        self.parameters = parameters
        self.libraries = libraries


class DataFlow(msrest.serialization.Model):
    """Azure Synapse nested object which contains a flow with data movements and transformations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MappingDataFlow.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of data flow.Constant filled by server.
    :type type: str
    :param description: The description of the data flow.
    :type description: str
    :param annotations: List of tags that can be used for describing the data flow.
    :type annotations: list[object]
    :param folder: The folder that this data flow is in. If not specified, Data flow will appear at
     the root level.
    :type folder: ~azure.synapse.artifacts.models.DataFlowFolder
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DataFlowFolder'},
    }

    _subtype_map = {
        'type': {'MappingDataFlow': 'MappingDataFlow'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DataFlowFolder"] = None,
        **kwargs
    ):
        super(DataFlow, self).__init__(**kwargs)
        self.type: Optional[str] = None
        self.description = description
        self.annotations = annotations
        self.folder = folder


class DataFlowDebugCommandRequest(msrest.serialization.Model):
    """Request body structure for data flow expression preview.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow_name: The data flow which contains the debug session.
    :type data_flow_name: str
    :param command_name: The command name.
    :type command_name: str
    :param command_payload: The command payload object.
    :type command_payload: object
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'command_name': {'key': 'commandName', 'type': 'str'},
        'command_payload': {'key': 'commandPayload', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        data_flow_name: Optional[str] = None,
        command_name: Optional[str] = None,
        command_payload: Optional[object] = None,
        **kwargs
    ):
        super(DataFlowDebugCommandRequest, self).__init__(**kwargs)
        self.session_id = session_id
        self.data_flow_name = data_flow_name
        self.command_name = command_name
        self.command_payload = command_payload


class DataFlowDebugCommandResponse(msrest.serialization.Model):
    """Response body structure of data flow result for data preview, statistics or expression preview.

    :param status: The run status of data preview, statistics or expression preview.
    :type status: str
    :param data: The result data of data preview, statistics or expression preview.
    :type data: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'data': {'key': 'data', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        data: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugCommandResponse, self).__init__(**kwargs)
        self.status = status
        self.data = data


class DataFlowDebugPackage(msrest.serialization.Model):
    """Request body structure for starting data flow debug session.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow: Data flow instance.
    :type data_flow: ~azure.synapse.artifacts.models.DataFlowDebugResource
    :param datasets: List of datasets.
    :type datasets: list[~azure.synapse.artifacts.models.DatasetDebugResource]
    :param linked_services: List of linked services.
    :type linked_services: list[~azure.synapse.artifacts.models.LinkedServiceDebugResource]
    :param staging: Staging info for debug session.
    :type staging: ~azure.synapse.artifacts.models.DataFlowStagingInfo
    :param debug_settings: Data flow debug settings.
    :type debug_settings: ~azure.synapse.artifacts.models.DataFlowDebugPackageDebugSettings
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow': {'key': 'dataFlow', 'type': 'DataFlowDebugResource'},
        'datasets': {'key': 'datasets', 'type': '[DatasetDebugResource]'},
        'linked_services': {'key': 'linkedServices', 'type': '[LinkedServiceDebugResource]'},
        'staging': {'key': 'staging', 'type': 'DataFlowStagingInfo'},
        'debug_settings': {'key': 'debugSettings', 'type': 'DataFlowDebugPackageDebugSettings'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        session_id: Optional[str] = None,
        data_flow: Optional["DataFlowDebugResource"] = None,
        datasets: Optional[List["DatasetDebugResource"]] = None,
        linked_services: Optional[List["LinkedServiceDebugResource"]] = None,
        staging: Optional["DataFlowStagingInfo"] = None,
        debug_settings: Optional["DataFlowDebugPackageDebugSettings"] = None,
        **kwargs
    ):
        super(DataFlowDebugPackage, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.session_id = session_id
        self.data_flow = data_flow
        self.datasets = datasets
        self.linked_services = linked_services
        self.staging = staging
        self.debug_settings = debug_settings


class DataFlowDebugPackageDebugSettings(msrest.serialization.Model):
    """Data flow debug settings.

    :param source_settings: Source setting for data flow debug.
    :type source_settings: list[~azure.synapse.artifacts.models.DataFlowSourceSetting]
    :param parameters: Data flow parameters.
    :type parameters: dict[str, object]
    :param dataset_parameters: Parameters for dataset.
    :type dataset_parameters: object
    """

    _attribute_map = {
        'source_settings': {'key': 'sourceSettings', 'type': '[DataFlowSourceSetting]'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
        'dataset_parameters': {'key': 'datasetParameters', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        source_settings: Optional[List["DataFlowSourceSetting"]] = None,
        parameters: Optional[Dict[str, object]] = None,
        dataset_parameters: Optional[object] = None,
        **kwargs
    ):
        super(DataFlowDebugPackageDebugSettings, self).__init__(**kwargs)
        self.source_settings = source_settings
        self.parameters = parameters
        self.dataset_parameters = dataset_parameters


class DataFlowDebugPreviewDataRequest(msrest.serialization.Model):
    """Request body structure for data flow preview data.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow_name: The data flow which contains the debug session.
    :type data_flow_name: str
    :param stream_name: The output stream name.
    :type stream_name: str
    :param row_limits: The row limit for preview request.
    :type row_limits: int
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'stream_name': {'key': 'streamName', 'type': 'str'},
        'row_limits': {'key': 'rowLimits', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        data_flow_name: Optional[str] = None,
        stream_name: Optional[str] = None,
        row_limits: Optional[int] = None,
        **kwargs
    ):
        super(DataFlowDebugPreviewDataRequest, self).__init__(**kwargs)
        self.session_id = session_id
        self.data_flow_name = data_flow_name
        self.stream_name = stream_name
        self.row_limits = row_limits


class DataFlowDebugQueryResponse(msrest.serialization.Model):
    """Response body structure of data flow query for data preview, statistics or expression preview.

    :param run_id: The run ID of data flow debug session.
    :type run_id: str
    """

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_id: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugQueryResponse, self).__init__(**kwargs)
        self.run_id = run_id


class SubResourceDebugResource(msrest.serialization.Model):
    """Azure Synapse nested debug resource.

    :param name: The resource name.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(SubResourceDebugResource, self).__init__(**kwargs)
        self.name = name


class DataFlowDebugResource(SubResourceDebugResource):
    """Data flow debug resource.

    All required parameters must be populated in order to send to Azure.

    :param name: The resource name.
    :type name: str
    :param properties: Required. Data flow properties.
    :type properties: ~azure.synapse.artifacts.models.DataFlow
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataFlow'},
    }

    def __init__(
        self,
        *,
        properties: "DataFlow",
        name: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugResource, self).__init__(name=name, **kwargs)
        self.properties = properties


class DataFlowDebugResultResponse(msrest.serialization.Model):
    """Response body structure of data flow result for data preview, statistics or expression preview.

    :param status: The run status of data preview, statistics or expression preview.
    :type status: str
    :param data: The result data of data preview, statistics or expression preview.
    :type data: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'data': {'key': 'data', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        data: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugResultResponse, self).__init__(**kwargs)
        self.status = status
        self.data = data


class DataFlowDebugSessionInfo(msrest.serialization.Model):
    """Data flow debug session info.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param data_flow_name: The name of the data flow.
    :type data_flow_name: str
    :param compute_type: Compute type of the cluster.
    :type compute_type: str
    :param core_count: Core count of the cluster.
    :type core_count: int
    :param node_count: Node count of the cluster. (deprecated property).
    :type node_count: int
    :param integration_runtime_name: Attached integration runtime name of data flow debug session.
    :type integration_runtime_name: str
    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param start_time: Start time of data flow debug session.
    :type start_time: str
    :param time_to_live_in_minutes: Compute type of the cluster.
    :type time_to_live_in_minutes: int
    :param last_activity_time: Last activity time of data flow debug session.
    :type last_activity_time: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
        'node_count': {'key': 'nodeCount', 'type': 'int'},
        'integration_runtime_name': {'key': 'integrationRuntimeName', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_to_live_in_minutes': {'key': 'timeToLiveInMinutes', 'type': 'int'},
        'last_activity_time': {'key': 'lastActivityTime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        data_flow_name: Optional[str] = None,
        compute_type: Optional[str] = None,
        core_count: Optional[int] = None,
        node_count: Optional[int] = None,
        integration_runtime_name: Optional[str] = None,
        session_id: Optional[str] = None,
        start_time: Optional[str] = None,
        time_to_live_in_minutes: Optional[int] = None,
        last_activity_time: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowDebugSessionInfo, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.data_flow_name = data_flow_name
        self.compute_type = compute_type
        self.core_count = core_count
        self.node_count = node_count
        self.integration_runtime_name = integration_runtime_name
        self.session_id = session_id
        self.start_time = start_time
        self.time_to_live_in_minutes = time_to_live_in_minutes
        self.last_activity_time = last_activity_time


class DataFlowDebugStatisticsRequest(msrest.serialization.Model):
    """Request body structure for data flow statistics.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow_name: The data flow which contains the debug session.
    :type data_flow_name: str
    :param stream_name: The output stream name.
    :type stream_name: str
    :param columns: List of column names.
    :type columns: list[str]
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'stream_name': {'key': 'streamName', 'type': 'str'},
        'columns': {'key': 'columns', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        data_flow_name: Optional[str] = None,
        stream_name: Optional[str] = None,
        columns: Optional[List[str]] = None,
        **kwargs
    ):
        super(DataFlowDebugStatisticsRequest, self).__init__(**kwargs)
        self.session_id = session_id
        self.data_flow_name = data_flow_name
        self.stream_name = stream_name
        self.columns = columns


class DataFlowFolder(msrest.serialization.Model):
    """The folder that this data flow is in. If not specified, Data flow will appear at the root level.

    :param name: The name of the folder that this data flow is in.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowFolder, self).__init__(**kwargs)
        self.name = name


class DataFlowListResponse(msrest.serialization.Model):
    """A list of data flow resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of data flows.
    :type value: list[~azure.synapse.artifacts.models.DataFlowResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataFlowResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DataFlowResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataFlowReference(msrest.serialization.Model):
    """Data flow reference type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar type: Required. Data flow reference type. Default value: "DataFlowReference".
    :vartype type: str
    :param reference_name: Required. Reference data flow name.
    :type reference_name: str
    :param dataset_parameters: Reference data flow parameters from dataset.
    :type dataset_parameters: object
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'dataset_parameters': {'key': 'datasetParameters', 'type': 'object'},
    }

    type = "DataFlowReference"

    def __init__(
        self,
        *,
        reference_name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        dataset_parameters: Optional[object] = None,
        **kwargs
    ):
        super(DataFlowReference, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.reference_name = reference_name
        self.dataset_parameters = dataset_parameters


class SubResource(msrest.serialization.Model):
    """Azure Synapse nested resource, which belongs to a workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class DataFlowResource(SubResource):
    """Data flow resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Data flow properties.
    :type properties: ~azure.synapse.artifacts.models.DataFlow
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataFlow'},
    }

    def __init__(
        self,
        *,
        properties: "DataFlow",
        **kwargs
    ):
        super(DataFlowResource, self).__init__(**kwargs)
        self.properties = properties


class Transformation(msrest.serialization.Model):
    """A data flow transformation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Transformation, self).__init__(**kwargs)
        self.name = name
        self.description = description


class DataFlowSink(Transformation):
    """Transformation for data flow sink.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    :param dataset: Dataset reference.
    :type dataset: ~azure.synapse.artifacts.models.DatasetReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'dataset': {'key': 'dataset', 'type': 'DatasetReference'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        dataset: Optional["DatasetReference"] = None,
        **kwargs
    ):
        super(DataFlowSink, self).__init__(name=name, description=description, **kwargs)
        self.dataset = dataset


class DataFlowSource(Transformation):
    """Transformation for data flow source.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    :param dataset: Dataset reference.
    :type dataset: ~azure.synapse.artifacts.models.DatasetReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'dataset': {'key': 'dataset', 'type': 'DatasetReference'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        dataset: Optional["DatasetReference"] = None,
        **kwargs
    ):
        super(DataFlowSource, self).__init__(name=name, description=description, **kwargs)
        self.dataset = dataset


class DataFlowSourceSetting(msrest.serialization.Model):
    """Definition of data flow source setting for debug.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param source_name: The data flow source name.
    :type source_name: str
    :param row_limit: Defines the row limit of data flow source in debug.
    :type row_limit: int
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'source_name': {'key': 'sourceName', 'type': 'str'},
        'row_limit': {'key': 'rowLimit', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        source_name: Optional[str] = None,
        row_limit: Optional[int] = None,
        **kwargs
    ):
        super(DataFlowSourceSetting, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.source_name = source_name
        self.row_limit = row_limit


class DataFlowStagingInfo(msrest.serialization.Model):
    """Staging info for execute data flow activity.

    :param linked_service: Staging linked service reference.
    :type linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param folder_path: Folder path for staging blob.
    :type folder_path: str
    """

    _attribute_map = {
        'linked_service': {'key': 'linkedService', 'type': 'LinkedServiceReference'},
        'folder_path': {'key': 'folderPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        linked_service: Optional["LinkedServiceReference"] = None,
        folder_path: Optional[str] = None,
        **kwargs
    ):
        super(DataFlowStagingInfo, self).__init__(**kwargs)
        self.linked_service = linked_service
        self.folder_path = folder_path


class DataLakeAnalyticsUSQLActivity(ExecutionActivity):
    """Data Lake Analytics U-SQL activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param script_path: Required. Case-sensitive path to folder that contains the U-SQL script.
     Type: string (or Expression with resultType string).
    :type script_path: object
    :param script_linked_service: Required. Script linked service reference.
    :type script_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param degree_of_parallelism: The maximum number of nodes simultaneously used to run the job.
     Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
    :type degree_of_parallelism: object
    :param priority: Determines which jobs out of all that are queued should be selected to run
     first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or
     Expression with resultType integer), minimum: 1.
    :type priority: object
    :param parameters: Parameters for U-SQL job request.
    :type parameters: dict[str, object]
    :param runtime_version: Runtime version of the U-SQL engine to use. Type: string (or Expression
     with resultType string).
    :type runtime_version: object
    :param compilation_mode: Compilation mode of U-SQL. Must be one of these values : Semantic,
     Full and SingleBox. Type: string (or Expression with resultType string).
    :type compilation_mode: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'script_path': {'required': True},
        'script_linked_service': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'degree_of_parallelism': {'key': 'typeProperties.degreeOfParallelism', 'type': 'object'},
        'priority': {'key': 'typeProperties.priority', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '{object}'},
        'runtime_version': {'key': 'typeProperties.runtimeVersion', 'type': 'object'},
        'compilation_mode': {'key': 'typeProperties.compilationMode', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        script_path: object,
        script_linked_service: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        degree_of_parallelism: Optional[object] = None,
        priority: Optional[object] = None,
        parameters: Optional[Dict[str, object]] = None,
        runtime_version: Optional[object] = None,
        compilation_mode: Optional[object] = None,
        **kwargs
    ):
        super(DataLakeAnalyticsUSQLActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'DataLakeAnalyticsU-SQL'
        self.script_path = script_path
        self.script_linked_service = script_linked_service
        self.degree_of_parallelism = degree_of_parallelism
        self.priority = priority
        self.parameters = parameters
        self.runtime_version = runtime_version
        self.compilation_mode = compilation_mode


class DatasetCompression(msrest.serialization.Model):
    """The compression method used on a dataset.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DatasetBZip2Compression, DatasetDeflateCompression, DatasetGZipCompression, DatasetZipDeflateCompression.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'BZip2': 'DatasetBZip2Compression', 'Deflate': 'DatasetDeflateCompression', 'GZip': 'DatasetGZipCompression', 'ZipDeflate': 'DatasetZipDeflateCompression'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(DatasetCompression, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type: str = 'DatasetCompression'


class DatasetBZip2Compression(DatasetCompression):
    """The BZip2 compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(DatasetBZip2Compression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type: str = 'BZip2'


class DatasetDebugResource(SubResourceDebugResource):
    """Dataset debug resource.

    All required parameters must be populated in order to send to Azure.

    :param name: The resource name.
    :type name: str
    :param properties: Required. Dataset properties.
    :type properties: ~azure.synapse.artifacts.models.Dataset
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Dataset'},
    }

    def __init__(
        self,
        *,
        properties: "Dataset",
        name: Optional[str] = None,
        **kwargs
    ):
        super(DatasetDebugResource, self).__init__(name=name, **kwargs)
        self.properties = properties


class DatasetDeflateCompression(DatasetCompression):
    """The Deflate compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    :param level: The Deflate compression level. Possible values include: "Optimal", "Fastest".
    :type level: str or ~azure.synapse.artifacts.models.DatasetCompressionLevel
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        level: Optional[Union[str, "DatasetCompressionLevel"]] = None,
        **kwargs
    ):
        super(DatasetDeflateCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type: str = 'Deflate'
        self.level = level


class DatasetFolder(msrest.serialization.Model):
    """The folder that this Dataset is in. If not specified, Dataset will appear at the root level.

    :param name: The name of the folder that this Dataset is in.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DatasetFolder, self).__init__(**kwargs)
        self.name = name


class DatasetGZipCompression(DatasetCompression):
    """The GZip compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    :param level: The GZip compression level. Possible values include: "Optimal", "Fastest".
    :type level: str or ~azure.synapse.artifacts.models.DatasetCompressionLevel
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        level: Optional[Union[str, "DatasetCompressionLevel"]] = None,
        **kwargs
    ):
        super(DatasetGZipCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type: str = 'GZip'
        self.level = level


class DatasetListResponse(msrest.serialization.Model):
    """A list of dataset resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of datasets.
    :type value: list[~azure.synapse.artifacts.models.DatasetResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatasetResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DatasetResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DatasetListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DatasetLocation(msrest.serialization.Model):
    """Dataset location.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: .

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    _subtype_map = {
        'type': {}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        folder_path: Optional[object] = None,
        file_name: Optional[object] = None,
        **kwargs
    ):
        super(DatasetLocation, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type: str = 'DatasetLocation'
        self.folder_path = folder_path
        self.file_name = file_name


class DatasetReference(msrest.serialization.Model):
    """Dataset reference type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Dataset reference type. Default value: "DatasetReference".
    :vartype type: str
    :param reference_name: Required. Reference dataset name.
    :type reference_name: str
    :param parameters: Arguments for dataset.
    :type parameters: dict[str, object]
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    type = "DatasetReference"

    def __init__(
        self,
        *,
        reference_name: str,
        parameters: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(DatasetReference, self).__init__(**kwargs)
        self.reference_name = reference_name
        self.parameters = parameters


class DatasetResource(SubResource):
    """Dataset resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Dataset properties.
    :type properties: ~azure.synapse.artifacts.models.Dataset
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Dataset'},
    }

    def __init__(
        self,
        *,
        properties: "Dataset",
        **kwargs
    ):
        super(DatasetResource, self).__init__(**kwargs)
        self.properties = properties


class DatasetZipDeflateCompression(DatasetCompression):
    """The ZipDeflate compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    :param level: The ZipDeflate compression level. Possible values include: "Optimal", "Fastest".
    :type level: str or ~azure.synapse.artifacts.models.DatasetCompressionLevel
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        level: Optional[Union[str, "DatasetCompressionLevel"]] = None,
        **kwargs
    ):
        super(DatasetZipDeflateCompression, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type: str = 'ZipDeflate'
        self.level = level


class Db2LinkedService(LinkedService):
    """Linked service for DB2 data source.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param server: Required. Server name for connection. Type: string (or Expression with
     resultType string).
    :type server: object
    :param database: Required. Database name for connection. Type: string (or Expression with
     resultType string).
    :type database: object
    :ivar authentication_type: AuthenticationType to be used for connection. Default value:
     "Basic".
    :vartype authentication_type: str
    :param username: Username for authentication. Type: string (or Expression with resultType
     string).
    :type username: object
    :param password: Password for authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param package_collection: Under where packages are created when querying database. Type:
     string (or Expression with resultType string).
    :type package_collection: object
    :param certificate_common_name: Certificate Common Name when TLS is enabled. Type: string (or
     Expression with resultType string).
    :type certificate_common_name: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
        'database': {'required': True},
        'authentication_type': {'constant': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'package_collection': {'key': 'typeProperties.packageCollection', 'type': 'object'},
        'certificate_common_name': {'key': 'typeProperties.certificateCommonName', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    authentication_type = "Basic"

    def __init__(
        self,
        *,
        server: object,
        database: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        package_collection: Optional[object] = None,
        certificate_common_name: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(Db2LinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Db2'
        self.server = server
        self.database = database
        self.username = username
        self.password = password
        self.package_collection = package_collection
        self.certificate_common_name = certificate_common_name
        self.encrypted_credential = encrypted_credential


class Db2TableDataset(Dataset):
    """The Db2 table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The Db2 schema name. Type: string (or Expression with
     resultType string).
    :type schema_type_properties_schema: object
    :param table: The Db2 table name. Type: string (or Expression with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(Db2TableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'Db2Table'
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class DeleteActivity(ExecutionActivity):
    """Delete activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param recursive: If true, files or sub-folders under current folder path will be deleted
     recursively. Default is false. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param max_concurrent_connections: The max concurrent connections to connect data source at the
     same time.
    :type max_concurrent_connections: int
    :param enable_logging: Whether to record detailed logs of delete-activity execution. Default
     value is false. Type: boolean (or Expression with resultType boolean).
    :type enable_logging: object
    :param log_storage_settings: Log storage settings customer need to provide when enableLogging
     is true.
    :type log_storage_settings: ~azure.synapse.artifacts.models.LogStorageSettings
    :param dataset: Required. Delete activity dataset reference.
    :type dataset: ~azure.synapse.artifacts.models.DatasetReference
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'max_concurrent_connections': {'minimum': 1},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'recursive': {'key': 'typeProperties.recursive', 'type': 'object'},
        'max_concurrent_connections': {'key': 'typeProperties.maxConcurrentConnections', 'type': 'int'},
        'enable_logging': {'key': 'typeProperties.enableLogging', 'type': 'object'},
        'log_storage_settings': {'key': 'typeProperties.logStorageSettings', 'type': 'LogStorageSettings'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
    }

    def __init__(
        self,
        *,
        name: str,
        dataset: "DatasetReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        recursive: Optional[object] = None,
        max_concurrent_connections: Optional[int] = None,
        enable_logging: Optional[object] = None,
        log_storage_settings: Optional["LogStorageSettings"] = None,
        **kwargs
    ):
        super(DeleteActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'Delete'
        self.recursive = recursive
        self.max_concurrent_connections = max_concurrent_connections
        self.enable_logging = enable_logging
        self.log_storage_settings = log_storage_settings
        self.dataset = dataset


class DeleteDataFlowDebugSessionRequest(msrest.serialization.Model):
    """Request body structure for deleting data flow debug session.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow_name: The data flow which contains the debug session.
    :type data_flow_name: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        data_flow_name: Optional[str] = None,
        **kwargs
    ):
        super(DeleteDataFlowDebugSessionRequest, self).__init__(**kwargs)
        self.session_id = session_id
        self.data_flow_name = data_flow_name


class DelimitedTextDataset(Dataset):
    """Delimited text dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the delimited text storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param column_delimiter: The column delimiter. Type: string (or Expression with resultType
     string).
    :type column_delimiter: object
    :param row_delimiter: The row delimiter. Type: string (or Expression with resultType string).
    :type row_delimiter: object
    :param encoding_name: The code page name of the preferred encoding. If miss, the default value
     is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in
     the following link to set supported values:
     https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with
     resultType string).
    :type encoding_name: object
    :param compression_codec:  Possible values include: "bzip2", "gzip", "deflate", "zipDeflate",
     "snappy", "lz4".
    :type compression_codec: str or ~azure.synapse.artifacts.models.DelimitedTextCompressionCodec
    :param compression_level: The data compression method used for DelimitedText. Possible values
     include: "Optimal", "Fastest".
    :type compression_level: str or ~azure.synapse.artifacts.models.DatasetCompressionLevel
    :param quote_char: The quote character. Type: string (or Expression with resultType string).
    :type quote_char: object
    :param escape_char: The escape character. Type: string (or Expression with resultType string).
    :type escape_char: object
    :param first_row_as_header: When used as input, treat the first row of data as headers. When
     used as output,write the headers into the output as the first row of data. The default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type first_row_as_header: object
    :param null_value: The null value string. Type: string (or Expression with resultType string).
    :type null_value: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'column_delimiter': {'key': 'typeProperties.columnDelimiter', 'type': 'object'},
        'row_delimiter': {'key': 'typeProperties.rowDelimiter', 'type': 'object'},
        'encoding_name': {'key': 'typeProperties.encodingName', 'type': 'object'},
        'compression_codec': {'key': 'typeProperties.compressionCodec', 'type': 'str'},
        'compression_level': {'key': 'typeProperties.compressionLevel', 'type': 'str'},
        'quote_char': {'key': 'typeProperties.quoteChar', 'type': 'object'},
        'escape_char': {'key': 'typeProperties.escapeChar', 'type': 'object'},
        'first_row_as_header': {'key': 'typeProperties.firstRowAsHeader', 'type': 'object'},
        'null_value': {'key': 'typeProperties.nullValue', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        column_delimiter: Optional[object] = None,
        row_delimiter: Optional[object] = None,
        encoding_name: Optional[object] = None,
        compression_codec: Optional[Union[str, "DelimitedTextCompressionCodec"]] = None,
        compression_level: Optional[Union[str, "DatasetCompressionLevel"]] = None,
        quote_char: Optional[object] = None,
        escape_char: Optional[object] = None,
        first_row_as_header: Optional[object] = None,
        null_value: Optional[object] = None,
        **kwargs
    ):
        super(DelimitedTextDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'DelimitedText'
        self.location = location
        self.column_delimiter = column_delimiter
        self.row_delimiter = row_delimiter
        self.encoding_name = encoding_name
        self.compression_codec = compression_codec
        self.compression_level = compression_level
        self.quote_char = quote_char
        self.escape_char = escape_char
        self.first_row_as_header = first_row_as_header
        self.null_value = null_value


class DocumentDbCollectionDataset(Dataset):
    """Microsoft Azure Document Database Collection dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param collection_name: Required. Document Database collection name. Type: string (or
     Expression with resultType string).
    :type collection_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection_name': {'key': 'typeProperties.collectionName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(DocumentDbCollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'DocumentDbCollection'
        self.collection_name = collection_name


class DrillLinkedService(LinkedService):
    """Drill server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(DrillLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Drill'
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class DrillTableDataset(Dataset):
    """Drill server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Drill. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Drill. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(DrillTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'DrillTable'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class DynamicsAXLinkedService(LinkedService):
    """Dynamics AX linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The Dynamics AX (or Dynamics 365 Finance and Operations) instance OData
     endpoint.
    :type url: object
    :param service_principal_id: Required. Specify the application's client ID. Type: string (or
     Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: Required. Specify the application's key. Mark this field as a
     SecureString to store it securely in Data Factory, or reference a secret stored in Azure Key
     Vault. Type: string (or Expression with resultType string).
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: Required. Specify the tenant information (domain name or tenant ID) under which
     your application resides. Retrieve it by hovering the mouse in the top-right corner of the
     Azure portal. Type: string (or Expression with resultType string).
    :type tenant: object
    :param aad_resource_id: Required. Specify the resource you are requesting authorization. Type:
     string (or Expression with resultType string).
    :type aad_resource_id: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
        'service_principal_id': {'required': True},
        'service_principal_key': {'required': True},
        'tenant': {'required': True},
        'aad_resource_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'aad_resource_id': {'key': 'typeProperties.aadResourceId', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        service_principal_id: object,
        service_principal_key: "SecretBase",
        tenant: object,
        aad_resource_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsAXLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'DynamicsAX'
        self.url = url
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.aad_resource_id = aad_resource_id
        self.encrypted_credential = encrypted_credential


class DynamicsAXResourceDataset(Dataset):
    """The path of the Dynamics AX OData entity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param path: Required. The path of the Dynamics AX OData entity. Type: string (or Expression
     with resultType string).
    :type path: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'path': {'key': 'typeProperties.path', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(DynamicsAXResourceDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'DynamicsAXResource'
        self.path = path


class DynamicsCrmEntityDataset(Dataset):
    """The Dynamics CRM entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        entity_name: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsCrmEntityDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'DynamicsCrmEntity'
        self.entity_name = entity_name


class DynamicsCrmLinkedService(LinkedService):
    """Dynamics CRM linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param deployment_type: Required. The deployment type of the Dynamics CRM instance. 'Online'
     for Dynamics CRM Online and 'OnPremisesWithIfd' for Dynamics CRM on-premises with Ifd. Type:
     string (or Expression with resultType string). Possible values include: "Online",
     "OnPremisesWithIfd".
    :type deployment_type: str or ~azure.synapse.artifacts.models.DynamicsDeploymentType
    :param host_name: The host name of the on-premises Dynamics CRM server. The property is
     required for on-prem and not allowed for online. Type: string (or Expression with resultType
     string).
    :type host_name: object
    :param port: The port of on-premises Dynamics CRM server. The property is required for on-prem
     and not allowed for online. Default is 443. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type port: object
    :param service_uri: The URL to the Microsoft Dynamics CRM server. The property is required for
     on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
    :type service_uri: object
    :param organization_name: The organization name of the Dynamics CRM instance. The property is
     required for on-prem and required for online when there are more than one Dynamics CRM
     instances associated with the user. Type: string (or Expression with resultType string).
    :type organization_name: object
    :param authentication_type: Required. The authentication type to connect to Dynamics CRM
     server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario,
     'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or
     Expression with resultType string). Possible values include: "Office365", "Ifd",
     "AADServicePrincipal".
    :type authentication_type: str or ~azure.synapse.artifacts.models.DynamicsAuthenticationType
    :param username: User name to access the Dynamics CRM instance. Type: string (or Expression
     with resultType string).
    :type username: object
    :param password: Password to access the Dynamics CRM instance.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.synapse.artifacts.models.DynamicsServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'str'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'object'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        deployment_type: Union[str, "DynamicsDeploymentType"],
        authentication_type: Union[str, "DynamicsAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        host_name: Optional[object] = None,
        port: Optional[object] = None,
        service_uri: Optional[object] = None,
        organization_name: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_credential_type: Optional[Union[str, "DynamicsServicePrincipalCredentialType"]] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsCrmLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'DynamicsCrm'
        self.deployment_type = deployment_type
        self.host_name = host_name
        self.port = port
        self.service_uri = service_uri
        self.organization_name = organization_name
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.encrypted_credential = encrypted_credential


class DynamicsEntityDataset(Dataset):
    """The Dynamics entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        entity_name: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsEntityDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'DynamicsEntity'
        self.entity_name = entity_name


class DynamicsLinkedService(LinkedService):
    """Dynamics linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param deployment_type: Required. The deployment type of the Dynamics instance. 'Online' for
     Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or
     Expression with resultType string). Possible values include: "Online", "OnPremisesWithIfd".
    :type deployment_type: str or ~azure.synapse.artifacts.models.DynamicsDeploymentType
    :param host_name: The host name of the on-premises Dynamics server. The property is required
     for on-prem and not allowed for online. Type: string (or Expression with resultType string).
    :type host_name: str
    :param port: The port of on-premises Dynamics server. The property is required for on-prem and
     not allowed for online. Default is 443. Type: integer (or Expression with resultType integer),
     minimum: 0.
    :type port: str
    :param service_uri: The URL to the Microsoft Dynamics server. The property is required for on-
     line and not allowed for on-prem. Type: string (or Expression with resultType string).
    :type service_uri: str
    :param organization_name: The organization name of the Dynamics instance. The property is
     required for on-prem and required for online when there are more than one Dynamics instances
     associated with the user. Type: string (or Expression with resultType string).
    :type organization_name: str
    :param authentication_type: Required. The authentication type to connect to Dynamics server.
     'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal'
     for Server-To-Server authentication in online scenario. Type: string (or Expression with
     resultType string). Possible values include: "Office365", "Ifd", "AADServicePrincipal".
    :type authentication_type: str or ~azure.synapse.artifacts.models.DynamicsAuthenticationType
    :param username: User name to access the Dynamics instance. Type: string (or Expression with
     resultType string).
    :type username: object
    :param password: Password to access the Dynamics instance.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.synapse.artifacts.models.DynamicsServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'str'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'str'},
        'port': {'key': 'typeProperties.port', 'type': 'str'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'str'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'str'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        deployment_type: Union[str, "DynamicsDeploymentType"],
        authentication_type: Union[str, "DynamicsAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        host_name: Optional[str] = None,
        port: Optional[str] = None,
        service_uri: Optional[str] = None,
        organization_name: Optional[str] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_credential_type: Optional[Union[str, "DynamicsServicePrincipalCredentialType"]] = None,
        service_principal_credential: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(DynamicsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Dynamics'
        self.deployment_type = deployment_type
        self.host_name = host_name
        self.port = port
        self.service_uri = service_uri
        self.organization_name = organization_name
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.encrypted_credential = encrypted_credential


class EloquaLinkedService(LinkedService):
    """Eloqua server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the Eloqua server. (i.e. eloqua.example.com).
    :type endpoint: object
    :param username: Required. The site name and user name of your Eloqua account in the form:
     sitename/username. (i.e. Eloqua/Alice).
    :type username: object
    :param password: The password corresponding to the user name.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: object,
        username: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(EloquaLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Eloqua'
        self.endpoint = endpoint
        self.username = username
        self.password = password
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class EloquaObjectDataset(Dataset):
    """Eloqua server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(EloquaObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'EloquaObject'
        self.table_name = table_name


class EvaluateDataFlowExpressionRequest(msrest.serialization.Model):
    """Request body structure for data flow expression preview.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow_name: The data flow which contains the debug session.
    :type data_flow_name: str
    :param stream_name: The output stream name.
    :type stream_name: str
    :param row_limits: The row limit for preview request.
    :type row_limits: int
    :param expression: The expression for preview.
    :type expression: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'stream_name': {'key': 'streamName', 'type': 'str'},
        'row_limits': {'key': 'rowLimits', 'type': 'int'},
        'expression': {'key': 'expression', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        data_flow_name: Optional[str] = None,
        stream_name: Optional[str] = None,
        row_limits: Optional[int] = None,
        expression: Optional[str] = None,
        **kwargs
    ):
        super(EvaluateDataFlowExpressionRequest, self).__init__(**kwargs)
        self.session_id = session_id
        self.data_flow_name = data_flow_name
        self.stream_name = stream_name
        self.row_limits = row_limits
        self.expression = expression


class ExecuteDataFlowActivity(ExecutionActivity):
    """Execute data flow activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param data_flow: Required. Data flow reference.
    :type data_flow: ~azure.synapse.artifacts.models.DataFlowReference
    :param staging: Staging info for execute data flow activity.
    :type staging: ~azure.synapse.artifacts.models.DataFlowStagingInfo
    :param integration_runtime: The integration runtime reference.
    :type integration_runtime: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param compute: Compute properties for data flow activity.
    :type compute: ~azure.synapse.artifacts.models.ExecuteDataFlowActivityTypePropertiesCompute
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'data_flow': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'data_flow': {'key': 'typeProperties.dataFlow', 'type': 'DataFlowReference'},
        'staging': {'key': 'typeProperties.staging', 'type': 'DataFlowStagingInfo'},
        'integration_runtime': {'key': 'typeProperties.integrationRuntime', 'type': 'IntegrationRuntimeReference'},
        'compute': {'key': 'typeProperties.compute', 'type': 'ExecuteDataFlowActivityTypePropertiesCompute'},
    }

    def __init__(
        self,
        *,
        name: str,
        data_flow: "DataFlowReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        staging: Optional["DataFlowStagingInfo"] = None,
        integration_runtime: Optional["IntegrationRuntimeReference"] = None,
        compute: Optional["ExecuteDataFlowActivityTypePropertiesCompute"] = None,
        **kwargs
    ):
        super(ExecuteDataFlowActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'ExecuteDataFlow'
        self.data_flow = data_flow
        self.staging = staging
        self.integration_runtime = integration_runtime
        self.compute = compute


class ExecuteDataFlowActivityTypePropertiesCompute(msrest.serialization.Model):
    """Compute properties for data flow activity.

    :param compute_type: Compute type of the cluster which will execute data flow job. Possible
     values include: "General", "MemoryOptimized", "ComputeOptimized".
    :type compute_type: str or ~azure.synapse.artifacts.models.DataFlowComputeType
    :param core_count: Core count of the cluster which will execute data flow job. Supported values
     are: 8, 16, 32, 48, 80, 144 and 272.
    :type core_count: int
    """

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        compute_type: Optional[Union[str, "DataFlowComputeType"]] = None,
        core_count: Optional[int] = None,
        **kwargs
    ):
        super(ExecuteDataFlowActivityTypePropertiesCompute, self).__init__(**kwargs)
        self.compute_type = compute_type
        self.core_count = core_count


class ExecutePipelineActivity(Activity):
    """Execute pipeline activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param pipeline: Required. Pipeline reference.
    :type pipeline: ~azure.synapse.artifacts.models.PipelineReference
    :param parameters: Pipeline parameters.
    :type parameters: dict[str, object]
    :param wait_on_completion: Defines whether activity execution will wait for the dependent
     pipeline execution to finish. Default is false.
    :type wait_on_completion: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'pipeline': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'pipeline': {'key': 'typeProperties.pipeline', 'type': 'PipelineReference'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '{object}'},
        'wait_on_completion': {'key': 'typeProperties.waitOnCompletion', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        pipeline: "PipelineReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        parameters: Optional[Dict[str, object]] = None,
        wait_on_completion: Optional[bool] = None,
        **kwargs
    ):
        super(ExecutePipelineActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type: str = 'ExecutePipeline'
        self.pipeline = pipeline
        self.parameters = parameters
        self.wait_on_completion = wait_on_completion


class ExecuteSSISPackageActivity(ExecutionActivity):
    """Execute SSIS package activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param package_location: Required. SSIS package location.
    :type package_location: ~azure.synapse.artifacts.models.SSISPackageLocation
    :param runtime: Specifies the runtime to execute SSIS package. The value should be "x86" or
     "x64". Type: string (or Expression with resultType string).
    :type runtime: object
    :param logging_level: The logging level of SSIS package execution. Type: string (or Expression
     with resultType string).
    :type logging_level: object
    :param environment_path: The environment path to execute the SSIS package. Type: string (or
     Expression with resultType string).
    :type environment_path: object
    :param execution_credential: The package execution credential.
    :type execution_credential: ~azure.synapse.artifacts.models.SSISExecutionCredential
    :param connect_via: Required. The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param project_parameters: The project level parameters to execute the SSIS package.
    :type project_parameters: dict[str, ~azure.synapse.artifacts.models.SSISExecutionParameter]
    :param package_parameters: The package level parameters to execute the SSIS package.
    :type package_parameters: dict[str, ~azure.synapse.artifacts.models.SSISExecutionParameter]
    :param project_connection_managers: The project level connection managers to execute the SSIS
     package.
    :type project_connection_managers: dict[str, object]
    :param package_connection_managers: The package level connection managers to execute the SSIS
     package.
    :type package_connection_managers: dict[str, object]
    :param property_overrides: The property overrides to execute the SSIS package.
    :type property_overrides: dict[str, ~azure.synapse.artifacts.models.SSISPropertyOverride]
    :param log_location: SSIS package execution log location.
    :type log_location: ~azure.synapse.artifacts.models.SSISLogLocation
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'package_location': {'required': True},
        'connect_via': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'package_location': {'key': 'typeProperties.packageLocation', 'type': 'SSISPackageLocation'},
        'runtime': {'key': 'typeProperties.runtime', 'type': 'object'},
        'logging_level': {'key': 'typeProperties.loggingLevel', 'type': 'object'},
        'environment_path': {'key': 'typeProperties.environmentPath', 'type': 'object'},
        'execution_credential': {'key': 'typeProperties.executionCredential', 'type': 'SSISExecutionCredential'},
        'connect_via': {'key': 'typeProperties.connectVia', 'type': 'IntegrationRuntimeReference'},
        'project_parameters': {'key': 'typeProperties.projectParameters', 'type': '{SSISExecutionParameter}'},
        'package_parameters': {'key': 'typeProperties.packageParameters', 'type': '{SSISExecutionParameter}'},
        'project_connection_managers': {'key': 'typeProperties.projectConnectionManagers', 'type': '{object}'},
        'package_connection_managers': {'key': 'typeProperties.packageConnectionManagers', 'type': '{object}'},
        'property_overrides': {'key': 'typeProperties.propertyOverrides', 'type': '{SSISPropertyOverride}'},
        'log_location': {'key': 'typeProperties.logLocation', 'type': 'SSISLogLocation'},
    }

    def __init__(
        self,
        *,
        name: str,
        package_location: "SSISPackageLocation",
        connect_via: "IntegrationRuntimeReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        runtime: Optional[object] = None,
        logging_level: Optional[object] = None,
        environment_path: Optional[object] = None,
        execution_credential: Optional["SSISExecutionCredential"] = None,
        project_parameters: Optional[Dict[str, "SSISExecutionParameter"]] = None,
        package_parameters: Optional[Dict[str, "SSISExecutionParameter"]] = None,
        project_connection_managers: Optional[Dict[str, object]] = None,
        package_connection_managers: Optional[Dict[str, object]] = None,
        property_overrides: Optional[Dict[str, "SSISPropertyOverride"]] = None,
        log_location: Optional["SSISLogLocation"] = None,
        **kwargs
    ):
        super(ExecuteSSISPackageActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'ExecuteSSISPackage'
        self.package_location = package_location
        self.runtime = runtime
        self.logging_level = logging_level
        self.environment_path = environment_path
        self.execution_credential = execution_credential
        self.connect_via = connect_via
        self.project_parameters = project_parameters
        self.package_parameters = package_parameters
        self.project_connection_managers = project_connection_managers
        self.package_connection_managers = package_connection_managers
        self.property_overrides = property_overrides
        self.log_location = log_location


class ExposureControlRequest(msrest.serialization.Model):
    """The exposure control request.

    :param feature_name: The feature name.
    :type feature_name: str
    :param feature_type: The feature type.
    :type feature_type: str
    """

    _attribute_map = {
        'feature_name': {'key': 'featureName', 'type': 'str'},
        'feature_type': {'key': 'featureType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        feature_name: Optional[str] = None,
        feature_type: Optional[str] = None,
        **kwargs
    ):
        super(ExposureControlRequest, self).__init__(**kwargs)
        self.feature_name = feature_name
        self.feature_type = feature_type


class ExposureControlResponse(msrest.serialization.Model):
    """The exposure control response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar feature_name: The feature name.
    :vartype feature_name: str
    :ivar value: The feature value.
    :vartype value: str
    """

    _validation = {
        'feature_name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'feature_name': {'key': 'featureName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExposureControlResponse, self).__init__(**kwargs)
        self.feature_name = None
        self.value = None


class Expression(msrest.serialization.Model):
    """Azure Synapse expression definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Expression type. Default value: "Expression".
    :vartype type: str
    :param value: Required. Expression value.
    :type value: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    type = "Expression"

    def __init__(
        self,
        *,
        value: str,
        **kwargs
    ):
        super(Expression, self).__init__(**kwargs)
        self.value = value


class FileServerLinkedService(LinkedService):
    """File system linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name of the server. Type: string (or Expression with resultType
     string).
    :type host: object
    :param user_id: User ID to logon the server. Type: string (or Expression with resultType
     string).
    :type user_id: object
    :param password: Password to logon the server.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'user_id': {'key': 'typeProperties.userId', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        user_id: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(FileServerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'FileServer'
        self.host = host
        self.user_id = user_id
        self.password = password
        self.encrypted_credential = encrypted_credential


class FilterActivity(Activity):
    """Filter and return results from input array based on the conditions.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param items: Required. Input array on which filter should be applied.
    :type items: ~azure.synapse.artifacts.models.Expression
    :param condition: Required. Condition to be used for filtering the input.
    :type condition: ~azure.synapse.artifacts.models.Expression
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'items': {'required': True},
        'condition': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'items': {'key': 'typeProperties.items', 'type': 'Expression'},
        'condition': {'key': 'typeProperties.condition', 'type': 'Expression'},
    }

    def __init__(
        self,
        *,
        name: str,
        items: "Expression",
        condition: "Expression",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        **kwargs
    ):
        super(FilterActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type: str = 'Filter'
        self.items = items
        self.condition = condition


class ForEachActivity(Activity):
    """This activity is used for iterating over a collection and execute given activities.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param is_sequential: Should the loop be executed in sequence or in parallel (max 50).
    :type is_sequential: bool
    :param batch_count: Batch count to be used for controlling the number of parallel execution
     (when isSequential is set to false).
    :type batch_count: int
    :param items: Required. Collection to iterate.
    :type items: ~azure.synapse.artifacts.models.Expression
    :param activities: Required. List of activities to execute .
    :type activities: list[~azure.synapse.artifacts.models.Activity]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'batch_count': {'maximum': 50},
        'items': {'required': True},
        'activities': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'is_sequential': {'key': 'typeProperties.isSequential', 'type': 'bool'},
        'batch_count': {'key': 'typeProperties.batchCount', 'type': 'int'},
        'items': {'key': 'typeProperties.items', 'type': 'Expression'},
        'activities': {'key': 'typeProperties.activities', 'type': '[Activity]'},
    }

    def __init__(
        self,
        *,
        name: str,
        items: "Expression",
        activities: List["Activity"],
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        is_sequential: Optional[bool] = None,
        batch_count: Optional[int] = None,
        **kwargs
    ):
        super(ForEachActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type: str = 'ForEach'
        self.is_sequential = is_sequential
        self.batch_count = batch_count
        self.items = items
        self.activities = activities


class FtpServerLinkedService(LinkedService):
    """A FTP server Linked Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name of the FTP server. Type: string (or Expression with resultType
     string).
    :type host: object
    :param port: The TCP port number that the FTP server uses to listen for client connections.
     Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
    :type port: object
    :param authentication_type: The authentication type to be used to connect to the FTP server.
     Possible values include: "Basic", "Anonymous".
    :type authentication_type: str or ~azure.synapse.artifacts.models.FtpAuthenticationType
    :param user_name: Username to logon the FTP server. Type: string (or Expression with resultType
     string).
    :type user_name: object
    :param password: Password to logon the FTP server.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param enable_ssl: If true, connect to the FTP server over SSL/TLS channel. Default value is
     true. Type: boolean (or Expression with resultType boolean).
    :type enable_ssl: object
    :param enable_server_certificate_validation: If true, validate the FTP server SSL certificate
     when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with
     resultType boolean).
    :type enable_server_certificate_validation: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'enable_server_certificate_validation': {'key': 'typeProperties.enableServerCertificateValidation', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        authentication_type: Optional[Union[str, "FtpAuthenticationType"]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        enable_ssl: Optional[object] = None,
        enable_server_certificate_validation: Optional[object] = None,
        **kwargs
    ):
        super(FtpServerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'FtpServer'
        self.host = host
        self.port = port
        self.authentication_type = authentication_type
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential
        self.enable_ssl = enable_ssl
        self.enable_server_certificate_validation = enable_server_certificate_validation


class GetMetadataActivity(ExecutionActivity):
    """Activity to get metadata of dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param dataset: Required. GetMetadata activity dataset reference.
    :type dataset: ~azure.synapse.artifacts.models.DatasetReference
    :param field_list: Fields of metadata to get from dataset.
    :type field_list: list[object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
        'field_list': {'key': 'typeProperties.fieldList', 'type': '[object]'},
    }

    def __init__(
        self,
        *,
        name: str,
        dataset: "DatasetReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        field_list: Optional[List[object]] = None,
        **kwargs
    ):
        super(GetMetadataActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'GetMetadata'
        self.dataset = dataset
        self.field_list = field_list


class GetSsisObjectMetadataRequest(msrest.serialization.Model):
    """The request payload of get SSIS object metadata.

    :param metadata_path: Metadata path.
    :type metadata_path: str
    """

    _attribute_map = {
        'metadata_path': {'key': 'metadataPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metadata_path: Optional[str] = None,
        **kwargs
    ):
        super(GetSsisObjectMetadataRequest, self).__init__(**kwargs)
        self.metadata_path = metadata_path


class GoogleAdWordsLinkedService(LinkedService):
    """Google AdWords service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param client_customer_id: Required. The Client customer ID of the AdWords account that you
     want to fetch report data for.
    :type client_customer_id: object
    :param developer_token: Required. The developer token associated with the manager account that
     you use to grant access to the AdWords API.
    :type developer_token: ~azure.synapse.artifacts.models.SecretBase
    :param authentication_type: Required. The OAuth 2.0 authentication mechanism used for
     authentication. ServiceAuthentication can only be used on self-hosted IR. Possible values
     include: "ServiceAuthentication", "UserAuthentication".
    :type authentication_type: str or
     ~azure.synapse.artifacts.models.GoogleAdWordsAuthenticationType
    :param refresh_token: The refresh token obtained from Google for authorizing access to AdWords
     for UserAuthentication.
    :type refresh_token: ~azure.synapse.artifacts.models.SecretBase
    :param client_id: The client id of the google application used to acquire the refresh token.
     Type: string (or Expression with resultType string).
    :type client_id: object
    :param client_secret: The client secret of the google application used to acquire the refresh
     token.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param email: The service account email ID that is used for ServiceAuthentication and can only
     be used on self-hosted IR.
    :type email: object
    :param key_file_path: The full path to the .p12 key file that is used to authenticate the
     service account email address and can only be used on self-hosted IR.
    :type key_file_path: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'client_customer_id': {'required': True},
        'developer_token': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'client_customer_id': {'key': 'typeProperties.clientCustomerID', 'type': 'object'},
        'developer_token': {'key': 'typeProperties.developerToken', 'type': 'SecretBase'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'refresh_token': {'key': 'typeProperties.refreshToken', 'type': 'SecretBase'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'email': {'key': 'typeProperties.email', 'type': 'object'},
        'key_file_path': {'key': 'typeProperties.keyFilePath', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        client_customer_id: object,
        developer_token: "SecretBase",
        authentication_type: Union[str, "GoogleAdWordsAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        refresh_token: Optional["SecretBase"] = None,
        client_id: Optional[object] = None,
        client_secret: Optional["SecretBase"] = None,
        email: Optional[object] = None,
        key_file_path: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        use_system_trust_store: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(GoogleAdWordsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'GoogleAdWords'
        self.client_customer_id = client_customer_id
        self.developer_token = developer_token
        self.authentication_type = authentication_type
        self.refresh_token = refresh_token
        self.client_id = client_id
        self.client_secret = client_secret
        self.email = email
        self.key_file_path = key_file_path
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.encrypted_credential = encrypted_credential


class GoogleAdWordsObjectDataset(Dataset):
    """Google AdWords service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(GoogleAdWordsObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'GoogleAdWordsObject'
        self.table_name = table_name


class GoogleBigQueryLinkedService(LinkedService):
    """Google BigQuery service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param project: Required. The default BigQuery project to query against.
    :type project: object
    :param additional_projects: A comma-separated list of public BigQuery projects to access.
    :type additional_projects: object
    :param request_google_drive_scope: Whether to request access to Google Drive. Allowing Google
     Drive access enables support for federated tables that combine BigQuery data with data from
     Google Drive. The default value is false.
    :type request_google_drive_scope: object
    :param authentication_type: Required. The OAuth 2.0 authentication mechanism used for
     authentication. ServiceAuthentication can only be used on self-hosted IR. Possible values
     include: "ServiceAuthentication", "UserAuthentication".
    :type authentication_type: str or
     ~azure.synapse.artifacts.models.GoogleBigQueryAuthenticationType
    :param refresh_token: The refresh token obtained from Google for authorizing access to BigQuery
     for UserAuthentication.
    :type refresh_token: ~azure.synapse.artifacts.models.SecretBase
    :param client_id: The client id of the google application used to acquire the refresh token.
     Type: string (or Expression with resultType string).
    :type client_id: object
    :param client_secret: The client secret of the google application used to acquire the refresh
     token.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param email: The service account email ID that is used for ServiceAuthentication and can only
     be used on self-hosted IR.
    :type email: object
    :param key_file_path: The full path to the .p12 key file that is used to authenticate the
     service account email address and can only be used on self-hosted IR.
    :type key_file_path: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'project': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'project': {'key': 'typeProperties.project', 'type': 'object'},
        'additional_projects': {'key': 'typeProperties.additionalProjects', 'type': 'object'},
        'request_google_drive_scope': {'key': 'typeProperties.requestGoogleDriveScope', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'refresh_token': {'key': 'typeProperties.refreshToken', 'type': 'SecretBase'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'email': {'key': 'typeProperties.email', 'type': 'object'},
        'key_file_path': {'key': 'typeProperties.keyFilePath', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        project: object,
        authentication_type: Union[str, "GoogleBigQueryAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        additional_projects: Optional[object] = None,
        request_google_drive_scope: Optional[object] = None,
        refresh_token: Optional["SecretBase"] = None,
        client_id: Optional[object] = None,
        client_secret: Optional["SecretBase"] = None,
        email: Optional[object] = None,
        key_file_path: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        use_system_trust_store: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(GoogleBigQueryLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'GoogleBigQuery'
        self.project = project
        self.additional_projects = additional_projects
        self.request_google_drive_scope = request_google_drive_scope
        self.authentication_type = authentication_type
        self.refresh_token = refresh_token
        self.client_id = client_id
        self.client_secret = client_secret
        self.email = email
        self.key_file_path = key_file_path
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.encrypted_credential = encrypted_credential


class GoogleBigQueryObjectDataset(Dataset):
    """Google BigQuery service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using database + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Google BigQuery. Type: string (or Expression with
     resultType string).
    :type table: object
    :param dataset: The database name of the Google BigQuery. Type: string (or Expression with
     resultType string).
    :type dataset: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        dataset: Optional[object] = None,
        **kwargs
    ):
        super(GoogleBigQueryObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'GoogleBigQueryObject'
        self.table_name = table_name
        self.table = table
        self.dataset = dataset


class GoogleCloudStorageLinkedService(LinkedService):
    """Linked service for Google Cloud Storage.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param access_key_id: The access key identifier of the Google Cloud Storage Identity and Access
     Management (IAM) user. Type: string (or Expression with resultType string).
    :type access_key_id: object
    :param secret_access_key: The secret access key of the Google Cloud Storage Identity and Access
     Management (IAM) user.
    :type secret_access_key: ~azure.synapse.artifacts.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the Google Cloud Storage
     Connector. This is an optional property; change it only if you want to try a different service
     endpoint or want to switch between https and http. Type: string (or Expression with resultType
     string).
    :type service_url: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        access_key_id: Optional[object] = None,
        secret_access_key: Optional["SecretBase"] = None,
        service_url: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(GoogleCloudStorageLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'GoogleCloudStorage'
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.service_url = service_url
        self.encrypted_credential = encrypted_credential


class GreenplumLinkedService(LinkedService):
    """Greenplum Database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(GreenplumLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Greenplum'
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class GreenplumTableDataset(Dataset):
    """Greenplum Database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of Greenplum. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of Greenplum. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(GreenplumTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'GreenplumTable'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class HBaseLinkedService(LinkedService):
    """HBase server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The IP address or host name of the HBase server. (i.e. 192.168.222.160).
    :type host: object
    :param port: The TCP port that the HBase instance uses to listen for client connections. The
     default value is 9090.
    :type port: object
    :param http_path: The partial URL corresponding to the HBase server. (i.e.
     /gateway/sandbox/hbase/version).
    :type http_path: object
    :param authentication_type: Required. The authentication mechanism to use to connect to the
     HBase server. Possible values include: "Anonymous", "Basic".
    :type authentication_type: str or ~azure.synapse.artifacts.models.HBaseAuthenticationType
    :param username: The user name used to connect to the HBase instance.
    :type username: object
    :param password: The password corresponding to the user name.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'http_path': {'key': 'typeProperties.httpPath', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        authentication_type: Union[str, "HBaseAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        http_path: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        enable_ssl: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        allow_host_name_cn_mismatch: Optional[object] = None,
        allow_self_signed_server_cert: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(HBaseLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'HBase'
        self.host = host
        self.port = port
        self.http_path = http_path
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.enable_ssl = enable_ssl
        self.trusted_cert_path = trusted_cert_path
        self.allow_host_name_cn_mismatch = allow_host_name_cn_mismatch
        self.allow_self_signed_server_cert = allow_self_signed_server_cert
        self.encrypted_credential = encrypted_credential


class HBaseObjectDataset(Dataset):
    """HBase server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(HBaseObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'HBaseObject'
        self.table_name = table_name


class HdfsLinkedService(LinkedService):
    """Hadoop Distributed File System (HDFS) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The URL of the HDFS service endpoint, e.g.
     http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with resultType string).
    :type url: object
    :param authentication_type: Type of authentication used to connect to the HDFS. Possible values
     are: Anonymous and Windows. Type: string (or Expression with resultType string).
    :type authentication_type: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param user_name: User name for Windows authentication. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password for Windows authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
    }

    def __init__(
        self,
        *,
        url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        **kwargs
    ):
        super(HdfsLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Hdfs'
        self.url = url
        self.authentication_type = authentication_type
        self.encrypted_credential = encrypted_credential
        self.user_name = user_name
        self.password = password


class HDInsightHiveActivity(ExecutionActivity):
    """HDInsight Hive activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.synapse.artifacts.models.HDInsightActivityDebugInfoOption
    :param script_path: Script path. Type: string (or Expression with resultType string).
    :type script_path: object
    :param script_linked_service: Script linked service reference.
    :type script_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param defines: Allows user to specify defines for Hive job request.
    :type defines: dict[str, object]
    :param variables: User specified arguments under hivevar namespace.
    :type variables: list[object]
    :param query_timeout: Query timeout value (in minutes).  Effective when the HDInsight cluster
     is with ESP (Enterprise Security Package).
    :type query_timeout: int
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
        'variables': {'key': 'typeProperties.variables', 'type': '[object]'},
        'query_timeout': {'key': 'typeProperties.queryTimeout', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        storage_linked_services: Optional[List["LinkedServiceReference"]] = None,
        arguments: Optional[List[object]] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        script_path: Optional[object] = None,
        script_linked_service: Optional["LinkedServiceReference"] = None,
        defines: Optional[Dict[str, object]] = None,
        variables: Optional[List[object]] = None,
        query_timeout: Optional[int] = None,
        **kwargs
    ):
        super(HDInsightHiveActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'HDInsightHive'
        self.storage_linked_services = storage_linked_services
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.script_path = script_path
        self.script_linked_service = script_linked_service
        self.defines = defines
        self.variables = variables
        self.query_timeout = query_timeout


class HDInsightLinkedService(LinkedService):
    """HDInsight linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param cluster_uri: Required. HDInsight cluster URI. Type: string (or Expression with
     resultType string).
    :type cluster_uri: object
    :param user_name: HDInsight cluster user name. Type: string (or Expression with resultType
     string).
    :type user_name: object
    :param password: HDInsight cluster password.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param linked_service_name: The Azure Storage linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param hcatalog_linked_service_name: A reference to the Azure SQL linked service that points to
     the HCatalog database.
    :type hcatalog_linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param is_esp_enabled: Specify if the HDInsight is created with ESP (Enterprise Security
     Package). Type: Boolean.
    :type is_esp_enabled: object
    :param file_system: Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2.
     Type: string (or Expression with resultType string).
    :type file_system: object
    """

    _validation = {
        'type': {'required': True},
        'cluster_uri': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'cluster_uri': {'key': 'typeProperties.clusterUri', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'hcatalog_linked_service_name': {'key': 'typeProperties.hcatalogLinkedServiceName', 'type': 'LinkedServiceReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'is_esp_enabled': {'key': 'typeProperties.isEspEnabled', 'type': 'object'},
        'file_system': {'key': 'typeProperties.fileSystem', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        cluster_uri: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        hcatalog_linked_service_name: Optional["LinkedServiceReference"] = None,
        encrypted_credential: Optional[object] = None,
        is_esp_enabled: Optional[object] = None,
        file_system: Optional[object] = None,
        **kwargs
    ):
        super(HDInsightLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'HDInsight'
        self.cluster_uri = cluster_uri
        self.user_name = user_name
        self.password = password
        self.linked_service_name = linked_service_name
        self.hcatalog_linked_service_name = hcatalog_linked_service_name
        self.encrypted_credential = encrypted_credential
        self.is_esp_enabled = is_esp_enabled
        self.file_system = file_system


class HDInsightMapReduceActivity(ExecutionActivity):
    """HDInsight MapReduce activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.synapse.artifacts.models.HDInsightActivityDebugInfoOption
    :param class_name: Required. Class name. Type: string (or Expression with resultType string).
    :type class_name: object
    :param jar_file_path: Required. Jar path. Type: string (or Expression with resultType string).
    :type jar_file_path: object
    :param jar_linked_service: Jar linked service reference.
    :type jar_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param jar_libs: Jar libs.
    :type jar_libs: list[object]
    :param defines: Allows user to specify defines for the MapReduce job request.
    :type defines: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'class_name': {'required': True},
        'jar_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'class_name': {'key': 'typeProperties.className', 'type': 'object'},
        'jar_file_path': {'key': 'typeProperties.jarFilePath', 'type': 'object'},
        'jar_linked_service': {'key': 'typeProperties.jarLinkedService', 'type': 'LinkedServiceReference'},
        'jar_libs': {'key': 'typeProperties.jarLibs', 'type': '[object]'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: str,
        class_name: object,
        jar_file_path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        storage_linked_services: Optional[List["LinkedServiceReference"]] = None,
        arguments: Optional[List[object]] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        jar_linked_service: Optional["LinkedServiceReference"] = None,
        jar_libs: Optional[List[object]] = None,
        defines: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(HDInsightMapReduceActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'HDInsightMapReduce'
        self.storage_linked_services = storage_linked_services
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.class_name = class_name
        self.jar_file_path = jar_file_path
        self.jar_linked_service = jar_linked_service
        self.jar_libs = jar_libs
        self.defines = defines


class HDInsightOnDemandLinkedService(LinkedService):
    """HDInsight ondemand linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param cluster_size: Required. Number of worker/data nodes in the cluster. Suggestion value: 4.
     Type: string (or Expression with resultType string).
    :type cluster_size: object
    :param time_to_live: Required. The allowed idle time for the on-demand HDInsight cluster.
     Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity
     run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string
     (or Expression with resultType string).
    :type time_to_live: object
    :param version: Required. Version of the HDInsight cluster.  Type: string (or Expression with
     resultType string).
    :type version: object
    :param linked_service_name: Required. Azure Storage linked service to be used by the on-demand
     cluster for storing and processing data.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param host_subscription_id: Required. The customer’s subscription to host the cluster. Type:
     string (or Expression with resultType string).
    :type host_subscription_id: object
    :param service_principal_id: The service principal id for the hostSubscriptionId. Type: string
     (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key for the service principal id.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: Required. The Tenant id/name to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param cluster_resource_group: Required. The resource group where the cluster belongs. Type:
     string (or Expression with resultType string).
    :type cluster_resource_group: object
    :param cluster_name_prefix: The prefix of cluster name, postfix will be distinct with
     timestamp. Type: string (or Expression with resultType string).
    :type cluster_name_prefix: object
    :param cluster_user_name: The username to access the cluster. Type: string (or Expression with
     resultType string).
    :type cluster_user_name: object
    :param cluster_password: The password to access the cluster.
    :type cluster_password: ~azure.synapse.artifacts.models.SecretBase
    :param cluster_ssh_user_name: The username to SSH remotely connect to cluster’s node (for
     Linux). Type: string (or Expression with resultType string).
    :type cluster_ssh_user_name: object
    :param cluster_ssh_password: The password to SSH remotely connect cluster’s node (for Linux).
    :type cluster_ssh_password: ~azure.synapse.artifacts.models.SecretBase
    :param additional_linked_service_names: Specifies additional storage accounts for the HDInsight
     linked service so that the Data Factory service can register them on your behalf.
    :type additional_linked_service_names:
     list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param hcatalog_linked_service_name: The name of Azure SQL linked service that point to the
     HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database
     as the metastore.
    :type hcatalog_linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param cluster_type: The cluster type. Type: string (or Expression with resultType string).
    :type cluster_type: object
    :param spark_version: The version of spark if the cluster type is 'spark'. Type: string (or
     Expression with resultType string).
    :type spark_version: object
    :param core_configuration: Specifies the core configuration parameters (as in core-site.xml)
     for the HDInsight cluster to be created.
    :type core_configuration: object
    :param h_base_configuration: Specifies the HBase configuration parameters (hbase-site.xml) for
     the HDInsight cluster.
    :type h_base_configuration: object
    :param hdfs_configuration: Specifies the HDFS configuration parameters (hdfs-site.xml) for the
     HDInsight cluster.
    :type hdfs_configuration: object
    :param hive_configuration: Specifies the hive configuration parameters (hive-site.xml) for the
     HDInsight cluster.
    :type hive_configuration: object
    :param map_reduce_configuration: Specifies the MapReduce configuration parameters (mapred-
     site.xml) for the HDInsight cluster.
    :type map_reduce_configuration: object
    :param oozie_configuration: Specifies the Oozie configuration parameters (oozie-site.xml) for
     the HDInsight cluster.
    :type oozie_configuration: object
    :param storm_configuration: Specifies the Storm configuration parameters (storm-site.xml) for
     the HDInsight cluster.
    :type storm_configuration: object
    :param yarn_configuration: Specifies the Yarn configuration parameters (yarn-site.xml) for the
     HDInsight cluster.
    :type yarn_configuration: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param head_node_size: Specifies the size of the head node for the HDInsight cluster.
    :type head_node_size: object
    :param data_node_size: Specifies the size of the data node for the HDInsight cluster.
    :type data_node_size: object
    :param zookeeper_node_size: Specifies the size of the Zoo Keeper node for the HDInsight
     cluster.
    :type zookeeper_node_size: object
    :param script_actions: Custom script actions to run on HDI ondemand cluster once it's up.
     Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-
     cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-
     us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
    :type script_actions: list[~azure.synapse.artifacts.models.ScriptAction]
    :param virtual_network_id: The ARM resource ID for the vNet to which the cluster should be
     joined after creation. Type: string (or Expression with resultType string).
    :type virtual_network_id: object
    :param subnet_name: The ARM resource ID for the subnet in the vNet. If virtualNetworkId was
     specified, then this property is required. Type: string (or Expression with resultType string).
    :type subnet_name: object
    """

    _validation = {
        'type': {'required': True},
        'cluster_size': {'required': True},
        'time_to_live': {'required': True},
        'version': {'required': True},
        'linked_service_name': {'required': True},
        'host_subscription_id': {'required': True},
        'tenant': {'required': True},
        'cluster_resource_group': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'cluster_size': {'key': 'typeProperties.clusterSize', 'type': 'object'},
        'time_to_live': {'key': 'typeProperties.timeToLive', 'type': 'object'},
        'version': {'key': 'typeProperties.version', 'type': 'object'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'host_subscription_id': {'key': 'typeProperties.hostSubscriptionId', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'cluster_resource_group': {'key': 'typeProperties.clusterResourceGroup', 'type': 'object'},
        'cluster_name_prefix': {'key': 'typeProperties.clusterNamePrefix', 'type': 'object'},
        'cluster_user_name': {'key': 'typeProperties.clusterUserName', 'type': 'object'},
        'cluster_password': {'key': 'typeProperties.clusterPassword', 'type': 'SecretBase'},
        'cluster_ssh_user_name': {'key': 'typeProperties.clusterSshUserName', 'type': 'object'},
        'cluster_ssh_password': {'key': 'typeProperties.clusterSshPassword', 'type': 'SecretBase'},
        'additional_linked_service_names': {'key': 'typeProperties.additionalLinkedServiceNames', 'type': '[LinkedServiceReference]'},
        'hcatalog_linked_service_name': {'key': 'typeProperties.hcatalogLinkedServiceName', 'type': 'LinkedServiceReference'},
        'cluster_type': {'key': 'typeProperties.clusterType', 'type': 'object'},
        'spark_version': {'key': 'typeProperties.sparkVersion', 'type': 'object'},
        'core_configuration': {'key': 'typeProperties.coreConfiguration', 'type': 'object'},
        'h_base_configuration': {'key': 'typeProperties.hBaseConfiguration', 'type': 'object'},
        'hdfs_configuration': {'key': 'typeProperties.hdfsConfiguration', 'type': 'object'},
        'hive_configuration': {'key': 'typeProperties.hiveConfiguration', 'type': 'object'},
        'map_reduce_configuration': {'key': 'typeProperties.mapReduceConfiguration', 'type': 'object'},
        'oozie_configuration': {'key': 'typeProperties.oozieConfiguration', 'type': 'object'},
        'storm_configuration': {'key': 'typeProperties.stormConfiguration', 'type': 'object'},
        'yarn_configuration': {'key': 'typeProperties.yarnConfiguration', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'head_node_size': {'key': 'typeProperties.headNodeSize', 'type': 'object'},
        'data_node_size': {'key': 'typeProperties.dataNodeSize', 'type': 'object'},
        'zookeeper_node_size': {'key': 'typeProperties.zookeeperNodeSize', 'type': 'object'},
        'script_actions': {'key': 'typeProperties.scriptActions', 'type': '[ScriptAction]'},
        'virtual_network_id': {'key': 'typeProperties.virtualNetworkId', 'type': 'object'},
        'subnet_name': {'key': 'typeProperties.subnetName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        cluster_size: object,
        time_to_live: object,
        version: object,
        linked_service_name: "LinkedServiceReference",
        host_subscription_id: object,
        tenant: object,
        cluster_resource_group: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        cluster_name_prefix: Optional[object] = None,
        cluster_user_name: Optional[object] = None,
        cluster_password: Optional["SecretBase"] = None,
        cluster_ssh_user_name: Optional[object] = None,
        cluster_ssh_password: Optional["SecretBase"] = None,
        additional_linked_service_names: Optional[List["LinkedServiceReference"]] = None,
        hcatalog_linked_service_name: Optional["LinkedServiceReference"] = None,
        cluster_type: Optional[object] = None,
        spark_version: Optional[object] = None,
        core_configuration: Optional[object] = None,
        h_base_configuration: Optional[object] = None,
        hdfs_configuration: Optional[object] = None,
        hive_configuration: Optional[object] = None,
        map_reduce_configuration: Optional[object] = None,
        oozie_configuration: Optional[object] = None,
        storm_configuration: Optional[object] = None,
        yarn_configuration: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        head_node_size: Optional[object] = None,
        data_node_size: Optional[object] = None,
        zookeeper_node_size: Optional[object] = None,
        script_actions: Optional[List["ScriptAction"]] = None,
        virtual_network_id: Optional[object] = None,
        subnet_name: Optional[object] = None,
        **kwargs
    ):
        super(HDInsightOnDemandLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'HDInsightOnDemand'
        self.cluster_size = cluster_size
        self.time_to_live = time_to_live
        self.version = version
        self.linked_service_name = linked_service_name
        self.host_subscription_id = host_subscription_id
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.cluster_resource_group = cluster_resource_group
        self.cluster_name_prefix = cluster_name_prefix
        self.cluster_user_name = cluster_user_name
        self.cluster_password = cluster_password
        self.cluster_ssh_user_name = cluster_ssh_user_name
        self.cluster_ssh_password = cluster_ssh_password
        self.additional_linked_service_names = additional_linked_service_names
        self.hcatalog_linked_service_name = hcatalog_linked_service_name
        self.cluster_type = cluster_type
        self.spark_version = spark_version
        self.core_configuration = core_configuration
        self.h_base_configuration = h_base_configuration
        self.hdfs_configuration = hdfs_configuration
        self.hive_configuration = hive_configuration
        self.map_reduce_configuration = map_reduce_configuration
        self.oozie_configuration = oozie_configuration
        self.storm_configuration = storm_configuration
        self.yarn_configuration = yarn_configuration
        self.encrypted_credential = encrypted_credential
        self.head_node_size = head_node_size
        self.data_node_size = data_node_size
        self.zookeeper_node_size = zookeeper_node_size
        self.script_actions = script_actions
        self.virtual_network_id = virtual_network_id
        self.subnet_name = subnet_name


class HDInsightPigActivity(ExecutionActivity):
    """HDInsight Pig activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity. Type: array (or Expression
     with resultType array).
    :type arguments: object
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.synapse.artifacts.models.HDInsightActivityDebugInfoOption
    :param script_path: Script path. Type: string (or Expression with resultType string).
    :type script_path: object
    :param script_linked_service: Script linked service reference.
    :type script_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param defines: Allows user to specify defines for Pig job request.
    :type defines: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': 'object'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        storage_linked_services: Optional[List["LinkedServiceReference"]] = None,
        arguments: Optional[object] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        script_path: Optional[object] = None,
        script_linked_service: Optional["LinkedServiceReference"] = None,
        defines: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(HDInsightPigActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'HDInsightPig'
        self.storage_linked_services = storage_linked_services
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.script_path = script_path
        self.script_linked_service = script_linked_service
        self.defines = defines


class HDInsightSparkActivity(ExecutionActivity):
    """HDInsight Spark activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param root_path: Required. The root path in 'sparkJobLinkedService' for all the job’s files.
     Type: string (or Expression with resultType string).
    :type root_path: object
    :param entry_file_path: Required. The relative path to the root folder of the code/package to
     be executed. Type: string (or Expression with resultType string).
    :type entry_file_path: object
    :param arguments: The user-specified arguments to HDInsightSparkActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.synapse.artifacts.models.HDInsightActivityDebugInfoOption
    :param spark_job_linked_service: The storage linked service for uploading the entry file and
     dependencies, and for receiving logs.
    :type spark_job_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param class_name: The application's Java/Spark main class.
    :type class_name: str
    :param proxy_user: The user to impersonate that will execute the job. Type: string (or
     Expression with resultType string).
    :type proxy_user: object
    :param spark_config: Spark configuration property.
    :type spark_config: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'root_path': {'required': True},
        'entry_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'root_path': {'key': 'typeProperties.rootPath', 'type': 'object'},
        'entry_file_path': {'key': 'typeProperties.entryFilePath', 'type': 'object'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'spark_job_linked_service': {'key': 'typeProperties.sparkJobLinkedService', 'type': 'LinkedServiceReference'},
        'class_name': {'key': 'typeProperties.className', 'type': 'str'},
        'proxy_user': {'key': 'typeProperties.proxyUser', 'type': 'object'},
        'spark_config': {'key': 'typeProperties.sparkConfig', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: str,
        root_path: object,
        entry_file_path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        arguments: Optional[List[object]] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        spark_job_linked_service: Optional["LinkedServiceReference"] = None,
        class_name: Optional[str] = None,
        proxy_user: Optional[object] = None,
        spark_config: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(HDInsightSparkActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'HDInsightSpark'
        self.root_path = root_path
        self.entry_file_path = entry_file_path
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.spark_job_linked_service = spark_job_linked_service
        self.class_name = class_name
        self.proxy_user = proxy_user
        self.spark_config = spark_config


class HDInsightStreamingActivity(ExecutionActivity):
    """HDInsight streaming activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.synapse.artifacts.models.HDInsightActivityDebugInfoOption
    :param mapper: Required. Mapper executable name. Type: string (or Expression with resultType
     string).
    :type mapper: object
    :param reducer: Required. Reducer executable name. Type: string (or Expression with resultType
     string).
    :type reducer: object
    :param input: Required. Input blob path. Type: string (or Expression with resultType string).
    :type input: object
    :param output: Required. Output blob path. Type: string (or Expression with resultType string).
    :type output: object
    :param file_paths: Required. Paths to streaming job files. Can be directories.
    :type file_paths: list[object]
    :param file_linked_service: Linked service reference where the files are located.
    :type file_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param combiner: Combiner executable name. Type: string (or Expression with resultType string).
    :type combiner: object
    :param command_environment: Command line environment values.
    :type command_environment: list[object]
    :param defines: Allows user to specify defines for streaming job request.
    :type defines: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'mapper': {'required': True},
        'reducer': {'required': True},
        'input': {'required': True},
        'output': {'required': True},
        'file_paths': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'mapper': {'key': 'typeProperties.mapper', 'type': 'object'},
        'reducer': {'key': 'typeProperties.reducer', 'type': 'object'},
        'input': {'key': 'typeProperties.input', 'type': 'object'},
        'output': {'key': 'typeProperties.output', 'type': 'object'},
        'file_paths': {'key': 'typeProperties.filePaths', 'type': '[object]'},
        'file_linked_service': {'key': 'typeProperties.fileLinkedService', 'type': 'LinkedServiceReference'},
        'combiner': {'key': 'typeProperties.combiner', 'type': 'object'},
        'command_environment': {'key': 'typeProperties.commandEnvironment', 'type': '[object]'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: str,
        mapper: object,
        reducer: object,
        input: object,
        output: object,
        file_paths: List[object],
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        storage_linked_services: Optional[List["LinkedServiceReference"]] = None,
        arguments: Optional[List[object]] = None,
        get_debug_info: Optional[Union[str, "HDInsightActivityDebugInfoOption"]] = None,
        file_linked_service: Optional["LinkedServiceReference"] = None,
        combiner: Optional[object] = None,
        command_environment: Optional[List[object]] = None,
        defines: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(HDInsightStreamingActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'HDInsightStreaming'
        self.storage_linked_services = storage_linked_services
        self.arguments = arguments
        self.get_debug_info = get_debug_info
        self.mapper = mapper
        self.reducer = reducer
        self.input = input
        self.output = output
        self.file_paths = file_paths
        self.file_linked_service = file_linked_service
        self.combiner = combiner
        self.command_environment = command_environment
        self.defines = defines


class HiveLinkedService(LinkedService):
    """Hive Server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. IP address or host name of the Hive server, separated by ';' for
     multiple hosts (only when serviceDiscoveryMode is enable).
    :type host: object
    :param port: The TCP port that the Hive server uses to listen for client connections.
    :type port: object
    :param server_type: The type of Hive server. Possible values include: "HiveServer1",
     "HiveServer2", "HiveThriftServer".
    :type server_type: str or ~azure.synapse.artifacts.models.HiveServerType
    :param thrift_transport_protocol: The transport protocol to use in the Thrift layer. Possible
     values include: "Binary", "SASL", "HTTP ".
    :type thrift_transport_protocol: str or
     ~azure.synapse.artifacts.models.HiveThriftTransportProtocol
    :param authentication_type: Required. The authentication method used to access the Hive server.
     Possible values include: "Anonymous", "Username", "UsernameAndPassword",
     "WindowsAzureHDInsightService".
    :type authentication_type: str or ~azure.synapse.artifacts.models.HiveAuthenticationType
    :param service_discovery_mode: true to indicate using the ZooKeeper service, false not.
    :type service_discovery_mode: object
    :param zoo_keeper_name_space: The namespace on ZooKeeper under which Hive Server 2 nodes are
     added.
    :type zoo_keeper_name_space: object
    :param use_native_query: Specifies whether the driver uses native HiveQL queries,or converts
     them into an equivalent form in HiveQL.
    :type use_native_query: object
    :param username: The user name that you use to access Hive Server.
    :type username: object
    :param password: The password corresponding to the user name that you provided in the Username
     field.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param http_path: The partial URL corresponding to the Hive server.
    :type http_path: object
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'server_type': {'key': 'typeProperties.serverType', 'type': 'str'},
        'thrift_transport_protocol': {'key': 'typeProperties.thriftTransportProtocol', 'type': 'str'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'service_discovery_mode': {'key': 'typeProperties.serviceDiscoveryMode', 'type': 'object'},
        'zoo_keeper_name_space': {'key': 'typeProperties.zooKeeperNameSpace', 'type': 'object'},
        'use_native_query': {'key': 'typeProperties.useNativeQuery', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'http_path': {'key': 'typeProperties.httpPath', 'type': 'object'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        authentication_type: Union[str, "HiveAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        server_type: Optional[Union[str, "HiveServerType"]] = None,
        thrift_transport_protocol: Optional[Union[str, "HiveThriftTransportProtocol"]] = None,
        service_discovery_mode: Optional[object] = None,
        zoo_keeper_name_space: Optional[object] = None,
        use_native_query: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        http_path: Optional[object] = None,
        enable_ssl: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        use_system_trust_store: Optional[object] = None,
        allow_host_name_cn_mismatch: Optional[object] = None,
        allow_self_signed_server_cert: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(HiveLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Hive'
        self.host = host
        self.port = port
        self.server_type = server_type
        self.thrift_transport_protocol = thrift_transport_protocol
        self.authentication_type = authentication_type
        self.service_discovery_mode = service_discovery_mode
        self.zoo_keeper_name_space = zoo_keeper_name_space
        self.use_native_query = use_native_query
        self.username = username
        self.password = password
        self.http_path = http_path
        self.enable_ssl = enable_ssl
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.allow_host_name_cn_mismatch = allow_host_name_cn_mismatch
        self.allow_self_signed_server_cert = allow_self_signed_server_cert
        self.encrypted_credential = encrypted_credential


class HiveObjectDataset(Dataset):
    """Hive Server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Hive. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Hive. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(HiveObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'HiveObject'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class HttpLinkedService(LinkedService):
    """Linked service for an HTTP source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The base URL of the HTTP endpoint, e.g. http://www.microsoft.com. Type:
     string (or Expression with resultType string).
    :type url: object
    :param authentication_type: The authentication type to be used to connect to the HTTP server.
     Possible values include: "Basic", "Anonymous", "Digest", "Windows", "ClientCertificate".
    :type authentication_type: str or ~azure.synapse.artifacts.models.HttpAuthenticationType
    :param user_name: User name for Basic, Digest, or Windows authentication. Type: string (or
     Expression with resultType string).
    :type user_name: object
    :param password: Password for Basic, Digest, Windows, or ClientCertificate with
     EmbeddedCertData authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param embedded_cert_data: Base64 encoded certificate data for ClientCertificate
     authentication. For on-premises copy with ClientCertificate authentication, either
     CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression
     with resultType string).
    :type embedded_cert_data: object
    :param cert_thumbprint: Thumbprint of certificate for ClientCertificate authentication. Only
     valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either
     CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression
     with resultType string).
    :type cert_thumbprint: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param enable_server_certificate_validation: If true, validate the HTTPS server SSL
     certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
    :type enable_server_certificate_validation: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'embedded_cert_data': {'key': 'typeProperties.embeddedCertData', 'type': 'object'},
        'cert_thumbprint': {'key': 'typeProperties.certThumbprint', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'enable_server_certificate_validation': {'key': 'typeProperties.enableServerCertificateValidation', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[Union[str, "HttpAuthenticationType"]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        embedded_cert_data: Optional[object] = None,
        cert_thumbprint: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        enable_server_certificate_validation: Optional[object] = None,
        **kwargs
    ):
        super(HttpLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'HttpServer'
        self.url = url
        self.authentication_type = authentication_type
        self.user_name = user_name
        self.password = password
        self.embedded_cert_data = embedded_cert_data
        self.cert_thumbprint = cert_thumbprint
        self.encrypted_credential = encrypted_credential
        self.enable_server_certificate_validation = enable_server_certificate_validation


class HubspotLinkedService(LinkedService):
    """Hubspot Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param client_id: Required. The client ID associated with your Hubspot application.
    :type client_id: object
    :param client_secret: The client secret associated with your Hubspot application.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param access_token: The access token obtained when initially authenticating your OAuth
     integration.
    :type access_token: ~azure.synapse.artifacts.models.SecretBase
    :param refresh_token: The refresh token obtained when initially authenticating your OAuth
     integration.
    :type refresh_token: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'refresh_token': {'key': 'typeProperties.refreshToken', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        client_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        client_secret: Optional["SecretBase"] = None,
        access_token: Optional["SecretBase"] = None,
        refresh_token: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(HubspotLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Hubspot'
        self.client_id = client_id
        self.client_secret = client_secret
        self.access_token = access_token
        self.refresh_token = refresh_token
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class HubspotObjectDataset(Dataset):
    """Hubspot Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(HubspotObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'HubspotObject'
        self.table_name = table_name


class IfConditionActivity(Activity):
    """This activity evaluates a boolean expression and executes either the activities under the ifTrueActivities property or the ifFalseActivities property depending on the result of the expression.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param expression: Required. An expression that would evaluate to Boolean. This is used to
     determine the block of activities (ifTrueActivities or ifFalseActivities) that will be
     executed.
    :type expression: ~azure.synapse.artifacts.models.Expression
    :param if_true_activities: List of activities to execute if expression is evaluated to true.
     This is an optional property and if not provided, the activity will exit without any action.
    :type if_true_activities: list[~azure.synapse.artifacts.models.Activity]
    :param if_false_activities: List of activities to execute if expression is evaluated to false.
     This is an optional property and if not provided, the activity will exit without any action.
    :type if_false_activities: list[~azure.synapse.artifacts.models.Activity]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'expression': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'expression': {'key': 'typeProperties.expression', 'type': 'Expression'},
        'if_true_activities': {'key': 'typeProperties.ifTrueActivities', 'type': '[Activity]'},
        'if_false_activities': {'key': 'typeProperties.ifFalseActivities', 'type': '[Activity]'},
    }

    def __init__(
        self,
        *,
        name: str,
        expression: "Expression",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        if_true_activities: Optional[List["Activity"]] = None,
        if_false_activities: Optional[List["Activity"]] = None,
        **kwargs
    ):
        super(IfConditionActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type: str = 'IfCondition'
        self.expression = expression
        self.if_true_activities = if_true_activities
        self.if_false_activities = if_false_activities


class ImpalaLinkedService(LinkedService):
    """Impala server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The IP address or host name of the Impala server. (i.e.
     192.168.222.160).
    :type host: object
    :param port: The TCP port that the Impala server uses to listen for client connections. The
     default value is 21050.
    :type port: object
    :param authentication_type: Required. The authentication type to use. Possible values include:
     "Anonymous", "SASLUsername", "UsernameAndPassword".
    :type authentication_type: str or ~azure.synapse.artifacts.models.ImpalaAuthenticationType
    :param username: The user name used to access the Impala server. The default value is anonymous
     when using SASLUsername.
    :type username: object
    :param password: The password corresponding to the user name when using UsernameAndPassword.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        authentication_type: Union[str, "ImpalaAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        enable_ssl: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        use_system_trust_store: Optional[object] = None,
        allow_host_name_cn_mismatch: Optional[object] = None,
        allow_self_signed_server_cert: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(ImpalaLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Impala'
        self.host = host
        self.port = port
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.enable_ssl = enable_ssl
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.allow_host_name_cn_mismatch = allow_host_name_cn_mismatch
        self.allow_self_signed_server_cert = allow_self_signed_server_cert
        self.encrypted_credential = encrypted_credential


class ImpalaObjectDataset(Dataset):
    """Impala server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Impala. Type: string (or Expression with resultType
     string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Impala. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(ImpalaObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'ImpalaObject'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class InformixLinkedService(LinkedService):
    """Informix linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The non-access credential portion of the connection string
     as well as an optional encrypted credential. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param authentication_type: Type of authentication used to connect to the Informix as ODBC data
     store. Possible values are: Anonymous and Basic. Type: string (or Expression with resultType
     string).
    :type authentication_type: object
    :param credential: The access credential portion of the connection string specified in driver-
     specific property-value format.
    :type credential: ~azure.synapse.artifacts.models.SecretBase
    :param user_name: User name for Basic authentication. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password for Basic authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'SecretBase'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[object] = None,
        credential: Optional["SecretBase"] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(InformixLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Informix'
        self.connection_string = connection_string
        self.authentication_type = authentication_type
        self.credential = credential
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential


class InformixTableDataset(Dataset):
    """The Informix table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The Informix table name. Type: string (or Expression with resultType
     string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(InformixTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'InformixTable'
        self.table_name = table_name


class IntegrationRuntimeReference(msrest.serialization.Model):
    """Integration runtime reference type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Type of integration runtime. Default value:
     "IntegrationRuntimeReference".
    :vartype type: str
    :param reference_name: Required. Reference integration runtime name.
    :type reference_name: str
    :param parameters: Arguments for integration runtime.
    :type parameters: dict[str, object]
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    type = "IntegrationRuntimeReference"

    def __init__(
        self,
        *,
        reference_name: str,
        parameters: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(IntegrationRuntimeReference, self).__init__(**kwargs)
        self.reference_name = reference_name
        self.parameters = parameters


class JiraLinkedService(LinkedService):
    """Jira Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The IP address or host name of the Jira service. (e.g.
     jira.example.com).
    :type host: object
    :param port: The TCP port that the Jira server uses to listen for client connections. The
     default value is 443 if connecting through HTTPS, or 8080 if connecting through HTTP.
    :type port: object
    :param username: Required. The user name that you use to access Jira Service.
    :type username: object
    :param password: The password corresponding to the user name that you provided in the username
     field.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        username: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(JiraLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Jira'
        self.host = host
        self.port = port
        self.username = username
        self.password = password
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class JiraObjectDataset(Dataset):
    """Jira Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(JiraObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'JiraObject'
        self.table_name = table_name


class JsonDataset(Dataset):
    """Json dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the json data storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param encoding_name: The code page name of the preferred encoding. If not specified, the
     default value is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column
     of the table in the following link to set supported values:
     https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with
     resultType string).
    :type encoding_name: object
    :param compression: The data compression method used for the json dataset.
    :type compression: ~azure.synapse.artifacts.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'encoding_name': {'key': 'typeProperties.encodingName', 'type': 'object'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        encoding_name: Optional[object] = None,
        compression: Optional["DatasetCompression"] = None,
        **kwargs
    ):
        super(JsonDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'Json'
        self.location = location
        self.encoding_name = encoding_name
        self.compression = compression


class LinkedServiceDebugResource(SubResourceDebugResource):
    """Linked service debug resource.

    All required parameters must be populated in order to send to Azure.

    :param name: The resource name.
    :type name: str
    :param properties: Required. Properties of linked service.
    :type properties: ~azure.synapse.artifacts.models.LinkedService
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'LinkedService'},
    }

    def __init__(
        self,
        *,
        properties: "LinkedService",
        name: Optional[str] = None,
        **kwargs
    ):
        super(LinkedServiceDebugResource, self).__init__(name=name, **kwargs)
        self.properties = properties


class LinkedServiceListResponse(msrest.serialization.Model):
    """A list of linked service resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of linked services.
    :type value: list[~azure.synapse.artifacts.models.LinkedServiceResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LinkedServiceResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["LinkedServiceResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(LinkedServiceListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LinkedServiceReference(msrest.serialization.Model):
    """Linked service reference type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Linked service reference type. Default value: "LinkedServiceReference".
    :vartype type: str
    :param reference_name: Required. Reference LinkedService name.
    :type reference_name: str
    :param parameters: Arguments for LinkedService.
    :type parameters: dict[str, object]
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    type = "LinkedServiceReference"

    def __init__(
        self,
        *,
        reference_name: str,
        parameters: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(LinkedServiceReference, self).__init__(**kwargs)
        self.reference_name = reference_name
        self.parameters = parameters


class LinkedServiceResource(SubResource):
    """Linked service resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Properties of linked service.
    :type properties: ~azure.synapse.artifacts.models.LinkedService
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'LinkedService'},
    }

    def __init__(
        self,
        *,
        properties: "LinkedService",
        **kwargs
    ):
        super(LinkedServiceResource, self).__init__(**kwargs)
        self.properties = properties


class LogStorageSettings(msrest.serialization.Model):
    """Log storage settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param linked_service_name: Required. Log storage linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param path: The path to storage for storing detailed logs of activity execution. Type: string
     (or Expression with resultType string).
    :type path: object
    """

    _validation = {
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'path': {'key': 'path', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        path: Optional[object] = None,
        **kwargs
    ):
        super(LogStorageSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.linked_service_name = linked_service_name
        self.path = path


class LookupActivity(ExecutionActivity):
    """Lookup activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param source: Required. Dataset-specific source properties, same as copy activity source.
    :type source: ~azure.synapse.artifacts.models.CopySource
    :param dataset: Required. Lookup activity dataset reference.
    :type dataset: ~azure.synapse.artifacts.models.DatasetReference
    :param first_row_only: Whether to return first row or all rows. Default value is true. Type:
     boolean (or Expression with resultType boolean).
    :type first_row_only: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'source': {'required': True},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'source': {'key': 'typeProperties.source', 'type': 'CopySource'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
        'first_row_only': {'key': 'typeProperties.firstRowOnly', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        source: "CopySource",
        dataset: "DatasetReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        first_row_only: Optional[object] = None,
        **kwargs
    ):
        super(LookupActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'Lookup'
        self.source = source
        self.dataset = dataset
        self.first_row_only = first_row_only


class MagentoLinkedService(LinkedService):
    """Magento server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The URL of the Magento instance. (i.e. 192.168.222.110/magento3).
    :type host: object
    :param access_token: The access token from Magento.
    :type access_token: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        access_token: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(MagentoLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Magento'
        self.host = host
        self.access_token = access_token
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class MagentoObjectDataset(Dataset):
    """Magento server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(MagentoObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'MagentoObject'
        self.table_name = table_name


class MappingDataFlow(DataFlow):
    """Mapping data flow.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of data flow.Constant filled by server.
    :type type: str
    :param description: The description of the data flow.
    :type description: str
    :param annotations: List of tags that can be used for describing the data flow.
    :type annotations: list[object]
    :param folder: The folder that this data flow is in. If not specified, Data flow will appear at
     the root level.
    :type folder: ~azure.synapse.artifacts.models.DataFlowFolder
    :param sources: List of sources in data flow.
    :type sources: list[~azure.synapse.artifacts.models.DataFlowSource]
    :param sinks: List of sinks in data flow.
    :type sinks: list[~azure.synapse.artifacts.models.DataFlowSink]
    :param transformations: List of transformations in data flow.
    :type transformations: list[~azure.synapse.artifacts.models.Transformation]
    :param script: DataFlow script.
    :type script: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DataFlowFolder'},
        'sources': {'key': 'typeProperties.sources', 'type': '[DataFlowSource]'},
        'sinks': {'key': 'typeProperties.sinks', 'type': '[DataFlowSink]'},
        'transformations': {'key': 'typeProperties.transformations', 'type': '[Transformation]'},
        'script': {'key': 'typeProperties.script', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DataFlowFolder"] = None,
        sources: Optional[List["DataFlowSource"]] = None,
        sinks: Optional[List["DataFlowSink"]] = None,
        transformations: Optional[List["Transformation"]] = None,
        script: Optional[str] = None,
        **kwargs
    ):
        super(MappingDataFlow, self).__init__(description=description, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'MappingDataFlow'
        self.sources = sources
        self.sinks = sinks
        self.transformations = transformations
        self.script = script


class MariaDBLinkedService(LinkedService):
    """MariaDB server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(MariaDBLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'MariaDB'
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class MariaDBTableDataset(Dataset):
    """MariaDB server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(MariaDBTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'MariaDBTable'
        self.table_name = table_name


class MarketoLinkedService(LinkedService):
    """Marketo server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the Marketo server. (i.e. 123-ABC-321.mktorest.com).
    :type endpoint: object
    :param client_id: Required. The client Id of your Marketo service.
    :type client_id: object
    :param client_secret: The client secret of your Marketo service.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: object,
        client_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        client_secret: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(MarketoLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Marketo'
        self.endpoint = endpoint
        self.client_id = client_id
        self.client_secret = client_secret
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class MarketoObjectDataset(Dataset):
    """Marketo server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(MarketoObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'MarketoObject'
        self.table_name = table_name


class MicrosoftAccessLinkedService(LinkedService):
    """Microsoft Access linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The non-access credential portion of the connection string
     as well as an optional encrypted credential. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param authentication_type: Type of authentication used to connect to the Microsoft Access as
     ODBC data store. Possible values are: Anonymous and Basic. Type: string (or Expression with
     resultType string).
    :type authentication_type: object
    :param credential: The access credential portion of the connection string specified in driver-
     specific property-value format.
    :type credential: ~azure.synapse.artifacts.models.SecretBase
    :param user_name: User name for Basic authentication. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password for Basic authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'SecretBase'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[object] = None,
        credential: Optional["SecretBase"] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(MicrosoftAccessLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'MicrosoftAccess'
        self.connection_string = connection_string
        self.authentication_type = authentication_type
        self.credential = credential
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential


class MicrosoftAccessTableDataset(Dataset):
    """The Microsoft Access table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The Microsoft Access table name. Type: string (or Expression with resultType
     string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(MicrosoftAccessTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'MicrosoftAccessTable'
        self.table_name = table_name


class MongoDbCollectionDataset(Dataset):
    """The MongoDB database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param collection_name: Required. The table name of the MongoDB database. Type: string (or
     Expression with resultType string).
    :type collection_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection_name': {'key': 'typeProperties.collectionName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(MongoDbCollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'MongoDbCollection'
        self.collection_name = collection_name


class MongoDbLinkedService(LinkedService):
    """Linked service for MongoDb data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param server: Required. The IP address or server name of the MongoDB server. Type: string (or
     Expression with resultType string).
    :type server: object
    :param authentication_type: The authentication type to be used to connect to the MongoDB
     database. Possible values include: "Basic", "Anonymous".
    :type authentication_type: str or ~azure.synapse.artifacts.models.MongoDbAuthenticationType
    :param database_name: Required. The name of the MongoDB database that you want to access. Type:
     string (or Expression with resultType string).
    :type database_name: object
    :param username: Username for authentication. Type: string (or Expression with resultType
     string).
    :type username: object
    :param password: Password for authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param auth_source: Database to verify the username and password. Type: string (or Expression
     with resultType string).
    :type auth_source: object
    :param port: The TCP port number that the MongoDB server uses to listen for client connections.
     The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0.
    :type port: object
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false. Type: boolean (or Expression with resultType boolean).
    :type enable_ssl: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false. Type: boolean (or Expression with resultType boolean).
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
        'database_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'database_name': {'key': 'typeProperties.databaseName', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'auth_source': {'key': 'typeProperties.authSource', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        server: object,
        database_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[Union[str, "MongoDbAuthenticationType"]] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        auth_source: Optional[object] = None,
        port: Optional[object] = None,
        enable_ssl: Optional[object] = None,
        allow_self_signed_server_cert: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(MongoDbLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'MongoDb'
        self.server = server
        self.authentication_type = authentication_type
        self.database_name = database_name
        self.username = username
        self.password = password
        self.auth_source = auth_source
        self.port = port
        self.enable_ssl = enable_ssl
        self.allow_self_signed_server_cert = allow_self_signed_server_cert
        self.encrypted_credential = encrypted_credential


class MongoDbV2CollectionDataset(Dataset):
    """The MongoDB database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param collection: Required. The collection name of the MongoDB database. Type: string (or
     Expression with resultType string).
    :type collection: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection': {'key': 'typeProperties.collection', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        collection: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(MongoDbV2CollectionDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'MongoDbV2Collection'
        self.collection = collection


class MongoDbV2LinkedService(LinkedService):
    """Linked service for MongoDB data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The MongoDB connection string. Type: string, SecureString
     or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param database: Required. The name of the MongoDB database that you want to access. Type:
     string (or Expression with resultType string).
    :type database: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        database: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(MongoDbV2LinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'MongoDbV2'
        self.connection_string = connection_string
        self.database = database


class Trigger(msrest.serialization.Model):
    """Azure Synapse nested object which contains information about creating pipeline run.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MultiplePipelineTrigger, RerunTumblingWindowTrigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.synapse.artifacts.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
    }

    _subtype_map = {
        'type': {'MultiplePipelineTrigger': 'MultiplePipelineTrigger', 'RerunTumblingWindowTrigger': 'RerunTumblingWindowTrigger'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        **kwargs
    ):
        super(Trigger, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type: str = 'Trigger'
        self.description = description
        self.runtime_state = None
        self.annotations = annotations


class MultiplePipelineTrigger(Trigger):
    """Base class for all triggers that support one to many model for trigger to pipeline.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.synapse.artifacts.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.synapse.artifacts.models.TriggerPipelineReference]
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        pipelines: Optional[List["TriggerPipelineReference"]] = None,
        **kwargs
    ):
        super(MultiplePipelineTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, **kwargs)
        self.type: str = 'MultiplePipelineTrigger'
        self.pipelines = pipelines


class MySqlLinkedService(LinkedService):
    """Linked service for MySQL data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(MySqlLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'MySql'
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class MySqlTableDataset(Dataset):
    """The MySQL table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The MySQL table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(MySqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'MySqlTable'
        self.table_name = table_name


class NetezzaLinkedService(LinkedService):
    """Netezza linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        pwd: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(NetezzaLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Netezza'
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class NetezzaTableDataset(Dataset):
    """Netezza dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Netezza. Type: string (or Expression with resultType
     string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Netezza. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(NetezzaTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'NetezzaTable'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class Notebook(msrest.serialization.Model):
    """Notebook.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param description: The description of the notebook.
    :type description: str
    :param big_data_pool: Big data pool reference.
    :type big_data_pool: ~azure.synapse.artifacts.models.BigDataPoolReference
    :param session_properties: Session properties.
    :type session_properties: ~azure.synapse.artifacts.models.NotebookSessionProperties
    :param metadata: Required. Notebook root-level metadata.
    :type metadata: ~azure.synapse.artifacts.models.NotebookMetadata
    :param nbformat: Required. Notebook format (major number). Incremented between backwards
     incompatible changes to the notebook format.
    :type nbformat: int
    :param nbformat_minor: Required. Notebook format (minor number). Incremented for backward
     compatible changes to the notebook format.
    :type nbformat_minor: int
    :param cells: Required. Array of cells of the current notebook.
    :type cells: list[~azure.synapse.artifacts.models.NotebookCell]
    """

    _validation = {
        'metadata': {'required': True},
        'nbformat': {'required': True},
        'nbformat_minor': {'required': True},
        'cells': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'big_data_pool': {'key': 'bigDataPool', 'type': 'BigDataPoolReference'},
        'session_properties': {'key': 'sessionProperties', 'type': 'NotebookSessionProperties'},
        'metadata': {'key': 'metadata', 'type': 'NotebookMetadata'},
        'nbformat': {'key': 'nbformat', 'type': 'int'},
        'nbformat_minor': {'key': 'nbformat_minor', 'type': 'int'},
        'cells': {'key': 'cells', 'type': '[NotebookCell]'},
    }

    def __init__(
        self,
        *,
        metadata: "NotebookMetadata",
        nbformat: int,
        nbformat_minor: int,
        cells: List["NotebookCell"],
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        big_data_pool: Optional["BigDataPoolReference"] = None,
        session_properties: Optional["NotebookSessionProperties"] = None,
        **kwargs
    ):
        super(Notebook, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.description = description
        self.big_data_pool = big_data_pool
        self.session_properties = session_properties
        self.metadata = metadata
        self.nbformat = nbformat
        self.nbformat_minor = nbformat_minor
        self.cells = cells


class NotebookCell(msrest.serialization.Model):
    """Notebook cell.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param cell_type: Required. String identifying the type of cell.
    :type cell_type: str
    :param metadata: Required. Cell-level metadata.
    :type metadata: object
    :param source: Required. Contents of the cell, represented as an array of lines.
    :type source: list[str]
    :param attachments: Attachments associated with the cell.
    :type attachments: object
    :param outputs: Cell-level output items.
    :type outputs: list[~azure.synapse.artifacts.models.NotebookCellOutputItem]
    """

    _validation = {
        'cell_type': {'required': True},
        'metadata': {'required': True},
        'source': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'cell_type': {'key': 'cell_type', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'source': {'key': 'source', 'type': '[str]'},
        'attachments': {'key': 'attachments', 'type': 'object'},
        'outputs': {'key': 'outputs', 'type': '[NotebookCellOutputItem]'},
    }

    def __init__(
        self,
        *,
        cell_type: str,
        metadata: object,
        source: List[str],
        additional_properties: Optional[Dict[str, object]] = None,
        attachments: Optional[object] = None,
        outputs: Optional[List["NotebookCellOutputItem"]] = None,
        **kwargs
    ):
        super(NotebookCell, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.cell_type = cell_type
        self.metadata = metadata
        self.source = source
        self.attachments = attachments
        self.outputs = outputs


class NotebookCellOutputItem(msrest.serialization.Model):
    """An item of the notebook cell execution output.

    All required parameters must be populated in order to send to Azure.

    :param name: For output_type=stream, determines the name of stream (stdout / stderr).
    :type name: str
    :param execution_count: Execution sequence number.
    :type execution_count: int
    :param output_type: Required. Execution, display, or stream outputs. Possible values include:
     "execute_result", "display_data", "stream", "error".
    :type output_type: str or ~azure.synapse.artifacts.models.CellOutputType
    :param text: For output_type=stream, the stream's text output, represented as a string or an
     array of strings.
    :type text: object
    :param data: Output data. Use MIME type as key, and content as value.
    :type data: object
    :param metadata: Metadata for the output item.
    :type metadata: object
    """

    _validation = {
        'output_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'execution_count': {'key': 'execution_count', 'type': 'int'},
        'output_type': {'key': 'output_type', 'type': 'str'},
        'text': {'key': 'text', 'type': 'object'},
        'data': {'key': 'data', 'type': 'object'},
        'metadata': {'key': 'metadata', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        output_type: Union[str, "CellOutputType"],
        name: Optional[str] = None,
        execution_count: Optional[int] = None,
        text: Optional[object] = None,
        data: Optional[object] = None,
        metadata: Optional[object] = None,
        **kwargs
    ):
        super(NotebookCellOutputItem, self).__init__(**kwargs)
        self.name = name
        self.execution_count = execution_count
        self.output_type = output_type
        self.text = text
        self.data = data
        self.metadata = metadata


class NotebookKernelSpec(msrest.serialization.Model):
    """Kernel information.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Name of the kernel specification.
    :type name: str
    :param display_name: Required. Name to display in UI.
    :type display_name: str
    """

    _validation = {
        'name': {'required': True},
        'display_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'display_name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        display_name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(NotebookKernelSpec, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.display_name = display_name


class NotebookLanguageInfo(msrest.serialization.Model):
    """Language info.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. The programming language which this kernel runs.
    :type name: str
    :param codemirror_mode: The codemirror mode to use for code in this language.
    :type codemirror_mode: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'codemirror_mode': {'key': 'codemirror_mode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        codemirror_mode: Optional[str] = None,
        **kwargs
    ):
        super(NotebookLanguageInfo, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.codemirror_mode = codemirror_mode


class NotebookListResponse(msrest.serialization.Model):
    """A list of Notebook resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of Notebooks.
    :type value: list[~azure.synapse.artifacts.models.NotebookResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NotebookResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["NotebookResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NotebookListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NotebookMetadata(msrest.serialization.Model):
    """Notebook root-level metadata.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param kernelspec: Kernel information.
    :type kernelspec: ~azure.synapse.artifacts.models.NotebookKernelSpec
    :param language_info: Language info.
    :type language_info: ~azure.synapse.artifacts.models.NotebookLanguageInfo
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'kernelspec': {'key': 'kernelspec', 'type': 'NotebookKernelSpec'},
        'language_info': {'key': 'language_info', 'type': 'NotebookLanguageInfo'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        kernelspec: Optional["NotebookKernelSpec"] = None,
        language_info: Optional["NotebookLanguageInfo"] = None,
        **kwargs
    ):
        super(NotebookMetadata, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.kernelspec = kernelspec
        self.language_info = language_info


class NotebookResource(SubResource):
    """Notebook resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Properties of Notebook.
    :type properties: ~azure.synapse.artifacts.models.Notebook
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Notebook'},
    }

    def __init__(
        self,
        *,
        properties: "Notebook",
        **kwargs
    ):
        super(NotebookResource, self).__init__(**kwargs)
        self.properties = properties


class NotebookSessionProperties(msrest.serialization.Model):
    """Session properties.

    All required parameters must be populated in order to send to Azure.

    :param driver_memory: Required. Amount of memory to use for the driver process.
    :type driver_memory: str
    :param driver_cores: Required. Number of cores to use for the driver.
    :type driver_cores: int
    :param executor_memory: Required. Amount of memory to use per executor process.
    :type executor_memory: str
    :param executor_cores: Required. Number of cores to use for each executor.
    :type executor_cores: int
    :param num_executors: Required. Number of executors to launch for this session.
    :type num_executors: int
    """

    _validation = {
        'driver_memory': {'required': True},
        'driver_cores': {'required': True},
        'executor_memory': {'required': True},
        'executor_cores': {'required': True},
        'num_executors': {'required': True},
    }

    _attribute_map = {
        'driver_memory': {'key': 'driverMemory', 'type': 'str'},
        'driver_cores': {'key': 'driverCores', 'type': 'int'},
        'executor_memory': {'key': 'executorMemory', 'type': 'str'},
        'executor_cores': {'key': 'executorCores', 'type': 'int'},
        'num_executors': {'key': 'numExecutors', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        driver_memory: str,
        driver_cores: int,
        executor_memory: str,
        executor_cores: int,
        num_executors: int,
        **kwargs
    ):
        super(NotebookSessionProperties, self).__init__(**kwargs)
        self.driver_memory = driver_memory
        self.driver_cores = driver_cores
        self.executor_memory = executor_memory
        self.executor_cores = executor_cores
        self.num_executors = num_executors


class ODataLinkedService(LinkedService):
    """Open Data Protocol (OData) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The URL of the OData service endpoint. Type: string (or Expression with
     resultType string).
    :type url: object
    :param authentication_type: Type of authentication used to connect to the OData service.
     Possible values include: "Basic", "Anonymous", "Windows", "AadServicePrincipal",
     "ManagedServiceIdentity".
    :type authentication_type: str or ~azure.synapse.artifacts.models.ODataAuthenticationType
    :param user_name: User name of the OData service. Type: string (or Expression with resultType
     string).
    :type user_name: object
    :param password: Password of the OData service.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: Specify the tenant information (domain name or tenant ID) under which your
     application resides. Type: string (or Expression with resultType string).
    :type tenant: object
    :param service_principal_id: Specify the application id of your application registered in Azure
     Active Directory. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param aad_resource_id: Specify the resource you are requesting authorization to use Directory.
     Type: string (or Expression with resultType string).
    :type aad_resource_id: object
    :param aad_service_principal_credential_type: Specify the credential type (key or cert) is used
     for service principal. Possible values include: "ServicePrincipalKey", "ServicePrincipalCert".
    :type aad_service_principal_credential_type: str or
     ~azure.synapse.artifacts.models.ODataAadServicePrincipalCredentialType
    :param service_principal_key: Specify the secret of your application registered in Azure Active
     Directory. Type: string (or Expression with resultType string).
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_embedded_cert: Specify the base64 encoded certificate of your
     application registered in Azure Active Directory. Type: string (or Expression with resultType
     string).
    :type service_principal_embedded_cert: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_embedded_cert_password: Specify the password of your certificate if
     your certificate has a password and you are using AadServicePrincipal authentication. Type:
     string (or Expression with resultType string).
    :type service_principal_embedded_cert_password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'aad_resource_id': {'key': 'typeProperties.aadResourceId', 'type': 'object'},
        'aad_service_principal_credential_type': {'key': 'typeProperties.aadServicePrincipalCredentialType', 'type': 'str'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'service_principal_embedded_cert': {'key': 'typeProperties.servicePrincipalEmbeddedCert', 'type': 'SecretBase'},
        'service_principal_embedded_cert_password': {'key': 'typeProperties.servicePrincipalEmbeddedCertPassword', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[Union[str, "ODataAuthenticationType"]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        service_principal_id: Optional[object] = None,
        aad_resource_id: Optional[object] = None,
        aad_service_principal_credential_type: Optional[Union[str, "ODataAadServicePrincipalCredentialType"]] = None,
        service_principal_key: Optional["SecretBase"] = None,
        service_principal_embedded_cert: Optional["SecretBase"] = None,
        service_principal_embedded_cert_password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(ODataLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'OData'
        self.url = url
        self.authentication_type = authentication_type
        self.user_name = user_name
        self.password = password
        self.tenant = tenant
        self.service_principal_id = service_principal_id
        self.aad_resource_id = aad_resource_id
        self.aad_service_principal_credential_type = aad_service_principal_credential_type
        self.service_principal_key = service_principal_key
        self.service_principal_embedded_cert = service_principal_embedded_cert
        self.service_principal_embedded_cert_password = service_principal_embedded_cert_password
        self.encrypted_credential = encrypted_credential


class ODataResourceDataset(Dataset):
    """The Open Data Protocol (OData) resource dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param path: The OData resource path. Type: string (or Expression with resultType string).
    :type path: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'path': {'key': 'typeProperties.path', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        path: Optional[object] = None,
        **kwargs
    ):
        super(ODataResourceDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'ODataResource'
        self.path = path


class OdbcLinkedService(LinkedService):
    """Open Database Connectivity (ODBC) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The non-access credential portion of the connection string
     as well as an optional encrypted credential. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param authentication_type: Type of authentication used to connect to the ODBC data store.
     Possible values are: Anonymous and Basic. Type: string (or Expression with resultType string).
    :type authentication_type: object
    :param credential: The access credential portion of the connection string specified in driver-
     specific property-value format.
    :type credential: ~azure.synapse.artifacts.models.SecretBase
    :param user_name: User name for Basic authentication. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password for Basic authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'SecretBase'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        authentication_type: Optional[object] = None,
        credential: Optional["SecretBase"] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(OdbcLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Odbc'
        self.connection_string = connection_string
        self.authentication_type = authentication_type
        self.credential = credential
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential


class OdbcTableDataset(Dataset):
    """The ODBC table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The ODBC table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(OdbcTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'OdbcTable'
        self.table_name = table_name


class Office365Dataset(Dataset):
    """The Office365 account.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: Required. Name of the dataset to extract from Office 365. Type: string (or
     Expression with resultType string).
    :type table_name: object
    :param predicate: A predicate expression that can be used to filter the specific rows to
     extract from Office 365. Type: string (or Expression with resultType string).
    :type predicate: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'table_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'predicate': {'key': 'typeProperties.predicate', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        table_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        predicate: Optional[object] = None,
        **kwargs
    ):
        super(Office365Dataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'Office365Table'
        self.table_name = table_name
        self.predicate = predicate


class Office365LinkedService(LinkedService):
    """Office365 linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param office365_tenant_id: Required. Azure tenant ID to which the Office 365 account belongs.
     Type: string (or Expression with resultType string).
    :type office365_tenant_id: object
    :param service_principal_tenant_id: Required. Specify the tenant information under which your
     Azure AD web application resides. Type: string (or Expression with resultType string).
    :type service_principal_tenant_id: object
    :param service_principal_id: Required. Specify the application's client ID. Type: string (or
     Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: Required. Specify the application's key.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'office365_tenant_id': {'required': True},
        'service_principal_tenant_id': {'required': True},
        'service_principal_id': {'required': True},
        'service_principal_key': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'office365_tenant_id': {'key': 'typeProperties.office365TenantId', 'type': 'object'},
        'service_principal_tenant_id': {'key': 'typeProperties.servicePrincipalTenantId', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        office365_tenant_id: object,
        service_principal_tenant_id: object,
        service_principal_id: object,
        service_principal_key: "SecretBase",
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(Office365LinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Office365'
        self.office365_tenant_id = office365_tenant_id
        self.service_principal_tenant_id = service_principal_tenant_id
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.encrypted_credential = encrypted_credential


class OracleLinkedService(LinkedService):
    """Oracle database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(OracleLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Oracle'
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class OracleServiceCloudLinkedService(LinkedService):
    """Oracle Service Cloud linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The URL of the Oracle Service Cloud instance.
    :type host: object
    :param username: Required. The user name that you use to access Oracle Service Cloud server.
    :type username: object
    :param password: Required. The password corresponding to the user name that you provided in the
     username key.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true. Type: boolean (or Expression with resultType boolean).
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true. Type: boolean (or Expression with resultType boolean).
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true. Type: boolean (or Expression with resultType
     boolean).
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'username': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        username: object,
        password: "SecretBase",
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(OracleServiceCloudLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'OracleServiceCloud'
        self.host = host
        self.username = username
        self.password = password
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class OracleServiceCloudObjectDataset(Dataset):
    """Oracle Service Cloud dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(OracleServiceCloudObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'OracleServiceCloudObject'
        self.table_name = table_name


class OracleTableDataset(Dataset):
    """The on-premises Oracle database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the on-premises Oracle database. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the on-premises Oracle database. Type: string (or Expression
     with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(OracleTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'OracleTable'
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class OrcDataset(Dataset):
    """ORC dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the ORC data storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param orc_compression_codec:  Possible values include: "none", "zlib", "snappy".
    :type orc_compression_codec: str or ~azure.synapse.artifacts.models.OrcCompressionCodec
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'orc_compression_codec': {'key': 'typeProperties.orcCompressionCodec', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        orc_compression_codec: Optional[Union[str, "OrcCompressionCodec"]] = None,
        **kwargs
    ):
        super(OrcDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'Orc'
        self.location = location
        self.orc_compression_codec = orc_compression_codec


class ParameterSpecification(msrest.serialization.Model):
    """Definition of a single parameter for an entity.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Parameter type. Possible values include: "Object", "String", "Int",
     "Float", "Bool", "Array", "SecureString".
    :type type: str or ~azure.synapse.artifacts.models.ParameterType
    :param default_value: Default value of parameter.
    :type default_value: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ParameterType"],
        default_value: Optional[object] = None,
        **kwargs
    ):
        super(ParameterSpecification, self).__init__(**kwargs)
        self.type = type
        self.default_value = default_value


class ParquetDataset(Dataset):
    """Parquet dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the parquet storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param compression_codec:  Possible values include: "none", "gzip", "snappy", "lzo".
    :type compression_codec: str or ~azure.synapse.artifacts.models.ParquetCompressionCodec
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'compression_codec': {'key': 'typeProperties.compressionCodec', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        location: Optional["DatasetLocation"] = None,
        compression_codec: Optional[Union[str, "ParquetCompressionCodec"]] = None,
        **kwargs
    ):
        super(ParquetDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'Parquet'
        self.location = location
        self.compression_codec = compression_codec


class PaypalLinkedService(LinkedService):
    """Paypal Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The URL of the PayPal instance. (i.e. api.sandbox.paypal.com).
    :type host: object
    :param client_id: Required. The client ID associated with your PayPal application.
    :type client_id: object
    :param client_secret: The client secret associated with your PayPal application.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        client_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        client_secret: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(PaypalLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Paypal'
        self.host = host
        self.client_id = client_id
        self.client_secret = client_secret
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class PaypalObjectDataset(Dataset):
    """Paypal Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(PaypalObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'PaypalObject'
        self.table_name = table_name


class PhoenixLinkedService(LinkedService):
    """Phoenix server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The IP address or host name of the Phoenix server. (i.e.
     192.168.222.160).
    :type host: object
    :param port: The TCP port that the Phoenix server uses to listen for client connections. The
     default value is 8765.
    :type port: object
    :param http_path: The partial URL corresponding to the Phoenix server. (i.e.
     /gateway/sandbox/phoenix/version). The default value is hbasephoenix if using
     WindowsAzureHDInsightService.
    :type http_path: object
    :param authentication_type: Required. The authentication mechanism used to connect to the
     Phoenix server. Possible values include: "Anonymous", "UsernameAndPassword",
     "WindowsAzureHDInsightService".
    :type authentication_type: str or ~azure.synapse.artifacts.models.PhoenixAuthenticationType
    :param username: The user name used to connect to the Phoenix server.
    :type username: object
    :param password: The password corresponding to the user name.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'http_path': {'key': 'typeProperties.httpPath', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        authentication_type: Union[str, "PhoenixAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        http_path: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        enable_ssl: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        use_system_trust_store: Optional[object] = None,
        allow_host_name_cn_mismatch: Optional[object] = None,
        allow_self_signed_server_cert: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(PhoenixLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Phoenix'
        self.host = host
        self.port = port
        self.http_path = http_path
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.enable_ssl = enable_ssl
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.allow_host_name_cn_mismatch = allow_host_name_cn_mismatch
        self.allow_self_signed_server_cert = allow_self_signed_server_cert
        self.encrypted_credential = encrypted_credential


class PhoenixObjectDataset(Dataset):
    """Phoenix server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Phoenix. Type: string (or Expression with resultType
     string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Phoenix. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(PhoenixObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'PhoenixObject'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class PipelineFolder(msrest.serialization.Model):
    """The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.

    :param name: The name of the folder that this Pipeline is in.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(PipelineFolder, self).__init__(**kwargs)
        self.name = name


class PipelineListResponse(msrest.serialization.Model):
    """A list of pipeline resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of pipelines.
    :type value: list[~azure.synapse.artifacts.models.PipelineResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PipelineResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["PipelineResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PipelineListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PipelineReference(msrest.serialization.Model):
    """Pipeline reference type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Pipeline reference type. Default value: "PipelineReference".
    :vartype type: str
    :param reference_name: Required. Reference pipeline name.
    :type reference_name: str
    :param name: Reference name.
    :type name: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    type = "PipelineReference"

    def __init__(
        self,
        *,
        reference_name: str,
        name: Optional[str] = None,
        **kwargs
    ):
        super(PipelineReference, self).__init__(**kwargs)
        self.reference_name = reference_name
        self.name = name


class PipelineResource(SubResource):
    """Pipeline resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param description: The description of the pipeline.
    :type description: str
    :param activities: List of activities in pipeline.
    :type activities: list[~azure.synapse.artifacts.models.Activity]
    :param parameters: List of parameters for pipeline.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param variables: List of variables for pipeline.
    :type variables: dict[str, ~azure.synapse.artifacts.models.VariableSpecification]
    :param concurrency: The max number of concurrent runs for the pipeline.
    :type concurrency: int
    :param annotations: List of tags that can be used for describing the Pipeline.
    :type annotations: list[object]
    :param run_dimensions: Dimensions emitted by Pipeline.
    :type run_dimensions: dict[str, object]
    :param folder: The folder that this Pipeline is in. If not specified, Pipeline will appear at
     the root level.
    :type folder: ~azure.synapse.artifacts.models.PipelineFolder
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'concurrency': {'minimum': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'activities': {'key': 'properties.activities', 'type': '[Activity]'},
        'parameters': {'key': 'properties.parameters', 'type': '{ParameterSpecification}'},
        'variables': {'key': 'properties.variables', 'type': '{VariableSpecification}'},
        'concurrency': {'key': 'properties.concurrency', 'type': 'int'},
        'annotations': {'key': 'properties.annotations', 'type': '[object]'},
        'run_dimensions': {'key': 'properties.runDimensions', 'type': '{object}'},
        'folder': {'key': 'properties.folder', 'type': 'PipelineFolder'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        activities: Optional[List["Activity"]] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        variables: Optional[Dict[str, "VariableSpecification"]] = None,
        concurrency: Optional[int] = None,
        annotations: Optional[List[object]] = None,
        run_dimensions: Optional[Dict[str, object]] = None,
        folder: Optional["PipelineFolder"] = None,
        **kwargs
    ):
        super(PipelineResource, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.description = description
        self.activities = activities
        self.parameters = parameters
        self.variables = variables
        self.concurrency = concurrency
        self.annotations = annotations
        self.run_dimensions = run_dimensions
        self.folder = folder


class PipelineRun(msrest.serialization.Model):
    """Information about a pipeline run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar run_id: Identifier of a run.
    :vartype run_id: str
    :ivar run_group_id: Identifier that correlates all the recovery runs of a pipeline run.
    :vartype run_group_id: str
    :ivar is_latest: Indicates if the recovered pipeline run is the latest in its group.
    :vartype is_latest: bool
    :ivar pipeline_name: The pipeline name.
    :vartype pipeline_name: str
    :ivar parameters: The full or partial list of parameter name, value pair used in the pipeline
     run.
    :vartype parameters: dict[str, str]
    :ivar invoked_by: Entity that started the pipeline run.
    :vartype invoked_by: ~azure.synapse.artifacts.models.PipelineRunInvokedBy
    :ivar last_updated: The last updated timestamp for the pipeline run event in ISO8601 format.
    :vartype last_updated: ~datetime.datetime
    :ivar run_start: The start time of a pipeline run in ISO8601 format.
    :vartype run_start: ~datetime.datetime
    :ivar run_end: The end time of a pipeline run in ISO8601 format.
    :vartype run_end: ~datetime.datetime
    :ivar duration_in_ms: The duration of a pipeline run.
    :vartype duration_in_ms: int
    :ivar status: The status of a pipeline run.
    :vartype status: str
    :ivar message: The message from a pipeline run.
    :vartype message: str
    """

    _validation = {
        'run_id': {'readonly': True},
        'run_group_id': {'readonly': True},
        'is_latest': {'readonly': True},
        'pipeline_name': {'readonly': True},
        'parameters': {'readonly': True},
        'invoked_by': {'readonly': True},
        'last_updated': {'readonly': True},
        'run_start': {'readonly': True},
        'run_end': {'readonly': True},
        'duration_in_ms': {'readonly': True},
        'status': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'run_id': {'key': 'runId', 'type': 'str'},
        'run_group_id': {'key': 'runGroupId', 'type': 'str'},
        'is_latest': {'key': 'isLatest', 'type': 'bool'},
        'pipeline_name': {'key': 'pipelineName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'invoked_by': {'key': 'invokedBy', 'type': 'PipelineRunInvokedBy'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'run_start': {'key': 'runStart', 'type': 'iso-8601'},
        'run_end': {'key': 'runEnd', 'type': 'iso-8601'},
        'duration_in_ms': {'key': 'durationInMs', 'type': 'int'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(PipelineRun, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.run_id = None
        self.run_group_id = None
        self.is_latest = None
        self.pipeline_name = None
        self.parameters = None
        self.invoked_by = None
        self.last_updated = None
        self.run_start = None
        self.run_end = None
        self.duration_in_ms = None
        self.status = None
        self.message = None


class PipelineRunInvokedBy(msrest.serialization.Model):
    """Provides entity name and id that started the pipeline run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the entity that started the pipeline run.
    :vartype name: str
    :ivar id: The ID of the entity that started the run.
    :vartype id: str
    :ivar invoked_by_type: The type of the entity that started the run.
    :vartype invoked_by_type: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'invoked_by_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'invoked_by_type': {'key': 'invokedByType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineRunInvokedBy, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.invoked_by_type = None


class PipelineRunsQueryResponse(msrest.serialization.Model):
    """A list pipeline runs.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of pipeline runs.
    :type value: list[~azure.synapse.artifacts.models.PipelineRun]
    :param continuation_token: The continuation token for getting the next page of results, if any
     remaining results exist, null otherwise.
    :type continuation_token: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PipelineRun]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["PipelineRun"],
        continuation_token: Optional[str] = None,
        **kwargs
    ):
        super(PipelineRunsQueryResponse, self).__init__(**kwargs)
        self.value = value
        self.continuation_token = continuation_token


class PostgreSqlLinkedService(LinkedService):
    """Linked service for PostgreSQL data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        password: Optional["AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(PostgreSqlLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'PostgreSql'
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class PostgreSqlTableDataset(Dataset):
    """The PostgreSQL table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The PostgreSQL table name. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The PostgreSQL schema name. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(PostgreSqlTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'PostgreSqlTable'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class PrestoLinkedService(LinkedService):
    """Presto server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The IP address or host name of the Presto server. (i.e.
     192.168.222.160).
    :type host: object
    :param server_version: Required. The version of the Presto server. (i.e. 0.148-t).
    :type server_version: object
    :param catalog: Required. The catalog context for all request against the server.
    :type catalog: object
    :param port: The TCP port that the Presto server uses to listen for client connections. The
     default value is 8080.
    :type port: object
    :param authentication_type: Required. The authentication mechanism used to connect to the
     Presto server. Possible values include: "Anonymous", "LDAP".
    :type authentication_type: str or ~azure.synapse.artifacts.models.PrestoAuthenticationType
    :param username: The user name used to connect to the Presto server.
    :type username: object
    :param password: The password corresponding to the user name.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param time_zone_id: The local time zone used by the connection. Valid values for this option
     are specified in the IANA Time Zone Database. The default value is the system time zone.
    :type time_zone_id: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'server_version': {'required': True},
        'catalog': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'server_version': {'key': 'typeProperties.serverVersion', 'type': 'object'},
        'catalog': {'key': 'typeProperties.catalog', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'time_zone_id': {'key': 'typeProperties.timeZoneID', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        server_version: object,
        catalog: object,
        authentication_type: Union[str, "PrestoAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        enable_ssl: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        use_system_trust_store: Optional[object] = None,
        allow_host_name_cn_mismatch: Optional[object] = None,
        allow_self_signed_server_cert: Optional[object] = None,
        time_zone_id: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(PrestoLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Presto'
        self.host = host
        self.server_version = server_version
        self.catalog = catalog
        self.port = port
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.enable_ssl = enable_ssl
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.allow_host_name_cn_mismatch = allow_host_name_cn_mismatch
        self.allow_self_signed_server_cert = allow_self_signed_server_cert
        self.time_zone_id = time_zone_id
        self.encrypted_credential = encrypted_credential


class PrestoObjectDataset(Dataset):
    """Presto server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Presto. Type: string (or Expression with resultType
     string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Presto. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(PrestoObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'PrestoObject'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class QueryDataFlowDebugSessionsResponse(msrest.serialization.Model):
    """A list of active debug sessions.

    :param value: Array with all active debug sessions.
    :type value: list[~azure.synapse.artifacts.models.DataFlowDebugSessionInfo]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataFlowDebugSessionInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DataFlowDebugSessionInfo"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(QueryDataFlowDebugSessionsResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuickBooksLinkedService(LinkedService):
    """QuickBooks server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the QuickBooks server. (i.e.
     quickbooks.api.intuit.com).
    :type endpoint: object
    :param company_id: Required. The company ID of the QuickBooks company to authorize.
    :type company_id: object
    :param consumer_key: Required. The consumer key for OAuth 1.0 authentication.
    :type consumer_key: object
    :param consumer_secret: Required. The consumer secret for OAuth 1.0 authentication.
    :type consumer_secret: ~azure.synapse.artifacts.models.SecretBase
    :param access_token: Required. The access token for OAuth 1.0 authentication.
    :type access_token: ~azure.synapse.artifacts.models.SecretBase
    :param access_token_secret: Required. The access token secret for OAuth 1.0 authentication.
    :type access_token_secret: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'company_id': {'required': True},
        'consumer_key': {'required': True},
        'consumer_secret': {'required': True},
        'access_token': {'required': True},
        'access_token_secret': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'company_id': {'key': 'typeProperties.companyId', 'type': 'object'},
        'consumer_key': {'key': 'typeProperties.consumerKey', 'type': 'object'},
        'consumer_secret': {'key': 'typeProperties.consumerSecret', 'type': 'SecretBase'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'access_token_secret': {'key': 'typeProperties.accessTokenSecret', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: object,
        company_id: object,
        consumer_key: object,
        consumer_secret: "SecretBase",
        access_token: "SecretBase",
        access_token_secret: "SecretBase",
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        use_encrypted_endpoints: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(QuickBooksLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'QuickBooks'
        self.endpoint = endpoint
        self.company_id = company_id
        self.consumer_key = consumer_key
        self.consumer_secret = consumer_secret
        self.access_token = access_token
        self.access_token_secret = access_token_secret
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.encrypted_credential = encrypted_credential


class QuickBooksObjectDataset(Dataset):
    """QuickBooks server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(QuickBooksObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'QuickBooksObject'
        self.table_name = table_name


class RedirectIncompatibleRowSettings(msrest.serialization.Model):
    """Redirect incompatible row settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param linked_service_name: Required. Name of the Azure Storage, Storage SAS, or Azure Data
     Lake Store linked service used for redirecting incompatible row. Must be specified if
     redirectIncompatibleRowSettings is specified. Type: string (or Expression with resultType
     string).
    :type linked_service_name: object
    :param path: The path for storing the redirect incompatible row data. Type: string (or
     Expression with resultType string).
    :type path: object
    """

    _validation = {
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'object'},
        'path': {'key': 'path', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        path: Optional[object] = None,
        **kwargs
    ):
        super(RedirectIncompatibleRowSettings, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.linked_service_name = linked_service_name
        self.path = path


class RelationalTableDataset(Dataset):
    """The relational table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The relational table name. Type: string (or Expression with resultType
     string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(RelationalTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'RelationalTable'
        self.table_name = table_name


class RerunTriggerListResponse(msrest.serialization.Model):
    """A list of rerun triggers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of rerun triggers.
    :type value: list[~azure.synapse.artifacts.models.RerunTriggerResource]
    :ivar next_link: The continuation token for getting the next page of results, if any remaining
     results exist, null otherwise.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RerunTriggerResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["RerunTriggerResource"],
        **kwargs
    ):
        super(RerunTriggerListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class RerunTriggerResource(SubResource):
    """RerunTrigger resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Properties of the rerun trigger.
    :type properties: ~azure.synapse.artifacts.models.RerunTumblingWindowTrigger
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'RerunTumblingWindowTrigger'},
    }

    def __init__(
        self,
        *,
        properties: "RerunTumblingWindowTrigger",
        **kwargs
    ):
        super(RerunTriggerResource, self).__init__(**kwargs)
        self.properties = properties


class RerunTumblingWindowTrigger(Trigger):
    """Trigger that schedules pipeline reruns for all fixed time interval windows from a requested start time to requested end time.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.synapse.artifacts.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param parent_trigger: The parent trigger reference.
    :type parent_trigger: object
    :param requested_start_time: Required. The start time for the time period for which restatement
     is initiated. Only UTC time is currently supported.
    :type requested_start_time: ~datetime.datetime
    :param requested_end_time: Required. The end time for the time period for which restatement is
     initiated. Only UTC time is currently supported.
    :type requested_end_time: ~datetime.datetime
    :param max_concurrency: Required. The max number of parallel time windows (ready for execution)
     for which a rerun is triggered.
    :type max_concurrency: int
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'requested_start_time': {'required': True},
        'requested_end_time': {'required': True},
        'max_concurrency': {'required': True, 'maximum': 50, 'minimum': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'parent_trigger': {'key': 'typeProperties.parentTrigger', 'type': 'object'},
        'requested_start_time': {'key': 'typeProperties.requestedStartTime', 'type': 'iso-8601'},
        'requested_end_time': {'key': 'typeProperties.requestedEndTime', 'type': 'iso-8601'},
        'max_concurrency': {'key': 'typeProperties.maxConcurrency', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        requested_start_time: datetime.datetime,
        requested_end_time: datetime.datetime,
        max_concurrency: int,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[object]] = None,
        parent_trigger: Optional[object] = None,
        **kwargs
    ):
        super(RerunTumblingWindowTrigger, self).__init__(additional_properties=additional_properties, description=description, annotations=annotations, **kwargs)
        self.type: str = 'RerunTumblingWindowTrigger'
        self.parent_trigger = parent_trigger
        self.requested_start_time = requested_start_time
        self.requested_end_time = requested_end_time
        self.max_concurrency = max_concurrency


class RerunTumblingWindowTriggerActionParameters(msrest.serialization.Model):
    """Rerun tumbling window trigger Parameters.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. The start time for the time period for which restatement is
     initiated. Only UTC time is currently supported.
    :type start_time: ~datetime.datetime
    :param end_time: Required. The end time for the time period for which restatement is initiated.
     Only UTC time is currently supported.
    :type end_time: ~datetime.datetime
    :param max_concurrency: Required. The max number of parallel time windows (ready for execution)
     for which a rerun is triggered.
    :type max_concurrency: int
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
        'max_concurrency': {'required': True, 'maximum': 50, 'minimum': 1},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        max_concurrency: int,
        **kwargs
    ):
        super(RerunTumblingWindowTriggerActionParameters, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.max_concurrency = max_concurrency


class Resource(msrest.serialization.Model):
    """Azure Synapse top-level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :ivar e_tag: Etag identifies change in the resource.
    :vartype e_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'e_tag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.e_tag = None


class ResponsysLinkedService(LinkedService):
    """Responsys linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the Responsys server.
    :type endpoint: object
    :param client_id: Required. The client ID associated with the Responsys application. Type:
     string (or Expression with resultType string).
    :type client_id: object
    :param client_secret: The client secret associated with the Responsys application. Type: string
     (or Expression with resultType string).
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true. Type: boolean (or Expression with resultType boolean).
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true. Type: boolean (or Expression with resultType boolean).
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true. Type: boolean (or Expression with resultType
     boolean).
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: object,
        client_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        client_secret: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(ResponsysLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Responsys'
        self.endpoint = endpoint
        self.client_id = client_id
        self.client_secret = client_secret
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class ResponsysObjectDataset(Dataset):
    """Responsys dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(ResponsysObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'ResponsysObject'
        self.table_name = table_name


class RestResourceDataset(Dataset):
    """A Rest service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param relative_url: The relative URL to the resource that the RESTful API provides. Type:
     string (or Expression with resultType string).
    :type relative_url: object
    :param request_method: The HTTP method used to call the RESTful API. The default is GET. Type:
     string (or Expression with resultType string).
    :type request_method: object
    :param request_body: The HTTP request body to the RESTful API if requestMethod is POST. Type:
     string (or Expression with resultType string).
    :type request_body: object
    :param additional_headers: The additional HTTP headers in the request to the RESTful API. Type:
     string (or Expression with resultType string).
    :type additional_headers: object
    :param pagination_rules: The pagination rules to compose next page requests. Type: string (or
     Expression with resultType string).
    :type pagination_rules: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'relative_url': {'key': 'typeProperties.relativeUrl', 'type': 'object'},
        'request_method': {'key': 'typeProperties.requestMethod', 'type': 'object'},
        'request_body': {'key': 'typeProperties.requestBody', 'type': 'object'},
        'additional_headers': {'key': 'typeProperties.additionalHeaders', 'type': 'object'},
        'pagination_rules': {'key': 'typeProperties.paginationRules', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        relative_url: Optional[object] = None,
        request_method: Optional[object] = None,
        request_body: Optional[object] = None,
        additional_headers: Optional[object] = None,
        pagination_rules: Optional[object] = None,
        **kwargs
    ):
        super(RestResourceDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'RestResource'
        self.relative_url = relative_url
        self.request_method = request_method
        self.request_body = request_body
        self.additional_headers = additional_headers
        self.pagination_rules = pagination_rules


class RestServiceLinkedService(LinkedService):
    """Rest Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The base URL of the REST service.
    :type url: object
    :param enable_server_certificate_validation: Whether to validate server side SSL certificate
     when connecting to the endpoint.The default value is true. Type: boolean (or Expression with
     resultType boolean).
    :type enable_server_certificate_validation: object
    :param authentication_type: Required. Type of authentication used to connect to the REST
     service. Possible values include: "Anonymous", "Basic", "AadServicePrincipal",
     "ManagedServiceIdentity".
    :type authentication_type: str or ~azure.synapse.artifacts.models.RestServiceAuthenticationType
    :param user_name: The user name used in Basic authentication type.
    :type user_name: object
    :param password: The password used in Basic authentication type.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_id: The application's client ID used in AadServicePrincipal
     authentication type.
    :type service_principal_id: object
    :param service_principal_key: The application's key used in AadServicePrincipal authentication
     type.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The tenant information (domain name or tenant ID) used in AadServicePrincipal
     authentication type under which your application resides.
    :type tenant: object
    :param aad_resource_id: The resource you are requesting authorization to use.
    :type aad_resource_id: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'enable_server_certificate_validation': {'key': 'typeProperties.enableServerCertificateValidation', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'aad_resource_id': {'key': 'typeProperties.aadResourceId', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        authentication_type: Union[str, "RestServiceAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        enable_server_certificate_validation: Optional[object] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        service_principal_id: Optional[object] = None,
        service_principal_key: Optional["SecretBase"] = None,
        tenant: Optional[object] = None,
        aad_resource_id: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(RestServiceLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'RestService'
        self.url = url
        self.enable_server_certificate_validation = enable_server_certificate_validation
        self.authentication_type = authentication_type
        self.user_name = user_name
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.aad_resource_id = aad_resource_id
        self.encrypted_credential = encrypted_credential


class RunFilterParameters(msrest.serialization.Model):
    """Query parameters for listing runs.

    All required parameters must be populated in order to send to Azure.

    :param continuation_token: The continuation token for getting the next page of results. Null
     for first page.
    :type continuation_token: str
    :param last_updated_after: Required. The time at or after which the run event was updated in
     'ISO 8601' format.
    :type last_updated_after: ~datetime.datetime
    :param last_updated_before: Required. The time at or before which the run event was updated in
     'ISO 8601' format.
    :type last_updated_before: ~datetime.datetime
    :param filters: List of filters.
    :type filters: list[~azure.synapse.artifacts.models.RunQueryFilter]
    :param order_by: List of OrderBy option.
    :type order_by: list[~azure.synapse.artifacts.models.RunQueryOrderBy]
    """

    _validation = {
        'last_updated_after': {'required': True},
        'last_updated_before': {'required': True},
    }

    _attribute_map = {
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'last_updated_after': {'key': 'lastUpdatedAfter', 'type': 'iso-8601'},
        'last_updated_before': {'key': 'lastUpdatedBefore', 'type': 'iso-8601'},
        'filters': {'key': 'filters', 'type': '[RunQueryFilter]'},
        'order_by': {'key': 'orderBy', 'type': '[RunQueryOrderBy]'},
    }

    def __init__(
        self,
        *,
        last_updated_after: datetime.datetime,
        last_updated_before: datetime.datetime,
        continuation_token: Optional[str] = None,
        filters: Optional[List["RunQueryFilter"]] = None,
        order_by: Optional[List["RunQueryOrderBy"]] = None,
        **kwargs
    ):
        super(RunFilterParameters, self).__init__(**kwargs)
        self.continuation_token = continuation_token
        self.last_updated_after = last_updated_after
        self.last_updated_before = last_updated_before
        self.filters = filters
        self.order_by = order_by


class RunQueryFilter(msrest.serialization.Model):
    """Query filter option for listing runs.

    All required parameters must be populated in order to send to Azure.

    :param operand: Required. Parameter name to be used for filter. The allowed operands to query
     pipeline runs are PipelineName, RunStart, RunEnd and Status; to query activity runs are
     ActivityName, ActivityRunStart, ActivityRunEnd, ActivityType and Status, and to query trigger
     runs are TriggerName, TriggerRunTimestamp and Status. Possible values include: "PipelineName",
     "Status", "RunStart", "RunEnd", "ActivityName", "ActivityRunStart", "ActivityRunEnd",
     "ActivityType", "TriggerName", "TriggerRunTimestamp", "RunGroupId", "LatestOnly".
    :type operand: str or ~azure.synapse.artifacts.models.RunQueryFilterOperand
    :param operator: Required. Operator to be used for filter. Possible values include: "Equals",
     "NotEquals", "In", "NotIn".
    :type operator: str or ~azure.synapse.artifacts.models.RunQueryFilterOperator
    :param values: Required. List of filter values.
    :type values: list[str]
    """

    _validation = {
        'operand': {'required': True},
        'operator': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'operand': {'key': 'operand', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        operand: Union[str, "RunQueryFilterOperand"],
        operator: Union[str, "RunQueryFilterOperator"],
        values: List[str],
        **kwargs
    ):
        super(RunQueryFilter, self).__init__(**kwargs)
        self.operand = operand
        self.operator = operator
        self.values = values


class RunQueryOrderBy(msrest.serialization.Model):
    """An object to provide order by options for listing runs.

    All required parameters must be populated in order to send to Azure.

    :param order_by: Required. Parameter name to be used for order by. The allowed parameters to
     order by for pipeline runs are PipelineName, RunStart, RunEnd and Status; for activity runs are
     ActivityName, ActivityRunStart, ActivityRunEnd and Status; for trigger runs are TriggerName,
     TriggerRunTimestamp and Status. Possible values include: "RunStart", "RunEnd", "PipelineName",
     "Status", "ActivityName", "ActivityRunStart", "ActivityRunEnd", "TriggerName",
     "TriggerRunTimestamp".
    :type order_by: str or ~azure.synapse.artifacts.models.RunQueryOrderByField
    :param order: Required. Sorting order of the parameter. Possible values include: "ASC", "DESC".
    :type order: str or ~azure.synapse.artifacts.models.RunQueryOrder
    """

    _validation = {
        'order_by': {'required': True},
        'order': {'required': True},
    }

    _attribute_map = {
        'order_by': {'key': 'orderBy', 'type': 'str'},
        'order': {'key': 'order', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        order_by: Union[str, "RunQueryOrderByField"],
        order: Union[str, "RunQueryOrder"],
        **kwargs
    ):
        super(RunQueryOrderBy, self).__init__(**kwargs)
        self.order_by = order_by
        self.order = order


class SalesforceLinkedService(LinkedService):
    """Linked service for Salesforce.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param environment_url: The URL of Salesforce instance. Default is
     'https://login.salesforce.com'. To copy data from sandbox, specify
     'https://test.salesforce.com'. To copy data from custom domain, specify, for example,
     'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
    :type environment_url: object
    :param username: The username for Basic authentication of the Salesforce instance. Type: string
     (or Expression with resultType string).
    :type username: object
    :param password: The password for Basic authentication of the Salesforce instance.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param security_token: The security token is required to remotely access Salesforce instance.
    :type security_token: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'environment_url': {'key': 'typeProperties.environmentUrl', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'security_token': {'key': 'typeProperties.securityToken', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        environment_url: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        security_token: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SalesforceLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Salesforce'
        self.environment_url = environment_url
        self.username = username
        self.password = password
        self.security_token = security_token
        self.encrypted_credential = encrypted_credential


class SalesforceMarketingCloudLinkedService(LinkedService):
    """Salesforce Marketing Cloud linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param client_id: Required. The client ID associated with the Salesforce Marketing Cloud
     application. Type: string (or Expression with resultType string).
    :type client_id: object
    :param client_secret: The client secret associated with the Salesforce Marketing Cloud
     application. Type: string (or Expression with resultType string).
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true. Type: boolean (or Expression with resultType boolean).
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true. Type: boolean (or Expression with resultType boolean).
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true. Type: boolean (or Expression with resultType
     boolean).
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        client_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        client_secret: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SalesforceMarketingCloudLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'SalesforceMarketingCloud'
        self.client_id = client_id
        self.client_secret = client_secret
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class SalesforceMarketingCloudObjectDataset(Dataset):
    """Salesforce Marketing Cloud dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(SalesforceMarketingCloudObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SalesforceMarketingCloudObject'
        self.table_name = table_name


class SalesforceObjectDataset(Dataset):
    """The Salesforce object dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param object_api_name: The Salesforce object API name. Type: string (or Expression with
     resultType string).
    :type object_api_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'object_api_name': {'key': 'typeProperties.objectApiName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        object_api_name: Optional[object] = None,
        **kwargs
    ):
        super(SalesforceObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SalesforceObject'
        self.object_api_name = object_api_name


class SalesforceServiceCloudLinkedService(LinkedService):
    """Linked service for Salesforce Service Cloud.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param environment_url: The URL of Salesforce Service Cloud instance. Default is
     'https://login.salesforce.com'. To copy data from sandbox, specify
     'https://test.salesforce.com'. To copy data from custom domain, specify, for example,
     'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
    :type environment_url: object
    :param username: The username for Basic authentication of the Salesforce instance. Type: string
     (or Expression with resultType string).
    :type username: object
    :param password: The password for Basic authentication of the Salesforce instance.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param security_token: The security token is required to remotely access Salesforce instance.
    :type security_token: ~azure.synapse.artifacts.models.SecretBase
    :param extended_properties: Extended properties appended to the connection string. Type: string
     (or Expression with resultType string).
    :type extended_properties: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'environment_url': {'key': 'typeProperties.environmentUrl', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'security_token': {'key': 'typeProperties.securityToken', 'type': 'SecretBase'},
        'extended_properties': {'key': 'typeProperties.extendedProperties', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        environment_url: Optional[object] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        security_token: Optional["SecretBase"] = None,
        extended_properties: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SalesforceServiceCloudLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'SalesforceServiceCloud'
        self.environment_url = environment_url
        self.username = username
        self.password = password
        self.security_token = security_token
        self.extended_properties = extended_properties
        self.encrypted_credential = encrypted_credential


class SalesforceServiceCloudObjectDataset(Dataset):
    """The Salesforce Service Cloud object dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param object_api_name: The Salesforce Service Cloud object API name. Type: string (or
     Expression with resultType string).
    :type object_api_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'object_api_name': {'key': 'typeProperties.objectApiName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        object_api_name: Optional[object] = None,
        **kwargs
    ):
        super(SalesforceServiceCloudObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SalesforceServiceCloudObject'
        self.object_api_name = object_api_name


class SapBwCubeDataset(Dataset):
    """The SAP BW cube dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(SapBwCubeDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SapBwCube'


class SapBWLinkedService(LinkedService):
    """SAP Business Warehouse Linked Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param server: Required. Host name of the SAP BW instance. Type: string (or Expression with
     resultType string).
    :type server: object
    :param system_number: Required. System number of the BW system. (Usually a two-digit decimal
     number represented as a string.) Type: string (or Expression with resultType string).
    :type system_number: object
    :param client_id: Required. Client ID of the client on the BW system. (Usually a three-digit
     decimal number represented as a string) Type: string (or Expression with resultType string).
    :type client_id: object
    :param user_name: Username to access the SAP BW server. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password to access the SAP BW server.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
        'system_number': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'system_number': {'key': 'typeProperties.systemNumber', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        server: object,
        system_number: object,
        client_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SapBWLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'SapBW'
        self.server = server
        self.system_number = system_number
        self.client_id = client_id
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential


class SapCloudForCustomerLinkedService(LinkedService):
    """Linked service for SAP Cloud for Customer.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The URL of SAP Cloud for Customer OData API. For example,
     '[https://[tenantname].crm.ondemand.com/sap/c4c/odata/v1]'. Type: string (or Expression with
     resultType string).
    :type url: object
    :param username: The username for Basic authentication. Type: string (or Expression with
     resultType string).
    :type username: object
    :param password: The password for Basic authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Either encryptedCredential or
     username/password must be provided. Type: string (or Expression with resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        url: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SapCloudForCustomerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'SapCloudForCustomer'
        self.url = url
        self.username = username
        self.password = password
        self.encrypted_credential = encrypted_credential


class SapCloudForCustomerResourceDataset(Dataset):
    """The path of the SAP Cloud for Customer OData entity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param path: Required. The path of the SAP Cloud for Customer OData entity. Type: string (or
     Expression with resultType string).
    :type path: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'path': {'key': 'typeProperties.path', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(SapCloudForCustomerResourceDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SapCloudForCustomerResource'
        self.path = path


class SapEccLinkedService(LinkedService):
    """Linked service for SAP ERP Central Component(SAP ECC).

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The URL of SAP ECC OData API. For example,
     '[https://hostname:port/sap/opu/odata/sap/servicename/]'. Type: string (or Expression with
     resultType string).
    :type url: str
    :param username: The username for Basic authentication. Type: string (or Expression with
     resultType string).
    :type username: str
    :param password: The password for Basic authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Either encryptedCredential or
     username/password must be provided. Type: string (or Expression with resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'str'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: str,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        username: Optional[str] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        super(SapEccLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'SapEcc'
        self.url = url
        self.username = username
        self.password = password
        self.encrypted_credential = encrypted_credential


class SapEccResourceDataset(Dataset):
    """The path of the SAP ECC OData entity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param path: Required. The path of the SAP ECC OData entity. Type: string (or Expression with
     resultType string).
    :type path: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'path': {'key': 'typeProperties.path', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        path: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(SapEccResourceDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SapEccResource'
        self.path = path


class SapHanaLinkedService(LinkedService):
    """SAP HANA Linked Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: SAP HANA ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param server: Required. Host name of the SAP HANA server. Type: string (or Expression with
     resultType string).
    :type server: object
    :param authentication_type: The authentication type to be used to connect to the SAP HANA
     server. Possible values include: "Basic", "Windows".
    :type authentication_type: str or ~azure.synapse.artifacts.models.SapHanaAuthenticationType
    :param user_name: Username to access the SAP HANA server. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password to access the SAP HANA server.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        server: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        connection_string: Optional[object] = None,
        authentication_type: Optional[Union[str, "SapHanaAuthenticationType"]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SapHanaLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'SapHana'
        self.connection_string = connection_string
        self.server = server
        self.authentication_type = authentication_type
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential


class SapHanaTableDataset(Dataset):
    """SAP HANA Table properties.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param schema_type_properties_schema: The schema name of SAP HANA. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of SAP HANA. Type: string (or Expression with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(SapHanaTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SapHanaTable'
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class SapOpenHubLinkedService(LinkedService):
    """SAP Business Warehouse Open Hub Destination Linked Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param server: Required. Host name of the SAP BW instance where the open hub destination is
     located. Type: string (or Expression with resultType string).
    :type server: object
    :param system_number: Required. System number of the BW system where the open hub destination
     is located. (Usually a two-digit decimal number represented as a string.) Type: string (or
     Expression with resultType string).
    :type system_number: object
    :param client_id: Required. Client ID of the client on the BW system where the open hub
     destination is located. (Usually a three-digit decimal number represented as a string) Type:
     string (or Expression with resultType string).
    :type client_id: object
    :param language: Language of the BW system where the open hub destination is located. The
     default value is EN. Type: string (or Expression with resultType string).
    :type language: object
    :param user_name: Username to access the SAP BW server where the open hub destination is
     located. Type: string (or Expression with resultType string).
    :type user_name: object
    :param password: Password to access the SAP BW server where the open hub destination is
     located.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
        'system_number': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'system_number': {'key': 'typeProperties.systemNumber', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'language': {'key': 'typeProperties.language', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        server: object,
        system_number: object,
        client_id: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        language: Optional[object] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SapOpenHubLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'SapOpenHub'
        self.server = server
        self.system_number = system_number
        self.client_id = client_id
        self.language = language
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential


class SapOpenHubTableDataset(Dataset):
    """Sap Business Warehouse Open Hub Destination Table properties.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param open_hub_destination_name: Required. The name of the Open Hub Destination with
     destination type as Database Table. Type: string (or Expression with resultType string).
    :type open_hub_destination_name: object
    :param exclude_last_request: Whether to exclude the records of the last request. The default
     value is true. Type: boolean (or Expression with resultType boolean).
    :type exclude_last_request: object
    :param base_request_id: The ID of request for delta loading. Once it is set, only data with
     requestId larger than the value of this property will be retrieved. The default value is 0.
     Type: integer (or Expression with resultType integer ).
    :type base_request_id: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'open_hub_destination_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'open_hub_destination_name': {'key': 'typeProperties.openHubDestinationName', 'type': 'object'},
        'exclude_last_request': {'key': 'typeProperties.excludeLastRequest', 'type': 'object'},
        'base_request_id': {'key': 'typeProperties.baseRequestId', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        open_hub_destination_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        exclude_last_request: Optional[object] = None,
        base_request_id: Optional[object] = None,
        **kwargs
    ):
        super(SapOpenHubTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SapOpenHubTable'
        self.open_hub_destination_name = open_hub_destination_name
        self.exclude_last_request = exclude_last_request
        self.base_request_id = base_request_id


class SapTableLinkedService(LinkedService):
    """SAP Table Linked Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param server: Host name of the SAP instance where the table is located. Type: string (or
     Expression with resultType string).
    :type server: object
    :param system_number: System number of the SAP system where the table is located. (Usually a
     two-digit decimal number represented as a string.) Type: string (or Expression with resultType
     string).
    :type system_number: object
    :param client_id: Client ID of the client on the SAP system where the table is located.
     (Usually a three-digit decimal number represented as a string) Type: string (or Expression with
     resultType string).
    :type client_id: object
    :param language: Language of the SAP system where the table is located. The default value is
     EN. Type: string (or Expression with resultType string).
    :type language: object
    :param system_id: SystemID of the SAP system where the table is located. Type: string (or
     Expression with resultType string).
    :type system_id: object
    :param user_name: Username to access the SAP server where the table is located. Type: string
     (or Expression with resultType string).
    :type user_name: object
    :param password: Password to access the SAP server where the table is located.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param message_server: The hostname of the SAP Message Server. Type: string (or Expression with
     resultType string).
    :type message_server: object
    :param message_server_service: The service name or port number of the Message Server. Type:
     string (or Expression with resultType string).
    :type message_server_service: object
    :param snc_mode: SNC activation indicator to access the SAP server where the table is located.
     Must be either 0 (off) or 1 (on). Type: string (or Expression with resultType string).
    :type snc_mode: object
    :param snc_my_name: Initiator's SNC name to access the SAP server where the table is located.
     Type: string (or Expression with resultType string).
    :type snc_my_name: object
    :param snc_partner_name: Communication partner's SNC name to access the SAP server where the
     table is located. Type: string (or Expression with resultType string).
    :type snc_partner_name: object
    :param snc_library_path: External security product's library to access the SAP server where the
     table is located. Type: string (or Expression with resultType string).
    :type snc_library_path: object
    :param snc_qop: SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string
     (or Expression with resultType string).
    :type snc_qop: object
    :param logon_group: The Logon Group for the SAP System. Type: string (or Expression with
     resultType string).
    :type logon_group: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'system_number': {'key': 'typeProperties.systemNumber', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'language': {'key': 'typeProperties.language', 'type': 'object'},
        'system_id': {'key': 'typeProperties.systemId', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'message_server': {'key': 'typeProperties.messageServer', 'type': 'object'},
        'message_server_service': {'key': 'typeProperties.messageServerService', 'type': 'object'},
        'snc_mode': {'key': 'typeProperties.sncMode', 'type': 'object'},
        'snc_my_name': {'key': 'typeProperties.sncMyName', 'type': 'object'},
        'snc_partner_name': {'key': 'typeProperties.sncPartnerName', 'type': 'object'},
        'snc_library_path': {'key': 'typeProperties.sncLibraryPath', 'type': 'object'},
        'snc_qop': {'key': 'typeProperties.sncQop', 'type': 'object'},
        'logon_group': {'key': 'typeProperties.logonGroup', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        server: Optional[object] = None,
        system_number: Optional[object] = None,
        client_id: Optional[object] = None,
        language: Optional[object] = None,
        system_id: Optional[object] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        message_server: Optional[object] = None,
        message_server_service: Optional[object] = None,
        snc_mode: Optional[object] = None,
        snc_my_name: Optional[object] = None,
        snc_partner_name: Optional[object] = None,
        snc_library_path: Optional[object] = None,
        snc_qop: Optional[object] = None,
        logon_group: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SapTableLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'SapTable'
        self.server = server
        self.system_number = system_number
        self.client_id = client_id
        self.language = language
        self.system_id = system_id
        self.user_name = user_name
        self.password = password
        self.message_server = message_server
        self.message_server_service = message_server_service
        self.snc_mode = snc_mode
        self.snc_my_name = snc_my_name
        self.snc_partner_name = snc_partner_name
        self.snc_library_path = snc_library_path
        self.snc_qop = snc_qop
        self.logon_group = logon_group
        self.encrypted_credential = encrypted_credential


class SapTableResourceDataset(Dataset):
    """SAP Table Resource properties.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: Required. The name of the SAP Table. Type: string (or Expression with
     resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'table_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        table_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        **kwargs
    ):
        super(SapTableResourceDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SapTableResource'
        self.table_name = table_name


class ScriptAction(msrest.serialization.Model):
    """Custom script action to run on HDI ondemand cluster once it's up.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The user provided name of the script action.
    :type name: str
    :param uri: Required. The URI for the script action.
    :type uri: str
    :param roles: Required. The node types on which the script action should be executed. Possible
     values include: "Headnode", "Workernode", "Zookeeper".
    :type roles: str or ~azure.synapse.artifacts.models.HdiNodeTypes
    :param parameters: The parameters for the script action.
    :type parameters: str
    """

    _validation = {
        'name': {'required': True},
        'uri': {'required': True},
        'roles': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'roles': {'key': 'roles', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        uri: str,
        roles: Union[str, "HdiNodeTypes"],
        parameters: Optional[str] = None,
        **kwargs
    ):
        super(ScriptAction, self).__init__(**kwargs)
        self.name = name
        self.uri = uri
        self.roles = roles
        self.parameters = parameters


class SecureString(SecretBase):
    """Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    :param value: Required. Value of secure string.
    :type value: str
    """

    _validation = {
        'type': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        **kwargs
    ):
        super(SecureString, self).__init__(**kwargs)
        self.type: str = 'SecureString'
        self.value = value


class ServiceNowLinkedService(LinkedService):
    """ServiceNow server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the ServiceNow server. (i.e.
     :code:`<instance>`.service-now.com).
    :type endpoint: object
    :param authentication_type: Required. The authentication type to use. Possible values include:
     "Basic", "OAuth2".
    :type authentication_type: str or ~azure.synapse.artifacts.models.ServiceNowAuthenticationType
    :param username: The user name used to connect to the ServiceNow server for Basic and OAuth2
     authentication.
    :type username: object
    :param password: The password corresponding to the user name for Basic and OAuth2
     authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param client_id: The client id for OAuth2 authentication.
    :type client_id: object
    :param client_secret: The client secret for OAuth2 authentication.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        endpoint: object,
        authentication_type: Union[str, "ServiceNowAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        client_id: Optional[object] = None,
        client_secret: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(ServiceNowLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'ServiceNow'
        self.endpoint = endpoint
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.client_id = client_id
        self.client_secret = client_secret
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class ServiceNowObjectDataset(Dataset):
    """ServiceNow server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(ServiceNowObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'ServiceNowObject'
        self.table_name = table_name


class SetVariableActivity(Activity):
    """Set value for a Variable.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param variable_name: Name of the variable whose value needs to be set.
    :type variable_name: str
    :param value: Value to be set. Could be a static value or Expression.
    :type value: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'variable_name': {'key': 'typeProperties.variableName', 'type': 'str'},
        'value': {'key': 'typeProperties.value', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        variable_name: Optional[str] = None,
        value: Optional[object] = None,
        **kwargs
    ):
        super(SetVariableActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, **kwargs)
        self.type: str = 'SetVariable'
        self.variable_name = variable_name
        self.value = value


class SftpServerLinkedService(LinkedService):
    """A linked service for an SSH File Transfer Protocol (SFTP) server.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The SFTP server host name. Type: string (or Expression with resultType
     string).
    :type host: object
    :param port: The TCP port number that the SFTP server uses to listen for client connections.
     Default value is 22. Type: integer (or Expression with resultType integer), minimum: 0.
    :type port: object
    :param authentication_type: The authentication type to be used to connect to the FTP server.
     Possible values include: "Basic", "SshPublicKey".
    :type authentication_type: str or ~azure.synapse.artifacts.models.SftpAuthenticationType
    :param user_name: The username used to log on to the SFTP server. Type: string (or Expression
     with resultType string).
    :type user_name: object
    :param password: Password to logon the SFTP server for Basic authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param private_key_path: The SSH private key file path for SshPublicKey authentication. Only
     valid for on-premises copy. For on-premises copy with SshPublicKey authentication, either
     PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH
     format. Type: string (or Expression with resultType string).
    :type private_key_path: object
    :param private_key_content: Base64 encoded SSH private key content for SshPublicKey
     authentication. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or
     PrivateKeyContent should be specified. SSH private key should be OpenSSH format.
    :type private_key_content: ~azure.synapse.artifacts.models.SecretBase
    :param pass_phrase: The password to decrypt the SSH private key if the SSH private key is
     encrypted.
    :type pass_phrase: ~azure.synapse.artifacts.models.SecretBase
    :param skip_host_key_validation: If true, skip the SSH host key validation. Default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type skip_host_key_validation: object
    :param host_key_fingerprint: The host key finger-print of the SFTP server. When
     SkipHostKeyValidation is false, HostKeyFingerprint should be specified. Type: string (or
     Expression with resultType string).
    :type host_key_fingerprint: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'private_key_path': {'key': 'typeProperties.privateKeyPath', 'type': 'object'},
        'private_key_content': {'key': 'typeProperties.privateKeyContent', 'type': 'SecretBase'},
        'pass_phrase': {'key': 'typeProperties.passPhrase', 'type': 'SecretBase'},
        'skip_host_key_validation': {'key': 'typeProperties.skipHostKeyValidation', 'type': 'object'},
        'host_key_fingerprint': {'key': 'typeProperties.hostKeyFingerprint', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        port: Optional[object] = None,
        authentication_type: Optional[Union[str, "SftpAuthenticationType"]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        private_key_path: Optional[object] = None,
        private_key_content: Optional["SecretBase"] = None,
        pass_phrase: Optional["SecretBase"] = None,
        skip_host_key_validation: Optional[object] = None,
        host_key_fingerprint: Optional[object] = None,
        **kwargs
    ):
        super(SftpServerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Sftp'
        self.host = host
        self.port = port
        self.authentication_type = authentication_type
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential
        self.private_key_path = private_key_path
        self.private_key_content = private_key_content
        self.pass_phrase = pass_phrase
        self.skip_host_key_validation = skip_host_key_validation
        self.host_key_fingerprint = host_key_fingerprint


class ShopifyLinkedService(LinkedService):
    """Shopify Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The endpoint of the Shopify server. (i.e. mystore.myshopify.com).
    :type host: object
    :param access_token: The API access token that can be used to access Shopify’s data. The token
     won't expire if it is offline mode.
    :type access_token: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        access_token: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(ShopifyLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Shopify'
        self.host = host
        self.access_token = access_token
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class ShopifyObjectDataset(Dataset):
    """Shopify Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        **kwargs
    ):
        super(ShopifyObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'ShopifyObject'
        self.table_name = table_name


class SparkBatchJob(msrest.serialization.Model):
    """SparkBatchJob.

    All required parameters must be populated in order to send to Azure.

    :param livy_info:
    :type livy_info: ~azure.synapse.artifacts.models.SparkBatchJobState
    :param name: The batch name.
    :type name: str
    :param workspace_name: The workspace name.
    :type workspace_name: str
    :param spark_pool_name: The Spark pool name.
    :type spark_pool_name: str
    :param submitter_name: The submitter name.
    :type submitter_name: str
    :param submitter_id: The submitter identifier.
    :type submitter_id: str
    :param artifact_id: The artifact identifier.
    :type artifact_id: str
    :param job_type: The job type. Possible values include: "SparkBatch", "SparkSession".
    :type job_type: str or ~azure.synapse.artifacts.models.SparkJobType
    :param result: The Spark batch job result. Possible values include: "Uncertain", "Succeeded",
     "Failed", "Cancelled".
    :type result: str or ~azure.synapse.artifacts.models.SparkBatchJobResultType
    :param scheduler: The scheduler information.
    :type scheduler: ~azure.synapse.artifacts.models.SparkScheduler
    :param plugin: The plugin information.
    :type plugin: ~azure.synapse.artifacts.models.SparkServicePlugin
    :param errors: The error information.
    :type errors: list[~azure.synapse.artifacts.models.SparkServiceError]
    :param tags: A set of tags. The tags.
    :type tags: dict[str, str]
    :param id: Required. The session Id.
    :type id: int
    :param app_id: The application id of this session.
    :type app_id: str
    :param app_info: The detailed application info.
    :type app_info: dict[str, str]
    :param state: The batch state.
    :type state: str
    :param log_lines: The log lines.
    :type log_lines: list[str]
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'livy_info': {'key': 'livyInfo', 'type': 'SparkBatchJobState'},
        'name': {'key': 'name', 'type': 'str'},
        'workspace_name': {'key': 'workspaceName', 'type': 'str'},
        'spark_pool_name': {'key': 'sparkPoolName', 'type': 'str'},
        'submitter_name': {'key': 'submitterName', 'type': 'str'},
        'submitter_id': {'key': 'submitterId', 'type': 'str'},
        'artifact_id': {'key': 'artifactId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'result': {'key': 'result', 'type': 'str'},
        'scheduler': {'key': 'schedulerInfo', 'type': 'SparkScheduler'},
        'plugin': {'key': 'pluginInfo', 'type': 'SparkServicePlugin'},
        'errors': {'key': 'errorInfo', 'type': '[SparkServiceError]'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'id': {'key': 'id', 'type': 'int'},
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_info': {'key': 'appInfo', 'type': '{str}'},
        'state': {'key': 'state', 'type': 'str'},
        'log_lines': {'key': 'log', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: int,
        livy_info: Optional["SparkBatchJobState"] = None,
        name: Optional[str] = None,
        workspace_name: Optional[str] = None,
        spark_pool_name: Optional[str] = None,
        submitter_name: Optional[str] = None,
        submitter_id: Optional[str] = None,
        artifact_id: Optional[str] = None,
        job_type: Optional[Union[str, "SparkJobType"]] = None,
        result: Optional[Union[str, "SparkBatchJobResultType"]] = None,
        scheduler: Optional["SparkScheduler"] = None,
        plugin: Optional["SparkServicePlugin"] = None,
        errors: Optional[List["SparkServiceError"]] = None,
        tags: Optional[Dict[str, str]] = None,
        app_id: Optional[str] = None,
        app_info: Optional[Dict[str, str]] = None,
        state: Optional[str] = None,
        log_lines: Optional[List[str]] = None,
        **kwargs
    ):
        super(SparkBatchJob, self).__init__(**kwargs)
        self.livy_info = livy_info
        self.name = name
        self.workspace_name = workspace_name
        self.spark_pool_name = spark_pool_name
        self.submitter_name = submitter_name
        self.submitter_id = submitter_id
        self.artifact_id = artifact_id
        self.job_type = job_type
        self.result = result
        self.scheduler = scheduler
        self.plugin = plugin
        self.errors = errors
        self.tags = tags
        self.id = id
        self.app_id = app_id
        self.app_info = app_info
        self.state = state
        self.log_lines = log_lines


class SparkBatchJobState(msrest.serialization.Model):
    """SparkBatchJobState.

    :param not_started_at: the time that at which "not_started" livy state was first seen.
    :type not_started_at: ~datetime.datetime
    :param starting_at: the time that at which "starting" livy state was first seen.
    :type starting_at: ~datetime.datetime
    :param running_at: the time that at which "running" livy state was first seen.
    :type running_at: ~datetime.datetime
    :param dead_at: time that at which "dead" livy state was first seen.
    :type dead_at: ~datetime.datetime
    :param success_at: the time that at which "success" livy state was first seen.
    :type success_at: ~datetime.datetime
    :param terminated_at: the time that at which "killed" livy state was first seen.
    :type terminated_at: ~datetime.datetime
    :param recovering_at: the time that at which "recovering" livy state was first seen.
    :type recovering_at: ~datetime.datetime
    :param current_state: the Spark job state.
    :type current_state: str
    :param job_creation_request:
    :type job_creation_request: ~azure.synapse.artifacts.models.SparkRequest
    """

    _attribute_map = {
        'not_started_at': {'key': 'notStartedAt', 'type': 'iso-8601'},
        'starting_at': {'key': 'startingAt', 'type': 'iso-8601'},
        'running_at': {'key': 'runningAt', 'type': 'iso-8601'},
        'dead_at': {'key': 'deadAt', 'type': 'iso-8601'},
        'success_at': {'key': 'successAt', 'type': 'iso-8601'},
        'terminated_at': {'key': 'killedAt', 'type': 'iso-8601'},
        'recovering_at': {'key': 'recoveringAt', 'type': 'iso-8601'},
        'current_state': {'key': 'currentState', 'type': 'str'},
        'job_creation_request': {'key': 'jobCreationRequest', 'type': 'SparkRequest'},
    }

    def __init__(
        self,
        *,
        not_started_at: Optional[datetime.datetime] = None,
        starting_at: Optional[datetime.datetime] = None,
        running_at: Optional[datetime.datetime] = None,
        dead_at: Optional[datetime.datetime] = None,
        success_at: Optional[datetime.datetime] = None,
        terminated_at: Optional[datetime.datetime] = None,
        recovering_at: Optional[datetime.datetime] = None,
        current_state: Optional[str] = None,
        job_creation_request: Optional["SparkRequest"] = None,
        **kwargs
    ):
        super(SparkBatchJobState, self).__init__(**kwargs)
        self.not_started_at = not_started_at
        self.starting_at = starting_at
        self.running_at = running_at
        self.dead_at = dead_at
        self.success_at = success_at
        self.terminated_at = terminated_at
        self.recovering_at = recovering_at
        self.current_state = current_state
        self.job_creation_request = job_creation_request


class SparkJobDefinition(msrest.serialization.Model):
    """Spark job definition.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param description: The description of the Spark job definition.
    :type description: str
    :param target_big_data_pool: Required. Big data pool reference.
    :type target_big_data_pool: ~azure.synapse.artifacts.models.BigDataPoolReference
    :param required_spark_version: The required Spark version of the application.
    :type required_spark_version: str
    :param language: The language of the Spark application.
    :type language: str
    :param job_properties: Required. The properties of the Spark job.
    :type job_properties: ~azure.synapse.artifacts.models.SparkJobProperties
    """

    _validation = {
        'target_big_data_pool': {'required': True},
        'job_properties': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'target_big_data_pool': {'key': 'targetBigDataPool', 'type': 'BigDataPoolReference'},
        'required_spark_version': {'key': 'requiredSparkVersion', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
        'job_properties': {'key': 'jobProperties', 'type': 'SparkJobProperties'},
    }

    def __init__(
        self,
        *,
        target_big_data_pool: "BigDataPoolReference",
        job_properties: "SparkJobProperties",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        required_spark_version: Optional[str] = None,
        language: Optional[str] = None,
        **kwargs
    ):
        super(SparkJobDefinition, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.description = description
        self.target_big_data_pool = target_big_data_pool
        self.required_spark_version = required_spark_version
        self.language = language
        self.job_properties = job_properties


class SparkJobDefinitionResource(SubResource):
    """Spark job definition resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Properties of spark job definition.
    :type properties: ~azure.synapse.artifacts.models.SparkJobDefinition
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'SparkJobDefinition'},
    }

    def __init__(
        self,
        *,
        properties: "SparkJobDefinition",
        **kwargs
    ):
        super(SparkJobDefinitionResource, self).__init__(**kwargs)
        self.properties = properties


class SparkJobDefinitionsListResponse(msrest.serialization.Model):
    """A list of spark job definitions resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of spark job definitions.
    :type value: list[~azure.synapse.artifacts.models.SparkJobDefinitionResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SparkJobDefinitionResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SparkJobDefinitionResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SparkJobDefinitionsListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SparkJobProperties(msrest.serialization.Model):
    """The properties of the Spark job.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: The name of the job.
    :type name: str
    :param file: Required. File containing the application to execute.
    :type file: str
    :param class_name: Main class for Java/Scala application.
    :type class_name: str
    :param conf: Spark configuration properties.
    :type conf: object
    :param args: Command line arguments for the application.
    :type args: list[str]
    :param jars: Jars to be used in this job.
    :type jars: list[str]
    :param files: files to be used in this job.
    :type files: list[str]
    :param archives: Archives to be used in this job.
    :type archives: list[str]
    :param driver_memory: Required. Amount of memory to use for the driver process.
    :type driver_memory: str
    :param driver_cores: Required. Number of cores to use for the driver.
    :type driver_cores: int
    :param executor_memory: Required. Amount of memory to use per executor process.
    :type executor_memory: str
    :param executor_cores: Required. Number of cores to use for each executor.
    :type executor_cores: int
    :param num_executors: Required. Number of executors to launch for this job.
    :type num_executors: int
    """

    _validation = {
        'file': {'required': True},
        'driver_memory': {'required': True},
        'driver_cores': {'required': True},
        'executor_memory': {'required': True},
        'executor_cores': {'required': True},
        'num_executors': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'class_name': {'key': 'className', 'type': 'str'},
        'conf': {'key': 'conf', 'type': 'object'},
        'args': {'key': 'args', 'type': '[str]'},
        'jars': {'key': 'jars', 'type': '[str]'},
        'files': {'key': 'files', 'type': '[str]'},
        'archives': {'key': 'archives', 'type': '[str]'},
        'driver_memory': {'key': 'driverMemory', 'type': 'str'},
        'driver_cores': {'key': 'driverCores', 'type': 'int'},
        'executor_memory': {'key': 'executorMemory', 'type': 'str'},
        'executor_cores': {'key': 'executorCores', 'type': 'int'},
        'num_executors': {'key': 'numExecutors', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        file: str,
        driver_memory: str,
        driver_cores: int,
        executor_memory: str,
        executor_cores: int,
        num_executors: int,
        additional_properties: Optional[Dict[str, object]] = None,
        name: Optional[str] = None,
        class_name: Optional[str] = None,
        conf: Optional[object] = None,
        args: Optional[List[str]] = None,
        jars: Optional[List[str]] = None,
        files: Optional[List[str]] = None,
        archives: Optional[List[str]] = None,
        **kwargs
    ):
        super(SparkJobProperties, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.file = file
        self.class_name = class_name
        self.conf = conf
        self.args = args
        self.jars = jars
        self.files = files
        self.archives = archives
        self.driver_memory = driver_memory
        self.driver_cores = driver_cores
        self.executor_memory = executor_memory
        self.executor_cores = executor_cores
        self.num_executors = num_executors


class SparkLinkedService(LinkedService):
    """Spark Server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. IP address or host name of the Spark server.
    :type host: object
    :param port: Required. The TCP port that the Spark server uses to listen for client
     connections.
    :type port: object
    :param server_type: The type of Spark server. Possible values include: "SharkServer",
     "SharkServer2", "SparkThriftServer".
    :type server_type: str or ~azure.synapse.artifacts.models.SparkServerType
    :param thrift_transport_protocol: The transport protocol to use in the Thrift layer. Possible
     values include: "Binary", "SASL", "HTTP ".
    :type thrift_transport_protocol: str or
     ~azure.synapse.artifacts.models.SparkThriftTransportProtocol
    :param authentication_type: Required. The authentication method used to access the Spark
     server. Possible values include: "Anonymous", "Username", "UsernameAndPassword",
     "WindowsAzureHDInsightService".
    :type authentication_type: str or ~azure.synapse.artifacts.models.SparkAuthenticationType
    :param username: The user name that you use to access Spark Server.
    :type username: object
    :param password: The password corresponding to the user name that you provided in the Username
     field.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param http_path: The partial URL corresponding to the Spark server.
    :type http_path: object
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'port': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'server_type': {'key': 'typeProperties.serverType', 'type': 'str'},
        'thrift_transport_protocol': {'key': 'typeProperties.thriftTransportProtocol', 'type': 'str'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'http_path': {'key': 'typeProperties.httpPath', 'type': 'object'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        port: object,
        authentication_type: Union[str, "SparkAuthenticationType"],
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        server_type: Optional[Union[str, "SparkServerType"]] = None,
        thrift_transport_protocol: Optional[Union[str, "SparkThriftTransportProtocol"]] = None,
        username: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        http_path: Optional[object] = None,
        enable_ssl: Optional[object] = None,
        trusted_cert_path: Optional[object] = None,
        use_system_trust_store: Optional[object] = None,
        allow_host_name_cn_mismatch: Optional[object] = None,
        allow_self_signed_server_cert: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SparkLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Spark'
        self.host = host
        self.port = port
        self.server_type = server_type
        self.thrift_transport_protocol = thrift_transport_protocol
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.http_path = http_path
        self.enable_ssl = enable_ssl
        self.trusted_cert_path = trusted_cert_path
        self.use_system_trust_store = use_system_trust_store
        self.allow_host_name_cn_mismatch = allow_host_name_cn_mismatch
        self.allow_self_signed_server_cert = allow_self_signed_server_cert
        self.encrypted_credential = encrypted_credential


class SparkObjectDataset(Dataset):
    """Spark Server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Spark. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Spark. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        table: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        **kwargs
    ):
        super(SparkObjectDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SparkObject'
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class SparkRequest(msrest.serialization.Model):
    """SparkRequest.

    :param name:
    :type name: str
    :param file:
    :type file: str
    :param class_name:
    :type class_name: str
    :param arguments:
    :type arguments: list[str]
    :param jars:
    :type jars: list[str]
    :param python_files:
    :type python_files: list[str]
    :param files:
    :type files: list[str]
    :param archives:
    :type archives: list[str]
    :param configuration: Dictionary of :code:`<string>`.
    :type configuration: dict[str, str]
    :param driver_memory:
    :type driver_memory: str
    :param driver_cores:
    :type driver_cores: int
    :param executor_memory:
    :type executor_memory: str
    :param executor_cores:
    :type executor_cores: int
    :param executor_count:
    :type executor_count: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'class_name': {'key': 'className', 'type': 'str'},
        'arguments': {'key': 'args', 'type': '[str]'},
        'jars': {'key': 'jars', 'type': '[str]'},
        'python_files': {'key': 'pyFiles', 'type': '[str]'},
        'files': {'key': 'files', 'type': '[str]'},
        'archives': {'key': 'archives', 'type': '[str]'},
        'configuration': {'key': 'conf', 'type': '{str}'},
        'driver_memory': {'key': 'driverMemory', 'type': 'str'},
        'driver_cores': {'key': 'driverCores', 'type': 'int'},
        'executor_memory': {'key': 'executorMemory', 'type': 'str'},
        'executor_cores': {'key': 'executorCores', 'type': 'int'},
        'executor_count': {'key': 'numExecutors', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        file: Optional[str] = None,
        class_name: Optional[str] = None,
        arguments: Optional[List[str]] = None,
        jars: Optional[List[str]] = None,
        python_files: Optional[List[str]] = None,
        files: Optional[List[str]] = None,
        archives: Optional[List[str]] = None,
        configuration: Optional[Dict[str, str]] = None,
        driver_memory: Optional[str] = None,
        driver_cores: Optional[int] = None,
        executor_memory: Optional[str] = None,
        executor_cores: Optional[int] = None,
        executor_count: Optional[int] = None,
        **kwargs
    ):
        super(SparkRequest, self).__init__(**kwargs)
        self.name = name
        self.file = file
        self.class_name = class_name
        self.arguments = arguments
        self.jars = jars
        self.python_files = python_files
        self.files = files
        self.archives = archives
        self.configuration = configuration
        self.driver_memory = driver_memory
        self.driver_cores = driver_cores
        self.executor_memory = executor_memory
        self.executor_cores = executor_cores
        self.executor_count = executor_count


class SparkScheduler(msrest.serialization.Model):
    """SparkScheduler.

    :param submitted_at:
    :type submitted_at: ~datetime.datetime
    :param scheduled_at:
    :type scheduled_at: ~datetime.datetime
    :param ended_at:
    :type ended_at: ~datetime.datetime
    :param cancellation_requested_at:
    :type cancellation_requested_at: ~datetime.datetime
    :param current_state:  Possible values include: "Queued", "Scheduled", "Ended".
    :type current_state: str or ~azure.synapse.artifacts.models.SchedulerCurrentState
    """

    _attribute_map = {
        'submitted_at': {'key': 'submittedAt', 'type': 'iso-8601'},
        'scheduled_at': {'key': 'scheduledAt', 'type': 'iso-8601'},
        'ended_at': {'key': 'endedAt', 'type': 'iso-8601'},
        'cancellation_requested_at': {'key': 'cancellationRequestedAt', 'type': 'iso-8601'},
        'current_state': {'key': 'currentState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        submitted_at: Optional[datetime.datetime] = None,
        scheduled_at: Optional[datetime.datetime] = None,
        ended_at: Optional[datetime.datetime] = None,
        cancellation_requested_at: Optional[datetime.datetime] = None,
        current_state: Optional[Union[str, "SchedulerCurrentState"]] = None,
        **kwargs
    ):
        super(SparkScheduler, self).__init__(**kwargs)
        self.submitted_at = submitted_at
        self.scheduled_at = scheduled_at
        self.ended_at = ended_at
        self.cancellation_requested_at = cancellation_requested_at
        self.current_state = current_state


class SparkServiceError(msrest.serialization.Model):
    """SparkServiceError.

    :param message:
    :type message: str
    :param error_code:
    :type error_code: str
    :param source:  Possible values include: "System", "User", "Unknown", "Dependency".
    :type source: str or ~azure.synapse.artifacts.models.SparkErrorSource
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        error_code: Optional[str] = None,
        source: Optional[Union[str, "SparkErrorSource"]] = None,
        **kwargs
    ):
        super(SparkServiceError, self).__init__(**kwargs)
        self.message = message
        self.error_code = error_code
        self.source = source


class SparkServicePlugin(msrest.serialization.Model):
    """SparkServicePlugin.

    :param preparation_started_at:
    :type preparation_started_at: ~datetime.datetime
    :param resource_acquisition_started_at:
    :type resource_acquisition_started_at: ~datetime.datetime
    :param submission_started_at:
    :type submission_started_at: ~datetime.datetime
    :param monitoring_started_at:
    :type monitoring_started_at: ~datetime.datetime
    :param cleanup_started_at:
    :type cleanup_started_at: ~datetime.datetime
    :param current_state:  Possible values include: "Preparation", "ResourceAcquisition", "Queued",
     "Submission", "Monitoring", "Cleanup", "Ended".
    :type current_state: str or ~azure.synapse.artifacts.models.PluginCurrentState
    """

    _attribute_map = {
        'preparation_started_at': {'key': 'preparationStartedAt', 'type': 'iso-8601'},
        'resource_acquisition_started_at': {'key': 'resourceAcquisitionStartedAt', 'type': 'iso-8601'},
        'submission_started_at': {'key': 'submissionStartedAt', 'type': 'iso-8601'},
        'monitoring_started_at': {'key': 'monitoringStartedAt', 'type': 'iso-8601'},
        'cleanup_started_at': {'key': 'cleanupStartedAt', 'type': 'iso-8601'},
        'current_state': {'key': 'currentState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        preparation_started_at: Optional[datetime.datetime] = None,
        resource_acquisition_started_at: Optional[datetime.datetime] = None,
        submission_started_at: Optional[datetime.datetime] = None,
        monitoring_started_at: Optional[datetime.datetime] = None,
        cleanup_started_at: Optional[datetime.datetime] = None,
        current_state: Optional[Union[str, "PluginCurrentState"]] = None,
        **kwargs
    ):
        super(SparkServicePlugin, self).__init__(**kwargs)
        self.preparation_started_at = preparation_started_at
        self.resource_acquisition_started_at = resource_acquisition_started_at
        self.submission_started_at = submission_started_at
        self.monitoring_started_at = monitoring_started_at
        self.cleanup_started_at = cleanup_started_at
        self.current_state = current_state


class SqlConnection(msrest.serialization.Model):
    """The connection used to execute the SQL script.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The type of the connection. Possible values include: "SqlOnDemand",
     "SqlPool".
    :type type: str or ~azure.synapse.artifacts.models.SqlConnectionType
    :param name: Required. The identifier of the connection.
    :type name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "SqlConnectionType"],
        name: str,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(SqlConnection, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = type
        self.name = name


class SqlScript(msrest.serialization.Model):
    """SQL script.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param description: The description of the SQL script.
    :type description: str
    :ivar type: The type of the SQL script. Default value: "SqlQuery".
    :vartype type: str
    :param content: Required. The content of the SQL script.
    :type content: ~azure.synapse.artifacts.models.SqlScriptContent
    """

    _validation = {
        'type': {'constant': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'content': {'key': 'content', 'type': 'SqlScriptContent'},
    }

    type = "SqlQuery"

    def __init__(
        self,
        *,
        content: "SqlScriptContent",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(SqlScript, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.description = description
        self.content = content


class SqlScriptContent(msrest.serialization.Model):
    """The content of the SQL script.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param query: Required. SQL query to execute.
    :type query: str
    :param current_connection: Required. The connection used to execute the SQL script.
    :type current_connection: ~azure.synapse.artifacts.models.SqlConnection
    :param metadata: The metadata of the SQL script.
    :type metadata: ~azure.synapse.artifacts.models.SqlScriptMetadata
    """

    _validation = {
        'query': {'required': True},
        'current_connection': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'query': {'key': 'query', 'type': 'str'},
        'current_connection': {'key': 'currentConnection', 'type': 'SqlConnection'},
        'metadata': {'key': 'metadata', 'type': 'SqlScriptMetadata'},
    }

    def __init__(
        self,
        *,
        query: str,
        current_connection: "SqlConnection",
        additional_properties: Optional[Dict[str, object]] = None,
        metadata: Optional["SqlScriptMetadata"] = None,
        **kwargs
    ):
        super(SqlScriptContent, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.query = query
        self.current_connection = current_connection
        self.metadata = metadata


class SqlScriptMetadata(msrest.serialization.Model):
    """The metadata of the SQL script.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param language: The language of the SQL script.
    :type language: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        language: Optional[str] = None,
        **kwargs
    ):
        super(SqlScriptMetadata, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.language = language


class SqlScriptResource(SubResource):
    """Sql Script resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Properties of sql script.
    :type properties: ~azure.synapse.artifacts.models.SqlScript
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'SqlScript'},
    }

    def __init__(
        self,
        *,
        properties: "SqlScript",
        **kwargs
    ):
        super(SqlScriptResource, self).__init__(**kwargs)
        self.properties = properties


class SqlScriptsListResponse(msrest.serialization.Model):
    """A list of sql scripts resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of sql scripts.
    :type value: list[~azure.synapse.artifacts.models.SqlScriptResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlScriptResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SqlScriptResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SqlScriptsListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SqlServerLinkedService(LinkedService):
    """SQL Server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param user_name: The on-premises Windows authentication user name. Type: string (or Expression
     with resultType string).
    :type user_name: object
    :param password: The on-premises Windows authentication password.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        connection_string: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        user_name: Optional[object] = None,
        password: Optional["SecretBase"] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SqlServerLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'SqlServer'
        self.connection_string = connection_string
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential


class SqlServerStoredProcedureActivity(ExecutionActivity):
    """SQL stored procedure activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param stored_procedure_name: Required. Stored procedure name. Type: string (or Expression with
     resultType string).
    :type stored_procedure_name: object
    :param stored_procedure_parameters: Value and type setting for stored procedure parameters.
     Example: "{Parameter1: {value: "1", type: "int"}}".
    :type stored_procedure_parameters: dict[str,
     ~azure.synapse.artifacts.models.StoredProcedureParameter]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'stored_procedure_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'stored_procedure_name': {'key': 'typeProperties.storedProcedureName', 'type': 'object'},
        'stored_procedure_parameters': {'key': 'typeProperties.storedProcedureParameters', 'type': '{StoredProcedureParameter}'},
    }

    def __init__(
        self,
        *,
        name: str,
        stored_procedure_name: object,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["ActivityDependency"]] = None,
        user_properties: Optional[List["UserProperty"]] = None,
        linked_service_name: Optional["LinkedServiceReference"] = None,
        policy: Optional["ActivityPolicy"] = None,
        stored_procedure_parameters: Optional[Dict[str, "StoredProcedureParameter"]] = None,
        **kwargs
    ):
        super(SqlServerStoredProcedureActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, user_properties=user_properties, linked_service_name=linked_service_name, policy=policy, **kwargs)
        self.type: str = 'SqlServerStoredProcedure'
        self.stored_procedure_name = stored_procedure_name
        self.stored_procedure_parameters = stored_procedure_parameters


class SqlServerTableDataset(Dataset):
    """The on-premises SQL Server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the SQL Server dataset. Type: string
     (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the SQL Server dataset. Type: string (or Expression with
     resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        linked_service_name: "LinkedServiceReference",
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        structure: Optional[object] = None,
        schema: Optional[object] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        folder: Optional["DatasetFolder"] = None,
        table_name: Optional[object] = None,
        schema_type_properties_schema: Optional[object] = None,
        table: Optional[object] = None,
        **kwargs
    ):
        super(SqlServerTableDataset, self).__init__(additional_properties=additional_properties, description=description, structure=structure, schema=schema, linked_service_name=linked_service_name, parameters=parameters, annotations=annotations, folder=folder, **kwargs)
        self.type: str = 'SqlServerTable'
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class SquareLinkedService(LinkedService):
    """Square Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The URL of the Square instance. (i.e. mystore.mysquare.com).
    :type host: object
    :param client_id: Required. The client ID associated with your Square application.
    :type client_id: object
    :param client_secret: The client secret associated with your Square application.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param redirect_uri: Required. The redirect URL assigned in the Square application dashboard.
     (i.e. http://localhost:2500).
    :type redirect_uri: object
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'client_id': {'required': True},
        'redirect_uri': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'redirect_uri': {'key': 'typeProperties.redirectUri', 'type': 'object'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        host: object,
        client_id: object,
        redirect_uri: object,
        additional_properties: Optional[Dict[str, object]] = None,
        connect_via: Optional["IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "ParameterSpecification"]] = None,
        annotations: Optional[List[object]] = None,
        client_secret: Optional["SecretBase"] = None,
        use_encrypted_endpoints: Optional[object] = None,
        use_host_verification: Optional[object] = None,
        use_peer_verification: Optional[object] = None,
        encrypted_credential: Optional[object] = None,
        **kwargs
    ):
        super(SquareLinkedService, self).__init__(additional_properties=additional_properties, connect_via=connect_via, description=description, parameters=parameters, annotations=annotations, **kwargs)
        self.type: str = 'Square'
        self.host = host
        self.client_id = client_id
        self.client_secret = client_secret
        self.redirect_uri = redirect_uri
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class SquareObjectDataset(Dataset):
    """Square Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'l