#!/usr/bin/env python3
"""
Compiler ID  handling for dhfortran: tests

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 GNU Public License.

"""

import dhfortran.compilers as cp

def test_get_flavor():
    gf = cp.default_compilers["gfortran"]
    arch = cp.multiarch
    assert cp.get_fc_flavor_arch("/usr/bin/gfortran") == (gf, arch)
    assert cp.get_fc_flavor_arch("/usr/bin/gfortran-15") == (gf, arch)
    assert cp.get_fc_flavor_arch(f"/usr/bin/{arch}-gfortran-15") == (gf, arch)
    assert cp.get_fc_flavor_arch("/etc/alternatives/f95") == (gf,arch)

    try:
        x,_ = cp.get_fc_flavor_arch("/bin/garbage"), arch
    except Exception as ex:
        pass
    else:
        assert 1
        1, "get_fc_flavor_arch('/bin/garbage') should fail"


def test_get_fc_default():
    gf = cp.default_compilers["gfortran"]
    assert cp.get_fc_default() == gf



def test_get_optional():
    assert cp.get_fc_optional() is not None


if __name__ == "__main__":
    import pytest

    pytest.main()
