#include "config.h"

#include <cmocka.h>
#include <cmocka_private.h>

#include "../src/cmocka.c"

static const uint8_t buf0[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const uint8_t buf1[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static void test_all_zero(void **state)
{
    (void)state;

    assert_true(all_zero(buf0, sizeof(buf0)));

    assert_true(all_zero(NULL, 0));

    assert_true(all_zero(buf0, 0));

    assert_false(all_zero(buf1, sizeof(buf1)));
}

int main(int argc, char **argv) {
    const struct CMUnitTest buffer_tests[] = {
        cmocka_unit_test(test_all_zero),
    };

    (void)argc;
    (void)argv;

    return cmocka_run_group_tests(buffer_tests, NULL, NULL);
}
