/*
 * Copyright (C) 2025 The Phosh.mobi e.V.
 *
 * SPDX-License-Identifier: GPL-3.0+
 *
 * Author: Guido Günther <agx@sigxcpu.org>
 */

#include "cbd-manager.c"

#include "lcb-message-priv.h"


static void
test_cbd_manager_dedup_timestamp (void)
{
  g_autoptr (LcbMessage) msg1 = NULL, msg2 = NULL, msg3 = NULL;

  msg1 = lcb_message_new ("This is a test", 4391, 12, 0, 1, LCB_SEVERITY_LEVEL_TEST, "", NULL);
  msg2 = lcb_message_new ("This is a test", 4391, 12, 0, 2, LCB_SEVERITY_LEVEL_TEST, "", NULL);
  msg3 = lcb_message_new ("This is a test", 4391, 12, 0,
                          (60 * 60 * 24) + 1,
                          LCB_SEVERITY_LEVEL_TEST, "", NULL);

  g_assert_true (is_timestamp_close (msg1, msg2));
  g_assert_true (is_timestamp_close (msg2, msg1));

  g_assert_false (is_timestamp_close (msg1, msg3));
  g_assert_false (is_timestamp_close (msg3, msg1));
}


static void
test_cbd_manager_dedup_timestamp_jp (void)
{
  g_autoptr (LcbMessage) msg1 = NULL, msg2 = NULL, msg3 = NULL;

  msg1 = lcb_message_new ("This is a test", 4391, 12, 0, 1, LCB_SEVERITY_LEVEL_TEST, "", "440");
  msg2 = lcb_message_new ("This is a test", 4391, 12, 0, 2, LCB_SEVERITY_LEVEL_TEST, "", "440");
  msg3 = lcb_message_new ("This is a test", 4391, 12, 0,
                          (60 * 60) + 10,
                          LCB_SEVERITY_LEVEL_TEST, "", "440");

  g_assert_true (is_timestamp_close (msg1, msg2));
  g_assert_true (is_timestamp_close (msg2, msg1));

  g_assert_false (is_timestamp_close (msg1, msg3));
  g_assert_false (is_timestamp_close (msg3, msg1));
}


static void
test_cbd_manager_dedup_operator (void)
{
  g_autoptr (LcbMessage) msg1 = NULL, msg2 = NULL, msg3 = NULL;

  msg1 = lcb_message_new ("This is a test", 4391, 12, 0, 0, LCB_SEVERITY_LEVEL_TEST, "", "00101");
  msg2 = lcb_message_new ("This is a test", 4391, 12, 0, 0, LCB_SEVERITY_LEVEL_TEST, "", "00101");
  msg3 = lcb_message_new ("This is a test", 4391, 12, 0, 0, LCB_SEVERITY_LEVEL_TEST, "", NULL);

  g_assert_true (is_same_operator (msg1, msg2));
  g_assert_false (is_same_operator (msg1, msg3));
}


static void
test_cbd_manager_dedup_cbm_params (void)
{
  g_autoptr (LcbMessage) msg1 = NULL, msg2 = NULL, msg3 = NULL;

  msg1 = lcb_message_new ("This is a test", 4391, 12, 0, 0, LCB_SEVERITY_LEVEL_TEST, "", "00101");
  msg2 = lcb_message_new ("This is a test", 4391, 12, 0, 0, LCB_SEVERITY_LEVEL_TEST, "", "00101");
  msg3 = lcb_message_new ("This is a test", 4391, 12, 10, 0, LCB_SEVERITY_LEVEL_TEST, "", "00101");

  g_assert_true (has_same_cbm_params (msg1, msg2));
  g_assert_false (has_same_cbm_params (msg1, msg3));
}


static void
test_cbd_manager_dedup_text (void)
{
  g_autoptr (LcbMessage) msg1 = NULL, msg2 = NULL, msg3 = NULL;

  msg1 = lcb_message_new ("This is a test", 4391, 12, 0, 0, LCB_SEVERITY_LEVEL_TEST, "", "00101");
  msg2 = lcb_message_new ("This is a test", 4391, 12, 0, 0, LCB_SEVERITY_LEVEL_TEST, "", "00101");
  msg3 = lcb_message_new ("This is a test test", 4391, 12, 0, 0, LCB_SEVERITY_LEVEL_TEST, "", "00101");

  g_assert_true (has_same_text (msg1, msg2));
  g_assert_false (has_same_text (msg1, msg3));
}


gint
main (gint argc, gchar *argv[])
{
  g_test_init (&argc, &argv, NULL);

  g_test_add_func ("/cbd/manager/dedup/timestamp", test_cbd_manager_dedup_timestamp);
  g_test_add_func ("/cbd/manager/dedup/timestamp-jp", test_cbd_manager_dedup_timestamp_jp);
  g_test_add_func ("/cbd/manager/dedup/operator", test_cbd_manager_dedup_operator);
  g_test_add_func ("/cbd/manager/dedup/cbm-params", test_cbd_manager_dedup_cbm_params);
  g_test_add_func ("/cbd/manager/dedup/text", test_cbd_manager_dedup_text);

  return g_test_run ();
}
