# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.deviceregistry import DeviceRegistryMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-deviceregistry
# USAGE
    python create_or_replace_namespace_asset.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DeviceRegistryMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.namespace_assets.begin_create_or_replace(
        resource_group_name="myResourceGroup",
        namespace_name="my-namespace-1",
        asset_name="my-asset-1",
        resource={
            "extendedLocation": {
                "name": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
                "type": "CustomLocation",
            },
            "location": "West Europe",
            "properties": {
                "assetTypeRefs": ["myAssetTypeRef1", "myAssetTypeRef2"],
                "attributes": {"floor": "1"},
                "datasets": [
                    {
                        "dataPoints": [
                            {
                                "dataPointConfiguration": '{"publishingInterval":8,"samplingInterval":8,"queueSize":4}',
                                "dataSource": "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
                                "name": "dataset1DataPoint1",
                                "typeRef": "dataset1DataPoint1TypeRef",
                            },
                            {
                                "dataPointConfiguration": '{"publishingInterval":8,"samplingInterval":8,"queueSize":4}',
                                "dataSource": "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
                                "name": "dataset1DataPoint2",
                                "typeRef": "dataset1DataPoint2TypeRef",
                            },
                        ],
                        "dataSource": "nsu=http://microsoft.com/Opc/OpcPlc/Oven;i=5",
                        "datasetConfiguration": '{"publishingInterval":10,"samplingInterval":15,"queueSize":20}',
                        "destinations": [{"configuration": {"key": "dataset1"}, "target": "BrokerStateStore"}],
                        "name": "dataset1",
                        "typeRef": "dataset1TypeRef",
                    }
                ],
                "defaultDatasetsConfiguration": '{"publishingInterval":10,"samplingInterval":15,"queueSize":20}',
                "defaultDatasetsDestinations": [
                    {"configuration": {"key": "defaultValue"}, "target": "BrokerStateStore"}
                ],
                "defaultEventsConfiguration": '{"publishingInterval":10,"samplingInterval":15,"queueSize":20}',
                "defaultEventsDestinations": [{"configuration": {"path": "/tmp"}, "target": "Storage"}],
                "defaultManagementGroupsConfiguration": '{"retryCount":10,"retryBackoffInterval":15}',
                "defaultStreamsConfiguration": '{"publishingInterval":10,"samplingInterval":15,"queueSize":20}',
                "defaultStreamsDestinations": [
                    {
                        "configuration": {"qos": "Qos0", "retain": "Never", "topic": "/contoso/test", "ttl": 3600},
                        "target": "Mqtt",
                    }
                ],
                "description": "This is a sample Asset",
                "deviceRef": {"deviceName": "device1", "endpointName": "opcuaendpointname"},
                "discoveredAssetRefs": ["discoveredAsset1"],
                "displayName": "AssetDisplayName",
                "documentationUri": "https://www.example.com/manual",
                "enabled": True,
                "eventGroups": [
                    {
                        "events": [
                            {
                                "dataSource": "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt5",
                                "destinations": [
                                    {
                                        "configuration": {
                                            "qos": "Qos0",
                                            "retain": "Keep",
                                            "topic": "/contoso/testEvent1",
                                            "ttl": 7200,
                                        },
                                        "target": "Mqtt",
                                    }
                                ],
                                "eventConfiguration": '{"publishingInterval":7,"samplingInterval":1,"queueSize":8}',
                                "name": "event1",
                                "typeRef": "event1Ref",
                            },
                            {
                                "dataSource": "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt8",
                                "destinations": [{"configuration": {"path": "/tmp/event2"}, "target": "Storage"}],
                                "eventConfiguration": '{"publishingInterval":7,"samplingInterval":1,"queueSize":8}',
                                "name": "event2",
                                "typeRef": "event2Ref",
                            },
                        ],
                        "name": "default",
                    }
                ],
                "externalAssetId": "8ZBA6LRHU0A458969",
                "hardwareRevision": "1.0",
                "managementGroups": [
                    {
                        "actions": [
                            {
                                "actionConfiguration": '{"retryCount":5,"retryBackoffInterval":5}',
                                "actionType": "Call",
                                "name": "action1",
                                "targetUri": "/onvif/device_service?ONVIFProfile=Profile1",
                                "timeoutInSeconds": 60,
                                "topic": "/contoso/managementGroup1/action1",
                                "typeRef": "action1TypeRef",
                            },
                            {
                                "actionConfiguration": '{"retryCount":5,"retryBackoffInterval":5}',
                                "actionType": "Call",
                                "name": "action2",
                                "targetUri": "/onvif/device_service?ONVIFProfile=Profile2",
                                "timeoutInSeconds": 60,
                                "topic": "/contoso/managementGroup1/action2",
                                "typeRef": "action2TypeRef",
                            },
                        ],
                        "defaultTimeoutInSeconds": 100,
                        "defaultTopic": "/contoso/managementGroup1",
                        "managementGroupConfiguration": '{"retryCount":10,"retryBackoffInterval":15}',
                        "name": "managementGroup1",
                        "typeRef": "managementGroup1TypeRef",
                    }
                ],
                "manufacturer": "Contoso",
                "manufacturerUri": "https://www.contoso.com/manufacturerUri",
                "model": "ContosoModel",
                "productCode": "SA34VDG",
                "serialNumber": "64-103816-519918-8",
                "softwareRevision": "2.0",
                "streams": [
                    {
                        "destinations": [{"configuration": {"path": "/tmp/stream1"}, "target": "Storage"}],
                        "name": "stream1",
                        "streamConfiguration": '{"publishingInterval":8,"samplingInterval":8,"queueSize":4}',
                        "typeRef": "stream1TypeRef",
                    },
                    {
                        "destinations": [
                            {
                                "configuration": {
                                    "qos": "Qos0",
                                    "retain": "Never",
                                    "topic": "/contoso/testStream2",
                                    "ttl": 7200,
                                },
                                "target": "Mqtt",
                            }
                        ],
                        "name": "stream2",
                        "streamConfiguration": '{"publishingInterval":8,"samplingInterval":8,"queueSize":4}',
                        "typeRef": "stream2TypeRef",
                    },
                ],
            },
            "tags": {"site": "building-1"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-10-01/CreateOrReplace_NamespaceAsset.json
if __name__ == "__main__":
    main()
