// RUN: mlir-opt -convert-spirv-to-llvm %s | FileCheck %s

// NOTE: Assertions have been autogenerated by utils/generate-test-checks.py

// CHECK-LABEL:   llvm.func spir_funccc @_Z17__spirv_GroupSMaxiij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z17__spirv_GroupUMaxiij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z17__spirv_GroupFMaxiif(i32, i32, f32) -> f32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z17__spirv_GroupSMiniij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z17__spirv_GroupUMiniij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z17__spirv_GroupFMiniif(i32, i32, f32) -> f32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z17__spirv_GroupFAddiif(i32, i32, f32) -> f32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z17__spirv_GroupIAddiij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}

// CHECK-LABEL:   llvm.func @group_reduce_iadd(
// CHECK-SAME:                                 %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupIAddiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_reduce_iadd(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupIAdd <Workgroup> <Reduce> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_reduce_fadd(
// CHECK-SAME:                                 %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupFAddiif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @group_reduce_fadd(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupFAdd <Workgroup> <Reduce> %arg0 : f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @group_reduce_fmin(
// CHECK-SAME:                                 %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupFMiniif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @group_reduce_fmin(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupFMin <Workgroup> <Reduce> %arg0 : f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @group_reduce_umin(
// CHECK-SAME:                                 %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupUMiniij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_reduce_umin(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupUMin <Workgroup> <Reduce> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_reduce_smin(
// CHECK-SAME:                                 %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupSMiniij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_reduce_smin(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupSMin <Workgroup> <Reduce> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_reduce_fmax(
// CHECK-SAME:                                 %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupFMaxiif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @group_reduce_fmax(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupFMax <Workgroup> <Reduce> %arg0 : f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @group_reduce_umax(
// CHECK-SAME:                                 %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupUMaxiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_reduce_umax(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupUMax <Workgroup> <Reduce> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_reduce_smax(
// CHECK-SAME:                                 %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupSMaxiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_reduce_smax(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupSMax <Workgroup> <Reduce> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_inclusive_scan_iadd(
// CHECK-SAME:                                         %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(1 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupIAddiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_inclusive_scan_iadd(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupIAdd <Workgroup> <InclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_inclusive_scan_fadd(
// CHECK-SAME:                                         %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(1 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupFAddiif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @group_inclusive_scan_fadd(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupFAdd <Workgroup> <InclusiveScan> %arg0 : f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @group_inclusive_scan_fmin(
// CHECK-SAME:                                         %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(1 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupFMiniif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @group_inclusive_scan_fmin(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupFMin <Workgroup> <InclusiveScan> %arg0 : f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @group_inclusive_scan_umin(
// CHECK-SAME:                                         %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(1 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupUMiniij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_inclusive_scan_umin(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupUMin <Workgroup> <InclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_inclusive_scan_smin(
// CHECK-SAME:                                         %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(1 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupSMiniij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_inclusive_scan_smin(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupSMin <Workgroup> <InclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_inclusive_scan_fmax(
// CHECK-SAME:                                         %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(1 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupFMaxiif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @group_inclusive_scan_fmax(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupFMax <Workgroup> <InclusiveScan> %arg0 : f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @group_inclusive_scan_umax(
// CHECK-SAME:                                         %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(1 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupUMaxiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_inclusive_scan_umax(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupUMax <Workgroup> <InclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_inclusive_scan_smax(
// CHECK-SAME:                                         %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupSMaxiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_inclusive_scan_smax(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupSMax <Workgroup> <ExclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_exclusive_scan_iadd(
// CHECK-SAME:                                         %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupIAddiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_exclusive_scan_iadd(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupIAdd <Workgroup> <ExclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_exclusive_scan_fadd(
// CHECK-SAME:                                         %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupFAddiif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @group_exclusive_scan_fadd(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupFAdd <Workgroup> <ExclusiveScan> %arg0 : f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @group_exclusive_scan_fmin(
// CHECK-SAME:                                         %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupFMiniif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @group_exclusive_scan_fmin(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupFMin <Workgroup> <ExclusiveScan> %arg0 : f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @group_exclusive_scan_umin(
// CHECK-SAME:                                         %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupUMiniij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_exclusive_scan_umin(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupUMin <Workgroup> <ExclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_exclusive_scan_smin(
// CHECK-SAME:                                         %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupSMiniij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_exclusive_scan_smin(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupSMin <Workgroup> <ExclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_exclusive_scan_fmax(
// CHECK-SAME:                                         %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupFMaxiif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @group_exclusive_scan_fmax(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupFMax <Workgroup> <ExclusiveScan> %arg0 : f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @group_exclusive_scan_umax(
// CHECK-SAME:                                         %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupUMaxiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_exclusive_scan_umax(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupUMax <Workgroup> <ExclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @group_exclusive_scan_smax(
// CHECK-SAME:                                         %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupSMaxiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @group_exclusive_scan_smax(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupSMax <Workgroup> <ExclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @subgroup_exclusive_scan_smax(
// CHECK-SAME:                                            %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(2 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z17__spirv_GroupSMaxiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @subgroup_exclusive_scan_smax(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupSMax <Subgroup> <ExclusiveScan> %arg0 : i32
  spirv.ReturnValue %0 : i32
}
