// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_variables.json and
// builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_autogen.cpp: Wrapper for static or pool allocated char arrays, that are
// guaranteed to be valid and unchanged for the duration of the compilation. Implements
// mangledNameHash using perfect hash function from gen_builtin_symbols.py

#include "compiler/translator/ImmutableString.h"

namespace sh
{

std::ostream &operator<<(std::ostream &os, const ImmutableString &str)
{
    return os.write(str.data(), str.length());
}

}  // namespace sh

#if defined(_MSC_VER)
#    pragma warning(disable : 4309)  // truncation of constant value
#endif

namespace
{

constexpr int mangledkT1[] = {1010, 2612, 305,  1103, 602,  2540, 792, 1009, 550,  54,
                              2937, 2671, 687,  157,  684,  1451, 375, 1283, 106,  2776,
                              1544, 1773, 1844, 885,  2584, 2112, 387, 2575, 3152, 2290,
                              1637, 1317, 1135, 1305, 2761, 1142, 354, 440,  3181, 93};
constexpr int mangledkT2[] = {113,  1809, 1131, 1235, 2983, 2154, 83,   1560, 1911, 2522,
                              3157, 2678, 37,   2136, 1636, 1893, 2950, 2085, 950,  1060,
                              242,  2000, 678,  450,  2221, 2144, 891,  2916, 3009, 945,
                              3020, 2446, 243,  2893, 2461, 2397, 759,  1880, 1958, 1451};
constexpr int mangledkG[]  = {
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    1382, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    8,    0,    0,    0,    0,    0,
    0,    0,    1877, 0,    0,    0,    0,    1737, 0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    804,  0,    0,    0,    0,    0,    0,    0,    0,    3048, 0,    0,    2068, 0,    0,
    912,  0,    0,    0,    3067, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    2338, 0,    0,    0,    0,    0,    0,    0,    0,    3145, 0,    0,    2874, 901,  0,    0,
    711,  0,    2522, 0,    0,    0,    2942, 0,    2497, 0,    0,    0,    3036, 0,    0,    0,
    0,    0,    0,    0,    543,  0,    0,    0,    0,    0,    0,    536,  102,  0,    0,    0,
    1566, 0,    0,    0,    0,    0,    0,    0,    0,    3174, 0,    0,    0,    0,    1070, 0,
    0,    1148, 0,    0,    0,    526,  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    3161, 0,    0,    0,    0,    0,    0,    3244, 0,    0,    0,    0,    0,    0,    2775, 663,
    0,    0,    0,    0,    0,    0,    0,    0,    2929, 0,    0,    1239, 0,    644,  3210, 0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    3080, 0,    0,    0,    0,
    892,  0,    1279, 201,  0,    0,    368,  0,    0,    0,    0,    0,    0,    0,    0,    539,
    0,    0,    0,    0,    785,  0,    0,    0,    2369, 1892, 3153, 2862, 0,    0,    0,    266,
    0,    600,  0,    2761, 0,    0,    0,    0,    0,    0,    659,  0,    0,    0,    0,    0,
    0,    0,    1004, 0,    286,  0,    0,    0,    0,    315,  1422, 0,    0,    987,  0,    0,
    0,    2031, 0,    0,    216,  2045, 883,  1282, 0,    0,    0,    0,    0,    0,    1396, 1339,
    1262, 0,    0,    0,    0,    0,    0,    953,  0,    0,    1345, 0,    0,    1148, 0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    223,  0,    293,  0,    0,    324,  0,    0,
    876,  409,  0,    0,    0,    0,    0,    0,    0,    0,    2641, 2620, 0,    0,    0,    430,
    0,    169,  0,    0,    794,  0,    962,  0,    0,    1700, 0,    472,  0,    0,    869,  2307,
    1170, 1421, 2170, 0,    0,    0,    0,    0,    190,  814,  0,    738,  0,    479,  0,    0,
    0,    0,    0,    0,    1444, 0,    1142, 937,  0,    1787, 695,  2333, 2835, 713,  0,    0,
    0,    0,    0,    0,    0,    2794, 0,    0,    2898, 0,    0,    0,    0,    2179, 0,    0,
    0,    0,    0,    0,    0,    1413, 0,    2318, 0,    0,    0,    269,  0,    2081, 834,  0,
    3102, 0,    3203, 0,    1836, 176,  0,    104,  0,    432,  0,    0,    0,    0,    0,    1103,
    0,    621,  2985, 0,    0,    0,    0,    0,    1276, 221,  361,  0,    0,    0,    0,    0,
    0,    3114, 0,    0,    0,    0,    0,    535,  0,    1012, 0,    0,    0,    1541, 0,    0,
    0,    0,    1385, 2736, 2860, 0,    686,  0,    3090, 1054, 0,    0,    0,    0,    1384, 2154,
    54,   1184, 0,    0,    0,    0,    277,  0,    0,    0,    0,    0,    990,  0,    795,  0,
    0,    1778, 1194, 0,    1288, 0,    738,  0,    0,    331,  0,    0,    0,    0,    0,    0,
    2762, 619,  0,    1451, 1907, 0,    0,    0,    0,    0,    529,  0,    0,    0,    0,    0,
    535,  430,  0,    3135, 0,    2699, 1905, 2267, 0,    0,    0,    0,    0,    0,    389,  1008,
    0,    0,    981,  0,    0,    0,    127,  0,    0,    0,    0,    1242, 0,    1133, 0,    0,
    0,    0,    0,    0,    1222, 304,  0,    3009, 2187, 0,    0,    0,    0,    0,    0,    428,
    1602, 0,    0,    0,    0,    0,    0,    3117, 0,    0,    0,    0,    0,    0,    3182, 3254,
    3234, 550,  452,  0,    0,    1196, 2355, 0,    0,    1149, 317,  578,  1922, 0,    0,    449,
    156,  1022, 0,    0,    3122, 525,  1254, 750,  0,    2871, 0,    0,    0,    0,    1904, 0,
    0,    0,    836,  0,    1166, 0,    0,    1381, 0,    513,  897,  934,  1156, 2707, 1746, 94,
    0,    1955, 387,  0,    0,    0,    3108, 663,  0,    0,    0,    0,    3205, 0,    0,    632,
    2022, 0,    2083, 0,    2881, 0,    1291, 0,    816,  0,    0,    2367, 469,  1036, 0,    1338,
    0,    627,  2694, 149,  0,    1276, 0,    1293, 678,  0,    0,    0,    0,    0,    1006, 2819,
    0,    0,    0,    1403, 650,  0,    0,    0,    0,    0,    0,    0,    368,  0,    0,    809,
    1414, 0,    0,    0,    0,    1618, 0,    1547, 0,    477,  0,    972,  234,  742,  0,    0,
    0,    1911, 0,    435,  0,    1686, 0,    0,    0,    569,  0,    0,    902,  1519, 0,    0,
    0,    0,    2199, 34,   0,    0,    715,  0,    1538, 3189, 64,   0,    0,    0,    2884, 2374,
    0,    0,    1257, 0,    0,    1160, 3207, 0,    2324, 0,    0,    0,    973,  0,    0,    0,
    1271, 141,  811,  1103, 900,  1325, 0,    89,   0,    1444, 696,  0,    456,  0,    2545, 221,
    2292, 0,    417,  1028, 0,    212,  0,    0,    1570, 0,    3177, 1402, 0,    0,    380,  0,
    0,    0,    1111, 0,    0,    1120, 2149, 2682, 1223, 0,    460,  0,    837,  0,    0,    16,
    912,  0,    0,    881,  3195, 0,    0,    0,    2024, 0,    0,    747,  0,    0,    0,    489,
    1061, 81,   0,    0,    0,    685,  2224, 0,    284,  988,  0,    2755, 0,    0,    1180, 368,
    0,    0,    0,    0,    1824, 0,    2567, 0,    0,    0,    0,    1069, 0,    0,    0,    2649,
    1219, 0,    2723, 3155, 0,    893,  120,  2421, 443,  3025, 1547, 0,    0,    0,    32,   0,
    312,  3001, 1050, 126,  652,  0,    2032, 0,    68,   0,    1352, 1533, 0,    0,    1833, 1440,
    0,    0,    1011, 3257, 2282, 77,   0,    668,  0,    0,    2526, 0,    0,    0,    0,    679,
    760,  908,  0,    647,  775,  0,    0,    621,  0,    0,    0,    2904, 0,    0,    556,  0,
    384,  0,    0,    767,  199,  0,    1263, 421,  919,  0,    1286, 1216, 0,    0,    0,    0,
    0,    348,  0,    1027, 0,    0,    361,  1582, 0,    0,    0,    0,    0,    0,    0,    2984,
    0,    0,    0,    3169, 564,  896,  0,    0,    42,   2760, 825,  1085, 1123, 1581, 1162, 3138,
    686,  2240, 0,    0,    1970, 0,    1553, 0,    0,    0,    2230, 1089, 0,    0,    977,  0,
    0,    1972, 893,  0,    0,    274,  2017, 1453, 0,    1471, 0,    1571, 1475, 598,  0,    2781,
    2356, 379,  0,    1431, 2456, 0,    950,  0,    0,    225,  1743, 0,    0,    0,    0,    0,
    0,    1116, 0,    0,    1308, 0,    0,    0,    3009, 964,  0,    0,    0,    1677, 0,    0,
    702,  196,  0,    0,    3236, 1217, 239,  0,    2366, 1569, 0,    0,    0,    1409, 0,    0,
    0,    0,    0,    2918, 245,  0,    0,    1418, 0,    0,    0,    1096, 0,    0,    311,  0,
    0,    0,    0,    2120, 0,    2724, 0,    0,    1344, 961,  1937, 2772, 1672, 3058, 0,    0,
    796,  706,  0,    834,  293,  869,  736,  0,    0,    0,    1377, 0,    0,    892,  0,    3184,
    3055, 470,  0,    126,  199,  0,    853,  0,    366,  0,    0,    1883, 428,  2056, 0,    0,
    45,   0,    0,    0,    2581, 3023, 0,    261,  0,    2786, 875,  329,  0,    0,    0,    0,
    0,    0,    0,    0,    795,  0,    0,    904,  0,    438,  0,    0,    0,    2562, 0,    0,
    664,  0,    0,    0,    1228, 0,    1551, 0,    2882, 0,    0,    0,    76,   570,  0,    0,
    1411, 1803, 0,    0,    0,    419,  0,    97,   1559, 0,    2611, 301,  2935, 0,    0,    0,
    0,    0,    579,  0,    0,    0,    0,    0,    0,    1180, 0,    0,    1538, 0,    0,    1347,
    0,    2489, 0,    0,    1485, 665,  2251, 0,    0,    0,    0,    0,    342,  0,    1425, 0,
    1430, 3202, 0,    0,    1600, 0,    2731, 1913, 0,    0,    176,  0,    0,    0,    0,    0,
    580,  1048, 0,    0,    0,    0,    568,  92,   0,    712,  2565, 1157, 191,  2385, 0,    1513,
    415,  75,   0,    0,    0,    2968, 0,    0,    1273, 1010, 0,    1135, 0,    0,    2319, 220,
    0,    1976, 0,    0,    0,    920,  0,    297,  0,    0,    0,    0,    0,    2581, 558,  970,
    1123, 438,  239,  718,  0,    689,  0,    0,    3202, 0,    0,    0,    0,    0,    0,    693,
    0,    0,    776,  0,    1664, 394,  183,  0,    0,    2338, 2610, 0,    1427, 0,    2103, 0,
    0,    1866, 0,    0,    1983, 2865, 512,  0,    3246, 0,    1139, 874,  2977, 146,  0,    2909,
    0,    1975, 0,    2196, 3243, 2156, 0,    0,    0,    0,    0,    1709, 1230, 0,    985,  0,
    0,    525,  1827, 2166, 0,    419,  0,    0,    1363, 0,    2929, 0,    0,    397,  0,    1062,
    549,  0,    0,    0,    894,  2658, 3024, 2340, 94,   0,    2400, 0,    0,    0,    0,    2229,
    0,    337,  343,  0,    2145, 505,  0,    0,    1560, 819,  1024, 0,    0,    36,   2629, 0,
    0,    2170, 0,    747,  0,    0,    596,  107,  1459, 0,    0,    851,  0,    1948, 0,    690,
    0,    1443, 2040, 150,  0,    0,    2635, 727,  0,    2256, 0,    3268, 1665, 0,    0,    0,
    0,    325,  0,    0,    0,    2452, 2290, 2932, 1575, 1375, 663,  0,    1023, 0,    0,    0,
    162,  0,    0,    3257, 1985, 0,    0,    637,  2965, 3178, 327,  378,  0,    1134, 0,    0,
    637,  0,    152,  822,  2487, 1102, 465,  0,    0,    0,    0,    1156, 0,    0,    938,  0,
    2646, 1396, 0,    781,  2039, 0,    0,    0,    1273, 0,    754,  1572, 2646, 1231, 0,    1173,
    0,    0,    1514, 2142, 2792, 0,    0,    0,    509,  2271, 0,    575,  0,    0,    0,    915,
    0,    248,  0,    0,    1601, 2812, 0,    2756, 2557, 328,  0,    1150, 629,  0,    674,  0,
    0,    172,  0,    31,   0,    1849, 0,    0,    0,    0,    124,  28,   1341, 0,    2358, 2356,
    0,    0,    2375, 756,  2994, 856,  166,  0,    0,    0,    410,  0,    602,  0,    1718, 1354,
    0,    1396, 3244, 647,  3003, 129,  1970, 0,    54,   1129, 0,    0,    605,  0,    0,    312,
    3108, 0,    0,    2991, 0,    757,  0,    0,    2769, 570,  0,    0,    0,    0,    0,    2706,
    1106, 40,   0,    2627, 0,    0,    1319, 0,    2085, 294,  1461, 0,    0,    1197, 0,    0,
    0,    754,  0,    467,  3008, 0,    155,  0,    0,    1543, 532,  0,    0,    3268, 1995, 0,
    0,    0,    0,    0,    2792, 0,    0,    0,    0,    0,    0,    3078, 352,  0,    1280, 566,
    0,    215,  877,  1058, 0,    26,   940,  0,    0,    0,    1053, 0,    0,    2875, 0,    1434,
    0,    0,    0,    0,    0,    0,    865,  0,    2816, 825,  990,  2699, 0,    3264, 0,    674,
    638,  3253, 0,    0,    3012, 924,  749,  0,    314,  0,    2846, 3137, 0,    854,  2578, 0,
    79,   556,  588,  0,    0,    2214, 2711, 0,    0,    0,    0,    153,  0,    45,   2574, 3029,
    258,  67,   2908, 0,    0,    750,  0,    0,    0,    0,    0,    735,  1073, 0,    0,    1295,
    3048, 0,    0,    0,    0,    0,    1099, 835,  954,  0,    1386, 672,  0,    0,    0,    828,
    604,  0,    1449, 1182, 0,    186,  716,  249,  347,  1522, 0,    217,  0,    1316, 2637, 0,
    1141, 0,    461,  0,    0,    0,    0,    0,    770,  0,    697,  0,    0,    954,  0,    0,
    387,  0,    1615, 1369, 0,    109,  480,  1023, 513,  3237, 348,  2190, 0,    1544, 676,  3162,
    954,  0,    0,    2411, 2792, 0,    392,  1093, 504,  413,  0,    0,    0,    250,  0,    0,
    0,    610,  60,   0,    0,    1497, 3056, 3047, 0,    0,    98,   553,  1182, 2981, 0,    0,
    0,    1035, 1214, 0,    0,    1844, 0,    507,  0,    0,    0,    1060, 0,    0,    1106, 0,
    0,    307,  531,  0,    0,    248,  0,    0,    825,  0,    0,    1093, 0,    0,    1865, 0,
    599,  179,  654,  0,    177,  3060, 0,    0,    2612, 0,    2837, 0,    832,  1240, 3021, 909,
    1941, 2566, 821,  585,  0,    1864, 0,    1096, 1051, 0,    0,    0,    0,    0,    0,    399,
    2301, 0,    2950, 100,  0,    65,   1522, 0,    0,    29,   0,    1346, 0,    362,  0,    0,
    0,    0,    294,  2473, 3057, 950,  655,  0,    0,    2629, 0,    830,  3144, 0,    1197, 1829,
    0,    248,  2812, 737,  0,    0,    263,  2715, 0,    4,    0,    0,    0,    32,   0,    788,
    0,    0,    2007, 0,    0,    146,  24,   2474, 0,    0,    996,  2708, 0,    970,  0,    0,
    281,  292,  2977, 0,    2551, 2995, 2672, 555,  0,    0,    51,   1199, 804,  0,    1369, 2392,
    148,  0,    0,    0,    2683, 402,  848,  453,  620,  2851, 0,    1522, 0,    0,    1165, 0,
    0,    419,  437,  2421, 0,    829,  816,  1499, 178,  2043, 752,  791,  0,    0,    910,  0,
    0,    0,    3077, 0,    2513, 870,  828,  1352, 1504, 1359, 2838, 0,    1155, 1812, 3229, 0,
    0,    0,    2685, 0,    570,  842,  0,    0,    0,    0,    445,  317,  864,  0,    1370, 0,
    0,    0,    994,  0,    477,  1022, 1409, 1500, 0,    0,    3242, 16,   265,  0,    0,    3111,
    0,    496,  0,    2879, 3067, 0,    0,    2871, 1285, 574,  0,    480,  3091, 0,    0,    429,
    797,  830,  0,    0,    562,  0,    0,    854,  0,    0,    225,  150,  288,  0,    0,    0,
    1357, 0,    3097, 0,    522,  147,  280,  1679, 445,  173,  2762, 1111, 0,    0,    44,   526,
    1156, 723,  2212, 2525, 331,  499,  0,    2886, 532,  978,  2023, 1407, 1026, 207,  501,  0,
    268,  2669, 2833, 1139, 0,    1817, 247,  0,    911,  0,    43,   0,    0,    423,  729,  0,
    3128, 0,    1090, 1880, 1055, 1122, 2688, 0,    0,    0,    0,    1757, 1243, 1428, 2157, 818,
    133,  938,  0,    0,    0,    0,    2303, 294,  0,    796,  3188, 1475, 2957, 188,  0,    547,
    0,    1840, 0,    2686, 1476, 0,    905,  0,    58,   0,    170,  0,    2066, 261,  0,    914,
    0,    0,    0,    10,   1338, 849,  2677, 1455, 0,    0,    387,  0,    407,  0,    717,  883,
    144,  1315, 1380, 3071, 519,  541,  0,    71,   785,  0,    599,  0,    2360, 0,    918,  1104,
    119,  0,    0,    545,  663,  1505, 1911, 2228, 1278, 0,    0,    0,    0,    0,    1625, 0,
    218,  1962, 872,  517,  1233, 0,    2591, 0,    0,    1276, 0,    0,    0,    462,  0,    3187,
    0,    3221, 126,  0,    1050, 0,    0,    1349, 0,    3000, 310,  872,  3077, 1145, 0,    336,
    0,    1052, 0,    0,    0,    64,   509,  0,    704,  716,  2494, 0,    1002, 1563, 1477, 0,
    0,    0,    0,    1796, 1083, 0,    603,  707,  0,    0,    0,    1329, 2298, 858,  0,    0,
    1786, 705,  0,    0,    857,  2581, 0,    2385, 0,    0,    760,  850,  282,  0,    2523, 1262,
    1462, 0,    0,    638,  1562, 1265, 0,    1323, 462,  0,    1459, 0,    0,    553,  0,    654,
    0,    966,  359,  2944, 1132, 0,    1379, 0,    1446, 0,    0,    878,  3114, 0,    0,    0,
    1337, 571,  3153, 0,    0,    720,  0,    355,  1521, 2696, 2894, 0,    20,   164,  3240, 0,
    1260, 84,   2748, 1667, 0,    0,    0,    609,  213,  471,  2384, 3084, 3242, 0,    684,  1233,
    1256, 0,    0,    2112, 0,    0,    0,    753,  311,  0,    122,  1244, 2732, 1309, 0,    803,
    2392, 450,  0,    3046, 0,    326,  209,  1045, 1797, 0,    0,    3069, 0,    0,    0,    1510,
    1291, 0,    500,  0,    1689, 581,  0,    1546, 2777, 1086, 1010, 0,    2739, 1302, 0,    0,
    1094, 0,    0,    3137, 0,    0,    0,    1321, 399,  168,  3178, 523,  0,    1370, 0,    0,
    0,    0,    0,    1234, 0,    152,  0,    1775, 1990, 1101, 2572, 651,  2059, 0,    1478, 1125,
    2095, 1370, 0,    0,    3054, 0,    620,  0,    1261, 2879, 1841, 0,    1261, 2054, 0,    737,
    2206, 0,    1203, 0,    0,    2260, 2409, 0,    3165, 0,    0,    0,    0,    455,  459,  0,
    3084, 0,    2252, 985,  967,  416,  0,    3244, 0,    1491, 0,    715,  3246, 0,    0,    219,
    0,    2170, 0,    0,    3238, 832,  763,  134,  0,    425,  0,    0,    0,    19,   784,  3079,
    1309, 0,    1569, 0,    317,  101,  0,    0,    2243, 446,  814,  0,    844,  0,    0,    349,
    455,  0,    1196, 0,    394,  672,  0,    847,  0,    1969, 639,  0,    1114, 1669, 1676, 1986,
    3144, 3266, 2527, 899,  1854, 0,    834,  1658, 0,    2357, 0,    852,  748,  0,    0,    710,
    0,    0,    0,    0,    2383, 966,  0,    0,    0,    0,    2840, 1635, 982,  1828, 0,    714,
    332,  0,    0,    1549, 1343, 0,    3206, 0,    0,    2120, 2040, 0,    0,    0,    1958, 1006,
    421,  2902, 0,    0,    1878, 367,  0,    0,    140,  952,  0,    1554, 1400, 358,  634,  384,
    1599, 3137, 0,    2946, 119,  352,  2157, 3135, 548,  0,    0,    96,   509,  0,    1508, 321,
    2397, 1480, 0,    0,    400,  808,  718,  0,    2789, 0,    394,  0,    0,    0,    1349, 1365,
    30,   583,  34,   0,    458,  3033, 1668, 1055, 0,    2172, 1645, 0,    0,    1391, 3021, 0,
    0,    224,  2457, 1224, 3162, 2721, 0,    0,    0,    2689, 0,    0,    0,    0,    1687, 0,
    780,  0,    72,   938,  237,  483,  2283, 1562, 0,    2240, 2313, 1348, 2277, 1033, 0,    453,
    997,  0,    2987, 1150, 0,    0,    607,  0,    1091, 0,    227,  355,  2346, 0,    1129, 3131,
    3107, 0,    0,    0,    0,    883,  71,   712,  0,    3179, 1287, 0,    2769, 487,  1401, 0,
    444,  0,    0,    73,   0,    2428, 0,    502,  779,  0,    372,  866,  100,  2126, 0,    0,
    0,    0,    0,    1074, 1704, 2795, 312,  288,  553,  2048, 2421, 2542, 1088, 3039, 0,    0,
    0,    0,    0,    0,    1364, 666,  0,    2188, 0,    0,    0,    178,  163,  0,    0,    1372,
    371,  0,    1388, 2321, 1336, 0,    854,  609,  2593, 998,  1178, 0,    1437, 127,  0,    1200,
    1337, 0,    1649, 810,  887,  0,    3228, 341,  0,    210,  0,    0,    0,    1736, 0,    1048,
    406,  1458, 377,  0,    0,    0,    3080, 1069, 17,   319,  652,  0,    3215, 274,  0,    109,
    788,  839,  3257, 302,  0,    1413, 0,    0,    1257, 1443, 0,    0,    0,    0,    0,    786,
    2003, 709,  0,    3210, 110,  0,    0,    0,    0,    1303, 210,  1240, 1902, 0,    0,    0,
    0,    731,  2,    0,    0,    0,    3035, 236,  2083, 1237, 1507, 271,  0,    0,    337,  0,
    0,    493,  2067, 1933, 820,  50,   737,  0,    307,  0,    24,   287,  0,    1500, 0,    1273,
    0,    1051, 0,    355,  1828, 96,   0,    0,    1313, 1014, 578,  595,  7,    1154, 592,  0,
    0,    1194, 116,  1046, 0,    0,    0,    3207, 1424, 1190, 880,  0,    1004, 0,    0,    0,
    0,    0,    591,  0,    2843, 0,    1360, 0,    2418, 0,    0,    0,    0,    480,  0,    0,
    1011, 0,    3201, 1481, 0,    1949, 375,  482,  0,    0,    0,    0,    0,    0,    2635, 198,
    46,   808,  1008, 0,    1132, 0,    1030, 0,    3036, 0,    2712, 0,    0,    141,  0,    0,
    1038, 891,  0,    590,  1314, 0,    0,    529,  1824, 227,  471,  956,  1515, 1577, 0,    2643,
    2470, 1429, 1181, 1169, 524,  1569, 0,    139,  0,    2485, 0,    2863, 1532, 740,  0,    641,
    425,  592,  2225, 1267, 0,    0,    684,  289,  664,  0,    1784, 214,  1305, 0,    479,  0,
    2185, 0,    0,    0,    2851, 0,    788,  0,    3194, 131,  0,    615,  338,  1425, 1266, 357,
    1095, 367,  0,    0,    1939, 0,    0,    0,    1398, 1530, 2576, 2614, 1550, 0,    2147, 1239,
    2439, 0,    2336, 0,    1030, 0,    2825, 2191, 0,    1416, 595,  0,    308,  0,    269,  0,
    0,    0,    0,    927,  0,    733,  0,    1548, 0,    52,   1032, 402,  0,    2093, 0,    0,
    0,    480,  0,    251,  0,    0,    0,    0,    0,    0,    618,  2545, 61,   1375, 12,   216,
    1137, 781,  0,    858,  521,  0,    466,  0,    1417, 1104, 2748, 3202, 422,  131,  0,    0,
    1704, 417,  3265, 951,  38,   0,    315,  0,    0,    1019, 161,  0,    0,    0,    673,  821,
    869,  1087, 2351, 643,  0,    833,  533,  0,    0,    866,  677,  491,  951,  1533, 0,    1397,
    0,    0,    3208, 0,    0,    393,  2042, 0,    700,  650,  0,    853,  2051, 0,    3252, 1467,
    0,    0,    2338, 276,  0,    0,    0,    456,  1414, 156,  0,    0,    1500, 949,  673,  300,
    150,  105,  562,  0,    1403, 22,   911,  0,    0,    868,  0,    62,   0,    433,  736,  3076,
    0,    112,  0,    1539, 0,    390,  980,  0,    0,    1208, 980,  295,  0,    2710, 0,    2670,
    0,    0,    1135, 0,    518,  671,  3247, 0,    0,    0,    145,  455,  0,    0,    0,    0,
    1443, 928,  0,    0,    295};

int MangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 3269;
    }
    return mangledkG[sum];
}

int MangledPerfectHash(const char *key)
{
    if (strlen(key) > 40)
        return 0;

    return (MangledHashG(key, mangledkT1) + MangledHashG(key, mangledkT2)) % 3269;
}

constexpr int unmangledkT1[] = {185, 179, 43, 263, 143, 11,  69,  176, 125, 3,  223,
                                196, 236, 59, 133, 183, 251, 270, 202, 193, 91, 207,
                                17,  29,  81, 181, 160, 152, 51,  186, 88,  252};
constexpr int unmangledkT2[] = {30,  35,  282, 170, 39, 137, 74,  279, 174, 219, 203,
                                269, 2,   226, 58,  37, 171, 51,  273, 0,   210, 176,
                                91,  234, 148, 247, 18, 234, 221, 137, 189, 99};
constexpr int unmangledkG[]  = {
    0,   0,   155, 53,  0,   0,   0,   0,   0,   0,   0,   244, 0,   0,   43,  280, 0,   121, 268,
    0,   44,  0,   0,   117, 0,   0,   0,   144, 0,   54,  141, 246, 154, 74,  0,   97,  0,   137,
    88,  194, 0,   48,  79,  0,   0,   0,   0,   3,   0,   214, 0,   250, 41,  0,   101, 134, 0,
    0,   231, 278, 68,  237, 0,   0,   139, 0,   195, 121, 269, 0,   228, 0,   202, 236, 0,   0,
    166, 62,  0,   0,   176, 209, 66,  234, 0,   0,   207, 0,   0,   148, 118, 0,   82,  0,   268,
    159, 0,   240, 0,   0,   0,   150, 0,   165, 137, 0,   0,   38,  0,   140, 20,  190, 0,   0,
    139, 0,   6,   142, 68,  46,  0,   115, 134, 138, 0,   72,  22,  85,  267, 148, 50,  0,   271,
    30,  227, 25,  157, 111, 108, 172, 92,  213, 40,  213, 0,   165, 168, 0,   0,   151, 12,  259,
    0,   275, 260, 260, 193, 28,  190, 0,   60,  8,   29,  97,  277, 79,  0,   244, 103, 105, 234,
    13,  16,  33,  160, 99,  0,   31,  127, 0,   0,   192, 0,   208, 0,   118, 0,   112, 0,   227,
    159, 168, 0,   234, 0,   67,  128, 168, 267, 212, 254, 111, 237, 72,  0,   68,  159, 0,   0,
    0,   0,   0,   138, 209, 114, 0,   40,  0,   234, 0,   34,  20,  107, 94,  0,   199, 43,  50,
    0,   245, 218, 190, 192, 0,   0,   0,   176, 232, 80,  0,   73,  99,  37,  0,   0,   3,   0,
    0,   277, 0,   0,   81,  77,  0,   225, 0,   82,  50,  135, 184, 267, 235, 126, 178, 247, 176,
    130, 1,   225, 47,  279, 94,  0,   0,   0,   0,   0,   0,   175, 0,   13,  155, 0,   143};

int UnmangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 284;
    }
    return unmangledkG[sum];
}

int UnmangledPerfectHash(const char *key)
{
    if (strlen(key) > 32)
        return 0;

    return (UnmangledHashG(key, unmangledkT1) + UnmangledHashG(key, unmangledkT2)) % 284;
}

}  // namespace

namespace sh
{

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvPrime = 16777619u;

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvOffsetBasis = 0x811c9dc5u;

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvPrime =
    static_cast<size_t>(1099511628211ull);

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvOffsetBasis =
    static_cast<size_t>(0xcbf29ce484222325ull);

uint32_t ImmutableString::mangledNameHash() const
{
    return MangledPerfectHash(data());
}

uint32_t ImmutableString::unmangledNameHash() const
{
    return UnmangledPerfectHash(data());
}

}  // namespace sh
