// Generated by `wit-bindgen` 0.16.0. DO NOT EDIT!
pub mod wasi {
  pub mod cli {
    
    #[allow(clippy::all)]
    pub mod environment {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      #[allow(unused_unsafe, clippy::all)]
      /// Get the POSIX-style environment variables.
      /// 
      /// Each environment variable is provided as a pair of string variable names
      /// and string value.
      /// 
      /// Morally, these are a value import, but until value imports are available
      /// in the component model, this import function should return the same
      /// values each time it is called.
      pub fn get_environment() -> wit_bindgen::rt::vec::Vec::<(wit_bindgen::rt::string::String,wit_bindgen::rt::string::String,)>{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(4))]
          struct RetArea([u8; 8]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let ptr0 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:cli/environment@0.2.0")]
          extern "C" {
            #[link_name = "get-environment"]
            fn wit_import(_: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, ){ unreachable!() }
          wit_import(ptr0);
          let l1 = *((ptr0 + 0) as *const i32);
          let l2 = *((ptr0 + 4) as *const i32);
          let base9 = l1;
          let len9 = l2;
          let mut result9 = Vec::with_capacity(len9 as usize);
          for i in 0..len9 {
            let base = base9 + i * 16;
            let e9 = {
              let l3 = *((base + 0) as *const i32);
              let l4 = *((base + 4) as *const i32);
              let len5 = l4 as usize;
              let bytes5 = Vec::from_raw_parts(l3 as *mut _, len5, len5);
              let l6 = *((base + 8) as *const i32);
              let l7 = *((base + 12) as *const i32);
              let len8 = l7 as usize;
              let bytes8 = Vec::from_raw_parts(l6 as *mut _, len8, len8);
              
              (wit_bindgen::rt::string_lift(bytes5), wit_bindgen::rt::string_lift(bytes8))
            };
            result9.push(e9);
          }
          wit_bindgen::rt::dealloc(base9, (len9 as usize) * 16, 4);
          result9
        }
      }
      #[allow(unused_unsafe, clippy::all)]
      /// Get the POSIX-style arguments to the program.
      pub fn get_arguments() -> wit_bindgen::rt::vec::Vec::<wit_bindgen::rt::string::String>{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(4))]
          struct RetArea([u8; 8]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let ptr0 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:cli/environment@0.2.0")]
          extern "C" {
            #[link_name = "get-arguments"]
            fn wit_import(_: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, ){ unreachable!() }
          wit_import(ptr0);
          let l1 = *((ptr0 + 0) as *const i32);
          let l2 = *((ptr0 + 4) as *const i32);
          let base6 = l1;
          let len6 = l2;
          let mut result6 = Vec::with_capacity(len6 as usize);
          for i in 0..len6 {
            let base = base6 + i * 8;
            let e6 = {
              let l3 = *((base + 0) as *const i32);
              let l4 = *((base + 4) as *const i32);
              let len5 = l4 as usize;
              let bytes5 = Vec::from_raw_parts(l3 as *mut _, len5, len5);
              
              wit_bindgen::rt::string_lift(bytes5)
            };
            result6.push(e6);
          }
          wit_bindgen::rt::dealloc(base6, (len6 as usize) * 8, 4);
          result6
        }
      }
      #[allow(unused_unsafe, clippy::all)]
      /// Return a path that programs should use as their initial current working
      /// directory, interpreting `.` as shorthand for this.
      pub fn initial_cwd() -> Option<wit_bindgen::rt::string::String>{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(4))]
          struct RetArea([u8; 12]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let ptr0 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:cli/environment@0.2.0")]
          extern "C" {
            #[link_name = "initial-cwd"]
            fn wit_import(_: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, ){ unreachable!() }
          wit_import(ptr0);
          let l1 = i32::from(*((ptr0 + 0) as *const u8));
          match l1 {
            0 => None,
            1 => {
              let e = {
                let l2 = *((ptr0 + 4) as *const i32);
                let l3 = *((ptr0 + 8) as *const i32);
                let len4 = l3 as usize;
                let bytes4 = Vec::from_raw_parts(l2 as *mut _, len4, len4);
                
                wit_bindgen::rt::string_lift(bytes4)
              };
              Some(e)
            }
            _ => wit_bindgen::rt::invalid_enum_discriminant(),
          }
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod exit {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      #[allow(unused_unsafe, clippy::all)]
      /// Exit the current instance and any linked instances.
      pub fn exit(status: Result<(),()>,){
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          let result0 = match status {
            Ok(_) => { 0i32 },
            Err(_) => { 1i32 },
          };
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:cli/exit@0.2.0")]
          extern "C" {
            #[link_name = "exit"]
            fn wit_import(_: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, ){ unreachable!() }
          wit_import(result0);
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod stdin {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      pub type InputStream = super::super::super::wasi::io::streams::InputStream;
      #[allow(unused_unsafe, clippy::all)]
      pub fn get_stdin() -> InputStream{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:cli/stdin@0.2.0")]
          extern "C" {
            #[link_name = "get-stdin"]
            fn wit_import() -> i32;
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import() -> i32{ unreachable!() }
          let ret = wit_import();
          super::super::super::wasi::io::streams::InputStream::from_handle(ret as u32)
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod stdout {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      pub type OutputStream = super::super::super::wasi::io::streams::OutputStream;
      #[allow(unused_unsafe, clippy::all)]
      pub fn get_stdout() -> OutputStream{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:cli/stdout@0.2.0")]
          extern "C" {
            #[link_name = "get-stdout"]
            fn wit_import() -> i32;
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import() -> i32{ unreachable!() }
          let ret = wit_import();
          super::super::super::wasi::io::streams::OutputStream::from_handle(ret as u32)
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod stderr {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      pub type OutputStream = super::super::super::wasi::io::streams::OutputStream;
      #[allow(unused_unsafe, clippy::all)]
      pub fn get_stderr() -> OutputStream{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:cli/stderr@0.2.0")]
          extern "C" {
            #[link_name = "get-stderr"]
            fn wit_import() -> i32;
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import() -> i32{ unreachable!() }
          let ret = wit_import();
          super::super::super::wasi::io::streams::OutputStream::from_handle(ret as u32)
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod terminal_input {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      /// The input side of a terminal.
      
      #[derive(Debug)]
      #[repr(transparent)]
      pub struct TerminalInput{
        handle: wit_bindgen::rt::Resource<TerminalInput>,
      }
      
      impl TerminalInput{
        #[doc(hidden)]
        pub unsafe fn from_handle(handle: u32) -> Self {
          Self {
            handle: wit_bindgen::rt::Resource::from_handle(handle),
          }
        }
        
        #[doc(hidden)]
        pub fn into_handle(self) -> u32 {
          wit_bindgen::rt::Resource::into_handle(self.handle)
        }
        
        #[doc(hidden)]
        pub fn handle(&self) -> u32 {
          wit_bindgen::rt::Resource::handle(&self.handle)
        }
      }
      
      
      unsafe impl wit_bindgen::rt::WasmResource for TerminalInput{
        #[inline]
        unsafe fn drop(_handle: u32) {
          #[cfg(not(target_arch = "wasm32"))]
          unreachable!();
          
          #[cfg(target_arch = "wasm32")]
          {
            #[link(wasm_import_module = "wasi:cli/terminal-input@0.2.0")]
            extern "C" {
              #[link_name = "[resource-drop]terminal-input"]
              fn drop(_: u32);
            }
            
            drop(_handle);
          }
        }
      }
      
      
    }
    
    
    #[allow(clippy::all)]
    pub mod terminal_output {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      /// The output side of a terminal.
      
      #[derive(Debug)]
      #[repr(transparent)]
      pub struct TerminalOutput{
        handle: wit_bindgen::rt::Resource<TerminalOutput>,
      }
      
      impl TerminalOutput{
        #[doc(hidden)]
        pub unsafe fn from_handle(handle: u32) -> Self {
          Self {
            handle: wit_bindgen::rt::Resource::from_handle(handle),
          }
        }
        
        #[doc(hidden)]
        pub fn into_handle(self) -> u32 {
          wit_bindgen::rt::Resource::into_handle(self.handle)
        }
        
        #[doc(hidden)]
        pub fn handle(&self) -> u32 {
          wit_bindgen::rt::Resource::handle(&self.handle)
        }
      }
      
      
      unsafe impl wit_bindgen::rt::WasmResource for TerminalOutput{
        #[inline]
        unsafe fn drop(_handle: u32) {
          #[cfg(not(target_arch = "wasm32"))]
          unreachable!();
          
          #[cfg(target_arch = "wasm32")]
          {
            #[link(wasm_import_module = "wasi:cli/terminal-output@0.2.0")]
            extern "C" {
              #[link_name = "[resource-drop]terminal-output"]
              fn drop(_: u32);
            }
            
            drop(_handle);
          }
        }
      }
      
      
    }
    
    
    #[allow(clippy::all)]
    pub mod terminal_stdin {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      pub type TerminalInput = super::super::super::wasi::cli::terminal_input::TerminalInput;
      #[allow(unused_unsafe, clippy::all)]
      /// If stdin is connected to a terminal, return a `terminal-input` handle
      /// allowing further interaction with it.
      pub fn get_terminal_stdin() -> Option<TerminalInput>{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(4))]
          struct RetArea([u8; 8]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let ptr0 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:cli/terminal-stdin@0.2.0")]
          extern "C" {
            #[link_name = "get-terminal-stdin"]
            fn wit_import(_: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, ){ unreachable!() }
          wit_import(ptr0);
          let l1 = i32::from(*((ptr0 + 0) as *const u8));
          match l1 {
            0 => None,
            1 => {
              let e = {
                let l2 = *((ptr0 + 4) as *const i32);
                
                super::super::super::wasi::cli::terminal_input::TerminalInput::from_handle(l2 as u32)
              };
              Some(e)
            }
            _ => wit_bindgen::rt::invalid_enum_discriminant(),
          }
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod terminal_stdout {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      pub type TerminalOutput = super::super::super::wasi::cli::terminal_output::TerminalOutput;
      #[allow(unused_unsafe, clippy::all)]
      /// If stdout is connected to a terminal, return a `terminal-output` handle
      /// allowing further interaction with it.
      pub fn get_terminal_stdout() -> Option<TerminalOutput>{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(4))]
          struct RetArea([u8; 8]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let ptr0 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:cli/terminal-stdout@0.2.0")]
          extern "C" {
            #[link_name = "get-terminal-stdout"]
            fn wit_import(_: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, ){ unreachable!() }
          wit_import(ptr0);
          let l1 = i32::from(*((ptr0 + 0) as *const u8));
          match l1 {
            0 => None,
            1 => {
              let e = {
                let l2 = *((ptr0 + 4) as *const i32);
                
                super::super::super::wasi::cli::terminal_output::TerminalOutput::from_handle(l2 as u32)
              };
              Some(e)
            }
            _ => wit_bindgen::rt::invalid_enum_discriminant(),
          }
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod terminal_stderr {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      pub type TerminalOutput = super::super::super::wasi::cli::terminal_output::TerminalOutput;
      #[allow(unused_unsafe, clippy::all)]
      /// If stderr is connected to a terminal, return a `terminal-output` handle
      /// allowing further interaction with it.
      pub fn get_terminal_stderr() -> Option<TerminalOutput>{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(4))]
          struct RetArea([u8; 8]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let ptr0 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:cli/terminal-stderr@0.2.0")]
          extern "C" {
            #[link_name = "get-terminal-stderr"]
            fn wit_import(_: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, ){ unreachable!() }
          wit_import(ptr0);
          let l1 = i32::from(*((ptr0 + 0) as *const u8));
          match l1 {
            0 => None,
            1 => {
              let e = {
                let l2 = *((ptr0 + 4) as *const i32);
                
                super::super::super::wasi::cli::terminal_output::TerminalOutput::from_handle(l2 as u32)
              };
              Some(e)
            }
            _ => wit_bindgen::rt::invalid_enum_discriminant(),
          }
        }
      }
      
    }
    
  }
  pub mod clocks {
    
    #[allow(clippy::all)]
    pub mod monotonic_clock {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      pub type Pollable = super::super::super::wasi::io::poll::Pollable;
      /// An instant in time, in nanoseconds. An instant is relative to an
      /// unspecified initial value, and can only be compared to instances from
      /// the same monotonic-clock.
      pub type Instant = u64;
      /// A duration of time, in nanoseconds.
      pub type Duration = u64;
      #[allow(unused_unsafe, clippy::all)]
      /// Read the current value of the clock.
      /// 
      /// The clock is monotonic, therefore calling this function repeatedly will
      /// produce a sequence of non-decreasing values.
      pub fn now() -> Instant{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:clocks/monotonic-clock@0.2.0")]
          extern "C" {
            #[link_name = "now"]
            fn wit_import() -> i64;
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import() -> i64{ unreachable!() }
          let ret = wit_import();
          ret as u64
        }
      }
      #[allow(unused_unsafe, clippy::all)]
      /// Query the resolution of the clock. Returns the duration of time
      /// corresponding to a clock tick.
      pub fn resolution() -> Duration{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:clocks/monotonic-clock@0.2.0")]
          extern "C" {
            #[link_name = "resolution"]
            fn wit_import() -> i64;
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import() -> i64{ unreachable!() }
          let ret = wit_import();
          ret as u64
        }
      }
      #[allow(unused_unsafe, clippy::all)]
      /// Create a `pollable` which will resolve once the specified instant
      /// occured.
      pub fn subscribe_instant(when: Instant,) -> Pollable{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:clocks/monotonic-clock@0.2.0")]
          extern "C" {
            #[link_name = "subscribe-instant"]
            fn wit_import(_: i64, ) -> i32;
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i64, ) -> i32{ unreachable!() }
          let ret = wit_import(wit_bindgen::rt::as_i64(when));
          super::super::super::wasi::io::poll::Pollable::from_handle(ret as u32)
        }
      }
      #[allow(unused_unsafe, clippy::all)]
      /// Create a `pollable` which will resolve once the given duration has
      /// elapsed, starting at the time at which this function was called.
      /// occured.
      pub fn subscribe_duration(when: Duration,) -> Pollable{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:clocks/monotonic-clock@0.2.0")]
          extern "C" {
            #[link_name = "subscribe-duration"]
            fn wit_import(_: i64, ) -> i32;
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i64, ) -> i32{ unreachable!() }
          let ret = wit_import(wit_bindgen::rt::as_i64(when));
          super::super::super::wasi::io::poll::Pollable::from_handle(ret as u32)
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod wall_clock {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      /// A time and date in seconds plus nanoseconds.
      #[repr(C)]
      #[derive(Clone, Copy)]
      pub struct Datetime {
        pub seconds: u64,
        pub nanoseconds: u32,
      }
      impl ::core::fmt::Debug for Datetime {
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          f.debug_struct("Datetime").field("seconds", &self.seconds).field("nanoseconds", &self.nanoseconds).finish()
        }
      }
      #[allow(unused_unsafe, clippy::all)]
      /// Read the current value of the clock.
      /// 
      /// This clock is not monotonic, therefore calling this function repeatedly
      /// will not necessarily produce a sequence of non-decreasing values.
      /// 
      /// The returned timestamps represent the number of seconds since
      /// 1970-01-01T00:00:00Z, also known as [POSIX's Seconds Since the Epoch],
      /// also known as [Unix Time].
      /// 
      /// The nanoseconds field of the output is always less than 1000000000.
      /// 
      /// [POSIX's Seconds Since the Epoch]: https://pubs.opengroup.org/onlinepubs/9699919799/xrat/V4_xbd_chap04.html#tag_21_04_16
      /// [Unix Time]: https://en.wikipedia.org/wiki/Unix_time
      pub fn now() -> Datetime{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(8))]
          struct RetArea([u8; 16]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let ptr0 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:clocks/wall-clock@0.2.0")]
          extern "C" {
            #[link_name = "now"]
            fn wit_import(_: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, ){ unreachable!() }
          wit_import(ptr0);
          let l1 = *((ptr0 + 0) as *const i64);
          let l2 = *((ptr0 + 8) as *const i32);
          Datetime{
            seconds: l1 as u64,
            nanoseconds: l2 as u32,
          }
        }
      }
      #[allow(unused_unsafe, clippy::all)]
      /// Query the resolution of the clock.
      /// 
      /// The nanoseconds field of the output is always less than 1000000000.
      pub fn resolution() -> Datetime{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(8))]
          struct RetArea([u8; 16]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let ptr0 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:clocks/wall-clock@0.2.0")]
          extern "C" {
            #[link_name = "resolution"]
            fn wit_import(_: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, ){ unreachable!() }
          wit_import(ptr0);
          let l1 = *((ptr0 + 0) as *const i64);
          let l2 = *((ptr0 + 8) as *const i32);
          Datetime{
            seconds: l1 as u64,
            nanoseconds: l2 as u32,
          }
        }
      }
      
    }
    
  }
  pub mod filesystem {
    
    #[allow(clippy::all)]
    pub mod types {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      pub type InputStream = super::super::super::wasi::io::streams::InputStream;
      pub type OutputStream = super::super::super::wasi::io::streams::OutputStream;
      pub type Error = super::super::super::wasi::io::streams::Error;
      pub type Datetime = super::super::super::wasi::clocks::wall_clock::Datetime;
      /// File size or length of a region within a file.
      pub type Filesize = u64;
      /// The type of a filesystem object referenced by a descriptor.
      /// 
      /// Note: This was called `filetype` in earlier versions of WASI.
      #[repr(u8)]
      #[derive(Clone, Copy, Eq, PartialEq)]
      pub enum DescriptorType {
        /// The type of the descriptor or file is unknown or is different from
        /// any of the other types specified.
        Unknown,
        /// The descriptor refers to a block device inode.
        BlockDevice,
        /// The descriptor refers to a character device inode.
        CharacterDevice,
        /// The descriptor refers to a directory inode.
        Directory,
        /// The descriptor refers to a named pipe.
        Fifo,
        /// The file refers to a symbolic link inode.
        SymbolicLink,
        /// The descriptor refers to a regular file inode.
        RegularFile,
        /// The descriptor refers to a socket.
        Socket,
      }
      impl ::core::fmt::Debug for DescriptorType {
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          match self {
            DescriptorType::Unknown => {
              f.debug_tuple("DescriptorType::Unknown").finish()
            }
            DescriptorType::BlockDevice => {
              f.debug_tuple("DescriptorType::BlockDevice").finish()
            }
            DescriptorType::CharacterDevice => {
              f.debug_tuple("DescriptorType::CharacterDevice").finish()
            }
            DescriptorType::Directory => {
              f.debug_tuple("DescriptorType::Directory").finish()
            }
            DescriptorType::Fifo => {
              f.debug_tuple("DescriptorType::Fifo").finish()
            }
            DescriptorType::SymbolicLink => {
              f.debug_tuple("DescriptorType::SymbolicLink").finish()
            }
            DescriptorType::RegularFile => {
              f.debug_tuple("DescriptorType::RegularFile").finish()
            }
            DescriptorType::Socket => {
              f.debug_tuple("DescriptorType::Socket").finish()
            }
          }
        }
      }
      
      impl DescriptorType{
        pub(crate) unsafe fn _lift(val: u8) -> DescriptorType{
          if !cfg!(debug_assertions) {
            return ::core::mem::transmute(val);
          }
          
          match val {
            0 => DescriptorType::Unknown,
            1 => DescriptorType::BlockDevice,
            2 => DescriptorType::CharacterDevice,
            3 => DescriptorType::Directory,
            4 => DescriptorType::Fifo,
            5 => DescriptorType::SymbolicLink,
            6 => DescriptorType::RegularFile,
            7 => DescriptorType::Socket,
            
            _ => panic!("invalid enum discriminant"),
          }
        }
      }
      
      wit_bindgen::bitflags::bitflags! {
        /// Descriptor flags.
        /// 
        /// Note: This was called `fdflags` in earlier versions of WASI.
        #[derive(PartialEq, Eq, PartialOrd, Ord, Hash, Debug, Clone, Copy)]
        pub struct DescriptorFlags: u8 {
          /// Read mode: Data can be read.
          const READ = 1 << 0;
          /// Write mode: Data can be written to.
          const WRITE = 1 << 1;
          /// Request that writes be performed according to synchronized I/O file
          /// integrity completion. The data stored in the file and the file's
          /// metadata are synchronized. This is similar to `O_SYNC` in POSIX.
          /// 
          /// The precise semantics of this operation have not yet been defined for
          /// WASI. At this time, it should be interpreted as a request, and not a
          /// requirement.
          const FILE_INTEGRITY_SYNC = 1 << 2;
          /// Request that writes be performed according to synchronized I/O data
          /// integrity completion. Only the data stored in the file is
          /// synchronized. This is similar to `O_DSYNC` in POSIX.
          /// 
          /// The precise semantics of this operation have not yet been defined for
          /// WASI. At this time, it should be interpreted as a request, and not a
          /// requirement.
          const DATA_INTEGRITY_SYNC = 1 << 3;
          /// Requests that reads be performed at the same level of integrety
          /// requested for writes. This is similar to `O_RSYNC` in POSIX.
          /// 
          /// The precise semantics of this operation have not yet been defined for
          /// WASI. At this time, it should be interpreted as a request, and not a
          /// requirement.
          const REQUESTED_WRITE_SYNC = 1 << 4;
          /// Mutating directories mode: Directory contents may be mutated.
          /// 
          /// When this flag is unset on a descriptor, operations using the
          /// descriptor which would create, rename, delete, modify the data or
          /// metadata of filesystem objects, or obtain another handle which
          /// would permit any of those, shall fail with `error-code::read-only` if
          /// they would otherwise succeed.
          /// 
          /// This may only be set on directories.
          const MUTATE_DIRECTORY = 1 << 5;
        }
      }
      wit_bindgen::bitflags::bitflags! {
        /// Flags determining the method of how paths are resolved.
        #[derive(PartialEq, Eq, PartialOrd, Ord, Hash, Debug, Clone, Copy)]
        pub struct PathFlags: u8 {
          /// As long as the resolved path corresponds to a symbolic link, it is
          /// expanded.
          const SYMLINK_FOLLOW = 1 << 0;
        }
      }
      wit_bindgen::bitflags::bitflags! {
        /// Open flags used by `open-at`.
        #[derive(PartialEq, Eq, PartialOrd, Ord, Hash, Debug, Clone, Copy)]
        pub struct OpenFlags: u8 {
          /// Create file if it does not exist, similar to `O_CREAT` in POSIX.
          const CREATE = 1 << 0;
          /// Fail if not a directory, similar to `O_DIRECTORY` in POSIX.
          const DIRECTORY = 1 << 1;
          /// Fail if file already exists, similar to `O_EXCL` in POSIX.
          const EXCLUSIVE = 1 << 2;
          /// Truncate file to size 0, similar to `O_TRUNC` in POSIX.
          const TRUNCATE = 1 << 3;
        }
      }
      /// Number of hard links to an inode.
      pub type LinkCount = u64;
      /// File attributes.
      /// 
      /// Note: This was called `filestat` in earlier versions of WASI.
      #[repr(C)]
      #[derive(Clone, Copy)]
      pub struct DescriptorStat {
        /// File type.
        pub type_: DescriptorType,
        /// Number of hard links to the file.
        pub link_count: LinkCount,
        /// For regular files, the file size in bytes. For symbolic links, the
        /// length in bytes of the pathname contained in the symbolic link.
        pub size: Filesize,
        /// Last data access timestamp.
        /// 
        /// If the `option` is none, the platform doesn't maintain an access
        /// timestamp for this file.
        pub data_access_timestamp: Option<Datetime>,
        /// Last data modification timestamp.
        /// 
        /// If the `option` is none, the platform doesn't maintain a
        /// modification timestamp for this file.
        pub data_modification_timestamp: Option<Datetime>,
        /// Last file status-change timestamp.
        /// 
        /// If the `option` is none, the platform doesn't maintain a
        /// status-change timestamp for this file.
        pub status_change_timestamp: Option<Datetime>,
      }
      impl ::core::fmt::Debug for DescriptorStat {
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          f.debug_struct("DescriptorStat").field("type", &self.type_).field("link-count", &self.link_count).field("size", &self.size).field("data-access-timestamp", &self.data_access_timestamp).field("data-modification-timestamp", &self.data_modification_timestamp).field("status-change-timestamp", &self.status_change_timestamp).finish()
        }
      }
      /// When setting a timestamp, this gives the value to set it to.
      #[derive(Clone, Copy)]
      pub enum NewTimestamp{
        /// Leave the timestamp set to its previous value.
        NoChange,
        /// Set the timestamp to the current time of the system clock associated
        /// with the filesystem.
        Now,
        /// Set the timestamp to the given value.
        Timestamp(Datetime),
      }
      impl ::core::fmt::Debug for NewTimestamp {
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          match self {
            NewTimestamp::NoChange => {
              f.debug_tuple("NewTimestamp::NoChange").finish()
            }
            NewTimestamp::Now => {
              f.debug_tuple("NewTimestamp::Now").finish()
            }
            NewTimestamp::Timestamp(e) => {
              f.debug_tuple("NewTimestamp::Timestamp").field(e).finish()
            }
          }
        }
      }
      /// A directory entry.
      #[derive(Clone)]
      pub struct DirectoryEntry {
        /// The type of the file referred to by this directory entry.
        pub type_: DescriptorType,
        /// The name of the object.
        pub name: wit_bindgen::rt::string::String,
      }
      impl ::core::fmt::Debug for DirectoryEntry {
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          f.debug_struct("DirectoryEntry").field("type", &self.type_).field("name", &self.name).finish()
        }
      }
      /// Error codes returned by functions, similar to `errno` in POSIX.
      /// Not all of these error codes are returned by the functions provided by this
      /// API; some are used in higher-level library layers, and others are provided
      /// merely for alignment with POSIX.
      #[repr(u8)]
      #[derive(Clone, Copy, Eq, PartialEq)]
      pub enum ErrorCode {
        /// Permission denied, similar to `EACCES` in POSIX.
        Access,
        /// Resource unavailable, or operation would block, similar to `EAGAIN` and `EWOULDBLOCK` in POSIX.
        WouldBlock,
        /// Connection already in progress, similar to `EALREADY` in POSIX.
        Already,
        /// Bad descriptor, similar to `EBADF` in POSIX.
        BadDescriptor,
        /// Device or resource busy, similar to `EBUSY` in POSIX.
        Busy,
        /// Resource deadlock would occur, similar to `EDEADLK` in POSIX.
        Deadlock,
        /// Storage quota exceeded, similar to `EDQUOT` in POSIX.
        Quota,
        /// File exists, similar to `EEXIST` in POSIX.
        Exist,
        /// File too large, similar to `EFBIG` in POSIX.
        FileTooLarge,
        /// Illegal byte sequence, similar to `EILSEQ` in POSIX.
        IllegalByteSequence,
        /// Operation in progress, similar to `EINPROGRESS` in POSIX.
        InProgress,
        /// Interrupted function, similar to `EINTR` in POSIX.
        Interrupted,
        /// Invalid argument, similar to `EINVAL` in POSIX.
        Invalid,
        /// I/O error, similar to `EIO` in POSIX.
        Io,
        /// Is a directory, similar to `EISDIR` in POSIX.
        IsDirectory,
        /// Too many levels of symbolic links, similar to `ELOOP` in POSIX.
        Loop,
        /// Too many links, similar to `EMLINK` in POSIX.
        TooManyLinks,
        /// Message too large, similar to `EMSGSIZE` in POSIX.
        MessageSize,
        /// Filename too long, similar to `ENAMETOOLONG` in POSIX.
        NameTooLong,
        /// No such device, similar to `ENODEV` in POSIX.
        NoDevice,
        /// No such file or directory, similar to `ENOENT` in POSIX.
        NoEntry,
        /// No locks available, similar to `ENOLCK` in POSIX.
        NoLock,
        /// Not enough space, similar to `ENOMEM` in POSIX.
        InsufficientMemory,
        /// No space left on device, similar to `ENOSPC` in POSIX.
        InsufficientSpace,
        /// Not a directory or a symbolic link to a directory, similar to `ENOTDIR` in POSIX.
        NotDirectory,
        /// Directory not empty, similar to `ENOTEMPTY` in POSIX.
        NotEmpty,
        /// State not recoverable, similar to `ENOTRECOVERABLE` in POSIX.
        NotRecoverable,
        /// Not supported, similar to `ENOTSUP` and `ENOSYS` in POSIX.
        Unsupported,
        /// Inappropriate I/O control operation, similar to `ENOTTY` in POSIX.
        NoTty,
        /// No such device or address, similar to `ENXIO` in POSIX.
        NoSuchDevice,
        /// Value too large to be stored in data type, similar to `EOVERFLOW` in POSIX.
        Overflow,
        /// Operation not permitted, similar to `EPERM` in POSIX.
        NotPermitted,
        /// Broken pipe, similar to `EPIPE` in POSIX.
        Pipe,
        /// Read-only file system, similar to `EROFS` in POSIX.
        ReadOnly,
        /// Invalid seek, similar to `ESPIPE` in POSIX.
        InvalidSeek,
        /// Text file busy, similar to `ETXTBSY` in POSIX.
        TextFileBusy,
        /// Cross-device link, similar to `EXDEV` in POSIX.
        CrossDevice,
      }
      impl ErrorCode{
        pub fn name(&self) -> &'static str {
          match self {
            ErrorCode::Access => "access",
            ErrorCode::WouldBlock => "would-block",
            ErrorCode::Already => "already",
            ErrorCode::BadDescriptor => "bad-descriptor",
            ErrorCode::Busy => "busy",
            ErrorCode::Deadlock => "deadlock",
            ErrorCode::Quota => "quota",
            ErrorCode::Exist => "exist",
            ErrorCode::FileTooLarge => "file-too-large",
            ErrorCode::IllegalByteSequence => "illegal-byte-sequence",
            ErrorCode::InProgress => "in-progress",
            ErrorCode::Interrupted => "interrupted",
            ErrorCode::Invalid => "invalid",
            ErrorCode::Io => "io",
            ErrorCode::IsDirectory => "is-directory",
            ErrorCode::Loop => "loop",
            ErrorCode::TooManyLinks => "too-many-links",
            ErrorCode::MessageSize => "message-size",
            ErrorCode::NameTooLong => "name-too-long",
            ErrorCode::NoDevice => "no-device",
            ErrorCode::NoEntry => "no-entry",
            ErrorCode::NoLock => "no-lock",
            ErrorCode::InsufficientMemory => "insufficient-memory",
            ErrorCode::InsufficientSpace => "insufficient-space",
            ErrorCode::NotDirectory => "not-directory",
            ErrorCode::NotEmpty => "not-empty",
            ErrorCode::NotRecoverable => "not-recoverable",
            ErrorCode::Unsupported => "unsupported",
            ErrorCode::NoTty => "no-tty",
            ErrorCode::NoSuchDevice => "no-such-device",
            ErrorCode::Overflow => "overflow",
            ErrorCode::NotPermitted => "not-permitted",
            ErrorCode::Pipe => "pipe",
            ErrorCode::ReadOnly => "read-only",
            ErrorCode::InvalidSeek => "invalid-seek",
            ErrorCode::TextFileBusy => "text-file-busy",
            ErrorCode::CrossDevice => "cross-device",
          }
        }
        pub fn message(&self) -> &'static str {
          match self {
            ErrorCode::Access => "Permission denied, similar to `EACCES` in POSIX.",
            ErrorCode::WouldBlock => "Resource unavailable, or operation would block, similar to `EAGAIN` and `EWOULDBLOCK` in POSIX.",
            ErrorCode::Already => "Connection already in progress, similar to `EALREADY` in POSIX.",
            ErrorCode::BadDescriptor => "Bad descriptor, similar to `EBADF` in POSIX.",
            ErrorCode::Busy => "Device or resource busy, similar to `EBUSY` in POSIX.",
            ErrorCode::Deadlock => "Resource deadlock would occur, similar to `EDEADLK` in POSIX.",
            ErrorCode::Quota => "Storage quota exceeded, similar to `EDQUOT` in POSIX.",
            ErrorCode::Exist => "File exists, similar to `EEXIST` in POSIX.",
            ErrorCode::FileTooLarge => "File too large, similar to `EFBIG` in POSIX.",
            ErrorCode::IllegalByteSequence => "Illegal byte sequence, similar to `EILSEQ` in POSIX.",
            ErrorCode::InProgress => "Operation in progress, similar to `EINPROGRESS` in POSIX.",
            ErrorCode::Interrupted => "Interrupted function, similar to `EINTR` in POSIX.",
            ErrorCode::Invalid => "Invalid argument, similar to `EINVAL` in POSIX.",
            ErrorCode::Io => "I/O error, similar to `EIO` in POSIX.",
            ErrorCode::IsDirectory => "Is a directory, similar to `EISDIR` in POSIX.",
            ErrorCode::Loop => "Too many levels of symbolic links, similar to `ELOOP` in POSIX.",
            ErrorCode::TooManyLinks => "Too many links, similar to `EMLINK` in POSIX.",
            ErrorCode::MessageSize => "Message too large, similar to `EMSGSIZE` in POSIX.",
            ErrorCode::NameTooLong => "Filename too long, similar to `ENAMETOOLONG` in POSIX.",
            ErrorCode::NoDevice => "No such device, similar to `ENODEV` in POSIX.",
            ErrorCode::NoEntry => "No such file or directory, similar to `ENOENT` in POSIX.",
            ErrorCode::NoLock => "No locks available, similar to `ENOLCK` in POSIX.",
            ErrorCode::InsufficientMemory => "Not enough space, similar to `ENOMEM` in POSIX.",
            ErrorCode::InsufficientSpace => "No space left on device, similar to `ENOSPC` in POSIX.",
            ErrorCode::NotDirectory => "Not a directory or a symbolic link to a directory, similar to `ENOTDIR` in POSIX.",
            ErrorCode::NotEmpty => "Directory not empty, similar to `ENOTEMPTY` in POSIX.",
            ErrorCode::NotRecoverable => "State not recoverable, similar to `ENOTRECOVERABLE` in POSIX.",
            ErrorCode::Unsupported => "Not supported, similar to `ENOTSUP` and `ENOSYS` in POSIX.",
            ErrorCode::NoTty => "Inappropriate I/O control operation, similar to `ENOTTY` in POSIX.",
            ErrorCode::NoSuchDevice => "No such device or address, similar to `ENXIO` in POSIX.",
            ErrorCode::Overflow => "Value too large to be stored in data type, similar to `EOVERFLOW` in POSIX.",
            ErrorCode::NotPermitted => "Operation not permitted, similar to `EPERM` in POSIX.",
            ErrorCode::Pipe => "Broken pipe, similar to `EPIPE` in POSIX.",
            ErrorCode::ReadOnly => "Read-only file system, similar to `EROFS` in POSIX.",
            ErrorCode::InvalidSeek => "Invalid seek, similar to `ESPIPE` in POSIX.",
            ErrorCode::TextFileBusy => "Text file busy, similar to `ETXTBSY` in POSIX.",
            ErrorCode::CrossDevice => "Cross-device link, similar to `EXDEV` in POSIX.",
          }
        }
      }
      impl ::core::fmt::Debug for ErrorCode{
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          f.debug_struct("ErrorCode")
          .field("code", &(*self as i32))
          .field("name", &self.name())
          .field("message", &self.message())
          .finish()
        }
      }
      impl ::core::fmt::Display for ErrorCode{
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          write!(f, "{} (error {})", self.name(), *self as i32)
        }
      }
      
      impl std::error::Error for ErrorCode{}
      
      impl ErrorCode{
        pub(crate) unsafe fn _lift(val: u8) -> ErrorCode{
          if !cfg!(debug_assertions) {
            return ::core::mem::transmute(val);
          }
          
          match val {
            0 => ErrorCode::Access,
            1 => ErrorCode::WouldBlock,
            2 => ErrorCode::Already,
            3 => ErrorCode::BadDescriptor,
            4 => ErrorCode::Busy,
            5 => ErrorCode::Deadlock,
            6 => ErrorCode::Quota,
            7 => ErrorCode::Exist,
            8 => ErrorCode::FileTooLarge,
            9 => ErrorCode::IllegalByteSequence,
            10 => ErrorCode::InProgress,
            11 => ErrorCode::Interrupted,
            12 => ErrorCode::Invalid,
            13 => ErrorCode::Io,
            14 => ErrorCode::IsDirectory,
            15 => ErrorCode::Loop,
            16 => ErrorCode::TooManyLinks,
            17 => ErrorCode::MessageSize,
            18 => ErrorCode::NameTooLong,
            19 => ErrorCode::NoDevice,
            20 => ErrorCode::NoEntry,
            21 => ErrorCode::NoLock,
            22 => ErrorCode::InsufficientMemory,
            23 => ErrorCode::InsufficientSpace,
            24 => ErrorCode::NotDirectory,
            25 => ErrorCode::NotEmpty,
            26 => ErrorCode::NotRecoverable,
            27 => ErrorCode::Unsupported,
            28 => ErrorCode::NoTty,
            29 => ErrorCode::NoSuchDevice,
            30 => ErrorCode::Overflow,
            31 => ErrorCode::NotPermitted,
            32 => ErrorCode::Pipe,
            33 => ErrorCode::ReadOnly,
            34 => ErrorCode::InvalidSeek,
            35 => ErrorCode::TextFileBusy,
            36 => ErrorCode::CrossDevice,
            
            _ => panic!("invalid enum discriminant"),
          }
        }
      }
      
      /// File or memory access pattern advisory information.
      #[repr(u8)]
      #[derive(Clone, Copy, Eq, PartialEq)]
      pub enum Advice {
        /// The application has no advice to give on its behavior with respect
        /// to the specified data.
        Normal,
        /// The application expects to access the specified data sequentially
        /// from lower offsets to higher offsets.
        Sequential,
        /// The application expects to access the specified data in a random
        /// order.
        Random,
        /// The application expects to access the specified data in the near
        /// future.
        WillNeed,
        /// The application expects that it will not access the specified data
        /// in the near future.
        DontNeed,
        /// The application expects to access the specified data once and then
        /// not reuse it thereafter.
        NoReuse,
      }
      impl ::core::fmt::Debug for Advice {
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          match self {
            Advice::Normal => {
              f.debug_tuple("Advice::Normal").finish()
            }
            Advice::Sequential => {
              f.debug_tuple("Advice::Sequential").finish()
            }
            Advice::Random => {
              f.debug_tuple("Advice::Random").finish()
            }
            Advice::WillNeed => {
              f.debug_tuple("Advice::WillNeed").finish()
            }
            Advice::DontNeed => {
              f.debug_tuple("Advice::DontNeed").finish()
            }
            Advice::NoReuse => {
              f.debug_tuple("Advice::NoReuse").finish()
            }
          }
        }
      }
      
      impl Advice{
        pub(crate) unsafe fn _lift(val: u8) -> Advice{
          if !cfg!(debug_assertions) {
            return ::core::mem::transmute(val);
          }
          
          match val {
            0 => Advice::Normal,
            1 => Advice::Sequential,
            2 => Advice::Random,
            3 => Advice::WillNeed,
            4 => Advice::DontNeed,
            5 => Advice::NoReuse,
            
            _ => panic!("invalid enum discriminant"),
          }
        }
      }
      
      /// A 128-bit hash value, split into parts because wasm doesn't have a
      /// 128-bit integer type.
      #[repr(C)]
      #[derive(Clone, Copy)]
      pub struct MetadataHashValue {
        /// 64 bits of a 128-bit hash value.
        pub lower: u64,
        /// Another 64 bits of a 128-bit hash value.
        pub upper: u64,
      }
      impl ::core::fmt::Debug for MetadataHashValue {
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          f.debug_struct("MetadataHashValue").field("lower", &self.lower).field("upper", &self.upper).finish()
        }
      }
      /// A descriptor is a reference to a filesystem object, which may be a file,
      /// directory, named pipe, special file, or other object on which filesystem
      /// calls may be made.
      
      #[derive(Debug)]
      #[repr(transparent)]
      pub struct Descriptor{
        handle: wit_bindgen::rt::Resource<Descriptor>,
      }
      
      impl Descriptor{
        #[doc(hidden)]
        pub unsafe fn from_handle(handle: u32) -> Self {
          Self {
            handle: wit_bindgen::rt::Resource::from_handle(handle),
          }
        }
        
        #[doc(hidden)]
        pub fn into_handle(self) -> u32 {
          wit_bindgen::rt::Resource::into_handle(self.handle)
        }
        
        #[doc(hidden)]
        pub fn handle(&self) -> u32 {
          wit_bindgen::rt::Resource::handle(&self.handle)
        }
      }
      
      
      unsafe impl wit_bindgen::rt::WasmResource for Descriptor{
        #[inline]
        unsafe fn drop(_handle: u32) {
          #[cfg(not(target_arch = "wasm32"))]
          unreachable!();
          
          #[cfg(target_arch = "wasm32")]
          {
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[resource-drop]descriptor"]
              fn drop(_: u32);
            }
            
            drop(_handle);
          }
        }
      }
      
      /// A stream of directory entries.
      
      #[derive(Debug)]
      #[repr(transparent)]
      pub struct DirectoryEntryStream{
        handle: wit_bindgen::rt::Resource<DirectoryEntryStream>,
      }
      
      impl DirectoryEntryStream{
        #[doc(hidden)]
        pub unsafe fn from_handle(handle: u32) -> Self {
          Self {
            handle: wit_bindgen::rt::Resource::from_handle(handle),
          }
        }
        
        #[doc(hidden)]
        pub fn into_handle(self) -> u32 {
          wit_bindgen::rt::Resource::into_handle(self.handle)
        }
        
        #[doc(hidden)]
        pub fn handle(&self) -> u32 {
          wit_bindgen::rt::Resource::handle(&self.handle)
        }
      }
      
      
      unsafe impl wit_bindgen::rt::WasmResource for DirectoryEntryStream{
        #[inline]
        unsafe fn drop(_handle: u32) {
          #[cfg(not(target_arch = "wasm32"))]
          unreachable!();
          
          #[cfg(target_arch = "wasm32")]
          {
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[resource-drop]directory-entry-stream"]
              fn drop(_: u32);
            }
            
            drop(_handle);
          }
        }
      }
      
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Return a stream for reading from a file, if available.
        /// 
        /// May fail with an error-code describing why the file cannot be read.
        /// 
        /// Multiple read, write, and append streams may be active on the same open
        /// file and they do not interfere with each other.
        /// 
        /// Note: This allows using `read-stream`, which is similar to `read` in POSIX.
        pub fn read_via_stream(&self,offset: Filesize,) -> Result<InputStream,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 8]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.read-via-stream"]
              fn wit_import(_: i32, _: i64, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(offset), ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 4) as *const i32);
                  
                  super::super::super::wasi::io::streams::InputStream::from_handle(l2 as u32)
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr0 + 4) as *const u8));
                  
                  ErrorCode::_lift(l3 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Return a stream for writing to a file, if available.
        /// 
        /// May fail with an error-code describing why the file cannot be written.
        /// 
        /// Note: This allows using `write-stream`, which is similar to `write` in
        /// POSIX.
        pub fn write_via_stream(&self,offset: Filesize,) -> Result<OutputStream,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 8]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.write-via-stream"]
              fn wit_import(_: i32, _: i64, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(offset), ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 4) as *const i32);
                  
                  super::super::super::wasi::io::streams::OutputStream::from_handle(l2 as u32)
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr0 + 4) as *const u8));
                  
                  ErrorCode::_lift(l3 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Return a stream for appending to a file, if available.
        /// 
        /// May fail with an error-code describing why the file cannot be appended.
        /// 
        /// Note: This allows using `write-stream`, which is similar to `write` with
        /// `O_APPEND` in in POSIX.
        pub fn append_via_stream(&self,) -> Result<OutputStream,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 8]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.append-via-stream"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 4) as *const i32);
                  
                  super::super::super::wasi::io::streams::OutputStream::from_handle(l2 as u32)
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr0 + 4) as *const u8));
                  
                  ErrorCode::_lift(l3 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Provide file advisory information on a descriptor.
        /// 
        /// This is similar to `posix_fadvise` in POSIX.
        pub fn advise(&self,offset: Filesize,length: Filesize,advice: Advice,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.advise"]
              fn wit_import(_: i32, _: i64, _: i64, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i64, _: i64, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(offset), wit_bindgen::rt::as_i64(length), advice.clone() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l2 = i32::from(*((ptr0 + 1) as *const u8));
                  
                  ErrorCode::_lift(l2 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Synchronize the data of a file to disk.
        /// 
        /// This function succeeds with no effect if the file descriptor is not
        /// opened for writing.
        /// 
        /// Note: This is similar to `fdatasync` in POSIX.
        pub fn sync_data(&self,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.sync-data"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l2 = i32::from(*((ptr0 + 1) as *const u8));
                  
                  ErrorCode::_lift(l2 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Get flags associated with a descriptor.
        /// 
        /// Note: This returns similar flags to `fcntl(fd, F_GETFL)` in POSIX.
        /// 
        /// Note: This returns the value that was the `fs_flags` value returned
        /// from `fdstat_get` in earlier versions of WASI.
        pub fn get_flags(&self,) -> Result<DescriptorFlags,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.get-flags"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = i32::from(*((ptr0 + 1) as *const u8));
                  
                  DescriptorFlags::empty() | DescriptorFlags::from_bits_retain(((l2 as u8) << 0) as _)
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr0 + 1) as *const u8));
                  
                  ErrorCode::_lift(l3 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Get the dynamic type of a descriptor.
        /// 
        /// Note: This returns the same value as the `type` field of the `fd-stat`
        /// returned by `stat`, `stat-at` and similar.
        /// 
        /// Note: This returns similar flags to the `st_mode & S_IFMT` value provided
        /// by `fstat` in POSIX.
        /// 
        /// Note: This returns the value that was the `fs_filetype` value returned
        /// from `fdstat_get` in earlier versions of WASI.
        pub fn get_type(&self,) -> Result<DescriptorType,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.get-type"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = i32::from(*((ptr0 + 1) as *const u8));
                  
                  DescriptorType::_lift(l2 as u8)
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr0 + 1) as *const u8));
                  
                  ErrorCode::_lift(l3 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Adjust the size of an open file. If this increases the file's size, the
        /// extra bytes are filled with zeros.
        /// 
        /// Note: This was called `fd_filestat_set_size` in earlier versions of WASI.
        pub fn set_size(&self,size: Filesize,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.set-size"]
              fn wit_import(_: i32, _: i64, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(size), ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l2 = i32::from(*((ptr0 + 1) as *const u8));
                  
                  ErrorCode::_lift(l2 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Adjust the timestamps of an open file or directory.
        /// 
        /// Note: This is similar to `futimens` in POSIX.
        /// 
        /// Note: This was called `fd_filestat_set_times` in earlier versions of WASI.
        pub fn set_times(&self,data_access_timestamp: NewTimestamp,data_modification_timestamp: NewTimestamp,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let (result1_0,result1_1,result1_2,) = match data_access_timestamp {
              NewTimestamp::NoChange=> {
                (0i32, 0i64, 0i32)
              }
              NewTimestamp::Now=> {
                (1i32, 0i64, 0i32)
              }
              NewTimestamp::Timestamp(e) => {
                let super::super::super::wasi::clocks::wall_clock::Datetime{ seconds:seconds0, nanoseconds:nanoseconds0, } = e;
                
                (2i32, wit_bindgen::rt::as_i64(seconds0), wit_bindgen::rt::as_i32(nanoseconds0))
              },
            };
            let (result3_0,result3_1,result3_2,) = match data_modification_timestamp {
              NewTimestamp::NoChange=> {
                (0i32, 0i64, 0i32)
              }
              NewTimestamp::Now=> {
                (1i32, 0i64, 0i32)
              }
              NewTimestamp::Timestamp(e) => {
                let super::super::super::wasi::clocks::wall_clock::Datetime{ seconds:seconds2, nanoseconds:nanoseconds2, } = e;
                
                (2i32, wit_bindgen::rt::as_i64(seconds2), wit_bindgen::rt::as_i32(nanoseconds2))
              },
            };
            let ptr4 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.set-times"]
              fn wit_import(_: i32, _: i32, _: i64, _: i32, _: i32, _: i64, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i64, _: i32, _: i32, _: i64, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, result1_0, result1_1, result1_2, result3_0, result3_1, result3_2, ptr4);
            let l5 = i32::from(*((ptr4 + 0) as *const u8));
            match l5 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l6 = i32::from(*((ptr4 + 1) as *const u8));
                  
                  ErrorCode::_lift(l6 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Read from a descriptor, without using and updating the descriptor's offset.
        /// 
        /// This function returns a list of bytes containing the data that was
        /// read, along with a bool which, when true, indicates that the end of the
        /// file was reached. The returned list will contain up to `length` bytes; it
        /// may return fewer than requested, if the end of the file is reached or
        /// if the I/O operation is interrupted.
        /// 
        /// In the future, this may change to return a `stream<u8, error-code>`.
        /// 
        /// Note: This is similar to `pread` in POSIX.
        pub fn read(&self,length: Filesize,offset: Filesize,) -> Result<(wit_bindgen::rt::vec::Vec::<u8>,bool,),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 16]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.read"]
              fn wit_import(_: i32, _: i64, _: i64, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i64, _: i64, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(length), wit_bindgen::rt::as_i64(offset), ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 4) as *const i32);
                  let l3 = *((ptr0 + 8) as *const i32);
                  let len4 = l3 as usize;
                  let l5 = i32::from(*((ptr0 + 12) as *const u8));
                  
                  (Vec::from_raw_parts(l2 as *mut _, len4, len4), wit_bindgen::rt::bool_lift(l5 as u8))
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l6 = i32::from(*((ptr0 + 4) as *const u8));
                  
                  ErrorCode::_lift(l6 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Write to a descriptor, without using and updating the descriptor's offset.
        /// 
        /// It is valid to write past the end of a file; the file is extended to the
        /// extent of the write, with bytes between the previous end and the start of
        /// the write set to zero.
        /// 
        /// In the future, this may change to take a `stream<u8, error-code>`.
        /// 
        /// Note: This is similar to `pwrite` in POSIX.
        pub fn write(&self,buffer: &[u8],offset: Filesize,) -> Result<Filesize,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(8))]
            struct RetArea([u8; 16]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let vec0 = buffer;
            let ptr0 = vec0.as_ptr() as i32;
            let len0 = vec0.len() as i32;
            let ptr1 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.write"]
              fn wit_import(_: i32, _: i32, _: i32, _: i64, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i64, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0, len0, wit_bindgen::rt::as_i64(offset), ptr1);
            let l2 = i32::from(*((ptr1 + 0) as *const u8));
            match l2 {
              0 => {
                let e = {
                  let l3 = *((ptr1 + 8) as *const i64);
                  
                  l3 as u64
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l4 = i32::from(*((ptr1 + 8) as *const u8));
                  
                  ErrorCode::_lift(l4 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Read directory entries from a directory.
        /// 
        /// On filesystems where directories contain entries referring to themselves
        /// and their parents, often named `.` and `..` respectively, these entries
        /// are omitted.
        /// 
        /// This always returns a new stream which starts at the beginning of the
        /// directory. Multiple streams may be active on the same directory, and they
        /// do not interfere with each other.
        pub fn read_directory(&self,) -> Result<DirectoryEntryStream,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 8]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.read-directory"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 4) as *const i32);
                  
                  DirectoryEntryStream::from_handle(l2 as u32)
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr0 + 4) as *const u8));
                  
                  ErrorCode::_lift(l3 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Synchronize the data and metadata of a file to disk.
        /// 
        /// This function succeeds with no effect if the file descriptor is not
        /// opened for writing.
        /// 
        /// Note: This is similar to `fsync` in POSIX.
        pub fn sync(&self,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.sync"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l2 = i32::from(*((ptr0 + 1) as *const u8));
                  
                  ErrorCode::_lift(l2 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Create a directory.
        /// 
        /// Note: This is similar to `mkdirat` in POSIX.
        pub fn create_directory_at(&self,path: &str,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let vec0 = path;
            let ptr0 = vec0.as_ptr() as i32;
            let len0 = vec0.len() as i32;
            let ptr1 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.create-directory-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0, len0, ptr1);
            let l2 = i32::from(*((ptr1 + 0) as *const u8));
            match l2 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr1 + 1) as *const u8));
                  
                  ErrorCode::_lift(l3 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Return the attributes of an open file or directory.
        /// 
        /// Note: This is similar to `fstat` in POSIX, except that it does not return
        /// device and inode information. For testing whether two descriptors refer to
        /// the same underlying filesystem object, use `is-same-object`. To obtain
        /// additional data that can be used do determine whether a file has been
        /// modified, use `metadata-hash`.
        /// 
        /// Note: This was called `fd_filestat_get` in earlier versions of WASI.
        pub fn stat(&self,) -> Result<DescriptorStat,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(8))]
            struct RetArea([u8; 104]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.stat"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = i32::from(*((ptr0 + 8) as *const u8));
                  let l3 = *((ptr0 + 16) as *const i64);
                  let l4 = *((ptr0 + 24) as *const i64);
                  let l5 = i32::from(*((ptr0 + 32) as *const u8));
                  let l8 = i32::from(*((ptr0 + 56) as *const u8));
                  let l11 = i32::from(*((ptr0 + 80) as *const u8));
                  
                  DescriptorStat{
                    type_: DescriptorType::_lift(l2 as u8),
                    link_count: l3 as u64,
                    size: l4 as u64,
                    data_access_timestamp: match l5 {
                      0 => None,
                      1 => {
                        let e = {
                          let l6 = *((ptr0 + 40) as *const i64);
                          let l7 = *((ptr0 + 48) as *const i32);
                          
                          super::super::super::wasi::clocks::wall_clock::Datetime{
                            seconds: l6 as u64,
                            nanoseconds: l7 as u32,
                          }
                        };
                        Some(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    },
                    data_modification_timestamp: match l8 {
                      0 => None,
                      1 => {
                        let e = {
                          let l9 = *((ptr0 + 64) as *const i64);
                          let l10 = *((ptr0 + 72) as *const i32);
                          
                          super::super::super::wasi::clocks::wall_clock::Datetime{
                            seconds: l9 as u64,
                            nanoseconds: l10 as u32,
                          }
                        };
                        Some(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    },
                    status_change_timestamp: match l11 {
                      0 => None,
                      1 => {
                        let e = {
                          let l12 = *((ptr0 + 88) as *const i64);
                          let l13 = *((ptr0 + 96) as *const i32);
                          
                          super::super::super::wasi::clocks::wall_clock::Datetime{
                            seconds: l12 as u64,
                            nanoseconds: l13 as u32,
                          }
                        };
                        Some(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    },
                  }
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l14 = i32::from(*((ptr0 + 8) as *const u8));
                  
                  ErrorCode::_lift(l14 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Return the attributes of a file or directory.
        /// 
        /// Note: This is similar to `fstatat` in POSIX, except that it does not
        /// return device and inode information. See the `stat` description for a
        /// discussion of alternatives.
        /// 
        /// Note: This was called `path_filestat_get` in earlier versions of WASI.
        pub fn stat_at(&self,path_flags: PathFlags,path: &str,) -> Result<DescriptorStat,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(8))]
            struct RetArea([u8; 104]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let flags0 = path_flags;
            let vec1 = path;
            let ptr1 = vec1.as_ptr() as i32;
            let len1 = vec1.len() as i32;
            let ptr2 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.stat-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, (flags0.bits() >> 0) as i32, ptr1, len1, ptr2);
            let l3 = i32::from(*((ptr2 + 0) as *const u8));
            match l3 {
              0 => {
                let e = {
                  let l4 = i32::from(*((ptr2 + 8) as *const u8));
                  let l5 = *((ptr2 + 16) as *const i64);
                  let l6 = *((ptr2 + 24) as *const i64);
                  let l7 = i32::from(*((ptr2 + 32) as *const u8));
                  let l10 = i32::from(*((ptr2 + 56) as *const u8));
                  let l13 = i32::from(*((ptr2 + 80) as *const u8));
                  
                  DescriptorStat{
                    type_: DescriptorType::_lift(l4 as u8),
                    link_count: l5 as u64,
                    size: l6 as u64,
                    data_access_timestamp: match l7 {
                      0 => None,
                      1 => {
                        let e = {
                          let l8 = *((ptr2 + 40) as *const i64);
                          let l9 = *((ptr2 + 48) as *const i32);
                          
                          super::super::super::wasi::clocks::wall_clock::Datetime{
                            seconds: l8 as u64,
                            nanoseconds: l9 as u32,
                          }
                        };
                        Some(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    },
                    data_modification_timestamp: match l10 {
                      0 => None,
                      1 => {
                        let e = {
                          let l11 = *((ptr2 + 64) as *const i64);
                          let l12 = *((ptr2 + 72) as *const i32);
                          
                          super::super::super::wasi::clocks::wall_clock::Datetime{
                            seconds: l11 as u64,
                            nanoseconds: l12 as u32,
                          }
                        };
                        Some(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    },
                    status_change_timestamp: match l13 {
                      0 => None,
                      1 => {
                        let e = {
                          let l14 = *((ptr2 + 88) as *const i64);
                          let l15 = *((ptr2 + 96) as *const i32);
                          
                          super::super::super::wasi::clocks::wall_clock::Datetime{
                            seconds: l14 as u64,
                            nanoseconds: l15 as u32,
                          }
                        };
                        Some(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    },
                  }
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l16 = i32::from(*((ptr2 + 8) as *const u8));
                  
                  ErrorCode::_lift(l16 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Adjust the timestamps of a file or directory.
        /// 
        /// Note: This is similar to `utimensat` in POSIX.
        /// 
        /// Note: This was called `path_filestat_set_times` in earlier versions of
        /// WASI.
        pub fn set_times_at(&self,path_flags: PathFlags,path: &str,data_access_timestamp: NewTimestamp,data_modification_timestamp: NewTimestamp,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let flags0 = path_flags;
            let vec1 = path;
            let ptr1 = vec1.as_ptr() as i32;
            let len1 = vec1.len() as i32;
            let (result3_0,result3_1,result3_2,) = match data_access_timestamp {
              NewTimestamp::NoChange=> {
                (0i32, 0i64, 0i32)
              }
              NewTimestamp::Now=> {
                (1i32, 0i64, 0i32)
              }
              NewTimestamp::Timestamp(e) => {
                let super::super::super::wasi::clocks::wall_clock::Datetime{ seconds:seconds2, nanoseconds:nanoseconds2, } = e;
                
                (2i32, wit_bindgen::rt::as_i64(seconds2), wit_bindgen::rt::as_i32(nanoseconds2))
              },
            };
            let (result5_0,result5_1,result5_2,) = match data_modification_timestamp {
              NewTimestamp::NoChange=> {
                (0i32, 0i64, 0i32)
              }
              NewTimestamp::Now=> {
                (1i32, 0i64, 0i32)
              }
              NewTimestamp::Timestamp(e) => {
                let super::super::super::wasi::clocks::wall_clock::Datetime{ seconds:seconds4, nanoseconds:nanoseconds4, } = e;
                
                (2i32, wit_bindgen::rt::as_i64(seconds4), wit_bindgen::rt::as_i32(nanoseconds4))
              },
            };
            let ptr6 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.set-times-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i64, _: i32, _: i32, _: i64, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i64, _: i32, _: i32, _: i64, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, (flags0.bits() >> 0) as i32, ptr1, len1, result3_0, result3_1, result3_2, result5_0, result5_1, result5_2, ptr6);
            let l7 = i32::from(*((ptr6 + 0) as *const u8));
            match l7 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l8 = i32::from(*((ptr6 + 1) as *const u8));
                  
                  ErrorCode::_lift(l8 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Create a hard link.
        /// 
        /// Note: This is similar to `linkat` in POSIX.
        pub fn link_at(&self,old_path_flags: PathFlags,old_path: &str,new_descriptor: &Descriptor,new_path: &str,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let flags0 = old_path_flags;
            let vec1 = old_path;
            let ptr1 = vec1.as_ptr() as i32;
            let len1 = vec1.len() as i32;
            let vec2 = new_path;
            let ptr2 = vec2.as_ptr() as i32;
            let len2 = vec2.len() as i32;
            let ptr3 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.link-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, (flags0.bits() >> 0) as i32, ptr1, len1, (new_descriptor).handle() as i32, ptr2, len2, ptr3);
            let l4 = i32::from(*((ptr3 + 0) as *const u8));
            match l4 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l5 = i32::from(*((ptr3 + 1) as *const u8));
                  
                  ErrorCode::_lift(l5 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Open a file or directory.
        /// 
        /// The returned descriptor is not guaranteed to be the lowest-numbered
        /// descriptor not currently open/ it is randomized to prevent applications
        /// from depending on making assumptions about indexes, since this is
        /// error-prone in multi-threaded contexts. The returned descriptor is
        /// guaranteed to be less than 2**31.
        /// 
        /// If `flags` contains `descriptor-flags::mutate-directory`, and the base
        /// descriptor doesn't have `descriptor-flags::mutate-directory` set,
        /// `open-at` fails with `error-code::read-only`.
        /// 
        /// If `flags` contains `write` or `mutate-directory`, or `open-flags`
        /// contains `truncate` or `create`, and the base descriptor doesn't have
        /// `descriptor-flags::mutate-directory` set, `open-at` fails with
        /// `error-code::read-only`.
        /// 
        /// Note: This is similar to `openat` in POSIX.
        pub fn open_at(&self,path_flags: PathFlags,path: &str,open_flags: OpenFlags,flags: DescriptorFlags,) -> Result<Descriptor,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 8]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let flags0 = path_flags;
            let vec1 = path;
            let ptr1 = vec1.as_ptr() as i32;
            let len1 = vec1.len() as i32;
            let flags2 = open_flags;
            let flags3 = flags;
            let ptr4 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.open-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, (flags0.bits() >> 0) as i32, ptr1, len1, (flags2.bits() >> 0) as i32, (flags3.bits() >> 0) as i32, ptr4);
            let l5 = i32::from(*((ptr4 + 0) as *const u8));
            match l5 {
              0 => {
                let e = {
                  let l6 = *((ptr4 + 4) as *const i32);
                  
                  Descriptor::from_handle(l6 as u32)
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l7 = i32::from(*((ptr4 + 4) as *const u8));
                  
                  ErrorCode::_lift(l7 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Read the contents of a symbolic link.
        /// 
        /// If the contents contain an absolute or rooted path in the underlying
        /// filesystem, this function fails with `error-code::not-permitted`.
        /// 
        /// Note: This is similar to `readlinkat` in POSIX.
        pub fn readlink_at(&self,path: &str,) -> Result<wit_bindgen::rt::string::String,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 12]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let vec0 = path;
            let ptr0 = vec0.as_ptr() as i32;
            let len0 = vec0.len() as i32;
            let ptr1 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.readlink-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0, len0, ptr1);
            let l2 = i32::from(*((ptr1 + 0) as *const u8));
            match l2 {
              0 => {
                let e = {
                  let l3 = *((ptr1 + 4) as *const i32);
                  let l4 = *((ptr1 + 8) as *const i32);
                  let len5 = l4 as usize;
                  let bytes5 = Vec::from_raw_parts(l3 as *mut _, len5, len5);
                  
                  wit_bindgen::rt::string_lift(bytes5)
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l6 = i32::from(*((ptr1 + 4) as *const u8));
                  
                  ErrorCode::_lift(l6 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Remove a directory.
        /// 
        /// Return `error-code::not-empty` if the directory is not empty.
        /// 
        /// Note: This is similar to `unlinkat(fd, path, AT_REMOVEDIR)` in POSIX.
        pub fn remove_directory_at(&self,path: &str,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let vec0 = path;
            let ptr0 = vec0.as_ptr() as i32;
            let len0 = vec0.len() as i32;
            let ptr1 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.remove-directory-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0, len0, ptr1);
            let l2 = i32::from(*((ptr1 + 0) as *const u8));
            match l2 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr1 + 1) as *const u8));
                  
                  ErrorCode::_lift(l3 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Rename a filesystem object.
        /// 
        /// Note: This is similar to `renameat` in POSIX.
        pub fn rename_at(&self,old_path: &str,new_descriptor: &Descriptor,new_path: &str,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let vec0 = old_path;
            let ptr0 = vec0.as_ptr() as i32;
            let len0 = vec0.len() as i32;
            let vec1 = new_path;
            let ptr1 = vec1.as_ptr() as i32;
            let len1 = vec1.len() as i32;
            let ptr2 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.rename-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0, len0, (new_descriptor).handle() as i32, ptr1, len1, ptr2);
            let l3 = i32::from(*((ptr2 + 0) as *const u8));
            match l3 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l4 = i32::from(*((ptr2 + 1) as *const u8));
                  
                  ErrorCode::_lift(l4 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Create a symbolic link (also known as a "symlink").
        /// 
        /// If `old-path` starts with `/`, the function fails with
        /// `error-code::not-permitted`.
        /// 
        /// Note: This is similar to `symlinkat` in POSIX.
        pub fn symlink_at(&self,old_path: &str,new_path: &str,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let vec0 = old_path;
            let ptr0 = vec0.as_ptr() as i32;
            let len0 = vec0.len() as i32;
            let vec1 = new_path;
            let ptr1 = vec1.as_ptr() as i32;
            let len1 = vec1.len() as i32;
            let ptr2 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.symlink-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0, len0, ptr1, len1, ptr2);
            let l3 = i32::from(*((ptr2 + 0) as *const u8));
            match l3 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l4 = i32::from(*((ptr2 + 1) as *const u8));
                  
                  ErrorCode::_lift(l4 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Unlink a filesystem object that is not a directory.
        /// 
        /// Return `error-code::is-directory` if the path refers to a directory.
        /// Note: This is similar to `unlinkat(fd, path, 0)` in POSIX.
        pub fn unlink_file_at(&self,path: &str,) -> Result<(),ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(1))]
            struct RetArea([u8; 2]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let vec0 = path;
            let ptr0 = vec0.as_ptr() as i32;
            let len0 = vec0.len() as i32;
            let ptr1 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.unlink-file-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0, len0, ptr1);
            let l2 = i32::from(*((ptr1 + 0) as *const u8));
            match l2 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr1 + 1) as *const u8));
                  
                  ErrorCode::_lift(l3 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Test whether two descriptors refer to the same filesystem object.
        /// 
        /// In POSIX, this corresponds to testing whether the two descriptors have the
        /// same device (`st_dev`) and inode (`st_ino` or `d_ino`) numbers.
        /// wasi-filesystem does not expose device and inode numbers, so this function
        /// may be used instead.
        pub fn is_same_object(&self,other: &Descriptor,) -> bool{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.is-same-object"]
              fn wit_import(_: i32, _: i32, ) -> i32;
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ) -> i32{ unreachable!() }
            let ret = wit_import((self).handle() as i32, (other).handle() as i32);
            wit_bindgen::rt::bool_lift(ret as u8)
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Return a hash of the metadata associated with a filesystem object referred
        /// to by a descriptor.
        /// 
        /// This returns a hash of the last-modification timestamp and file size, and
        /// may also include the inode number, device number, birth timestamp, and
        /// other metadata fields that may change when the file is modified or
        /// replaced. It may also include a secret value chosen by the
        /// implementation and not otherwise exposed.
        /// 
        /// Implementations are encourated to provide the following properties:
        /// 
        /// - If the file is not modified or replaced, the computed hash value should
        /// usually not change.
        /// - If the object is modified or replaced, the computed hash value should
        /// usually change.
        /// - The inputs to the hash should not be easily computable from the
        /// computed hash.
        /// 
        /// However, none of these is required.
        pub fn metadata_hash(&self,) -> Result<MetadataHashValue,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(8))]
            struct RetArea([u8; 24]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.metadata-hash"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 8) as *const i64);
                  let l3 = *((ptr0 + 16) as *const i64);
                  
                  MetadataHashValue{
                    lower: l2 as u64,
                    upper: l3 as u64,
                  }
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l4 = i32::from(*((ptr0 + 8) as *const u8));
                  
                  ErrorCode::_lift(l4 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl Descriptor {
        #[allow(unused_unsafe, clippy::all)]
        /// Return a hash of the metadata associated with a filesystem object referred
        /// to by a directory descriptor and a relative path.
        /// 
        /// This performs the same hash computation as `metadata-hash`.
        pub fn metadata_hash_at(&self,path_flags: PathFlags,path: &str,) -> Result<MetadataHashValue,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(8))]
            struct RetArea([u8; 24]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let flags0 = path_flags;
            let vec1 = path;
            let ptr1 = vec1.as_ptr() as i32;
            let len1 = vec1.len() as i32;
            let ptr2 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]descriptor.metadata-hash-at"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, (flags0.bits() >> 0) as i32, ptr1, len1, ptr2);
            let l3 = i32::from(*((ptr2 + 0) as *const u8));
            match l3 {
              0 => {
                let e = {
                  let l4 = *((ptr2 + 8) as *const i64);
                  let l5 = *((ptr2 + 16) as *const i64);
                  
                  MetadataHashValue{
                    lower: l4 as u64,
                    upper: l5 as u64,
                  }
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l6 = i32::from(*((ptr2 + 8) as *const u8));
                  
                  ErrorCode::_lift(l6 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl DirectoryEntryStream {
        #[allow(unused_unsafe, clippy::all)]
        /// Read a single directory entry from a `directory-entry-stream`.
        pub fn read_directory_entry(&self,) -> Result<Option<DirectoryEntry>,ErrorCode>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 20]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
            extern "C" {
              #[link_name = "[method]directory-entry-stream.read-directory-entry"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = i32::from(*((ptr0 + 4) as *const u8));
                  
                  match l2 {
                    0 => None,
                    1 => {
                      let e = {
                        let l3 = i32::from(*((ptr0 + 8) as *const u8));
                        let l4 = *((ptr0 + 12) as *const i32);
                        let l5 = *((ptr0 + 16) as *const i32);
                        let len6 = l5 as usize;
                        let bytes6 = Vec::from_raw_parts(l4 as *mut _, len6, len6);
                        
                        DirectoryEntry{
                          type_: DescriptorType::_lift(l3 as u8),
                          name: wit_bindgen::rt::string_lift(bytes6),
                        }
                      };
                      Some(e)
                    }
                    _ => wit_bindgen::rt::invalid_enum_discriminant(),
                  }
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l7 = i32::from(*((ptr0 + 4) as *const u8));
                  
                  ErrorCode::_lift(l7 as u8)
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      #[allow(unused_unsafe, clippy::all)]
      /// Attempts to extract a filesystem-related `error-code` from the stream
      /// `error` provided.
      /// 
      /// Stream operations which return `stream-error::last-operation-failed`
      /// have a payload with more information about the operation that failed.
      /// This payload can be passed through to this function to see if there's
      /// filesystem-related information about the error to return.
      /// 
      /// Note that this function is fallible because not all stream-related
      /// errors are filesystem-related errors.
      pub fn filesystem_error_code(err: &Error,) -> Option<ErrorCode>{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(1))]
          struct RetArea([u8; 2]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let ptr0 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:filesystem/types@0.2.0")]
          extern "C" {
            #[link_name = "filesystem-error-code"]
            fn wit_import(_: i32, _: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, _: i32, ){ unreachable!() }
          wit_import((err).handle() as i32, ptr0);
          let l1 = i32::from(*((ptr0 + 0) as *const u8));
          match l1 {
            0 => None,
            1 => {
              let e = {
                let l2 = i32::from(*((ptr0 + 1) as *const u8));
                
                ErrorCode::_lift(l2 as u8)
              };
              Some(e)
            }
            _ => wit_bindgen::rt::invalid_enum_discriminant(),
          }
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod preopens {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      pub type Descriptor = super::super::super::wasi::filesystem::types::Descriptor;
      #[allow(unused_unsafe, clippy::all)]
      /// Return the set of preopened directories, and their path.
      pub fn get_directories() -> wit_bindgen::rt::vec::Vec::<(Descriptor,wit_bindgen::rt::string::String,)>{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(4))]
          struct RetArea([u8; 8]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let ptr0 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:filesystem/preopens@0.2.0")]
          extern "C" {
            #[link_name = "get-directories"]
            fn wit_import(_: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, ){ unreachable!() }
          wit_import(ptr0);
          let l1 = *((ptr0 + 0) as *const i32);
          let l2 = *((ptr0 + 4) as *const i32);
          let base7 = l1;
          let len7 = l2;
          let mut result7 = Vec::with_capacity(len7 as usize);
          for i in 0..len7 {
            let base = base7 + i * 12;
            let e7 = {
              let l3 = *((base + 0) as *const i32);
              let l4 = *((base + 4) as *const i32);
              let l5 = *((base + 8) as *const i32);
              let len6 = l5 as usize;
              let bytes6 = Vec::from_raw_parts(l4 as *mut _, len6, len6);
              
              (super::super::super::wasi::filesystem::types::Descriptor::from_handle(l3 as u32), wit_bindgen::rt::string_lift(bytes6))
            };
            result7.push(e7);
          }
          wit_bindgen::rt::dealloc(base7, (len7 as usize) * 12, 4);
          result7
        }
      }
      
    }
    
  }
  pub mod io {
    
    #[allow(clippy::all)]
    pub mod error {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      /// A resource which represents some error information.
      /// 
      /// The only method provided by this resource is `to-debug-string`,
      /// which provides some human-readable information about the error.
      /// 
      /// In the `wasi:io` package, this resource is returned through the
      /// `wasi:io/streams/stream-error` type.
      /// 
      /// To provide more specific error information, other interfaces may
      /// provide functions to further "downcast" this error into more specific
      /// error information. For example, `error`s returned in streams derived
      /// from filesystem types to be described using the filesystem's own
      /// error-code type, using the function
      /// `wasi:filesystem/types/filesystem-error-code`, which takes a parameter
      /// `borrow<error>` and returns
      /// `option<wasi:filesystem/types/error-code>`.
      /// 
      /// The set of functions which can "downcast" an `error` into a more
      /// concrete type is open.
      
      #[derive(Debug)]
      #[repr(transparent)]
      pub struct Error{
        handle: wit_bindgen::rt::Resource<Error>,
      }
      
      impl Error{
        #[doc(hidden)]
        pub unsafe fn from_handle(handle: u32) -> Self {
          Self {
            handle: wit_bindgen::rt::Resource::from_handle(handle),
          }
        }
        
        #[doc(hidden)]
        pub fn into_handle(self) -> u32 {
          wit_bindgen::rt::Resource::into_handle(self.handle)
        }
        
        #[doc(hidden)]
        pub fn handle(&self) -> u32 {
          wit_bindgen::rt::Resource::handle(&self.handle)
        }
      }
      
      
      unsafe impl wit_bindgen::rt::WasmResource for Error{
        #[inline]
        unsafe fn drop(_handle: u32) {
          #[cfg(not(target_arch = "wasm32"))]
          unreachable!();
          
          #[cfg(target_arch = "wasm32")]
          {
            #[link(wasm_import_module = "wasi:io/error@0.2.0")]
            extern "C" {
              #[link_name = "[resource-drop]error"]
              fn drop(_: u32);
            }
            
            drop(_handle);
          }
        }
      }
      
      impl Error {
        #[allow(unused_unsafe, clippy::all)]
        /// Returns a string that is suitable to assist humans in debugging
        /// this error.
        /// 
        /// WARNING: The returned string should not be consumed mechanically!
        /// It may change across platforms, hosts, or other implementation
        /// details. Parsing this string is a major platform-compatibility
        /// hazard.
        pub fn to_debug_string(&self,) -> wit_bindgen::rt::string::String{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 8]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:io/error@0.2.0")]
            extern "C" {
              #[link_name = "[method]error.to-debug-string"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = *((ptr0 + 0) as *const i32);
            let l2 = *((ptr0 + 4) as *const i32);
            let len3 = l2 as usize;
            let bytes3 = Vec::from_raw_parts(l1 as *mut _, len3, len3);
            wit_bindgen::rt::string_lift(bytes3)
          }
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod poll {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      /// `pollable` represents a single I/O event which may be ready, or not.
      
      #[derive(Debug)]
      #[repr(transparent)]
      pub struct Pollable{
        handle: wit_bindgen::rt::Resource<Pollable>,
      }
      
      impl Pollable{
        #[doc(hidden)]
        pub unsafe fn from_handle(handle: u32) -> Self {
          Self {
            handle: wit_bindgen::rt::Resource::from_handle(handle),
          }
        }
        
        #[doc(hidden)]
        pub fn into_handle(self) -> u32 {
          wit_bindgen::rt::Resource::into_handle(self.handle)
        }
        
        #[doc(hidden)]
        pub fn handle(&self) -> u32 {
          wit_bindgen::rt::Resource::handle(&self.handle)
        }
      }
      
      
      unsafe impl wit_bindgen::rt::WasmResource for Pollable{
        #[inline]
        unsafe fn drop(_handle: u32) {
          #[cfg(not(target_arch = "wasm32"))]
          unreachable!();
          
          #[cfg(target_arch = "wasm32")]
          {
            #[link(wasm_import_module = "wasi:io/poll@0.2.0")]
            extern "C" {
              #[link_name = "[resource-drop]pollable"]
              fn drop(_: u32);
            }
            
            drop(_handle);
          }
        }
      }
      
      impl Pollable {
        #[allow(unused_unsafe, clippy::all)]
        /// Return the readiness of a pollable. This function never blocks.
        /// 
        /// Returns `true` when the pollable is ready, and `false` otherwise.
        pub fn ready(&self,) -> bool{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:io/poll@0.2.0")]
            extern "C" {
              #[link_name = "[method]pollable.ready"]
              fn wit_import(_: i32, ) -> i32;
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, ) -> i32{ unreachable!() }
            let ret = wit_import((self).handle() as i32);
            wit_bindgen::rt::bool_lift(ret as u8)
          }
        }
      }
      impl Pollable {
        #[allow(unused_unsafe, clippy::all)]
        /// `block` returns immediately if the pollable is ready, and otherwise
        /// blocks until ready.
        /// 
        /// This function is equivalent to calling `poll.poll` on a list
        /// containing only this pollable.
        pub fn block(&self,){
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:io/poll@0.2.0")]
            extern "C" {
              #[link_name = "[method]pollable.block"]
              fn wit_import(_: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, ){ unreachable!() }
            wit_import((self).handle() as i32);
          }
        }
      }
      #[allow(unused_unsafe, clippy::all)]
      /// Poll for completion on a set of pollables.
      /// 
      /// This function takes a list of pollables, which identify I/O sources of
      /// interest, and waits until one or more of the events is ready for I/O.
      /// 
      /// The result `list<u32>` contains one or more indices of handles in the
      /// argument list that is ready for I/O.
      /// 
      /// This function traps if either:
      /// - the list is empty, or:
      /// - the list contains more elements than can be indexed with a `u32` value.
      /// 
      /// A timeout can be implemented by adding a pollable from the
      /// wasi-clocks API to the list.
      /// 
      /// This function does not return a `result`; polling in itself does not
      /// do any I/O so it doesn't fail. If any of the I/O sources identified by
      /// the pollables has an error, it is indicated by marking the source as
      /// being ready for I/O.
      pub fn poll(in_: &[&Pollable],) -> wit_bindgen::rt::vec::Vec::<u32>{
        
        #[allow(unused_imports)]
        use wit_bindgen::rt::{alloc, vec::Vec, string::String};
        unsafe {
          
          #[repr(align(4))]
          struct RetArea([u8; 8]);
          let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
          let vec0 = in_;
          let len0 = vec0.len() as i32;
          let layout0 = alloc::Layout::from_size_align_unchecked(vec0.len() * 4, 4);
          let result0 = if layout0.size() != 0
          {
            let ptr = alloc::alloc(layout0);
            if ptr.is_null()
            {
              alloc::handle_alloc_error(layout0);
            }
            ptr
          }else {{
            ::core::ptr::null_mut()
          }};
          for (i, e) in vec0.into_iter().enumerate() {
            let base = result0 as i32 + (i as i32) * 4;
            {
              *((base + 0) as *mut i32) = (e).handle() as i32;
            }
          }
          let ptr1 = ret_area.as_mut_ptr() as i32;
          #[cfg(target_arch = "wasm32")]
          #[link(wasm_import_module = "wasi:io/poll@0.2.0")]
          extern "C" {
            #[link_name = "poll"]
            fn wit_import(_: i32, _: i32, _: i32, );
          }
          
          #[cfg(not(target_arch = "wasm32"))]
          fn wit_import(_: i32, _: i32, _: i32, ){ unreachable!() }
          wit_import(result0 as i32, len0, ptr1);
          let l2 = *((ptr1 + 0) as *const i32);
          let l3 = *((ptr1 + 4) as *const i32);
          let len4 = l3 as usize;
          if layout0.size() != 0 {
            alloc::dealloc(result0, layout0);
          }
          Vec::from_raw_parts(l2 as *mut _, len4, len4)
        }
      }
      
    }
    
    
    #[allow(clippy::all)]
    pub mod streams {
      #[used]
      #[doc(hidden)]
      #[cfg(target_arch = "wasm32")]
      static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
      pub type Error = super::super::super::wasi::io::error::Error;
      pub type Pollable = super::super::super::wasi::io::poll::Pollable;
      /// An error for input-stream and output-stream operations.
      pub enum StreamError{
        /// The last operation (a write or flush) failed before completion.
        /// 
        /// More information is available in the `error` payload.
        LastOperationFailed(Error),
        /// The stream is closed: no more input will be accepted by the
        /// stream. A closed output-stream will return this error on all
        /// future operations.
        Closed,
      }
      impl ::core::fmt::Debug for StreamError {
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          match self {
            StreamError::LastOperationFailed(e) => {
              f.debug_tuple("StreamError::LastOperationFailed").field(e).finish()
            }
            StreamError::Closed => {
              f.debug_tuple("StreamError::Closed").finish()
            }
          }
        }
      }
      impl ::core::fmt::Display for StreamError {
        fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
          write!(f, "{:?}", self)
        }
      }
      
      impl std::error::Error for StreamError {}
      /// An input bytestream.
      /// 
      /// `input-stream`s are *non-blocking* to the extent practical on underlying
      /// platforms. I/O operations always return promptly; if fewer bytes are
      /// promptly available than requested, they return the number of bytes promptly
      /// available, which could even be zero. To wait for data to be available,
      /// use the `subscribe` function to obtain a `pollable` which can be polled
      /// for using `wasi:io/poll`.
      
      #[derive(Debug)]
      #[repr(transparent)]
      pub struct InputStream{
        handle: wit_bindgen::rt::Resource<InputStream>,
      }
      
      impl InputStream{
        #[doc(hidden)]
        pub unsafe fn from_handle(handle: u32) -> Self {
          Self {
            handle: wit_bindgen::rt::Resource::from_handle(handle),
          }
        }
        
        #[doc(hidden)]
        pub fn into_handle(self) -> u32 {
          wit_bindgen::rt::Resource::into_handle(self.handle)
        }
        
        #[doc(hidden)]
        pub fn handle(&self) -> u32 {
          wit_bindgen::rt::Resource::handle(&self.handle)
        }
      }
      
      
      unsafe impl wit_bindgen::rt::WasmResource for InputStream{
        #[inline]
        unsafe fn drop(_handle: u32) {
          #[cfg(not(target_arch = "wasm32"))]
          unreachable!();
          
          #[cfg(target_arch = "wasm32")]
          {
            #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
            extern "C" {
              #[link_name = "[resource-drop]input-stream"]
              fn drop(_: u32);
            }
            
            drop(_handle);
          }
        }
      }
      
      /// An output bytestream.
      /// 
      /// `output-stream`s are *non-blocking* to the extent practical on
      /// underlying platforms. Except where specified otherwise, I/O operations also
      /// always return promptly, after the number of bytes that can be written
      /// promptly, which could even be zero. To wait for the stream to be ready to
      /// accept data, the `subscribe` function to obtain a `pollable` which can be
      /// polled for using `wasi:io/poll`.
      
      #[derive(Debug)]
      #[repr(transparent)]
      pub struct OutputStream{
        handle: wit_bindgen::rt::Resource<OutputStream>,
      }
      
      impl OutputStream{
        #[doc(hidden)]
        pub unsafe fn from_handle(handle: u32) -> Self {
          Self {
            handle: wit_bindgen::rt::Resource::from_handle(handle),
          }
        }
        
        #[doc(hidden)]
        pub fn into_handle(self) -> u32 {
          wit_bindgen::rt::Resource::into_handle(self.handle)
        }
        
        #[doc(hidden)]
        pub fn handle(&self) -> u32 {
          wit_bindgen::rt::Resource::handle(&self.handle)
        }
      }
      
      
      unsafe impl wit_bindgen::rt::WasmResource for OutputStream{
        #[inline]
        unsafe fn drop(_handle: u32) {
          #[cfg(not(target_arch = "wasm32"))]
          unreachable!();
          
          #[cfg(target_arch = "wasm32")]
          {
            #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
            extern "C" {
              #[link_name = "[resource-drop]output-stream"]
              fn drop(_: u32);
            }
            
            drop(_handle);
          }
        }
      }
      
      impl InputStream {
        #[allow(unused_unsafe, clippy::all)]
        /// Perform a non-blocking read from the stream.
        /// 
        /// When the source of a `read` is binary data, the bytes from the source
        /// are returned verbatim. When the source of a `read` is known to the
        /// implementation to be text, bytes containing the UTF-8 encoding of the
        /// text are returned.
        /// 
        /// This function returns a list of bytes containing the read data,
        /// when successful. The returned list will contain up to `len` bytes;
        /// it may return fewer than requested, but not more. The list is
        /// empty when no bytes are available for reading at this time. The
        /// pollable given by `subscribe` will be ready when more bytes are
        /// available.
        /// 
        /// This function fails with a `stream-error` when the operation
        /// encounters an error, giving `last-operation-failed`, or when the
        /// stream is closed, giving `closed`.
        /// 
        /// When the caller gives a `len` of 0, it represents a request to
        /// read 0 bytes. If the stream is still open, this call should
        /// succeed and return an empty list, or otherwise fail with `closed`.
        /// 
        /// The `len` parameter is a `u64`, which could represent a list of u8 which
        /// is not possible to allocate in wasm32, or not desirable to allocate as
        /// as a return value by the callee. The callee may return a list of bytes
        /// less than `len` in size while more bytes are available for reading.
        pub fn read(&self,len: u64,) -> Result<wit_bindgen::rt::vec::Vec::<u8>,StreamError>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 12]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
            extern "C" {
              #[link_name = "[method]input-stream.read"]
              fn wit_import(_: i32, _: i64, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(len), ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 4) as *const i32);
                  let l3 = *((ptr0 + 8) as *const i32);
                  let len4 = l3 as usize;
                  
                  Vec::from_raw_parts(l2 as *mut _, len4, len4)
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l5 = i32::from(*((ptr0 + 4) as *const u8));
                  let v7 = match l5 {
                    0 => {
                      let e7 = {
                        let l6 = *((ptr0 + 8) as *const i32);
                        
                        super::super::super::wasi::io::error::Error::from_handle(l6 as u32)
                      };
                      StreamError::LastOperationFailed(e7)
                    }
                    n => {
                      debug_assert_eq!(n, 1, "invalid enum discriminant");
                      StreamError::Closed
                    }
                  };
                  
                  v7
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl InputStream {
        #[allow(unused_unsafe, clippy::all)]
        /// Read bytes from a stream, after blocking until at least one byte can
        /// be read. Except for blocking, behavior is identical to `read`.
        pub fn blocking_read(&self,len: u64,) -> Result<wit_bindgen::rt::vec::Vec::<u8>,StreamError>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 12]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
            extern "C" {
              #[link_name = "[method]input-stream.blocking-read"]
              fn wit_import(_: i32, _: i64, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(len), ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 4) as *const i32);
                  let l3 = *((ptr0 + 8) as *const i32);
                  let len4 = l3 as usize;
                  
                  Vec::from_raw_parts(l2 as *mut _, len4, len4)
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l5 = i32::from(*((ptr0 + 4) as *const u8));
                  let v7 = match l5 {
                    0 => {
                      let e7 = {
                        let l6 = *((ptr0 + 8) as *const i32);
                        
                        super::super::super::wasi::io::error::Error::from_handle(l6 as u32)
                      };
                      StreamError::LastOperationFailed(e7)
                    }
                    n => {
                      debug_assert_eq!(n, 1, "invalid enum discriminant");
                      StreamError::Closed
                    }
                  };
                  
                  v7
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl InputStream {
        #[allow(unused_unsafe, clippy::all)]
        /// Skip bytes from a stream. Returns number of bytes skipped.
        /// 
        /// Behaves identical to `read`, except instead of returning a list
        /// of bytes, returns the number of bytes consumed from the stream.
        pub fn skip(&self,len: u64,) -> Result<u64,StreamError>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(8))]
            struct RetArea([u8; 16]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
            extern "C" {
              #[link_name = "[method]input-stream.skip"]
              fn wit_import(_: i32, _: i64, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(len), ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 8) as *const i64);
                  
                  l2 as u64
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr0 + 8) as *const u8));
                  let v5 = match l3 {
                    0 => {
                      let e5 = {
                        let l4 = *((ptr0 + 12) as *const i32);
                        
                        super::super::super::wasi::io::error::Error::from_handle(l4 as u32)
                      };
                      StreamError::LastOperationFailed(e5)
                    }
                    n => {
                      debug_assert_eq!(n, 1, "invalid enum discriminant");
                      StreamError::Closed
                    }
                  };
                  
                  v5
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl InputStream {
        #[allow(unused_unsafe, clippy::all)]
        /// Skip bytes from a stream, after blocking until at least one byte
        /// can be skipped. Except for blocking behavior, identical to `skip`.
        pub fn blocking_skip(&self,len: u64,) -> Result<u64,StreamError>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(8))]
            struct RetArea([u8; 16]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
            extern "C" {
              #[link_name = "[method]input-stream.blocking-skip"]
              fn wit_import(_: i32, _: i64, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(len), ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 8) as *const i64);
                  
                  l2 as u64
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr0 + 8) as *const u8));
                  let v5 = match l3 {
                    0 => {
                      let e5 = {
                        let l4 = *((ptr0 + 12) as *const i32);
                        
                        super::super::super::wasi::io::error::Error::from_handle(l4 as u32)
                      };
                      StreamError::LastOperationFailed(e5)
                    }
                    n => {
                      debug_assert_eq!(n, 1, "invalid enum discriminant");
                      StreamError::Closed
                    }
                  };
                  
                  v5
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl InputStream {
        #[allow(unused_unsafe, clippy::all)]
        /// Create a `pollable` which will resolve once either the specified stream
        /// has bytes available to read or the other end of the stream has been
        /// closed.
        /// The created `pollable` is a child resource of the `input-stream`.
        /// Implementations may trap if the `input-stream` is dropped before
        /// all derived `pollable`s created with this function are dropped.
        pub fn subscribe(&self,) -> Pollable{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
            extern "C" {
              #[link_name = "[method]input-stream.subscribe"]
              fn wit_import(_: i32, ) -> i32;
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, ) -> i32{ unreachable!() }
            let ret = wit_import((self).handle() as i32);
            super::super::super::wasi::io::poll::Pollable::from_handle(ret as u32)
          }
        }
      }
      impl OutputStream {
        #[allow(unused_unsafe, clippy::all)]
        /// Check readiness for writing. This function never blocks.
        /// 
        /// Returns the number of bytes permitted for the next call to `write`,
        /// or an error. Calling `write` with more bytes than this function has
        /// permitted will trap.
        /// 
        /// When this function returns 0 bytes, the `subscribe` pollable will
        /// become ready when this function will report at least 1 byte, or an
        /// error.
        pub fn check_write(&self,) -> Result<u64,StreamError>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(8))]
            struct RetArea([u8; 16]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let ptr0 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
            extern "C" {
              #[link_name = "[method]output-stream.check-write"]
              fn wit_import(_: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0);
            let l1 = i32::from(*((ptr0 + 0) as *const u8));
            match l1 {
              0 => {
                let e = {
                  let l2 = *((ptr0 + 8) as *const i64);
                  
                  l2 as u64
                };
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr0 + 8) as *const u8));
                  let v5 = match l3 {
                    0 => {
                      let e5 = {
                        let l4 = *((ptr0 + 12) as *const i32);
                        
                        super::super::super::wasi::io::error::Error::from_handle(l4 as u32)
                      };
                      StreamError::LastOperationFailed(e5)
                    }
                    n => {
                      debug_assert_eq!(n, 1, "invalid enum discriminant");
                      StreamError::Closed
                    }
                  };
                  
                  v5
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl OutputStream {
        #[allow(unused_unsafe, clippy::all)]
        /// Perform a write. This function never blocks.
        /// 
        /// When the destination of a `write` is binary data, the bytes from
        /// `contents` are written verbatim. When the destination of a `write` is
        /// known to the implementation to be text, the bytes of `contents` are
        /// transcoded from UTF-8 into the encoding of the destination and then
        /// written.
        /// 
        /// Precondition: check-write gave permit of Ok(n) and contents has a
        /// length of less than or equal to n. Otherwise, this function will trap.
        /// 
        /// returns Err(closed) without writing if the stream has closed since
        /// the last call to check-write provided a permit.
        pub fn write(&self,contents: &[u8],) -> Result<(),StreamError>{
          
          #[allow(unused_imports)]
          use wit_bindgen::rt::{alloc, vec::Vec, string::String};
          unsafe {
            
            #[repr(align(4))]
            struct RetArea([u8; 12]);
            let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
            let vec0 = contents;
            let ptr0 = vec0.as_ptr() as i32;
            let len0 = vec0.len() as i32;
            let ptr1 = ret_area.as_mut_ptr() as i32;
            #[cfg(target_arch = "wasm32")]
            #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
            extern "C" {
              #[link_name = "[method]output-stream.write"]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, );
            }
            
            #[cfg(not(target_arch = "wasm32"))]
            fn wit_import(_: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
            wit_import((self).handle() as i32, ptr0, len0, ptr1);
            let l2 = i32::from(*((ptr1 + 0) as *const u8));
            match l2 {
              0 => {
                let e = ();
                Ok(e)
              }
              1 => {
                let e = {
                  let l3 = i32::from(*((ptr1 + 4) as *const u8));
                  let v5 = match l3 {
                    0 => {
                      let e5 = {
                        let l4 = *((ptr1 + 8) as *const i32);
                        
                        super::super::super::wasi::io::error::Error::from_handle(l4 as u32)
                      };
                      StreamError::LastOperationFailed(e5)
                    }
                    n => {
                      debug_assert_eq!(n, 1, "invalid enum discriminant");
                      StreamError::Closed
                    }
                  };
                  
                  v5
                };
                Err(e)
              }
              _ => wit_bindgen::rt::invalid_enum_discriminant(),
            }
          }
        }
      }
      impl OutputStream {
        #[allow(unused_unsafe, clippy::all)]
        /// Perform a write of up to 4096 bytes, and then flush the stream. Block
        /// until all of these operations are complete, or an error occurs.
        /// 
        /// This is a convenience wrapper around the use of `check-write`,
        /// `subscribe`, `write`, and `flush`, and is implemented with the
        /// following pseudo-code:
        /// 
        /// ```text
        /// let pollable = this.subscribe();
        /// while !contents.is_empty() {
          /// // Wait for the stream to become writable
          /// pollable.block();
          /// let Ok(n) = this.check-write(); // eliding error handling
          /// let len = min(n, contents.len());
          /// let (chunk, rest) = contents.split_at(len);
          /// this.write(chunk  );            // eliding error handling
          /// contents = rest;
          /// }
          /// this.flush();
          /// // Wait for completion of `flush`
          /// pollable.block();
          /// // Check for any errors that arose during `flush`
          /// let _ = this.check-write();         // eliding error handling
          /// ```
          pub fn blocking_write_and_flush(&self,contents: &[u8],) -> Result<(),StreamError>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(4))]
              struct RetArea([u8; 12]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let vec0 = contents;
              let ptr0 = vec0.as_ptr() as i32;
              let len0 = vec0.len() as i32;
              let ptr1 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
              extern "C" {
                #[link_name = "[method]output-stream.blocking-write-and-flush"]
                fn wit_import(_: i32, _: i32, _: i32, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
              wit_import((self).handle() as i32, ptr0, len0, ptr1);
              let l2 = i32::from(*((ptr1 + 0) as *const u8));
              match l2 {
                0 => {
                  let e = ();
                  Ok(e)
                }
                1 => {
                  let e = {
                    let l3 = i32::from(*((ptr1 + 4) as *const u8));
                    let v5 = match l3 {
                      0 => {
                        let e5 = {
                          let l4 = *((ptr1 + 8) as *const i32);
                          
                          super::super::super::wasi::io::error::Error::from_handle(l4 as u32)
                        };
                        StreamError::LastOperationFailed(e5)
                      }
                      n => {
                        debug_assert_eq!(n, 1, "invalid enum discriminant");
                        StreamError::Closed
                      }
                    };
                    
                    v5
                  };
                  Err(e)
                }
                _ => wit_bindgen::rt::invalid_enum_discriminant(),
              }
            }
          }
        }
        impl OutputStream {
          #[allow(unused_unsafe, clippy::all)]
          /// Request to flush buffered output. This function never blocks.
          /// 
          /// This tells the output-stream that the caller intends any buffered
          /// output to be flushed. the output which is expected to be flushed
          /// is all that has been passed to `write` prior to this call.
          /// 
          /// Upon calling this function, the `output-stream` will not accept any
          /// writes (`check-write` will return `ok(0)`) until the flush has
          /// completed. The `subscribe` pollable will become ready when the
          /// flush has completed and the stream can accept more writes.
          pub fn flush(&self,) -> Result<(),StreamError>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(4))]
              struct RetArea([u8; 12]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let ptr0 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
              extern "C" {
                #[link_name = "[method]output-stream.flush"]
                fn wit_import(_: i32, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, _: i32, ){ unreachable!() }
              wit_import((self).handle() as i32, ptr0);
              let l1 = i32::from(*((ptr0 + 0) as *const u8));
              match l1 {
                0 => {
                  let e = ();
                  Ok(e)
                }
                1 => {
                  let e = {
                    let l2 = i32::from(*((ptr0 + 4) as *const u8));
                    let v4 = match l2 {
                      0 => {
                        let e4 = {
                          let l3 = *((ptr0 + 8) as *const i32);
                          
                          super::super::super::wasi::io::error::Error::from_handle(l3 as u32)
                        };
                        StreamError::LastOperationFailed(e4)
                      }
                      n => {
                        debug_assert_eq!(n, 1, "invalid enum discriminant");
                        StreamError::Closed
                      }
                    };
                    
                    v4
                  };
                  Err(e)
                }
                _ => wit_bindgen::rt::invalid_enum_discriminant(),
              }
            }
          }
        }
        impl OutputStream {
          #[allow(unused_unsafe, clippy::all)]
          /// Request to flush buffered output, and block until flush completes
          /// and stream is ready for writing again.
          pub fn blocking_flush(&self,) -> Result<(),StreamError>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(4))]
              struct RetArea([u8; 12]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let ptr0 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
              extern "C" {
                #[link_name = "[method]output-stream.blocking-flush"]
                fn wit_import(_: i32, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, _: i32, ){ unreachable!() }
              wit_import((self).handle() as i32, ptr0);
              let l1 = i32::from(*((ptr0 + 0) as *const u8));
              match l1 {
                0 => {
                  let e = ();
                  Ok(e)
                }
                1 => {
                  let e = {
                    let l2 = i32::from(*((ptr0 + 4) as *const u8));
                    let v4 = match l2 {
                      0 => {
                        let e4 = {
                          let l3 = *((ptr0 + 8) as *const i32);
                          
                          super::super::super::wasi::io::error::Error::from_handle(l3 as u32)
                        };
                        StreamError::LastOperationFailed(e4)
                      }
                      n => {
                        debug_assert_eq!(n, 1, "invalid enum discriminant");
                        StreamError::Closed
                      }
                    };
                    
                    v4
                  };
                  Err(e)
                }
                _ => wit_bindgen::rt::invalid_enum_discriminant(),
              }
            }
          }
        }
        impl OutputStream {
          #[allow(unused_unsafe, clippy::all)]
          /// Create a `pollable` which will resolve once the output-stream
          /// is ready for more writing, or an error has occured. When this
          /// pollable is ready, `check-write` will return `ok(n)` with n>0, or an
          /// error.
          /// 
          /// If the stream is closed, this pollable is always ready immediately.
          /// 
          /// The created `pollable` is a child resource of the `output-stream`.
          /// Implementations may trap if the `output-stream` is dropped before
          /// all derived `pollable`s created with this function are dropped.
          pub fn subscribe(&self,) -> Pollable{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
              extern "C" {
                #[link_name = "[method]output-stream.subscribe"]
                fn wit_import(_: i32, ) -> i32;
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, ) -> i32{ unreachable!() }
              let ret = wit_import((self).handle() as i32);
              super::super::super::wasi::io::poll::Pollable::from_handle(ret as u32)
            }
          }
        }
        impl OutputStream {
          #[allow(unused_unsafe, clippy::all)]
          /// Write zeroes to a stream.
          /// 
          /// This should be used precisely like `write` with the exact same
          /// preconditions (must use check-write first), but instead of
          /// passing a list of bytes, you simply pass the number of zero-bytes
          /// that should be written.
          pub fn write_zeroes(&self,len: u64,) -> Result<(),StreamError>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(4))]
              struct RetArea([u8; 12]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let ptr0 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
              extern "C" {
                #[link_name = "[method]output-stream.write-zeroes"]
                fn wit_import(_: i32, _: i64, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
              wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(len), ptr0);
              let l1 = i32::from(*((ptr0 + 0) as *const u8));
              match l1 {
                0 => {
                  let e = ();
                  Ok(e)
                }
                1 => {
                  let e = {
                    let l2 = i32::from(*((ptr0 + 4) as *const u8));
                    let v4 = match l2 {
                      0 => {
                        let e4 = {
                          let l3 = *((ptr0 + 8) as *const i32);
                          
                          super::super::super::wasi::io::error::Error::from_handle(l3 as u32)
                        };
                        StreamError::LastOperationFailed(e4)
                      }
                      n => {
                        debug_assert_eq!(n, 1, "invalid enum discriminant");
                        StreamError::Closed
                      }
                    };
                    
                    v4
                  };
                  Err(e)
                }
                _ => wit_bindgen::rt::invalid_enum_discriminant(),
              }
            }
          }
        }
        impl OutputStream {
          #[allow(unused_unsafe, clippy::all)]
          /// Perform a write of up to 4096 zeroes, and then flush the stream.
          /// Block until all of these operations are complete, or an error
          /// occurs.
          /// 
          /// This is a convenience wrapper around the use of `check-write`,
          /// `subscribe`, `write-zeroes`, and `flush`, and is implemented with
          /// the following pseudo-code:
          /// 
          /// ```text
          /// let pollable = this.subscribe();
          /// while num_zeroes != 0 {
            /// // Wait for the stream to become writable
            /// pollable.block();
            /// let Ok(n) = this.check-write(); // eliding error handling
            /// let len = min(n, num_zeroes);
            /// this.write-zeroes(len);         // eliding error handling
            /// num_zeroes -= len;
            /// }
            /// this.flush();
            /// // Wait for completion of `flush`
            /// pollable.block();
            /// // Check for any errors that arose during `flush`
            /// let _ = this.check-write();         // eliding error handling
            /// ```
            pub fn blocking_write_zeroes_and_flush(&self,len: u64,) -> Result<(),StreamError>{
              
              #[allow(unused_imports)]
              use wit_bindgen::rt::{alloc, vec::Vec, string::String};
              unsafe {
                
                #[repr(align(4))]
                struct RetArea([u8; 12]);
                let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                let ptr0 = ret_area.as_mut_ptr() as i32;
                #[cfg(target_arch = "wasm32")]
                #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
                extern "C" {
                  #[link_name = "[method]output-stream.blocking-write-zeroes-and-flush"]
                  fn wit_import(_: i32, _: i64, _: i32, );
                }
                
                #[cfg(not(target_arch = "wasm32"))]
                fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
                wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(len), ptr0);
                let l1 = i32::from(*((ptr0 + 0) as *const u8));
                match l1 {
                  0 => {
                    let e = ();
                    Ok(e)
                  }
                  1 => {
                    let e = {
                      let l2 = i32::from(*((ptr0 + 4) as *const u8));
                      let v4 = match l2 {
                        0 => {
                          let e4 = {
                            let l3 = *((ptr0 + 8) as *const i32);
                            
                            super::super::super::wasi::io::error::Error::from_handle(l3 as u32)
                          };
                          StreamError::LastOperationFailed(e4)
                        }
                        n => {
                          debug_assert_eq!(n, 1, "invalid enum discriminant");
                          StreamError::Closed
                        }
                      };
                      
                      v4
                    };
                    Err(e)
                  }
                  _ => wit_bindgen::rt::invalid_enum_discriminant(),
                }
              }
            }
          }
          impl OutputStream {
            #[allow(unused_unsafe, clippy::all)]
            /// Read from one stream and write to another.
            /// 
            /// The behavior of splice is equivelant to:
            /// 1. calling `check-write` on the `output-stream`
            /// 2. calling `read` on the `input-stream` with the smaller of the
            /// `check-write` permitted length and the `len` provided to `splice`
            /// 3. calling `write` on the `output-stream` with that read data.
            /// 
            /// Any error reported by the call to `check-write`, `read`, or
            /// `write` ends the splice and reports that error.
            /// 
            /// This function returns the number of bytes transferred; it may be less
            /// than `len`.
            pub fn splice(&self,src: &InputStream,len: u64,) -> Result<u64,StreamError>{
              
              #[allow(unused_imports)]
              use wit_bindgen::rt::{alloc, vec::Vec, string::String};
              unsafe {
                
                #[repr(align(8))]
                struct RetArea([u8; 16]);
                let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                let ptr0 = ret_area.as_mut_ptr() as i32;
                #[cfg(target_arch = "wasm32")]
                #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
                extern "C" {
                  #[link_name = "[method]output-stream.splice"]
                  fn wit_import(_: i32, _: i32, _: i64, _: i32, );
                }
                
                #[cfg(not(target_arch = "wasm32"))]
                fn wit_import(_: i32, _: i32, _: i64, _: i32, ){ unreachable!() }
                wit_import((self).handle() as i32, (src).handle() as i32, wit_bindgen::rt::as_i64(len), ptr0);
                let l1 = i32::from(*((ptr0 + 0) as *const u8));
                match l1 {
                  0 => {
                    let e = {
                      let l2 = *((ptr0 + 8) as *const i64);
                      
                      l2 as u64
                    };
                    Ok(e)
                  }
                  1 => {
                    let e = {
                      let l3 = i32::from(*((ptr0 + 8) as *const u8));
                      let v5 = match l3 {
                        0 => {
                          let e5 = {
                            let l4 = *((ptr0 + 12) as *const i32);
                            
                            super::super::super::wasi::io::error::Error::from_handle(l4 as u32)
                          };
                          StreamError::LastOperationFailed(e5)
                        }
                        n => {
                          debug_assert_eq!(n, 1, "invalid enum discriminant");
                          StreamError::Closed
                        }
                      };
                      
                      v5
                    };
                    Err(e)
                  }
                  _ => wit_bindgen::rt::invalid_enum_discriminant(),
                }
              }
            }
          }
          impl OutputStream {
            #[allow(unused_unsafe, clippy::all)]
            /// Read from one stream and write to another, with blocking.
            /// 
            /// This is similar to `splice`, except that it blocks until the
            /// `output-stream` is ready for writing, and the `input-stream`
            /// is ready for reading, before performing the `splice`.
            pub fn blocking_splice(&self,src: &InputStream,len: u64,) -> Result<u64,StreamError>{
              
              #[allow(unused_imports)]
              use wit_bindgen::rt::{alloc, vec::Vec, string::String};
              unsafe {
                
                #[repr(align(8))]
                struct RetArea([u8; 16]);
                let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                let ptr0 = ret_area.as_mut_ptr() as i32;
                #[cfg(target_arch = "wasm32")]
                #[link(wasm_import_module = "wasi:io/streams@0.2.0")]
                extern "C" {
                  #[link_name = "[method]output-stream.blocking-splice"]
                  fn wit_import(_: i32, _: i32, _: i64, _: i32, );
                }
                
                #[cfg(not(target_arch = "wasm32"))]
                fn wit_import(_: i32, _: i32, _: i64, _: i32, ){ unreachable!() }
                wit_import((self).handle() as i32, (src).handle() as i32, wit_bindgen::rt::as_i64(len), ptr0);
                let l1 = i32::from(*((ptr0 + 0) as *const u8));
                match l1 {
                  0 => {
                    let e = {
                      let l2 = *((ptr0 + 8) as *const i64);
                      
                      l2 as u64
                    };
                    Ok(e)
                  }
                  1 => {
                    let e = {
                      let l3 = i32::from(*((ptr0 + 8) as *const u8));
                      let v5 = match l3 {
                        0 => {
                          let e5 = {
                            let l4 = *((ptr0 + 12) as *const i32);
                            
                            super::super::super::wasi::io::error::Error::from_handle(l4 as u32)
                          };
                          StreamError::LastOperationFailed(e5)
                        }
                        n => {
                          debug_assert_eq!(n, 1, "invalid enum discriminant");
                          StreamError::Closed
                        }
                      };
                      
                      v5
                    };
                    Err(e)
                  }
                  _ => wit_bindgen::rt::invalid_enum_discriminant(),
                }
              }
            }
          }
          
        }
        
      }
      pub mod nn {
        
        #[allow(clippy::all)]
        pub mod tensor {
          #[used]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
          /// The dimensions of a tensor.
          /// 
          /// The array length matches the tensor rank and each element in the array describes the size of
          /// each dimension
          pub type TensorDimensions = wit_bindgen::rt::vec::Vec::<u32>;
          /// The type of the elements in a tensor.
          #[repr(u8)]
          #[derive(Clone, Copy, Eq, PartialEq)]
          pub enum TensorType {
            Fp16,
            Fp32,
            Fp64,
            Bf16,
            U8,
            I32,
            I64,
          }
          impl ::core::fmt::Debug for TensorType {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              match self {
                TensorType::Fp16 => {
                  f.debug_tuple("TensorType::Fp16").finish()
                }
                TensorType::Fp32 => {
                  f.debug_tuple("TensorType::Fp32").finish()
                }
                TensorType::Fp64 => {
                  f.debug_tuple("TensorType::Fp64").finish()
                }
                TensorType::Bf16 => {
                  f.debug_tuple("TensorType::Bf16").finish()
                }
                TensorType::U8 => {
                  f.debug_tuple("TensorType::U8").finish()
                }
                TensorType::I32 => {
                  f.debug_tuple("TensorType::I32").finish()
                }
                TensorType::I64 => {
                  f.debug_tuple("TensorType::I64").finish()
                }
              }
            }
          }
          
          impl TensorType{
            pub(crate) unsafe fn _lift(val: u8) -> TensorType{
              if !cfg!(debug_assertions) {
                return ::core::mem::transmute(val);
              }
              
              match val {
                0 => TensorType::Fp16,
                1 => TensorType::Fp32,
                2 => TensorType::Fp64,
                3 => TensorType::Bf16,
                4 => TensorType::U8,
                5 => TensorType::I32,
                6 => TensorType::I64,
                
                _ => panic!("invalid enum discriminant"),
              }
            }
          }
          
          /// The tensor data.
          /// 
          /// Initially conceived as a sparse representation, each empty cell would be filled with zeros
          /// and the array length must match the product of all of the dimensions and the number of bytes
          /// in the type (e.g., a 2x2 tensor with 4-byte f32 elements would have a data array of length
          /// 16). Naturally, this representation requires some knowledge of how to lay out data in
          /// memory--e.g., using row-major ordering--and could perhaps be improved.
          pub type TensorData = wit_bindgen::rt::vec::Vec::<u8>;
          #[derive(Clone)]
          pub struct Tensor {
            /// Describe the size of the tensor (e.g., 2x2x2x2 -> [2, 2, 2, 2]). To represent a tensor
            /// containing a single value, use `[1]` for the tensor dimensions.
            pub dimensions: TensorDimensions,
            /// Describe the type of element in the tensor (e.g., `f32`).
            pub tensor_type: TensorType,
            /// Contains the tensor data.
            pub data: TensorData,
          }
          impl ::core::fmt::Debug for Tensor {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              f.debug_struct("Tensor").field("dimensions", &self.dimensions).field("tensor-type", &self.tensor_type).field("data", &self.data).finish()
            }
          }
          
        }
        
        
        #[allow(clippy::all)]
        pub mod errors {
          #[used]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
          #[repr(u8)]
          #[derive(Clone, Copy, Eq, PartialEq)]
          pub enum Error {
            /// Caller module passed an invalid argument.
            InvalidArgument,
            /// Invalid encoding.
            InvalidEncoding,
            Busy,
            /// Runtime Error.
            RuntimeError,
            /// Unsupported operation.
            UnsupportedOperation,
            /// Graph is too large.
            TooLarge,
            /// Graph not found.
            NotFound,
          }
          impl Error{
            pub fn name(&self) -> &'static str {
              match self {
                Error::InvalidArgument => "invalid-argument",
                Error::InvalidEncoding => "invalid-encoding",
                Error::Busy => "busy",
                Error::RuntimeError => "runtime-error",
                Error::UnsupportedOperation => "unsupported-operation",
                Error::TooLarge => "too-large",
                Error::NotFound => "not-found",
              }
            }
            pub fn message(&self) -> &'static str {
              match self {
                Error::InvalidArgument => "Caller module passed an invalid argument.",
                Error::InvalidEncoding => "Invalid encoding.",
                Error::Busy => "",
                Error::RuntimeError => "Runtime Error.",
                Error::UnsupportedOperation => "Unsupported operation.",
                Error::TooLarge => "Graph is too large.",
                Error::NotFound => "Graph not found.",
              }
            }
          }
          impl ::core::fmt::Debug for Error{
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              f.debug_struct("Error")
              .field("code", &(*self as i32))
              .field("name", &self.name())
              .field("message", &self.message())
              .finish()
            }
          }
          impl ::core::fmt::Display for Error{
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              write!(f, "{} (error {})", self.name(), *self as i32)
            }
          }
          
          impl std::error::Error for Error{}
          
          impl Error{
            pub(crate) unsafe fn _lift(val: u8) -> Error{
              if !cfg!(debug_assertions) {
                return ::core::mem::transmute(val);
              }
              
              match val {
                0 => Error::InvalidArgument,
                1 => Error::InvalidEncoding,
                2 => Error::Busy,
                3 => Error::RuntimeError,
                4 => Error::UnsupportedOperation,
                5 => Error::TooLarge,
                6 => Error::NotFound,
                
                _ => panic!("invalid enum discriminant"),
              }
            }
          }
          
          
        }
        
        
        #[allow(clippy::all)]
        pub mod graph {
          #[used]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
          pub type Error = super::super::super::wasi::nn::errors::Error;
          /// An execution graph for performing inference (i.e., a model).
          /// 
          /// TODO: replace with `resource` (https://github.com/WebAssembly/wasi-nn/issues/47).
          pub type Graph = u32;
          /// Describes the encoding of the graph. This allows the API to be implemented by various
          /// backends that encode (i.e., serialize) their graph IR with different formats.
          #[repr(u8)]
          #[derive(Clone, Copy, Eq, PartialEq)]
          pub enum GraphEncoding {
            Openvino,
            Onnx,
            Tensorflow,
            Pytorch,
            Tensorflowlite,
            Autodetect,
          }
          impl ::core::fmt::Debug for GraphEncoding {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              match self {
                GraphEncoding::Openvino => {
                  f.debug_tuple("GraphEncoding::Openvino").finish()
                }
                GraphEncoding::Onnx => {
                  f.debug_tuple("GraphEncoding::Onnx").finish()
                }
                GraphEncoding::Tensorflow => {
                  f.debug_tuple("GraphEncoding::Tensorflow").finish()
                }
                GraphEncoding::Pytorch => {
                  f.debug_tuple("GraphEncoding::Pytorch").finish()
                }
                GraphEncoding::Tensorflowlite => {
                  f.debug_tuple("GraphEncoding::Tensorflowlite").finish()
                }
                GraphEncoding::Autodetect => {
                  f.debug_tuple("GraphEncoding::Autodetect").finish()
                }
              }
            }
          }
          
          impl GraphEncoding{
            pub(crate) unsafe fn _lift(val: u8) -> GraphEncoding{
              if !cfg!(debug_assertions) {
                return ::core::mem::transmute(val);
              }
              
              match val {
                0 => GraphEncoding::Openvino,
                1 => GraphEncoding::Onnx,
                2 => GraphEncoding::Tensorflow,
                3 => GraphEncoding::Pytorch,
                4 => GraphEncoding::Tensorflowlite,
                5 => GraphEncoding::Autodetect,
                
                _ => panic!("invalid enum discriminant"),
              }
            }
          }
          
          /// Define where the graph should be executed.
          #[repr(u8)]
          #[derive(Clone, Copy, Eq, PartialEq)]
          pub enum ExecutionTarget {
            Cpu,
            Gpu,
            Tpu,
          }
          impl ::core::fmt::Debug for ExecutionTarget {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              match self {
                ExecutionTarget::Cpu => {
                  f.debug_tuple("ExecutionTarget::Cpu").finish()
                }
                ExecutionTarget::Gpu => {
                  f.debug_tuple("ExecutionTarget::Gpu").finish()
                }
                ExecutionTarget::Tpu => {
                  f.debug_tuple("ExecutionTarget::Tpu").finish()
                }
              }
            }
          }
          
          impl ExecutionTarget{
            pub(crate) unsafe fn _lift(val: u8) -> ExecutionTarget{
              if !cfg!(debug_assertions) {
                return ::core::mem::transmute(val);
              }
              
              match val {
                0 => ExecutionTarget::Cpu,
                1 => ExecutionTarget::Gpu,
                2 => ExecutionTarget::Tpu,
                
                _ => panic!("invalid enum discriminant"),
              }
            }
          }
          
          /// The graph initialization data.
          /// 
          /// This gets bundled up into an array of buffers because implementing backends may encode their
          /// graph IR in parts (e.g., OpenVINO stores its IR and weights separately).
          pub type GraphBuilder = wit_bindgen::rt::vec::Vec::<u8>;
          #[allow(unused_unsafe, clippy::all)]
          /// Load a `graph` from an opaque sequence of bytes to use for inference.
          pub fn load(builder: &[GraphBuilder],encoding: GraphEncoding,target: ExecutionTarget,) -> Result<Graph,Error>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(4))]
              struct RetArea([u8; 8]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let vec1 = builder;
              let len1 = vec1.len() as i32;
              let layout1 = alloc::Layout::from_size_align_unchecked(vec1.len() * 8, 4);
              let result1 = if layout1.size() != 0
              {
                let ptr = alloc::alloc(layout1);
                if ptr.is_null()
                {
                  alloc::handle_alloc_error(layout1);
                }
                ptr
              }else {{
                ::core::ptr::null_mut()
              }};
              for (i, e) in vec1.into_iter().enumerate() {
                let base = result1 as i32 + (i as i32) * 8;
                {
                  let vec0 = e;
                  let ptr0 = vec0.as_ptr() as i32;
                  let len0 = vec0.len() as i32;
                  *((base + 4) as *mut i32) = len0;
                  *((base + 0) as *mut i32) = ptr0;
                }
              }
              let ptr2 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:nn/graph")]
              extern "C" {
                #[link_name = "load"]
                fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
              wit_import(result1 as i32, len1, encoding.clone() as i32, target.clone() as i32, ptr2);
              let l3 = i32::from(*((ptr2 + 0) as *const u8));
              if layout1.size() != 0 {
                alloc::dealloc(result1, layout1);
              }
              match l3 {
                0 => {
                  let e = {
                    let l4 = *((ptr2 + 4) as *const i32);
                    
                    l4 as u32
                  };
                  Ok(e)
                }
                1 => {
                  let e = {
                    let l5 = i32::from(*((ptr2 + 4) as *const u8));
                    
                    super::super::super::wasi::nn::errors::Error::_lift(l5 as u8)
                  };
                  Err(e)
                }
                _ => wit_bindgen::rt::invalid_enum_discriminant(),
              }
            }
          }
          #[allow(unused_unsafe, clippy::all)]
          /// Load a `graph` by name.
          /// 
          /// How the host expects the names to be passed and how it stores the graphs for retrieval via
          /// this function is **implementation-specific**. This allows hosts to choose name schemes that
          /// range from simple to complex (e.g., URLs?) and caching mechanisms of various kinds.
          pub fn load_by_name(name: &str,) -> Result<Graph,Error>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(4))]
              struct RetArea([u8; 8]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let vec0 = name;
              let ptr0 = vec0.as_ptr() as i32;
              let len0 = vec0.len() as i32;
              let ptr1 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:nn/graph")]
              extern "C" {
                #[link_name = "load-by-name"]
                fn wit_import(_: i32, _: i32, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, _: i32, _: i32, ){ unreachable!() }
              wit_import(ptr0, len0, ptr1);
              let l2 = i32::from(*((ptr1 + 0) as *const u8));
              match l2 {
                0 => {
                  let e = {
                    let l3 = *((ptr1 + 4) as *const i32);
                    
                    l3 as u32
                  };
                  Ok(e)
                }
                1 => {
                  let e = {
                    let l4 = i32::from(*((ptr1 + 4) as *const u8));
                    
                    super::super::super::wasi::nn::errors::Error::_lift(l4 as u8)
                  };
                  Err(e)
                }
                _ => wit_bindgen::rt::invalid_enum_discriminant(),
              }
            }
          }
          
        }
        
        
        #[allow(clippy::all)]
        pub mod inference {
          #[used]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
          pub type Error = super::super::super::wasi::nn::errors::Error;
          pub type Tensor = super::super::super::wasi::nn::tensor::Tensor;
          pub type TensorData = super::super::super::wasi::nn::tensor::TensorData;
          pub type Graph = super::super::super::wasi::nn::graph::Graph;
          /// Bind a `graph` to the input and output tensors for an inference.
          /// 
          /// TODO: this is no longer necessary in WIT (https://github.com/WebAssembly/wasi-nn/issues/43)
          pub type GraphExecutionContext = u32;
          #[allow(unused_unsafe, clippy::all)]
          /// Create an execution instance of a loaded graph.
          pub fn init_execution_context(graph: Graph,) -> Result<GraphExecutionContext,Error>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(4))]
              struct RetArea([u8; 8]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let ptr0 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:nn/inference")]
              extern "C" {
                #[link_name = "init-execution-context"]
                fn wit_import(_: i32, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, _: i32, ){ unreachable!() }
              wit_import(wit_bindgen::rt::as_i32(graph), ptr0);
              let l1 = i32::from(*((ptr0 + 0) as *const u8));
              match l1 {
                0 => {
                  let e = {
                    let l2 = *((ptr0 + 4) as *const i32);
                    
                    l2 as u32
                  };
                  Ok(e)
                }
                1 => {
                  let e = {
                    let l3 = i32::from(*((ptr0 + 4) as *const u8));
                    
                    super::super::super::wasi::nn::errors::Error::_lift(l3 as u8)
                  };
                  Err(e)
                }
                _ => wit_bindgen::rt::invalid_enum_discriminant(),
              }
            }
          }
          #[allow(unused_unsafe, clippy::all)]
          /// Define the inputs to use for inference.
          pub fn set_input(ctx: GraphExecutionContext,index: u32,tensor: &Tensor,) -> Result<(),Error>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(1))]
              struct RetArea([u8; 2]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let super::super::super::wasi::nn::tensor::Tensor{ dimensions:dimensions0, tensor_type:tensor_type0, data:data0, } = tensor;
              let vec1 = dimensions0;
              let ptr1 = vec1.as_ptr() as i32;
              let len1 = vec1.len() as i32;
              let vec2 = data0;
              let ptr2 = vec2.as_ptr() as i32;
              let len2 = vec2.len() as i32;
              let ptr3 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:nn/inference")]
              extern "C" {
                #[link_name = "set-input"]
                fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
              wit_import(wit_bindgen::rt::as_i32(ctx), wit_bindgen::rt::as_i32(index), ptr1, len1, tensor_type0.clone() as i32, ptr2, len2, ptr3);
              let l4 = i32::from(*((ptr3 + 0) as *const u8));
              match l4 {
                0 => {
                  let e = ();
                  Ok(e)
                }
                1 => {
                  let e = {
                    let l5 = i32::from(*((ptr3 + 1) as *const u8));
                    
                    super::super::super::wasi::nn::errors::Error::_lift(l5 as u8)
                  };
                  Err(e)
                }
                _ => wit_bindgen::rt::invalid_enum_discriminant(),
              }
            }
          }
          #[allow(unused_unsafe, clippy::all)]
          /// Compute the inference on the given inputs.
          /// 
          /// Note the expected sequence of calls: `set-input`, `compute`, `get-output`. TODO: this
          /// expectation could be removed as a part of https://github.com/WebAssembly/wasi-nn/issues/43.
          pub fn compute(ctx: GraphExecutionContext,) -> Result<(),Error>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(1))]
              struct RetArea([u8; 2]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let ptr0 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:nn/inference")]
              extern "C" {
                #[link_name = "compute"]
                fn wit_import(_: i32, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, _: i32, ){ unreachable!() }
              wit_import(wit_bindgen::rt::as_i32(ctx), ptr0);
              let l1 = i32::from(*((ptr0 + 0) as *const u8));
              match l1 {
                0 => {
                  let e = ();
                  Ok(e)
                }
                1 => {
                  let e = {
                    let l2 = i32::from(*((ptr0 + 1) as *const u8));
                    
                    super::super::super::wasi::nn::errors::Error::_lift(l2 as u8)
                  };
                  Err(e)
                }
                _ => wit_bindgen::rt::invalid_enum_discriminant(),
              }
            }
          }
          #[allow(unused_unsafe, clippy::all)]
          /// Extract the outputs after inference.
          pub fn get_output(ctx: GraphExecutionContext,index: u32,) -> Result<TensorData,Error>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(4))]
              struct RetArea([u8; 12]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let ptr0 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:nn/inference")]
              extern "C" {
                #[link_name = "get-output"]
                fn wit_import(_: i32, _: i32, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, _: i32, _: i32, ){ unreachable!() }
              wit_import(wit_bindgen::rt::as_i32(ctx), wit_bindgen::rt::as_i32(index), ptr0);
              let l1 = i32::from(*((ptr0 + 0) as *const u8));
              match l1 {
                0 => {
                  let e = {
                    let l2 = *((ptr0 + 4) as *const i32);
                    let l3 = *((ptr0 + 8) as *const i32);
                    let len4 = l3 as usize;
                    
                    Vec::from_raw_parts(l2 as *mut _, len4, len4)
                  };
                  Ok(e)
                }
                1 => {
                  let e = {
                    let l5 = i32::from(*((ptr0 + 4) as *const u8));
                    
                    super::super::super::wasi::nn::errors::Error::_lift(l5 as u8)
                  };
                  Err(e)
                }
                _ => wit_bindgen::rt::invalid_enum_discriminant(),
              }
            }
          }
          
        }
        
      }
      pub mod random {
        
        #[allow(clippy::all)]
        pub mod random {
          #[used]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
          #[allow(unused_unsafe, clippy::all)]
          /// Return `len` cryptographically-secure random or pseudo-random bytes.
          /// 
          /// This function must produce data at least as cryptographically secure and
          /// fast as an adequately seeded cryptographically-secure pseudo-random
          /// number generator (CSPRNG). It must not block, from the perspective of
          /// the calling program, under any circumstances, including on the first
          /// request and on requests for numbers of bytes. The returned data must
          /// always be unpredictable.
          /// 
          /// This function must always return fresh data. Deterministic environments
          /// must omit this function, rather than implementing it with deterministic
          /// data.
          pub fn get_random_bytes(len: u64,) -> wit_bindgen::rt::vec::Vec::<u8>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(4))]
              struct RetArea([u8; 8]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let ptr0 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:random/random@0.2.0")]
              extern "C" {
                #[link_name = "get-random-bytes"]
                fn wit_import(_: i64, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i64, _: i32, ){ unreachable!() }
              wit_import(wit_bindgen::rt::as_i64(len), ptr0);
              let l1 = *((ptr0 + 0) as *const i32);
              let l2 = *((ptr0 + 4) as *const i32);
              let len3 = l2 as usize;
              Vec::from_raw_parts(l1 as *mut _, len3, len3)
            }
          }
          #[allow(unused_unsafe, clippy::all)]
          /// Return a cryptographically-secure random or pseudo-random `u64` value.
          /// 
          /// This function returns the same type of data as `get-random-bytes`,
          /// represented as a `u64`.
          pub fn get_random_u64() -> u64{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:random/random@0.2.0")]
              extern "C" {
                #[link_name = "get-random-u64"]
                fn wit_import() -> i64;
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import() -> i64{ unreachable!() }
              let ret = wit_import();
              ret as u64
            }
          }
          
        }
        
        
        #[allow(clippy::all)]
        pub mod insecure {
          #[used]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
          #[allow(unused_unsafe, clippy::all)]
          /// Return `len` insecure pseudo-random bytes.
          /// 
          /// This function is not cryptographically secure. Do not use it for
          /// anything related to security.
          /// 
          /// There are no requirements on the values of the returned bytes, however
          /// implementations are encouraged to return evenly distributed values with
          /// a long period.
          pub fn get_insecure_random_bytes(len: u64,) -> wit_bindgen::rt::vec::Vec::<u8>{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(4))]
              struct RetArea([u8; 8]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let ptr0 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:random/insecure@0.2.0")]
              extern "C" {
                #[link_name = "get-insecure-random-bytes"]
                fn wit_import(_: i64, _: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i64, _: i32, ){ unreachable!() }
              wit_import(wit_bindgen::rt::as_i64(len), ptr0);
              let l1 = *((ptr0 + 0) as *const i32);
              let l2 = *((ptr0 + 4) as *const i32);
              let len3 = l2 as usize;
              Vec::from_raw_parts(l1 as *mut _, len3, len3)
            }
          }
          #[allow(unused_unsafe, clippy::all)]
          /// Return an insecure pseudo-random `u64` value.
          /// 
          /// This function returns the same type of pseudo-random data as
          /// `get-insecure-random-bytes`, represented as a `u64`.
          pub fn get_insecure_random_u64() -> u64{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:random/insecure@0.2.0")]
              extern "C" {
                #[link_name = "get-insecure-random-u64"]
                fn wit_import() -> i64;
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import() -> i64{ unreachable!() }
              let ret = wit_import();
              ret as u64
            }
          }
          
        }
        
        
        #[allow(clippy::all)]
        pub mod insecure_seed {
          #[used]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
          #[allow(unused_unsafe, clippy::all)]
          /// Return a 128-bit value that may contain a pseudo-random value.
          /// 
          /// The returned value is not required to be computed from a CSPRNG, and may
          /// even be entirely deterministic. Host implementations are encouraged to
          /// provide pseudo-random values to any program exposed to
          /// attacker-controlled content, to enable DoS protection built into many
          /// languages' hash-map implementations.
          /// 
          /// This function is intended to only be called once, by a source language
          /// to initialize Denial Of Service (DoS) protection in its hash-map
          /// implementation.
          /// 
          /// # Expected future evolution
          /// 
          /// This will likely be changed to a value import, to prevent it from being
          /// called multiple times and potentially used for purposes other than DoS
          /// protection.
          pub fn insecure_seed() -> (u64,u64,){
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[repr(align(8))]
              struct RetArea([u8; 16]);
              let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
              let ptr0 = ret_area.as_mut_ptr() as i32;
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:random/insecure-seed@0.2.0")]
              extern "C" {
                #[link_name = "insecure-seed"]
                fn wit_import(_: i32, );
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import(_: i32, ){ unreachable!() }
              wit_import(ptr0);
              let l1 = *((ptr0 + 0) as *const i64);
              let l2 = *((ptr0 + 8) as *const i64);
              (l1 as u64, l2 as u64)
            }
          }
          
        }
        
      }
      pub mod sockets {
        
        #[allow(clippy::all)]
        pub mod network {
          #[used]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
          /// An opaque resource that represents access to (a subset of) the network.
          /// This enables context-based security for networking.
          /// There is no need for this to map 1:1 to a physical network interface.
          
          #[derive(Debug)]
          #[repr(transparent)]
          pub struct Network{
            handle: wit_bindgen::rt::Resource<Network>,
          }
          
          impl Network{
            #[doc(hidden)]
            pub unsafe fn from_handle(handle: u32) -> Self {
              Self {
                handle: wit_bindgen::rt::Resource::from_handle(handle),
              }
            }
            
            #[doc(hidden)]
            pub fn into_handle(self) -> u32 {
              wit_bindgen::rt::Resource::into_handle(self.handle)
            }
            
            #[doc(hidden)]
            pub fn handle(&self) -> u32 {
              wit_bindgen::rt::Resource::handle(&self.handle)
            }
          }
          
          
          unsafe impl wit_bindgen::rt::WasmResource for Network{
            #[inline]
            unsafe fn drop(_handle: u32) {
              #[cfg(not(target_arch = "wasm32"))]
              unreachable!();
              
              #[cfg(target_arch = "wasm32")]
              {
                #[link(wasm_import_module = "wasi:sockets/network@0.2.0")]
                extern "C" {
                  #[link_name = "[resource-drop]network"]
                  fn drop(_: u32);
                }
                
                drop(_handle);
              }
            }
          }
          
          /// Error codes.
          /// 
          /// In theory, every API can return any error code.
          /// In practice, API's typically only return the errors documented per API
          /// combined with a couple of errors that are always possible:
          /// - `unknown`
          /// - `access-denied`
          /// - `not-supported`
          /// - `out-of-memory`
          /// - `concurrency-conflict`
          /// 
          /// See each individual API for what the POSIX equivalents are. They sometimes differ per API.
          #[repr(u8)]
          #[derive(Clone, Copy, Eq, PartialEq)]
          pub enum ErrorCode {
            /// Unknown error
            Unknown,
            /// Access denied.
            /// 
            /// POSIX equivalent: EACCES, EPERM
            AccessDenied,
            /// The operation is not supported.
            /// 
            /// POSIX equivalent: EOPNOTSUPP
            NotSupported,
            /// One of the arguments is invalid.
            /// 
            /// POSIX equivalent: EINVAL
            InvalidArgument,
            /// Not enough memory to complete the operation.
            /// 
            /// POSIX equivalent: ENOMEM, ENOBUFS, EAI_MEMORY
            OutOfMemory,
            /// The operation timed out before it could finish completely.
            Timeout,
            /// This operation is incompatible with another asynchronous operation that is already in progress.
            /// 
            /// POSIX equivalent: EALREADY
            ConcurrencyConflict,
            /// Trying to finish an asynchronous operation that:
            /// - has not been started yet, or:
            /// - was already finished by a previous `finish-*` call.
            /// 
            /// Note: this is scheduled to be removed when `future`s are natively supported.
            NotInProgress,
            /// The operation has been aborted because it could not be completed immediately.
            /// 
            /// Note: this is scheduled to be removed when `future`s are natively supported.
            WouldBlock,
            /// The operation is not valid in the socket's current state.
            InvalidState,
            /// A new socket resource could not be created because of a system limit.
            NewSocketLimit,
            /// A bind operation failed because the provided address is not an address that the `network` can bind to.
            AddressNotBindable,
            /// A bind operation failed because the provided address is already in use or because there are no ephemeral ports available.
            AddressInUse,
            /// The remote address is not reachable
            RemoteUnreachable,
            /// The TCP connection was forcefully rejected
            ConnectionRefused,
            /// The TCP connection was reset.
            ConnectionReset,
            /// A TCP connection was aborted.
            ConnectionAborted,
            /// The size of a datagram sent to a UDP socket exceeded the maximum
            /// supported size.
            DatagramTooLarge,
            /// Name does not exist or has no suitable associated IP addresses.
            NameUnresolvable,
            /// A temporary failure in name resolution occurred.
            TemporaryResolverFailure,
            /// A permanent failure in name resolution occurred.
            PermanentResolverFailure,
          }
          impl ErrorCode{
            pub fn name(&self) -> &'static str {
              match self {
                ErrorCode::Unknown => "unknown",
                ErrorCode::AccessDenied => "access-denied",
                ErrorCode::NotSupported => "not-supported",
                ErrorCode::InvalidArgument => "invalid-argument",
                ErrorCode::OutOfMemory => "out-of-memory",
                ErrorCode::Timeout => "timeout",
                ErrorCode::ConcurrencyConflict => "concurrency-conflict",
                ErrorCode::NotInProgress => "not-in-progress",
                ErrorCode::WouldBlock => "would-block",
                ErrorCode::InvalidState => "invalid-state",
                ErrorCode::NewSocketLimit => "new-socket-limit",
                ErrorCode::AddressNotBindable => "address-not-bindable",
                ErrorCode::AddressInUse => "address-in-use",
                ErrorCode::RemoteUnreachable => "remote-unreachable",
                ErrorCode::ConnectionRefused => "connection-refused",
                ErrorCode::ConnectionReset => "connection-reset",
                ErrorCode::ConnectionAborted => "connection-aborted",
                ErrorCode::DatagramTooLarge => "datagram-too-large",
                ErrorCode::NameUnresolvable => "name-unresolvable",
                ErrorCode::TemporaryResolverFailure => "temporary-resolver-failure",
                ErrorCode::PermanentResolverFailure => "permanent-resolver-failure",
              }
            }
            pub fn message(&self) -> &'static str {
              match self {
                ErrorCode::Unknown => "Unknown error",
                ErrorCode::AccessDenied => "Access denied.
                
                POSIX equivalent: EACCES, EPERM",
                ErrorCode::NotSupported => "The operation is not supported.
                
                POSIX equivalent: EOPNOTSUPP",
                ErrorCode::InvalidArgument => "One of the arguments is invalid.
                
                POSIX equivalent: EINVAL",
                ErrorCode::OutOfMemory => "Not enough memory to complete the operation.
                
                POSIX equivalent: ENOMEM, ENOBUFS, EAI_MEMORY",
                ErrorCode::Timeout => "The operation timed out before it could finish completely.",
                ErrorCode::ConcurrencyConflict => "This operation is incompatible with another asynchronous operation that is already in progress.
                
                POSIX equivalent: EALREADY",
                ErrorCode::NotInProgress => "Trying to finish an asynchronous operation that:
                - has not been started yet, or:
                - was already finished by a previous `finish-*` call.
                
                Note: this is scheduled to be removed when `future`s are natively supported.",
                ErrorCode::WouldBlock => "The operation has been aborted because it could not be completed immediately.
                
                Note: this is scheduled to be removed when `future`s are natively supported.",
                ErrorCode::InvalidState => "The operation is not valid in the socket's current state.",
                ErrorCode::NewSocketLimit => "A new socket resource could not be created because of a system limit.",
                ErrorCode::AddressNotBindable => "A bind operation failed because the provided address is not an address that the `network` can bind to.",
                ErrorCode::AddressInUse => "A bind operation failed because the provided address is already in use or because there are no ephemeral ports available.",
                ErrorCode::RemoteUnreachable => "The remote address is not reachable",
                ErrorCode::ConnectionRefused => "The TCP connection was forcefully rejected",
                ErrorCode::ConnectionReset => "The TCP connection was reset.",
                ErrorCode::ConnectionAborted => "A TCP connection was aborted.",
                ErrorCode::DatagramTooLarge => "The size of a datagram sent to a UDP socket exceeded the maximum
                supported size.",
                ErrorCode::NameUnresolvable => "Name does not exist or has no suitable associated IP addresses.",
                ErrorCode::TemporaryResolverFailure => "A temporary failure in name resolution occurred.",
                ErrorCode::PermanentResolverFailure => "A permanent failure in name resolution occurred.",
              }
            }
          }
          impl ::core::fmt::Debug for ErrorCode{
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              f.debug_struct("ErrorCode")
              .field("code", &(*self as i32))
              .field("name", &self.name())
              .field("message", &self.message())
              .finish()
            }
          }
          impl ::core::fmt::Display for ErrorCode{
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              write!(f, "{} (error {})", self.name(), *self as i32)
            }
          }
          
          impl std::error::Error for ErrorCode{}
          
          impl ErrorCode{
            pub(crate) unsafe fn _lift(val: u8) -> ErrorCode{
              if !cfg!(debug_assertions) {
                return ::core::mem::transmute(val);
              }
              
              match val {
                0 => ErrorCode::Unknown,
                1 => ErrorCode::AccessDenied,
                2 => ErrorCode::NotSupported,
                3 => ErrorCode::InvalidArgument,
                4 => ErrorCode::OutOfMemory,
                5 => ErrorCode::Timeout,
                6 => ErrorCode::ConcurrencyConflict,
                7 => ErrorCode::NotInProgress,
                8 => ErrorCode::WouldBlock,
                9 => ErrorCode::InvalidState,
                10 => ErrorCode::NewSocketLimit,
                11 => ErrorCode::AddressNotBindable,
                12 => ErrorCode::AddressInUse,
                13 => ErrorCode::RemoteUnreachable,
                14 => ErrorCode::ConnectionRefused,
                15 => ErrorCode::ConnectionReset,
                16 => ErrorCode::ConnectionAborted,
                17 => ErrorCode::DatagramTooLarge,
                18 => ErrorCode::NameUnresolvable,
                19 => ErrorCode::TemporaryResolverFailure,
                20 => ErrorCode::PermanentResolverFailure,
                
                _ => panic!("invalid enum discriminant"),
              }
            }
          }
          
          #[repr(u8)]
          #[derive(Clone, Copy, Eq, PartialEq)]
          pub enum IpAddressFamily {
            /// Similar to `AF_INET` in POSIX.
            Ipv4,
            /// Similar to `AF_INET6` in POSIX.
            Ipv6,
          }
          impl ::core::fmt::Debug for IpAddressFamily {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              match self {
                IpAddressFamily::Ipv4 => {
                  f.debug_tuple("IpAddressFamily::Ipv4").finish()
                }
                IpAddressFamily::Ipv6 => {
                  f.debug_tuple("IpAddressFamily::Ipv6").finish()
                }
              }
            }
          }
          
          impl IpAddressFamily{
            pub(crate) unsafe fn _lift(val: u8) -> IpAddressFamily{
              if !cfg!(debug_assertions) {
                return ::core::mem::transmute(val);
              }
              
              match val {
                0 => IpAddressFamily::Ipv4,
                1 => IpAddressFamily::Ipv6,
                
                _ => panic!("invalid enum discriminant"),
              }
            }
          }
          
          pub type Ipv4Address = (u8,u8,u8,u8,);
          pub type Ipv6Address = (u16,u16,u16,u16,u16,u16,u16,u16,);
          #[derive(Clone, Copy)]
          pub enum IpAddress{
            Ipv4(Ipv4Address),
            Ipv6(Ipv6Address),
          }
          impl ::core::fmt::Debug for IpAddress {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              match self {
                IpAddress::Ipv4(e) => {
                  f.debug_tuple("IpAddress::Ipv4").field(e).finish()
                }
                IpAddress::Ipv6(e) => {
                  f.debug_tuple("IpAddress::Ipv6").field(e).finish()
                }
              }
            }
          }
          #[repr(C)]
          #[derive(Clone, Copy)]
          pub struct Ipv4SocketAddress {
            /// sin_port
            pub port: u16,
            /// sin_addr
            pub address: Ipv4Address,
          }
          impl ::core::fmt::Debug for Ipv4SocketAddress {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              f.debug_struct("Ipv4SocketAddress").field("port", &self.port).field("address", &self.address).finish()
            }
          }
          #[repr(C)]
          #[derive(Clone, Copy)]
          pub struct Ipv6SocketAddress {
            /// sin6_port
            pub port: u16,
            /// sin6_flowinfo
            pub flow_info: u32,
            /// sin6_addr
            pub address: Ipv6Address,
            /// sin6_scope_id
            pub scope_id: u32,
          }
          impl ::core::fmt::Debug for Ipv6SocketAddress {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              f.debug_struct("Ipv6SocketAddress").field("port", &self.port).field("flow-info", &self.flow_info).field("address", &self.address).field("scope-id", &self.scope_id).finish()
            }
          }
          #[derive(Clone, Copy)]
          pub enum IpSocketAddress{
            Ipv4(Ipv4SocketAddress),
            Ipv6(Ipv6SocketAddress),
          }
          impl ::core::fmt::Debug for IpSocketAddress {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              match self {
                IpSocketAddress::Ipv4(e) => {
                  f.debug_tuple("IpSocketAddress::Ipv4").field(e).finish()
                }
                IpSocketAddress::Ipv6(e) => {
                  f.debug_tuple("IpSocketAddress::Ipv6").field(e).finish()
                }
              }
            }
          }
          
        }
        
        
        #[allow(clippy::all)]
        pub mod instance_network {
          #[used]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
          pub type Network = super::super::super::wasi::sockets::network::Network;
          #[allow(unused_unsafe, clippy::all)]
          /// Get a handle to the default network.
          pub fn instance_network() -> Network{
            
            #[allow(unused_imports)]
            use wit_bindgen::rt::{alloc, vec::Vec, string::String};
            unsafe {
              
              #[cfg(target_arch = "wasm32")]
              #[link(wasm_import_module = "wasi:sockets/instance-network@0.2.0")]
              extern "C" {
                #[link_name = "instance-network"]
                fn wit_import() -> i32;
              }
              
              #[cfg(not(target_arch = "wasm32"))]
              fn wit_import() -> i32{ unreachable!() }
              let ret = wit_import();
              super::super::super::wasi::sockets::network::Network::from_handle(ret as u32)
            }
          }
          
        }
        
        
        #[allow(clippy::all)]
        pub mod udp {
          #[used]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
          pub type Pollable = super::super::super::wasi::io::poll::Pollable;
          pub type Network = super::super::super::wasi::sockets::network::Network;
          pub type ErrorCode = super::super::super::wasi::sockets::network::ErrorCode;
          pub type IpSocketAddress = super::super::super::wasi::sockets::network::IpSocketAddress;
          pub type IpAddressFamily = super::super::super::wasi::sockets::network::IpAddressFamily;
          /// A received datagram.
          #[derive(Clone)]
          pub struct IncomingDatagram {
            /// The payload.
            /// 
            /// Theoretical max size: ~64 KiB. In practice, typically less than 1500 bytes.
            pub data: wit_bindgen::rt::vec::Vec::<u8>,
            /// The source address.
            /// 
            /// This field is guaranteed to match the remote address the stream was initialized with, if any.
            /// 
            /// Equivalent to the `src_addr` out parameter of `recvfrom`.
            pub remote_address: IpSocketAddress,
          }
          impl ::core::fmt::Debug for IncomingDatagram {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              f.debug_struct("IncomingDatagram").field("data", &self.data).field("remote-address", &self.remote_address).finish()
            }
          }
          /// A datagram to be sent out.
          #[derive(Clone)]
          pub struct OutgoingDatagram {
            /// The payload.
            pub data: wit_bindgen::rt::vec::Vec::<u8>,
            /// The destination address.
            /// 
            /// The requirements on this field depend on how the stream was initialized:
            /// - with a remote address: this field must be None or match the stream's remote address exactly.
            /// - without a remote address: this field is required.
            /// 
            /// If this value is None, the send operation is equivalent to `send` in POSIX. Otherwise it is equivalent to `sendto`.
            pub remote_address: Option<IpSocketAddress>,
          }
          impl ::core::fmt::Debug for OutgoingDatagram {
            fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
              f.debug_struct("OutgoingDatagram").field("data", &self.data).field("remote-address", &self.remote_address).finish()
            }
          }
          /// A UDP socket handle.
          
          #[derive(Debug)]
          #[repr(transparent)]
          pub struct UdpSocket{
            handle: wit_bindgen::rt::Resource<UdpSocket>,
          }
          
          impl UdpSocket{
            #[doc(hidden)]
            pub unsafe fn from_handle(handle: u32) -> Self {
              Self {
                handle: wit_bindgen::rt::Resource::from_handle(handle),
              }
            }
            
            #[doc(hidden)]
            pub fn into_handle(self) -> u32 {
              wit_bindgen::rt::Resource::into_handle(self.handle)
            }
            
            #[doc(hidden)]
            pub fn handle(&self) -> u32 {
              wit_bindgen::rt::Resource::handle(&self.handle)
            }
          }
          
          
          unsafe impl wit_bindgen::rt::WasmResource for UdpSocket{
            #[inline]
            unsafe fn drop(_handle: u32) {
              #[cfg(not(target_arch = "wasm32"))]
              unreachable!();
              
              #[cfg(target_arch = "wasm32")]
              {
                #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                extern "C" {
                  #[link_name = "[resource-drop]udp-socket"]
                  fn drop(_: u32);
                }
                
                drop(_handle);
              }
            }
          }
          
          
          #[derive(Debug)]
          #[repr(transparent)]
          pub struct IncomingDatagramStream{
            handle: wit_bindgen::rt::Resource<IncomingDatagramStream>,
          }
          
          impl IncomingDatagramStream{
            #[doc(hidden)]
            pub unsafe fn from_handle(handle: u32) -> Self {
              Self {
                handle: wit_bindgen::rt::Resource::from_handle(handle),
              }
            }
            
            #[doc(hidden)]
            pub fn into_handle(self) -> u32 {
              wit_bindgen::rt::Resource::into_handle(self.handle)
            }
            
            #[doc(hidden)]
            pub fn handle(&self) -> u32 {
              wit_bindgen::rt::Resource::handle(&self.handle)
            }
          }
          
          
          unsafe impl wit_bindgen::rt::WasmResource for IncomingDatagramStream{
            #[inline]
            unsafe fn drop(_handle: u32) {
              #[cfg(not(target_arch = "wasm32"))]
              unreachable!();
              
              #[cfg(target_arch = "wasm32")]
              {
                #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                extern "C" {
                  #[link_name = "[resource-drop]incoming-datagram-stream"]
                  fn drop(_: u32);
                }
                
                drop(_handle);
              }
            }
          }
          
          
          #[derive(Debug)]
          #[repr(transparent)]
          pub struct OutgoingDatagramStream{
            handle: wit_bindgen::rt::Resource<OutgoingDatagramStream>,
          }
          
          impl OutgoingDatagramStream{
            #[doc(hidden)]
            pub unsafe fn from_handle(handle: u32) -> Self {
              Self {
                handle: wit_bindgen::rt::Resource::from_handle(handle),
              }
            }
            
            #[doc(hidden)]
            pub fn into_handle(self) -> u32 {
              wit_bindgen::rt::Resource::into_handle(self.handle)
            }
            
            #[doc(hidden)]
            pub fn handle(&self) -> u32 {
              wit_bindgen::rt::Resource::handle(&self.handle)
            }
          }
          
          
          unsafe impl wit_bindgen::rt::WasmResource for OutgoingDatagramStream{
            #[inline]
            unsafe fn drop(_handle: u32) {
              #[cfg(not(target_arch = "wasm32"))]
              unreachable!();
              
              #[cfg(target_arch = "wasm32")]
              {
                #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                extern "C" {
                  #[link_name = "[resource-drop]outgoing-datagram-stream"]
                  fn drop(_: u32);
                }
                
                drop(_handle);
              }
            }
          }
          
          impl UdpSocket {
            #[allow(unused_unsafe, clippy::all)]
            /// Bind the socket to a specific network on the provided IP address and port.
            /// 
            /// If the IP address is zero (`0.0.0.0` in IPv4, `::` in IPv6), it is left to the implementation to decide which
            /// network interface(s) to bind to.
            /// If the port is zero, the socket will be bound to a random free port.
            /// 
            /// # Typical errors
            /// - `invalid-argument`:          The `local-address` has the wrong address family. (EAFNOSUPPORT, EFAULT on Windows)
            /// - `invalid-state`:             The socket is already bound. (EINVAL)
            /// - `address-in-use`:            No ephemeral ports available. (EADDRINUSE, ENOBUFS on Windows)
            /// - `address-in-use`:            Address is already in use. (EADDRINUSE)
            /// - `address-not-bindable`:      `local-address` is not an address that the `network` can bind to. (EADDRNOTAVAIL)
            /// - `not-in-progress`:           A `bind` operation is not in progress.
            /// - `would-block`:               Can't finish the operation, it is still in progress. (EWOULDBLOCK, EAGAIN)
            /// 
            /// # Implementors note
            /// Unlike in POSIX, in WASI the bind operation is async. This enables
            /// interactive WASI hosts to inject permission prompts. Runtimes that
            /// don't want to make use of this ability can simply call the native
            /// `bind` as part of either `start-bind` or `finish-bind`.
            /// 
            /// # References
            /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/bind.html>
            /// - <https://man7.org/linux/man-pages/man2/bind.2.html>
            /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-bind>
            /// - <https://man.freebsd.org/cgi/man.cgi?query=bind&sektion=2&format=html>
            pub fn start_bind(&self,network: &Network,local_address: IpSocketAddress,) -> Result<(),ErrorCode>{
              
              #[allow(unused_imports)]
              use wit_bindgen::rt::{alloc, vec::Vec, string::String};
              unsafe {
                
                #[repr(align(1))]
                struct RetArea([u8; 2]);
                let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                use super::super::super::wasi::sockets::network::IpSocketAddress as V4;
                let (result5_0,result5_1,result5_2,result5_3,result5_4,result5_5,result5_6,result5_7,result5_8,result5_9,result5_10,result5_11,) = match local_address {
                  V4::Ipv4(e) => {
                    let super::super::super::wasi::sockets::network::Ipv4SocketAddress{ port:port0, address:address0, } = e;
                    let (t1_0, t1_1, t1_2, t1_3, ) = address0;
                    
                    (0i32, wit_bindgen::rt::as_i32(port0), wit_bindgen::rt::as_i32(t1_0), wit_bindgen::rt::as_i32(t1_1), wit_bindgen::rt::as_i32(t1_2), wit_bindgen::rt::as_i32(t1_3), 0i32, 0i32, 0i32, 0i32, 0i32, 0i32)
                  },
                  V4::Ipv6(e) => {
                    let super::super::super::wasi::sockets::network::Ipv6SocketAddress{ port:port2, flow_info:flow_info2, address:address2, scope_id:scope_id2, } = e;
                    let (t3_0, t3_1, t3_2, t3_3, t3_4, t3_5, t3_6, t3_7, ) = address2;
                    
                    (1i32, wit_bindgen::rt::as_i32(port2), wit_bindgen::rt::as_i32(flow_info2), wit_bindgen::rt::as_i32(t3_0), wit_bindgen::rt::as_i32(t3_1), wit_bindgen::rt::as_i32(t3_2), wit_bindgen::rt::as_i32(t3_3), wit_bindgen::rt::as_i32(t3_4), wit_bindgen::rt::as_i32(t3_5), wit_bindgen::rt::as_i32(t3_6), wit_bindgen::rt::as_i32(t3_7), wit_bindgen::rt::as_i32(scope_id2))
                  },
                };
                let ptr6 = ret_area.as_mut_ptr() as i32;
                #[cfg(target_arch = "wasm32")]
                #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                extern "C" {
                  #[link_name = "[method]udp-socket.start-bind"]
                  fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, );
                }
                
                #[cfg(not(target_arch = "wasm32"))]
                fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
                wit_import((self).handle() as i32, (network).handle() as i32, result5_0, result5_1, result5_2, result5_3, result5_4, result5_5, result5_6, result5_7, result5_8, result5_9, result5_10, result5_11, ptr6);
                let l7 = i32::from(*((ptr6 + 0) as *const u8));
                match l7 {
                  0 => {
                    let e = ();
                    Ok(e)
                  }
                  1 => {
                    let e = {
                      let l8 = i32::from(*((ptr6 + 1) as *const u8));
                      
                      super::super::super::wasi::sockets::network::ErrorCode::_lift(l8 as u8)
                    };
                    Err(e)
                  }
                  _ => wit_bindgen::rt::invalid_enum_discriminant(),
                }
              }
            }
          }
          impl UdpSocket {
            #[allow(unused_unsafe, clippy::all)]
            pub fn finish_bind(&self,) -> Result<(),ErrorCode>{
              
              #[allow(unused_imports)]
              use wit_bindgen::rt::{alloc, vec::Vec, string::String};
              unsafe {
                
                #[repr(align(1))]
                struct RetArea([u8; 2]);
                let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                let ptr0 = ret_area.as_mut_ptr() as i32;
                #[cfg(target_arch = "wasm32")]
                #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                extern "C" {
                  #[link_name = "[method]udp-socket.finish-bind"]
                  fn wit_import(_: i32, _: i32, );
                }
                
                #[cfg(not(target_arch = "wasm32"))]
                fn wit_import(_: i32, _: i32, ){ unreachable!() }
                wit_import((self).handle() as i32, ptr0);
                let l1 = i32::from(*((ptr0 + 0) as *const u8));
                match l1 {
                  0 => {
                    let e = ();
                    Ok(e)
                  }
                  1 => {
                    let e = {
                      let l2 = i32::from(*((ptr0 + 1) as *const u8));
                      
                      super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                    };
                    Err(e)
                  }
                  _ => wit_bindgen::rt::invalid_enum_discriminant(),
                }
              }
            }
          }
          impl UdpSocket {
            #[allow(unused_unsafe, clippy::all)]
            /// Set up inbound & outbound communication channels, optionally to a specific peer.
            /// 
            /// This function only changes the local socket configuration and does not generate any network traffic.
            /// On success, the `remote-address` of the socket is updated. The `local-address` may be updated as well,
            /// based on the best network path to `remote-address`.
            /// 
            /// When a `remote-address` is provided, the returned streams are limited to communicating with that specific peer:
            /// - `send` can only be used to send to this destination.
            /// - `receive` will only return datagrams sent from the provided `remote-address`.
            /// 
            /// This method may be called multiple times on the same socket to change its association, but
            /// only the most recently returned pair of streams will be operational. Implementations may trap if
            /// the streams returned by a previous invocation haven't been dropped yet before calling `stream` again.
            /// 
            /// The POSIX equivalent in pseudo-code is:
            /// ```text
            /// if (was previously connected) {
              /// connect(s, AF_UNSPEC)
              /// }
              /// if (remote_address is Some) {
                /// connect(s, remote_address)
                /// }
                /// ```
                /// 
                /// Unlike in POSIX, the socket must already be explicitly bound.
                /// 
                /// # Typical errors
                /// - `invalid-argument`:          The `remote-address` has the wrong address family. (EAFNOSUPPORT)
                /// - `invalid-argument`:          The IP address in `remote-address` is set to INADDR_ANY (`0.0.0.0` / `::`). (EDESTADDRREQ, EADDRNOTAVAIL)
                /// - `invalid-argument`:          The port in `remote-address` is set to 0. (EDESTADDRREQ, EADDRNOTAVAIL)
                /// - `invalid-state`:             The socket is not bound.
                /// - `address-in-use`:            Tried to perform an implicit bind, but there were no ephemeral ports available. (EADDRINUSE, EADDRNOTAVAIL on Linux, EAGAIN on BSD)
                /// - `remote-unreachable`:        The remote address is not reachable. (ECONNRESET, ENETRESET, EHOSTUNREACH, EHOSTDOWN, ENETUNREACH, ENETDOWN, ENONET)
                /// - `connection-refused`:        The connection was refused. (ECONNREFUSED)
                /// 
                /// # References
                /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/connect.html>
                /// - <https://man7.org/linux/man-pages/man2/connect.2.html>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-connect>
                /// - <https://man.freebsd.org/cgi/man.cgi?connect>
                pub fn stream(&self,remote_address: Option<IpSocketAddress>,) -> Result<(IncomingDatagramStream,OutgoingDatagramStream,),ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(4))]
                    struct RetArea([u8; 12]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let (result6_0,result6_1,result6_2,result6_3,result6_4,result6_5,result6_6,result6_7,result6_8,result6_9,result6_10,result6_11,result6_12,) = match remote_address {
                      Some(e) => {
                        use super::super::super::wasi::sockets::network::IpSocketAddress as V4;
                        let (result5_0,result5_1,result5_2,result5_3,result5_4,result5_5,result5_6,result5_7,result5_8,result5_9,result5_10,result5_11,) = match e {
                          V4::Ipv4(e) => {
                            let super::super::super::wasi::sockets::network::Ipv4SocketAddress{ port:port0, address:address0, } = e;
                            let (t1_0, t1_1, t1_2, t1_3, ) = address0;
                            
                            (0i32, wit_bindgen::rt::as_i32(port0), wit_bindgen::rt::as_i32(t1_0), wit_bindgen::rt::as_i32(t1_1), wit_bindgen::rt::as_i32(t1_2), wit_bindgen::rt::as_i32(t1_3), 0i32, 0i32, 0i32, 0i32, 0i32, 0i32)
                          },
                          V4::Ipv6(e) => {
                            let super::super::super::wasi::sockets::network::Ipv6SocketAddress{ port:port2, flow_info:flow_info2, address:address2, scope_id:scope_id2, } = e;
                            let (t3_0, t3_1, t3_2, t3_3, t3_4, t3_5, t3_6, t3_7, ) = address2;
                            
                            (1i32, wit_bindgen::rt::as_i32(port2), wit_bindgen::rt::as_i32(flow_info2), wit_bindgen::rt::as_i32(t3_0), wit_bindgen::rt::as_i32(t3_1), wit_bindgen::rt::as_i32(t3_2), wit_bindgen::rt::as_i32(t3_3), wit_bindgen::rt::as_i32(t3_4), wit_bindgen::rt::as_i32(t3_5), wit_bindgen::rt::as_i32(t3_6), wit_bindgen::rt::as_i32(t3_7), wit_bindgen::rt::as_i32(scope_id2))
                          },
                        };
                        
                        (1i32, result5_0, result5_1, result5_2, result5_3, result5_4, result5_5, result5_6, result5_7, result5_8, result5_9, result5_10, result5_11)
                      },
                      None => {
                        (0i32, 0i32, 0i32, 0i32, 0i32, 0i32, 0i32, 0i32, 0i32, 0i32, 0i32, 0i32, 0i32)
                      },
                    };let ptr7 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.stream"]
                      fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, result6_0, result6_1, result6_2, result6_3, result6_4, result6_5, result6_6, result6_7, result6_8, result6_9, result6_10, result6_11, result6_12, ptr7);
                    let l8 = i32::from(*((ptr7 + 0) as *const u8));
                    match l8 {
                      0 => {
                        let e = {
                          let l9 = *((ptr7 + 4) as *const i32);
                          let l10 = *((ptr7 + 8) as *const i32);
                          
                          (IncomingDatagramStream::from_handle(l9 as u32), OutgoingDatagramStream::from_handle(l10 as u32))
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l11 = i32::from(*((ptr7 + 4) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l11 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl UdpSocket {
                #[allow(unused_unsafe, clippy::all)]
                /// Get the current bound address.
                /// 
                /// POSIX mentions:
                /// > If the socket has not been bound to a local name, the value
                /// > stored in the object pointed to by `address` is unspecified.
                /// 
                /// WASI is stricter and requires `local-address` to return `invalid-state` when the socket hasn't been bound yet.
                /// 
                /// # Typical errors
                /// - `invalid-state`: The socket is not bound to any local address.
                /// 
                /// # References
                /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/getsockname.html>
                /// - <https://man7.org/linux/man-pages/man2/getsockname.2.html>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-getsockname>
                /// - <https://man.freebsd.org/cgi/man.cgi?getsockname>
                pub fn local_address(&self,) -> Result<IpSocketAddress,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(4))]
                    struct RetArea([u8; 36]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.local-address"]
                      fn wit_import(_: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = {
                          let l2 = i32::from(*((ptr0 + 4) as *const u8));
                          use super::super::super::wasi::sockets::network::IpSocketAddress as V19;
                          let v19 = match l2 {
                            0 => {
                              let e19 = {
                                let l3 = i32::from(*((ptr0 + 8) as *const u16));
                                let l4 = i32::from(*((ptr0 + 10) as *const u8));
                                let l5 = i32::from(*((ptr0 + 11) as *const u8));
                                let l6 = i32::from(*((ptr0 + 12) as *const u8));
                                let l7 = i32::from(*((ptr0 + 13) as *const u8));
                                
                                super::super::super::wasi::sockets::network::Ipv4SocketAddress{
                                  port: l3 as u16,
                                  address: (l4 as u8, l5 as u8, l6 as u8, l7 as u8),
                                }
                              };
                              V19::Ipv4(e19)
                            }
                            n => {
                              debug_assert_eq!(n, 1, "invalid enum discriminant");
                              let e19 = {
                                let l8 = i32::from(*((ptr0 + 8) as *const u16));
                                let l9 = *((ptr0 + 12) as *const i32);
                                let l10 = i32::from(*((ptr0 + 16) as *const u16));
                                let l11 = i32::from(*((ptr0 + 18) as *const u16));
                                let l12 = i32::from(*((ptr0 + 20) as *const u16));
                                let l13 = i32::from(*((ptr0 + 22) as *const u16));
                                let l14 = i32::from(*((ptr0 + 24) as *const u16));
                                let l15 = i32::from(*((ptr0 + 26) as *const u16));
                                let l16 = i32::from(*((ptr0 + 28) as *const u16));
                                let l17 = i32::from(*((ptr0 + 30) as *const u16));
                                let l18 = *((ptr0 + 32) as *const i32);
                                
                                super::super::super::wasi::sockets::network::Ipv6SocketAddress{
                                  port: l8 as u16,
                                  flow_info: l9 as u32,
                                  address: (l10 as u16, l11 as u16, l12 as u16, l13 as u16, l14 as u16, l15 as u16, l16 as u16, l17 as u16),
                                  scope_id: l18 as u32,
                                }
                              };
                              V19::Ipv6(e19)
                            }
                          };
                          
                          v19
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l20 = i32::from(*((ptr0 + 4) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l20 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl UdpSocket {
                #[allow(unused_unsafe, clippy::all)]
                /// Get the address the socket is currently streaming to.
                /// 
                /// # Typical errors
                /// - `invalid-state`: The socket is not streaming to a specific remote address. (ENOTCONN)
                /// 
                /// # References
                /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/getpeername.html>
                /// - <https://man7.org/linux/man-pages/man2/getpeername.2.html>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-getpeername>
                /// - <https://man.freebsd.org/cgi/man.cgi?query=getpeername&sektion=2&n=1>
                pub fn remote_address(&self,) -> Result<IpSocketAddress,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(4))]
                    struct RetArea([u8; 36]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.remote-address"]
                      fn wit_import(_: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = {
                          let l2 = i32::from(*((ptr0 + 4) as *const u8));
                          use super::super::super::wasi::sockets::network::IpSocketAddress as V19;
                          let v19 = match l2 {
                            0 => {
                              let e19 = {
                                let l3 = i32::from(*((ptr0 + 8) as *const u16));
                                let l4 = i32::from(*((ptr0 + 10) as *const u8));
                                let l5 = i32::from(*((ptr0 + 11) as *const u8));
                                let l6 = i32::from(*((ptr0 + 12) as *const u8));
                                let l7 = i32::from(*((ptr0 + 13) as *const u8));
                                
                                super::super::super::wasi::sockets::network::Ipv4SocketAddress{
                                  port: l3 as u16,
                                  address: (l4 as u8, l5 as u8, l6 as u8, l7 as u8),
                                }
                              };
                              V19::Ipv4(e19)
                            }
                            n => {
                              debug_assert_eq!(n, 1, "invalid enum discriminant");
                              let e19 = {
                                let l8 = i32::from(*((ptr0 + 8) as *const u16));
                                let l9 = *((ptr0 + 12) as *const i32);
                                let l10 = i32::from(*((ptr0 + 16) as *const u16));
                                let l11 = i32::from(*((ptr0 + 18) as *const u16));
                                let l12 = i32::from(*((ptr0 + 20) as *const u16));
                                let l13 = i32::from(*((ptr0 + 22) as *const u16));
                                let l14 = i32::from(*((ptr0 + 24) as *const u16));
                                let l15 = i32::from(*((ptr0 + 26) as *const u16));
                                let l16 = i32::from(*((ptr0 + 28) as *const u16));
                                let l17 = i32::from(*((ptr0 + 30) as *const u16));
                                let l18 = *((ptr0 + 32) as *const i32);
                                
                                super::super::super::wasi::sockets::network::Ipv6SocketAddress{
                                  port: l8 as u16,
                                  flow_info: l9 as u32,
                                  address: (l10 as u16, l11 as u16, l12 as u16, l13 as u16, l14 as u16, l15 as u16, l16 as u16, l17 as u16),
                                  scope_id: l18 as u32,
                                }
                              };
                              V19::Ipv6(e19)
                            }
                          };
                          
                          v19
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l20 = i32::from(*((ptr0 + 4) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l20 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl UdpSocket {
                #[allow(unused_unsafe, clippy::all)]
                /// Whether this is a IPv4 or IPv6 socket.
                /// 
                /// Equivalent to the SO_DOMAIN socket option.
                pub fn address_family(&self,) -> IpAddressFamily{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.address-family"]
                      fn wit_import(_: i32, ) -> i32;
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, ) -> i32{ unreachable!() }
                    let ret = wit_import((self).handle() as i32);
                    super::super::super::wasi::sockets::network::IpAddressFamily::_lift(ret as u8)
                  }
                }
              }
              impl UdpSocket {
                #[allow(unused_unsafe, clippy::all)]
                /// Equivalent to the IP_TTL & IPV6_UNICAST_HOPS socket options.
                /// 
                /// If the provided value is 0, an `invalid-argument` error is returned.
                /// 
                /// # Typical errors
                /// - `invalid-argument`:     (set) The TTL value must be 1 or higher.
                pub fn unicast_hop_limit(&self,) -> Result<u8,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(1))]
                    struct RetArea([u8; 2]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.unicast-hop-limit"]
                      fn wit_import(_: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = {
                          let l2 = i32::from(*((ptr0 + 1) as *const u8));
                          
                          l2 as u8
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l3 = i32::from(*((ptr0 + 1) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl UdpSocket {
                #[allow(unused_unsafe, clippy::all)]
                pub fn set_unicast_hop_limit(&self,value: u8,) -> Result<(),ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(1))]
                    struct RetArea([u8; 2]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.set-unicast-hop-limit"]
                      fn wit_import(_: i32, _: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, wit_bindgen::rt::as_i32(value), ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = ();
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l2 = i32::from(*((ptr0 + 1) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl UdpSocket {
                #[allow(unused_unsafe, clippy::all)]
                /// The kernel buffer space reserved for sends/receives on this socket.
                /// 
                /// If the provided value is 0, an `invalid-argument` error is returned.
                /// Any other value will never cause an error, but it might be silently clamped and/or rounded.
                /// I.e. after setting a value, reading the same setting back may return a different value.
                /// 
                /// Equivalent to the SO_RCVBUF and SO_SNDBUF socket options.
                /// 
                /// # Typical errors
                /// - `invalid-argument`:     (set) The provided value was 0.
                pub fn receive_buffer_size(&self,) -> Result<u64,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(8))]
                    struct RetArea([u8; 16]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.receive-buffer-size"]
                      fn wit_import(_: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = {
                          let l2 = *((ptr0 + 8) as *const i64);
                          
                          l2 as u64
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l3 = i32::from(*((ptr0 + 8) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl UdpSocket {
                #[allow(unused_unsafe, clippy::all)]
                pub fn set_receive_buffer_size(&self,value: u64,) -> Result<(),ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(1))]
                    struct RetArea([u8; 2]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.set-receive-buffer-size"]
                      fn wit_import(_: i32, _: i64, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(value), ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = ();
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l2 = i32::from(*((ptr0 + 1) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl UdpSocket {
                #[allow(unused_unsafe, clippy::all)]
                pub fn send_buffer_size(&self,) -> Result<u64,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(8))]
                    struct RetArea([u8; 16]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.send-buffer-size"]
                      fn wit_import(_: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = {
                          let l2 = *((ptr0 + 8) as *const i64);
                          
                          l2 as u64
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l3 = i32::from(*((ptr0 + 8) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl UdpSocket {
                #[allow(unused_unsafe, clippy::all)]
                pub fn set_send_buffer_size(&self,value: u64,) -> Result<(),ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(1))]
                    struct RetArea([u8; 2]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.set-send-buffer-size"]
                      fn wit_import(_: i32, _: i64, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(value), ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = ();
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l2 = i32::from(*((ptr0 + 1) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl UdpSocket {
                #[allow(unused_unsafe, clippy::all)]
                /// Create a `pollable` which will resolve once the socket is ready for I/O.
                /// 
                /// Note: this function is here for WASI Preview2 only.
                /// It's planned to be removed when `future` is natively supported in Preview3.
                pub fn subscribe(&self,) -> Pollable{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]udp-socket.subscribe"]
                      fn wit_import(_: i32, ) -> i32;
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, ) -> i32{ unreachable!() }
                    let ret = wit_import((self).handle() as i32);
                    super::super::super::wasi::io::poll::Pollable::from_handle(ret as u32)
                  }
                }
              }
              impl IncomingDatagramStream {
                #[allow(unused_unsafe, clippy::all)]
                /// Receive messages on the socket.
                /// 
                /// This function attempts to receive up to `max-results` datagrams on the socket without blocking.
                /// The returned list may contain fewer elements than requested, but never more.
                /// 
                /// This function returns successfully with an empty list when either:
                /// - `max-results` is 0, or:
                /// - `max-results` is greater than 0, but no results are immediately available.
                /// This function never returns `error(would-block)`.
                /// 
                /// # Typical errors
                /// - `remote-unreachable`: The remote address is not reachable. (ECONNRESET, ENETRESET on Windows, EHOSTUNREACH, EHOSTDOWN, ENETUNREACH, ENETDOWN, ENONET)
                /// - `connection-refused`: The connection was refused. (ECONNREFUSED)
                /// 
                /// # References
                /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/recvfrom.html>
                /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/recvmsg.html>
                /// - <https://man7.org/linux/man-pages/man2/recv.2.html>
                /// - <https://man7.org/linux/man-pages/man2/recvmmsg.2.html>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-recv>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-recvfrom>
                /// - <https://learn.microsoft.com/en-us/previous-versions/windows/desktop/legacy/ms741687(v=vs.85)>
                /// - <https://man.freebsd.org/cgi/man.cgi?query=recv&sektion=2>
                pub fn receive(&self,max_results: u64,) -> Result<wit_bindgen::rt::vec::Vec::<IncomingDatagram>,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(4))]
                    struct RetArea([u8; 12]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]incoming-datagram-stream.receive"]
                      fn wit_import(_: i32, _: i64, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(max_results), ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = {
                          let l2 = *((ptr0 + 4) as *const i32);
                          let l3 = *((ptr0 + 8) as *const i32);
                          let base25 = l2;
                          let len25 = l3;
                          let mut result25 = Vec::with_capacity(len25 as usize);
                          for i in 0..len25 {
                            let base = base25 + i * 40;
                            let e25 = {
                              let l4 = *((base + 0) as *const i32);
                              let l5 = *((base + 4) as *const i32);
                              let len6 = l5 as usize;
                              let l7 = i32::from(*((base + 8) as *const u8));
                              use super::super::super::wasi::sockets::network::IpSocketAddress as V24;
                              let v24 = match l7 {
                                0 => {
                                  let e24 = {
                                    let l8 = i32::from(*((base + 12) as *const u16));
                                    let l9 = i32::from(*((base + 14) as *const u8));
                                    let l10 = i32::from(*((base + 15) as *const u8));
                                    let l11 = i32::from(*((base + 16) as *const u8));
                                    let l12 = i32::from(*((base + 17) as *const u8));
                                    
                                    super::super::super::wasi::sockets::network::Ipv4SocketAddress{
                                      port: l8 as u16,
                                      address: (l9 as u8, l10 as u8, l11 as u8, l12 as u8),
                                    }
                                  };
                                  V24::Ipv4(e24)
                                }
                                n => {
                                  debug_assert_eq!(n, 1, "invalid enum discriminant");
                                  let e24 = {
                                    let l13 = i32::from(*((base + 12) as *const u16));
                                    let l14 = *((base + 16) as *const i32);
                                    let l15 = i32::from(*((base + 20) as *const u16));
                                    let l16 = i32::from(*((base + 22) as *const u16));
                                    let l17 = i32::from(*((base + 24) as *const u16));
                                    let l18 = i32::from(*((base + 26) as *const u16));
                                    let l19 = i32::from(*((base + 28) as *const u16));
                                    let l20 = i32::from(*((base + 30) as *const u16));
                                    let l21 = i32::from(*((base + 32) as *const u16));
                                    let l22 = i32::from(*((base + 34) as *const u16));
                                    let l23 = *((base + 36) as *const i32);
                                    
                                    super::super::super::wasi::sockets::network::Ipv6SocketAddress{
                                      port: l13 as u16,
                                      flow_info: l14 as u32,
                                      address: (l15 as u16, l16 as u16, l17 as u16, l18 as u16, l19 as u16, l20 as u16, l21 as u16, l22 as u16),
                                      scope_id: l23 as u32,
                                    }
                                  };
                                  V24::Ipv6(e24)
                                }
                              };
                              
                              IncomingDatagram{
                                data: Vec::from_raw_parts(l4 as *mut _, len6, len6),
                                remote_address: v24,
                              }
                            };
                            result25.push(e25);
                          }
                          wit_bindgen::rt::dealloc(base25, (len25 as usize) * 40, 4);
                          
                          result25
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l26 = i32::from(*((ptr0 + 4) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l26 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl IncomingDatagramStream {
                #[allow(unused_unsafe, clippy::all)]
                /// Create a `pollable` which will resolve once the stream is ready to receive again.
                /// 
                /// Note: this function is here for WASI Preview2 only.
                /// It's planned to be removed when `future` is natively supported in Preview3.
                pub fn subscribe(&self,) -> Pollable{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]incoming-datagram-stream.subscribe"]
                      fn wit_import(_: i32, ) -> i32;
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, ) -> i32{ unreachable!() }
                    let ret = wit_import((self).handle() as i32);
                    super::super::super::wasi::io::poll::Pollable::from_handle(ret as u32)
                  }
                }
              }
              impl OutgoingDatagramStream {
                #[allow(unused_unsafe, clippy::all)]
                /// Check readiness for sending. This function never blocks.
                /// 
                /// Returns the number of datagrams permitted for the next call to `send`,
                /// or an error. Calling `send` with more datagrams than this function has
                /// permitted will trap.
                /// 
                /// When this function returns ok(0), the `subscribe` pollable will
                /// become ready when this function will report at least ok(1), or an
                /// error.
                /// 
                /// Never returns `would-block`.
                pub fn check_send(&self,) -> Result<u64,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(8))]
                    struct RetArea([u8; 16]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                    extern "C" {
                      #[link_name = "[method]outgoing-datagram-stream.check-send"]
                      fn wit_import(_: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, ){ unreachable!() }
                    wit_import((self).handle() as i32, ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = {
                          let l2 = *((ptr0 + 8) as *const i64);
                          
                          l2 as u64
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l3 = i32::from(*((ptr0 + 8) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
              }
              impl OutgoingDatagramStream {
                #[allow(unused_unsafe, clippy::all)]
                /// Send messages on the socket.
                /// 
                /// This function attempts to send all provided `datagrams` on the socket without blocking and
                /// returns how many messages were actually sent (or queued for sending). This function never
                /// returns `error(would-block)`. If none of the datagrams were able to be sent, `ok(0)` is returned.
                /// 
                /// This function semantically behaves the same as iterating the `datagrams` list and sequentially
                /// sending each individual datagram until either the end of the list has been reached or the first error occurred.
                /// If at least one datagram has been sent successfully, this function never returns an error.
                /// 
                /// If the input list is empty, the function returns `ok(0)`.
                /// 
                /// Each call to `send` must be permitted by a preceding `check-send`. Implementations must trap if
                /// either `check-send` was not called or `datagrams` contains more items than `check-send` permitted.
                /// 
                /// # Typical errors
                /// - `invalid-argument`:        The `remote-address` has the wrong address family. (EAFNOSUPPORT)
                /// - `invalid-argument`:        The IP address in `remote-address` is set to INADDR_ANY (`0.0.0.0` / `::`). (EDESTADDRREQ, EADDRNOTAVAIL)
                /// - `invalid-argument`:        The port in `remote-address` is set to 0. (EDESTADDRREQ, EADDRNOTAVAIL)
                /// - `invalid-argument`:        The socket is in "connected" mode and `remote-address` is `some` value that does not match the address passed to `stream`. (EISCONN)
                /// - `invalid-argument`:        The socket is not "connected" and no value for `remote-address` was provided. (EDESTADDRREQ)
                /// - `remote-unreachable`:      The remote address is not reachable. (ECONNRESET, ENETRESET on Windows, EHOSTUNREACH, EHOSTDOWN, ENETUNREACH, ENETDOWN, ENONET)
                /// - `connection-refused`:      The connection was refused. (ECONNREFUSED)
                /// - `datagram-too-large`:      The datagram is too large. (EMSGSIZE)
                /// 
                /// # References
                /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/sendto.html>
                /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/sendmsg.html>
                /// - <https://man7.org/linux/man-pages/man2/send.2.html>
                /// - <https://man7.org/linux/man-pages/man2/sendmmsg.2.html>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-send>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-sendto>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-wsasendmsg>
                /// - <https://man.freebsd.org/cgi/man.cgi?query=send&sektion=2>
                pub fn send(&self,datagrams: &[OutgoingDatagram],) -> Result<u64,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(8))]
                    struct RetArea([u8; 16]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let vec7 = datagrams;
                    let len7 = vec7.len() as i32;
                    let layout7 = alloc::Layout::from_size_align_unchecked(vec7.len() * 44, 4);
                    let result7 = if layout7.size() != 0
                    {
                      let ptr = alloc::alloc(layout7);
                      if ptr.is_null()
                      {
                        alloc::handle_alloc_error(layout7);
                      }
                      ptr
                    }else {{
                      ::core::ptr::null_mut()
                    }};
                    for (i, e) in vec7.into_iter().enumerate() {
                      let base = result7 as i32 + (i as i32) * 44;
                      {
                        let OutgoingDatagram{ data:data0, remote_address:remote_address0, } = e;
                        let vec1 = data0;
                        let ptr1 = vec1.as_ptr() as i32;
                        let len1 = vec1.len() as i32;
                        *((base + 4) as *mut i32) = len1;
                        *((base + 0) as *mut i32) = ptr1;
                        match remote_address0 {
                          Some(e) => {
                            *((base + 8) as *mut u8) = (1i32) as u8;
                            use super::super::super::wasi::sockets::network::IpSocketAddress as V6;
                            match e {
                              V6::Ipv4(e) => {
                                *((base + 12) as *mut u8) = (0i32) as u8;
                                let super::super::super::wasi::sockets::network::Ipv4SocketAddress{ port:port2, address:address2, } = e;
                                *((base + 16) as *mut u16) = (wit_bindgen::rt::as_i32(port2)) as u16;
                                let (t3_0, t3_1, t3_2, t3_3, ) = address2;
                                *((base + 18) as *mut u8) = (wit_bindgen::rt::as_i32(t3_0)) as u8;
                                *((base + 19) as *mut u8) = (wit_bindgen::rt::as_i32(t3_1)) as u8;
                                *((base + 20) as *mut u8) = (wit_bindgen::rt::as_i32(t3_2)) as u8;
                                *((base + 21) as *mut u8) = (wit_bindgen::rt::as_i32(t3_3)) as u8;
                              },
                              V6::Ipv6(e) => {
                                *((base + 12) as *mut u8) = (1i32) as u8;
                                let super::super::super::wasi::sockets::network::Ipv6SocketAddress{ port:port4, flow_info:flow_info4, address:address4, scope_id:scope_id4, } = e;
                                *((base + 16) as *mut u16) = (wit_bindgen::rt::as_i32(port4)) as u16;
                                *((base + 20) as *mut i32) = wit_bindgen::rt::as_i32(flow_info4);
                                let (t5_0, t5_1, t5_2, t5_3, t5_4, t5_5, t5_6, t5_7, ) = address4;
                                *((base + 24) as *mut u16) = (wit_bindgen::rt::as_i32(t5_0)) as u16;
                                *((base + 26) as *mut u16) = (wit_bindgen::rt::as_i32(t5_1)) as u16;
                                *((base + 28) as *mut u16) = (wit_bindgen::rt::as_i32(t5_2)) as u16;
                                *((base + 30) as *mut u16) = (wit_bindgen::rt::as_i32(t5_3)) as u16;
                                *((base + 32) as *mut u16) = (wit_bindgen::rt::as_i32(t5_4)) as u16;
                                *((base + 34) as *mut u16) = (wit_bindgen::rt::as_i32(t5_5)) as u16;
                                *((base + 36) as *mut u16) = (wit_bindgen::rt::as_i32(t5_6)) as u16;
                                *((base + 38) as *mut u16) = (wit_bindgen::rt::as_i32(t5_7)) as u16;
                                *((base + 40) as *mut i32) = wit_bindgen::rt::as_i32(scope_id4);
                              },
                            }
                          },
                          None => {
                            {
                              *((base + 8) as *mut u8) = (0i32) as u8;
                            }
                          },
                        };}
                      }
                      let ptr8 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]outgoing-datagram-stream.send"]
                        fn wit_import(_: i32, _: i32, _: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, result7 as i32, len7, ptr8);
                      let l9 = i32::from(*((ptr8 + 0) as *const u8));
                      if layout7.size() != 0 {
                        alloc::dealloc(result7, layout7);
                      }
                      match l9 {
                        0 => {
                          let e = {
                            let l10 = *((ptr8 + 8) as *const i64);
                            
                            l10 as u64
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l11 = i32::from(*((ptr8 + 8) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l11 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl OutgoingDatagramStream {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Create a `pollable` which will resolve once the stream is ready to send again.
                  /// 
                  /// Note: this function is here for WASI Preview2 only.
                  /// It's planned to be removed when `future` is natively supported in Preview3.
                  pub fn subscribe(&self,) -> Pollable{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/udp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]outgoing-datagram-stream.subscribe"]
                        fn wit_import(_: i32, ) -> i32;
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, ) -> i32{ unreachable!() }
                      let ret = wit_import((self).handle() as i32);
                      super::super::super::wasi::io::poll::Pollable::from_handle(ret as u32)
                    }
                  }
                }
                
              }
              
              
              #[allow(clippy::all)]
              pub mod udp_create_socket {
                #[used]
                #[doc(hidden)]
                #[cfg(target_arch = "wasm32")]
                static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
                pub type ErrorCode = super::super::super::wasi::sockets::network::ErrorCode;
                pub type IpAddressFamily = super::super::super::wasi::sockets::network::IpAddressFamily;
                pub type UdpSocket = super::super::super::wasi::sockets::udp::UdpSocket;
                #[allow(unused_unsafe, clippy::all)]
                /// Create a new UDP socket.
                /// 
                /// Similar to `socket(AF_INET or AF_INET6, SOCK_DGRAM, IPPROTO_UDP)` in POSIX.
                /// On IPv6 sockets, IPV6_V6ONLY is enabled by default and can't be configured otherwise.
                /// 
                /// This function does not require a network capability handle. This is considered to be safe because
                /// at time of creation, the socket is not bound to any `network` yet. Up to the moment `bind` is called,
                /// the socket is effectively an in-memory configuration object, unable to communicate with the outside world.
                /// 
                /// All sockets are non-blocking. Use the wasi-poll interface to block on asynchronous operations.
                /// 
                /// # Typical errors
                /// - `not-supported`:     The specified `address-family` is not supported. (EAFNOSUPPORT)
                /// - `new-socket-limit`:  The new socket resource could not be created because of a system limit. (EMFILE, ENFILE)
                /// 
                /// # References:
                /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/socket.html>
                /// - <https://man7.org/linux/man-pages/man2/socket.2.html>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-wsasocketw>
                /// - <https://man.freebsd.org/cgi/man.cgi?query=socket&sektion=2>
                pub fn create_udp_socket(address_family: IpAddressFamily,) -> Result<UdpSocket,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(4))]
                    struct RetArea([u8; 8]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/udp-create-socket@0.2.0")]
                    extern "C" {
                      #[link_name = "create-udp-socket"]
                      fn wit_import(_: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, ){ unreachable!() }
                    wit_import(address_family.clone() as i32, ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = {
                          let l2 = *((ptr0 + 4) as *const i32);
                          
                          super::super::super::wasi::sockets::udp::UdpSocket::from_handle(l2 as u32)
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l3 = i32::from(*((ptr0 + 4) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
                
              }
              
              
              #[allow(clippy::all)]
              pub mod tcp {
                #[used]
                #[doc(hidden)]
                #[cfg(target_arch = "wasm32")]
                static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
                pub type InputStream = super::super::super::wasi::io::streams::InputStream;
                pub type OutputStream = super::super::super::wasi::io::streams::OutputStream;
                pub type Pollable = super::super::super::wasi::io::poll::Pollable;
                pub type Duration = super::super::super::wasi::clocks::monotonic_clock::Duration;
                pub type Network = super::super::super::wasi::sockets::network::Network;
                pub type ErrorCode = super::super::super::wasi::sockets::network::ErrorCode;
                pub type IpSocketAddress = super::super::super::wasi::sockets::network::IpSocketAddress;
                pub type IpAddressFamily = super::super::super::wasi::sockets::network::IpAddressFamily;
                #[repr(u8)]
                #[derive(Clone, Copy, Eq, PartialEq)]
                pub enum ShutdownType {
                  /// Similar to `SHUT_RD` in POSIX.
                  Receive,
                  /// Similar to `SHUT_WR` in POSIX.
                  Send,
                  /// Similar to `SHUT_RDWR` in POSIX.
                  Both,
                }
                impl ::core::fmt::Debug for ShutdownType {
                  fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
                    match self {
                      ShutdownType::Receive => {
                        f.debug_tuple("ShutdownType::Receive").finish()
                      }
                      ShutdownType::Send => {
                        f.debug_tuple("ShutdownType::Send").finish()
                      }
                      ShutdownType::Both => {
                        f.debug_tuple("ShutdownType::Both").finish()
                      }
                    }
                  }
                }
                
                impl ShutdownType{
                  pub(crate) unsafe fn _lift(val: u8) -> ShutdownType{
                    if !cfg!(debug_assertions) {
                      return ::core::mem::transmute(val);
                    }
                    
                    match val {
                      0 => ShutdownType::Receive,
                      1 => ShutdownType::Send,
                      2 => ShutdownType::Both,
                      
                      _ => panic!("invalid enum discriminant"),
                    }
                  }
                }
                
                /// A TCP socket resource.
                /// 
                /// The socket can be in one of the following states:
                /// - `unbound`
                /// - `bind-in-progress`
                /// - `bound` (See note below)
                /// - `listen-in-progress`
                /// - `listening`
                /// - `connect-in-progress`
                /// - `connected`
                /// - `closed`
                /// See <https://github.com/WebAssembly/wasi-sockets/TcpSocketOperationalSemantics.md>
                /// for a more information.
                /// 
                /// Note: Except where explicitly mentioned, whenever this documentation uses
                /// the term "bound" without backticks it actually means: in the `bound` state *or higher*.
                /// (i.e. `bound`, `listen-in-progress`, `listening`, `connect-in-progress` or `connected`)
                /// 
                /// In addition to the general error codes documented on the
                /// `network::error-code` type, TCP socket methods may always return
                /// `error(invalid-state)` when in the `closed` state.
                
                #[derive(Debug)]
                #[repr(transparent)]
                pub struct TcpSocket{
                  handle: wit_bindgen::rt::Resource<TcpSocket>,
                }
                
                impl TcpSocket{
                  #[doc(hidden)]
                  pub unsafe fn from_handle(handle: u32) -> Self {
                    Self {
                      handle: wit_bindgen::rt::Resource::from_handle(handle),
                    }
                  }
                  
                  #[doc(hidden)]
                  pub fn into_handle(self) -> u32 {
                    wit_bindgen::rt::Resource::into_handle(self.handle)
                  }
                  
                  #[doc(hidden)]
                  pub fn handle(&self) -> u32 {
                    wit_bindgen::rt::Resource::handle(&self.handle)
                  }
                }
                
                
                unsafe impl wit_bindgen::rt::WasmResource for TcpSocket{
                  #[inline]
                  unsafe fn drop(_handle: u32) {
                    #[cfg(not(target_arch = "wasm32"))]
                    unreachable!();
                    
                    #[cfg(target_arch = "wasm32")]
                    {
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[resource-drop]tcp-socket"]
                        fn drop(_: u32);
                      }
                      
                      drop(_handle);
                    }
                  }
                }
                
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Bind the socket to a specific network on the provided IP address and port.
                  /// 
                  /// If the IP address is zero (`0.0.0.0` in IPv4, `::` in IPv6), it is left to the implementation to decide which
                  /// network interface(s) to bind to.
                  /// If the TCP/UDP port is zero, the socket will be bound to a random free port.
                  /// 
                  /// Bind can be attempted multiple times on the same socket, even with
                  /// different arguments on each iteration. But never concurrently and
                  /// only as long as the previous bind failed. Once a bind succeeds, the
                  /// binding can't be changed anymore.
                  /// 
                  /// # Typical errors
                  /// - `invalid-argument`:          The `local-address` has the wrong address family. (EAFNOSUPPORT, EFAULT on Windows)
                  /// - `invalid-argument`:          `local-address` is not a unicast address. (EINVAL)
                  /// - `invalid-argument`:          `local-address` is an IPv4-mapped IPv6 address. (EINVAL)
                  /// - `invalid-state`:             The socket is already bound. (EINVAL)
                  /// - `address-in-use`:            No ephemeral ports available. (EADDRINUSE, ENOBUFS on Windows)
                  /// - `address-in-use`:            Address is already in use. (EADDRINUSE)
                  /// - `address-not-bindable`:      `local-address` is not an address that the `network` can bind to. (EADDRNOTAVAIL)
                  /// - `not-in-progress`:           A `bind` operation is not in progress.
                  /// - `would-block`:               Can't finish the operation, it is still in progress. (EWOULDBLOCK, EAGAIN)
                  /// 
                  /// # Implementors note
                  /// When binding to a non-zero port, this bind operation shouldn't be affected by the TIME_WAIT
                  /// state of a recently closed socket on the same local address. In practice this means that the SO_REUSEADDR
                  /// socket option should be set implicitly on all platforms, except on Windows where this is the default behavior
                  /// and SO_REUSEADDR performs something different entirely.
                  /// 
                  /// Unlike in POSIX, in WASI the bind operation is async. This enables
                  /// interactive WASI hosts to inject permission prompts. Runtimes that
                  /// don't want to make use of this ability can simply call the native
                  /// `bind` as part of either `start-bind` or `finish-bind`.
                  /// 
                  /// # References
                  /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/bind.html>
                  /// - <https://man7.org/linux/man-pages/man2/bind.2.html>
                  /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-bind>
                  /// - <https://man.freebsd.org/cgi/man.cgi?query=bind&sektion=2&format=html>
                  pub fn start_bind(&self,network: &Network,local_address: IpSocketAddress,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      use super::super::super::wasi::sockets::network::IpSocketAddress as V4;
                      let (result5_0,result5_1,result5_2,result5_3,result5_4,result5_5,result5_6,result5_7,result5_8,result5_9,result5_10,result5_11,) = match local_address {
                        V4::Ipv4(e) => {
                          let super::super::super::wasi::sockets::network::Ipv4SocketAddress{ port:port0, address:address0, } = e;
                          let (t1_0, t1_1, t1_2, t1_3, ) = address0;
                          
                          (0i32, wit_bindgen::rt::as_i32(port0), wit_bindgen::rt::as_i32(t1_0), wit_bindgen::rt::as_i32(t1_1), wit_bindgen::rt::as_i32(t1_2), wit_bindgen::rt::as_i32(t1_3), 0i32, 0i32, 0i32, 0i32, 0i32, 0i32)
                        },
                        V4::Ipv6(e) => {
                          let super::super::super::wasi::sockets::network::Ipv6SocketAddress{ port:port2, flow_info:flow_info2, address:address2, scope_id:scope_id2, } = e;
                          let (t3_0, t3_1, t3_2, t3_3, t3_4, t3_5, t3_6, t3_7, ) = address2;
                          
                          (1i32, wit_bindgen::rt::as_i32(port2), wit_bindgen::rt::as_i32(flow_info2), wit_bindgen::rt::as_i32(t3_0), wit_bindgen::rt::as_i32(t3_1), wit_bindgen::rt::as_i32(t3_2), wit_bindgen::rt::as_i32(t3_3), wit_bindgen::rt::as_i32(t3_4), wit_bindgen::rt::as_i32(t3_5), wit_bindgen::rt::as_i32(t3_6), wit_bindgen::rt::as_i32(t3_7), wit_bindgen::rt::as_i32(scope_id2))
                        },
                      };
                      let ptr6 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.start-bind"]
                        fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, (network).handle() as i32, result5_0, result5_1, result5_2, result5_3, result5_4, result5_5, result5_6, result5_7, result5_8, result5_9, result5_10, result5_11, ptr6);
                      let l7 = i32::from(*((ptr6 + 0) as *const u8));
                      match l7 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l8 = i32::from(*((ptr6 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l8 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn finish_bind(&self,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.finish-bind"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Connect to a remote endpoint.
                  /// 
                  /// On success:
                  /// - the socket is transitioned into the `connection` state.
                  /// - a pair of streams is returned that can be used to read & write to the connection
                  /// 
                  /// After a failed connection attempt, the socket will be in the `closed`
                  /// state and the only valid action left is to `drop` the socket. A single
                  /// socket can not be used to connect more than once.
                  /// 
                  /// # Typical errors
                  /// - `invalid-argument`:          The `remote-address` has the wrong address family. (EAFNOSUPPORT)
                  /// - `invalid-argument`:          `remote-address` is not a unicast address. (EINVAL, ENETUNREACH on Linux, EAFNOSUPPORT on MacOS)
                  /// - `invalid-argument`:          `remote-address` is an IPv4-mapped IPv6 address. (EINVAL, EADDRNOTAVAIL on Illumos)
                  /// - `invalid-argument`:          The IP address in `remote-address` is set to INADDR_ANY (`0.0.0.0` / `::`). (EADDRNOTAVAIL on Windows)
                  /// - `invalid-argument`:          The port in `remote-address` is set to 0. (EADDRNOTAVAIL on Windows)
                  /// - `invalid-argument`:          The socket is already attached to a different network. The `network` passed to `connect` must be identical to the one passed to `bind`.
                  /// - `invalid-state`:             The socket is already in the `connected` state. (EISCONN)
                  /// - `invalid-state`:             The socket is already in the `listening` state. (EOPNOTSUPP, EINVAL on Windows)
                  /// - `timeout`:                   Connection timed out. (ETIMEDOUT)
                  /// - `connection-refused`:        The connection was forcefully rejected. (ECONNREFUSED)
                  /// - `connection-reset`:          The connection was reset. (ECONNRESET)
                  /// - `connection-aborted`:        The connection was aborted. (ECONNABORTED)
                  /// - `remote-unreachable`:        The remote address is not reachable. (EHOSTUNREACH, EHOSTDOWN, ENETUNREACH, ENETDOWN, ENONET)
                  /// - `address-in-use`:            Tried to perform an implicit bind, but there were no ephemeral ports available. (EADDRINUSE, EADDRNOTAVAIL on Linux, EAGAIN on BSD)
                  /// - `not-in-progress`:           A connect operation is not in progress.
                  /// - `would-block`:               Can't finish the operation, it is still in progress. (EWOULDBLOCK, EAGAIN)
                  /// 
                  /// # Implementors note
                  /// The POSIX equivalent of `start-connect` is the regular `connect` syscall.
                  /// Because all WASI sockets are non-blocking this is expected to return
                  /// EINPROGRESS, which should be translated to `ok()` in WASI.
                  /// 
                  /// The POSIX equivalent of `finish-connect` is a `poll` for event `POLLOUT`
                  /// with a timeout of 0 on the socket descriptor. Followed by a check for
                  /// the `SO_ERROR` socket option, in case the poll signaled readiness.
                  /// 
                  /// # References
                  /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/connect.html>
                  /// - <https://man7.org/linux/man-pages/man2/connect.2.html>
                  /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-connect>
                  /// - <https://man.freebsd.org/cgi/man.cgi?connect>
                  pub fn start_connect(&self,network: &Network,remote_address: IpSocketAddress,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      use super::super::super::wasi::sockets::network::IpSocketAddress as V4;
                      let (result5_0,result5_1,result5_2,result5_3,result5_4,result5_5,result5_6,result5_7,result5_8,result5_9,result5_10,result5_11,) = match remote_address {
                        V4::Ipv4(e) => {
                          let super::super::super::wasi::sockets::network::Ipv4SocketAddress{ port:port0, address:address0, } = e;
                          let (t1_0, t1_1, t1_2, t1_3, ) = address0;
                          
                          (0i32, wit_bindgen::rt::as_i32(port0), wit_bindgen::rt::as_i32(t1_0), wit_bindgen::rt::as_i32(t1_1), wit_bindgen::rt::as_i32(t1_2), wit_bindgen::rt::as_i32(t1_3), 0i32, 0i32, 0i32, 0i32, 0i32, 0i32)
                        },
                        V4::Ipv6(e) => {
                          let super::super::super::wasi::sockets::network::Ipv6SocketAddress{ port:port2, flow_info:flow_info2, address:address2, scope_id:scope_id2, } = e;
                          let (t3_0, t3_1, t3_2, t3_3, t3_4, t3_5, t3_6, t3_7, ) = address2;
                          
                          (1i32, wit_bindgen::rt::as_i32(port2), wit_bindgen::rt::as_i32(flow_info2), wit_bindgen::rt::as_i32(t3_0), wit_bindgen::rt::as_i32(t3_1), wit_bindgen::rt::as_i32(t3_2), wit_bindgen::rt::as_i32(t3_3), wit_bindgen::rt::as_i32(t3_4), wit_bindgen::rt::as_i32(t3_5), wit_bindgen::rt::as_i32(t3_6), wit_bindgen::rt::as_i32(t3_7), wit_bindgen::rt::as_i32(scope_id2))
                        },
                      };
                      let ptr6 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.start-connect"]
                        fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, (network).handle() as i32, result5_0, result5_1, result5_2, result5_3, result5_4, result5_5, result5_6, result5_7, result5_8, result5_9, result5_10, result5_11, ptr6);
                      let l7 = i32::from(*((ptr6 + 0) as *const u8));
                      match l7 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l8 = i32::from(*((ptr6 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l8 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn finish_connect(&self,) -> Result<(InputStream,OutputStream,),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(4))]
                      struct RetArea([u8; 12]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.finish-connect"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = *((ptr0 + 4) as *const i32);
                            let l3 = *((ptr0 + 8) as *const i32);
                            
                            (super::super::super::wasi::io::streams::InputStream::from_handle(l2 as u32), super::super::super::wasi::io::streams::OutputStream::from_handle(l3 as u32))
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l4 = i32::from(*((ptr0 + 4) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l4 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Start listening for new connections.
                  /// 
                  /// Transitions the socket into the `listening` state.
                  /// 
                  /// Unlike POSIX, the socket must already be explicitly bound.
                  /// 
                  /// # Typical errors
                  /// - `invalid-state`:             The socket is not bound to any local address. (EDESTADDRREQ)
                  /// - `invalid-state`:             The socket is already in the `connected` state. (EISCONN, EINVAL on BSD)
                  /// - `invalid-state`:             The socket is already in the `listening` state.
                  /// - `address-in-use`:            Tried to perform an implicit bind, but there were no ephemeral ports available. (EADDRINUSE)
                  /// - `not-in-progress`:           A listen operation is not in progress.
                  /// - `would-block`:               Can't finish the operation, it is still in progress. (EWOULDBLOCK, EAGAIN)
                  /// 
                  /// # Implementors note
                  /// Unlike in POSIX, in WASI the listen operation is async. This enables
                  /// interactive WASI hosts to inject permission prompts. Runtimes that
                  /// don't want to make use of this ability can simply call the native
                  /// `listen` as part of either `start-listen` or `finish-listen`.
                  /// 
                  /// # References
                  /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/listen.html>
                  /// - <https://man7.org/linux/man-pages/man2/listen.2.html>
                  /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-listen>
                  /// - <https://man.freebsd.org/cgi/man.cgi?query=listen&sektion=2>
                  pub fn start_listen(&self,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.start-listen"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn finish_listen(&self,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.finish-listen"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Accept a new client socket.
                  /// 
                  /// The returned socket is bound and in the `connected` state. The following properties are inherited from the listener socket:
                  /// - `address-family`
                  /// - `keep-alive-enabled`
                  /// - `keep-alive-idle-time`
                  /// - `keep-alive-interval`
                  /// - `keep-alive-count`
                  /// - `hop-limit`
                  /// - `receive-buffer-size`
                  /// - `send-buffer-size`
                  /// 
                  /// On success, this function returns the newly accepted client socket along with
                  /// a pair of streams that can be used to read & write to the connection.
                  /// 
                  /// # Typical errors
                  /// - `invalid-state`:      Socket is not in the `listening` state. (EINVAL)
                  /// - `would-block`:        No pending connections at the moment. (EWOULDBLOCK, EAGAIN)
                  /// - `connection-aborted`: An incoming connection was pending, but was terminated by the client before this listener could accept it. (ECONNABORTED)
                  /// - `new-socket-limit`:   The new socket resource could not be created because of a system limit. (EMFILE, ENFILE)
                  /// 
                  /// # References
                  /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/accept.html>
                  /// - <https://man7.org/linux/man-pages/man2/accept.2.html>
                  /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-accept>
                  /// - <https://man.freebsd.org/cgi/man.cgi?query=accept&sektion=2>
                  pub fn accept(&self,) -> Result<(TcpSocket,InputStream,OutputStream,),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(4))]
                      struct RetArea([u8; 16]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.accept"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = *((ptr0 + 4) as *const i32);
                            let l3 = *((ptr0 + 8) as *const i32);
                            let l4 = *((ptr0 + 12) as *const i32);
                            
                            (TcpSocket::from_handle(l2 as u32), super::super::super::wasi::io::streams::InputStream::from_handle(l3 as u32), super::super::super::wasi::io::streams::OutputStream::from_handle(l4 as u32))
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l5 = i32::from(*((ptr0 + 4) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l5 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Get the bound local address.
                  /// 
                  /// POSIX mentions:
                  /// > If the socket has not been bound to a local name, the value
                  /// > stored in the object pointed to by `address` is unspecified.
                  /// 
                  /// WASI is stricter and requires `local-address` to return `invalid-state` when the socket hasn't been bound yet.
                  /// 
                  /// # Typical errors
                  /// - `invalid-state`: The socket is not bound to any local address.
                  /// 
                  /// # References
                  /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/getsockname.html>
                  /// - <https://man7.org/linux/man-pages/man2/getsockname.2.html>
                  /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-getsockname>
                  /// - <https://man.freebsd.org/cgi/man.cgi?getsockname>
                  pub fn local_address(&self,) -> Result<IpSocketAddress,ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(4))]
                      struct RetArea([u8; 36]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.local-address"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 4) as *const u8));
                            use super::super::super::wasi::sockets::network::IpSocketAddress as V19;
                            let v19 = match l2 {
                              0 => {
                                let e19 = {
                                  let l3 = i32::from(*((ptr0 + 8) as *const u16));
                                  let l4 = i32::from(*((ptr0 + 10) as *const u8));
                                  let l5 = i32::from(*((ptr0 + 11) as *const u8));
                                  let l6 = i32::from(*((ptr0 + 12) as *const u8));
                                  let l7 = i32::from(*((ptr0 + 13) as *const u8));
                                  
                                  super::super::super::wasi::sockets::network::Ipv4SocketAddress{
                                    port: l3 as u16,
                                    address: (l4 as u8, l5 as u8, l6 as u8, l7 as u8),
                                  }
                                };
                                V19::Ipv4(e19)
                              }
                              n => {
                                debug_assert_eq!(n, 1, "invalid enum discriminant");
                                let e19 = {
                                  let l8 = i32::from(*((ptr0 + 8) as *const u16));
                                  let l9 = *((ptr0 + 12) as *const i32);
                                  let l10 = i32::from(*((ptr0 + 16) as *const u16));
                                  let l11 = i32::from(*((ptr0 + 18) as *const u16));
                                  let l12 = i32::from(*((ptr0 + 20) as *const u16));
                                  let l13 = i32::from(*((ptr0 + 22) as *const u16));
                                  let l14 = i32::from(*((ptr0 + 24) as *const u16));
                                  let l15 = i32::from(*((ptr0 + 26) as *const u16));
                                  let l16 = i32::from(*((ptr0 + 28) as *const u16));
                                  let l17 = i32::from(*((ptr0 + 30) as *const u16));
                                  let l18 = *((ptr0 + 32) as *const i32);
                                  
                                  super::super::super::wasi::sockets::network::Ipv6SocketAddress{
                                    port: l8 as u16,
                                    flow_info: l9 as u32,
                                    address: (l10 as u16, l11 as u16, l12 as u16, l13 as u16, l14 as u16, l15 as u16, l16 as u16, l17 as u16),
                                    scope_id: l18 as u32,
                                  }
                                };
                                V19::Ipv6(e19)
                              }
                            };
                            
                            v19
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l20 = i32::from(*((ptr0 + 4) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l20 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Get the remote address.
                  /// 
                  /// # Typical errors
                  /// - `invalid-state`: The socket is not connected to a remote address. (ENOTCONN)
                  /// 
                  /// # References
                  /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/getpeername.html>
                  /// - <https://man7.org/linux/man-pages/man2/getpeername.2.html>
                  /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-getpeername>
                  /// - <https://man.freebsd.org/cgi/man.cgi?query=getpeername&sektion=2&n=1>
                  pub fn remote_address(&self,) -> Result<IpSocketAddress,ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(4))]
                      struct RetArea([u8; 36]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.remote-address"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 4) as *const u8));
                            use super::super::super::wasi::sockets::network::IpSocketAddress as V19;
                            let v19 = match l2 {
                              0 => {
                                let e19 = {
                                  let l3 = i32::from(*((ptr0 + 8) as *const u16));
                                  let l4 = i32::from(*((ptr0 + 10) as *const u8));
                                  let l5 = i32::from(*((ptr0 + 11) as *const u8));
                                  let l6 = i32::from(*((ptr0 + 12) as *const u8));
                                  let l7 = i32::from(*((ptr0 + 13) as *const u8));
                                  
                                  super::super::super::wasi::sockets::network::Ipv4SocketAddress{
                                    port: l3 as u16,
                                    address: (l4 as u8, l5 as u8, l6 as u8, l7 as u8),
                                  }
                                };
                                V19::Ipv4(e19)
                              }
                              n => {
                                debug_assert_eq!(n, 1, "invalid enum discriminant");
                                let e19 = {
                                  let l8 = i32::from(*((ptr0 + 8) as *const u16));
                                  let l9 = *((ptr0 + 12) as *const i32);
                                  let l10 = i32::from(*((ptr0 + 16) as *const u16));
                                  let l11 = i32::from(*((ptr0 + 18) as *const u16));
                                  let l12 = i32::from(*((ptr0 + 20) as *const u16));
                                  let l13 = i32::from(*((ptr0 + 22) as *const u16));
                                  let l14 = i32::from(*((ptr0 + 24) as *const u16));
                                  let l15 = i32::from(*((ptr0 + 26) as *const u16));
                                  let l16 = i32::from(*((ptr0 + 28) as *const u16));
                                  let l17 = i32::from(*((ptr0 + 30) as *const u16));
                                  let l18 = *((ptr0 + 32) as *const i32);
                                  
                                  super::super::super::wasi::sockets::network::Ipv6SocketAddress{
                                    port: l8 as u16,
                                    flow_info: l9 as u32,
                                    address: (l10 as u16, l11 as u16, l12 as u16, l13 as u16, l14 as u16, l15 as u16, l16 as u16, l17 as u16),
                                    scope_id: l18 as u32,
                                  }
                                };
                                V19::Ipv6(e19)
                              }
                            };
                            
                            v19
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l20 = i32::from(*((ptr0 + 4) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l20 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Whether the socket is in the `listening` state.
                  /// 
                  /// Equivalent to the SO_ACCEPTCONN socket option.
                  pub fn is_listening(&self,) -> bool{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.is-listening"]
                        fn wit_import(_: i32, ) -> i32;
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, ) -> i32{ unreachable!() }
                      let ret = wit_import((self).handle() as i32);
                      wit_bindgen::rt::bool_lift(ret as u8)
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Whether this is a IPv4 or IPv6 socket.
                  /// 
                  /// Equivalent to the SO_DOMAIN socket option.
                  pub fn address_family(&self,) -> IpAddressFamily{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.address-family"]
                        fn wit_import(_: i32, ) -> i32;
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, ) -> i32{ unreachable!() }
                      let ret = wit_import((self).handle() as i32);
                      super::super::super::wasi::sockets::network::IpAddressFamily::_lift(ret as u8)
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Hints the desired listen queue size. Implementations are free to ignore this.
                  /// 
                  /// If the provided value is 0, an `invalid-argument` error is returned.
                  /// Any other value will never cause an error, but it might be silently clamped and/or rounded.
                  /// 
                  /// # Typical errors
                  /// - `not-supported`:        (set) The platform does not support changing the backlog size after the initial listen.
                  /// - `invalid-argument`:     (set) The provided value was 0.
                  /// - `invalid-state`:        (set) The socket is in the `connect-in-progress` or `connected` state.
                  pub fn set_listen_backlog_size(&self,value: u64,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.set-listen-backlog-size"]
                        fn wit_import(_: i32, _: i64, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(value), ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Enables or disables keepalive.
                  /// 
                  /// The keepalive behavior can be adjusted using:
                  /// - `keep-alive-idle-time`
                  /// - `keep-alive-interval`
                  /// - `keep-alive-count`
                  /// These properties can be configured while `keep-alive-enabled` is false, but only come into effect when `keep-alive-enabled` is true.
                  /// 
                  /// Equivalent to the SO_KEEPALIVE socket option.
                  pub fn keep_alive_enabled(&self,) -> Result<bool,ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.keep-alive-enabled"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            wit_bindgen::rt::bool_lift(l2 as u8)
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l3 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn set_keep_alive_enabled(&self,value: bool,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.set-keep-alive-enabled"]
                        fn wit_import(_: i32, _: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, match value { true => 1, false => 0 }, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Amount of time the connection has to be idle before TCP starts sending keepalive packets.
                  /// 
                  /// If the provided value is 0, an `invalid-argument` error is returned.
                  /// Any other value will never cause an error, but it might be silently clamped and/or rounded.
                  /// I.e. after setting a value, reading the same setting back may return a different value.
                  /// 
                  /// Equivalent to the TCP_KEEPIDLE socket option. (TCP_KEEPALIVE on MacOS)
                  /// 
                  /// # Typical errors
                  /// - `invalid-argument`:     (set) The provided value was 0.
                  pub fn keep_alive_idle_time(&self,) -> Result<Duration,ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(8))]
                      struct RetArea([u8; 16]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.keep-alive-idle-time"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = *((ptr0 + 8) as *const i64);
                            
                            l2 as u64
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l3 = i32::from(*((ptr0 + 8) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn set_keep_alive_idle_time(&self,value: Duration,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.set-keep-alive-idle-time"]
                        fn wit_import(_: i32, _: i64, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(value), ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// The time between keepalive packets.
                  /// 
                  /// If the provided value is 0, an `invalid-argument` error is returned.
                  /// Any other value will never cause an error, but it might be silently clamped and/or rounded.
                  /// I.e. after setting a value, reading the same setting back may return a different value.
                  /// 
                  /// Equivalent to the TCP_KEEPINTVL socket option.
                  /// 
                  /// # Typical errors
                  /// - `invalid-argument`:     (set) The provided value was 0.
                  pub fn keep_alive_interval(&self,) -> Result<Duration,ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(8))]
                      struct RetArea([u8; 16]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.keep-alive-interval"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = *((ptr0 + 8) as *const i64);
                            
                            l2 as u64
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l3 = i32::from(*((ptr0 + 8) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn set_keep_alive_interval(&self,value: Duration,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.set-keep-alive-interval"]
                        fn wit_import(_: i32, _: i64, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(value), ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// The maximum amount of keepalive packets TCP should send before aborting the connection.
                  /// 
                  /// If the provided value is 0, an `invalid-argument` error is returned.
                  /// Any other value will never cause an error, but it might be silently clamped and/or rounded.
                  /// I.e. after setting a value, reading the same setting back may return a different value.
                  /// 
                  /// Equivalent to the TCP_KEEPCNT socket option.
                  /// 
                  /// # Typical errors
                  /// - `invalid-argument`:     (set) The provided value was 0.
                  pub fn keep_alive_count(&self,) -> Result<u32,ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(4))]
                      struct RetArea([u8; 8]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.keep-alive-count"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = *((ptr0 + 4) as *const i32);
                            
                            l2 as u32
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l3 = i32::from(*((ptr0 + 4) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn set_keep_alive_count(&self,value: u32,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.set-keep-alive-count"]
                        fn wit_import(_: i32, _: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, wit_bindgen::rt::as_i32(value), ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Equivalent to the IP_TTL & IPV6_UNICAST_HOPS socket options.
                  /// 
                  /// If the provided value is 0, an `invalid-argument` error is returned.
                  /// 
                  /// # Typical errors
                  /// - `invalid-argument`:     (set) The TTL value must be 1 or higher.
                  pub fn hop_limit(&self,) -> Result<u8,ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.hop-limit"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            l2 as u8
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l3 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn set_hop_limit(&self,value: u8,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.set-hop-limit"]
                        fn wit_import(_: i32, _: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, wit_bindgen::rt::as_i32(value), ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// The kernel buffer space reserved for sends/receives on this socket.
                  /// 
                  /// If the provided value is 0, an `invalid-argument` error is returned.
                  /// Any other value will never cause an error, but it might be silently clamped and/or rounded.
                  /// I.e. after setting a value, reading the same setting back may return a different value.
                  /// 
                  /// Equivalent to the SO_RCVBUF and SO_SNDBUF socket options.
                  /// 
                  /// # Typical errors
                  /// - `invalid-argument`:     (set) The provided value was 0.
                  pub fn receive_buffer_size(&self,) -> Result<u64,ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(8))]
                      struct RetArea([u8; 16]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.receive-buffer-size"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = *((ptr0 + 8) as *const i64);
                            
                            l2 as u64
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l3 = i32::from(*((ptr0 + 8) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn set_receive_buffer_size(&self,value: u64,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.set-receive-buffer-size"]
                        fn wit_import(_: i32, _: i64, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(value), ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn send_buffer_size(&self,) -> Result<u64,ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(8))]
                      struct RetArea([u8; 16]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.send-buffer-size"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = *((ptr0 + 8) as *const i64);
                            
                            l2 as u64
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l3 = i32::from(*((ptr0 + 8) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  pub fn set_send_buffer_size(&self,value: u64,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.set-send-buffer-size"]
                        fn wit_import(_: i32, _: i64, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i64, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, wit_bindgen::rt::as_i64(value), ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Create a `pollable` which can be used to poll for, or block on,
                  /// completion of any of the asynchronous operations of this socket.
                  /// 
                  /// When `finish-bind`, `finish-listen`, `finish-connect` or `accept`
                  /// return `error(would-block)`, this pollable can be used to wait for
                  /// their success or failure, after which the method can be retried.
                  /// 
                  /// The pollable is not limited to the async operation that happens to be
                  /// in progress at the time of calling `subscribe` (if any). Theoretically,
                  /// `subscribe` only has to be called once per socket and can then be
                  /// (re)used for the remainder of the socket's lifetime.
                  /// 
                  /// See <https://github.com/WebAssembly/wasi-sockets/TcpSocketOperationalSemantics.md#Pollable-readiness>
                  /// for a more information.
                  /// 
                  /// Note: this function is here for WASI Preview2 only.
                  /// It's planned to be removed when `future` is natively supported in Preview3.
                  pub fn subscribe(&self,) -> Pollable{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.subscribe"]
                        fn wit_import(_: i32, ) -> i32;
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, ) -> i32{ unreachable!() }
                      let ret = wit_import((self).handle() as i32);
                      super::super::super::wasi::io::poll::Pollable::from_handle(ret as u32)
                    }
                  }
                }
                impl TcpSocket {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Initiate a graceful shutdown.
                  /// 
                  /// - `receive`: The socket is not expecting to receive any data from
                  /// the peer. The `input-stream` associated with this socket will be
                  /// closed. Any data still in the receive queue at time of calling
                  /// this method will be discarded.
                  /// - `send`: The socket has no more data to send to the peer. The `output-stream`
                  /// associated with this socket will be closed and a FIN packet will be sent.
                  /// - `both`: Same effect as `receive` & `send` combined.
                  /// 
                  /// This function is idempotent. Shutting a down a direction more than once
                  /// has no effect and returns `ok`.
                  /// 
                  /// The shutdown function does not close (drop) the socket.
                  /// 
                  /// # Typical errors
                  /// - `invalid-state`: The socket is not in the `connected` state. (ENOTCONN)
                  /// 
                  /// # References
                  /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/shutdown.html>
                  /// - <https://man7.org/linux/man-pages/man2/shutdown.2.html>
                  /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-shutdown>
                  /// - <https://man.freebsd.org/cgi/man.cgi?query=shutdown&sektion=2>
                  pub fn shutdown(&self,shutdown_type: ShutdownType,) -> Result<(),ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(1))]
                      struct RetArea([u8; 2]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/tcp@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]tcp-socket.shutdown"]
                        fn wit_import(_: i32, _: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, shutdown_type.clone() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = ();
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 1) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l2 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                
              }
              
              
              #[allow(clippy::all)]
              pub mod tcp_create_socket {
                #[used]
                #[doc(hidden)]
                #[cfg(target_arch = "wasm32")]
                static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
                pub type ErrorCode = super::super::super::wasi::sockets::network::ErrorCode;
                pub type IpAddressFamily = super::super::super::wasi::sockets::network::IpAddressFamily;
                pub type TcpSocket = super::super::super::wasi::sockets::tcp::TcpSocket;
                #[allow(unused_unsafe, clippy::all)]
                /// Create a new TCP socket.
                /// 
                /// Similar to `socket(AF_INET or AF_INET6, SOCK_STREAM, IPPROTO_TCP)` in POSIX.
                /// On IPv6 sockets, IPV6_V6ONLY is enabled by default and can't be configured otherwise.
                /// 
                /// This function does not require a network capability handle. This is considered to be safe because
                /// at time of creation, the socket is not bound to any `network` yet. Up to the moment `bind`/`connect`
                /// is called, the socket is effectively an in-memory configuration object, unable to communicate with the outside world.
                /// 
                /// All sockets are non-blocking. Use the wasi-poll interface to block on asynchronous operations.
                /// 
                /// # Typical errors
                /// - `not-supported`:     The specified `address-family` is not supported. (EAFNOSUPPORT)
                /// - `new-socket-limit`:  The new socket resource could not be created because of a system limit. (EMFILE, ENFILE)
                /// 
                /// # References
                /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/socket.html>
                /// - <https://man7.org/linux/man-pages/man2/socket.2.html>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-wsasocketw>
                /// - <https://man.freebsd.org/cgi/man.cgi?query=socket&sektion=2>
                pub fn create_tcp_socket(address_family: IpAddressFamily,) -> Result<TcpSocket,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(4))]
                    struct RetArea([u8; 8]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let ptr0 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/tcp-create-socket@0.2.0")]
                    extern "C" {
                      #[link_name = "create-tcp-socket"]
                      fn wit_import(_: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, ){ unreachable!() }
                    wit_import(address_family.clone() as i32, ptr0);
                    let l1 = i32::from(*((ptr0 + 0) as *const u8));
                    match l1 {
                      0 => {
                        let e = {
                          let l2 = *((ptr0 + 4) as *const i32);
                          
                          super::super::super::wasi::sockets::tcp::TcpSocket::from_handle(l2 as u32)
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l3 = i32::from(*((ptr0 + 4) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l3 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
                
              }
              
              
              #[allow(clippy::all)]
              pub mod ip_name_lookup {
                #[used]
                #[doc(hidden)]
                #[cfg(target_arch = "wasm32")]
                static __FORCE_SECTION_REF: fn() = super::super::super::__link_section;
                pub type Pollable = super::super::super::wasi::io::poll::Pollable;
                pub type Network = super::super::super::wasi::sockets::network::Network;
                pub type ErrorCode = super::super::super::wasi::sockets::network::ErrorCode;
                pub type IpAddress = super::super::super::wasi::sockets::network::IpAddress;
                
                #[derive(Debug)]
                #[repr(transparent)]
                pub struct ResolveAddressStream{
                  handle: wit_bindgen::rt::Resource<ResolveAddressStream>,
                }
                
                impl ResolveAddressStream{
                  #[doc(hidden)]
                  pub unsafe fn from_handle(handle: u32) -> Self {
                    Self {
                      handle: wit_bindgen::rt::Resource::from_handle(handle),
                    }
                  }
                  
                  #[doc(hidden)]
                  pub fn into_handle(self) -> u32 {
                    wit_bindgen::rt::Resource::into_handle(self.handle)
                  }
                  
                  #[doc(hidden)]
                  pub fn handle(&self) -> u32 {
                    wit_bindgen::rt::Resource::handle(&self.handle)
                  }
                }
                
                
                unsafe impl wit_bindgen::rt::WasmResource for ResolveAddressStream{
                  #[inline]
                  unsafe fn drop(_handle: u32) {
                    #[cfg(not(target_arch = "wasm32"))]
                    unreachable!();
                    
                    #[cfg(target_arch = "wasm32")]
                    {
                      #[link(wasm_import_module = "wasi:sockets/ip-name-lookup@0.2.0")]
                      extern "C" {
                        #[link_name = "[resource-drop]resolve-address-stream"]
                        fn drop(_: u32);
                      }
                      
                      drop(_handle);
                    }
                  }
                }
                
                #[allow(unused_unsafe, clippy::all)]
                /// Resolve an internet host name to a list of IP addresses.
                /// 
                /// Unicode domain names are automatically converted to ASCII using IDNA encoding.
                /// If the input is an IP address string, the address is parsed and returned
                /// as-is without making any external requests.
                /// 
                /// See the wasi-socket proposal README.md for a comparison with getaddrinfo.
                /// 
                /// This function never blocks. It either immediately fails or immediately
                /// returns successfully with a `resolve-address-stream` that can be used
                /// to (asynchronously) fetch the results.
                /// 
                /// # Typical errors
                /// - `invalid-argument`: `name` is a syntactically invalid domain name or IP address.
                /// 
                /// # References:
                /// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/getaddrinfo.html>
                /// - <https://man7.org/linux/man-pages/man3/getaddrinfo.3.html>
                /// - <https://learn.microsoft.com/en-us/windows/win32/api/ws2tcpip/nf-ws2tcpip-getaddrinfo>
                /// - <https://man.freebsd.org/cgi/man.cgi?query=getaddrinfo&sektion=3>
                pub fn resolve_addresses(network: &Network,name: &str,) -> Result<ResolveAddressStream,ErrorCode>{
                  
                  #[allow(unused_imports)]
                  use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                  unsafe {
                    
                    #[repr(align(4))]
                    struct RetArea([u8; 8]);
                    let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                    let vec0 = name;
                    let ptr0 = vec0.as_ptr() as i32;
                    let len0 = vec0.len() as i32;
                    let ptr1 = ret_area.as_mut_ptr() as i32;
                    #[cfg(target_arch = "wasm32")]
                    #[link(wasm_import_module = "wasi:sockets/ip-name-lookup@0.2.0")]
                    extern "C" {
                      #[link_name = "resolve-addresses"]
                      fn wit_import(_: i32, _: i32, _: i32, _: i32, );
                    }
                    
                    #[cfg(not(target_arch = "wasm32"))]
                    fn wit_import(_: i32, _: i32, _: i32, _: i32, ){ unreachable!() }
                    wit_import((network).handle() as i32, ptr0, len0, ptr1);
                    let l2 = i32::from(*((ptr1 + 0) as *const u8));
                    match l2 {
                      0 => {
                        let e = {
                          let l3 = *((ptr1 + 4) as *const i32);
                          
                          ResolveAddressStream::from_handle(l3 as u32)
                        };
                        Ok(e)
                      }
                      1 => {
                        let e = {
                          let l4 = i32::from(*((ptr1 + 4) as *const u8));
                          
                          super::super::super::wasi::sockets::network::ErrorCode::_lift(l4 as u8)
                        };
                        Err(e)
                      }
                      _ => wit_bindgen::rt::invalid_enum_discriminant(),
                    }
                  }
                }
                impl ResolveAddressStream {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Returns the next address from the resolver.
                  /// 
                  /// This function should be called multiple times. On each call, it will
                  /// return the next address in connection order preference. If all
                  /// addresses have been exhausted, this function returns `none`.
                  /// 
                  /// This function never returns IPv4-mapped IPv6 addresses.
                  /// 
                  /// # Typical errors
                  /// - `name-unresolvable`:          Name does not exist or has no suitable associated IP addresses. (EAI_NONAME, EAI_NODATA, EAI_ADDRFAMILY)
                  /// - `temporary-resolver-failure`: A temporary failure in name resolution occurred. (EAI_AGAIN)
                  /// - `permanent-resolver-failure`: A permanent failure in name resolution occurred. (EAI_FAIL)
                  /// - `would-block`:                A result is not available yet. (EWOULDBLOCK, EAGAIN)
                  pub fn resolve_next_address(&self,) -> Result<Option<IpAddress>,ErrorCode>{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[repr(align(2))]
                      struct RetArea([u8; 22]);
                      let mut ret_area = ::core::mem::MaybeUninit::<RetArea>::uninit();
                      let ptr0 = ret_area.as_mut_ptr() as i32;
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/ip-name-lookup@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]resolve-address-stream.resolve-next-address"]
                        fn wit_import(_: i32, _: i32, );
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, _: i32, ){ unreachable!() }
                      wit_import((self).handle() as i32, ptr0);
                      let l1 = i32::from(*((ptr0 + 0) as *const u8));
                      match l1 {
                        0 => {
                          let e = {
                            let l2 = i32::from(*((ptr0 + 2) as *const u8));
                            
                            match l2 {
                              0 => None,
                              1 => {
                                let e = {
                                  let l3 = i32::from(*((ptr0 + 4) as *const u8));
                                  use super::super::super::wasi::sockets::network::IpAddress as V16;
                                  let v16 = match l3 {
                                    0 => {
                                      let e16 = {
                                        let l4 = i32::from(*((ptr0 + 6) as *const u8));
                                        let l5 = i32::from(*((ptr0 + 7) as *const u8));
                                        let l6 = i32::from(*((ptr0 + 8) as *const u8));
                                        let l7 = i32::from(*((ptr0 + 9) as *const u8));
                                        
                                        (l4 as u8, l5 as u8, l6 as u8, l7 as u8)
                                      };
                                      V16::Ipv4(e16)
                                    }
                                    n => {
                                      debug_assert_eq!(n, 1, "invalid enum discriminant");
                                      let e16 = {
                                        let l8 = i32::from(*((ptr0 + 6) as *const u16));
                                        let l9 = i32::from(*((ptr0 + 8) as *const u16));
                                        let l10 = i32::from(*((ptr0 + 10) as *const u16));
                                        let l11 = i32::from(*((ptr0 + 12) as *const u16));
                                        let l12 = i32::from(*((ptr0 + 14) as *const u16));
                                        let l13 = i32::from(*((ptr0 + 16) as *const u16));
                                        let l14 = i32::from(*((ptr0 + 18) as *const u16));
                                        let l15 = i32::from(*((ptr0 + 20) as *const u16));
                                        
                                        (l8 as u16, l9 as u16, l10 as u16, l11 as u16, l12 as u16, l13 as u16, l14 as u16, l15 as u16)
                                      };
                                      V16::Ipv6(e16)
                                    }
                                  };
                                  
                                  v16
                                };
                                Some(e)
                              }
                              _ => wit_bindgen::rt::invalid_enum_discriminant(),
                            }
                          };
                          Ok(e)
                        }
                        1 => {
                          let e = {
                            let l17 = i32::from(*((ptr0 + 2) as *const u8));
                            
                            super::super::super::wasi::sockets::network::ErrorCode::_lift(l17 as u8)
                          };
                          Err(e)
                        }
                        _ => wit_bindgen::rt::invalid_enum_discriminant(),
                      }
                    }
                  }
                }
                impl ResolveAddressStream {
                  #[allow(unused_unsafe, clippy::all)]
                  /// Create a `pollable` which will resolve once the stream is ready for I/O.
                  /// 
                  /// Note: this function is here for WASI Preview2 only.
                  /// It's planned to be removed when `future` is natively supported in Preview3.
                  pub fn subscribe(&self,) -> Pollable{
                    
                    #[allow(unused_imports)]
                    use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                    unsafe {
                      
                      #[cfg(target_arch = "wasm32")]
                      #[link(wasm_import_module = "wasi:sockets/ip-name-lookup@0.2.0")]
                      extern "C" {
                        #[link_name = "[method]resolve-address-stream.subscribe"]
                        fn wit_import(_: i32, ) -> i32;
                      }
                      
                      #[cfg(not(target_arch = "wasm32"))]
                      fn wit_import(_: i32, ) -> i32{ unreachable!() }
                      let ret = wit_import((self).handle() as i32);
                      super::super::super::wasi::io::poll::Pollable::from_handle(ret as u32)
                    }
                  }
                }
                
              }
              
            }
          }
          pub mod exports {
            pub mod wasi {
              pub mod cli {
                
                #[allow(clippy::all)]
                pub mod run {
                  #[used]
                  #[doc(hidden)]
                  #[cfg(target_arch = "wasm32")]
                  static __FORCE_SECTION_REF: fn() = super::super::super::super::__link_section;
                  const _: () = {
                    
                    #[doc(hidden)]
                    #[export_name = "wasi:cli/run@0.2.0#run"]
                    #[allow(non_snake_case)]
                    unsafe extern "C" fn __export_run() -> i32 {
                      #[allow(unused_imports)]
                      use wit_bindgen::rt::{alloc, vec::Vec, string::String};
                      
                      // Before executing any other code, use this function to run all static
                      // constructors, if they have not yet been run. This is a hack required
                      // to work around wasi-libc ctors calling import functions to initialize
                      // the environment.
                      //
                      // This functionality will be removed once rust 1.69.0 is stable, at which
                      // point wasi-libc will no longer have this behavior.
                      //
                      // See
                      // https://github.com/bytecodealliance/preview2-prototyping/issues/99
                      // for more details.
                      #[cfg(target_arch="wasm32")]
                      wit_bindgen::rt::run_ctors_once();
                      
                      let result0 = <_GuestImpl as Guest>::run();
                      let result1 = match result0 {
                        Ok(_) => { 0i32 },
                        Err(_) => { 1i32 },
                      };result1
                    }
                  };
                  use super::super::super::super::super::Component as _GuestImpl;
                  pub trait Guest {
                    /// Run the program.
                    fn run() -> Result<(),()>;
                  }
                  
                }
                
              }
            }
          }
          
          #[cfg(target_arch = "wasm32")]
          #[link_section = "component-type:classify"]
          #[doc(hidden)]
          pub static __WIT_BINDGEN_COMPONENT_TYPE: [u8; 11690] = [3, 0, 8, 99, 108, 97, 115, 115, 105, 102, 121, 0, 97, 115, 109, 13, 0, 1, 0, 7, 170, 90, 1, 65, 2, 1, 65, 85, 1, 66, 10, 1, 111, 2, 115, 115, 1, 112, 0, 1, 64, 0, 0, 1, 4, 0, 15, 103, 101, 116, 45, 101, 110, 118, 105, 114, 111, 110, 109, 101, 110, 116, 1, 2, 1, 112, 115, 1, 64, 0, 0, 3, 4, 0, 13, 103, 101, 116, 45, 97, 114, 103, 117, 109, 101, 110, 116, 115, 1, 4, 1, 107, 115, 1, 64, 0, 0, 5, 4, 0, 11, 105, 110, 105, 116, 105, 97, 108, 45, 99, 119, 100, 1, 6, 3, 1, 26, 119, 97, 115, 105, 58, 99, 108, 105, 47, 101, 110, 118, 105, 114, 111, 110, 109, 101, 110, 116, 64, 48, 46, 50, 46, 48, 5, 0, 1, 66, 3, 1, 106, 0, 0, 1, 64, 1, 6, 115, 116, 97, 116, 117, 115, 0, 1, 0, 4, 0, 4, 101, 120, 105, 116, 1, 1, 3, 1, 19, 119, 97, 115, 105, 58, 99, 108, 105, 47, 101, 120, 105, 116, 64, 48, 46, 50, 46, 48, 5, 1, 1, 66, 4, 4, 0, 5, 101, 114, 114, 111, 114, 3, 1, 1, 104, 0, 1, 64, 1, 4, 115, 101, 108, 102, 1, 0, 115, 4, 0, 29, 91, 109, 101, 116, 104, 111, 100, 93, 101, 114, 114, 111, 114, 46, 116, 111, 45, 100, 101, 98, 117, 103, 45, 115, 116, 114, 105, 110, 103, 1, 2, 3, 1, 19, 119, 97, 115, 105, 58, 105, 111, 47, 101, 114, 114, 111, 114, 64, 48, 46, 50, 46, 48, 5, 2, 1, 66, 10, 4, 0, 8, 112, 111, 108, 108, 97, 98, 108, 101, 3, 1, 1, 104, 0, 1, 64, 1, 4, 115, 101, 108, 102, 1, 0, 127, 4, 0, 22, 91, 109, 101, 116, 104, 111, 100, 93, 112, 111, 108, 108, 97, 98, 108, 101, 46, 114, 101, 97, 100, 121, 1, 2, 1, 64, 1, 4, 115, 101, 108, 102, 1, 1, 0, 4, 0, 22, 91, 109, 101, 116, 104, 111, 100, 93, 112, 111, 108, 108, 97, 98, 108, 101, 46, 98, 108, 111, 99, 107, 1, 3, 1, 112, 1, 1, 112, 121, 1, 64, 1, 2, 105, 110, 4, 0, 5, 4, 0, 4, 112, 111, 108, 108, 1, 6, 3, 1, 18, 119, 97, 115, 105, 58, 105, 111, 47, 112, 111, 108, 108, 64, 48, 46, 50, 46, 48, 5, 3, 2, 3, 0, 2, 5, 101, 114, 114, 111, 114, 2, 3, 0, 3, 8, 112, 111, 108, 108, 97, 98, 108, 101, 1, 66, 40, 2, 3, 2, 1, 4, 4, 0, 5, 101, 114, 114, 111, 114, 3, 0, 0, 2, 3, 2, 1, 5, 4, 0, 8, 112, 111, 108, 108, 97, 98, 108, 101, 3, 0, 2, 1, 105, 1, 1, 113, 2, 21, 108, 97, 115, 116, 45, 111, 112, 101, 114, 97, 116, 105, 111, 110, 45, 102, 97, 105, 108, 101, 100, 1, 4, 0, 6, 99, 108, 111, 115, 101, 100, 0, 0, 4, 0, 12, 115, 116, 114, 101, 97, 109, 45, 101, 114, 114, 111, 114, 3, 0, 5, 4, 0, 12, 105, 110, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 3, 1, 4, 0, 13, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 3, 1, 1, 104, 7, 1, 112, 125, 1, 106, 1, 10, 1, 6, 1, 64, 2, 4, 115, 101, 108, 102, 9, 3, 108, 101, 110, 119, 0, 11, 4, 0, 25, 91, 109, 101, 116, 104, 111, 100, 93, 105, 110, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 114, 101, 97, 100, 1, 12, 4, 0, 34, 91, 109, 101, 116, 104, 111, 100, 93, 105, 110, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 98, 108, 111, 99, 107, 105, 110, 103, 45, 114, 101, 97, 100, 1, 12, 1, 106, 1, 119, 1, 6, 1, 64, 2, 4, 115, 101, 108, 102, 9, 3, 108, 101, 110, 119, 0, 13, 4, 0, 25, 91, 109, 101, 116, 104, 111, 100, 93, 105, 110, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 115, 107, 105, 112, 1, 14, 4, 0, 34, 91, 109, 101, 116, 104, 111, 100, 93, 105, 110, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 98, 108, 111, 99, 107, 105, 110, 103, 45, 115, 107, 105, 112, 1, 14, 1, 105, 3, 1, 64, 1, 4, 115, 101, 108, 102, 9, 0, 15, 4, 0, 30, 91, 109, 101, 116, 104, 111, 100, 93, 105, 110, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 115, 117, 98, 115, 99, 114, 105, 98, 101, 1, 16, 1, 104, 8, 1, 64, 1, 4, 115, 101, 108, 102, 17, 0, 13, 4, 0, 33, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 99, 104, 101, 99, 107, 45, 119, 114, 105, 116, 101, 1, 18, 1, 106, 0, 1, 6, 1, 64, 2, 4, 115, 101, 108, 102, 17, 8, 99, 111, 110, 116, 101, 110, 116, 115, 10, 0, 19, 4, 0, 27, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 119, 114, 105, 116, 101, 1, 20, 4, 0, 46, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 98, 108, 111, 99, 107, 105, 110, 103, 45, 119, 114, 105, 116, 101, 45, 97, 110, 100, 45, 102, 108, 117, 115, 104, 1, 20, 1, 64, 1, 4, 115, 101, 108, 102, 17, 0, 19, 4, 0, 27, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 102, 108, 117, 115, 104, 1, 21, 4, 0, 36, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 98, 108, 111, 99, 107, 105, 110, 103, 45, 102, 108, 117, 115, 104, 1, 21, 1, 64, 1, 4, 115, 101, 108, 102, 17, 0, 15, 4, 0, 31, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 115, 117, 98, 115, 99, 114, 105, 98, 101, 1, 22, 1, 64, 2, 4, 115, 101, 108, 102, 17, 3, 108, 101, 110, 119, 0, 19, 4, 0, 34, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 119, 114, 105, 116, 101, 45, 122, 101, 114, 111, 101, 115, 1, 23, 4, 0, 53, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 98, 108, 111, 99, 107, 105, 110, 103, 45, 119, 114, 105, 116, 101, 45, 122, 101, 114, 111, 101, 115, 45, 97, 110, 100, 45, 102, 108, 117, 115, 104, 1, 23, 1, 64, 3, 4, 115, 101, 108, 102, 17, 3, 115, 114, 99, 9, 3, 108, 101, 110, 119, 0, 13, 4, 0, 28, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 115, 112, 108, 105, 99, 101, 1, 24, 4, 0, 37, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 46, 98, 108, 111, 99, 107, 105, 110, 103, 45, 115, 112, 108, 105, 99, 101, 1, 24, 3, 1, 21, 119, 97, 115, 105, 58, 105, 111, 47, 115, 116, 114, 101, 97, 109, 115, 64, 48, 46, 50, 46, 48, 5, 6, 2, 3, 0, 4, 12, 105, 110, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 1, 66, 5, 2, 3, 2, 1, 7, 4, 0, 12, 105, 110, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 3, 0, 0, 1, 105, 1, 1, 64, 0, 0, 2, 4, 0, 9, 103, 101, 116, 45, 115, 116, 100, 105, 110, 1, 3, 3, 1, 20, 119, 97, 115, 105, 58, 99, 108, 105, 47, 115, 116, 100, 105, 110, 64, 48, 46, 50, 46, 48, 5, 8, 2, 3, 0, 4, 13, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 1, 66, 5, 2, 3, 2, 1, 9, 4, 0, 13, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 3, 0, 0, 1, 105, 1, 1, 64, 0, 0, 2, 4, 0, 10, 103, 101, 116, 45, 115, 116, 100, 111, 117, 116, 1, 3, 3, 1, 21, 119, 97, 115, 105, 58, 99, 108, 105, 47, 115, 116, 100, 111, 117, 116, 64, 48, 46, 50, 46, 48, 5, 10, 1, 66, 5, 2, 3, 2, 1, 9, 4, 0, 13, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 3, 0, 0, 1, 105, 1, 1, 64, 0, 0, 2, 4, 0, 10, 103, 101, 116, 45, 115, 116, 100, 101, 114, 114, 1, 3, 3, 1, 21, 119, 97, 115, 105, 58, 99, 108, 105, 47, 115, 116, 100, 101, 114, 114, 64, 48, 46, 50, 46, 48, 5, 11, 1, 66, 1, 4, 0, 14, 116, 101, 114, 109, 105, 110, 97, 108, 45, 105, 110, 112, 117, 116, 3, 1, 3, 1, 29, 119, 97, 115, 105, 58, 99, 108, 105, 47, 116, 101, 114, 109, 105, 110, 97, 108, 45, 105, 110, 112, 117, 116, 64, 48, 46, 50, 46, 48, 5, 12, 1, 66, 1, 4, 0, 15, 116, 101, 114, 109, 105, 110, 97, 108, 45, 111, 117, 116, 112, 117, 116, 3, 1, 3, 1, 30, 119, 97, 115, 105, 58, 99, 108, 105, 47, 116, 101, 114, 109, 105, 110, 97, 108, 45, 111, 117, 116, 112, 117, 116, 64, 48, 46, 50, 46, 48, 5, 13, 2, 3, 0, 8, 14, 116, 101, 114, 109, 105, 110, 97, 108, 45, 105, 110, 112, 117, 116, 1, 66, 6, 2, 3, 2, 1, 14, 4, 0, 14, 116, 101, 114, 109, 105, 110, 97, 108, 45, 105, 110, 112, 117, 116, 3, 0, 0, 1, 105, 1, 1, 107, 2, 1, 64, 0, 0, 3, 4, 0, 18, 103, 101, 116, 45, 116, 101, 114, 109, 105, 110, 97, 108, 45, 115, 116, 100, 105, 110, 1, 4, 3, 1, 29, 119, 97, 115, 105, 58, 99, 108, 105, 47, 116, 101, 114, 109, 105, 110, 97, 108, 45, 115, 116, 100, 105, 110, 64, 48, 46, 50, 46, 48, 5, 15, 2, 3, 0, 9, 15, 116, 101, 114, 109, 105, 110, 97, 108, 45, 111, 117, 116, 112, 117, 116, 1, 66, 6, 2, 3, 2, 1, 16, 4, 0, 15, 116, 101, 114, 109, 105, 110, 97, 108, 45, 111, 117, 116, 112, 117, 116, 3, 0, 0, 1, 105, 1, 1, 107, 2, 1, 64, 0, 0, 3, 4, 0, 19, 103, 101, 116, 45, 116, 101, 114, 109, 105, 110, 97, 108, 45, 115, 116, 100, 111, 117, 116, 1, 4, 3, 1, 30, 119, 97, 115, 105, 58, 99, 108, 105, 47, 116, 101, 114, 109, 105, 110, 97, 108, 45, 115, 116, 100, 111, 117, 116, 64, 48, 46, 50, 46, 48, 5, 17, 1, 66, 6, 2, 3, 2, 1, 16, 4, 0, 15, 116, 101, 114, 109, 105, 110, 97, 108, 45, 111, 117, 116, 112, 117, 116, 3, 0, 0, 1, 105, 1, 1, 107, 2, 1, 64, 0, 0, 3, 4, 0, 19, 103, 101, 116, 45, 116, 101, 114, 109, 105, 110, 97, 108, 45, 115, 116, 100, 101, 114, 114, 1, 4, 3, 1, 30, 119, 97, 115, 105, 58, 99, 108, 105, 47, 116, 101, 114, 109, 105, 110, 97, 108, 45, 115, 116, 100, 101, 114, 114, 64, 48, 46, 50, 46, 48, 5, 18, 1, 66, 15, 2, 3, 2, 1, 5, 4, 0, 8, 112, 111, 108, 108, 97, 98, 108, 101, 3, 0, 0, 1, 119, 4, 0, 7, 105, 110, 115, 116, 97, 110, 116, 3, 0, 2, 1, 119, 4, 0, 8, 100, 117, 114, 97, 116, 105, 111, 110, 3, 0, 4, 1, 64, 0, 0, 3, 4, 0, 3, 110, 111, 119, 1, 6, 1, 64, 0, 0, 5, 4, 0, 10, 114, 101, 115, 111, 108, 117, 116, 105, 111, 110, 1, 7, 1, 105, 1, 1, 64, 1, 4, 119, 104, 101, 110, 3, 0, 8, 4, 0, 17, 115, 117, 98, 115, 99, 114, 105, 98, 101, 45, 105, 110, 115, 116, 97, 110, 116, 1, 9, 1, 64, 1, 4, 119, 104, 101, 110, 5, 0, 8, 4, 0, 18, 115, 117, 98, 115, 99, 114, 105, 98, 101, 45, 100, 117, 114, 97, 116, 105, 111, 110, 1, 10, 3, 1, 33, 119, 97, 115, 105, 58, 99, 108, 111, 99, 107, 115, 47, 109, 111, 110, 111, 116, 111, 110, 105, 99, 45, 99, 108, 111, 99, 107, 64, 48, 46, 50, 46, 48, 5, 19, 1, 66, 5, 1, 114, 2, 7, 115, 101, 99, 111, 110, 100, 115, 119, 11, 110, 97, 110, 111, 115, 101, 99, 111, 110, 100, 115, 121, 4, 0, 8, 100, 97, 116, 101, 116, 105, 109, 101, 3, 0, 0, 1, 64, 0, 0, 1, 4, 0, 3, 110, 111, 119, 1, 2, 4, 0, 10, 114, 101, 115, 111, 108, 117, 116, 105, 111, 110, 1, 2, 3, 1, 28, 119, 97, 115, 105, 58, 99, 108, 111, 99, 107, 115, 47, 119, 97, 108, 108, 45, 99, 108, 111, 99, 107, 64, 48, 46, 50, 46, 48, 5, 20, 2, 3, 0, 4, 5, 101, 114, 114, 111, 114, 2, 3, 0, 14, 8, 100, 97, 116, 101, 116, 105, 109, 101, 1, 66, 114, 2, 3, 2, 1, 7, 4, 0, 12, 105, 110, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 3, 0, 0, 2, 3, 2, 1, 9, 4, 0, 13, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 3, 0, 2, 2, 3, 2, 1, 21, 4, 0, 5, 101, 114, 114, 111, 114, 3, 0, 4, 2, 3, 2, 1, 22, 4, 0, 8, 100, 97, 116, 101, 116, 105, 109, 101, 3, 0, 6, 1, 119, 4, 0, 8, 102, 105, 108, 101, 115, 105, 122, 101, 3, 0, 8, 1, 109, 8, 7, 117, 110, 107, 110, 111, 119, 110, 12, 98, 108, 111, 99, 107, 45, 100, 101, 118, 105, 99, 101, 16, 99, 104, 97, 114, 97, 99, 116, 101, 114, 45, 100, 101, 118, 105, 99, 101, 9, 100, 105, 114, 101, 99, 116, 111, 114, 121, 4, 102, 105, 102, 111, 13, 115, 121, 109, 98, 111, 108, 105, 99, 45, 108, 105, 110, 107, 12, 114, 101, 103, 117, 108, 97, 114, 45, 102, 105, 108, 101, 6, 115, 111, 99, 107, 101, 116, 4, 0, 15, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 45, 116, 121, 112, 101, 3, 0, 10, 1, 110, 6, 4, 114, 101, 97, 100, 5, 119, 114, 105, 116, 101, 19, 102, 105, 108, 101, 45, 105, 110, 116, 101, 103, 114, 105, 116, 121, 45, 115, 121, 110, 99, 19, 100, 97, 116, 97, 45, 105, 110, 116, 101, 103, 114, 105, 116, 121, 45, 115, 121, 110, 99, 20, 114, 101, 113, 117, 101, 115, 116, 101, 100, 45, 119, 114, 105, 116, 101, 45, 115, 121, 110, 99, 16, 109, 117, 116, 97, 116, 101, 45, 100, 105, 114, 101, 99, 116, 111, 114, 121, 4, 0, 16, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 45, 102, 108, 97, 103, 115, 3, 0, 12, 1, 110, 1, 14, 115, 121, 109, 108, 105, 110, 107, 45, 102, 111, 108, 108, 111, 119, 4, 0, 10, 112, 97, 116, 104, 45, 102, 108, 97, 103, 115, 3, 0, 14, 1, 110, 4, 6, 99, 114, 101, 97, 116, 101, 9, 100, 105, 114, 101, 99, 116, 111, 114, 121, 9, 101, 120, 99, 108, 117, 115, 105, 118, 101, 8, 116, 114, 117, 110, 99, 97, 116, 101, 4, 0, 10, 111, 112, 101, 110, 45, 102, 108, 97, 103, 115, 3, 0, 16, 1, 119, 4, 0, 10, 108, 105, 110, 107, 45, 99, 111, 117, 110, 116, 3, 0, 18, 1, 107, 7, 1, 114, 6, 4, 116, 121, 112, 101, 11, 10, 108, 105, 110, 107, 45, 99, 111, 117, 110, 116, 19, 4, 115, 105, 122, 101, 9, 21, 100, 97, 116, 97, 45, 97, 99, 99, 101, 115, 115, 45, 116, 105, 109, 101, 115, 116, 97, 109, 112, 20, 27, 100, 97, 116, 97, 45, 109, 111, 100, 105, 102, 105, 99, 97, 116, 105, 111, 110, 45, 116, 105, 109, 101, 115, 116, 97, 109, 112, 20, 23, 115, 116, 97, 116, 117, 115, 45, 99, 104, 97, 110, 103, 101, 45, 116, 105, 109, 101, 115, 116, 97, 109, 112, 20, 4, 0, 15, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 45, 115, 116, 97, 116, 3, 0, 21, 1, 113, 3, 9, 110, 111, 45, 99, 104, 97, 110, 103, 101, 0, 0, 3, 110, 111, 119, 0, 0, 9, 116, 105, 109, 101, 115, 116, 97, 109, 112, 1, 7, 0, 4, 0, 13, 110, 101, 119, 45, 116, 105, 109, 101, 115, 116, 97, 109, 112, 3, 0, 23, 1, 114, 2, 4, 116, 121, 112, 101, 11, 4, 110, 97, 109, 101, 115, 4, 0, 15, 100, 105, 114, 101, 99, 116, 111, 114, 121, 45, 101, 110, 116, 114, 121, 3, 0, 25, 1, 109, 37, 6, 97, 99, 99, 101, 115, 115, 11, 119, 111, 117, 108, 100, 45, 98, 108, 111, 99, 107, 7, 97, 108, 114, 101, 97, 100, 121, 14, 98, 97, 100, 45, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 4, 98, 117, 115, 121, 8, 100, 101, 97, 100, 108, 111, 99, 107, 5, 113, 117, 111, 116, 97, 5, 101, 120, 105, 115, 116, 14, 102, 105, 108, 101, 45, 116, 111, 111, 45, 108, 97, 114, 103, 101, 21, 105, 108, 108, 101, 103, 97, 108, 45, 98, 121, 116, 101, 45, 115, 101, 113, 117, 101, 110, 99, 101, 11, 105, 110, 45, 112, 114, 111, 103, 114, 101, 115, 115, 11, 105, 110, 116, 101, 114, 114, 117, 112, 116, 101, 100, 7, 105, 110, 118, 97, 108, 105, 100, 2, 105, 111, 12, 105, 115, 45, 100, 105, 114, 101, 99, 116, 111, 114, 121, 4, 108, 111, 111, 112, 14, 116, 111, 111, 45, 109, 97, 110, 121, 45, 108, 105, 110, 107, 115, 12, 109, 101, 115, 115, 97, 103, 101, 45, 115, 105, 122, 101, 13, 110, 97, 109, 101, 45, 116, 111, 111, 45, 108, 111, 110, 103, 9, 110, 111, 45, 100, 101, 118, 105, 99, 101, 8, 110, 111, 45, 101, 110, 116, 114, 121, 7, 110, 111, 45, 108, 111, 99, 107, 19, 105, 110, 115, 117, 102, 102, 105, 99, 105, 101, 110, 116, 45, 109, 101, 109, 111, 114, 121, 18, 105, 110, 115, 117, 102, 102, 105, 99, 105, 101, 110, 116, 45, 115, 112, 97, 99, 101, 13, 110, 111, 116, 45, 100, 105, 114, 101, 99, 116, 111, 114, 121, 9, 110, 111, 116, 45, 101, 109, 112, 116, 121, 15, 110, 111, 116, 45, 114, 101, 99, 111, 118, 101, 114, 97, 98, 108, 101, 11, 117, 110, 115, 117, 112, 112, 111, 114, 116, 101, 100, 6, 110, 111, 45, 116, 116, 121, 14, 110, 111, 45, 115, 117, 99, 104, 45, 100, 101, 118, 105, 99, 101, 8, 111, 118, 101, 114, 102, 108, 111, 119, 13, 110, 111, 116, 45, 112, 101, 114, 109, 105, 116, 116, 101, 100, 4, 112, 105, 112, 101, 9, 114, 101, 97, 100, 45, 111, 110, 108, 121, 12, 105, 110, 118, 97, 108, 105, 100, 45, 115, 101, 101, 107, 14, 116, 101, 120, 116, 45, 102, 105, 108, 101, 45, 98, 117, 115, 121, 12, 99, 114, 111, 115, 115, 45, 100, 101, 118, 105, 99, 101, 4, 0, 10, 101, 114, 114, 111, 114, 45, 99, 111, 100, 101, 3, 0, 27, 1, 109, 6, 6, 110, 111, 114, 109, 97, 108, 10, 115, 101, 113, 117, 101, 110, 116, 105, 97, 108, 6, 114, 97, 110, 100, 111, 109, 9, 119, 105, 108, 108, 45, 110, 101, 101, 100, 9, 100, 111, 110, 116, 45, 110, 101, 101, 100, 8, 110, 111, 45, 114, 101, 117, 115, 101, 4, 0, 6, 97, 100, 118, 105, 99, 101, 3, 0, 29, 1, 114, 2, 5, 108, 111, 119, 101, 114, 119, 5, 117, 112, 112, 101, 114, 119, 4, 0, 19, 109, 101, 116, 97, 100, 97, 116, 97, 45, 104, 97, 115, 104, 45, 118, 97, 108, 117, 101, 3, 0, 31, 4, 0, 10, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 3, 1, 4, 0, 22, 100, 105, 114, 101, 99, 116, 111, 114, 121, 45, 101, 110, 116, 114, 121, 45, 115, 116, 114, 101, 97, 109, 3, 1, 1, 104, 33, 1, 105, 1, 1, 106, 1, 36, 1, 28, 1, 64, 2, 4, 115, 101, 108, 102, 35, 6, 111, 102, 102, 115, 101, 116, 9, 0, 37, 4, 0, 34, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 114, 101, 97, 100, 45, 118, 105, 97, 45, 115, 116, 114, 101, 97, 109, 1, 38, 1, 105, 3, 1, 106, 1, 39, 1, 28, 1, 64, 2, 4, 115, 101, 108, 102, 35, 6, 111, 102, 102, 115, 101, 116, 9, 0, 40, 4, 0, 35, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 119, 114, 105, 116, 101, 45, 118, 105, 97, 45, 115, 116, 114, 101, 97, 109, 1, 41, 1, 64, 1, 4, 115, 101, 108, 102, 35, 0, 40, 4, 0, 36, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 97, 112, 112, 101, 110, 100, 45, 118, 105, 97, 45, 115, 116, 114, 101, 97, 109, 1, 42, 1, 106, 0, 1, 28, 1, 64, 4, 4, 115, 101, 108, 102, 35, 6, 111, 102, 102, 115, 101, 116, 9, 6, 108, 101, 110, 103, 116, 104, 9, 6, 97, 100, 118, 105, 99, 101, 30, 0, 43, 4, 0, 25, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 97, 100, 118, 105, 115, 101, 1, 44, 1, 64, 1, 4, 115, 101, 108, 102, 35, 0, 43, 4, 0, 28, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 115, 121, 110, 99, 45, 100, 97, 116, 97, 1, 45, 1, 106, 1, 13, 1, 28, 1, 64, 1, 4, 115, 101, 108, 102, 35, 0, 46, 4, 0, 28, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 103, 101, 116, 45, 102, 108, 97, 103, 115, 1, 47, 1, 106, 1, 11, 1, 28, 1, 64, 1, 4, 115, 101, 108, 102, 35, 0, 48, 4, 0, 27, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 103, 101, 116, 45, 116, 121, 112, 101, 1, 49, 1, 64, 2, 4, 115, 101, 108, 102, 35, 4, 115, 105, 122, 101, 9, 0, 43, 4, 0, 27, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 115, 101, 116, 45, 115, 105, 122, 101, 1, 50, 1, 64, 3, 4, 115, 101, 108, 102, 35, 21, 100, 97, 116, 97, 45, 97, 99, 99, 101, 115, 115, 45, 116, 105, 109, 101, 115, 116, 97, 109, 112, 24, 27, 100, 97, 116, 97, 45, 109, 111, 100, 105, 102, 105, 99, 97, 116, 105, 111, 110, 45, 116, 105, 109, 101, 115, 116, 97, 109, 112, 24, 0, 43, 4, 0, 28, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 115, 101, 116, 45, 116, 105, 109, 101, 115, 1, 51, 1, 112, 125, 1, 111, 2, 52, 127, 1, 106, 1, 53, 1, 28, 1, 64, 3, 4, 115, 101, 108, 102, 35, 6, 108, 101, 110, 103, 116, 104, 9, 6, 111, 102, 102, 115, 101, 116, 9, 0, 54, 4, 0, 23, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 114, 101, 97, 100, 1, 55, 1, 106, 1, 9, 1, 28, 1, 64, 3, 4, 115, 101, 108, 102, 35, 6, 98, 117, 102, 102, 101, 114, 52, 6, 111, 102, 102, 115, 101, 116, 9, 0, 56, 4, 0, 24, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 119, 114, 105, 116, 101, 1, 57, 1, 105, 34, 1, 106, 1, 58, 1, 28, 1, 64, 1, 4, 115, 101, 108, 102, 35, 0, 59, 4, 0, 33, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 114, 101, 97, 100, 45, 100, 105, 114, 101, 99, 116, 111, 114, 121, 1, 60, 4, 0, 23, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 115, 121, 110, 99, 1, 45, 1, 64, 2, 4, 115, 101, 108, 102, 35, 4, 112, 97, 116, 104, 115, 0, 43, 4, 0, 38, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 99, 114, 101, 97, 116, 101, 45, 100, 105, 114, 101, 99, 116, 111, 114, 121, 45, 97, 116, 1, 61, 1, 106, 1, 22, 1, 28, 1, 64, 1, 4, 115, 101, 108, 102, 35, 0, 62, 4, 0, 23, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 115, 116, 97, 116, 1, 63, 1, 64, 3, 4, 115, 101, 108, 102, 35, 10, 112, 97, 116, 104, 45, 102, 108, 97, 103, 115, 15, 4, 112, 97, 116, 104, 115, 0, 62, 4, 0, 26, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 115, 116, 97, 116, 45, 97, 116, 1, 64, 1, 64, 5, 4, 115, 101, 108, 102, 35, 10, 112, 97, 116, 104, 45, 102, 108, 97, 103, 115, 15, 4, 112, 97, 116, 104, 115, 21, 100, 97, 116, 97, 45, 97, 99, 99, 101, 115, 115, 45, 116, 105, 109, 101, 115, 116, 97, 109, 112, 24, 27, 100, 97, 116, 97, 45, 109, 111, 100, 105, 102, 105, 99, 97, 116, 105, 111, 110, 45, 116, 105, 109, 101, 115, 116, 97, 109, 112, 24, 0, 43, 4, 0, 31, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 115, 101, 116, 45, 116, 105, 109, 101, 115, 45, 97, 116, 1, 65, 1, 64, 5, 4, 115, 101, 108, 102, 35, 14, 111, 108, 100, 45, 112, 97, 116, 104, 45, 102, 108, 97, 103, 115, 15, 8, 111, 108, 100, 45, 112, 97, 116, 104, 115, 14, 110, 101, 119, 45, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 35, 8, 110, 101, 119, 45, 112, 97, 116, 104, 115, 0, 43, 4, 0, 26, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 108, 105, 110, 107, 45, 97, 116, 1, 66, 1, 105, 33, 1, 106, 1, 195, 0, 1, 28, 1, 64, 5, 4, 115, 101, 108, 102, 35, 10, 112, 97, 116, 104, 45, 102, 108, 97, 103, 115, 15, 4, 112, 97, 116, 104, 115, 10, 111, 112, 101, 110, 45, 102, 108, 97, 103, 115, 17, 5, 102, 108, 97, 103, 115, 13, 0, 196, 0, 4, 0, 26, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 111, 112, 101, 110, 45, 97, 116, 1, 69, 1, 106, 1, 115, 1, 28, 1, 64, 2, 4, 115, 101, 108, 102, 35, 4, 112, 97, 116, 104, 115, 0, 198, 0, 4, 0, 30, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 114, 101, 97, 100, 108, 105, 110, 107, 45, 97, 116, 1, 71, 4, 0, 38, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 114, 101, 109, 111, 118, 101, 45, 100, 105, 114, 101, 99, 116, 111, 114, 121, 45, 97, 116, 1, 61, 1, 64, 4, 4, 115, 101, 108, 102, 35, 8, 111, 108, 100, 45, 112, 97, 116, 104, 115, 14, 110, 101, 119, 45, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 35, 8, 110, 101, 119, 45, 112, 97, 116, 104, 115, 0, 43, 4, 0, 28, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 114, 101, 110, 97, 109, 101, 45, 97, 116, 1, 72, 1, 64, 3, 4, 115, 101, 108, 102, 35, 8, 111, 108, 100, 45, 112, 97, 116, 104, 115, 8, 110, 101, 119, 45, 112, 97, 116, 104, 115, 0, 43, 4, 0, 29, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 115, 121, 109, 108, 105, 110, 107, 45, 97, 116, 1, 73, 4, 0, 33, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 117, 110, 108, 105, 110, 107, 45, 102, 105, 108, 101, 45, 97, 116, 1, 61, 1, 64, 2, 4, 115, 101, 108, 102, 35, 5, 111, 116, 104, 101, 114, 35, 0, 127, 4, 0, 33, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 105, 115, 45, 115, 97, 109, 101, 45, 111, 98, 106, 101, 99, 116, 1, 74, 1, 106, 1, 32, 1, 28, 1, 64, 1, 4, 115, 101, 108, 102, 35, 0, 203, 0, 4, 0, 32, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 109, 101, 116, 97, 100, 97, 116, 97, 45, 104, 97, 115, 104, 1, 76, 1, 64, 3, 4, 115, 101, 108, 102, 35, 10, 112, 97, 116, 104, 45, 102, 108, 97, 103, 115, 15, 4, 112, 97, 116, 104, 115, 0, 203, 0, 4, 0, 35, 91, 109, 101, 116, 104, 111, 100, 93, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 46, 109, 101, 116, 97, 100, 97, 116, 97, 45, 104, 97, 115, 104, 45, 97, 116, 1, 77, 1, 104, 34, 1, 107, 26, 1, 106, 1, 207, 0, 1, 28, 1, 64, 1, 4, 115, 101, 108, 102, 206, 0, 0, 208, 0, 4, 0, 51, 91, 109, 101, 116, 104, 111, 100, 93, 100, 105, 114, 101, 99, 116, 111, 114, 121, 45, 101, 110, 116, 114, 121, 45, 115, 116, 114, 101, 97, 109, 46, 114, 101, 97, 100, 45, 100, 105, 114, 101, 99, 116, 111, 114, 121, 45, 101, 110, 116, 114, 121, 1, 81, 1, 104, 5, 1, 107, 28, 1, 64, 1, 3, 101, 114, 114, 210, 0, 0, 211, 0, 4, 0, 21, 102, 105, 108, 101, 115, 121, 115, 116, 101, 109, 45, 101, 114, 114, 111, 114, 45, 99, 111, 100, 101, 1, 84, 3, 1, 27, 119, 97, 115, 105, 58, 102, 105, 108, 101, 115, 121, 115, 116, 101, 109, 47, 116, 121, 112, 101, 115, 64, 48, 46, 50, 46, 48, 5, 23, 2, 3, 0, 15, 10, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 1, 66, 7, 2, 3, 2, 1, 24, 4, 0, 10, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 3, 0, 0, 1, 105, 1, 1, 111, 2, 2, 115, 1, 112, 3, 1, 64, 0, 0, 4, 4, 0, 15, 103, 101, 116, 45, 100, 105, 114, 101, 99, 116, 111, 114, 105, 101, 115, 1, 5, 3, 1, 30, 119, 97, 115, 105, 58, 102, 105, 108, 101, 115, 121, 115, 116, 101, 109, 47, 112, 114, 101, 111, 112, 101, 110, 115, 64, 48, 46, 50, 46, 48, 5, 25, 1, 66, 17, 4, 0, 7, 110, 101, 116, 119, 111, 114, 107, 3, 1, 1, 109, 21, 7, 117, 110, 107, 110, 111, 119, 110, 13, 97, 99, 99, 101, 115, 115, 45, 100, 101, 110, 105, 101, 100, 13, 110, 111, 116, 45, 115, 117, 112, 112, 111, 114, 116, 101, 100, 16, 105, 110, 118, 97, 108, 105, 100, 45, 97, 114, 103, 117, 109, 101, 110, 116, 13, 111, 117, 116, 45, 111, 102, 45, 109, 101, 109, 111, 114, 121, 7, 116, 105, 109, 101, 111, 117, 116, 20, 99, 111, 110, 99, 117, 114, 114, 101, 110, 99, 121, 45, 99, 111, 110, 102, 108, 105, 99, 116, 15, 110, 111, 116, 45, 105, 110, 45, 112, 114, 111, 103, 114, 101, 115, 115, 11, 119, 111, 117, 108, 100, 45, 98, 108, 111, 99, 107, 13, 105, 110, 118, 97, 108, 105, 100, 45, 115, 116, 97, 116, 101, 16, 110, 101, 119, 45, 115, 111, 99, 107, 101, 116, 45, 108, 105, 109, 105, 116, 20, 97, 100, 100, 114, 101, 115, 115, 45, 110, 111, 116, 45, 98, 105, 110, 100, 97, 98, 108, 101, 14, 97, 100, 100, 114, 101, 115, 115, 45, 105, 110, 45, 117, 115, 101, 18, 114, 101, 109, 111, 116, 101, 45, 117, 110, 114, 101, 97, 99, 104, 97, 98, 108, 101, 18, 99, 111, 110, 110, 101, 99, 116, 105, 111, 110, 45, 114, 101, 102, 117, 115, 101, 100, 16, 99, 111, 110, 110, 101, 99, 116, 105, 111, 110, 45, 114, 101, 115, 101, 116, 18, 99, 111, 110, 110, 101, 99, 116, 105, 111, 110, 45, 97, 98, 111, 114, 116, 101, 100, 18, 100, 97, 116, 97, 103, 114, 97, 109, 45, 116, 111, 111, 45, 108, 97, 114, 103, 101, 17, 110, 97, 109, 101, 45, 117, 110, 114, 101, 115, 111, 108, 118, 97, 98, 108, 101, 26, 116, 101, 109, 112, 111, 114, 97, 114, 121, 45, 114, 101, 115, 111, 108, 118, 101, 114, 45, 102, 97, 105, 108, 117, 114, 101, 26, 112, 101, 114, 109, 97, 110, 101, 110, 116, 45, 114, 101, 115, 111, 108, 118, 101, 114, 45, 102, 97, 105, 108, 117, 114, 101, 4, 0, 10, 101, 114, 114, 111, 114, 45, 99, 111, 100, 101, 3, 0, 1, 1, 109, 2, 4, 105, 112, 118, 52, 4, 105, 112, 118, 54, 4, 0, 17, 105, 112, 45, 97, 100, 100, 114, 101, 115, 115, 45, 102, 97, 109, 105, 108, 121, 3, 0, 3, 1, 111, 4, 125, 125, 125, 125, 4, 0, 12, 105, 112, 118, 52, 45, 97, 100, 100, 114, 101, 115, 115, 3, 0, 5, 1, 111, 8, 123, 123, 123, 123, 123, 123, 123, 123, 4, 0, 12, 105, 112, 118, 54, 45, 97, 100, 100, 114, 101, 115, 115, 3, 0, 7, 1, 113, 2, 4, 105, 112, 118, 52, 1, 6, 0, 4, 105, 112, 118, 54, 1, 8, 0, 4, 0, 10, 105, 112, 45, 97, 100, 100, 114, 101, 115, 115, 3, 0, 9, 1, 114, 2, 4, 112, 111, 114, 116, 123, 7, 97, 100, 100, 114, 101, 115, 115, 6, 4, 0, 19, 105, 112, 118, 52, 45, 115, 111, 99, 107, 101, 116, 45, 97, 100, 100, 114, 101, 115, 115, 3, 0, 11, 1, 114, 4, 4, 112, 111, 114, 116, 123, 9, 102, 108, 111, 119, 45, 105, 110, 102, 111, 121, 7, 97, 100, 100, 114, 101, 115, 115, 8, 8, 115, 99, 111, 112, 101, 45, 105, 100, 121, 4, 0, 19, 105, 112, 118, 54, 45, 115, 111, 99, 107, 101, 116, 45, 97, 100, 100, 114, 101, 115, 115, 3, 0, 13, 1, 113, 2, 4, 105, 112, 118, 52, 1, 12, 0, 4, 105, 112, 118, 54, 1, 14, 0, 4, 0, 17, 105, 112, 45, 115, 111, 99, 107, 101, 116, 45, 97, 100, 100, 114, 101, 115, 115, 3, 0, 15, 3, 1, 26, 119, 97, 115, 105, 58, 115, 111, 99, 107, 101, 116, 115, 47, 110, 101, 116, 119, 111, 114, 107, 64, 48, 46, 50, 46, 48, 5, 26, 2, 3, 0, 17, 7, 110, 101, 116, 119, 111, 114, 107, 1, 66, 5, 2, 3, 2, 1, 27, 4, 0, 7, 110, 101, 116, 119, 111, 114, 107, 3, 0, 0, 1, 105, 1, 1, 64, 0, 0, 2, 4, 0, 16, 105, 110, 115, 116, 97, 110, 99, 101, 45, 110, 101, 116, 119, 111, 114, 107, 1, 3, 3, 1, 35, 119, 97, 115, 105, 58, 115, 111, 99, 107, 101, 116, 115, 47, 105, 110, 115, 116, 97, 110, 99, 101, 45, 110, 101, 116, 119, 111, 114, 107, 64, 48, 46, 50, 46, 48, 5, 28, 2, 3, 0, 17, 10, 101, 114, 114, 111, 114, 45, 99, 111, 100, 101, 2, 3, 0, 17, 17, 105, 112, 45, 115, 111, 99, 107, 101, 116, 45, 97, 100, 100, 114, 101, 115, 115, 2, 3, 0, 17, 17, 105, 112, 45, 97, 100, 100, 114, 101, 115, 115, 45, 102, 97, 109, 105, 108, 121, 1, 66, 68, 2, 3, 2, 1, 5, 4, 0, 8, 112, 111, 108, 108, 97, 98, 108, 101, 3, 0, 0, 2, 3, 2, 1, 27, 4, 0, 7, 110, 101, 116, 119, 111, 114, 107, 3, 0, 2, 2, 3, 2, 1, 29, 4, 0, 10, 101, 114, 114, 111, 114, 45, 99, 111, 100, 101, 3, 0, 4, 2, 3, 2, 1, 30, 4, 0, 17, 105, 112, 45, 115, 111, 99, 107, 101, 116, 45, 97, 100, 100, 114, 101, 115, 115, 3, 0, 6, 2, 3, 2, 1, 31, 4, 0, 17, 105, 112, 45, 97, 100, 100, 114, 101, 115, 115, 45, 102, 97, 109, 105, 108, 121, 3, 0, 8, 1, 112, 125, 1, 114, 2, 4, 100, 97, 116, 97, 10, 14, 114, 101, 109, 111, 116, 101, 45, 97, 100, 100, 114, 101, 115, 115, 7, 4, 0, 17, 105, 110, 99, 111, 109, 105, 110, 103, 45, 100, 97, 116, 97, 103, 114, 97, 109, 3, 0, 11, 1, 107, 7, 1, 114, 2, 4, 100, 97, 116, 97, 10, 14, 114, 101, 109, 111, 116, 101, 45, 97, 100, 100, 114, 101, 115, 115, 13, 4, 0, 17, 111, 117, 116, 103, 111, 105, 110, 103, 45, 100, 97, 116, 97, 103, 114, 97, 109, 3, 0, 14, 4, 0, 10, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 3, 1, 4, 0, 24, 105, 110, 99, 111, 109, 105, 110, 103, 45, 100, 97, 116, 97, 103, 114, 97, 109, 45, 115, 116, 114, 101, 97, 109, 3, 1, 4, 0, 24, 111, 117, 116, 103, 111, 105, 110, 103, 45, 100, 97, 116, 97, 103, 114, 97, 109, 45, 115, 116, 114, 101, 97, 109, 3, 1, 1, 104, 16, 1, 104, 3, 1, 106, 0, 1, 5, 1, 64, 3, 4, 115, 101, 108, 102, 19, 7, 110, 101, 116, 119, 111, 114, 107, 20, 13, 108, 111, 99, 97, 108, 45, 97, 100, 100, 114, 101, 115, 115, 7, 0, 21, 4, 0, 29, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 116, 97, 114, 116, 45, 98, 105, 110, 100, 1, 22, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 21, 4, 0, 30, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 102, 105, 110, 105, 115, 104, 45, 98, 105, 110, 100, 1, 23, 1, 105, 17, 1, 105, 18, 1, 111, 2, 24, 25, 1, 106, 1, 26, 1, 5, 1, 64, 2, 4, 115, 101, 108, 102, 19, 14, 114, 101, 109, 111, 116, 101, 45, 97, 100, 100, 114, 101, 115, 115, 13, 0, 27, 4, 0, 25, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 116, 114, 101, 97, 109, 1, 28, 1, 106, 1, 7, 1, 5, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 29, 4, 0, 32, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 108, 111, 99, 97, 108, 45, 97, 100, 100, 114, 101, 115, 115, 1, 30, 4, 0, 33, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 114, 101, 109, 111, 116, 101, 45, 97, 100, 100, 114, 101, 115, 115, 1, 30, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 9, 4, 0, 33, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 97, 100, 100, 114, 101, 115, 115, 45, 102, 97, 109, 105, 108, 121, 1, 31, 1, 106, 1, 125, 1, 5, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 32, 4, 0, 36, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 117, 110, 105, 99, 97, 115, 116, 45, 104, 111, 112, 45, 108, 105, 109, 105, 116, 1, 33, 1, 64, 2, 4, 115, 101, 108, 102, 19, 5, 118, 97, 108, 117, 101, 125, 0, 21, 4, 0, 40, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 117, 110, 105, 99, 97, 115, 116, 45, 104, 111, 112, 45, 108, 105, 109, 105, 116, 1, 34, 1, 106, 1, 119, 1, 5, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 35, 4, 0, 38, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 114, 101, 99, 101, 105, 118, 101, 45, 98, 117, 102, 102, 101, 114, 45, 115, 105, 122, 101, 1, 36, 1, 64, 2, 4, 115, 101, 108, 102, 19, 5, 118, 97, 108, 117, 101, 119, 0, 21, 4, 0, 42, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 114, 101, 99, 101, 105, 118, 101, 45, 98, 117, 102, 102, 101, 114, 45, 115, 105, 122, 101, 1, 37, 4, 0, 35, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 110, 100, 45, 98, 117, 102, 102, 101, 114, 45, 115, 105, 122, 101, 1, 36, 4, 0, 39, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 115, 101, 110, 100, 45, 98, 117, 102, 102, 101, 114, 45, 115, 105, 122, 101, 1, 37, 1, 105, 1, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 38, 4, 0, 28, 91, 109, 101, 116, 104, 111, 100, 93, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 117, 98, 115, 99, 114, 105, 98, 101, 1, 39, 1, 104, 17, 1, 112, 12, 1, 106, 1, 41, 1, 5, 1, 64, 2, 4, 115, 101, 108, 102, 40, 11, 109, 97, 120, 45, 114, 101, 115, 117, 108, 116, 115, 119, 0, 42, 4, 0, 40, 91, 109, 101, 116, 104, 111, 100, 93, 105, 110, 99, 111, 109, 105, 110, 103, 45, 100, 97, 116, 97, 103, 114, 97, 109, 45, 115, 116, 114, 101, 97, 109, 46, 114, 101, 99, 101, 105, 118, 101, 1, 43, 1, 64, 1, 4, 115, 101, 108, 102, 40, 0, 38, 4, 0, 42, 91, 109, 101, 116, 104, 111, 100, 93, 105, 110, 99, 111, 109, 105, 110, 103, 45, 100, 97, 116, 97, 103, 114, 97, 109, 45, 115, 116, 114, 101, 97, 109, 46, 115, 117, 98, 115, 99, 114, 105, 98, 101, 1, 44, 1, 104, 18, 1, 64, 1, 4, 115, 101, 108, 102, 45, 0, 35, 4, 0, 43, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 103, 111, 105, 110, 103, 45, 100, 97, 116, 97, 103, 114, 97, 109, 45, 115, 116, 114, 101, 97, 109, 46, 99, 104, 101, 99, 107, 45, 115, 101, 110, 100, 1, 46, 1, 112, 15, 1, 64, 2, 4, 115, 101, 108, 102, 45, 9, 100, 97, 116, 97, 103, 114, 97, 109, 115, 47, 0, 35, 4, 0, 37, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 103, 111, 105, 110, 103, 45, 100, 97, 116, 97, 103, 114, 97, 109, 45, 115, 116, 114, 101, 97, 109, 46, 115, 101, 110, 100, 1, 48, 1, 64, 1, 4, 115, 101, 108, 102, 45, 0, 38, 4, 0, 42, 91, 109, 101, 116, 104, 111, 100, 93, 111, 117, 116, 103, 111, 105, 110, 103, 45, 100, 97, 116, 97, 103, 114, 97, 109, 45, 115, 116, 114, 101, 97, 109, 46, 115, 117, 98, 115, 99, 114, 105, 98, 101, 1, 49, 3, 1, 22, 119, 97, 115, 105, 58, 115, 111, 99, 107, 101, 116, 115, 47, 117, 100, 112, 64, 48, 46, 50, 46, 48, 5, 32, 2, 3, 0, 19, 10, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 1, 66, 12, 2, 3, 2, 1, 27, 4, 0, 7, 110, 101, 116, 119, 111, 114, 107, 3, 0, 0, 2, 3, 2, 1, 29, 4, 0, 10, 101, 114, 114, 111, 114, 45, 99, 111, 100, 101, 3, 0, 2, 2, 3, 2, 1, 31, 4, 0, 17, 105, 112, 45, 97, 100, 100, 114, 101, 115, 115, 45, 102, 97, 109, 105, 108, 121, 3, 0, 4, 2, 3, 2, 1, 33, 4, 0, 10, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 3, 0, 6, 1, 105, 7, 1, 106, 1, 8, 1, 3, 1, 64, 1, 14, 97, 100, 100, 114, 101, 115, 115, 45, 102, 97, 109, 105, 108, 121, 5, 0, 9, 4, 0, 17, 99, 114, 101, 97, 116, 101, 45, 117, 100, 112, 45, 115, 111, 99, 107, 101, 116, 1, 10, 3, 1, 36, 119, 97, 115, 105, 58, 115, 111, 99, 107, 101, 116, 115, 47, 117, 100, 112, 45, 99, 114, 101, 97, 116, 101, 45, 115, 111, 99, 107, 101, 116, 64, 48, 46, 50, 46, 48, 5, 34, 2, 3, 0, 13, 8, 100, 117, 114, 97, 116, 105, 111, 110, 1, 66, 84, 2, 3, 2, 1, 7, 4, 0, 12, 105, 110, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 3, 0, 0, 2, 3, 2, 1, 9, 4, 0, 13, 111, 117, 116, 112, 117, 116, 45, 115, 116, 114, 101, 97, 109, 3, 0, 2, 2, 3, 2, 1, 5, 4, 0, 8, 112, 111, 108, 108, 97, 98, 108, 101, 3, 0, 4, 2, 3, 2, 1, 35, 4, 0, 8, 100, 117, 114, 97, 116, 105, 111, 110, 3, 0, 6, 2, 3, 2, 1, 27, 4, 0, 7, 110, 101, 116, 119, 111, 114, 107, 3, 0, 8, 2, 3, 2, 1, 29, 4, 0, 10, 101, 114, 114, 111, 114, 45, 99, 111, 100, 101, 3, 0, 10, 2, 3, 2, 1, 30, 4, 0, 17, 105, 112, 45, 115, 111, 99, 107, 101, 116, 45, 97, 100, 100, 114, 101, 115, 115, 3, 0, 12, 2, 3, 2, 1, 31, 4, 0, 17, 105, 112, 45, 97, 100, 100, 114, 101, 115, 115, 45, 102, 97, 109, 105, 108, 121, 3, 0, 14, 1, 109, 3, 7, 114, 101, 99, 101, 105, 118, 101, 4, 115, 101, 110, 100, 4, 98, 111, 116, 104, 4, 0, 13, 115, 104, 117, 116, 100, 111, 119, 110, 45, 116, 121, 112, 101, 3, 0, 16, 4, 0, 10, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 3, 1, 1, 104, 18, 1, 104, 9, 1, 106, 0, 1, 11, 1, 64, 3, 4, 115, 101, 108, 102, 19, 7, 110, 101, 116, 119, 111, 114, 107, 20, 13, 108, 111, 99, 97, 108, 45, 97, 100, 100, 114, 101, 115, 115, 13, 0, 21, 4, 0, 29, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 116, 97, 114, 116, 45, 98, 105, 110, 100, 1, 22, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 21, 4, 0, 30, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 102, 105, 110, 105, 115, 104, 45, 98, 105, 110, 100, 1, 23, 1, 64, 3, 4, 115, 101, 108, 102, 19, 7, 110, 101, 116, 119, 111, 114, 107, 20, 14, 114, 101, 109, 111, 116, 101, 45, 97, 100, 100, 114, 101, 115, 115, 13, 0, 21, 4, 0, 32, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 116, 97, 114, 116, 45, 99, 111, 110, 110, 101, 99, 116, 1, 24, 1, 105, 1, 1, 105, 3, 1, 111, 2, 25, 26, 1, 106, 1, 27, 1, 11, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 28, 4, 0, 33, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 102, 105, 110, 105, 115, 104, 45, 99, 111, 110, 110, 101, 99, 116, 1, 29, 4, 0, 31, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 116, 97, 114, 116, 45, 108, 105, 115, 116, 101, 110, 1, 23, 4, 0, 32, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 102, 105, 110, 105, 115, 104, 45, 108, 105, 115, 116, 101, 110, 1, 23, 1, 105, 18, 1, 111, 3, 30, 25, 26, 1, 106, 1, 31, 1, 11, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 32, 4, 0, 25, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 97, 99, 99, 101, 112, 116, 1, 33, 1, 106, 1, 13, 1, 11, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 34, 4, 0, 32, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 108, 111, 99, 97, 108, 45, 97, 100, 100, 114, 101, 115, 115, 1, 35, 4, 0, 33, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 114, 101, 109, 111, 116, 101, 45, 97, 100, 100, 114, 101, 115, 115, 1, 35, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 127, 4, 0, 31, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 105, 115, 45, 108, 105, 115, 116, 101, 110, 105, 110, 103, 1, 36, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 15, 4, 0, 33, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 97, 100, 100, 114, 101, 115, 115, 45, 102, 97, 109, 105, 108, 121, 1, 37, 1, 64, 2, 4, 115, 101, 108, 102, 19, 5, 118, 97, 108, 117, 101, 119, 0, 21, 4, 0, 42, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 108, 105, 115, 116, 101, 110, 45, 98, 97, 99, 107, 108, 111, 103, 45, 115, 105, 122, 101, 1, 38, 1, 106, 1, 127, 1, 11, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 39, 4, 0, 37, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 107, 101, 101, 112, 45, 97, 108, 105, 118, 101, 45, 101, 110, 97, 98, 108, 101, 100, 1, 40, 1, 64, 2, 4, 115, 101, 108, 102, 19, 5, 118, 97, 108, 117, 101, 127, 0, 21, 4, 0, 41, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 107, 101, 101, 112, 45, 97, 108, 105, 118, 101, 45, 101, 110, 97, 98, 108, 101, 100, 1, 41, 1, 106, 1, 7, 1, 11, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 42, 4, 0, 39, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 107, 101, 101, 112, 45, 97, 108, 105, 118, 101, 45, 105, 100, 108, 101, 45, 116, 105, 109, 101, 1, 43, 1, 64, 2, 4, 115, 101, 108, 102, 19, 5, 118, 97, 108, 117, 101, 7, 0, 21, 4, 0, 43, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 107, 101, 101, 112, 45, 97, 108, 105, 118, 101, 45, 105, 100, 108, 101, 45, 116, 105, 109, 101, 1, 44, 4, 0, 38, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 107, 101, 101, 112, 45, 97, 108, 105, 118, 101, 45, 105, 110, 116, 101, 114, 118, 97, 108, 1, 43, 4, 0, 42, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 107, 101, 101, 112, 45, 97, 108, 105, 118, 101, 45, 105, 110, 116, 101, 114, 118, 97, 108, 1, 44, 1, 106, 1, 121, 1, 11, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 45, 4, 0, 35, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 107, 101, 101, 112, 45, 97, 108, 105, 118, 101, 45, 99, 111, 117, 110, 116, 1, 46, 1, 64, 2, 4, 115, 101, 108, 102, 19, 5, 118, 97, 108, 117, 101, 121, 0, 21, 4, 0, 39, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 107, 101, 101, 112, 45, 97, 108, 105, 118, 101, 45, 99, 111, 117, 110, 116, 1, 47, 1, 106, 1, 125, 1, 11, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 48, 4, 0, 28, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 104, 111, 112, 45, 108, 105, 109, 105, 116, 1, 49, 1, 64, 2, 4, 115, 101, 108, 102, 19, 5, 118, 97, 108, 117, 101, 125, 0, 21, 4, 0, 32, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 104, 111, 112, 45, 108, 105, 109, 105, 116, 1, 50, 1, 106, 1, 119, 1, 11, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 51, 4, 0, 38, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 114, 101, 99, 101, 105, 118, 101, 45, 98, 117, 102, 102, 101, 114, 45, 115, 105, 122, 101, 1, 52, 4, 0, 42, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 114, 101, 99, 101, 105, 118, 101, 45, 98, 117, 102, 102, 101, 114, 45, 115, 105, 122, 101, 1, 38, 4, 0, 35, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 110, 100, 45, 98, 117, 102, 102, 101, 114, 45, 115, 105, 122, 101, 1, 52, 4, 0, 39, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 101, 116, 45, 115, 101, 110, 100, 45, 98, 117, 102, 102, 101, 114, 45, 115, 105, 122, 101, 1, 38, 1, 105, 5, 1, 64, 1, 4, 115, 101, 108, 102, 19, 0, 53, 4, 0, 28, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 117, 98, 115, 99, 114, 105, 98, 101, 1, 54, 1, 64, 2, 4, 115, 101, 108, 102, 19, 13, 115, 104, 117, 116, 100, 111, 119, 110, 45, 116, 121, 112, 101, 17, 0, 21, 4, 0, 27, 91, 109, 101, 116, 104, 111, 100, 93, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 46, 115, 104, 117, 116, 100, 111, 119, 110, 1, 55, 3, 1, 22, 119, 97, 115, 105, 58, 115, 111, 99, 107, 101, 116, 115, 47, 116, 99, 112, 64, 48, 46, 50, 46, 48, 5, 36, 2, 3, 0, 21, 10, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 1, 66, 12, 2, 3, 2, 1, 27, 4, 0, 7, 110, 101, 116, 119, 111, 114, 107, 3, 0, 0, 2, 3, 2, 1, 29, 4, 0, 10, 101, 114, 114, 111, 114, 45, 99, 111, 100, 101, 3, 0, 2, 2, 3, 2, 1, 31, 4, 0, 17, 105, 112, 45, 97, 100, 100, 114, 101, 115, 115, 45, 102, 97, 109, 105, 108, 121, 3, 0, 4, 2, 3, 2, 1, 37, 4, 0, 10, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 3, 0, 6, 1, 105, 7, 1, 106, 1, 8, 1, 3, 1, 64, 1, 14, 97, 100, 100, 114, 101, 115, 115, 45, 102, 97, 109, 105, 108, 121, 5, 0, 9, 4, 0, 17, 99, 114, 101, 97, 116, 101, 45, 116, 99, 112, 45, 115, 111, 99, 107, 101, 116, 1, 10, 3, 1, 36, 119, 97, 115, 105, 58, 115, 111, 99, 107, 101, 116, 115, 47, 116, 99, 112, 45, 99, 114, 101, 97, 116, 101, 45, 115, 111, 99, 107, 101, 116, 64, 48, 46, 50, 46, 48, 5, 38, 2, 3, 0, 17, 10, 105, 112, 45, 97, 100, 100, 114, 101, 115, 115, 1, 66, 22, 2, 3, 2, 1, 5, 4, 0, 8, 112, 111, 108, 108, 97, 98, 108, 101, 3, 0, 0, 2, 3, 2, 1, 27, 4, 0, 7, 110, 101, 116, 119, 111, 114, 107, 3, 0, 2, 2, 3, 2, 1, 29, 4, 0, 10, 101, 114, 114, 111, 114, 45, 99, 111, 100, 101, 3, 0, 4, 2, 3, 2, 1, 39, 4, 0, 10, 105, 112, 45, 97, 100, 100, 114, 101, 115, 115, 3, 0, 6, 4, 0, 22, 114, 101, 115, 111, 108, 118, 101, 45, 97, 100, 100, 114, 101, 115, 115, 45, 115, 116, 114, 101, 97, 109, 3, 1, 1, 104, 8, 1, 107, 7, 1, 106, 1, 10, 1, 5, 1, 64, 1, 4, 115, 101, 108, 102, 9, 0, 11, 4, 0, 51, 91, 109, 101, 116, 104, 111, 100, 93, 114, 101, 115, 111, 108, 118, 101, 45, 97, 100, 100, 114, 101, 115, 115, 45, 115, 116, 114, 101, 97, 109, 46, 114, 101, 115, 111, 108, 118, 101, 45, 110, 101, 120, 116, 45, 97, 100, 100, 114, 101, 115, 115, 1, 12, 1, 105, 1, 1, 64, 1, 4, 115, 101, 108, 102, 9, 0, 13, 4, 0, 40, 91, 109, 101, 116, 104, 111, 100, 93, 114, 101, 115, 111, 108, 118, 101, 45, 97, 100, 100, 114, 101, 115, 115, 45, 115, 116, 114, 101, 97, 109, 46, 115, 117, 98, 115, 99, 114, 105, 98, 101, 1, 14, 1, 104, 3, 1, 105, 8, 1, 106, 1, 16, 1, 5, 1, 64, 2, 7, 110, 101, 116, 119, 111, 114, 107, 15, 4, 110, 97, 109, 101, 115, 0, 17, 4, 0, 17, 114, 101, 115, 111, 108, 118, 101, 45, 97, 100, 100, 114, 101, 115, 115, 101, 115, 1, 18, 3, 1, 33, 119, 97, 115, 105, 58, 115, 111, 99, 107, 101, 116, 115, 47, 105, 112, 45, 110, 97, 109, 101, 45, 108, 111, 111, 107, 117, 112, 64, 48, 46, 50, 46, 48, 5, 40, 1, 66, 5, 1, 112, 125, 1, 64, 1, 3, 108, 101, 110, 119, 0, 0, 4, 0, 16, 103, 101, 116, 45, 114, 97, 110, 100, 111, 109, 45, 98, 121, 116, 101, 115, 1, 1, 1, 64, 0, 0, 119, 4, 0, 14, 103, 101, 116, 45, 114, 97, 110, 100, 111, 109, 45, 117, 54, 52, 1, 2, 3, 1, 24, 119, 97, 115, 105, 58, 114, 97, 110, 100, 111, 109, 47, 114, 97, 110, 100, 111, 109, 64, 48, 46, 50, 46, 48, 5, 41, 1, 66, 5, 1, 112, 125, 1, 64, 1, 3, 108, 101, 110, 119, 0, 0, 4, 0, 25, 103, 101, 116, 45, 105, 110, 115, 101, 99, 117, 114, 101, 45, 114, 97, 110, 100, 111, 109, 45, 98, 121, 116, 101, 115, 1, 1, 1, 64, 0, 0, 119, 4, 0, 23, 103, 101, 116, 45, 105, 110, 115, 101, 99, 117, 114, 101, 45, 114, 97, 110, 100, 111, 109, 45, 117, 54, 52, 1, 2, 3, 1, 26, 119, 97, 115, 105, 58, 114, 97, 110, 100, 111, 109, 47, 105, 110, 115, 101, 99, 117, 114, 101, 64, 48, 46, 50, 46, 48, 5, 42, 1, 66, 3, 1, 111, 2, 119, 119, 1, 64, 0, 0, 0, 4, 0, 13, 105, 110, 115, 101, 99, 117, 114, 101, 45, 115, 101, 101, 100, 1, 1, 3, 1, 31, 119, 97, 115, 105, 58, 114, 97, 110, 100, 111, 109, 47, 105, 110, 115, 101, 99, 117, 114, 101, 45, 115, 101, 101, 100, 64, 48, 46, 50, 46, 48, 5, 43, 1, 66, 8, 1, 112, 121, 4, 0, 17, 116, 101, 110, 115, 111, 114, 45, 100, 105, 109, 101, 110, 115, 105, 111, 110, 115, 3, 0, 0, 1, 109, 7, 4, 70, 80, 49, 54, 4, 70, 80, 51, 50, 4, 70, 80, 54, 52, 4, 66, 70, 49, 54, 2, 85, 56, 3, 73, 51, 50, 3, 73, 54, 52, 4, 0, 11, 116, 101, 110, 115, 111, 114, 45, 116, 121, 112, 101, 3, 0, 2, 1, 112, 125, 4, 0, 11, 116, 101, 110, 115, 111, 114, 45, 100, 97, 116, 97, 3, 0, 4, 1, 114, 3, 10, 100, 105, 109, 101, 110, 115, 105, 111, 110, 115, 1, 11, 116, 101, 110, 115, 111, 114, 45, 116, 121, 112, 101, 3, 4, 100, 97, 116, 97, 5, 4, 0, 6, 116, 101, 110, 115, 111, 114, 3, 0, 6, 3, 1, 14, 119, 97, 115, 105, 58, 110, 110, 47, 116, 101, 110, 115, 111, 114, 5, 44, 1, 66, 2, 1, 109, 7, 16, 105, 110, 118, 97, 108, 105, 100, 45, 97, 114, 103, 117, 109, 101, 110, 116, 16, 105, 110, 118, 97, 108, 105, 100, 45, 101, 110, 99, 111, 100, 105, 110, 103, 4, 98, 117, 115, 121, 13, 114, 117, 110, 116, 105, 109, 101, 45, 101, 114, 114, 111, 114, 21, 117, 110, 115, 117, 112, 112, 111, 114, 116, 101, 100, 45, 111, 112, 101, 114, 97, 116, 105, 111, 110, 9, 116, 111, 111, 45, 108, 97, 114, 103, 101, 9, 110, 111, 116, 45, 102, 111, 117, 110, 100, 4, 0, 5, 101, 114, 114, 111, 114, 3, 0, 0, 3, 1, 14, 119, 97, 115, 105, 58, 110, 110, 47, 101, 114, 114, 111, 114, 115, 5, 45, 2, 3, 0, 28, 5, 101, 114, 114, 111, 114, 2, 3, 0, 27, 6, 116, 101, 110, 115, 111, 114, 1, 66, 18, 2, 3, 2, 1, 46, 4, 0, 5, 101, 114, 114, 111, 114, 3, 0, 0, 2, 3, 2, 1, 47, 4, 0, 6, 116, 101, 110, 115, 111, 114, 3, 0, 2, 1, 121, 4, 0, 5, 103, 114, 97, 112, 104, 3, 0, 4, 1, 109, 6, 8, 111, 112, 101, 110, 118, 105, 110, 111, 4, 111, 110, 110, 120, 10, 116, 101, 110, 115, 111, 114, 102, 108, 111, 119, 7, 112, 121, 116, 111, 114, 99, 104, 14, 116, 101, 110, 115, 111, 114, 102, 108, 111, 119, 108, 105, 116, 101, 10, 97, 117, 116, 111, 100, 101, 116, 101, 99, 116, 4, 0, 14, 103, 114, 97, 112, 104, 45, 101, 110, 99, 111, 100, 105, 110, 103, 3, 0, 6, 1, 109, 3, 3, 99, 112, 117, 3, 103, 112, 117, 3, 116, 112, 117, 4, 0, 16, 101, 120, 101, 99, 117, 116, 105, 111, 110, 45, 116, 97, 114, 103, 101, 116, 3, 0, 8, 1, 112, 125, 4, 0, 13, 103, 114, 97, 112, 104, 45, 98, 117, 105, 108, 100, 101, 114, 3, 0, 10, 1, 112, 11, 1, 106, 1, 5, 1, 1, 1, 64, 3, 7, 98, 117, 105, 108, 100, 101, 114, 12, 8, 101, 110, 99, 111, 100, 105, 110, 103, 7, 6, 116, 97, 114, 103, 101, 116, 9, 0, 13, 4, 0, 4, 108, 111, 97, 100, 1, 14, 1, 64, 1, 4, 110, 97, 109, 101, 115, 0, 13, 4, 0, 12, 108, 111, 97, 100, 45, 98, 121, 45, 110, 97, 109, 101, 1, 15, 3, 1, 13, 119, 97, 115, 105, 58, 110, 110, 47, 103, 114, 97, 112, 104, 5, 48, 2, 3, 0, 27, 11, 116, 101, 110, 115, 111, 114, 45, 100, 97, 116, 97, 2, 3, 0, 29, 5, 103, 114, 97, 112, 104, 1, 66, 21, 2, 3, 2, 1, 46, 4, 0, 5, 101, 114, 114, 111, 114, 3, 0, 0, 2, 3, 2, 1, 47, 4, 0, 6, 116, 101, 110, 115, 111, 114, 3, 0, 2, 2, 3, 2, 1, 49, 4, 0, 11, 116, 101, 110, 115, 111, 114, 45, 100, 97, 116, 97, 3, 0, 4, 2, 3, 2, 1, 50, 4, 0, 5, 103, 114, 97, 112, 104, 3, 0, 6, 1, 121, 4, 0, 23, 103, 114, 97, 112, 104, 45, 101, 120, 101, 99, 117, 116, 105, 111, 110, 45, 99, 111, 110, 116, 101, 120, 116, 3, 0, 8, 1, 106, 1, 9, 1, 1, 1, 64, 1, 5, 103, 114, 97, 112, 104, 7, 0, 10, 4, 0, 22, 105, 110, 105, 116, 45, 101, 120, 101, 99, 117, 116, 105, 111, 110, 45, 99, 111, 110, 116, 101, 120, 116, 1, 11, 1, 106, 0, 1, 1, 1, 64, 3, 3, 99, 116, 120, 9, 5, 105, 110, 100, 101, 120, 121, 6, 116, 101, 110, 115, 111, 114, 3, 0, 12, 4, 0, 9, 115, 101, 116, 45, 105, 110, 112, 117, 116, 1, 13, 1, 64, 1, 3, 99, 116, 120, 9, 0, 12, 4, 0, 7, 99, 111, 109, 112, 117, 116, 101, 1, 14, 1, 106, 1, 5, 1, 1, 1, 64, 2, 3, 99, 116, 120, 9, 5, 105, 110, 100, 101, 120, 121, 0, 15, 4, 0, 10, 103, 101, 116, 45, 111, 117, 116, 112, 117, 116, 1, 16, 3, 1, 17, 119, 97, 115, 105, 58, 110, 110, 47, 105, 110, 102, 101, 114, 101, 110, 99, 101, 5, 51, 1, 66, 3, 1, 106, 0, 0, 1, 64, 0, 0, 0, 4, 0, 3, 114, 117, 110, 1, 1, 4, 1, 18, 119, 97, 115, 105, 58, 99, 108, 105, 47, 114, 117, 110, 64, 48, 46, 50, 46, 48, 5, 52, 4, 1, 32, 101, 120, 97, 109, 112, 108, 101, 58, 111, 110, 110, 120, 45, 99, 108, 97, 115, 115, 105, 102, 105, 101, 114, 47, 99, 108, 97, 115, 115, 105, 102, 121, 4, 0, 11, 14, 1, 0, 8, 99, 108, 97, 115, 115, 105, 102, 121, 3, 0, 0, 0, 16, 12, 112, 97, 99, 107, 97, 103, 101, 45, 100, 111, 99, 115, 0, 123, 125, 0, 70, 9, 112, 114, 111, 100, 117, 99, 101, 114, 115, 1, 12, 112, 114, 111, 99, 101, 115, 115, 101, 100, 45, 98, 121, 2, 13, 119, 105, 116, 45, 99, 111, 109, 112, 111, 110, 101, 110, 116, 6, 48, 46, 49, 56, 46, 50, 16, 119, 105, 116, 45, 98, 105, 110, 100, 103, 101, 110, 45, 114, 117, 115, 116, 6, 48, 46, 49, 54, 46, 48];
          
          #[inline(never)]
          #[doc(hidden)]
          #[cfg(target_arch = "wasm32")]
          pub fn __link_section() {}
          
