% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R, R/wkt.R
\name{st_as_text}
\alias{st_as_text}
\alias{st_as_text.crs}
\alias{st_as_text.sfg}
\alias{st_as_text.sfc}
\title{Return Well-known Text representation of simple feature geometry or coordinate reference system}
\usage{
\method{st_as_text}{crs}(x, ..., projjson = FALSE, pretty = FALSE)

st_as_text(x, ...)

\method{st_as_text}{sfg}(x, ...)

\method{st_as_text}{sfc}(x, ..., EWKT = FALSE)
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfc} or \code{crs}}

\item{...}{modifiers; in particular \code{digits} can be passed to control the number of digits used}

\item{projjson}{logical; if TRUE, return projjson form (requires GDAL 3.1 and PROJ 6.2), else return well-known-text form}

\item{pretty}{logical; if TRUE, print human-readable well-known-text representation of a coordinate reference system}

\item{EWKT}{logical; if TRUE, print SRID=xxx; before the WKT string if \code{epsg} is available}
}
\description{
Return Well-known Text representation of simple feature geometry or coordinate reference system
}
\details{
The returned WKT representation of simple feature geometry conforms to the
\href{https://www.ogc.org/standards/sfa}{simple features access} specification and extensions
(known as EWKT, supported by PostGIS and other simple features implementations for addition of 
a SRID to a WKT string).
}
\examples{
st_as_text(st_point(1:2))
st_as_text(st_sfc(st_point(c(-90,40)), crs = 4326), EWKT = TRUE)
}
