% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\encoding{UTF-8}
\name{print.draws_rvars}
\alias{print.draws_rvars}
\title{Print \code{draws_rvars} objects}
\usage{
\method{print}{draws_rvars}(
  x,
  digits = 2,
  max_variables = getOption("posterior.max_variables", 8),
  summary = getOption("posterior.rvar_summary", "mean_sd"),
  reserved = FALSE,
  ...
)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{digits}{(nonnegative integer) The minimum number of significant digits
to print. If \code{NULL}, defaults to \code{getOption("posterior.digits", 2)}.}

\item{max_variables}{(positive integer) The maximum number of variables to
print. Can be controlled globally via the \code{"posterior.max_variables"}
\link[base:options]{option}.}

\item{summary}{(string) The style of summary to display:
\itemize{
\item \code{"mean_sd"} displays \verb{mean ± sd}
\item \code{"median_mad"} displays \verb{median ± mad}
\item \code{"mode_entropy"} displays \verb{mode <entropy>}, and is used automatically for
\code{\link{rvar_factor}}s. It shows normalized entropy, which ranges from
0 (all probability in one category) to 1 (uniform). See \code{\link[=entropy]{entropy()}}.
\item \code{"mode_dissent"} displays \verb{mode <dissent>}, and is used automatically for
\code{\link{rvar_ordered}}s. It shows Tastle and Wierman's (2007) \emph{dissention}
measure, which ranges from 0 (all probability in one category) through
0.5 (uniform) to 1 (bimodal: all probability split equally between the
first and last category). See \code{\link[=dissent]{dissent()}}.
\item \code{NULL} uses \code{getOption("posterior.rvar_summary")} (default \verb{"mean_sd})
}}

\item{reserved}{(logical) Should reserved variables be included in the
output? Defaults to \code{FALSE}. See \code{\link{reserved_variables}} for an overview of
currently reserved variable names.}

\item{...}{Further arguments passed to the underlying \code{\link[=print]{print()}} methods.}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Pretty printing for \code{\link{draws_rvars}} objects.
}
\examples{
x <- as_draws_rvars(example_draws())
print(x)

}
